! f90 include file

!_______________________________________________________________________
!
   subroutine Implem_msDisplay_mfArray_double( x, string, unit )

      type(mfArray) :: x
      character(len=*), intent(in) :: string
      type(mfUnit), intent(in), optional :: unit
      !------ API end ------

#ifdef _DEVLP
      ! Here, only 'string' (and optionally 'unit') is printed.

      character(len=75) :: phys_dim_str, phys_unit_str, phys_dim_req_str
      integer :: status

   !------ end of declarations -- execution starts hereafter  ------

      call msInitArgs( x )

      write(STDOUT,"()")
      write(STDOUT,*) trim(string), " ="
      if( mf_phys_units ) then
         if( present(unit) ) then
            if( unit%abbrev == "S.I." ) then
               call process_units( x%units, phys_dim_str )
               ! special case where MUESLI must try to find
               ! the unit name
               call find_unit_name_from_units( x%units, phys_unit_str )
            else
               call process_units( x%units, phys_dim_str, unit, phys_unit_str )
               call verif_adim( x%units, unit%units, status )
               if( status /= 0 ) then
                  call process_units( unit%units, phys_dim_req_str )
                  call PrintMessage( "msDisplay", "E",                  &
                                     "required unit for printing not consistent", &
                                     "with the physical dimension of the mfArray!", &
                                     "Current physical dimension is : " // trim(phys_dim_str), &
                                     "Required unit for printing is : " // trim(phys_dim_req_str) )
                  go to 99
               end if
            end if
            write(STDOUT,*) trim(phys_dim_str), " ", trim(phys_unit_str)
         else
            call process_units( x%units, phys_dim_str )
            write(STDOUT,*) trim(phys_dim_str)
         end if
      end if
      write(STDOUT,"()")

      call print_mfArray_double_alone( x, unit )

 99   continue

      call msFreeArgs( x )
      call msAutoRelease( x )

#endif
   end subroutine Implem_msDisplay_mfArray_double
!_______________________________________________________________________
!
   subroutine print_mfArray_double_alone( x_arg, unit )

      type(mfArray) :: x_arg
      type(mfUnit), intent(in), optional :: unit
      !------ API end ------

#ifdef _DEVLP
      type(mfArray) :: x
      logical :: x_allocated

      character(len=10), parameter :: blank = ""
      integer :: nb_blanks

      ! The following constants must be exactly correspond to those used
      ! in the 'msDisplay_with_legend' routine.
      character(len=10), parameter :: fmt_int_small = "I4"
      integer, parameter       :: len_fmt_int_small = 4

      character(len=10), parameter :: fmt_int_large = "I10"
      integer, parameter       :: len_fmt_int_large = 10

      character(len=10), parameter :: fmt_short     = "F9.4"
      integer, parameter       :: len_fmt_short     = 9

      character(len=10), parameter :: fmt_sci_short = "ES12.4E3"
      integer, parameter       :: len_fmt_sci_short = 12

      character(len=10), parameter :: fmt_long      = "F18.14"
      integer, parameter       :: len_fmt_long      = 18

      character(len=10), parameter :: fmt_sci_long  = "ES22.14E3"
      integer, parameter       :: len_fmt_sci_long  = 22

      character(len=10), parameter :: fmt_hexa      = "Z16.16"
      integer, parameter       :: len_fmt_hexa      = 16

      character(len=10) :: fmt_int, fmt_used
      character(len=80) :: fmt
      character(len=12) :: string_ncol
      character(len=12) :: re_char_12
      character(len=22) :: re_char_22
      integer :: i, j, jdeb, jfin, ncol_max, ncol_shell, len_fmt
      real(kind=MF_DOUBLE) :: log10_x_max, max_val_abs, scale, power_threshold
      integer :: power_scale
      real(kind=MF_DOUBLE) :: re
      logical :: integer_fmt, integer_small, float_small

      real(kind=MF_DOUBLE), allocatable :: x_abs(:,:)
      logical, allocatable :: x_mask(:,:)
      integer :: m, n, x_count
      logical :: x_contains_special_IEEE_values, ellipsis_printed
      logical :: columns_vector, line_vector, mf_short_mantissa_save

   !------ end of declarations -- execution starts hereafter  ------

      call mf_save_and_disable_fpe( )

      ncol_shell = mfGetTermWidth()

      call msInitArgs( x_arg )

      ! warning, 'x_arg' is the argument name, but in the following
      ! we are working with 'x'
      x%data_type = x_arg%data_type
      x%shape = x_arg%shape
      x%units = x_arg%units
      x_allocated = .false.

      if( mf_phys_units ) then
         if( present(unit) ) then
            ! 'x' is modified only if the required physical unit
            ! is different from an SI unit.
            if( unit%value /= 1.0d0 ) then
               m = x%shape(1)
               n = x%shape(2)
               allocate( x%double(m,n) )

               x%double(:,:) = x_arg%double(:,:) / unit%value
               x_allocated = .true.
            end if
         end if
      end if

      if( .not. x_allocated ) then
         x%double => x_arg%double
      end if

      ! eventually, one of the two dimension can be zero (used, e. g.,
      ! when we concat a matrix iteratively by a column vector, or
      ! result of a mfFind inquiry), but not both.
      if( all( x%shape == [ 0, 0 ] ) ) then
         call PrintMessage( "msDisplay", "E",                           &
                            "all dims of the mfArray 'x' are zero!" )
         go to 99
      end if

      if( any( x%shape == [ 0, 0 ] ) ) then
         write(STDOUT,*) " <EMPTY>"
         write(STDOUT,"()")
         go to 99
      end if

      m = x%shape(1)
      n = x%shape(2)

      if( m == 1 ) then
         line_vector = .true.
      else
         line_vector = .false.
      end if
      columns_vector = .not. line_vector

      ! ┌───────────────────────────────────────────────────────┐
      ! │ determine if the mfArray contains special IEEE values │
      ! └───────────────────────────────────────────────────────┘

      allocate( x_abs(m,n) )
      allocate( x_mask(m,n) )
      x_contains_special_IEEE_values = .false.
      x_abs(:,:) = abs(x%double)
      x_mask(:,:) = mf_isfinite(x_abs)
      x_count = count( x_mask )
      if( x_count == 0 ) then
         ! All values are Inf and/or NaN
         max_val_abs = 0.0d0
         x_contains_special_IEEE_values = .true.
      else
         ! avoid special IEEE values (Inf, NaN)
         max_val_abs = maxval(x_abs,MASK=x_mask)
         if( x_count /= m*n ) then
            x_contains_special_IEEE_values = .true.
         end if
      end if
      deallocate( x_abs, x_mask )

      ! default values
      float_small = .true.
      integer_fmt = .false.

      ! hexadecimal format
      if( mf_display_hexa ) then
         ! Save old value because it is usually changed by the end-user only
         ! via the 'msFormat' Muesli routine)
         mf_short_mantissa_save = mf_short_mantissa
         mf_short_mantissa = .false. ! les 16 car nécessaires au format hexa
                                    ! vont déborder de 're_char_12'... avec
                                    ! 're_char_22', c'est ok
      else

         if( mf_display_exponent /= "sci" ) then ! "auto" or "eng"
            if( max_val_abs == 0.0d0 ) then
               log10_x_max = 0.0d0
            else
               log10_x_max = log10(max_val_abs)
            end if
            if( mf_short_mantissa ) then
               power_threshold = 3.0d0
            else
               power_threshold = 2.0d0
            end if
            if( abs(log10_x_max) >= power_threshold ) then
               float_small = .false.
            end if
            power_scale = int(log10_x_max)
            if( mf_display_exponent == "eng" ) then
               if( int(log10_x_max) < 0 ) then
                  power_scale = ((power_scale)/3)*3
               else
                  power_scale = ((power_scale+1)/3)*3
               end if
               if( power_scale /= 0 ) then
                  float_small = .false.
               else
                  float_small = .true.
               end if
            end if
         end if

         if( mf_display_exponent == "auto" .and.                        &
            .not. x_contains_special_IEEE_values ) then
            if( all( int(x%double) == x%double) ) then
               integer_fmt = .true.
               if( log10_x_max < 3.0d0 ) then
                  integer_small = .true.
               else
                  integer_small = .false.
               end if
               if( log10_x_max < 3.0d0 ) then
                  fmt_int = fmt_int_small
                  len_fmt = len_fmt_int_small
               else if( log10_x_max < 8.0d0 ) then
                  fmt_int = fmt_int_large
                  len_fmt = len_fmt_int_large
               else
                  integer_fmt = .false.
               end if
            end if
         end if

      end if

      if( integer_fmt ) then
         ! integer format
         ncol_max = ncol_shell / ( len_fmt + 2 )
         if( n <= ncol_max ) then
            write(string_ncol,"(i0)") n
            fmt = "(" // trim(string_ncol) // "(2x," // trim(fmt_int) // "))"
            if( mf_display_line_head_or_tail ) then
               ellipsis_printed = .false.
               nb_blanks = len_fmt + 2 - 3
               if( columns_vector ) then
                  do i = 1, m
                     if( i > mf_display_head_length .and.               &
                         m-i+1 > mf_display_tail_length ) then
                        if( .not. ellipsis_printed ) then
                           write(STDOUT,"(A,I0,A)") "  ... (",          &
                                 m - mf_display_head_length - mf_display_tail_length, &
                                 " lines skipped)"
                           ellipsis_printed = .true.
                        end if
                        cycle
                     end if
                     write(STDOUT,fmt) int(x%double(i,:))
                  end do
               else ! line_vector with m = 1
                  write(STDOUT,"(A,I0,A,/)") "  (",                     &
                        n - mf_display_head_length - mf_display_tail_length, &
                        " values skipped)"
                  fmt = "(2x," // trim(fmt_int) // ")"
                  do j = 1, n
                     if( j > mf_display_head_length .and.               &
                         n-j+1 > mf_display_tail_length ) then
                        if( .not. ellipsis_printed ) then
                           write(STDOUT,"(A)",advance='no')             &
                              blank(1:nb_blanks) // "..."
                           ellipsis_printed = .true.
                        end if
                        cycle
                     end if
                     write(STDOUT,fmt,advance='no') int(x%double(1,j))
                  end do
                  write(STDOUT,"()")
               end if
            else
               write(STDOUT,fmt) (int(x%double(i,:)),i=1,m)
            end if
         else ! n > ncol_max
            if( mf_display_line_head_or_tail .and. line_vector ) then
               write(STDOUT,"(A,I0,A,/)") "  (",                        &
                     n - mf_display_head_length - mf_display_tail_length, &
                     " values skipped)"
               ellipsis_printed = .false.
               nb_blanks = len_fmt + 2 - 3
               fmt = "(2x," // trim(fmt_int) // ")"
               if( mf_display_head_length+mf_display_tail_length+1 <= ncol_max ) then
                  do j = 1, n
                     if( j > mf_display_head_length .and.               &
                         n-j+1 > mf_display_tail_length ) then
                        if( .not. ellipsis_printed ) then
                           write(STDOUT,"(A)",advance='no')             &
                              blank(1:nb_blanks) // "..."
                           ellipsis_printed = .true.
                        end if
                        cycle
                     end if
                     write(STDOUT,fmt,advance='no') int(x%double(1,j))
                  end do
                  write(STDOUT,"()")
               else
                  write(STDOUT,"(A)") "  <extracted vector too long to be printed on one single line>"
               end if
            else
               jdeb = 1
               do
                  jfin = min( jdeb+ncol_max-1, n )
                  if( jfin > jdeb ) then
                     write(STDOUT,"(a,i0,a,i0,/)") " Columns ", jdeb, " through ", jfin
                  else
                     write(STDOUT,"(a,i0,/)") " Column ", jdeb
                  end if
                  write(string_ncol,"(i0)") jfin-jdeb+1
                  fmt = "(" // trim(string_ncol) // "(2x," // trim(fmt_int) // "))"
                  write(STDOUT,fmt) (int(x%double(i,jdeb:jfin)),i=1,m)
                  jdeb = jdeb + ncol_max
                  if( jdeb > n ) then
                     exit
                  end if
                  write(STDOUT,"()")
               end do
            end if
         end if
      else ! float format
         if( mf_display_exponent /= "sci" ) then ! "auto" or "eng"
            if( mf_short_mantissa ) then
               ! short mantissa
               fmt_used = fmt_short
               len_fmt = len_fmt_short
            else
               ! long mantissa
               fmt_used = fmt_long
               len_fmt = len_fmt_long
            end if
         else ! "sci"
            if( mf_short_mantissa ) then
               ! short mantissa
               fmt_used = fmt_sci_short
               len_fmt = len_fmt_sci_short
            else
               ! long mantissa
               fmt_used = fmt_sci_long
               len_fmt = len_fmt_sci_long
            end if
         end if
if( mf_display_hexa ) then
   fmt_used = fmt_hexa
   len_fmt = len_fmt_hexa
end if
         ncol_max = ncol_shell / ( len_fmt + 1 )
         if( float_small ) then ! small float
            if( n <= ncol_max ) then
               if( x_contains_special_IEEE_values ) then
                  fmt = "("//fmt_used//")"
                  if( mf_short_mantissa ) then
                     ellipsis_printed = .false.
                     if( columns_vector ) then
                        do i = 1, m
                           if( mf_display_line_head_or_tail ) then
                              if( i > mf_display_head_length .and.      &
                                  m-i+1 > mf_display_tail_length ) then
                                 if( .not. ellipsis_printed ) then
                                    write(STDOUT,"(A,I0,A)") "  ... (", &
                                          m - mf_display_head_length - mf_display_tail_length, &
                                          " lines skipped)"
                                    ellipsis_printed = .true.
                                 end if
                                 cycle
                              end if
                           end if
                           do j = 1, n
                              re = x%double(i,j)
                              re_char_12 = ""
                              if( mf_isnan(re) ) then ! NaN
                                 re_char_12(len_fmt-4:len_fmt-1) = " NaN"
                              else if( re == MF_INF ) then
                                 re_char_12(len_fmt-4:len_fmt-1) = " Inf"
                              else if( re == -MF_INF ) then
                                 re_char_12(len_fmt-4:len_fmt-1) = "-Inf"
                              else
                                 write(re_char_12,fmt) re
                              end if
                              write(*,"(A)",advance="no") " " // re_char_12(1:len_fmt)
                           end do
                           write(STDOUT,"()")
                        end do
                     else ! line_vector with m = 1
                        if( mf_display_line_head_or_tail ) then
                           write(STDOUT,"(A,I0,A,/)") "  (",            &
                                 n - mf_display_head_length - mf_display_tail_length, &
                                 " values skipped)"
                        end if
                        do j = 1, n
                           if( mf_display_line_head_or_tail ) then
                              if( j > mf_display_head_length .and.      &
                                  n-j+1 > mf_display_tail_length ) then
                                 if( .not. ellipsis_printed ) then
                                    write(STDOUT,"(A)",advance='no') "    ...   "
                                    ellipsis_printed = .true.
                                 end if
                                 cycle
                              end if
                           end if
                           re = x%double(1,j)
                           re_char_12 = ""
                           if( mf_isnan(re) ) then ! NaN
                              re_char_12(len_fmt-4:len_fmt-1) = " NaN"
                           else if( re == MF_INF ) then
                              re_char_12(len_fmt-4:len_fmt-1) = " Inf"
                           else if( re == -MF_INF ) then
                              re_char_12(len_fmt-4:len_fmt-1) = "-Inf"
                           else
                              write(re_char_12,fmt) re
                           end if
                           write(*,"(A)",advance="no") " " // re_char_12(1:len_fmt)
                        end do
                        write(STDOUT,"()")
                     end if
                  else ! long mantissa
                     ellipsis_printed = .false.
                     if( columns_vector ) then
                        do i = 1, m
                           if( mf_display_line_head_or_tail ) then
                              if( i > mf_display_head_length .and.      &
                                  m-i+1 > mf_display_tail_length ) then
                                 if( .not. ellipsis_printed ) then
                                    write(STDOUT,"(A,I0,A)") "  ... (", &
                                          m - mf_display_head_length - mf_display_tail_length, &
                                          " lines skipped)"
                                    ellipsis_printed = .true.
                                 end if
                                 cycle
                              end if
                           end if
                           do j = 1, n
                              re = x%double(i,j)
                              re_char_22 = ""
                              if( mf_isnan(re) ) then ! NaN
                                 re_char_22(len_fmt-4:len_fmt-1) = " NaN"
                              else if( re == MF_INF ) then
                                 re_char_22(len_fmt-4:len_fmt-1) = " Inf"
                              else if( re == -MF_INF ) then
                                 re_char_22(len_fmt-4:len_fmt-1) = "-Inf"
                              else
                                 write(re_char_22,fmt) re
                              end if
                              write(*,"(A)",advance="no") " " // re_char_22(1:len_fmt)
                           end do
                           write(STDOUT,"()")
                        end do
                     else ! line_vector with m = 1
                        if( mf_display_line_head_or_tail ) then
                           write(STDOUT,"(A,I0,A,/)") "  (",            &
                                 n - mf_display_head_length - mf_display_tail_length, &
                                 " values skipped)"
                        end if
                        do j = 1, n
                           if( mf_display_line_head_or_tail ) then
                              if( j > mf_display_head_length .and.      &
                                  n-j+1 > mf_display_tail_length ) then
                                 if( .not. ellipsis_printed ) then
                                    write(STDOUT,"(A)",advance='no') "         ...       "
                                    ellipsis_printed = .true.
                                 end if
                                 cycle
                              end if
                           end if
                           re = x%double(1,j)
                           re_char_22 = ""
                           if( mf_isnan(re) ) then ! NaN
                              re_char_22(len_fmt-4:len_fmt-1) = " NaN"
                           else if( re == MF_INF ) then
                              re_char_22(len_fmt-4:len_fmt-1) = " Inf"
                           else if( re == -MF_INF ) then
                              re_char_22(len_fmt-4:len_fmt-1) = "-Inf"
                           else
                              write(re_char_22,fmt) re
                           end if
                           write(*,"(A)",advance="no") " " // re_char_22(1:len_fmt)
                        end do
                        write(STDOUT,"()")
                     end if
                  end if
               else ! .not. x_contains_special_IEEE_values
                  write(string_ncol,"(i0)") n
                  fmt = "(" // trim(string_ncol) // "(1x," // trim(fmt_used) // "))"
                  if( mf_display_line_head_or_tail ) then
                     ellipsis_printed = .false.
                     if( columns_vector ) then
                        do i = 1, m
                           if( i > mf_display_head_length .and.         &
                               m-i+1 > mf_display_tail_length ) then
                              if( .not. ellipsis_printed ) then
                                 write(STDOUT,"(A,I0,A)") "  ... (",    &
                                       m - mf_display_head_length - mf_display_tail_length, &
                                       " lines skipped)"
                                 ellipsis_printed = .true.
                              end if
                              cycle
                           end if
                           write(STDOUT,fmt) x%double(i,:)
                        end do
                     else ! line_vector with m = 1
                        if( mf_display_line_head_or_tail ) then
                           write(STDOUT,"(A,I0,A,/)") "  (",            &
                                 n - mf_display_head_length - mf_display_tail_length, &
                                 " values skipped)"
                        end if
                        fmt = "(1x," // trim(fmt_used) // ")"
                        do j = 1, n
                           if( j > mf_display_head_length .and.         &
                               n-j+1 > mf_display_tail_length ) then
                              if( .not. ellipsis_printed ) then
                                 if( mf_short_mantissa ) then
                                    write(STDOUT,"(A)",advance='no') "    ...   "
                                 else
                                    write(STDOUT,"(A)",advance='no') "         ...       "
                                 end if
                                 ellipsis_printed = .true.
                              end if
                              cycle
                           end if
                           write(STDOUT,fmt,advance='no') x%double(1,j)
                        end do
                        write(STDOUT,"()")
                     end if
                  else
                     write(STDOUT,fmt) (x%double(i,:),i=1,m)
                  end if
               end if
            else ! n > ncol_max
               if( mf_display_line_head_or_tail .and. line_vector ) then
                  write(STDOUT,"(A,I0,A,/)") "  (",                     &
                        n - mf_display_head_length - mf_display_tail_length, &
                        " values skipped)"
                  ellipsis_printed = .false.
                  if( mf_display_head_length+mf_display_tail_length+1 <= ncol_max ) then
                     if( x_contains_special_IEEE_values ) then
                        fmt = "("//fmt_used//")"
                        if( mf_short_mantissa ) then
                           do j = 1, n
                              if( j > mf_display_head_length .and.      &
                                  n-j+1 > mf_display_tail_length ) then
                                 if( .not. ellipsis_printed ) then
                                    write(STDOUT,"(A)",advance='no') "    ...   "
                                    ellipsis_printed = .true.
                                 end if
                                 cycle
                              end if
                              re = x%double(1,j)
                              re_char_12 = ""
                              if( mf_isnan(re) ) then ! NaN
                                 re_char_12(len_fmt-4:len_fmt-1) = " NaN"
                              else if( re == MF_INF ) then
                                 re_char_12(len_fmt-4:len_fmt-1) = " Inf"
                              else if( re == -MF_INF ) then
                                 re_char_12(len_fmt-4:len_fmt-1) = "-Inf"
                              else
                                 write(re_char_12,fmt) re
                              end if
                              write(*,"(A)",advance="no") " " // re_char_12(1:len_fmt)
                           end do
                           write(STDOUT,"()")
                        else ! long mantissa
                           do j = 1, n
                              if( j > mf_display_head_length .and.      &
                                  n-j+1 > mf_display_tail_length ) then
                                 if( .not. ellipsis_printed ) then
                                    write(STDOUT,"(A)",advance='no') "         ...       "
                                    ellipsis_printed = .true.
                                 end if
                                 cycle
                              end if
                              re = x%double(1,j)
                              re_char_22 = ""
                              if( mf_isnan(re) ) then ! NaN
                                 re_char_22(len_fmt-4:len_fmt-1) = " NaN"
                              else if( re == MF_INF ) then
                                 re_char_22(len_fmt-4:len_fmt-1) = " Inf"
                              else if( re == -MF_INF ) then
                                 re_char_22(len_fmt-4:len_fmt-1) = "-Inf"
                              else
                                 write(re_char_22,fmt) re
                              end if
                              write(*,"(A)",advance="no") " " // re_char_22(1:len_fmt)
                           end do
                           write(STDOUT,"()")
                        end if
                     else ! .not. x_contains_special_IEEE_values
                        fmt = "(1x," // trim(fmt_used) // ")"
                        do j = 1, n
                           if( j > mf_display_head_length .and.         &
                               n-j+1 > mf_display_tail_length ) then
                              if( .not. ellipsis_printed ) then
                                 if( mf_short_mantissa ) then
                                    write(STDOUT,"(A)",advance='no') "    ...   "
                                 else
                                    write(STDOUT,"(A)",advance='no') "         ...       "
                                 end if
                                 ellipsis_printed = .true.
                              end if
                              cycle
                           end if
                           write(STDOUT,fmt,advance='no') x%double(1,j)
                        end do
                        write(STDOUT,"()")
                     end if
                  else
                     write(STDOUT,"(A)") "  <extracted vector too long to be printed on one single line>"
                  end if
               else
                  jdeb = 1
                  do
                     jfin = min( jdeb+ncol_max-1, n )
                     if( jfin > jdeb ) then
                        write(STDOUT,"(a,i0,a,i0,/)") " Columns ", jdeb, " through ", jfin
                     else
                        write(STDOUT,"(a,i0,/)") " Column ", jdeb
                     end if
                     if( x_contains_special_IEEE_values ) then
                        fmt = "("//fmt_used//")"
                        if( mf_short_mantissa ) then
                           do i = 1, m
                              do j = jdeb, jfin
                                 re = x%double(i,j)
                                 re_char_12 = ""
                                 if( mf_isnan(re) ) then ! NaN
                                    re_char_12(len_fmt-4:len_fmt-1) = " NaN"
                                 else if( re == MF_INF ) then
                                    re_char_12(len_fmt-4:len_fmt-1) = " Inf"
                                 else if( re == -MF_INF ) then
                                    re_char_12(len_fmt-4:len_fmt-1) = "-Inf"
                                 else
                                    write(re_char_12,fmt) re
                                 end if
                                 write(*,"(A)",advance="no") " " // re_char_12(1:len_fmt)
                              end do
                              write(STDOUT,"()")
                           end do
                        else
                           do i = 1, m
                              do j = jdeb, jfin
                                 re = x%double(i,j)
                                 re_char_22 = ""
                                 if( mf_isnan(re) ) then ! NaN
                                    re_char_22(len_fmt-4:len_fmt-1) = " NaN"
                                 else if( re == MF_INF ) then
                                    re_char_22(len_fmt-4:len_fmt-1) = " Inf"
                                 else if( re == -MF_INF ) then
                                    re_char_22(len_fmt-4:len_fmt-1) = "-Inf"
                                 else
                                    write(re_char_22,fmt) re
                                 end if
                                 write(*,"(A)",advance="no") " " // re_char_22(1:len_fmt)
                              end do
                              write(STDOUT,"()")
                           end do
                        end if
                     else ! .not. x_contains_special_IEEE_values
                        write(string_ncol,"(i0)") jfin-jdeb+1
                        fmt = "(" // trim(string_ncol) // "(1x," // trim(fmt_used) // "))"
                        write(STDOUT,fmt) (x%double(i,jdeb:jfin),i=1,m)
                     end if
                     jdeb = jdeb + ncol_max
                     if( jdeb > n ) then
                        exit
                     end if
                     write(STDOUT,"()")
                  end do
               end if
            end if
         else ! large float ("auto" or "eng" format)
            scale = 10.0d0**power_scale
            if( m==1 .and. n==1 ) then
               if( mf_short_mantissa ) then
                  if( mf_display_exponent == "eng" ) then
                     write(STDOUT,"(2X,EN14.4E3)") x%double(1,1)
                  else
                     write(STDOUT,"(2X,ES12.4E3)") x%double(1,1)
                  end if
               else
                  if( mf_display_exponent == "eng" ) then
                     write(STDOUT,"(2X,EN24.14E3)") x%double(1,1)
                  else
                     write(STDOUT,"(2X,ES22.14E3)") x%double(1,1)
                  end if
               end if
               go to 99
            else
               write(STDOUT,"(2X,ES9.1E3,A,/)") scale, " *"
            end if
            if( n <= ncol_max ) then
               fmt = "("//fmt_used//")"
               if( x_contains_special_IEEE_values ) then
                  if( mf_short_mantissa ) then
                     ellipsis_printed = .false.
                     if( columns_vector ) then
                        do i = 1, m
                           if( mf_display_line_head_or_tail ) then
                              if( i > mf_display_head_length .and.         &
                                  m-i+1 > mf_display_tail_length ) then
                                 if( .not. ellipsis_printed ) then
                                    write(STDOUT,"(A,I0,A)") "  ... (",    &
                                                      m - mf_display_head_length - mf_display_tail_length, &
                                                      " lines skipped)"
                                    ellipsis_printed = .true.
                                 end if
                                 cycle
                              end if
                           end if
                           do j = 1, n
                              re = x%double(i,j)
                              re_char_12 = ""
                              if( mf_isnan(re) ) then ! NaN
                                 re_char_12(len_fmt-4:len_fmt-1) = " NaN"
                              else if( re == MF_INF ) then
                                 re_char_12(len_fmt-4:len_fmt-1) = " Inf"
                              else if( re == -MF_INF ) then
                                 re_char_12(len_fmt-4:len_fmt-1) = "-Inf"
                              else
                                 write(re_char_12,fmt) re/scale
                              end if
                              write(*,"(A)",advance="no") " " // re_char_12(1:len_fmt)
                           end do
                           write(STDOUT,"()")
                        end do
                     else ! line_vector with m = 1
                        if( mf_display_line_head_or_tail ) then
                           write(STDOUT,"(A,I0,A,/)") "  (",            &
                                 n - mf_display_head_length - mf_display_tail_length, &
                                 " values skipped)"
                        end if
                        do j = 1, n
                           if( mf_display_line_head_or_tail ) then
                              if( j > mf_display_head_length .and.      &
                                  n-j+1 > mf_display_tail_length ) then
                                 if( .not. ellipsis_printed ) then
                                    write(STDOUT,"(A)",advance='no') "    ...   "
                                    ellipsis_printed = .true.
                                 end if
                                 cycle
                              end if
                           end if
                           re = x%double(1,j)
                           re_char_12 = ""
                           if( mf_isnan(re) ) then ! NaN
                              re_char_12(len_fmt-4:len_fmt-1) = " NaN"
                           else if( re == MF_INF ) then
                              re_char_12(len_fmt-4:len_fmt-1) = " Inf"
                           else if( re == -MF_INF ) then
                              re_char_12(len_fmt-4:len_fmt-1) = "-Inf"
                           else
                              write(re_char_12,fmt) re/scale
                           end if
                           write(*,"(A)",advance="no") " " // re_char_12(1:len_fmt)
                        end do
                        write(STDOUT,"()")
                     end if
                  else ! long mantissa
                     ellipsis_printed = .false.
                     if( columns_vector ) then
                        do i = 1, m
                           if( mf_display_line_head_or_tail ) then
                              if( i > mf_display_head_length .and.         &
                                  m-i+1 > mf_display_tail_length ) then
                                 if( .not. ellipsis_printed ) then
                                    write(STDOUT,"(A,I0,A)") "  ... (",    &
                                                      m - mf_display_head_length - mf_display_tail_length, &
                                                      " lines skipped)"
                                    ellipsis_printed = .true.
                                 end if
                                 cycle
                              end if
                           end if
                           do j = 1, n
                              re = x%double(i,j)
                              re_char_22 = ""
                              if( mf_isnan(re) ) then ! NaN
                                 re_char_22(len_fmt-4:len_fmt-1) = " NaN"
                              else if( re == MF_INF ) then
                                 re_char_22(len_fmt-4:len_fmt-1) = " Inf"
                              else if( re == -MF_INF ) then
                                 re_char_22(len_fmt-4:len_fmt-1) = "-Inf"
                              else
                                 write(re_char_22,fmt) re/scale
                              end if
                              write(*,"(A)",advance="no") " " // re_char_22(1:len_fmt)
                           end do
                           write(STDOUT,"()")
                        end do
                     else ! line_vector with m = 1
                        if( mf_display_line_head_or_tail ) then
                           write(STDOUT,"(A,I0,A,/)") "  (",            &
                                 n - mf_display_head_length - mf_display_tail_length, &
                                 " values skipped)"
                        end if
                        do j = 1, n
                           if( mf_display_line_head_or_tail ) then
                              if( j > mf_display_head_length .and.      &
                                  n-j+1 > mf_display_tail_length ) then
                                 if( .not. ellipsis_printed ) then
                                    write(STDOUT,"(A)",advance='no') "         ...       "
                                    ellipsis_printed = .true.
                                 end if
                                 cycle
                              end if
                           end if
                           re = x%double(1,j)
                           re_char_22 = ""
                           if( mf_isnan(re) ) then ! NaN
                              re_char_22(len_fmt-4:len_fmt-1) = " NaN"
                           else if( re == MF_INF ) then
                              re_char_22(len_fmt-4:len_fmt-1) = " Inf"
                           else if( re == -MF_INF ) then
                              re_char_22(len_fmt-4:len_fmt-1) = "-Inf"
                           else
                              write(re_char_22,fmt) re/scale
                           end if
                           write(*,"(A)",advance="no") " " // re_char_22(1:len_fmt)
                        end do
                        write(STDOUT,"()")
                     end if
                  end if
               else ! .not. x_contains_special_IEEE_values
                  write(string_ncol,"(i0)") n
                  fmt = "(" // trim(string_ncol) // "(1x," // trim(fmt_used) // "))"
                  if( mf_display_line_head_or_tail ) then
                     ellipsis_printed = .false.
                     if( columns_vector ) then
                        do i = 1, m
                           if( i > mf_display_head_length .and.         &
                               m-i+1 > mf_display_tail_length ) then
                              if( .not. ellipsis_printed ) then
                                 write(STDOUT,"(A,I0,A)") "  ... (",    &
                                                   m - mf_display_head_length - mf_display_tail_length, &
                                                   " lines skipped)"
                                 ellipsis_printed = .true.
                              end if
                              cycle
                           end if
                           write(STDOUT,fmt) x%double(i,:)/scale
                        end do
                     else ! line_vector with m = 1
                        if( mf_display_line_head_or_tail ) then
                           write(STDOUT,"(A,I0,A,/)") "  (",            &
                                 n - mf_display_head_length - mf_display_tail_length, &
                                 " values skipped)"
                        end if
                        fmt = "(1x," // trim(fmt_used) // ")"
                        do j = 1, n
                           if( j > mf_display_head_length .and.         &
                               n-j+1 > mf_display_tail_length ) then
                              if( .not. ellipsis_printed ) then
                                 if( mf_short_mantissa ) then
                                    write(STDOUT,"(A)",advance='no') "    ...   "
                                 else
                                    write(STDOUT,"(A)",advance='no') "         ...       "
                                 end if
                                 ellipsis_printed = .true.
                              end if
                              cycle
                           end if
                           write(STDOUT,fmt,advance='no') x%double(1,j)/scale
                        end do
                        write(STDOUT,"()")
                     end if
                  else
                     write(STDOUT,fmt) (x%double(i,:)/scale,i=1,m)
                  end if
               end if
            else ! n > ncol_max
               if( mf_display_line_head_or_tail .and. line_vector ) then
                  write(STDOUT,"(A,I0,A,/)") "  (",                     &
                        n - mf_display_head_length - mf_display_tail_length, &
                        " values skipped)"
                  ellipsis_printed = .false.
                  if( mf_display_head_length+mf_display_tail_length+1 <= ncol_max ) then
                     if( x_contains_special_IEEE_values ) then
                        fmt = "("//fmt_used//")"
                        if( mf_short_mantissa ) then
                           do j = 1, n
                              if( j > mf_display_head_length .and.      &
                                  n-j+1 > mf_display_tail_length ) then
                                 if( .not. ellipsis_printed ) then
                                    write(STDOUT,"(A)",advance='no') "    ...   "
                                    ellipsis_printed = .true.
                                 end if
                                 cycle
                              end if
                              re = x%double(1,j)
                              re_char_12 = ""
                              if( mf_isnan(re) ) then ! NaN
                                 re_char_12(len_fmt-4:len_fmt-1) = " NaN"
                              else if( re == MF_INF ) then
                                 re_char_12(len_fmt-4:len_fmt-1) = " Inf"
                              else if( re == -MF_INF ) then
                                 re_char_12(len_fmt-4:len_fmt-1) = "-Inf"
                              else
                                 write(re_char_12,fmt) re/scale
                              end if
                              write(*,"(A)",advance="no") " " // re_char_12(1:len_fmt)
                           end do
                           write(STDOUT,"()")
                        else ! long mantissa
                           do j = 1, n
                              if( j > mf_display_head_length .and.      &
                                  n-j+1 > mf_display_tail_length ) then
                                 if( .not. ellipsis_printed ) then
                                    write(STDOUT,"(A)",advance='no') "         ...       "
                                    ellipsis_printed = .true.
                                 end if
                                 cycle
                              end if
                              re = x%double(1,j)
                              re_char_22 = ""
                              if( mf_isnan(re) ) then ! NaN
                                 re_char_22(len_fmt-4:len_fmt-1) = " NaN"
                              else if( re == MF_INF ) then
                                 re_char_22(len_fmt-4:len_fmt-1) = " Inf"
                              else if( re == -MF_INF ) then
                                 re_char_22(len_fmt-4:len_fmt-1) = "-Inf"
                              else
                                 write(re_char_22,fmt) re/scale
                              end if
                              write(*,"(A)",advance="no") " " // re_char_22(1:len_fmt)
                           end do
                           write(STDOUT,"()")
                        end if
                     else ! .not. x_contains_special_IEEE_values
                        fmt = "(1x," // trim(fmt_used) // ")"
                        do j = 1, n
                           if( j > mf_display_head_length .and.         &
                               n-j+1 > mf_display_tail_length ) then
                              if( .not. ellipsis_printed ) then
                                 if( mf_short_mantissa ) then
                                    write(STDOUT,"(A)",advance='no') "    ...   "
                                 else
                                    write(STDOUT,"(A)",advance='no') "         ...       "
                                 end if
                                 ellipsis_printed = .true.
                              end if
                              cycle
                           end if
                           write(STDOUT,fmt,advance='no') x%double(1,j)/scale
                        end do
                        write(STDOUT,"()")
                     end if
                  else
                     write(STDOUT,"(A)") "  <extracted vector too long to be printed on one single line>"
                  end if
               else
                  jdeb = 1
                  do
                     jfin = min( jdeb+ncol_max-1, n )
                     if( jfin > jdeb ) then
                        write(STDOUT,"(a,i0,a,i0,/)") " Columns ", jdeb, " through ", jfin
                     else
                        write(STDOUT,"(a,i0,/)") " Column ", jdeb
                     end if
                     if( x_contains_special_IEEE_values ) then
                        fmt = "("//fmt_used//")"
                        if( mf_short_mantissa ) then
                           do i = 1, m
                              do j = jdeb, jfin
                                 re = x%double(i,j)
                                 re_char_12 = ""
                                 if( mf_isnan(re) ) then ! NaN
                                    re_char_12(len_fmt-4:len_fmt-1) = " NaN"
                                 else if( re == MF_INF ) then
                                    re_char_12(len_fmt-4:len_fmt-1) = " Inf"
                                 else if( re == -MF_INF ) then
                                    re_char_12(len_fmt-4:len_fmt-1) = "-Inf"
                                 else
                                    write(re_char_12,fmt) re/scale
                                 end if
                                 write(*,"(A)",advance="no") " " // re_char_12(1:len_fmt)
                              end do
                              write(STDOUT,"()")
                           end do
                        else ! long mantissa
                           do i = 1, m
                              do j = jdeb, jfin
                                 re = x%double(i,j)
                                 re_char_22 = ""
                                 if( mf_isnan(re) ) then ! NaN
                                    re_char_22(len_fmt-4:len_fmt-1) = " NaN"
                                 else if( re == MF_INF ) then
                                    re_char_22(len_fmt-4:len_fmt-1) = " Inf"
                                 else if( re == -MF_INF ) then
                                    re_char_22(len_fmt-4:len_fmt-1) = "-Inf"
                                 else
                                    write(re_char_22,fmt) re/scale
                                 end if
                                 write(*,"(A)",advance="no") " " // re_char_22(1:len_fmt)
                              end do
                              write(STDOUT,"()")
                           end do
                        end if
                     else ! .not. x_contains_special_IEEE_values
                        write(string_ncol,"(i0)") jfin-jdeb+1
                        fmt = "(" // trim(string_ncol) // "(1x," // trim(fmt_used) // "))"
                        write(STDOUT,fmt) (x%double(i,jdeb:jfin)/scale,i=1,m)
                     end if
                     jdeb = jdeb + ncol_max
                     if( jdeb > n ) then
                        exit
                     end if
                     write(STDOUT,"()")
                  end do
               end if
            end if
         end if
      end if

if( mf_display_hexa ) then
   mf_short_mantissa = mf_short_mantissa_save
end if

 99   continue

      write(STDOUT,"()")

      if( x_allocated ) then
         deallocate( x%double )

      end if

      call msFreeArgs( x_arg )
      call msAutoRelease( x_arg )

      call mf_restore_fpe( )

#endif
   end subroutine print_mfArray_double_alone
