! f90 include file

!_______________________________________________________________________
!
   subroutine Implem_msDisplay_mfArray_bool( x, string )

      type(mfArray) :: x
      character(len=*), intent(in) :: string
      !------ API end ------

#ifdef _DEVLP
      character(len=10) :: fmt_int = "L4"
      integer           :: len_fmt = 4
      character(len=80) :: fmt
      character(len=12) :: string_ncol
      integer :: i, jdeb, jfin, ncol_max, ncol_shell

      integer :: m, n
      logical :: ellipsis_printed

   !------ end of declarations -- execution starts hereafter  ------

      ncol_shell = mfGetTermWidth()

      call msInitArgs( x )

      write(STDOUT,"()")
      write(STDOUT,*) trim(string), " ="
      write(STDOUT,"()")

      ! eventually, one of the two dimensions can be zero (used, e. g.,
      ! when we concat a matrix iteratively by a column vector, or
      ! result of a mfFind inquiry), but not both.
      if( all( x%shape == [ 0, 0 ] ) ) then
         call PrintMessage( "msDisplay", "W",                           &
                            "all dims of the mfArray 'x' are zero!" )
         go to 99
      end if

      if( any( x%shape == [ 0, 0 ] ) ) then
         write(STDOUT,*)  " <EMPTY>"
         write(STDOUT,"()")
         go to 99
      end if

      m = x%shape(1)
      n = x%shape(2)

      ncol_max = ncol_shell / ( len_fmt + 2 )
      if( n <= ncol_max ) then
         write(string_ncol,"(i0)") n
         fmt = "(" // trim(string_ncol) // "(2x," // trim(fmt_int) // "))"
         if( mf_display_line_head_or_tail ) then
            ellipsis_printed = .false.
            do i = 1, m
               if( i > mf_display_head_length .and.                     &
                   m-i+1 > mf_display_tail_length ) then
                  if( .not. ellipsis_printed ) then
                     write(STDOUT,"(A,I0,A)") "  ... (",                &
                                       m - mf_display_head_length - mf_display_tail_length, &
                                       " lines skipped)"
                     ellipsis_printed = .true.
                  end if
                  cycle
               end if
               write(STDOUT,fmt) x%double(i,:)==1.0d0
            end do
         else
            write(STDOUT,fmt) (x%double(i,:)==1.0d0,i=1,m)
         end if
      else
         jdeb = 1
         do
            jfin = min( jdeb+ncol_max-1, n )
            if( jfin > jdeb ) then
               write(STDOUT,"(a,i0,a,i0,/)") " Columns ", jdeb, " through ", jfin
            else
               write(STDOUT,"(a,i0,/)") " Column ", jdeb
            end if
            write(string_ncol,"(i0)") jfin-jdeb+1
            fmt = "(" // trim(string_ncol) // "(2x," // trim(fmt_int) // "))"
            write(STDOUT,fmt) (x%double(i,jdeb:jfin)==1.0d0,i=1,m)
            jdeb = jdeb + ncol_max
            if( jdeb > n ) then
               exit
            end if
            write(STDOUT,"()")
         end do
      end if

 99   continue

      write(STDOUT,"()")

      call msFreeArgs( x )
      call msAutoRelease( x )

#endif
   end subroutine Implem_msDisplay_mfArray_bool
