module mod_grplot

   use mod_mfArray, only: PrintMessage

   use mod_mfdebug, only: muesli_trace, mf_message_displayed

   implicit none

   !--------------------------------------------------------------------
   !
   !                           GRPCKG module
   ! Modifications:
   !    ...
   ! 31-Jan-2006 - Increase GRIMAX to 16.
   ! 17-Dec-2006 - Switch GRWIDT type from INTEGER to REAL.
   ! 28-Apr-2007 - Increase GRFNMX from 90 to 256 (because INTEL-ifort
   !               works with absolute filename).
   ! 13-Nov-2007 - Added new variable 'GR_PRINTING_EPS' in new common
   !               'GR_MF_00' in order to communicate with psdriv.f.
   ! 26-Jun-2010 - Increase GRIMAX to 32.
   !  3-Nov-2015 - Increase GRIMAX to 48.
   !  2-Apr-2020 - Added an array for the marker-size property (grmsiz).
   ! 16-Apr-2020 - Panels removed.
   !--------------------------------------------------------------------
   !
   ! Parameters:

   ! Driver num.
   integer, parameter :: MF_DEV_TYPE_NUMBER = 4
   integer, parameter :: X11_DRIVER_NUM  = 1,                           &
                         EPS_DRIVER_NUM  = 2,                           &
                         PDF_DRIVER_NUM  = 3,                           &
                         NULL_DRIVER_NUM = 4

   ! Opcode num.
   integer, parameter :: GET_DEV_NAME                =  1,              &
                         GET_COL_IND_RANGE           =  2,              &
                         GET_DEV_RESOL               =  3,              &
                         GET_MISC_INFO               =  4,              &
                         GET_DEF_FILENAME            =  5,              &
                         GET_DEF_SIZE                =  6,              &
                         GET_CHAR_SIZE               =  7,              &
                         SELECT_PLOT                 =  8,              &
                         OPEN_DEV                    =  9,              &
                         CLOSE_DEV                   = 10,              &
                         BEGIN_PICT                  = 11,              &
                         DRAW_LINE_SEGM              = 12,              &
                         DRAW_POLYLINE               = 13,              &
                         END_PICT                    = 14,              &
                         SELECT_COL_IND              = 15,              &
                         FLUSH_BUF                   = 16,              &
                         READ_CURSOR                 = 17,              &
                         SET_X11_WIN_ID              = 18,              &
                         SET_LINE_STYLE              = 19,              &
                         POLYGON_FILL                = 20,              &
                         SET_COL_REPRES              = 21,              &
                         SET_LINE_WIDTH              = 22,              &
                         ESCAPE                      = 23,              &
                         RECT_FILL                   = 24,              &
                         SET_LINE_CAP_JOIN_STYLE     = 25
   integer, parameter :: PUT_LINE_PIX_CI             = 26,              &
                         GET_LINE_PIX_RGB            = 27,              &
                         PUT_LINE_PIX_RGB            = 28,              &
                         GET_COL_REPRES              = 29,              &
                         DRAW_BEZIER_SEGM            = 30,              &
                         SET_ANG_CLIP_XFT            = 31,              &
                         SET_FONT_XFT                = 32,              &
                         DRAW_CHAR_STRING            = 33,              &
                         SET_MUESLI_PATH             = 34,              &
                         GET_DEF_SIZE_VIRT           = 35,              &
                         GET_XFT_STRING_BBOX         = 36,              &
                         WRITE_COLORMAP_IF           = 37,              &
                         DRAW_MARKER                 = 38,              &
                         PDF_RECORD_OCG              = 39,              &
                         UPDATE_TRANSP_TABLE         = 40,              &
                         BITMAP_IMAGE                = 41,              &
                         ADD_COMMENT_EPS_PDF         = 42,              &
                         PDF_BDC_TAG                 = 43,              &
                         PDF_EMC_TAG                 = 44,              &
                         UPDATE_BBOX                 = 45,              &
                         RECT_DRAW                   = 49,              &
                         GET_CURSOR_POS              = 50
   integer, parameter :: GET_CLICK_IN_WIN            = 51,              &
                         RAISE_WIN                   = 53,              &
                         WIN_RESIZE                  = 56,              &
                         SELECT_BACK_FOREGROUND      = 57,              &
                         GET_COL_DEPTH               = 58,              &
                         SET_EXE_NAME                = 59,              &
                         GET_COLOR_CORR              = 60,              &
                         FINISH_READ_CURSOR          = 61,              &
                         SET_CURSOR_SHAPE            = 62,              &
                         READ_CURSOR_DYN             = 63,              &
                         GET_WIN_SIZE_PIX            = 64,              &
                         READ_CURSOR_DYN_EXCL_BOX    = 65,              &
                         READ_CURSOR_DYN_MULTISPOT   = 66,              &
                         READ_CURSOR_DYN_QUADR_POLYG = 67,              &
                         GET_DASH_PERIOD             = 70,              &
                         CLEAN_FONTCONFIG            = 72,              &
                         SELECT_AUX_PIXMAP           = 80,              &
                         MOVE_GROBJ_PIXMAP           = 82,              &
                         REDUCE_2ND_AUX_PIXMAP       = 83,              &
                         SET_CLIPPING                = 84,              &
                         SET_1_PIX_CORR              = 85,              &
                         SCROLL_IN_PIXMAP            = 88
   integer, parameter :: GET_INFO_EMPTY_EPS          = 100,             &
                         PREP_ARROW_MOVE             = 102,             &
                         MOVE_ARROW                  = 103,             &
                         X11_FLUSH_POLICY            = 105,             &
                         FORCE_FLUSH_BUFFER          = 106,             &
                         FORCE_UPDATE_FROM_PIXMAP    = 107,             &
                         SET_INPUT_FOCUS             = 110,             &
                         SET_VIEWPORT                = 120,             &
                         UPDATE_MAIN_PIXMAP          = 132,             &
                         GET_LABEL_AREA_AROUND       = 135,             &
                         ERASE_LABEL_AREA_AROUND     = 140,             &
                         GET_CLIPPING                = 150,             &
                         SAVE_PIXMAP_ID              = 160,             &
                         COPY_PIXMAP_FROM_ID         = 161,             &
                         REM_FIG_NUM_IN_WIN_TITLE    = 162,             &
                         GET_CURRENT_WIN_GEOM        = 163,             &
                         READ_CURSOR_WITHOUT_WAITING = 164,             &
                         DEF_CUSTOM_CURSOR_SHAPE     = 165,             &
                         GET_MODIFIED_CURS_POS       = 166


   !   GRIMAX : maximum number of concurrent devices
   !            (should be the same as MAXDEV in 'nudriv.f90')
   !   GRFNMX : maximum length of file names

   integer, parameter :: grimax = 64, grfnmx = 256

   !   GRCIDE : identifier of current plot
   !   GRGTYP : device type of current plot
   !
   ! The following are qualified by a plot id:
   !   GRSTAT : 0 => workstation closed
   !            1 => workstation open
   !            2 => picture open
   !   GRPLTD :
   !   GRUNIT : unit associated with id
   !   GRFNLN : length of filename
   !   GRTYPE : device type

   !   GRXMXA : x size of plotting surface    \   full view surface
   !   GRYMXA : y size of plotting surface    /
   !   GRXMIN : blc of plotting window (x)    \
   !   GRYMIN :  "        "       "    (y)     |  plotting area
   !   GRXMAX : trc of plotting window (x)     |
   !   GRYMAX :  "        "       "    (y)    /

   !   GRWIDT : line width (real code)
   !   GRSTYL : line style (integer code)
   !   GRDPAT : pseudo dash pattern code, which depends on the two above

   !   GRCCOL : current color index (integer code)
   !   GRMNCI : minimum color index on this device
   !   GRMXCI : maximum color index on this device
   !   GRCMRK : current marker number
   !   GRMSIZ : current marker size
   !   GRXPRE : previous (current) pen position (x)
   !   GRYPRE :    "         "      "     "     (y)

   !   GRXORG : transformation variables (GRTRAN)    \
   !   GRYORG :       "            "                  |  scaling
   !   GRXSCL :       "            "                  |
   !   GRYSCL :       "            "                 /

   !   GRCFAC : character scaling factor

   !   GRFILE : file name (character)
   !   GRGCAP : device capabilities (character)
   !   GRPXPI : pixels per inch in x
   !   GRPYPI : pixels per inch in y

   integer, save :: grcide, grgtyp
   logical, save :: grpltd(grimax)
   integer, save :: grstat(grimax)
   integer, save :: grunit(grimax), grfnln(grimax), grtype(grimax),     &
                    grxmxa(grimax), grymxa(grimax),                     &
                    grstyl(grimax), grccol(grimax),                     &
                    grcmrk(grimax),                                     &
                    grmnci(grimax), grmxci(grimax)

   double precision, save :: grxmin(grimax), grymin(grimax),            &
                             grxmax(grimax), grymax(grimax),            &
                             grwidt(grimax), grdpat(grimax),            &
                             grmsiz(grimax)
   double precision, save :: grxpre(grimax), grypre(grimax),            &
                             grxorg(grimax), gryorg(grimax),            &
                             grxscl(grimax), gryscl(grimax),            &
                             grcfac(grimax),                            &
                             grpxpi(grimax), grpypi(grimax)

   character(len=grfnmx), save :: grfile(grimax)
   character(len=10), save :: grgcap(grimax)

   !--------------------------------------------------------------------
   ! added by É. Canot

   ! GR_SUBSCRIPT_SCALING : scaling factor for sub- and super-script
   !                        (recursive factor -- old was 0.75)
   double precision, parameter :: gr_subscript_scaling = 0.667d0

   ! TRUE: in legend, FALSE: not legend
   logical, save :: gr_text_in_legend = .false.

   ! TRUE: numerical labelling uses "minus sign" in math mode
   logical, save :: gr_minus_sign_math_mode = .false.

   ! for EPS driver, and 'grparse_ps_font'
   logical, save :: EPS_driver_font_begin

   ! for PDF driver, and 'grparse_pdf_font'
   logical, save :: PDF_driver_font_begin

   ! avoid grenv multiple times for getting the MUESLI install path
   character(len=256), save :: MFPLOT_DIR = ""

   integer, parameter :: NB_MAX_FONTS = 8
   ! presence of some standard PostScript fonts + EnglishBT-reg
   logical, save :: PS_Std_Fonts_presence(NB_MAX_FONTS)
   logical, save :: EnglishBT_embedded

   ! metrics for the 8 PS Type 1 fonts used for EPS printing
   ! (read in 'gr_read_AFM_files' routine, used in 'ps_font_char_width')
   integer, save :: font_metrics(NB_MAX_FONTS,22:255)
   double precision, save :: font_heights(NB_MAX_FONTS,2)

   ! For EPS, each change of color set the following variable to TRUE,
   ! but any call to 'grestore' in PostScript must cancel this.
   ! (used in GRSCI)
   !WARNING: the following parameters are global to all devices.
   ! Therefore, they have to be reset to FALSE at each change of device!
   logical, save :: LAST_COLOR_IS_VALID       = .false.,                &
                    LAST_LINEWIDTH_IS_VALID   = .false.,                &
                    LAST_LINESTYLE_IS_VALID   = .false.,                &
                    LAST_FONT_ATTRIB_IS_VALID = .false.,                &
                    LAST_MARKERSIZE_IS_VALID  = .false.

   ! For PDF: 1 for Stroke, 2 for Fill, 3 for both (Arrow or Font)
   ! (set only during redraw of the plot, when it is for PDF)
   integer, save :: gr_pdf_color_intent = 0

   logical, save :: MF_AFM_READ = .false. ! .true. if AFM files (EPS print)
                                          ! have been read successfully

   logical, save :: PRINTING_EPS = .false.
   logical, save :: PRINTING_PDF = .false.

   logical, save :: COMMENTS_IN_EPS = .false.
   logical, save :: COMMENTS_IN_PDF = .false.

   ! The following variable must be always synchronized with the static
   ! variable CLIPPING in the X11 driver!
   logical, save :: CLIPPING_IN_AXES = .false.

   integer, save :: MFPLOT_DEBUG = 0

   double precision, private, parameter :: pi = 3.141592653589793d0

   ! pi/180 ~ 0.01745...
   double precision, parameter :: deg_to_rad = pi/180.0d0

   ! 180/pi ~ 57.29...
   double precision, parameter :: rad_to_deg = 180.0d0/pi

   ! some predefined colors
   integer, parameter :: MFPLOT_LIGHT_GREY  = 12,                       &
                         MFPLOT_DARK_GREY   = 10,                       &
                         MFPLOT_QUASI_WHITE = 14,                       &
                         MFPLOT_QUASI_BLACK = 8

   ! default: white background.
   integer :: MFPLOT_QUASI_BACKGROUND = MFPLOT_QUASI_WHITE

   ! specific saved values for moving viewport via 'Pan' and 'PanAndZoom'
   double precision, save :: GRXORG_save, GRYORG_save,                  &
                             grxmin_save, grxmax_save,                  &
                             grymin_save, grymax_save

   ! The X11 ID of the terminal (may be zero)
   integer, save :: MF_TERMINAL_X11_ID

   ! To manage the change of focus. Usually, all interactive routines are
   ! able to change the focus temporarily, except during animation.
   logical, save :: FOCUS_CHANGE_DISABLE = .false.

   ! The theoretical limit of 32767 for SHORT_MAX concerns the whole range.
   ! We must divide it by 2 because X11 works with signed values. (most of
   ! Xlib implementation works with a virtual screen of 16384x16384;
   ! cf 'xrandr -q')
   integer, parameter :: MFPLOT_SHORT_MAX = 16384

contains
!_______________________________________________________________________
!
   ! from 'src/gr'
#include "src/gr/grarea.f90"
#include "src/gr/grbpic.f90"
#include "src/gr/grclos.f90"
#include "src/gr/grcurs.f90"
#include "src/gr/gr_dev_to_wld.f90"
#include "src/gr/grdtyp.f90"
#include "src/gr/grepic.f90"
#include "src/gr/gresc.f90"
#include "src/gr/grexec.F90"
#include "src/gr/grfa.f90"
#include "src/gr/grimg0.f90"
#include "src/gr/grimg1.f90"
#include "src/gr/grimg2.f90"
#include "src/gr/grinit.f90"
#include "src/gr/gritoc.f90"
#include "src/gr/grlin0.f90"
#include "src/gr/grlin2.f90"
#include "src/gr/grlin3.f90"
#include "src/gr/grlina.f90"
#include "src/gr/grlinr.f90"
#include "src/gr/grmker.f90"
#include "src/gr/grmova.f90"
#include "src/gr/grmovr.f90"
#include "src/gr/grmsg.f90"
#include "src/gr/gropen.f90"
#include "src/gr/grpage.f90"
#include "src/gr/grpars.f90"
#include "src/gr/grpocl.f90"
#include "src/gr/grqcap.f90"
#include "src/gr/grqci.f90"
#include "src/gr/grqcol.f90"
#include "src/gr/grqcr.f90"
#include "src/gr/grqdev.f90"
#include "src/gr/grqdt.f90"
#include "src/gr/grqls.f90"
#include "src/gr/grqlw.f90"
#include "src/gr/grqpos.f90"
#include "src/gr/grqtyp.f90"
#include "src/gr/grrec0.f90"
#include "src/gr/grrect.f90"
#include "src/gr/grsci.f90"
#include "src/gr/grscr.f90"
#include "src/gr/grsize.f90"
#include "src/gr/grslct.f90"
#include "src/gr/grsls.f90"
#include "src/gr/grslw.f90"
#include "src/gr/grsms.f90"
#include "src/gr/grterm.f90"
#include "src/gr/grtoup.f90"
#include "src/gr/gr_wld_to_dev.f90"
#include "src/gr/grvct0.f90"
#include "src/gr/grwarn.f90"
#include "src/gr/grxhls.f90"
#include "src/gr/grxrgb.f90"
!_______________________________________________________________________
!
   ! from 'src/sys'
#include "src/sys/grflun.f90"
#include "src/sys/grgenv.f90"
#include "src/sys/grglun.f90"
!_______________________________________________________________________
!
   ! from 'src/zoom'
#include "src/zoom/grclick_ec.f90"
#include "src/zoom/grcurs_ec.f90"
#include "src/zoom/grnormcurs_ec.f90"
!_______________________________________________________________________
!
   ! from 'src/pgaux'
#include "src/pgaux/change_viewport.f90"
#include "src/pgaux/embed_EnglishBT_PFA.f90"
#include "src/pgaux/grclos_ec.f90"
#include "src/pgaux/grcurs_dyn.f90"
#include "src/pgaux/gropen_ec.f90"
#include "src/pgaux/grpocl_ec.f90"
#include "src/pgaux/gr_read_AFM_files.f90"
#include "src/pgaux/gr_set_cursor_shape.f90"
#include "src/pgaux/ps_font_char_width.f90"
#include "src/pgaux/raise_mfplot_win.f90"
#include "src/pgaux/restore_viewport.f90"
#include "src/pgaux/set_focus_mfplot_win.f90"
#include "src/pgaux/set_muesli_install_dir.F90"
#include "src/pgaux/set_mfplot_background_color.f90"
!_______________________________________________________________________
!
   function restrict_to_short( x ) result( i )

      double precision, intent(in) :: x
      integer :: i
      !------ API end ------

      ! This routine is called by the following ones:
      ! 'grmker', 'grrec0', 'grtext_xft'

   !------ end of declarations -- execution starts hereafter  ------

      if( MFPLOT_SHORT_MAX < x ) then
         i = MFPLOT_SHORT_MAX
      else if( x < -MFPLOT_SHORT_MAX ) then
         i = -MFPLOT_SHORT_MAX
      else
         i = nint( x )
      end if

   end function restrict_to_short
!_______________________________________________________________________
!
   subroutine restrict_to_short_3( xA, yA, xB, yB, iA, jA, iB, jB,      &
                                   status )

      double precision, intent(in) :: xA, yA, xB, yB
      integer, intent(out) :: iA, jA, iB, jB
      integer, intent(out) :: status
      !------ API end ------

      ! Complete clipping at the big rectangle of max admissible integers
      ! X11 coordinates. This is absolutely necessary to
      ! avoid a strange behavior of oblique line when zooming.
      !
      ! This routine returns status=0 if it succeeded in computing the
      ! intersection, else status=1 means a fail.

      ! See the PDF document 'Clipping at max. int.pdf'

      ! This routine is called by the following ones:
      ! 'grfa', 'grlin2'

      logical :: A_inside, B_inside

   !------ end of declarations -- execution starts hereafter  ------

      ! Determine how points A and B locate w.r.t. the big rectangle.
      A_inside = -MFPLOT_SHORT_MAX <= xA .and. xA <= MFPLOT_SHORT_MAX .and. &
                 -MFPLOT_SHORT_MAX <= yA .and. yA <= MFPLOT_SHORT_MAX
      B_inside = -MFPLOT_SHORT_MAX <= xB .and. xB <= MFPLOT_SHORT_MAX .and. &
                 -MFPLOT_SHORT_MAX <= yB .and. yB <= MFPLOT_SHORT_MAX

      if( A_inside ) then
         iA = nint( xA )
         jA = nint( yA )
         if( B_inside ) then
            iB = nint( xB )
            jB = nint( yB )
         else ! B outside
            ! Here, find B' the intersection of AB with the big rectangle
            call intersect( xA, yA, xB, yB, iB, jB )
         end if
      else ! A outside
         if( B_inside ) then
            iB = nint( xB )
            jB = nint( yB )
            ! Here, find A' the intersection of AB with the big rectangle
            call intersect( xB, yB, xA, yA, iA, jA )
         else ! B outside
            ! This case shouldn't occur (due to quick return implementation),
            ! except for the interior of a colored polygon, for example!
            print *, char(27) // "[38;5;202m" ! to switch to orange printing
            print *, "(Muesli FGL:) ERROR: X11 limitation of max admissible integers for pixel values!"
            print *, "              The plot of an element is skipped."
            print *
            print *, "              This is certainly due to a strong interactive zooming process..."
            print *, "              -> Try to unzoom to cure the problem."
            print *, char(27) // "[0m" ! to revert to normal printing
            status = 1 ! failure
         end if
      end if

      status = 0

   contains

      subroutine intersect( xA, yA, xB, yB, iB, jB )

         double precision, intent(in) :: xA, yA, xB, yB
         integer, intent(out) :: iB, jB
         !------ API end ------

         ! Here, point A is inside the frame, and point B is outside.
         ! We compute the integer coordinates of the intersection between
         ! the segment AB and the frame boundary.

         integer :: zone
         double precision :: hx, hy, hxp, hyp, SMx, SMy

      !------ end of declarations -- execution starts hereafter  ------

         hx = xB - xA
         hy = yB - yA

         ! Determine the appropriate quadrant.
         if( xB > xA ) then
            SMx = MFPLOT_SHORT_MAX - xA
            if( yB > yA ) then
               SMy = MFPLOT_SHORT_MAX - yA
               if( hy/hx <= SMy/SMx ) then
                  zone = 1
               else
                  zone = 2
               end if
            else if( yB == yA ) then
               iB = MFPLOT_SHORT_MAX
               jB = nint( yB )
               return
            else ! yB < yA
               SMy = -MFPLOT_SHORT_MAX - yA
               if( hy/hx >= SMy/SMx ) then
                  zone = 1
               else
                  zone = 4
               end if
            end if
         else if( xB == xA ) then
            iB = nint( xB )
            if( yB > yA ) then
               jB = MFPLOT_SHORT_MAX
            else ! yB < yA
               jB = -MFPLOT_SHORT_MAX
            end if
            return
         else ! xB < xA
            SMx = -MFPLOT_SHORT_MAX - xA
            if( yB > yA ) then
               SMy = MFPLOT_SHORT_MAX - yA
               if( (yB-yA)/(xB-xA) >= SMy/SMx ) then
                  zone = 3
               else
                  zone = 2
               end if
            else if( yB == yA ) then
               iB = -MFPLOT_SHORT_MAX
               jB = nint( yB )
               return
            else ! yB < yA
               SMy = -MFPLOT_SHORT_MAX - yA
               if( (yB-yA)/(xB-xA) <= SMy/SMx ) then
                  zone = 3
               else
                  zone = 4
               end if
            end if
         end if

         select case( zone )
            case( 1 )
               iB = MFPLOT_SHORT_MAX
               hyp = hy * SMx/hx
               jB = nint( yA + hyp )
            case( 2 )
               hxp = hx * SMy/hy
               iB = nint( xA + hxp )
               jB = MFPLOT_SHORT_MAX
            case( 3 )
               iB = -MFPLOT_SHORT_MAX
               hyp = hy * SMx/hx
               jB = nint( yA + hyp )
            case( 4 )
               hxp = hx * SMy/hy
               iB = nint( xA + hxp )
               jB = -MFPLOT_SHORT_MAX
         end select

      end subroutine intersect

   end subroutine restrict_to_short_3
!_______________________________________________________________________
!
   function restrict_to_long( x ) result( i )

      double precision, intent(in) :: x
      integer :: i
      !------ API end ------

      integer, parameter :: LONG_MAX = 1e6 ! < huge(1)

   !------ end of declarations -- execution starts hereafter  ------

      if( LONG_MAX < x ) then
         i = LONG_MAX
      else if( x < -LONG_MAX ) then
         i = -LONG_MAX
      else
         i = nint( x )
      end if

   end function restrict_to_long
!_______________________________________________________________________
!
   logical function MF_check_CLIPPING_synchro()

      !------ API end ------

      ! This debugging routine can be used at any moment to check that
      ! CLIPPING_IN_AXES (in GRPCKG) and CLIPPING (static variable in X11
      ! driver) has the same value.

      logical :: CLIPPING_X11

      double precision :: rbuf(1)
      integer :: ibuf(1), lchr
      character(len=1) :: chr

   !------ end of declarations -- execution starts hereafter  ------

      call grexec( grgtyp, GET_CLIPPING, rbuf, ibuf, chr, lchr )
      CLIPPING_X11 = ibuf(1) == 1

      MF_check_CLIPPING_synchro = CLIPPING_IN_AXES .eqv. CLIPPING_X11

   end function MF_check_CLIPPING_synchro
!_______________________________________________________________________
!
end module mod_grplot
