subroutine call_mf_pgsch_from_x11_driver( )

   use mod_pgplot

   implicit none

   double precision :: pgxblc_init, pgxtrc_init,                        &
                       pgyblc_init, pgytrc_init
   common /call_routines_from_x11_driver/ pgxblc_init, pgxtrc_init,     &
                                          pgyblc_init, pgytrc_init

   !------ end of declarations -- execution starts hereafter  ------

   ! Set the character height,
   call pgsch( pg_axe_fnt_siz_fct(pgid) * pg_char_height_factor(pgid) )

   ! Update world coord. range
   pgxblc_init = pgxblc(pgid)
   pgxtrc_init = pgxtrc(pgid)
   pgyblc_init = pgyblc(pgid)
   pgytrc_init = pgytrc(pgid)

   call grslw( pg_axis_lin_width(pgid) )

end subroutine call_mf_pgsch_from_x11_driver
!_______________________________________________________________________
!
subroutine call_mf_pgtbox_from_x11_driver( dx_pix, dy_pix, axis_on )

   use mod_pgplot

   implicit none

   integer, intent(in) :: dx_pix, dy_pix
   integer, intent(in) :: axis_on ! = boolean 1=TRUE, 0=FALSE
   !------ API end ------

   double precision :: rbuf(1)
   integer :: ibuf(2), lchr
   character(len=1) :: chr

   double precision :: shift_x, shift_y

   double precision :: pgxblc_init, pgxtrc_init,                        &
                       pgyblc_init, pgytrc_init
   common /call_routines_from_x11_driver/ pgxblc_init, pgxtrc_init,     &
                                          pgyblc_init, pgytrc_init

   !------ end of declarations -- execution starts hereafter  ------

   ! Shift obtained must be converted into world coordinates
   shift_x = dx_pix/grxscl(pgid)
   shift_y = dy_pix/gryscl(pgid)


   if( axis_on == 1 ) then
      ! Erase the labelling area around the viewport
      if( index(XOPT_SAVE,'Z') /= 0 ) then
         ibuf(1) = 1
      else
         ibuf(1) = 0
      end if
      if( index(YOPT_SAVE,'Z') /= 0 ) then
         ibuf(2) = 1
      else
         ibuf(2) = 0
      end if
      call grexec( grgtyp, ERASE_LABEL_AREA_AROUND, rbuf, ibuf, chr, lchr )
   end if

   ! Update world coord. range
   pgxblc(pgid) = pgxblc_init - shift_x
   pgxtrc(pgid) = pgxtrc_init - shift_x
   pgyblc(pgid) = pgyblc_init + shift_y
   pgytrc(pgid) = pgytrc_init + shift_y

   ! Back to the original values (dev. coords)
   GRXORG(grcide) = GRXORG_save + dx_pix
   GRYORG(grcide) = GRYORG_save - dy_pix

   if( axis_on == 1 ) then
      ! Redraw the ticks and numerical labelling, from the X11 driver!
      call pgtbox( XOPT_SAVE, MF_SMART_XTICK(pgid), MF_SMART_NXSUB(pgid), &
                   YOPT_SAVE, MF_SMART_YTICK(pgid), MF_SMART_NYSUB(pgid) )
   else ! axis off
      ! Redraw top and left sides of the box only, using the background color
      ! (else, as a side effect, a line may be left by a grobj...)
      call grsci(0)
      ibuf(1) = 0 ! unset clipping (used only in X11 driver)
      call grexec( grgtyp, SET_CLIPPING, rbuf, ibuf, chr, lchr )
      call grlin2( grxmin_save, grymin_save, grxmin_save, grymax_save )
      call grlin2( grxmin_save, grymax_save, grxmax_save, grymax_save )

   end if

end subroutine call_mf_pgtbox_from_x11_driver
