# Makefile : common part

# for not_smart f90 compilers, not aware of compilation-cascade problem
# (special for INTEL-ifort);
# we use a way to avoid the timestamps update of precompiled module
# files.

# new organisation: each *.o depends now only on *.mod files
#                   use of recursive-make
#
# Copyright É. Canot 2003-2025 -- CNRS

#-----------------------------------------------------------------------
#--------------------------------- FML ---------------------------------
#-----------------------------------------------------------------------

FML_OBJS = obj/mod_mfdebug.o \
           obj/mod_mem_debug.o \
           obj/mod_mfaux.o \
           obj/iso_varying_string.o \
           obj/rational_numbers.o \
           obj/mod_prop.o \
           obj/mod_mfarray.o \
           obj/mod_physunits.o \
           obj/mod_ieee.o \
           obj/mod_core.o \
           obj/mod_sparse.o \
           obj/mod_elmat.o \
           obj/mod_fileio.o \
           obj/mod_mf_gsl.o \
           obj/mod_elfun.o \
           obj/mod_specfun.o \
           obj/mod_ops.o \
           \
           obj/gft_common.o \
           obj/gft_jmfft.o \
           obj/gft_set.o \
           obj/gft_do.o \
           obj/gft_end.o \
           obj/gft.o \
           \
           obj/mod_datafun.o \
           obj/mod_matfun.o \
           \
           obj/minpack.o \
           \
           obj/convexhull_mod.o \
           \
           obj/splines.o \
           obj/bezier.o \
           \
           obj/mod_polyfun.o \
           obj/mod_funfun.o \
           \
           obj/mod_ddebd2.o \
           obj/mod_slatec_aux.o \
           obj/mod_slatec_fun.o \
           obj/mod_slatec_solve.o \
           \
           obj/umf4_f90wrapper.o \
           obj/cholmod_f90wrapper.o \
           obj/spqr_f90wrapper.o \
           \
           obj/voronoi_f90wrapper.o \
           \
           obj/RngStream.o \
           obj/RngStream_f90wrapper.o \
           \
           obj/triangle.o \
           obj/triangle_delaunay.o \
           obj/predicates.o \
           obj/tetgen.o \
           obj/tetgen_f90wrapper.o \
           \
           obj/get_term_col.o

FML_OBJS += obj/set_rounding_mode.o \
            obj/fp_exceptions.o \
            \
            obj/readline_c.o

ifeq '$(X86_64)' '"yes"'
  FML_OBJS += obj/crc32_adler.o
else
  FML_OBJS += obj/icrc32.o \
              obj/crc32.o
endif

FML_OBJS += obj/f90_gzlib.o \
            obj/zlib_f90.o

obj/mod_mem_debug.o : inc_dev/mod_mfdebug.mod

obj/mod_mfaux.o : fml_core/min_max_nan.inc \
                  fml_core/quick_sort.inc \
                  fml_core/quick_sortrows.inc \
                  fml_core/tri.inc \
                  fml_core/tetra.inc \
                  fml_core/seq_def.inc \
                  inc_dev/mod_mfdebug.mod \
                  inc_dev/mod_mem_debug.mod \
                  inc_dev/convexhull_mod.mod

obj/rational_numbers.o : misc/rational_numbers/rational_config.inc

obj/mod_prop.o : inc_dev/mod_mfdebug.mod

obj/mod_mfarray.o : fml_core/parameters.inc \
                    fml_core/realloc.inc \
                    inc_dev/mod_mfdebug.mod \
                    inc_dev/mod_mem_debug.mod \
                    inc_dev/mod_mfaux.mod \
                    inc_dev/mod_prop.mod \
                    inc_dev/rational_numbers.mod

obj/mod_physunits.o : fml_physunits/find_unit_name.inc \
                      inc_dev/mod_mfdebug.mod \
                      inc_dev/rational_numbers.mod \
                      inc_dev/mod_mfarray.mod

obj/mod_ieee.o : inc_dev/mod_mfdebug.mod

obj/mod_core.o : fml_core/mf_Out.inc \
                 fml_core/Array.inc \
                 fml_core/Assign.inc \
                 fml_core/Display.inc \
                 fml_core/DisplayColumns.inc \
                 fml_core/Display_bool.inc \
                 fml_core/Display_unit.inc \
                 fml_core/Display_mf_int_list.inc \
                 fml_core/Display_mf_int_list_vec.inc \
                 fml_core/Display_mf_real_list.inc \
                 fml_core/Display_mf_real_list_vec.inc \
                 fml_core/Display_double.inc \
                 fml_core/Display_complex.inc \
                 fml_core/Display_sparse_bool.inc \
                 fml_core/Display_sparse_double.inc \
                 fml_core/Display_sparse_complex.inc \
                 fml_core/Display_with_legend.inc \
                 fml_core/Get.inc \
                 fml_core/Set.inc \
                 fml_core/seq_def_EndIndex.inc \
                 fml_core/Hashes.inc \
                 fml_sparse/util/getelm.inc \
                 fml_sparse/util/submat.inc \
                 fml_sparse/util/setelm.inc \
                 fml_sparse/util/xtrcol.inc \
                 fml_sparse/util/nnzxtrcols.inc \
                 fml_sparse/util/xtrcols.inc \
                 fml_sparse/util/xtrrow.inc \
                 fml_sparse/util/sort.inc \
                 fml_sparse/util/chgcol.inc \
                 papi/fpapi.inc \
                 inc_dev/mod_mfdebug.mod \
                 inc_dev/mod_mfaux.mod \
                 inc_dev/mod_prop.mod \
                 inc_dev/mod_mfarray.mod \
                 inc_dev/mod_physunits.mod \
                 inc_dev/mod_ieee.mod \
                 misc/suitesparse/umf4_f90wrapper.inc

obj/mod_sparse.o : fml_sparse/Sparse.inc \
                   fml_sparse/Import.inc \
                   fml_sparse/Export.inc \
                   fml_sparse/SpEye.inc \
                   fml_sparse/SpOnes.inc \
                   fml_sparse/SpDiags.inc \
                   fml_sparse/util/amib.inc \
                   fml_sparse/util/amib1.inc \
                   fml_sparse/util/amux.inc \
                   fml_sparse/util/aplb.inc \
                   fml_sparse/util/aplb1.inc \
                   fml_sparse/util/aplib.inc \
                   fml_sparse/util/aplib1.inc \
                   fml_sparse/util/apply_bin_ops_to_sp_dble.inc \
                   fml_sparse/util/nnzaplb.inc \
                   fml_sparse/util/coo2csc.inc \
                   fml_sparse/util/coo2csc_struct_only.inc \
                   fml_sparse/util/dns2csc.inc \
                   fml_sparse/util/normcols.inc \
                   fml_sparse/util/prtmt.inc \
                   fml_sparse/util/readmt.inc \
                   fml_sparse/util/sqbanded2csc.inc \
                   fml_sparse/util/transp.inc \
                   fml_sparse/util/xmua.inc \
                   fml_sparse/util/spcut.inc \
                   fml_sparse/util/trilsol.inc \
                   fml_sparse/util/triusol.inc \
                   fml_sparse/util/sp_del_0_and_compact.inc \
                   inc_dev/mod_mfarray.mod \
                   inc_dev/mod_core.mod \
                   misc/suitesparse/spqr_f90wrapper.inc

obj/f90_gzlib.o : inc_dev/mod_mfdebug.mod \
                  inc_dev/rational_numbers.mod

obj/mod_mf_gsl.o : inc_dev/mod_ieee.mod

obj/mod_elfun.o : inc_dev/mod_slatec_fun.mod \
                  inc_dev/mod_sparse.mod \
                  inc_dev/mod_mf_gsl.mod

obj/mod_ops.o : fml_ops/Add.inc \
                fml_ops/Colon.inc \
                fml_ops/CTranspose.inc \
                fml_ops/Div.inc \
                fml_ops/Greater.inc \
                fml_ops/GreaterStrict.inc \
                fml_ops/Less.inc \
                fml_ops/LessStrict.inc \
                fml_ops/Mul.inc \
                fml_ops/Pow.inc \
                fml_ops/Sub.inc \
                fml_ops/Transpose.inc \
                fml_ops/matmul.inc \
                fml_sparse/util/nnzamub.inc \
                fml_sparse/util/amub.inc \
                fml_sparse/util/col_auto_scale.inc \
                fml_sparse/util/row_auto_scale.inc \
                inc_dev/mod_physunits.mod \
                inc_dev/mod_core.mod \
                inc_dev/mod_sparse.mod \
                inc_dev/mod_elfun.mod

obj/mod_elmat.o : fml_ops/horiz_concat.inc \
                  fml_ops/vert_concat.inc \
                  fml_sparse/util/colconcat.inc \
                  fml_sparse/util/colconcat_ip.inc \
                  fml_sparse/util/rowconcat.inc \
                  fml_sparse/util/getdia.inc \
                  fml_sparse/util/getl.inc \
                  fml_sparse/util/getu.inc \
                  fml_sparse/util/reshape.inc \
                  misc/RngStreams/RngStream_f90wrapper.inc \
                  inc_dev/mod_mfaux.mod \
                  inc_dev/mod_core.mod \
                  inc_dev/mod_sparse.mod \
                  inc_dev/mod_ops.mod

obj/mod_fileio.o : misc/rational_numbers/rational_config.inc \
                   fml_fileio/msSaveAscii.inc \
                   fml_fileio/mfLoadAscii.inc \
                   fml_fileio/msSave_mfArray.inc \
                   fml_fileio/msSave_mfTriConnect.inc \
                   fml_fileio/mfLoadTriConnect.inc \
                   fml_fileio/mfLoad.inc \
                   fml_fileio/msSaveHDF5.inc \
                   fml_fileio/mfLoadHDF5.inc \
                   fml_fileio/swap_bytes.inc \
                   fml_fileio/msSaveSparse.inc \
                   fml_fileio/mfLoadSparse.inc \
                   fml_fileio/msLoadSparse.inc \
                   fml_polyfun/mfTriConnect.inc \
                   inc_dev/rational_numbers.mod \
                   inc_dev/mod_mfaux.mod \
                   inc_dev/mod_core.mod \
                   inc_dev/mod_sparse.mod \
                   inc_dev/mod_ops.mod \
                   inc_dev/mod_elmat.mod \
                   inc_dev/f90_gzlib.mod \
                   inc_dev/iso_varying_string.mod

obj/gft_common.o : misc/GFT/gft_common.f90

obj/gft_jmfft.o : misc/GFT/gft_jmfft.f90 \
                  obj/gft_common.o

obj/gft_set.o : misc/GFT/gft_set.f90 \
                obj/gft_jmfft.o

obj/gft_do.o : misc/GFT/gft_do.f90 \
               obj/gft_jmfft.o

obj/gft_end.o : misc/GFT/gft_end.f90 \
                obj/gft_common.o

obj/gft.o : misc/GFT/gft.f90 \
            obj/gft_jmfft.o \
            obj/gft_set.o \
            obj/gft_do.o \
            obj/gft_end.o

obj/minpack.o : misc/minpack/minpack.F90 \
                misc/minpack/chkder.inc \
                misc/minpack/dogleg.inc \
                misc/minpack/dogleg_sp.inc \
                misc/minpack/enorm.inc \
                misc/minpack/fdjac1.inc \
                misc/minpack/fdjac2.inc \
                misc/minpack/fdjac2_funfit.inc \
                misc/minpack/full_chk_der.inc \
                misc/minpack/full_chk_der_2.inc \
                misc/minpack/hybrd.inc \
                misc/minpack/hybrj_mf.inc \
                misc/minpack/hybrj_sp.inc \
                misc/minpack/lmder_mf.inc \
                misc/minpack/lmdif_funfit.inc \
                misc/minpack/lmdif1_funfit.inc \
                misc/minpack/lmdif.inc \
                misc/minpack/lmpar.inc \
                misc/minpack/qform.inc \
                misc/minpack/qrfac.inc \
                misc/minpack/qrsolv.inc \
                misc/minpack/r1mpyq.inc \
                misc/minpack/r1updt.inc \
                inc_dev/mod_core.mod \
                inc_dev/mod_fileio.mod \
                inc_dev/mod_mfdebug.mod \
                inc_dev/mod_mfaux.mod \
                inc_dev/mod_mfarray.mod \
                inc_dev/mod_datafun.mod \
                inc_dev/mod_sparse.mod \
                inc_dev/mod_matfun.mod \
                inc_dev/mod_ops.mod

obj/mod_datafun.o : fml_datafun/Max.inc \
                    fml_datafun/Min.inc \
                    fml_datafun/fourier_cos.inc \
                    fml_datafun/fourier_sin.inc \
                    fml_datafun/fft.inc \
                    fml_datafun/ifft.inc \
                    fml_datafun/fft2.inc \
                    fml_datafun/ifft2.inc \
                    fml_datafun/gradient.inc \
                    fml_datafun/Sort.inc \
                    fml_datafun/Stats.inc \
                    fml_datafun/moments.inc \
                    fml_sparse/util/maxab.inc \
                    fml_sparse/util/maxab1.inc \
                    fml_sparse/util/minab.inc \
                    fml_sparse/util/minab1.inc \
                    fml_sparse/util/sumcols.inc \
                    fml_sparse/util/sumrows.inc \
                    inc_dev/mod_core.mod \
                    inc_dev/mod_sparse.mod \
                    inc_dev/mod_elmat.mod \
                    inc_dev/gft.mod

obj/mod_specfun.o : fml_specfun/cei_double.inc \
                    fml_specfun/erf.inc \
                    inc_dev/mod_core.mod \
                    inc_dev/mod_ops.mod \
                    inc_dev/mod_datafun.mod

obj/mod_matfun.o : fml_matfun/Balance.inc \
                   fml_matfun/Chol.inc \
                   fml_matfun/CondEst.inc \
                   fml_matfun/Eig.inc \
                   fml_matfun/Funm.inc \
                   fml_matfun/Expm.inc \
                   fml_matfun/Hess.inc \
                   fml_matfun/Is_Pos_Def.inc \
                   fml_matfun/LDiv.inc \
                   fml_matfun/LDiv_aux.inc \
                   fml_matfun/Logm.inc \
                   fml_matfun/LDLT.inc \
                   fml_matfun/LU.inc \
                   fml_matfun/Norm.inc \
                   fml_matfun/NormEst.inc \
                   fml_matfun/NormEst1.inc \
                   fml_matfun/Null.inc \
                   fml_matfun/Orth.inc \
                   fml_matfun/Powm.inc \
                   fml_matfun/QR.inc \
                   fml_matfun/Rank.inc \
                   fml_matfun/RCond.inc \
                   fml_matfun/RDiv.inc \
                   fml_matfun/RDiv_aux.inc \
                   fml_matfun/Rref.inc \
                   fml_matfun/Schur.inc \
                   fml_matfun/Sqrtm.inc \
                   fml_matfun/Svd.inc \
                   \
                   fml_matfun/mat_vec.inc \
                   fml_matfun/Eigs_which.inc \
                   fml_matfun/Eigs_sigma.inc \
                   fml_matfun/SVDS.inc \
                   fml_sparse/util/max_diag_at_a.inc \
                   fml_sparse/util/norm.inc \
                   fml_sparse/util/symmpattern.inc \
                   fml_sparse/util/isdiag.inc \
                   fml_sparse/util/istril.inc \
                   fml_sparse/util/istriu.inc \
                   \
                   misc/suitesparse/umf4_f90wrapper.inc \
                   misc/suitesparse/cholmod_f90wrapper.inc \
                   misc/suitesparse/spqr_f90wrapper.inc \
                   \
                   inc_dev/mod_mfarray.mod \
                   inc_dev/mod_core.mod \
                   inc_dev/mod_elmat.mod \
                   inc_dev/mod_ops.mod \
                   inc_dev/mod_datafun.mod \
                   inc_dev/mod_specfun.mod

obj/bezier.o : inc_dev/mod_mfdebug.mod \
               inc_dev/mod_mfarray.mod

obj/mod_polyfun.o : fml_core/Progress.inc \
                    fml_datafun/fourier_leg.inc \
                    fml_polyfun/mfTriConnect.inc \
                    fml_polyfun/Delaunay.inc \
                    fml_polyfun/Delaunay3D.inc \
                    fml_polyfun/Voronoi.inc \
                    fml_polyfun/FunFit.inc \
                    fml_polyfun/GridData.inc \
                    fml_polyfun/GridData3D.inc \
                    fml_polyfun/Interp1.inc \
                    fml_polyfun/Interp2.inc \
                    fml_polyfun/Poly.inc \
                    fml_polyfun/PolyFit.inc \
                    fml_polyfun/PolyVal.inc \
                    fml_polyfun/PPDer.inc \
                    fml_polyfun/PPVal.inc \
                    fml_polyfun/Spline.inc \
                    inc_dev/mod_mfaux.mod \
                    inc_dev/mod_core.mod \
                    inc_dev/mod_elmat.mod \
                    inc_dev/mod_matfun.mod \
                    inc_dev/bezier.mod \
                    inc_dev/splines.mod

obj/mod_ddebd2.o : inc_dev/mod_mfdebug.mod \
                   inc_dev/mod_mfaux.mod \
                   inc_dev/mod_core.mod \
                   misc/suitesparse/umf4_f90wrapper.inc

obj/mod_slatec_aux.o : \
      misc/slatec/d1mach.f90 misc/slatec/fdump.f90 misc/slatec/i1mach.f90 \
      misc/slatec/j4save.f90 misc/slatec/xercnt.f90 misc/slatec/xerhlt.f90 \
      misc/slatec/xermsg.f90 misc/slatec/xerprn.f90 misc/slatec/xersve.f90 \
      misc/slatec/xgetua.f90 misc/slatec/xsetf.f90

obj/mod_slatec_fun.o : \
      misc/slatec/dai.f90 misc/slatec/daie.f90 \
      misc/slatec/d9aimp.f90 misc/slatec/dbi.f90 \
      misc/slatec/dbie.f90 misc/slatec/d9lgmc.f90 misc/slatec/dasyik.f90 \
      misc/slatec/dasyjy.f90 misc/slatec/dbesi.f90 misc/slatec/dbesj.f90 \
      misc/slatec/dbesk.f90 misc/slatec/dbesk0.f90 misc/slatec/dbesk1.f90 \
      misc/slatec/dbesi0.f90 misc/slatec/dbesi1.f90 misc/slatec/dbesy.f90 \
      misc/slatec/dbsi0e.f90 misc/slatec/dbsi1e.f90 misc/slatec/dbsk0e.f90 \
      misc/slatec/dbsk1e.f90 misc/slatec/dbsknu.f90 misc/slatec/dbsynu.f90 \
      misc/slatec/dcsevl.f90 misc/slatec/dgamma.f90 misc/slatec/dgamlm.f90 \
      misc/slatec/dgamln.f90 misc/slatec/djairy.f90 misc/slatec/dlngam.f90 \
      misc/slatec/dqag.f90 \
      misc/slatec/dqagi.f90 misc/slatec/dqagie.f90 misc/slatec/dqk15i.f90 \
      misc/slatec/dqag_2.f90 misc/slatec/dqag_3.f90 \
      misc/slatec/dqage.f90 misc/slatec/dqage_2.f90 misc/slatec/dqage_3.f90 \
      misc/slatec/dqags.f90 misc/slatec/dqagse.f90 misc/slatec/dqelg.f90 \
      misc/slatec/dqk15.f90 misc/slatec/dqk21.f90 misc/slatec/dqk31.f90 \
      misc/slatec/dqk41.f90 misc/slatec/dqk51.f90 misc/slatec/dqk61.f90 \
      misc/slatec/dqk15_2.f90 misc/slatec/dqk21_2.f90 misc/slatec/dqk31_2.f90 \
      misc/slatec/dqk41_2.f90 misc/slatec/dqk51_2.f90 misc/slatec/dqk61_2.f90 \
      misc/slatec/dqk15_3.f90 misc/slatec/dqk21_3.f90 misc/slatec/dqk31_3.f90 \
      misc/slatec/dqk41_3.f90 misc/slatec/dqk51_3.f90 misc/slatec/dqk61_3.f90 \
      misc/slatec/dqpsrt.f90 misc/slatec/dyairy.f90 misc/slatec/initds.f90 \
      misc/slatec/zabs.f90 misc/slatec/zacai.f90 misc/slatec/zacon.f90 \
      misc/slatec/zairy.f90 misc/slatec/zasyi.f90 misc/slatec/zbesh.f90 \
      misc/slatec/zbesi.f90 misc/slatec/zbesj.f90 misc/slatec/zbesk.f90 \
      misc/slatec/zbesy.f90 misc/slatec/zbinu.f90 misc/slatec/zbknu.f90 \
      misc/slatec/zbiry.f90 misc/slatec/zbuni.f90 misc/slatec/zbunk.f90 \
      misc/slatec/zdiv.f90 misc/slatec/zexp.f90 misc/slatec/zkscl.f90 \
      misc/slatec/zlog.f90 misc/slatec/zmlt.f90 misc/slatec/zmlri.f90 \
      misc/slatec/zrati.f90 misc/slatec/zs1s2.f90 misc/slatec/zseri.f90 \
      misc/slatec/zshch.f90 misc/slatec/zsqrt.f90 misc/slatec/zuchk.f90 \
      misc/slatec/zunhj.f90 misc/slatec/zuni1.f90 misc/slatec/zuni2.f90 \
      misc/slatec/zunik.f90 misc/slatec/zunk1.f90 misc/slatec/zunk2.f90 \
      misc/slatec/zuoik.f90 misc/slatec/zwrsk.f90 \
      \
      inc_dev/mod_slatec_aux.mod

obj/mod_slatec_solve.o : \
      misc/slatec/dcfod.f90 misc/slatec/ddaini.F90 misc/slatec/ddajac.F90 \
      misc/slatec/ddanrm.f90 misc/slatec/ddaslv.F90 misc/slatec/ddassl.F90 \
      misc/slatec/ddastp.F90 misc/slatec/ddatrp.f90 misc/slatec/ddawts.f90 \
      misc/slatec/ddeabm.f90 misc/slatec/ddebdf.f90 misc/slatec/dderkf.f90 \
      misc/slatec/ddes.F90 misc/slatec/dfehl.f90 misc/slatec/dgbfa.f90 \
      misc/slatec/dgbsl.f90 misc/slatec/dgefa.f90 misc/slatec/dgesl.f90 \
      misc/slatec/dgeco.f90 misc/slatec/dhstrt.F90 misc/slatec/dhvnrm.f90 \
      misc/slatec/dintp.f90 misc/slatec/dintyd.f90 misc/slatec/dlsod.F90 \
      misc/slatec/dpbfa.f90 misc/slatec/dpbsl.f90 misc/slatec/dpoco.f90 \
      misc/slatec/dpofa.f90 misc/slatec/dposl.f90 misc/slatec/dpjac.F90 \
      misc/slatec/drkfs.F90 misc/slatec/dslvs.f90 misc/slatec/dsteps.f90 \
      misc/slatec/dstod.F90 misc/slatec/dvnrms.f90 \
      \
      inc_dev/mod_slatec_aux.mod \
      inc_dev/mod_ddebd2.mod \
      inc_dev/minpack.mod

obj/mod_funfun.o : fml_funfun/Quad.inc \
                   fml_funfun/mfOdeSolve_JacDF.inc \
                   fml_funfun/mfOdeSolve_JacUser.inc \
                   fml_funfun/mfOdeSolve_JacUserSP.inc \
                   fml_funfun/msOdeSolve_JacDF.inc \
                   fml_funfun/msOdeSolve_JacUser.inc \
                   fml_funfun/msOdeSolve_JacUserSP.inc \
                   fml_funfun/OdeSolve_aux.inc \
                   fml_funfun/mfDaeSolve_JacDF.inc \
                   fml_funfun/mfDaeSolve_JacUser.inc \
                   fml_funfun/mfDaeSolve_JacUserSP.inc \
                   fml_funfun/msDaeSolve_JacDF.inc \
                   fml_funfun/msDaeSolve_JacUser.inc \
                   fml_funfun/msDaeSolve_JacUserSP.inc \
                   fml_funfun/DaeSolve_aux.inc \
                   fml_funfun/dae_cic_dense.inc \
                   fml_funfun/dae_cic_band.inc \
                   fml_funfun/dae_cic_sparse.inc \
                   fml_funfun/FZero.inc \
                   fml_funfun/FSolve.inc \
                   fml_funfun/LsqNonLin.inc \
                   inc_dev/mod_slatec_solve.mod \
                   inc_dev/mod_matfun.mod \
                   inc_dev/mod_fileio.mod \
                   inc_dev/mod_ddebd2.mod \
                   inc_dev/minpack.mod

obj/triangle.o : misc/delaunay/2d/triangle.h
obj/triangle_delaunay.o : misc/delaunay/2d/triangle.h
obj/predicates.o : misc/delaunay/3d/tetgen.h
obj/tetgen.o : misc/delaunay/3d/tetgen.h
obj/tetgen_f90wrapper.o : misc/delaunay/3d/tetgen.h

#--------------------------------- tags --------------------------------

fml.tags :
	ctags --language-force=fortran -f ../src/$@ \
         *.F90 \
         fml_*/*.inc \
         fml_sparse/util/*.inc

#-----------------------------------------------------------------------
#--------------------------------- FGL ---------------------------------
#-----------------------------------------------------------------------

FGL_OBJS = obj/fgl_aux.o \
           obj/fgl_aux_2.o \
           \
           obj/mod_win_db.o \
           obj/mod_window.o \
           obj/mod_axes.o \
           obj/mod_grobj.o \
           obj/mod_plot2d.o

obj/mod_fgl_mem_debug.o : inc_dev/mod_mfdebug.mod \
                          inc_dev/mod_mem_debug.mod \
                          inc_dev/mod_win_db.mod

obj/fgl_aux.o : inc_dev/mod_fgl_mem_debug.mod \
                inc_dev/fml.mod

obj/fgl_aux_2.o : fgl/src/PS_PDF/PatchQuadCore_flat.inc \
                  fgl/src/PS_PDF/PatchQuadCore_shad.inc \
                  fgl/src/PS_PDF/PatchQuadMesh_shad.inc \
                  fgl/src/PS_PDF/PatchRectCore_flat.inc \
                  fgl/src/PS_PDF/PatchTriCore_flat.inc \
                  fgl/src/PS_PDF/PatchTriCore_shad.inc \
                  fgl/src/PS_PDF/PatchTriMesh_shad.inc \
                  fgl/src/PS_PDF/X11_rect_dump.inc \
                  fgl/src/Pix_aux.inc \
                  fgl/src/pg2dproj/pg2dproj_x.inc \
                  fgl/src/pg2dproj/pg2dproj_y.inc \
                  fgl/src/pg2dproj/pg2dproj_matx.inc \
                  fgl/src/pg2dproj/pg2dproj_maty.inc \
                  fgl/src/pg2dproj/pg2dproj_aux.inc \
                  inc_dev/mod_pgplot.mod \
                  inc_dev/mod_win_db.mod \
                  inc_dev/mod_mfdebug.mod \
                  inc_dev/mod_mfaux.mod \
                  inc_dev/mod_mfarray.mod \
                  inc_dev/mod_fgl_mem_debug.mod

obj/mod_win_db.o : inc_dev/mod_ieee.mod \
                   inc_dev/mod_mfaux.mod

obj/mod_window.o : fgl/src/mf_win_aux.F90 \
                   fgl/src/mf_win_redraw.f90 \
                   fgl/src/usr/Arrow_draw.f90 \
                   fgl/src/usr/Bar_draw.f90 \
                   fgl/src/usr/Contour_draw.f90 \
                   fgl/src/usr/ContourF_draw.f90 \
                   fgl/src/usr/ErrorBar_draw.f90 \
                   fgl/src/usr/Image_draw.f90 \
                   fgl/src/usr/Patch_draw.f90 \
                   fgl/src/usr/Pcolor_draw.f90 \
                   fgl/src/usr/Plot_draw.f90 \
                   fgl/src/usr/PlotCubicBezier_draw.f90 \
                   fgl/src/usr/PlotHist_draw.f90 \
                   fgl/src/usr/PlotQuadrBezier_draw.f90 \
                   fgl/src/usr/PlotVoronoi_draw.f90 \
                   fgl/src/usr/Quiver_draw.f90 \
                   fgl/src/usr/Spy_draw.f90 \
                   fgl/src/usr/Streamline_draw.f90 \
                   fgl/src/usr/Text_draw.f90 \
                   fgl/src/usr/TriContour_draw.f90 \
                   fgl/src/usr/TriContourF_draw.f90 \
                   fgl/src/usr/TriFill_draw.f90 \
                   fgl/src/usr/TriMesh_draw.f90 \
                   fgl/src/usr/TriPcolor_draw.f90 \
                   fgl/src/usr/TriQuiver_draw.f90 \
                   fgl/src/usr/PlotPLdomain_draw.f90 \
                   fgl/src/usr/Legend_aux.f90 \
                   fgl/src/usr/Close.f90 \
                   fgl/src/usr/ExitFgl.f90 \
                   fgl/src/usr/Figure.f90 \
                   fgl/src/usr/InitFgl.f90 \
                   fgl/src/usr/SetBackgroundColor.f90 \
                   fgl/src/usr/GetX11Device.f90 \
                   fgl/src/usr/SetX11Device.F90 \
                   inc_dev/fml.mod \
                   inc_dev/mod_win_db.mod \
                   inc_dev/fgl_aux.mod \
                   inc_dev/fgl_aux_2.mod \
                   inc_dev/mod_fgl_mem_debug.mod \
                   inc_dev/mod_pgplot.mod

obj/mod_axes.o : fgl/src/usr/Axis.f90 \
                 fgl/src/usr/AxisFontSize.f90 \
                 fgl/src/usr/AxisLabelFormat.f90 \
                 fgl/src/usr/AxisLineWidth.f90 \
                 fgl/src/usr/CharInPixels.f90 \
                 fgl/src/usr/Cla.f90 \
                 fgl/src/usr/Clf.f90 \
                 fgl/src/usr/ColorAxis.f90 \
                 fgl/src/usr/ColorBar.f90 \
                 fgl/src/usr/ColorMap.f90 \
                 fgl/src/usr/ColorMapSize.f90 \
                 fgl/src/usr/DrawBox.f90 \
                 fgl/src/usr/DrawGrid.f90 \
                 fgl/src/usr/RedrawFigure.f90 \
                 fgl/src/usr/GetModKeys.f90 \
                 fgl/src/usr/DefineCustomCursors.f90 \
                 fgl/src/usr/GetX11Pixmap.f90 \
                 fgl/src/usr/GetXAxisTicksNb.f90 \
                 fgl/src/usr/SetXAxisUserLabels.f90 \
                 fgl/src/usr/Ginput.f90 \
                 fgl/src/usr/GinputRect.f90 \
                 fgl/src/usr/GinputCustom.f90 \
                 fgl/src/usr/Grid.f90 \
                 fgl/src/usr/Hold.f90 \
                 fgl/src/usr/LabelFontSize.f90 \
                 fgl/src/usr/TitleFontSize.f90 \
                 fgl/src/usr/Legend.F90 \
                 fgl/src/usr/Print.f90 \
                 fgl/src/usr/Print_aux.F90 \
                 fgl/src/usr/RemoveClipBox.f90 \
                 fgl/src/usr/ResizeWindow.f90 \
                 fgl/src/usr/SetClipBox.f90 \
                 fgl/src/usr/SetWinProp.f90 \
                 fgl/src/usr/Title.F90 \
                 fgl/src/usr/XLabel.F90 \
                 fgl/src/usr/YLabel.F90 \
                 tmp/mfLegend.f90            tmp/msLegend.f90 \
                 tmp/mfTitle.f90             tmp/msTitle.f90 \
                 tmp/mfXLabel.f90            tmp/msXLabel.f90 \
                 tmp/mfYLabel.f90            tmp/msYLabel.f90 \
                 \
                 inc_dev/fml.mod \
                 inc_dev/mod_win_db.mod \
                 inc_dev/mod_window.mod \
                 inc_dev/fgl_aux_2.mod

obj/mod_grobj.o : fgl/src/usr/Animation.f90 \
                  fgl/src/usr/ShowNow.f90 \
                  fgl/src/usr/AttributesManagement.f90 \
                  fgl/src/usr/BBuf.f90 \
                  fgl/src/usr/EBuf.f90 \
                  fgl/src/usr/GetWinId.f90 \
                  fgl/src/usr/MoveLegend.f90 \
                  fgl/src/usr/PanAndZoom.f90 \
                  fgl/src/usr/Pan.f90 \
                  fgl/src/usr/RemoveGrObj.f90 \
                  fgl/src/usr/SetGBuffer.f90 \
                  fgl/src/usr/GetAllGrObj.f90 \
                  fgl/src/usr/GetTypeGrObj.f90 \
                  fgl/src/usr/SelectTypeGrObj.f90 \
                  fgl/src/usr/SetGrObj.f90 \
                  fgl/src/usr/SetGrObj_aux.f90 \
                  fgl/src/usr/SetPdfOC.f90 \
                  fgl/src/usr/Zoom.f90 \
                  fgl/src/usr/MoveGrObj.f90 \
                  fgl/src/usr/MoveGrObj_aux.f90 \
                  inc_dev/fml.mod \
                  inc_dev/mod_win_db.mod \
                  inc_dev/mod_window.mod \
                  inc_dev/mod_axes.mod \
                  inc_dev/fgl_aux_2.mod

obj/mod_plot2d.o : fgl/src/usr/Bar.F90 \
                   fgl/src/usr/Bar_aux.f90 \
                   fgl/src/usr/Contour_aux.f90 \
                   fgl/src/usr/ContourF_aux.f90 \
                   fgl/src/usr/CumulHist.f90 \
                   fgl/src/usr/ErrorBar.F90 \
                   fgl/src/usr/ErrorBar_aux.f90 \
                   fgl/src/usr/Image_aux.f90 \
                   fgl/src/usr/ImRead.F90 \
                   fgl/src/usr/ImRead_aux.f90 \
                   fgl/src/usr/ImRead_aux2.F90 \
                   fgl/src/usr/ImWrite.F90 \
                   fgl/src/usr/ImWrite_aux.f90 \
                   fgl/src/usr/ImWrite_aux2.F90 \
                   fgl/src/usr/Patch_aux.f90 \
                   fgl/src/usr/Pcolor_aux.f90 \
                   fgl/src/usr/Quiver_aux.f90 \
                   fgl/src/usr/Plot_aux.f90 \
                   fgl/src/usr/PlotCubicBezier_aux.f90 \
                   fgl/src/usr/PlotCubicSpline_aux.f90 \
                   fgl/src/usr/PlotQuadrBezier_aux.f90 \
                   fgl/src/usr/Shading.f90 \
                   fgl/src/usr/Spy_aux.f90 \
                   fgl/src/usr/Streamline_aux.f90 \
                   fgl/mfplot/src/TriStream/TriStream.inc \
                   fgl/src/usr/Text_aux.f90 \
                   fgl/src/usr/TriContour_aux.f90 \
                   fgl/src/usr/TriContourF_aux.f90 \
                   fgl/src/usr/TriContourF_aux2.f90 \
                   fgl/src/usr/TriFill_aux.f90 \
                   fgl/src/usr/TriMesh_aux.f90 \
                   fgl/src/usr/TriPcolor_aux.f90 \
                   fgl/src/usr/TriQuiver_aux.f90 \
                   fgl/src/usr/PlotPLdomain_aux.f90 \
                   tmp/mfArrow.f90           tmp/msArrow.f90 \
                   tmp/mfBar.f90             tmp/msBar.f90 \
                   tmp/mfContour.f90         tmp/msContour.f90 \
                   tmp/mfContourF.f90        tmp/msContourF.f90 \
                   tmp/mfErrorBar.f90        tmp/msErrorBar.f90 \
                   tmp/mfImage.f90           tmp/msImage.f90 \
                   tmp/mfPatch.f90           tmp/msPatch.f90 \
                   tmp/mfPcolor.f90          tmp/msPcolor.f90 \
                   tmp/mfQuiver.f90          tmp/msQuiver.f90 \
                   tmp/mfPlot.f90            tmp/msPlot.f90 \
                   tmp/mfPlotCubicBezier.f90 tmp/msPlotCubicBezier.f90 \
                   tmp/mfPlotCubicSpline.f90 tmp/msPlotCubicSpline.f90 \
                   tmp/mfPlotHist.f90        tmp/msPlotHist.f90 \
                   tmp/mfPlotQuadrBezier.f90 tmp/msPlotQuadrBezier.f90 \
                   tmp/mfSpy.f90             tmp/msSpy.f90 \
                   tmp/mfStreamline.f90      tmp/msStreamline.f90 \
                   tmp/mfText.f90            tmp/msText.f90 \
                   tmp/mfTriContour.f90      tmp/msTriContour.f90 \
                   tmp/mfTriContourF.f90     tmp/msTriContourF.f90 \
                   tmp/mfTriFill.f90         tmp/msTriFill.f90 \
                   tmp/mfTriMesh.f90         tmp/msTriMesh.f90 \
                   tmp/mfTriPcolor.f90       tmp/msTriPcolor.f90 \
                   tmp/mfTriQuiver.f90       tmp/msTriQuiver.f90 \
                   tmp/mfTriStreamline.f90   tmp/msTriStreamline.f90 \
                   tmp/mfPlotPLdomain.f90    tmp/msPlotPLdomain.f90 \
                   \
                   inc_dev/fml.mod \
                   inc_dev/mod_win_db.mod \
                   inc_dev/mod_window.mod \
                   inc_dev/mod_axes.mod \
                   inc_dev/mod_grobj.mod

#-------------------------------- dist ---------------------------------

dist_fml : dist_fml_echo \
           include/mod_funfun.mod \
           include/mod_polyfun.mod \
           include/mod_matfun.mod \
           include/mod_datafun.mod \
           include/mod_specfun.mod \
           include/mod_ops.mod \
           include/mod_elfun.mod \
           include/mod_mf_gsl.mod \
           include/mod_fileio.mod \
           include/mod_elmat.mod \
           include/mod_sparse.mod \
           include/mod_core.mod \
           include/mod_ieee.mod \
           include/mod_physunits.mod \
           include/mod_mfarray.mod \
           include/mod_prop.mod \
           include/rational_numbers.mod \
           include/iso_varying_string.mod \
           include/mod_mfaux.mod \
           include/mod_mem_debug.mod \
           include/mod_mfdebug.mod \
           include/gft_common.mod \
           include/gft_jmfft.mod \
           include/gft_set.mod \
           include/gft_do.mod \
           include/gft_end.mod \
           include/gft.mod \
           include/bezier.mod \
           include/splines.mod \
           include/mod_ddebd2.mod \
           include/fml.mod \
           include/f90_gzlib.mod \
           include/arpack_util.mod \
           include/mod_arpack.mod \
           include/convexhull_mod.mod \
           include/minpack.mod \
           include/mod_slatec_aux.mod \
           include/mod_slatec_fun.mod \
           include/mod_slatec_solve.mod

dist_fml_echo :
	@echo $(ECHO_OPT) "\r \c"
	@echo $(ECHO_OPT) "\r  ... creating modules with private access : \c"

include/mod_funfun.mod         : inc_dev/mod_funfun.mod
include/mod_polyfun.mod        : inc_dev/mod_polyfun.mod
include/mod_matfun.mod         : inc_dev/mod_matfun.mod
include/mod_datafun.mod        : inc_dev/mod_datafun.mod
include/mod_specfun.mod        : inc_dev/mod_specfun.mod
include/mod_ops.mod            : inc_dev/mod_ops.mod
include/mod_elfun.mod          : inc_dev/mod_elfun.mod
include/mod_mf_gsl.mod         : inc_dev/mod_mf_gsl.mod
include/mod_fileio.mod         : inc_dev/mod_fileio.mod
include/mod_elmat.mod          : inc_dev/mod_elmat.mod
include/mod_sparse.mod         : inc_dev/mod_sparse.mod
include/mod_core.mod           : inc_dev/mod_core.mod
include/mod_ieee.mod           : inc_dev/mod_ieee.mod
include/mod_physunits.mod      : inc_dev/mod_physunits.mod
include/mod_mfarray.mod        : inc_dev/mod_mfarray.mod
include/mod_prop.mod           : inc_dev/mod_prop.mod
include/rational_numbers.mod   : inc_dev/rational_numbers.mod
include/mod_mfaux.mod          : inc_dev/mod_mfaux.mod
include/mod_mem_debug.mod      : inc_dev/mod_mem_debug.mod
include/mod_mfdebug.mod        : inc_dev/mod_mfdebug.mod
include/mod_ddebd2.mod         : inc_dev/mod_ddebd2.mod
include/fml.mod                : inc_dev/fml.mod

dist_fgl : dist_fgl_echo \
           include/mod_plot2d.mod \
           include/mod_grobj.mod \
           include/mod_axes.mod \
           include/mod_window.mod \
           include/mod_fgl_mem_debug.mod \
           include/fgl_aux_2.mod \
           include/mod_win_db.mod \
           include/fgl_aux.mod \
           include/fgl.mod \
           include/mod_pgplot.mod \
           include/mod_grplot.mod

dist_fgl_echo :
	@echo $(ECHO_OPT) "\r \c"
	@echo $(ECHO_OPT) "\r  ... creating modules with private access : \c"

include/mod_plot2d.mod        : inc_dev/mod_plot2d.mod
include/mod_grobj.mod         : inc_dev/mod_grobj.mod
include/mod_axes.mod          : inc_dev/mod_axes.mod
include/mod_window.mod        : inc_dev/mod_window.mod
include/mod_fgl_mem_debug.mod : inc_dev/mod_fgl_mem_debug.mod
include/mod_win_db.mod        : inc_dev/mod_win_db.mod
include/fgl_aux_2.mod         : inc_dev/fgl_aux_2.mod
include/fgl_aux.mod           : inc_dev/fgl_aux.mod
include/fgl.mod               : inc_dev/fgl.mod

#--------------------------------- tags --------------------------------

fgl.tags :
	ctags --language-force=fortran -f ../src/$@ \
         fgl/src/*.f fgl/src/*.f90 fgl/src/*.F90 \
         fgl/src/usr/*.f90 fgl/src/usr/*.F90

tags : fml.tags fgl.tags

#---------------------------- preprocessing ----------------------------

tmp/mf%.f90 : fgl/src/usr/%.F90
	@$(FPP) $(FPP_DEBUG_FLAGS) -D_MF_FUNC $(FPP_FLAGS) $< $(FPP_OUT) $@

tmp/ms%.f90 : fgl/src/usr/%.F90
	@$(FPP) $(FPP_DEBUG_FLAGS) -D_MF_SUBR $(FPP_FLAGS) $< $(FPP_OUT) $@
