program test_mod_sparse_1

   use fml

   use test_aux
   use lib_aux

   implicit none

   type(mfArray) :: A, B, C, v, x, y, d, E, s
   type(mfArray) :: L, U, P, Q, R
   type(mfArray) :: vec, A_vec, lambda, ind, flag, tmp
   integer, allocatable :: ir(:), jc(:)
   real(kind=MF_DOUBLE), allocatable :: val(:)
   complex(kind=MF_DOUBLE), allocatable :: zval(:)
   real(kind=MF_DOUBLE), pointer :: f90_ptr_vec(:)
   complex(kind=MF_DOUBLE), pointer :: f90_ptr_vec_cmplx(:)
   logical :: bool
   integer :: i, n, MsgLevel_save, nev
   integer :: nrow, ncol, nnz
   real(kind=MF_DOUBLE) :: check_small_threshold = 1.0d3*MF_EPS

   character(len=24) :: arpack_version
   character(len=128) :: arpack_info
   character(len=8) :: suitesparse_version

   ! Msg level = 3 : all messages are printed (verbose mode)
   !             2 : messages of kind 'ERROR' and 'Warning' are
   !                 printed [default]
   !             1 : only messages of kind 'ERROR' are printed
   !             0 : nothing is printed (quiet mode)
   !                 (pause are ignored !)

!!   call msSetMsgLevel(3)
!!   call msSetTrbLevel("all")

   print "()"

   ! for TRACE_MEM_DEBUG, STDERR must be redirected to STDOUT;
   ! the same thing stands for 'make check'
   call msSetStdIO( stderr=STDOUT )

!!goto 10

   ! to avoid escape sequences of color setting in the output file
   ! (default in "on")
   call msSetColoredMsg( "off" )

   ! VERSIONs ----------------------------------------------------------
   print "()"
   print *, "MF_MUESLI_VERSION = '", MF_MUESLI_VERSION, "'"
   print "()"
   print *, "MF_COMPILER_VERSION = '", MF_COMPILER_VERSION, "'"
   print "()"
   print *, "MF_COMPILATION_CONFIG = '", MF_COMPILATION_CONFIG(), "'"
   print "()"

   ! Arpack version ----------------------------------------------------
   call print_separation("msGetArpackInfo")

   print "()"
   call msGetArpackInfo( arpack_version, arpack_info )
   print *, "ARPACK version = '", trim(arpack_version), "'"
   print "()"
   print *, "ARPACK info = '", trim(arpack_info), "'"
   print "()"

   ! SuiteSparse version ----------------------------------------------------
   call print_separation("msGetSuiteSparseLib")

   print "()"
   call msGetSuiteSparseLib( suitesparse_version )
   print *, "SuiteSparse version = '", trim(suitesparse_version), "'"

   print "()"

   ! msDisplay (screen layout) -----------------------------------------
   call print_separation("msDisplay (screen layout)")

   ! real (format short)
   call msFormat("short")
   A = mf( [ 1.0d-111, 1.0d0, -MF_E, MF_PI ] )
   A = mfSparse(A)
   print "(/,A)", "*** test number 1 ***"
   call msDisplay(A,"A")

   ! real (format long)
   call msFormat("long")
   print "(/,A)", "*** test number 2 ***"
   call msDisplay(A,"A")

   ! special IEEE values: Inf, NaN (format short)
   call msFormat("short")
   A = mf( [ 1.0d0, MF_INF, -MF_INF, MF_NAN ] )
   A = mfSparse(A)
   print "(/,A)", "*** test number 3 ***"
   call msDisplay(A,"A")

   ! special IEEE values: Inf, NaN (format long)
   call msFormat("long")
   print "(/,A)", "*** test number 4 ***"
   call msDisplay(A,"A")

   !---------------------

   ! complex (format short)
   call msFormat("short")
   A = mf( [ 1.0d-111, 1.0d0, -MF_E, MF_PI ] )*MF_I
   A = mfSparse(A)
   print "(/,A)", "*** test number 5 ***"
   call msDisplay(A,"A")

   ! complex (format long)
   call msFormat("long")
   print "(/,A)", "*** test number 6 ***"
   call msDisplay(A,"A")

   ! complex: special IEEE values: Inf, NaN (format short)
   call msFormat("short")
   A = mf( [ 1.0d0, MF_INF, -MF_INF, MF_NAN ] )*MF_I
   A = mfSparse(A)
   print "(/,A)", "*** test number 7 ***"
   call msDisplay(A,"A")

   ! complex: special IEEE values: Inf, NaN (format long)
   call msFormat("long")
   print "(/,A)", "*** test number 8 ***"
   call msDisplay(A,"A")

   ! complex: special IEEE values: Inf, NaN (format short)
   call msFormat("short")
   A = mf( [ 0.0d0, MF_INF, -MF_INF, MF_NAN ] ) &
     + mf( [ 1.0d0, 0.0d0, -1.0d0, 1.0d0 ] )*MF_I
   A = -mfSparse(A)
   print "(/,A)", "*** test number 9 ***"
   call msDisplay(A,"A")

   ! complex: special IEEE values: Inf, NaN (format long)
   call msFormat("long")
   print "(/,A)", "*** test number 10 ***"
   call msDisplay(A,"A")

   call msFormat("short")

   ! mfSparse ----------------------------------------------------------
   call print_separation("mfSparse")

   MsgLevel_save = mfGetMsgLevel()
   call msSetMsgLevel(1)
   call msDisplay(mfSparse(MF_EMPTY), "mfSparse(MF_EMPTY)")
   call msSetMsgLevel(MsgLevel_save)

   ! real case

   ! test on a matrix which is not sparse
   ! emits an info-message (only if MsgLevel == 3)
   A = mfOnes( 4 )
   call msDisplay(A, "A (dense, real) ")
   MsgLevel_save = mfGetMsgLevel()
   call msSetMsgLevel(3)
   print "(/,A)", "*** test number 11 ***"
   call msAssign(B, mfSparse(A))   ! Assignment (msAssign_mfArray)
   call msSetMsgLevel(MsgLevel_save)

   A = mfEye( 4 )
   call msDisplay(A, "A (dense, real) ")
   print "(/,A)", "*** test number 12 ***"
   call msDisplay(mfSparse(A), "mfSparse(A)")

   print "(/,A)", "*** test number 13 ***"
   A = mfSparse(A)                 ! Assignment (msAssign_mfArray_copy)
   call msDisplay(A, "mfSparse(A)")

   ! complex case

   ! test on a matrix which is not sparse
   ! emits an info-message (only if MsgLevel == 3)
   A = mfOnes( 4 )*MF_I
   call msDisplay(A, "A (dense, complex) ")
   MsgLevel_save = mfGetMsgLevel()
   call msSetMsgLevel(3)
   print "(/,A)", "*** test number 14 ***"
   call msAssign(B, mfSparse(A))   ! Assignment (msAssign_mfArray)
   call msSetMsgLevel(MsgLevel_save)

   A = mfEye( 4 )*MF_I
   call msDisplay(A, "A (dense, complex) ")
   print "(/,A)", "*** test number 15 ***"
   call msDisplay(mfSparse(A), "mfSparse(A)")

   print "(/,A)", "*** test number 16 ***"
   A = mfSparse(A)                 ! Assignment (msAssign_mfArray_copy)
   call msDisplay(A, "mfSparse(A)")

   ! mfSpImport --------------------------------------------------------
   call print_separation("mfSpImport")

   ! real case

   ! hereafter val(:) must be allocated in all cases

   ! from COO format

   allocate( ir(3), jc(3), val(0) )
   ir(:) = [ 7, 6, 3 ]
   jc(:) = [ 4, 5, 2 ]

   ! 'val' may have a null size : structure only
   print "(/,A)", "*** test number 17 ***"
   A = mfSpImport(ir,jc,val)
   call msDisplay(A, "mfSpImport(ir,jc,<null size vector>)")
   deallocate( ir, jc, val )

   ! with duplicated entries
   allocate( ir(5), jc(5), val(0) )
   ir(:) = [ 7, 6, 3, 7, 6 ]
   jc(:) = [ 4, 5, 2, 4, 5 ]
   MsgLevel_save = mfGetMsgLevel()
   call msSetMsgLevel(3)
   print "(/,A)", "*** test number 18 ***"
   call msAssign( A, mfSpImport(ir,jc,val) )
   call msSetMsgLevel(MsgLevel_save)
   call msDisplay(A, "mfSpImport(ir,jc,<null size vector>)")
   deallocate( ir, jc, val )

   allocate( ir(3), jc(3), val(3) )
   ir(:) = [ 7, 6, 3 ]
   jc(:) = [ 4, 5, 2 ]
   val(:) = [ 1.0d0, 2.0d0, 3.0d0 ]

   ! 'val' may have a null size again (other way)
   print "(/,A)", "*** test number 19 ***"
   A = mfSpImport(ir,jc,val(1:0))
   call msDisplay(A, "mfSpImport(ir,jc,val(1:0))")

   print "(/,A)", "*** test number 20 ***"
   A = mfSpImport(ir,jc,val)
   call msDisplay(A, "mfSpImport(ir,jc,val)")
   deallocate( ir, jc, val )

   ! with duplicated entries
   allocate( ir(5), jc(5), val(5) )
   ir(:) = [ 7, 6, 3, 7, 6 ]
   jc(:) = [ 4, 5, 2, 4, 5 ]
   val(:) = [ 0.5d0, 1.0d0, 3.0d0, 1.5d0, 1.0d0 ]
   MsgLevel_save = mfGetMsgLevel()
   call msSetMsgLevel(3)
   print "(/,A)", "*** test number 21 ***"
   call msAssign( A, mfSpImport(ir,jc,val,duplicated_entries="ignored") )
   call msSetMsgLevel(MsgLevel_save)
   call msDisplay(A, "mfSpImport(ir,jc,val,duplicated_entries='ignored')")

   MsgLevel_save = mfGetMsgLevel()
   call msSetMsgLevel(3)
   print "(/,A)", "*** test number 22 ***"
   call msAssign( A, mfSpImport(ir,jc,val,duplicated_entries="added") )
   call msSetMsgLevel(MsgLevel_save)
   call msDisplay(A, "mfSpImport(ir,jc,val,duplicated_entries='added')")

   MsgLevel_save = mfGetMsgLevel()
   call msSetMsgLevel(3)
   print "(/,A)", "*** test number 23 ***"
   call msAssign( A, mfSpImport(ir,jc,val,duplicated_entries="replaced") )
   call msSetMsgLevel(MsgLevel_save)
   call msDisplay(A, "mfSpImport(ir,jc,val,duplicated_entries='replaced')")

   print "(/,A)", "*** test number 24 ***"
   A = mfSpImport(ir,jc,val,m=10)
   call msDisplay(A, "mfSpImport(ir,jc,val,m=10)")

   print "(/,A)", "*** test number 25 ***"
   A = mfSpImport(ir,jc,val,n=10)
   call msDisplay(A, "mfSpImport(ir,jc,val,n=10)")

   print "(/,A)", "*** test number 26 ***"
   A = mfSpImport(ir,jc,val,m=10,n=10)
   call msDisplay(A, "mfSpImport(ir,jc,val,m=10,n=10)")

   print "(/,A)", "*** test number 27 ***"
   A = mfSpImport(ir,jc,val,m=10,n=10,nzmax=30)
   call msDisplay(A, "mfSpImport(ir,jc,val,m=10,n=10,nzmax=30)")

   deallocate( ir, jc, val )

   allocate( ir(3), jc(3), val(3) )

   ! using pattern optional arg. ---------------

   ! real matrices

   ir(:) = [ 1, 6, 6 ]  ! lower triangular with diagonal elements
   jc(:) = [ 1, 1, 6 ]
   val(:) = [ 1, 10, 2 ]

   print "(/,A)", "*** test number 28 ***"
   A = mfSpImport(ir,jc,val,pattern="symm")
   call msDisplay(A, "mfSpImport(ir,jc,val,pattern='symm')")
   call msDisplay( mfFull(A), 'full(")')

   ir(:) = [ 1, 1, 6 ]  ! upper triangular with diagonal elements
   jc(:) = [ 1, 6, 6 ]

   print "(/,A)", "*** test number 29 ***"
   A = mfSpImport(ir,jc,val,pattern="symm")
   call msDisplay(A, "mfSpImport(ir,jc,val,pattern='symm')")
   call msDisplay( mfFull(A), 'full(")')

   ir(:) = [ 5, 5, 6 ]  ! lower triangular without any diagonal element
   jc(:) = [ 1, 2, 2 ]
   val(:) = [ 1, 2, 3 ]

   print "(/,A)", "*** test number 30 ***"
   A = mfSpImport(ir,jc,val,pattern="skew")
   call msDisplay(A, "mfSpImport(ir,jc,val,pattern='skew')")
   call msDisplay( mfFull(A), 'full(")')

   ir(:) = [ 1, 2, 2 ]  ! upper triangular without any diagonal element
   jc(:) = [ 5, 5, 6 ]

   print "(/,A)", "*** test number 31 ***"
   A = mfSpImport(ir,jc,val,pattern="skew")
   call msDisplay(A, "mfSpImport(ir,jc,val,pattern='skew')")
   call msDisplay( mfFull(A), 'full(")')

   ! complex matrices

   deallocate( val )
   allocate( zval(3) )

   ir(:) = [ 1, 6, 6 ]  ! lower triangular with diagonal elements
   jc(:) = [ 1, 1, 6 ]
   zval(:) = [ (0.0d0,1.0d0), (0.0d0,10.0d0), (0.0d0,2.0d0) ]

   print "(/,A)", "*** test number 32 ***"
   A = mfSpImport(ir,jc,zval,pattern="symm")
   call msDisplay(A, "mfSpImport(ir,jc,zval,pattern='symm')")
   call msDisplay( mfFull(A), 'full(")')

   print "(/,A)", "*** test number 33 ***"
   A = mfSpImport(ir,jc,zval,pattern="herm")
   call msDisplay(A, "mfSpImport(ir,jc,zval,pattern='herm')")
   call msDisplay( mfFull(A), 'full(")')

   ir(:) = [ 1, 1, 6 ]  ! upper triangular with diagonal elements
   jc(:) = [ 1, 6, 6 ]

   print "(/,A)", "*** test number 34 ***"
   A = mfSpImport(ir,jc,zval,pattern="symm")
   call msDisplay(A, "mfSpImport(ir,jc,zval,pattern='symm')")
   call msDisplay( mfFull(A), 'full(")')

   print "(/,A)", "*** test number 35 ***"
   A = mfSpImport(ir,jc,zval,pattern="herm")
   call msDisplay(A, "mfSpImport(ir,jc,zval,pattern='herm')")
   call msDisplay( mfFull(A), 'full(")')

   ir(:) = [ 5, 5, 6 ]  ! lower triangular without any diagonal element
   jc(:) = [ 1, 2, 2 ]
   zval(:) = [ (0.0d0,1.0d0), (0.0d0,2.0d0), (0.0d0,3.0d0) ]

   print "(/,A)", "*** test number 36 ***"
   A = mfSpImport(ir,jc,zval,pattern="skew")
   call msDisplay(A, "mfSpImport(ir,jc,zval,pattern='skew')")
   call msDisplay( mfFull(A), 'full(")')

   ir(:) = [ 1, 2, 2 ]  ! upper triangular without any diagonal element
   jc(:) = [ 5, 5, 6 ]

   print "(/,A)", "*** test number 37 ***"
   A = mfSpImport(ir,jc,zval,pattern="skew")
   call msDisplay(A, "mfSpImport(ir,jc,zval,pattern='skew')")
   call msDisplay( mfFull(A), 'full(")')

   deallocate( ir, jc, zval )

   ! from CSC format
   ! 3x4 sparse matrix
   nrow = 3
   ncol = 4
   nnz = 6
   allocate( ir(nnz), jc(ncol+1), val(0) )
   ir(:) = [ 2, 3, 1, 1, 2, 2 ]
   jc(:) = [ 1, 3, 4, 6, nnz+1 ]

   print "(/,A)", "*** test number 38 ***"
   A = mfSpImport(ir,jc,val,format='CSC')
   call msDisplay(A, "mfSpImport(ir,jc,<null size vector>,format='CSC')")

   deallocate( val )
   allocate( val(nnz) )

   val(:) = [ 1.0d0, 2.0d0, 3.0d0, 4.0d0, 5.0d0, 6.0d0 ]
   print "(/,A)", "*** test number 39 ***"
   A = mfSpImport(ir,jc,val,format='CSC')
   call msDisplay(A, "mfSpImport(ir,jc,val,format='CSC')")
   call msDisplay(mfFull(A), "")

   deallocate( ir, jc, val )

   ! from CSR format
   ! 3x4 sparse matrix
   nrow = 3
   ncol = 4
   nnz = 6
   allocate( ir(nrow+1), jc(nnz), val(0) )
   ir(:) = [ 1, 3, 6, nnz+1 ]
   jc(:) = [ 2, 3, 1, 3, 4, 1 ]

   print "(/,A)", "*** test number 40 ***"
   A = mfSpImport(ir,jc,val,format='CSR')
   call msDisplay(A, "mfSpImport(ir,jc,<null size vector>,format='CSR')")

   deallocate( val )
   allocate( val(nnz) )

   val(:) = [ 3.0d0, 4.0d0, 1.0d0, 5.0d0, 6.0d0, 2.0d0 ]
   print "(/,A)", "*** test number 41 ***"
   A = mfSpImport(ir,jc,val,format='CSR')
   call msDisplay(A, "mfSpImport(ir,jc,val,format='CSR')")
   call msDisplay(mfFull(A), "")

   deallocate( ir, jc, val )

   ! complex case

   ! hereafter val(:) must be allocated in all cases

   ! from COO format

   allocate( ir(3), jc(3), zval(0) )
   ir(:) = [ 7, 6, 3 ]
   jc(:) = [ 4, 5, 2 ]

   ! 'zval' may have a null size
   print "(/,A)", "*** test number 42 ***"
   A = mfSpImport(ir,jc,zval)
   call msDisplay(A, "mfSpImport(ir,jc,<null size vector>)")

   deallocate( zval )
   allocate( zval(3) )
   zval(:) = [ (1.0d0,0.1d0), (2.0d0,0.2d0), (3.0d0,0.3d0) ]

   ! 'zval' may have a null size again (other way)
   print "(/,A)", "*** test number 43 ***"
   A = mfSpImport(ir,jc,zval(1:0))
   call msDisplay(A, "mfSpImport(ir,jc,zval(1:0))")

   print "(/,A)", "*** test number 44 ***"
   A = mfSpImport(ir,jc,zval)
   call msDisplay(A, "mfSpImport(ir,jc,zval)")

   print "(/,A)", "*** test number 45 ***"
   A = mfSpImport(ir,jc,zval,m=10)
   call msDisplay(A, "mfSpImport(ir,jc,zval,m=10)")

   print "(/,A)", "*** test number 46 ***"
   A = mfSpImport(ir,jc,zval,n=10)
   call msDisplay(A, "mfSpImport(ir,jc,zval,n=10)")

   print "(/,A)", "*** test number 47 ***"
   A = mfSpImport(ir,jc,zval,m=10,n=10)
   call msDisplay(A, "mfSpImport(ir,jc,zval,m=10,n=10)")

   print "(/,A)", "*** test number 48 ***"
   A = mfSpImport(ir,jc,zval,m=10,n=10,nzmax=30)
   call msDisplay(A, "mfSpImport(ir,jc,zval,m=10,n=10,nzmax=30)")

   deallocate( ir, jc, zval )

   ! from CSC format
   ! 3x4 sparse matrix
   nrow = 3
   ncol = 4
   nnz = 6
   allocate( ir(nnz), jc(ncol+1), zval(0) )
   ir(:) = [ 2, 3, 1, 1, 2, 2 ]
   jc(:) = [ 1, 3, 4, 6, nnz+1 ]

   print "(/,A)", "*** test number 49 ***"
   A = mfSpImport(ir,jc,zval,format='CSC')
   call msDisplay(A, "mfSpImport(ir,jc,<null size vector>,format='CSC')")

   deallocate( zval )
   allocate( zval(nnz) )

   zval(:) = [ (1.0d0,0.1d0), (2.0d0,0.2d0), (3.0d0,0.3d0),             &
               (4.0d0,0.1d0), (5.0d0,0.5d0), (6.0d0,0.6d0) ]
   print "(/,A)", "*** test number 50 ***"
   A = mfSpImport(ir,jc,zval,format='CSC')
   call msDisplay(A, "mfSpImport(ir,jc,zval,format='CSC')")
   call msDisplay(mfFull(A), "")

   deallocate( ir, jc, zval )

   ! from CSR format
   ! 3x4 sparse matrix
   nrow = 3
   ncol = 4
   nnz = 6
   allocate( ir(nrow+1), jc(nnz), zval(0) )
   ir(:) = [ 1, 3, 6, nnz+1 ]
   jc(:) = [ 2, 3, 1, 3, 4, 1 ]

   print "(/,A)", "*** test number 51 ***"
   A = mfSpImport(ir,jc,zval,format='CSR')
   call msDisplay(A, "mfSpImport(ir,jc,<null size vector>,format='CSR')")

   deallocate( zval )
   allocate( zval(nnz) )

   zval(:) = [ (3.0d0,0.3d0), (4.0d0,0.1d0), (1.0d0,0.1d0),             &
               (5.0d0,0.5d0), (6.0d0,0.6d0), (2.0d0,0.2d0) ]
   print "(/,A)", "*** test number 52 ***"
   A = mfSpImport(ir,jc,zval,format='CSR')
   call msDisplay(A, "mfSpImport(ir,jc,zval,format='CSR')")
   call msDisplay(mfFull(A), "")

   deallocate( ir, jc, zval )

   ! msSpExport --------------------------------------------------------
   call print_separation("msSpExport")

   ! real case

   ! to COO format

   A = mf( [ 0, 3, 4, 0 ] ) .vc.                                        &
       mf( [ 1, 0, 5, 6 ] ) .vc.                                        &
       mf( [ 2, 0, 0, 0 ] )

   call msDisplay(A,"A")
   A = mfSparse(A)

   nnz = mfNnz(A)
   allocate( ir(nnz), jc(nnz), val(nnz) )
   print "(/,A)", "*** test number 53 ***"
   call msSpExport( A, ir, jc, val )
   print *, "exporting 'A' to COO format:"
   print "(1X,A,6(1X,I0))", "  ir = ", ir
   print "(1X,A,6(1X,I0))", "  jc = ", jc
   print "(1X,A,6(1X,F8.4))", "  val = ", val
   print "()"
   deallocate( ir, jc, val )

   ! to CSC format

   ncol = mfGet( mfShape(A), 2 )
   nnz = mfNnz(A)
   allocate( ir(nnz), jc(ncol+1), val(nnz) )
   print "(/,A)", "*** test number 54 ***"
   call msSpExport( A, ir, jc, val, format="CSC" )
   print *, "exporting 'A' to CSC format:"
   print "(1X,A,6(1X,I0))", "  ir = ", ir
   print "(1X,A,5(1X,I0))", "  jc = ", jc
   print "(1X,A,6(1X,F8.4))", "  val = ", val
   print "()"
   deallocate( ir, jc, val )

   ! to CSR format

   nrow = mfGet( mfShape(A), 1 )
   nnz = mfNnz(A)
   allocate( ir(nrow+1), jc(nnz), val(nnz) )
   print "(/,A)", "*** test number 55 ***"
   call msSpExport( A, ir, jc, val, format="CSR" )
   print *, "exporting 'A' to CSR format:"
   print "(1X,A,4(1X,I0))", "  ir = ", ir
   print "(1X,A,6(1X,I0))", "  jc = ", jc
   print "(1X,A,6(1X,F8.4))", "  val = ", val
   print "()"
   deallocate( ir, jc, val )

   ! complex case

   ! to COO format

   A = mf( [ 0, 3, 4, 0 ] ) .vc.                                        &
       mf( [ 1, 0, 5, 6 ] ) .vc.                                        &
       mf( [ 2, 0, 0, 0 ] )
   A = A*MF_I

   call msDisplay(A,"A")
   A = mfSparse(A)

   allocate( ir(6), jc(6), zval(6) )
   print "(/,A)", "*** test number 56 ***"
   call msSpExport( A, ir, jc, zval )
   print *, "exporting 'A' to COO format:"
   print "(1X,A,6(1X,I0))", "  ir = ", ir
   print "(1X,A,6(1X,I0))", "  jc = ", jc
   print "(1X,A,6(1X,'(',F8.4,',',F8.4,')'))", "  zval = ", zval
   print "()"
   deallocate( ir, jc, zval )

   ! to CSC format

   ncol = mfGet( mfShape(A), 2 )
   nnz = mfNnz(A)
   allocate( ir(nnz), jc(ncol+1), zval(nnz) )
   print "(/,A)", "*** test number 57 ***"
   call msSpExport( A, ir, jc, zval, format="CSC" )
   print *, "exporting 'A' to CSC format:"
   print "(1X,A,6(1X,I0))", "  ir = ", ir
   print "(1X,A,5(1X,I0))", "  jc = ", jc
   print "(1X,A,6(1X,'(',F8.4,',',F8.4,')'))", "  zval = ", zval
   print "()"
   deallocate( ir, jc, zval )

   ! to CSR format

   nrow = mfGet( mfShape(A), 1 )
   nnz = mfNnz(A)
   allocate( ir(nrow+1), jc(nnz), zval(nnz) )
   print "(/,A)", "*** test number 58 ***"
   call msSpExport( A, ir, jc, zval, format="CSR" )
   print *, "exporting 'A' to CSR format:"
   print "(1X,A,4(1X,I0))", "  ir = ", ir
   print "(1X,A,6(1X,I0))", "  jc = ", jc
   print "(1X,A,6(1X,'(',F8.4,',',F8.4,')'))", "  zval = ", zval
   print "()"
   deallocate( ir, jc, zval )

   ! msPointer ---------------------------------------------------------
   call print_separation("msPointer")

   ! real case

   A = mfSpEye(4)
   call msDisplay(A,"A = mfSpEye(4)")
   print "(/,A)", "*** test number 59 ***"
   call msPointer(A,f90_ptr_vec) ! f90_ptr_vec => A
   print "(1X,A,I0)", "size(f90_ptr_vec) = ", size(f90_ptr_vec)
   print "()"

   f90_ptr_vec(1) = 77
   print *, "'msPointer(A,f90_ptr_vec)'"
   print *, "'f90_ptr(1) = 77'"
   call msDisplay(A,"A")

   f90_ptr_vec(3) = -33
   print *, "'f90_ptr(3) = -33'"
   call msDisplay(A,"A")

   call msFreePointer(A,f90_ptr_vec) ! f90_ptr_vec => null()

   ! complex case

   A = mfSpEye(4,kind="complex")
   call msDisplay(A,"A = mfSpEye(4)")
   print "(/,A)", "*** test number 60 ***"
   call msPointer(A,f90_ptr_vec_cmplx) ! f90_ptr_vec_cmplx => A
   print "(1X,A,I0)", "size(f90_ptr_vec_cmplx) = ", size(f90_ptr_vec_cmplx)
   print "()"

   f90_ptr_vec_cmplx(1) = 77 - MF_I
   print *, "'msPointer(A,f90_ptr_vec_cmplx)'"
   print *, "'f90_ptr(1) = 77 - MF_I'"
   call msDisplay(A,"A")

   f90_ptr_vec_cmplx(3) = -33 + MF_I
   print *, "'f90_ptr(3) = -33 + MF_I'"
   call msDisplay(A,"A")

   call msFreePointer(A,f90_ptr_vec_cmplx) ! f90_ptr_vec_cmplx => null()

   ! mfIsSparse --------------------------------------------------------
   call print_separation("mfIsSparse")

   print "()"

   A = mfSparse(mfEye(2))
   print "(/,A)", "*** test number 61 ***"
   if( mfIsSparse(A) ) then
      print *, "ok, A is sparse."
   else
      print *, "bug ! A should be detected as sparse."
   end if
   print "()"

   A = mfSparse(mfEye(2)*MF_I)
   print "(/,A)", "*** test number 62 ***"
   if( mfIsSparse(A) ) then
      print *, "ok, A is sparse."
   else
      print *, "bug ! A should be detected as sparse."
   end if
   print "()"

   ! via a tempo
   ! (some compilers don't support recursive IO)
   print "(/,A)", "*** test number 63 ***"
   bool = mfIsSparse(mfSparse(mfEye(2)))
   print *, "Is sparse 'sparse(eye(2))'?", bool
   print "()"

   ! via a tempo
   ! (some compilers don't support recursive IO)
   print "(/,A)", "*** test number 64 ***"
   bool = mfIsSparse(mfSparse(mfEye(2)*MF_I))
   print *, "Is sparse 'sparse(eye(2)*MF_I)'?", bool
   print "()"

   ! mfFull ------------------------------------------------------------
   call print_separation("mfFull")

   A = mfSpEye(2,5)
   call msDisplay(A, "A = mfSpEye(2,5)")
   print "(/,A)", "*** test number 65 ***"
   call msDisplay(mfFull(A), "mfFull(A)")

   print "(/,A)", "*** test number 66 ***"
   call msDisplay(mfFull(mfSpEye(5,2)), "mfFull(mfSpEye(5,2))")

   ! A is already full, not tempo
   A = mfEye(3)
   call msDisplay(A, "A = mfEye(3)")
   print "(/,A)", "*** test number 67 ***"
   MsgLevel_save = mfGetMsgLevel()
   call msSetMsgLevel(1)
   call msDisplay(mfFull(A), "mfFull(A)")
   call msSetMsgLevel(MsgLevel_save)

   ! A is already full, tempo
   print "(/,A)", "*** test number 68 ***"
   MsgLevel_save = mfGetMsgLevel()
   call msSetMsgLevel(1)
   call msDisplay(mfFull(mfEye(3)), "mfFull(mfEye(3))")
   call msSetMsgLevel(MsgLevel_save)

   A = mfSpEye(2,5,kind='complex')
   call msDisplay(A, "A = mfSpEye(2,5,kind='complex')")
   print "(/,A)", "*** test number 69 ***"
   call msDisplay(mfFull(A), "mfFull(A)")

   print "(/,A)", "*** test number 70 ***"
   call msDisplay(mfFull(mfSpEye(5,2,kind='complex')),                  &
                 "mfFull(mfSpEye(5,2,kind='complex'))")

   ! A is already full, not tempo
   A = mfEye(3)*MF_I
   call msDisplay(A, "A = mfEye(3)*MF_I")
   print "(/,A)", "*** test number 71 ***"
   MsgLevel_save = mfGetMsgLevel()
   call msSetMsgLevel(1)
   call msDisplay(mfFull(A), "mfFull(A)")
   call msSetMsgLevel(MsgLevel_save)

   ! A is already full, tempo
   print "(/,A)", "*** test number 72 ***"
   MsgLevel_save = mfGetMsgLevel()
   call msSetMsgLevel(1)
   call msDisplay(mfFull(mfEye(3)*MF_I), "mfFull(mfEye(3)*MF_I)")
   call msSetMsgLevel(MsgLevel_save)

   ! mfSpAlloc ---------------------------------------------------------
   call print_separation("mfSpAlloc")

   print "()"

   ! real case

   ! zero matrix, 10x10, nz=0, nzmax=0
   print "(/,A)", "*** test number 73 ***"
   A = mfSpAlloc(10,10)
   print *, "A = mfSpAlloc(10,10)"
   call msDisplay(mfShape(A), "mfShape(A)")
   call msDisplay(mfSize(A), "mfSize(A)")
   call msDisplay(mfNzmax(A), "mfNzmax(A)")
   call msDisplay(mfNnz(A), "mfNnz(A)")
   print "()"

   ! zero matrix, 10x10, nz=0, nzmax=30, ncolmax=10
   print "(/,A)", "*** test number 74 ***"
   A = mfSpAlloc(10,10,nzmax=30)
   print *, "A = mfSpAlloc(10,10,nzmax=30)"
   call msDisplay(mfShape(A), "mfShape(A)")
   call msDisplay(mfSize(A), "mfSize(A)")
   call msDisplay(mfNzmax(A), "mfNzmax(A)")
   call msDisplay(mfNnz(A), "mfNnz(A)")
   print "()"

   ! zero matrix, 10x0, nz=0, nzmax=30, ncolmax=10
   print "(/,A)", "*** test number 75 ***"
   A = mfSpAlloc(10,0,nzmax=30,ncolmax=10)
   print *, "A = mfSpAlloc(10,0,nzmax=30,ncolmax=10)"
   call msDisplay(mfShape(A), "mfShape(A)")
   call msDisplay(mfSize(A), "mfSize(A)")
   call msDisplay(mfNzmax(A), "mfNzmax(A)")
   call msDisplay(mfNnz(A), "mfNnz(A)")
   print "()"

   ! complex case

   ! zero matrix, 10x10, nz=0, nzmax=0
   print "(/,A)", "*** test number 76 ***"
   A = mfSpAlloc(10,10,kind='complex')
   print *, "A = mfSpAlloc(10,10,kind='complex')"
   call msDisplay(mfShape(A), "mfShape(A)")
   call msDisplay(mfSize(A), "mfSize(A)")
   call msDisplay(mfNzmax(A), "mfNzmax(A)")
   call msDisplay(mfNnz(A), "mfNnz(A)")
   print "()"

   ! zero matrix, 10x10, nz=0, nzmax=30, ncolmax=10
   print "(/,A)", "*** test number 77 ***"
   A = mfSpAlloc(10,10,nzmax=30,kind='complex')
   print *, "A = mfSpAlloc(10,10,nzmax=30,kind='complex')"
   call msDisplay(mfShape(A), "mfShape(A)")
   call msDisplay(mfSize(A), "mfSize(A)")
   call msDisplay(mfNzmax(A), "mfNzmax(A)")
   call msDisplay(mfNnz(A), "mfNnz(A)")
   print "()"

   ! zero matrix, 10x0, nz=0, nzmax=30, ncolmax=10
   print "(/,A)", "*** test number 78 ***"
   A = mfSpAlloc(10,0,nzmax=30,ncolmax=10,kind='complex')
   print *, "A = mfSpAlloc(10,0,nzmax=30,ncolmax=10,kind='complex')"
   call msDisplay(mfShape(A), "mfShape(A)")
   call msDisplay(mfSize(A), "mfSize(A)")
   call msDisplay(mfNzmax(A), "mfNzmax(A)")
   call msDisplay(mfNnz(A), "mfNnz(A)")
   print "()"

   ! mfNnz -------------------------------------------------------------
   call print_separation("mfNnz")

   print "()"

   print "(/,A)", "*** test number 79 ***"
   A = mfEye(10) ! dense case
   print *, "A = mfEye(10)"
   call msDisplay(mfShape(A), "mfShape(A)")
   call msDisplay(mfSize(A), "mfSize(A)")
   call msDisplay(mfNnz(A), "mfNnz(A)") ! via a count
   print "()"

   print "(/,A)", "*** test number 80 ***"
   A = mfEye(10)*MF_I ! dense case
   print *, "A = mfEye(10)*MF_I"
   call msDisplay(mfShape(A), "mfShape(A)")
   call msDisplay(mfSize(A), "mfSize(A)")
   call msDisplay(mfNnz(A), "mfNnz(A)") ! via a count
   print "()"

   print "(/,A)", "*** test number 81 ***"
   A = mfSpEye(10) ! sparse case
   print *, "A = mfSpEye(10)"
   call msDisplay(mfShape(A), "mfShape(A)")
   call msDisplay(mfSize(A), "mfSize(A)")
   call msDisplay(mfNnz(A), "mfNnz(A)")
   print "()"

   print "(/,A)", "*** test number 82 ***"
   A = mfSpEye(10,kind='complex') ! sparse case
   print *, "A = mfSpEye(10,kind='complex')"
   call msDisplay(mfShape(A), "mfShape(A)")
   call msDisplay(mfSize(A), "mfSize(A)")
   call msDisplay(mfNnz(A), "mfNnz(A)")
   print "()"

   ! mfNzmax -----------------------------------------------------------
   call print_separation("mfNzmax")

   print "()"

   print "(/,A)", "*** test number 83 ***"
   A = mfSpEye(10)
   print *, "A = mfSpEye(10)"
   call msDisplay(mfShape(A), "mfShape(A)")
   call msDisplay(mfSize(A), "mfSize(A)")
   call msDisplay(mfNzmax(A), "mfNzmax(A)")
   print "()"

   print "(/,A)", "*** test number 84 ***"
   A = mfSpEye(10,kind='complex')
   print *, "A = mfSpEye(10,kind='complex')"
   call msDisplay(mfShape(A), "mfShape(A)")
   call msDisplay(mfSize(A), "mfSize(A)")
   call msDisplay(mfNzmax(A), "mfNzmax(A)")
   print "()"

   print "(/,A)", "*** test number 85 ***"
   A = mfSpAlloc(10,10,30)
   print *, "A = mfSpAlloc(10,10,30)"
   call msDisplay(mfShape(A), "mfShape(A)")
   call msDisplay(mfSize(A), "mfSize(A)")
   call msDisplay(mfNzmax(A), "mfNzmax(A)")
   print "()"

   print "(/,A)", "*** test number 86 ***"
   A = mfSpAlloc(10,10,30,kind='complex')
   print *, "A = mfSpAlloc(10,10,30,kind='complex')"
   call msDisplay(mfShape(A), "mfShape(A)")
   call msDisplay(mfSize(A), "mfSize(A)")
   call msDisplay(mfNzmax(A), "mfNzmax(A)")
   print "()"

   ! mfNcolmax ---------------------------------------------------------
   call print_separation("mfNcolmax")

   print "()"

   print "(/,A)", "*** test number 87 ***"
   A = mfSpEye(10)
   print *, "A = mfSpEye(10)"
   call msDisplay(mfShape(A), "mfShape(A)")
   call msDisplay(mfNcolmax(A), "mfNcolmax(A)")
   print "()"

   print "(/,A)", "*** test number 88 ***"
   A = mfSpEye(10,kind='complex')
   print *, "A = mfSpEye(10,kind='complex')"
   call msDisplay(mfShape(A), "mfShape(A)")
   call msDisplay(mfNcolmax(A), "mfNcolmax(A)")
   print "()"

   print "(/,A)", "*** test number 89 ***"
   A = mfSpAlloc(10,10,ncolmax=30)
   print *, "A = mfSpAlloc(10,10,30)"
   call msDisplay(mfShape(A), "mfShape(A)")
   call msDisplay(mfNcolmax(A), "mfNcolmax(A)")
   print "()"

   print "(/,A)", "*** test number 90 ***"
   A = mfSpAlloc(10,10,ncolmax=30,kind='complex')
   print *, "A = mfSpAlloc(10,10,30,kind='complex')"
   call msDisplay(mfShape(A), "mfShape(A)")
   call msDisplay(mfNcolmax(A), "mfNcolmax(A)")
   print "()"

   ! mfSpEye -----------------------------------------------------------
   call print_separation("mfSpEye")

   print "(/,A)", "*** test number 91 ***"
   A = mfSpEye( 5 )
   call msDisplay(A, "mfSpEye( 5 )")
   call msDisplay(mfFull(A), "")

   print "(/,A)", "*** test number 92 ***"
   A = mfSpEye( 6, 5 )
   call msDisplay(A, "mfSpEye( 6, 5 )")
   call msDisplay(mfFull(A), "")

   print "(/,A)", "*** test number 93 ***"
   A = mfSpEye( 5, 6 )
   call msDisplay(A, "mfSpEye( 5, 6 )")
   call msDisplay(mfFull(A), "")

   print "(/,A)", "*** test number 94 ***"
   call msDisplay(mfSpEye(2), "mfSpEye(2)")
   print "(/,A)", "*** test number 95 ***"
   call msDisplay(mfFull(mfSpEye(2)), "")

   print "(/,A)", "*** test number 96 ***"
   A = mfSpEye( 5, kind='complex' )
   call msDisplay(A, "mfSpEye( 5, kind='complex' )")
   call msDisplay(mfFull(A), "")

   print "(/,A)", "*** test number 97 ***"
   A = mfSpEye( 6, 5, kind='complex' )
   call msDisplay(A, "mfSpEye( 6, 5, kind='complex' )")
   call msDisplay(mfFull(A), "")

   print "(/,A)", "*** test number 98 ***"
   A = mfSpEye( 5, 6, kind='complex' )
   call msDisplay(A, "mfSpEye( 5, 6, kind='complex' )")
   call msDisplay(mfFull(A), "")

   print "(/,A)", "*** test number 99 ***"
   call msDisplay(mfSpEye(2,kind='complex'), "mfSpEye(2,kind='complex')")
   print "(/,A)", "*** test number 100 ***"
   call msDisplay(mfFull(mfSpEye(2,kind='complex')), "")

   ! mfSpOnes ----------------------------------------------------------
   call print_separation("mfSpOnes")

   ! A is real dense
   A = mfEye(3)*MF_PI
   call msDisplay(A, "A = mfEye(3)*MF_PI")

   print "(/,A)", "*** test number 101 ***"
   call msDisplay(mfSpOnes(A), "mfSpOnes(A)")
   call msDisplay(mfFull(mfSpOnes(A)), "")

   ! via a tempo
   print "(/,A)", "*** test number 102 ***"
   call msDisplay(mfSpOnes(mfEye(3)*MF_PI),                             &
                 "mfSpOnes(mfEye(3)*MF_PI)")
   print "(/,A)", "*** test number 103 ***"
   call msDisplay(mfFull(mfSpOnes(mfEye(3)*MF_PI)), "")

   ! A is complex dense
   A = mfEye(3)*MF_I
   call msDisplay(A, "A = mfEye(3)*MF_I")

   print "(/,A)", "*** test number 104 ***"
   call msDisplay(mfSpOnes(A), "mfSpOnes(A)")
   print "(/,A)", "*** test number 105 ***"
   call msDisplay(mfFull(mfSpOnes(A)), "")

   ! via a tempo
   print "(/,A)", "*** test number 106 ***"
   call msDisplay(mfSpOnes(mfEye(3)*MF_I),                              &
                 "mfSpOnes(mfEye(3)*MF_I)")
   print "(/,A)", "*** test number 107 ***"
   call msDisplay(mfFull(mfSpOnes(mfEye(3)*MF_I)), "")

   ! A is real sparse
   A = mfSpEye(3)*MF_PI
   call msDisplay(A, "A = mfSpEye(3)*MF_PI")
   call msDisplay(mfFull(A), "")

   print "(/,A)", "*** test number 108 ***"
   call msDisplay(mfSpOnes(A), "mfSpOnes(A)")
   print "(/,A)", "*** test number 109 ***"
   call msDisplay(mfFull(mfSpOnes(A)), "")

   ! via a tempo
   print "(/,A)", "*** test number 110 ***"
   call msDisplay(mfSpOnes(mfSpEye(3)*MF_PI),                           &
                 "mfSpOnes(mfSpEye(3)*MF_PI)")
   print "(/,A)", "*** test number 111 ***"
   call msDisplay(mfFull(mfSpOnes(mfSpEye(3)*MF_PI)), "")

   ! A is complex sparse
   A = mfSpEye(3)*MF_I
   call msDisplay(A, "A = mfSpEye(3)*MF_I")
   call msDisplay(mfFull(A), "")

   print "(/,A)", "*** test number 112 ***"
   call msDisplay(mfSpOnes(A), "mfSpOnes(A)")
   print "(/,A)", "*** test number 113 ***"
   call msDisplay(mfFull(mfSpOnes(A)), "")

   ! via a tempo
   print "(/,A)", "*** test number 114 ***"
   call msDisplay(mfSpOnes(mfSpEye(3)*MF_I),                            &
                 "mfSpOnes(mfSpEye(3)*MF_I)")
   print "(/,A)", "*** test number 115 ***"
   call msDisplay(mfFull(mfSpOnes(mfSpEye(3)*MF_I)), "")

   ! mfSpRand ----------------------------------------------------------
   call print_separation("mfSpRand")

   A = mfSpEye( 3 )
   print "(/,A)", "*** test number 116 ***"
   x = mfSpRand(A)
   call msDisplay(x,"mfSpRand(A)")

   print "(/,A)", "*** test number 117 ***"
   x = mfSpRand(10,7,0.1d0)
   call msDisplay( x, "x = mfSpRand(10,7,0.1d0)" )
   call msDisplay(mfFull(x), "")
   call msDisplay( mfSize(x)*0.1, "mfSize(x)*0.1" )
   call msDisplay( mfNnz(x), "mfNnz(x)" )

   ! mfSpRandN ---------------------------------------------------------
   call print_separation("mfSpRandN")

   A = mfSpEye( 3 )
   print "(/,A)", "*** test number 118 ***"
   x = mfSpRandN(A)
   call msDisplay(x,"mfSpRandN(A)")

   print "(/,A)", "*** test number 119 ***"
   x = mfSpRandN(10,7,0.1d0)
   call msDisplay( x, "x = mfSpRandN(10,7,0.1d0)" )
   call msDisplay(mfFull(x), "")
   call msDisplay( mfSize(x)*0.1, "mfSize(x)*0.1" )
   call msDisplay( mfNnz(x), "mfNnz(x)" )

   ! operator(+) -------------------------------------------------------
   call print_separation("operator(+)")

   ! --- real/real case --------------------------
   A = mfSpEye( 3 )
   call msDisplay(A, "A")

   print "(/,A)", "*** test number 120 ***"
   B = + A
   call msDisplay(B, "B = + A")

   call msRelease(A)
   call msDisplay(B, "B")

   print "(/,A)", "*** test number 121 ***"
   B = + mfSpEye( 3 )
   call msDisplay(B, "B = + mfSpEye( 3 )")

   A = mfSpEye( 3 )
   print "(/,A)", "*** test number 122 ***"
   B = A + A
   call msDisplay(B, "B = A + A")

   print "(/,A)", "*** test number 123 ***"
   call msDisplay(A+A, "A + A")

   allocate( ir(4), jc(4), val(4) )
   ir(:) = [ 2, 3, 4, 1 ]
   jc(:) = [ 2, 4, 3, 3 ]
   val(:) = [ -1.0d0, -1.0d0, -1.0d0, -1.0d0 ]

   A = mfSpImport(ir,jc,val)
   call msDisplay(A, "A = mfSpImport(ir,jc,val)")
   call msDisplay(mfFull(A), "")

   deallocate( ir, jc, val )

   print "(/,A)", "*** test number 124 ***"
   B = A + mfSpEye(4)
   call msDisplay(B, "B = A + mfSpEye(4)")
   call msDisplay(mfFull(B), "")

   ! forcing not sorting the columns of the first operand
   call msSetAutoRowSorted( .false. )
   allocate( ir(4), jc(4), val(4) )
   ir(:) = [ 2, 3, 4, 1 ]
   jc(:) = [ 2, 4, 3, 3 ]
   val(:) = [ -1.0d0, -2.0d0, -3.0d0, -4.0d0 ]

   A = mfSpImport(ir,jc,val)
   print *, 'mfIsRowSorted(A) = ', mfIsRowSorted(A)
   call msDisplay(A, "A = mfSpImport(ir,jc,val)")
   call msDisplay(mfFull(A), "")

   deallocate( ir, jc, val )

   print "(/,A)", "*** test number 125 ***"
   B = A + mfSpEye(4)
   call msDisplay(B, "B = A + mfSpEye(4)")
   call msDisplay(mfFull(B), "")
   call msSetAutoRowSorted( .true. )

   ! forcing not sorting the columns of the second operand
   call msSetAutoRowSorted( .false. )
   allocate( ir(4), jc(4), val(4) )
   ir(:) = [ 2, 3, 4, 1 ]
   jc(:) = [ 2, 4, 3, 3 ]
   val(:) = [ -1.0d0, -2.0d0, -3.0d0, -4.0d0 ]

   A = mfSpImport(ir,jc,val)
   print *, 'mfIsRowSorted(A) = ', mfIsRowSorted(A)
   call msSetAutoRowSorted( .true. )
   call msDisplay(A, "A = mfSpImport(ir,jc,val)")
   call msDisplay(mfFull(A), "")

   deallocate( ir, jc, val )

   print "(/,A)", "*** test number 126 ***"
   B = mfSpEye(4) + A
   call msDisplay(B, "B = mfSpEye(4) + A")
   call msDisplay(mfFull(B), "")

   ! forcing not sorting the columns of at least one operand (tempo)
   ! -> one warning
   call msSetAutoRowSorted( .false. )
   allocate( ir(4), jc(4), val(4) )
   ir(:) = [ 2, 3, 4, 1 ]
   jc(:) = [ 2, 4, 3, 3 ]
   val(:) = [ -1.0d0, -2.0d0, -3.0d0, -4.0d0 ]

   print "(/,A)", "*** test number 127 ***"
   B = mfSpImport(ir,jc,val) + mfSpEye(4)
   print *, 'mfIsRowSorted(B) = ', mfIsRowSorted(B)
   call msDisplay(B, "B = mfSpImport(ir,jc,val) + mfSpEye(4)")
   call msDisplay(mfFull(B), "")
   call msSetAutoRowSorted( .true. )
   deallocate( ir, jc, val )

   ! --- cmplx/cmplx case
   A = mfSpEye( 3, kind='complex' )
   call msDisplay(A, "A")

   print "(/,A)", "*** test number 128 ***"
   B = + A
   call msDisplay(B, "B = + A")

   call msRelease(A)
   call msDisplay(B, "B")

   print "(/,A)", "*** test number 129 ***"
   B = + mfSpEye( 3, kind='complex' )
   call msDisplay(B, "B = + mfSpEye( 3, kind='complex' )")

   A = mfSpEye( 3, kind='complex' )
   print "(/,A)", "*** test number 130 ***"
   B = A + A
   call msDisplay(B, "B = A + A")

   print "(/,A)", "*** test number 131 ***"
   call msDisplay(A+A, "A + A")

   ! forcing not sorting the columns of the first operand
   call msSetAutoRowSorted( .false. )
   allocate( ir(4), jc(4), zval(4) )
   ir(:) = [ 2, 3, 4, 1 ]
   jc(:) = [ 2, 4, 3, 3 ]
   zval(:) = [ -1.0d0, -2.0d0, -3.0d0, -4.0d0 ]

   A = mfSpImport(ir,jc,zval)
   print *, 'mfIsRowSorted(A) = ', mfIsRowSorted(A)
   call msSetAutoRowSorted( .true. )
   call msDisplay(A, "A = mfSpImport(ir,jc,zval)")
   call msDisplay(mfFull(A), "")

   deallocate( ir, jc, zval )

   print "(/,A)", "*** test number 132 ***"
   B = A + mfSpEye(4, kind='complex')
   call msDisplay(B, "B = A + mfSpEye(4, kind='complex')")
   call msDisplay(mfFull(B), "")

   ! forcing not sorting the columns of the second operand
   call msSetAutoRowSorted( .false. )
   allocate( ir(4), jc(4), zval(4) )
   ir(:) = [ 2, 3, 4, 1 ]
   jc(:) = [ 2, 4, 3, 3 ]
   zval(:) = [ -1.0d0, -2.0d0, -3.0d0, -4.0d0 ]

   A = mfSpImport(ir,jc,zval)
   print *, 'mfIsRowSorted(A) = ', mfIsRowSorted(A)
   call msSetAutoRowSorted( .true. )
   call msDisplay(A, "A = mfSpImport(ir,jc,zval)")
   call msDisplay(mfFull(A), "")

   deallocate( ir, jc, zval )

   print "(/,A)", "*** test number 133 ***"
   B = mfSpEye(4, kind='complex') + A
   call msDisplay(B, "B = mfSpEye(4, kind='complex') + A")
   call msDisplay(mfFull(B), "")

   ! forcing not sorting the columns of at least one operand (tempo)
   ! -> one warning
   call msSetAutoRowSorted( .false. )
   allocate( ir(4), jc(4), zval(4) )
   ir(:) = [ 2, 3, 4, 1 ]
   jc(:) = [ 2, 4, 3, 3 ]
   zval(:) = [ -1.0d0, -2.0d0, -3.0d0, -4.0d0 ]

   print "(/,A)", "*** test number 134 ***"
   B = mfSpImport(ir,jc,zval) + mfSpEye(4, kind='complex')
   print *, 'mfIsRowSorted(B) = ', mfIsRowSorted(B)
   call msDisplay(B, "B = mfSpImport(ir,jc,zval) + mfSpEye(4, kind='complex')")
   call msDisplay(mfFull(B), "")
   call msSetAutoRowSorted( .true. )
   deallocate( ir, jc, zval )

   ! --- real/complex case
   A = mfSpEye( 3 )
   B = mfSpEye( 3, kind='complex' )
   print "(/,A)", "*** test number 135 ***"
   C = A + B
   call msDisplay(C, "C = A + B")

   ! forcing not sorting the columns of the first operand
   call msSetAutoRowSorted( .false. )
   allocate( ir(4), jc(4), val(4) )
   ir(:) = [ 2, 3, 4, 1 ]
   jc(:) = [ 2, 4, 3, 3 ]
   val(:) = [ -1.0d0, -2.0d0, -3.0d0, -4.0d0 ]

   A = mfSpImport(ir,jc,val)
   print *, 'mfIsRowSorted(A) = ', mfIsRowSorted(A)
   call msSetAutoRowSorted( .true. )
   call msDisplay(A, "A = mfSpImport(ir,jc,val)")
   call msDisplay(mfFull(A), "")

   deallocate( ir, jc, val )

   print "(/,A)", "*** test number 136 ***"
   B = A + mfSpEye( 4, kind='complex' )
   call msDisplay(B, "B = A + mfSpEye(4,kind='complex')")
   call msDisplay(mfFull(B), "")

   ! forcing not sorting the columns of the second operand
   call msSetAutoRowSorted( .false. )
   allocate( ir(4), jc(4), zval(4) )
   ir(:) = [ 2, 3, 4, 1 ]
   jc(:) = [ 2, 4, 3, 3 ]
   zval(:) = [ -1.0d0, -2.0d0, -3.0d0, -4.0d0 ]

   A = mfSpImport(ir,jc,zval)
   print *, 'mfIsRowSorted(A) = ', mfIsRowSorted(A)
   call msSetAutoRowSorted( .true. )
   call msDisplay(A, "A = mfSpImport(ir,jc,zval)")
   call msDisplay(mfFull(A), "")

   deallocate( ir, jc, zval )

   print "(/,A)", "*** test number 137 ***"
   B = mfSpEye(4) + A
   call msDisplay(B, "B = mfSpEye(4) + A")
   call msDisplay(mfFull(B), "")

   ! forcing not sorting the columns of at least one operand (tempo)
   ! -> one warning
   call msSetAutoRowSorted( .false. )
   allocate( ir(4), jc(4), val(4) )
   ir(:) = [ 2, 3, 4, 1 ]
   jc(:) = [ 2, 4, 3, 3 ]
   val(:) = [ -1.0d0, -2.0d0, -3.0d0, -4.0d0 ]

   print "(/,A)", "*** test number 138 ***"
   B = mfSpImport(ir,jc,val) + mfSpEye(4, kind='complex')
   print *, 'mfIsRowSorted(B) = ', mfIsRowSorted(B)
   call msDisplay(B, "B = mfSpImport(ir,jc,val) + mfSpEye(4, kind='complex')")
   call msDisplay(mfFull(B), "")
   call msSetAutoRowSorted( .true. )
   deallocate( ir, jc, val )

   ! --- complex/real case
   A = mfSpEye( 3, kind='complex' )
   B = mfSpEye( 3 )
   print "(/,A)", "*** test number 139 ***"
   C = A + B
   call msDisplay(C, "C = A + B")

   ! forcing not sorting the columns of the first operand
   call msSetAutoRowSorted( .false. )
   allocate( ir(4), jc(4), zval(4) )
   ir(:) = [ 2, 3, 4, 1 ]
   jc(:) = [ 2, 4, 3, 3 ]
   zval(:) = [ -1.0d0, -2.0d0, -3.0d0, -4.0d0 ]

   B = mfSpImport(ir,jc,zval)
   print *, 'mfIsRowSorted(B) = ', mfIsRowSorted(B)
   call msSetAutoRowSorted( .true. )
   call msDisplay(B, "B = mfSpImport(ir,jc,zval)")
   call msDisplay(mfFull(B), "")

   deallocate( ir, jc, zval )

   print "(/,A)", "*** test number 140 ***"
   B = B + mfSpEye( 4 )
   call msDisplay(B, "B = B + mfSpEye(4)")
   call msDisplay(mfFull(B), "")

   ! forcing not sorting the columns of the second operand
   call msSetAutoRowSorted( .false. )
   allocate( ir(4), jc(4), val(4) )
   ir(:) = [ 2, 3, 4, 1 ]
   jc(:) = [ 2, 4, 3, 3 ]
   val(:) = [ -1.0d0, -2.0d0, -3.0d0, -4.0d0 ]

   A = mfSpImport(ir,jc,val)
   print *, 'mfIsRowSorted(A) = ', mfIsRowSorted(A)
   call msSetAutoRowSorted( .true. )
   call msDisplay(A, "A = mfSpImport(ir,jc,val)")
   call msDisplay(mfFull(A), "")

   deallocate( ir, jc, val )

   print "(/,A)", "*** test number 141 ***"
   B = mfSpEye(4,kind='complex') + A
   call msDisplay(B, "B = mfSpEye(4) + A")
   call msDisplay(mfFull(B), "")

   ! forcing not sorting the columns of at least one operand (tempo)
   ! -> one warning
   call msSetAutoRowSorted( .false. )
   allocate( ir(4), jc(4), zval(4) )
   ir(:) = [ 2, 3, 4, 1 ]
   jc(:) = [ 2, 4, 3, 3 ]
   zval(:) = [ -1.0d0, -2.0d0, -3.0d0, -4.0d0 ]

   print "(/,A)", "*** test number 142 ***"
   B = mfSpImport(ir,jc,zval) + mfSpEye(4)
   print *, 'mfIsRowSorted(B) = ', mfIsRowSorted(B)
   call msDisplay(B, "B = mfSpImport(ir,jc,zval) + mfSpEye(4)")
   call msDisplay(mfFull(B), "")
   call msSetAutoRowSorted( .true. )
   deallocate( ir, jc, zval )

   ! operator(-) -------------------------------------------------------
   call print_separation("operator(-)")

   ! --- real/real case
   print "(/,A)", "*** test number 143 ***"
   A = mfSpEye( 3 )
   call msDisplay(A, "A")
   B = - A
   call msDisplay(B, "B = - A")

   print "(/,A)", "*** test number 144 ***"
   call msRelease(A)
   call msDisplay(B, "B")

   print "(/,A)", "*** test number 145 ***"
   B = - mfSpEye( 3 )
   call msDisplay(B, "B = - mfSpEye( 3 )")

   print "(/,A)", "*** test number 146 ***"
   A = mfSpEye(3)
   print *, "A = mfSpEye(3)"
   B = A - A
   call msDisplay(B, "B = A - A")

   print "(/,A)", "*** test number 147 ***"
   call msDisplay(A-A, "A - A")

   allocate( ir(3), jc(3), val(3) )
   ir(:) = [ 2, 3, 4 ]
   jc(:) = [ 2, 4, 3 ]
   val(:) = [ 1.0d0, 2.0d0, 3.0d0 ]
   A = mfSpImport(ir,jc,val)
   call msDisplay(A, "A = mfSpImport(ir,jc,val)")
   call msDisplay(mfFull(A), "")
   deallocate( ir, jc, val )

   print "(/,A)", "*** test number 148 ***"
   B = mfSpEye(4) - A
   call msDisplay(B, "B = mfSpEye(4) - A")
   call msDisplay(mfFull(B), "")

   ! --- cmplx/cmplx case
   A = mfSpEye( 3, kind='complex' )
   call msDisplay(A, "A")

   print "(/,A)", "*** test number 149 ***"
   B = - A
   call msDisplay(B, "B = - A")

   call msRelease(A)
   call msDisplay(B, "B")

   print "(/,A)", "*** test number 150 ***"
   B = - mfSpEye( 3, kind='complex' )
   call msDisplay(B, "B = - mfSpEye( 3, kind='complex' )")

   A = mfSpEye( 3, kind='complex' )
   print "(/,A)", "*** test number 151 ***"
   B = A - A
   call msDisplay(B, "B = A - A")

   call msDisplay(A-A, "A - A")

   ! --- real/complex case
   A = mfSpEye( 3 )
   B = mfSpEye( 3, kind='complex' )
   print "(/,A)", "*** test number 152 ***"
   C = A - B
   call msDisplay(C, "C = A - B")

   ! --- complex/real case
   A = mfSpEye( 3, kind='complex' )
   B = mfSpEye( 3 )
   print "(/,A)", "*** test number 153 ***"
   C = A - B
   call msDisplay(C, "C = A - B")

   ! operator(*) -------------------------------------------------------
   call print_separation("operator(*)")

   ! --- real scalar & real sparse
   A = mfSpEye( 3 )
   call msDisplay(A, "A")

   print "(/,A)", "*** test number 154 ***"
   B = 2.0d0 * A
   call msDisplay(B, "B = 2.0d0 * A")

   print "(/,A)", "*** test number 155 ***"
   B = A * (-2.0d0)
   call msDisplay(B, "B = A * (-2.0d0)")

   ! --- complex scalar & real sparse
   A = mfSpEye( 3 )
   call msDisplay(A, "A")

   print "(/,A)", "*** test number 156 ***"
   B = MF_I * A
   call msDisplay(B, "B = MF_I * A")

   print "(/,A)", "*** test number 157 ***"
   B = A * (-MF_I)
   call zeroes_small_values( B, 10.0d0*MF_EPS )
   call msDisplay(B, "B = A * (-MF_I)")

   ! --- real scalar & complex sparse
   A = mfSpEye( 3, kind='complex' )
   call msDisplay(A, "A")

   print "(/,A)", "*** test number 158 ***"
   B = 2.0d0 * A
   call msDisplay(B, "B = 2.0d0 * A")

   print "(/,A)", "*** test number 159 ***"
   B = A * (-2.0d0)
   call zeroes_small_values( B, 10.0d0*MF_EPS )
   call msDisplay(B, "B = A * (-2.0d0)")

   ! --- complex scalar & complex sparse
   A = mfSpEye( 3, kind='complex' )
   call msDisplay(A, "A")

   print "(/,A)", "*** test number 160 ***"
   B = MF_I * A
   call msDisplay(B, "B = MF_I * A")

   print "(/,A)", "*** test number 161 ***"
   B = A * (-MF_I)
   call msDisplay(B, "B = A * (-MF_I)")

   ! mfMul -------------------------------------------------------------
   call print_separation("mfMul")

   !------ matrix * vector

   ! --- real sparse & real vector
   A = mfSpEye(3)
   call msDisplay(A, "A = mfSpEye(3)")
   call msDisplay(mfFull(A), "")

   v = .t.[ 0.1d0, 0.2d0, 0.3d0 ]
   call msDisplay(v, "v")

   print "(/,A)", "*** test number 162 ***"
   B = mfMul( A, v )
   call msDisplay(B, "B = mfMul( A, v )")

   allocate( ir(3), jc(3), val(3) )
   ir(:) = [ 2, 3, 4 ]
   jc(:) = [ 2, 4, 3 ]
   val(:) = [ 1.0d0, 2.0d0, 3.0d0 ]

   A = mfSpImport(ir,jc,val)
   call msDisplay(A, "A = mfSpImport(ir,jc,val)")
   call msDisplay(mfFull(A), "")

   deallocate( ir, jc, val )

   ! getting the 2nd col of A
   print "(/,A)", "*** test number 163 ***"
   B = mfMul( A, .t.[ 0.0d0, 1.0d0, 0.0d0, 0.0d0 ] )
   call msDisplay(B, "B = mfMul( A, .t.[ 0.0d0, 1.0d0, 0.0d0, 0.0d0 ] )")

   ! getting the 3rd col of A
   print "(/,A)", "*** test number 164 ***"
   B = mfMul( A, .t.[ 0.0d0, 0.0d0, 1.0d0, 0.0d0 ] )
   call msDisplay(B, "B = mfMul( A, .t.[ 0.0d0, 1.0d0, 0.0d0, 0.0d0 ] )")

   ! --- real sparse & complex vector
   A = mfSpEye(3)
   call msDisplay(A, "A = mfSpEye(3)")
   call msDisplay(mfFull(A), "")

   v = .t.[ 0.1d0, 0.2d0, 0.3d0 ] * MF_I
   call msDisplay(v, "v")

   print "(/,A)", "*** test number 165 ***"
   B = mfMul( A, v )
   call msDisplay(B, "B = mfMul( A, v )")

   ! --- complex sparse & real vector
   A = mfSpEye(3,kind='complex')
   call msDisplay(A, "A = mfSpEye(3,kind='complex')")
   call msDisplay(mfFull(A), "")

   v = .t.[ 0.1d0, 0.2d0, 0.3d0 ]
   call msDisplay(v, "v")

   print "(/,A)", "*** test number 166 ***"
   B = mfMul( A, v )
   call msDisplay(B, "B = mfMul( A, v )")

   ! --- complex sparse & complex vector
   A = mfSpEye(3,kind='complex')
   call msDisplay(A, "A = mfSpEye(3,kind='complex')")
   call msDisplay(mfFull(A), "")

   v = .t.[ 0.1d0, 0.2d0, 0.3d0 ] * MF_I
   call msDisplay(v, "v")

   print "(/,A)", "*** test number 167 ***"
   B = mfMul( A, v )
   call msDisplay(B, "B = mfMul( A, v )")

   !------ vector * matrix

   ! --- real vector & real sparse
   A = mfSpEye(3)
   call msDisplay(A, "A = mfSpEye(3)")
   call msDisplay(mfFull(A), "")

   v = [ 0.1d0, 0.2d0, 0.3d0 ]
   call msDisplay(v, "v")

   print "(/,A)", "*** test number 168 ***"
   B = mfMul( v, A )
   call msDisplay(B, "B = mfMul( v, A )")

   ! --- complex vector & real sparse
   A = mfSpEye(3)
   call msDisplay(A, "A = mfSpEye(3)")
   call msDisplay(mfFull(A), "")

   v = [ 0.1d0, 0.2d0, 0.3d0 ] * MF_I
   call msDisplay(v, "v")

   print "(/,A)", "*** test number 169 ***"
   B = mfMul( v, A )
   call msDisplay(B, "B = mfMul( v, A )")

   ! --- complex vector & complex sparse
   A = mfSpEye(3,kind='complex')
   call msDisplay(A, "A = mfSpEye(3,kind='complex')")
   call msDisplay(mfFull(A), "")

   v = [ 0.1d0, 0.2d0, 0.3d0 ] * MF_I
   call msDisplay(v, "v")

   print "(/,A)", "*** test number 170 ***"
   B = mfMul( v, A )
   call msDisplay(B, "B = mfMul( v, A )")

   !------ matrix * matrix

   ! --- real sparse & real sparse
   A = mfSpEye(5)
   print *, "A = mfSpEye(5)"

   ! B is 5x5
   allocate( ir(12), jc(12), val(12) )
   ir(:) = [ 1, 2, 1, 3, 5, 2, 3, 4, 5, 3, 2, 5 ]
   jc(:) = [ 1, 1, 2, 2, 2, 3, 3, 3, 3, 4, 5, 5 ]
   val(:) = [ 2.0d0, 3.0d0, 3.0d0, -1.0d0, 4.0d0, 4.0d0, -3.0d0,        &
               1.0d0, 2.0d0, 2.0d0, 6.0d0, 1.0d0 ]

   B = mfSpImport(ir,jc,val)
   print *, "B = mfSpImport(ir,jc,val)"
   call msDisplay(mfFull(B), "mfFull(B)")

   deallocate( ir, jc, val )

   print "(/,A)", "*** test number 171 ***"
   C = mfMul( A, B )
   call msDisplay(C, "C = mfMul(A, B )")
   call msDisplay(mfFull(C), "")

   ! ---
   A = mfSpEye(3,5)
   print *, "A = mfSpEye(3,5)"

   ! B is 5x4
   allocate( ir(12), jc(12), val(12) )
   ir(:) = [ 1, 2, 1, 3, 5, 2, 3, 4, 5, 3, 2, 5 ]
   jc(:) = [ 1, 1, 2, 2, 2, 3, 3, 3, 3, 4, 4, 4 ]
   val(:) = [ 2.0d0, 3.0d0, 3.0d0, -1.0d0, 4.0d0, 4.0d0, -3.0d0,        &
               1.0d0, 2.0d0, 2.0d0, 6.0d0, 1.0d0 ]

   B = mfSpImport(ir,jc,val)
   print *, "B = mfSpImport(ir,jc,val)"
   call msDisplay(mfFull(B), "mfFull(B)")

   deallocate( ir, jc, val )

   print "(/,A)", "*** test number 172 ***"
   C = mfMul( A, B )
   call msDisplay(C, "C = mfMul(A, B )")
   call msDisplay(mfFull(C), "")

   ! ---
   A = mfSpEye(5,3)
   print *, "A = mfSpEye(5,3)"

   ! B is 3x4
   allocate( ir(6), jc(6), val(6) )
   ir(:) = [ 1, 2, 1, 3, 2, 1 ]
   jc(:) = [ 1, 4, 2, 1, 2, 3 ]
   val(:) = [ 2.0d0, 3.0d0, 3.0d0, -1.0d0, 4.0d0, 4.0d0 ]

   B = mfSpImport(ir,jc,val)
   print *, "B = mfSpImport(ir,jc,val)"
   call msDisplay(mfFull(B), "mfFull(B)")

   deallocate( ir, jc, val )

   print "(/,A)", "*** test number 173 ***"
   C = mfMul( A, B )
   call msDisplay(C, "C = mfMul(A, B )")
   call msDisplay(mfFull(C), "")

   ! --- real sparse & complex sparse
   A = mfSpEye(5)
   print *, "A = mfSpEye(5)"

   ! B is 5x5
   allocate( ir(12), jc(12), val(12) )
   ir(:) = [ 1, 2, 1, 3, 5, 2, 3, 4, 5, 3, 2, 5 ]
   jc(:) = [ 1, 1, 2, 2, 2, 3, 3, 3, 3, 4, 5, 5 ]
   val(:) = [ 2.0d0, 3.0d0, 3.0d0, -1.0d0, 4.0d0, 4.0d0, -3.0d0,        &
               1.0d0, 2.0d0, 2.0d0, 6.0d0, 1.0d0 ]

   B = mfSpImport(ir,jc,val)*MF_I
   print *, "B = mfSpImport(ir,jc,val)*MF_I"
   call msDisplay(mfFull(B), "mfFull(B)")

   deallocate( ir, jc, val )

   print "(/,A)", "*** test number 174 ***"
   C = mfMul( A, B )
   call zeroes_small_values( C, 10.0d0*MF_EPS )
   call msDisplay(C, "C = mfMul(A, B )")
   call msDisplay(mfFull(C), "")

   ! ---
   A = mfSpEye(3,5)
   print *, "A = mfSpEye(3,5)"

   ! B is 5x4
   allocate( ir(12), jc(12), val(12) )
   ir(:) = [ 1, 2, 1, 3, 5, 2, 3, 4, 5, 3, 2, 5 ]
   jc(:) = [ 1, 1, 2, 2, 2, 3, 3, 3, 3, 4, 4, 4 ]
   val(:) = [ 2.0d0, 3.0d0, 3.0d0, -1.0d0, 4.0d0, 4.0d0, -3.0d0,        &
               1.0d0, 2.0d0, 2.0d0, 6.0d0, 1.0d0 ]

   B = mfSpImport(ir,jc,val)*MF_I
   print *, "B = mfSpImport(ir,jc,val)*MF_I"
   call msDisplay(mfFull(B), "mfFull(B)")

   deallocate( ir, jc, val )

   print "(/,A)", "*** test number 175 ***"
   C = mfMul( A, B )
   call zeroes_small_values( C, 10.0d0*MF_EPS )
   call msDisplay(C, "C = mfMul(A, B )")
   call msDisplay(mfFull(C), "")

   ! ---
   A = mfSpEye(5,3)
   print *, "A = mfSpEye(5,3)"

   ! B is 3x4
   allocate( ir(6), jc(6), val(6) )
   ir(:) = [ 1, 2, 1, 3, 2, 1 ]
   jc(:) = [ 1, 4, 2, 1, 2, 3 ]
   val(:) = [ 2.0d0, 3.0d0, 3.0d0, -1.0d0, 4.0d0, 4.0d0 ]

   B = mfSpImport(ir,jc,val)*MF_I
   print *, "B = mfSpImport(ir,jc,val)*MF_I"
   call msDisplay(mfFull(B), "mfFull(B)")

   deallocate( ir, jc, val )

   print "(/,A)", "*** test number 176 ***"
   C = mfMul( A, B )
   call zeroes_small_values( C, 10.0d0*MF_EPS )
   call msDisplay(C, "C = mfMul(A, B )")
   call msDisplay(mfFull(C), "")

   ! --- complex sparse & real sparse
   A = mfSpEye(5,kind="complex")
   print *, "A = mfSpEye(5)"

   ! B is 5x5
   allocate( ir(12), jc(12), val(12) )
   ir(:) = [ 1, 2, 1, 3, 5, 2, 3, 4, 5, 3, 2, 5 ]
   jc(:) = [ 1, 1, 2, 2, 2, 3, 3, 3, 3, 4, 5, 5 ]
   val(:) = [ 2.0d0, 3.0d0, 3.0d0, -1.0d0, 4.0d0, 4.0d0, -3.0d0,        &
               1.0d0, 2.0d0, 2.0d0, 6.0d0, 1.0d0 ]

   B = mfSpImport(ir,jc,val)
   print *, "B = mfSpImport(ir,jc,val)"
   call msDisplay(mfFull(B), "mfFull(B)")

   deallocate( ir, jc, val )

   print "(/,A)", "*** test number 177 ***"
   C = mfMul( A, B )
   call msDisplay(C, "C = mfMul(A, B )")
   call msDisplay(mfFull(C), "")

   ! ---
   A = mfSpEye(3,5,kind="complex")
   print *, "A = mfSpEye(3,5)"

   ! B is 5x4
   allocate( ir(12), jc(12), val(12) )
   ir(:) = [ 1, 2, 1, 3, 5, 2, 3, 4, 5, 3, 2, 5 ]
   jc(:) = [ 1, 1, 2, 2, 2, 3, 3, 3, 3, 4, 4, 4 ]
   val(:) = [ 2.0d0, 3.0d0, 3.0d0, -1.0d0, 4.0d0, 4.0d0, -3.0d0,        &
               1.0d0, 2.0d0, 2.0d0, 6.0d0, 1.0d0 ]

   B = mfSpImport(ir,jc,val)
   print *, "B = mfSpImport(ir,jc,val)"
   call msDisplay(mfFull(B), "mfFull(B)")

   deallocate( ir, jc, val )

   print "(/,A)", "*** test number 178 ***"
   C = mfMul( A, B )
   call msDisplay(C, "C = mfMul(A, B )")
   call msDisplay(mfFull(C), "")

   ! ---
   A = mfSpEye(5,3,kind="complex")
   print *, "A = mfSpEye(5,3)"

   ! B is 3x4
   allocate( ir(6), jc(6), val(6) )
   ir(:) = [ 1, 2, 1, 3, 2, 1 ]
   jc(:) = [ 1, 4, 2, 1, 2, 3 ]
   val(:) = [ 2.0d0, 3.0d0, 3.0d0, -1.0d0, 4.0d0, 4.0d0 ]

   B = mfSpImport(ir,jc,val)
   print *, "B = mfSpImport(ir,jc,val)"
   call msDisplay(mfFull(B), "mfFull(B)")

   deallocate( ir, jc, val )

   print "(/,A)", "*** test number 179 ***"
   C = mfMul( A, B )
   call msDisplay(C, "C = mfMul(A, B )")
   call msDisplay(mfFull(C), "")

   ! --- complex sparse & complex sparse
   A = mfSpEye(5,kind="complex")
   print *, "A = mfSpEye(5)"

   ! B is 5x5
   allocate( ir(12), jc(12), val(12) )
   ir(:) = [ 1, 2, 1, 3, 5, 2, 3, 4, 5, 3, 2, 5 ]
   jc(:) = [ 1, 1, 2, 2, 2, 3, 3, 3, 3, 4, 5, 5 ]
   val(:) = [ 2.0d0, 3.0d0, 3.0d0, -1.0d0, 4.0d0, 4.0d0, -3.0d0,        &
               1.0d0, 2.0d0, 2.0d0, 6.0d0, 1.0d0 ]

   B = mfSpImport(ir,jc,val)*MF_I
   print *, "B = mfSpImport(ir,jc,val)*MF_I"
   call msDisplay(mfFull(B), "mfFull(B)")

   deallocate( ir, jc, val )

   print "(/,A)", "*** test number 180 ***"
   C = mfMul( A, B )
   call msDisplay(C, "C = mfMul(A, B )")
   call msDisplay(mfFull(C), "")

   ! ---
   A = mfSpEye(3,5,kind="complex")
   print *, "A = mfSpEye(3,5)"

   ! B is 5x4
   allocate( ir(12), jc(12), val(12) )
   ir(:) = [ 1, 2, 1, 3, 5, 2, 3, 4, 5, 3, 2, 5 ]
   jc(:) = [ 1, 1, 2, 2, 2, 3, 3, 3, 3, 4, 4, 4 ]
   val(:) = [ 2.0d0, 3.0d0, 3.0d0, -1.0d0, 4.0d0, 4.0d0, -3.0d0,        &
               1.0d0, 2.0d0, 2.0d0, 6.0d0, 1.0d0 ]

   B = mfSpImport(ir,jc,val)*MF_I
   print *, "B = mfSpImport(ir,jc,val)*MF_I"
   call msDisplay(mfFull(B), "mfFull(B)")

   deallocate( ir, jc, val )

   print "(/,A)", "*** test number 181 ***"
   C = mfMul( A, B )
   call msDisplay(C, "C = mfMul(A, B )")
   call msDisplay(mfFull(C), "")

   ! ---
   A = mfSpEye(5,3,kind="complex")
   print *, "A = mfSpEye(5,3)"

   ! B is 3x4
   allocate( ir(6), jc(6), val(6) )
   ir(:) = [ 1, 2, 1, 3, 2, 1 ]
   jc(:) = [ 1, 4, 2, 1, 2, 3 ]
   val(:) = [ 2.0d0, 3.0d0, 3.0d0, -1.0d0, 4.0d0, 4.0d0 ]

   B = mfSpImport(ir,jc,val)*MF_I
   print *, "B = mfSpImport(ir,jc,val)*MF_I"
   call msDisplay(mfFull(B), "mfFull(B)")

   deallocate( ir, jc, val )

   print "(/,A)", "*** test number 182 ***"
   C = mfMul( A, B )
   call msDisplay(C, "C = mfMul(A, B )")
   call msDisplay(mfFull(C), "")

   ! msSpReAlloc -------------------------------------------------------
   call print_separation("msSpReAlloc")

   print "(/,A)", "*** test number 183 ***"
   A = mfSpEye(5)
   print *, "A = mfSpEye(5)"
   call msDisplay(mfNzmax(A), "mfNzmax(A)")
   call msDisplay(mfNcolmax(A), "mfNcolmax(A)")
   print "()"

   print "(/,A)", "*** test number 184 ***"
   call msSpReAlloc( A, 1000 )
   print *, "'call msSpReAlloc( A, 1000 )'"
   call msDisplay(mfNzmax(A), "mfNzmax(A)")
   call msDisplay(mfNcolmax(A), "mfNcolmax(A)")
   print "()"

   print "(/,A)", "*** test number 185 ***"
   call msSpReAlloc( A, 5000, ncolmax=50 )
   print *, "'call msSpReAlloc( A, 5000, ncolmax=50 )'"
   call msDisplay(mfNzmax(A), "mfNzmax(A)")
   call msDisplay(mfNcolmax(A), "mfNcolmax(A)")
   print "()"

   print "(/,A)", "*** test number 186 ***"
   call msSpReAlloc(A, mfNnz(A))        ! pack to minimum size
   print *, "'call msSpReAlloc(A, mfNnz(A))'"
   call msDisplay(mfNzmax(A), "mfNzmax(A)")
   call msDisplay(mfNcolmax(A), "mfNcolmax(A)")
   print "()"

   ! easier way to pack to minimum size
   A = mfSpEye(5)
   print "(/,A)", "*** test number 187 ***"
   call msSpReAlloc( A, 5000, ncolmax=50 )
   call msDisplay(mfNzmax(A), "mfNzmax(A)")
   call msDisplay(mfNcolmax(A), "mfNcolmax(A)")

   print "(/,A)", "*** test number 188 ***"
   call msSpReAlloc( A, "minimal" )
   print *, "'call msSpReAlloc( A, ""minimal"" )'"
   call msDisplay(mfNzmax(A), "mfNzmax(A)")
   call msDisplay(mfNcolmax(A), "mfNcolmax(A)")

   ! mfSpDiags ---------------------------------------------------------
   call print_separation("mfSpDiags")

   ! --- real case

   v = .t. [ 1.0d0, 2.0d0, 3.0d0 ]
   call msDisplay(v,"v")

   print "(/,A)", "*** test number 189 ***"
   B = mfSpDiags( 3, 5, v, 0 )
   call msDisplay(B,"B = mfSpDiags( 3, 5, v, 0 )")
   call msDisplay(mfFull(B),"")

   print "(/,A)", "*** test number 190 ***"
   B = mfSpDiags( 3, 5, v, -1 )
   call msDisplay(B,"B = mfSpDiags( 3, 5, v, -1 )")
   call msDisplay(mfFull(B),"")

   print "(/,A)", "*** test number 191 ***"
   B = mfSpDiags( 3, 5, v, -2 )
   call msDisplay(B,"B = mfSpDiags( 3, 5, v, -2 )")
   call msDisplay(mfFull(B),"")

   print "(/,A)", "*** test number 192 ***"
   B = mfSpDiags( 3, 5, v, 1 )
   call msDisplay(B,"B = mfSpDiags( 3, 5, v, 1 )")
   call msDisplay(mfFull(B),"")

   print "(/,A)", "*** test number 193 ***"
   B = mfSpDiags( 3, 5, v, 3 )
   call msDisplay(B,"B = mfSpDiags( 3, 5, v, 3 )")
   call msDisplay(mfFull(B),"")

   print "(/,A)", "*** test number 194 ***"
   B = mfSpDiags( 5, 3, v, 0 )
   call msDisplay(B,"B = mfSpDiags( 5, 3, v, 0 )")
   call msDisplay(mfFull(B),"")

   print "(/,A)", "*** test number 195 ***"
   B = mfSpDiags( 5, 3, v, -2 )
   call msDisplay(B,"B = mfSpDiags( 5, 3, v, -2 )")
   call msDisplay(mfFull(B),"")

   print "(/,A)", "*** test number 196 ***"
   B = mfSpDiags( 5, 3, v, -3 )
   call msDisplay(B,"B = mfSpDiags( 5, 3, v, -3 )")
   call msDisplay(mfFull(B),"")

   print "(/,A)", "*** test number 197 ***"
   B = mfSpDiags( 5, 3, v, 1 )
   call msDisplay(B,"B = mfSpDiags( 5, 3, v, 1 )")
   call msDisplay(mfFull(B),"")

   n = 5
   v = mfOnes(n,1)
   call msDisplay(v,"v")

   ! one way to construct a tridiag system (with re-alloc !)
   print "(/,A)", "*** test number 198 ***"
   A = mfSpDiags( n, n,  2.0d0*v,  0 ) +                                &
       mfSpDiags( n, n, -1.0d0*v,  1 ) +                                &
       mfSpDiags( n, n, -1.0d0*v, -1 )
   call msDisplay(mfFull(A),"A")

   ! another way, with sufficient room
   ! (warning: we must suppose that sums are made from left to right !)
   A = mfSpAlloc(n,n,3*n)
   print "(/,A)", "*** test number 199 ***"
   A = A + mfSpDiags( n, n,  2.0d0*v,  0 ) +                            &
           mfSpDiags( n, n, -1.0d0*v,  1 ) +                            &
           mfSpDiags( n, n, -1.0d0*v, -1 )
   call msDisplay(mfFull(A),"A")
   call msDisplay(mfNnz(A), "mfNnz(A)")
   call msDisplay(mfNzmax(A), "mfNzmax(A)")
   call msSpReAlloc(A, mfNnz(A))        ! pack to minimum size
   call msDisplay(mfNzmax(A), "after repacking: mfNzmax(A)")
   print "()"
   print *, "after packing :"
   call msDisplay(mfNzmax(A), "mfNzmax(A)")
   print "()"

   ! yet another way
   A = mfSpDiags( 5, 5, mf([-1,2,-1]), [-1,0,1] )
   print "(/,A)", "*** test number 200 ***"
   call msDisplay(A,"A")
   call msDisplay(mfFull(A),"")
   call msDisplay(mfNnz(A), "mfNnz(A)")
   call msDisplay(mfNzmax(A), "mfNzmax(A)")

   v = .t. mf([ 1, 2, 3, 4, 5 ])
   v = v .hc. (-v) .hc. v
   call msDisplay(v,"v")
   A = mfSpDiags( 5, 5, v, [-2,0,1] )
   print "(/,A)", "*** test number 201 ***"
   call msDisplay(A,"A")
   call msDisplay(mfFull(A),"")
   call msDisplay(mfNnz(A), "mfNnz(A)")
   call msDisplay(mfNzmax(A), "mfNzmax(A)")

   ! verifying that null values doesn't lead to null entries
   v = mf([ 1, 0, 2, 0, 3 ]) .vc.                                       &
       mf([ 0, 4, 0, 5, 0 ]) .vc.                                       &
       mf([ 6, 0, 7, 0, 8 ])
   v = .t. v
   call msDisplay(v,"v")
   A = mfSpDiags( 5, 5, v, [-1,0,2] )
   print "(/,A)", "*** test number 202 ***"
   call msDisplay(A,"A")
   call msDisplay(mfFull(A),"")
   call msDisplay(mfNnz(A), "mfNnz(A)")
   call msDisplay(mfNzmax(A), "mfNzmax(A)")
   call msSpReAlloc(A, mfNnz(A))        ! pack to minimum size
   call msDisplay(mfNzmax(A), "after repacking: mfNzmax(A)")

   v = .t. [ 1.0d0, 0.0d0, 3.0d0, 0.0d0, 0.0d0 ]
   call msDisplay(v,"v")

   print "(/,A)", "*** test number 203 ***"
   A = mfSpDiags( 5, 5, v )
   call msDisplay(A,"A")
   call msDisplay(mfFull(A),"")

   print "(/,A)", "*** test number 204 ***"
   A = mfSpDiags( 5, 5, v, 2 )
   call msDisplay(A,"A")
   call msDisplay(mfFull(A),"")

   ! --- complex case

   v = .t. [ 1.0d0, 2.0d0, 3.0d0 ] * MF_I
   call msDisplay(v,"v")

   print "(/,A)", "*** test number 205 ***"
   B = mfSpDiags( 3, 5, v, 0 )
   call msDisplay(B,"B = mfSpDiags( 3, 5, v, 0 )")
   call msDisplay(mfFull(B),"")

   ! --- Simple use (one arg.)
   v = .t. [ 1.0d0, 2.0d0, 3.0d0 ]

   print "(/,A)", "*** test number 206 ***"
   A = mfSpDiags( v )
   call msDisplay(A,"A")
   call msDisplay(mfFull(A),"")

   v = v * MF_I

   print "(/,A)", "*** test number 207 ***"
   A = mfSpDiags( v )
   call msDisplay(A,"A")
   call msDisplay(mfFull(A),"")

   ! Transpose (.t. and .h.) -------------------------------------------
   call print_separation("Transpose (.t. and .h.)")

   allocate( ir(4), jc(4), val(4) )
   ir(:) = [ 2, 3, 4, 5 ]
   jc(:) = [ 2, 4, 3, 1 ]
   val(:) = [ 1.0d0, 2.0d0, 3.0d0, 4.0d0 ]

   A = mfSpImport(ir,jc,val)
   call msDisplay(A, "A = mfSpImport(ir,jc,val)")
   call msDisplay(mfFull(A), "")

   deallocate( ir, jc, val )

   B = mfSpEye(5,4) - A
   call msDisplay(B, "B = mfSpEye(5,4) - A")
   call msDisplay(mfFull(B), "")

   print "(/,A)", "*** test number 208 ***"
   C = .t. B
   call msDisplay(C,"C = .t. B")
   call msDisplay(mfFull(C),"")

   print "(/,A)", "*** test number 209 ***"
   C = .t.( B * MF_I )
   call msDisplay(C,"C = .t.( B * MF_I )")
   call msDisplay(mfFull(C),"")

   print "(/,A)", "*** test number 210 ***"
   MsgLevel_save = mfGetMsgLevel()
   call msSetMsgLevel(1)
   C = .h.( B * MF_I + mfSpEye(5,4) )
   call msDisplay(C,"C = .h.( B * MF_I + mfSpEye(5,4) )")
   call msSetMsgLevel(MsgLevel_save)
   call msDisplay(mfFull(C),"")

   ! mfLDiv ------------------------------------------------------------
   call print_separation("mfLDiv")

   ! --- real case

   !-- triangular systems
   allocate( ir(12), jc(12), val(12) )
   ir(:) = [ 1, 2, 1, 3, 5, 2, 3, 4, 5, 3, 2, 5 ]
   jc(:) = [ 1, 1, 2, 2, 2, 3, 3, 3, 3, 4, 5, 5 ]
   val(:) = [ 2.0d0, 3.0d0, 3.0d0, -1.0d0, 4.0d0, 4.0d0, -3.0d0,        &
              1.0d0, 2.0d0, 2.0d0,  6.0d0, 1.0d0 ]
   A = mfSpImport(ir,jc,val)
   deallocate( ir, jc, val )
   call msDisplay(A, "A = mfSpImport(ir,jc,val)")
   call msDisplay(mfFull(A), "")
   call msLU( mfOut(L,U), A )
   ! we are looking only for non-unit triangular systems
   call msDisplay(mfFull(U), "U")
   L = .t. U

   print "(/,A)", "*** test number 211 ***"
   b = mfMul( L, .t. mf( [ 1, 2, 3, 4, 5 ] ) )
   call msDisplay(b, "b [RHS]")
   x = mfLDiv( L, b )
   call msDisplay(x, "x [sol.]")

   print "(/,A)", "*** test number 212 ***"
   b = mfMul( U, .t. mf( [ 1, 2, 3, 4, 5 ] ) )
   call msDisplay(b, "b [RHS]")
   x = mfLDiv( U, b )
   call msDisplay(x, "x [sol.]")

   ! singular diagonal matrix
   A = mfSpEyE(5,5)
   call msSet( 0.0d0, A, 2, 2 )
   print "(/,A)", "*** test number 213 ***"
   call msDisplay(A, "A")
   call msDisplay(mfFull(A), "")
   print *, "mfIsDiag(A) = ", mfIsDiag(A)
   b = .t. mf( [ 1, 2, 3, 4, 5 ] )
   call msDisplay(b, "b [RHS]")
   call mf_save_and_disable_fpe( )
   x = mfLDiv( A, b )
   call msDisplay(x, "x [sol.]")
   call mf_restore_fpe( )

   ! singular lower triangular matrix
   allocate( ir(5), jc(5), val(5) )
   ir(:) = [ 1, 3, 5, 5, 4 ]
   jc(:) = [ 1, 3, 5, 2, 3 ]
   val(:) = [ 1.0d0, 3.0d0, 5.0d0, -1.0d0, -2.0d0 ]
   A = mfSpImport(ir,jc,val)
   deallocate( ir, jc, val )
   print "(/,A)", "*** test number 214 ***"
   call msDisplay(A, "A")
   call msDisplay(mfFull(A), "")
   print *, "mfIsTril(A) = ", mfIsTril(A)
   print *, "mfIsTriu(A) = ", mfIsTriu(A)
   b = .t. mf( [ 1, 2, 3, 4, 5 ] )
   call msDisplay(b, "b [RHS]")
   call mf_save_and_disable_fpe( )
   x = mfLDiv( A, b )
   call msDisplay(x, "x [sol.]")
   call mf_restore_fpe( )

   ! singular upper triangular matrix
   allocate( ir(5), jc(5), val(5) )
   ir(:) = [ 1, 3, 5, 5, 4 ]
   jc(:) = [ 1, 3, 5, 2, 3 ]
   val(:) = [ 1.0d0, 3.0d0, 5.0d0, -1.0d0, -2.0d0 ]
   A = .t. mfSpImport(ir,jc,val)
   deallocate( ir, jc, val )
   print "(/,A)", "*** test number 215 ***"
   call msDisplay(A, "A")
   call msDisplay(mfFull(A), "")
   print *, "mfIsTril(A) = ", mfIsTril(A)
   print *, "mfIsTriu(A) = ", mfIsTriu(A)
   b = .t. mf( [ 1, 2, 3, 4, 5 ] )
   call msDisplay(b, "b [RHS]")
   call mf_save_and_disable_fpe( )
   x = mfLDiv( A, b )
   call msDisplay(x, "x [sol.]")
   call mf_restore_fpe( )

   ! square system unsymmetric : UMFPACK

   ! same example as in doc of UMFPack-4
   allocate( ir(12), jc(12), val(12) )
   ir(:) = [ 1, 2, 1, 3, 5, 2, 3, 4, 5, 3, 2, 5 ]
   jc(:) = [ 1, 1, 2, 2, 2, 3, 3, 3, 3, 4, 5, 5 ]
   val(:) = [ 2.0d0, 3.0d0, 3.0d0, -1.0d0, 4.0d0, 4.0d0, -3.0d0,        &
              1.0d0, 2.0d0, 2.0d0,  6.0d0, 1.0d0 ]

   A = mfSpImport(ir,jc,val)
   call msDisplay(A, "A = mfSpImport(ir,jc,val) [ex. from doc of UMFPack-4]")
   call msDisplay(mfFull(A), "")

   deallocate( ir, jc, val )

   b = mfMul( A, .t. mf( [ 1, 2, 3, 4, 5 ] ) )
   call msDisplay(b, "b [RHS]")

   print "(/,A)", "*** test number 216 ***"
   x = mfLDiv( A, b )
   call msDisplay(x, "x [sol.]")

   ! after LU factorization (storing all factors)
   call msLU( mfOut(L,U,p,q,r), A )
   print *, "call msLU( mfOut(L,U,p,q,r), A )"
   x = mfMul(L,U)
!!   y = mfMul(mfMul(P,mfMul(R,A)),Q)
   y = mfRowScale(A,r)
   call msRowPerm(y,p)
   call msColPerm(y,q)
   call msDisplay( mfNorm(x-y), "|L*U - p*r*A*q|" )

   print "(/,A)", "*** test number 217 ***"
   x = mfLDiv( L, U, b )
   call msDisplay(x, "x [sol.]")

   ! see another test in 'msLU' section

   ! square system symmetric and pos. def.: CHOLMOD

   ! adding a unity diagonal: if not, cholmod cannot solve it,
   ! because it must not have zeros on the diagonal
   A = A + .t. A + mfSpEye(5)
   call msDisplay(A, "A (symmetric)")
   call msDisplay(mfFull(A), "")

   b = mfMul( A, .t. mf( [ 1, 2, 3, 4, 5 ] ) )
   call msDisplay(b, "b [RHS]")

   print "(/,A)", "*** test number 218 ***"
   x = mfLDiv( A, b )
   call msDisplay(x, "x [sol.]")

   ! over-determined system : m > n

   print "(/,A)", "*** test number 219 ***"
   allocate( ir(15), jc(15), val(15) )
   ir(:) = [ 1, 2, 4, 6, 5, 2, 7, 1, 5, 3, 6, 2, 3, 1, 3 ]
   jc(:) = [ 2, 3, 3, 3, 5, 1, 5, 1, 2, 4, 4, 5, 2, 3, 3 ]
   val(:) = [ 3.0d0, -3.0d0, 2.0d0, 3.0d0, 1.0d0,  3.0d0, 2.0d0,        &
              2.0d0,  4.0d0, 2.0d0, 3.0d0, 6.0d0, -1.0d0, 4.0d0, 1.0d0 ]

   A = mfSpImport(ir,jc,val)
   call msDisplay(A, "A = mfSpImport(ir,jc,val)")
   call msDisplay(mfFull(A), "")

   deallocate( ir, jc, val )

   b = mfMul( A, .t. mf( [ 1, 2, 3, 4, 5 ] ) )
   call msDisplay(b, "b [RHS]")

   x = mfLDiv( A, b )
   call msDisplay(x, "x [LSQ sol.]")

   call check_small( mfNorm(mfMul(A,x)-b), "| A*x - b |",               &
                     1.0d2*MF_EPS )

   ! under-determined system : m < n

   print "(/,A)", "*** test number 220 ***"
   allocate( ir(9), jc(9), val(9) )
   ir(:) = [ 1, 2, 1, 3, 2, 3, 4, 3, 2 ]
   jc(:) = [ 1, 1, 2, 2, 3, 3, 3, 4, 5 ]
   val(:) = [ 2.0d0, 3.0d0, 3.0d0, -1.0d0, 4.0d0, -3.0d0,               &
              1.0d0, 2.0d0, 6.0d0 ]

   A = mfSpImport(ir,jc,val)
   call msDisplay(A, "A = mfSpImport(ir,jc,val)")
   call msDisplay(mfFull(A), "")

   deallocate( ir, jc, val )

   b = mfMul( A, .t. mf( [ 1, 2, 3, 4, 5 ] ) )
   call msDisplay(b, "b [RHS]")

   x = mfLDiv( A, b )
   call msDisplay(x, "x [sol. of min. 2-norm]")

   call check_small( mfNorm(mfMul(A,x)-b), "| A*x - b |",               &
                     1.0d2*MF_EPS )

   ! --- complex case
   ! square system

   !-- triangular systems
   allocate( ir(12), jc(12), val(12) )
   ir(:) = [ 1, 2, 1, 3, 5, 2, 3, 4, 5, 3, 2, 5 ]
   jc(:) = [ 1, 1, 2, 2, 2, 3, 3, 3, 3, 4, 5, 5 ]
   val(:) = [ 2.0d0, 3.0d0, 3.0d0, -1.0d0, 4.0d0, 4.0d0, -3.0d0,        &
              1.0d0, 2.0d0, 2.0d0,  6.0d0, 1.0d0 ]
   A = mfSpImport(ir,jc,val)
   deallocate( ir, jc, val )
   call msDisplay(A, "A = mfSpImport(ir,jc,val)")
   call msDisplay(mfFull(A), "")
   call msLU( mfOut(L,U), A )
   ! we are looking only for non-unit triangular systems
   call msDisplay(mfFull(U), "U")

   print "(/,A)", "*** test number 221 ***"
   b = mfMul( L, .t.mf( [ 1, 2, 3, 4, 5 ] ) ) * MF_I
   call msDisplay(b, "b [RHS]")
   x = mfLDiv( L, b )
   call msDisplay(x, "x [sol.]")

   print "(/,A)", "*** test number 222 ***"
   b = mfMul( U, .t.mf( [ 1, 2, 3, 4, 5 ] ) ) * MF_I
   call msDisplay(b, "b [RHS]")
   x = mfLDiv( U, b )
   call msDisplay(x, "x [sol.]")

   U = U*MF_I
   L = .t. U

   print "(/,A)", "*** test number 223 ***"
   b = mfMul( L, .t.mf( [ 1, 2, 3, 4, 5 ] ) )
   call msDisplay(b, "b [RHS]")
   x = mfLDiv( L, b )
   call msDisplay(x, "x [sol.]")

   print "(/,A)", "*** test number 224 ***"
   b = mfMul( U, .t.mf( [ 1, 2, 3, 4, 5 ] ) )
   call msDisplay(b, "b [RHS]")
   x = mfLDiv( U, b )
   call msDisplay(x, "x [sol.]")

   print "(/,A)", "*** test number 225 ***"
   b = mfMul( L, .t.mf( [ 1, 2, 3, 4, 5 ] ) ) * MF_I
   call msDisplay(b, "b [RHS]")
   x = mfLDiv( L, b )
   call msDisplay(x, "x [sol.]")

   print "(/,A)", "*** test number 226 ***"
   b = mfMul( U, .t.mf( [ 1, 2, 3, 4, 5 ] ) ) * MF_I
   call msDisplay(b, "b [RHS]")
   x = mfLDiv( U, b )
   call msDisplay(x, "x [sol.]")

   allocate( ir(12), jc(12), val(12) )
   ir(:) = [ 1, 2, 1, 3, 5, 2, 3, 4, 5, 3, 2, 5 ]
   jc(:) = [ 1, 1, 2, 2, 2, 3, 3, 3, 3, 4, 5, 5 ]
   val(:) = [ 2.0d0, 3.0d0, 3.0d0, -1.0d0, 4.0d0, 4.0d0, -3.0d0,        &
              1.0d0, 2.0d0, 2.0d0,  6.0d0, 1.0d0 ]

   A = mfSpImport(ir,jc,val)*MF_I + mfSpEye(5)
   call msDisplay(A, "A = mfSpImport(ir,jc,val)*MF_I + mfSpEye(5)")
   call msDisplay(mfFull(A), "")

   deallocate( ir, jc, val )

   if( mfIsRowSorted( A ) ) then
      print *, "  --> info: 'A' row sorted : true"
   else
      print *, "  --> info: 'A' row sorted : false"
   end if

   b = mfMul( A, .t. mf( [ 1, 2, 3, 4, 5 ] ) )
   call msDisplay(b, "b [RHS]")

   print "(/,A)", "*** test number 227 ***"
   x = mfLDiv( A, b )
   call zeroes_small_values( x, 10.0d0*MF_EPS )
   call msDisplay(x, "x [sol.]")

   ! after LU factorization
   call msLU( mfOut(L,U,p,q,r), A )
   print "(/,1X,A)", "call msLU( mfOut(L,U,p,q,r), A )"
   x = mfMul(L,U)
!!   y = mfMul(mfMul(P,mfMul(R,A)),Q)
   y = mfRowScale(A,r)
   call msRowPerm(y,p)
   call msColPerm(y,q)
   call check_small( mfNorm(x-y), "|L*U - p*r*A*q|",                    &
                     1.0d2*MF_EPS )

   print "(/,A)", "*** test number 228 ***"
   x = mfLDiv( L, U, b )
   call zeroes_small_values( x, 10.0d0*MF_EPS )
   call msDisplay(x, "x [sol.]")

   ! hermitian and pos. def.: CHOLMOD
   allocate( ir(10), jc(10), val(10) )
   ir(:) = [ 1, 2, 3, 4, 1, 2, 1, 3, 1, 4 ]
   jc(:) = [ 1, 1, 1, 1, 2, 2, 3, 3, 4, 4 ]
   val(:) = [ 2.0d0, 1.0d0, 1.0d0, 1.0d0, 1.0d0, 2.0d0, 1.0d0,          &
              2.0d0, 1.0d0, 2.0d0 ]

   A = mfSpImport(ir,jc,val)
   deallocate( ir, jc, val )

   A = A*( 1.0d0 + MF_I )
   A = mfTriu(A)
   A = A + .h. A
   call msDisplay(mfFull(A), "")

   bool = mfIsSymm(A)
   print *, "Is A hermitian ? ", bool
   bool = mfIsPosDef(A)
   print *, "Is A positive definite ? ", bool
   print "()"

   b = mfMul( A, .t. mf( [ 1, 2, 3, 4 ] ) )
   call msDisplay(b, "b [RHS]")

   print "(/,A)", "*** test number 229 ***"
   x = mfLDiv( A, b )
   call msDisplay(x, "x [sol.]")

   ! over-determined system : m > n
! not possible in this release (no complex routine)

   ! under-determined system : m < n
! not possible in this release (no complex routine)

   ! mfRDiv ------------------------------------------------------------
   call print_separation("mfRDiv")

   ! --- real case

   !-- triangular systems
   allocate( ir(12), jc(12), val(12) )
   ir(:) = [ 1, 2, 1, 3, 5, 2, 3, 4, 5, 3, 2, 5 ]
   jc(:) = [ 1, 1, 2, 2, 2, 3, 3, 3, 3, 4, 5, 5 ]
   val(:) = [ 2.0d0, 3.0d0, 3.0d0, -1.0d0, 4.0d0, 4.0d0, -3.0d0,        &
              1.0d0, 2.0d0, 2.0d0,  6.0d0, 1.0d0 ]
   A = mfSpImport(ir,jc,val)
   deallocate( ir, jc, val )
   call msDisplay(A, "A = mfSpImport(ir,jc,val)")
   call msDisplay(mfFull(A), "")
   call msLU( mfOut(L,U), A )
   ! we are looking only for non-unit triangular systems
   call msDisplay(mfFull(U), "U")
   L = .t. U

   print "(/,A)", "*** test number 230 ***"
   b = mfMul( mf( [ 1, 2, 3, 4, 5 ] ), L )
   call msDisplay(b, "b [RHS]")
   x = mfRDiv( b, L )
   call msDisplay(x, "x [sol.]")

   print "(/,A)", "*** test number 231 ***"
   b = mfMul( mf( [ 1, 2, 3, 4, 5 ] ), U )
   call msDisplay(b, "b [RHS]")
   x = mfRDiv( b, U )
   call msDisplay(x, "x [sol.]")

   ! singular diagonal matrix
   A = mfSpEyE(5,5)
   call msSet( 0.0d0, A, 2, 2 )
   print "(/,A)", "*** test number 232 ***"
   call msDisplay(A, "A")
   call msDisplay(mfFull(A), "")
   print *, "mfIsDiag(A) = ", mfIsDiag(A)
   b = mf( [ 1, 2, 3, 4, 5 ] )
   call msDisplay(b, "b [RHS]")
   call mf_save_and_disable_fpe( )
   x = mfRDiv( b, A )
   call msDisplay(x, "x [sol.]")
   call mf_restore_fpe( )

   ! singular lower triangular matrix
   allocate( ir(5), jc(5), val(5) )
   ir(:) = [ 1, 3, 5, 5, 4 ]
   jc(:) = [ 1, 3, 5, 2, 3 ]
   val(:) = [ 1.0d0, 3.0d0, 5.0d0, -1.0d0, -2.0d0 ]
   A = mfSpImport(ir,jc,val)
   deallocate( ir, jc, val )
   print "(/,A)", "*** test number 233 ***"
   call msDisplay(A, "A")
   call msDisplay(mfFull(A), "")
   print *, "mfIsTril(A) = ", mfIsTril(A)
   print *, "mfIsTriu(A) = ", mfIsTriu(A)
   b = mf( [ 1, 2, 3, 4, 5 ] )
   call msDisplay(b, "b [RHS]")
   call mf_save_and_disable_fpe( )
   x = mfRDiv( b, A )
   call msDisplay(x, "x [sol.]")
   call mf_restore_fpe( )

   ! singular upper triangular matrix
   allocate( ir(5), jc(5), val(5) )
   ir(:) = [ 1, 3, 5, 5, 4 ]
   jc(:) = [ 1, 3, 5, 2, 3 ]
   val(:) = [ 1.0d0, 3.0d0, 5.0d0, -1.0d0, -2.0d0 ]
   A = .t. mfSpImport(ir,jc,val)
   deallocate( ir, jc, val )
   print "(/,A)", "*** test number 234 ***"
   call msDisplay(A, "A")
   call msDisplay(mfFull(A), "")
   print *, "mfIsTril(A) = ", mfIsTril(A)
   print *, "mfIsTriu(A) = ", mfIsTriu(A)
   b = mf( [ 1, 2, 3, 4, 5 ] )
   call msDisplay(b, "b [RHS]")
   call mf_save_and_disable_fpe( )
   x = mfRDiv( b, A )
   call msDisplay(x, "x [sol.]")
   call mf_restore_fpe( )

   ! square system unsymmetric : UMFPACK

   ! same example as in doc of UMFPack-4
   allocate( ir(12), jc(12), val(12) )
   ir(:) = [ 1, 2, 1, 3, 5, 2, 3, 4, 5, 3, 2, 5 ]
   jc(:) = [ 1, 1, 2, 2, 2, 3, 3, 3, 3, 4, 5, 5 ]
   val(:) = [ 2.0d0, 3.0d0, 3.0d0, -1.0d0, 4.0d0, 4.0d0, -3.0d0,        &
              1.0d0, 2.0d0, 2.0d0,  6.0d0, 1.0d0 ]

   A = mfSpImport(ir,jc,val)
   deallocate( ir, jc, val )
   call msDisplay(A, "A = mfSpImport(ir,jc,val) [ex. from doc of UMFPack-4]")
   call msDisplay(mfFull(A), "")

   b = mfMul( mf( [ 1, 2, 3, 4, 5 ] ), A )
   call msDisplay(b, "b [RHS]")

   print "(/,A)", "*** test number 235 ***"
   x = mfRDiv( b, A )
   call msDisplay(x, "x [sol.]")

   ! after LU factorization (storing all factors)
   call msLU( mfOut(L,U,p,q,r), A )
   print *, "call msLU( mfOut(L,U,p,q,r), A )"
   x = mfMul(L,U)
!!   y = mfMul(mfMul(P,mfMul(R,A)),Q)
   y = mfRowScale(A,r)
   call msRowPerm(y,p)
   call msColPerm(y,q)
   call msDisplay( mfNorm(x-y), "|L*U - p*r*A*q|" )

   print "(/,A)", "*** test number 236 ***"
   x = mfRDiv( b, L, U )
   call msDisplay(x, "x [sol.]")

   ! see another test in 'msLU' section

   ! square system symmetric and pos. def.: CHOLMOD

   ! adding a unity diagonal: if not, cholmod cannot solve it,
   ! because it must not have zeros on the diagonal
   A = A + .t. A + mfSpEye(5)
   call msDisplay(A, "A (symmetric)")
   call msDisplay(mfFull(A), "")

   b = mfMul( mf( [ 1, 2, 3, 4, 5 ] ), A )
   call msDisplay(b, "b [RHS]")

   print "(/,A)", "*** test number 237 ***"
   x = mfRDiv( b, A )
   call msDisplay(x, "x [sol.]")

   ! over-determined system : n > m

   print "(/,A)", "*** test number 238 ***"
   allocate( ir(15), jc(15), val(15) )
   ir(:) = [ 1, 2, 4, 6, 5, 2, 7, 1, 5, 3, 6, 2, 3, 1, 3 ]
   jc(:) = [ 2, 3, 3, 3, 5, 1, 5, 1, 2, 4, 4, 5, 2, 3, 3 ]
   val(:) = [ 3.0d0, -3.0d0, 2.0d0, 3.0d0, 1.0d0,  3.0d0, 2.0d0,        &
              2.0d0,  4.0d0, 2.0d0, 3.0d0, 6.0d0, -1.0d0, 4.0d0, 1.0d0 ]

   A = .t. mfSpImport(ir,jc,val)
   call msDisplay(A, "A = .t. mfSpImport(ir,jc,val)")
   call msDisplay(mfFull(A), "")

   deallocate( ir, jc, val )

   b = mfMul( mf( [ 1, 2, 3, 4, 5 ] ), A )
   call msDisplay(b, "b [RHS]")

   x = mfRDiv( b, A )
   call msDisplay(x, "x [LSQ sol.]")

   call check_small( mfNorm(mfMul(x,A)-b), "| x*A - b |",               &
                     1.0d2*MF_EPS )

   ! under-determined system : n < m

   print "(/,A)", "*** test number 239 ***"
   allocate( ir(9), jc(9), val(9) )
   ir(:) = [ 1, 2, 1, 3, 2, 3, 4, 3, 2 ]
   jc(:) = [ 1, 1, 2, 2, 3, 3, 3, 4, 5 ]
   val(:) = [ 2.0d0, 3.0d0, 3.0d0, -1.0d0, 4.0d0, -3.0d0,               &
              1.0d0, 2.0d0, 6.0d0 ]

   A = .t. mfSpImport(ir,jc,val)
   call msDisplay(A, "A = mfSpImport(ir,jc,val)")
   call msDisplay(mfFull(A), "")

   deallocate( ir, jc, val )

   b = mfMul( mf( [ 1, 2, 3, 4, 5 ] ), A )
   call msDisplay(b, "b [RHS]")

   x = mfRDiv( b, A )
   call msDisplay(x, "x [sol. of min. 2-norm]")

   call check_small( mfNorm(mfMul(x,A)-b), "| x*A - b |",               &
                     1.0d2*MF_EPS )
   ! --- complex case

   !-- triangular systems
   allocate( ir(12), jc(12), val(12) )
   ir(:) = [ 1, 2, 1, 3, 5, 2, 3, 4, 5, 3, 2, 5 ]
   jc(:) = [ 1, 1, 2, 2, 2, 3, 3, 3, 3, 4, 5, 5 ]
   val(:) = [ 2.0d0, 3.0d0, 3.0d0, -1.0d0, 4.0d0, 4.0d0, -3.0d0,        &
              1.0d0, 2.0d0, 2.0d0,  6.0d0, 1.0d0 ]
   A = mfSpImport(ir,jc,val)
   deallocate( ir, jc, val )
   call msDisplay(A, "A = mfSpImport(ir,jc,val)")
   call msDisplay(mfFull(A), "")
   call msLU( mfOut(L,U), A )
   ! we are looking only for non-unit triangular systems
   call msDisplay(mfFull(U), "U")
   L = .t. U

   print "(/,A)", "*** test number 240 ***"
   b = mfMul( mf( [ 1, 2, 3, 4, 5 ] ), L ) * MF_I
   call msDisplay(b, "b [RHS]")
   x = mfRDiv( b, L )
   call msDisplay(x, "x [sol.]")
   call check_small( mfNormEst(mfMul(x,L)-b), "|x*L-b|", 1.0d2*MF_EPS )

   print "(/,A)", "*** test number 241 ***"
   b = mfMul( mf( [ 1, 2, 3, 4, 5 ] ), U ) * MF_I
   call msDisplay(b, "b [RHS]")
   x = mfRDiv( b, U )
   call msDisplay(x, "x [sol.]")
   call check_small( mfNormEst(mfMul(x,U)-b), "|x*U-b|", 1.0d2*MF_EPS )

   U = U*MF_I
   L = .h. U

   print "(/,A)", "*** test number 242 ***"
   b = mfMul( mf( [ 1, 2, 3, 4, 5 ] ), L )
   call msDisplay(b, "b [RHS]")
   x = mfRDiv( b, L )
   call msDisplay(x, "x [sol.]")

   print "(/,A)", "*** test number 243 ***"
   b = mfMul( mf( [ 1, 2, 3, 4, 5 ] ), U )
   call msDisplay(b, "b [RHS]")
   x = mfRDiv( b, U )
   call msDisplay(x, "x [sol.]")

   print "(/,A)", "*** test number 244 ***"
   b = mfMul( mf( [ 1, 2, 3, 4, 5 ] ), L ) * MF_I
   call msDisplay(b, "b [RHS]")
   x = mfRDiv( b, L )
   call msDisplay(x, "x [sol.]")
   call check_small( mfNormEst(mfMul(x,L)-b), "|x*L-b|", 1.0d2*MF_EPS )

   print "(/,A)", "*** test number 245 ***"
   b = mfMul( mf( [ 1, 2, 3, 4, 5 ] ), U ) * MF_I
   call msDisplay(b, "b [RHS]")
   x = mfRDiv( b, U )
   call msDisplay(x, "x [sol.]")
   call check_small( mfNormEst(mfMul(x,U)-b), "|x*U-b|", 1.0d2*MF_EPS )

   ! square system
   allocate( ir(12), jc(12), val(12) )
   ir(:) = [ 1, 2, 1, 3, 5, 2, 3, 4, 5, 3, 2, 5 ]
   jc(:) = [ 1, 1, 2, 2, 2, 3, 3, 3, 3, 4, 5, 5 ]
   val(:) = [ 2.0d0, 3.0d0, 3.0d0, -1.0d0, 4.0d0, 4.0d0, -3.0d0,        &
              1.0d0, 2.0d0, 2.0d0,  6.0d0, 1.0d0 ]

   A = mfSpImport(ir,jc,val)*MF_I + mfSpEye(5)
   call msDisplay(A, "A = mfSpImport(ir,jc,val)*MF_I + mfSpEye(5)")
   call msDisplay(mfFull(A), "")

   deallocate( ir, jc, val )

   if( mfIsRowSorted( A ) ) then
      print *, "  --> info: 'A' row sorted : true"
   else
      print *, "  --> info: 'A' row sorted : false"
   end if

   b = mfMul( mf( [ 1, 2, 3, 4, 5 ] ), A )
   call msDisplay(b, "b [RHS]")

   print "(/,A)", "*** test number 246 ***"
   x = mfRDiv( b, A )
   call zeroes_small_values( x, 10.0d0*MF_EPS )
   call msDisplay(x, "x [sol.]")

   ! after LU factorization
   call msLU( mfOut(L,U,p,q,r), A )
   print "(/,1X,A)", "call msLU( mfOut(L,U,p,q,r), A )"
   x = mfMul(L,U)
!!   y = mfMul(mfMul(P,mfMul(R,A)),Q)
   y = mfRowScale(A,r)
   call msRowPerm(y,p)
   call msColPerm(y,q)
   call check_small( mfNorm(x-y), "|L*U - p*r*A*q|",                    &
                     1.0d2*MF_EPS )

   print "(/,A)", "*** test number 247 ***"
   x = mfRDiv( b, L, U )
   call zeroes_small_values( x, 10.0d0*MF_EPS )
   call msDisplay(x, "x [sol.]")

   ! hermitian and pos. def.: CHOLMOD
   allocate( ir(10), jc(10), val(10) )
   ir(:) = [ 1, 2, 3, 4, 1, 2, 1, 3, 1, 4 ]
   jc(:) = [ 1, 1, 1, 1, 2, 2, 3, 3, 4, 4 ]
   val(:) = [ 2.0d0, 1.0d0, 1.0d0, 1.0d0, 1.0d0, 2.0d0, 1.0d0,          &
              2.0d0, 1.0d0, 2.0d0 ]

   A = mfSpImport(ir,jc,val)
   deallocate( ir, jc, val )

   A = A*( 1.0d0 + MF_I )
   A = mfTriu(A)
   A = A + .h. A
   call msDisplay(mfFull(A), "A")

   bool = mfIsSymm(A)
   print *, "Is A hermitian ? ", bool
   bool = mfIsPosDef(A)
   print *, "Is A positive definite ? ", bool
   print "()"

   b = mfMul( mf( [ 1, 2, 3, 4 ] ), A )
   call msDisplay(b, "b [RHS]")

   print "(/,A)", "*** test number 248 ***"
   x = mfRDiv( b, A )
   call msDisplay(x, "x [sol.]")

   ! over-determined system : m > n
   ! not possible in this release (no complex routine)

   ! under-determined system : m < n
   ! not possible in this release (no complex routine)

   ! mfEigs, msEigs ----------------------------------------------------
   call print_separation("mfEigs, msEigs")

!### TODO ?: why the dense case here? Not treated in matfun_2?
   ! --- case DENSE ---

   ! --- symmetric real matrix : real eigenvalues

   ! diagonal matrix for which we know lambda_i
   ! (in order to check the output order)
   n = 8
   A = mfDiag( mf([ (i,i=1,n) ]) )
   call msDisplay(A, "A")

   ! (check with mfEig)
   v = mfEig(A)
   call msDisplay(v, "All eigenvalues from mfEig()")

   print "(/,A)", "*** test number 249 ***"
   d = mfEigs( A, 2 ) ! default : "LM"
   call msDisplay(d, "Largest eigenvalues from mfEigs()")

   print "(/,A)", "*** test number 250 ***"
   d = mfEigs( A, 2, "SM" )
   call msDisplay(d, "Smallest eigenvalues from mfEigs()")

   print "(/,A)", "*** test number 251 ***"
   d = mfEigs( A, 2, "BE" )
   call msDisplay(d, "Both-end eigenvalues from mfEigs()")

   print "(/,A)", "*** test number 252 ***"
   d = mfEigs( A, 2, sigma=4.25d0 )
   call msDisplay( d,"Eigenvalues closest to 4.25 from mfEigs()")

   ! (check with msEig)
   call msEig( mfOut(V,E), A )
   call msDisplay(V, "All eigenvectors from msEig()")

   print "(/,A)", "*** test number 253 ***"
   call msEigs( mfOut(V,E,flag), A, 2 ) ! default : "LM"
   call msDisplay(E,"Largest eigenvalues from msEigs() (with eigenvectors)")
   !call msDisplay(V, "Eigenvectors for 'LM' from msEigs()")
   call msDisplay(flag, "All requested eigenvalues converged?")
   D = mfDiag(E)
   call check_small( mfNorm(mfMul(A,V)-mfMul(V,D)), "norm(A*V - V*D)",  &
                     check_small_threshold )

   print "(/,A)", "*** test number 254 ***"
   call msEigs( mfOut(V,E,flag), A, 2, "SM" )
   call msDisplay(E, "Smallest eigenvalues from mfEigs() (with eigenvectors)")
   !call msDisplay(V, "Eigenvectors for 'SM' from msEigs()")
   call msDisplay(flag, "All requested eigenvalues converged?")
   D = mfDiag(E)
   call check_small( mfNorm(mfMul(A,V)-mfMul(V,D)), "norm(A*V - V*D)",  &
                     check_small_threshold )

   print "(/,A)", "*** test number 255 ***"
   call msEigs( mfOut(V,E,flag), A, 2, "BE" )
   call msDisplay(E, "Both-end eigenvalues from mfEigs() (with eigenvectors)")
   !call msDisplay(V, "Eigenvectors for 'SM' from msEigs()")
   call msDisplay(flag, "All requested eigenvalues converged?")
   D = mfDiag(E)
   call check_small( mfNorm(mfMul(A,V)-mfMul(V,D)), "norm(A*V - V*D)",  &
                     check_small_threshold )

   print "(/,A)", "*** test number 256 ***"
   call msEigs( mfOut(V,E,flag), A, 2, sigma=4.25d0 )
   call msDisplay( E,"Eigenvalues closest to 4.25 from mfEigs() (with eigenvectors)")
   !call msDisplay(V, "Eigenvectors for 'SM' from msEigs()")
   call msDisplay(flag, "All requested eigenvalues converged?")
   D = mfDiag(E)
   call check_small( mfNorm(mfMul(A,V)-mfMul(V,D)), "norm(A*V - V*D)",  &
                     check_small_threshold )

   ! --- hermitian matrix : real eigenvalues
   n = 8
   A = mfEye(n) + MF_I*0.5d0*mfTriu(mfHilb(n))
   A = A + .h.A
   call msDisplay(A, "A")

   ! (check with mfEig)
   v = mfEig(A)
   call msDisplay(v, "All eigenvalues from mfEig()")

   print "(/,A)", "*** test number 257 ***"
   d = mfEigs( A, 2 ) ! default : "LM"
   call msDisplay(d, "Eigenvectors for 'LM' from mfEigs()")

   print "(/,A)", "*** test number 258 ***"
   d = mfEigs( A, 2, "SM" )
   call msDisplay(d, "Eigenvectors for 'SM' from mfEigs()")

   print "(/,A)", "*** test number 259 ***"
   d = mfEigs( A, 2, sigma=(2.0d0,1.0d0) )
   call msDisplay( d,"Eigenvalues closest to (2.0,1.0) from mfEigs()")

   ! (check with msEig)
   call msEig( mfOut(V,E), A )
   call msDisplay(V, "All eigenvectors from msEig()")

   print "(/,A)", "*** test number 260 ***"
   call msEigs( mfOut(V,E,flag), A, 2 ) ! default : "LM"
   call msDisplay(E,"Largest eigenvalues from msEigs() (with eigenvectors)")
   !call msDisplay(V, "Eigenvectors for 'LM' from msEigs()")
   call msDisplay(flag, "All requested eigenvalues converged?")
   D = mfDiag(E)
   call check_small( mfNorm(mfMul(A,V)-mfMul(V,D)), "norm(A*V - V*D)",  &
                     check_small_threshold )

   print "(/,A)", "*** test number 261 ***"
   call msEigs( mfOut(V,E,flag), A, 2, "SM" )
   call msDisplay(E, "Smallest eigenvalues from mfEigs() (with eigenvectors)")
   !call msDisplay(V, "Eigenvectors for 'SM' from msEigs()")
   call msDisplay(flag, "All requested eigenvalues converged?")
   D = mfDiag(E)
   call check_small( mfNorm(mfMul(A,V)-mfMul(V,D)), "norm(A*V - V*D)",  &
                     check_small_threshold )

   print "(/,A)", "*** test number 262 ***"
   call msEigs( mfOut(V,E,flag), A, 2, sigma=(2.0d0,1.0d0) )
   call msDisplay( E,"Eigenvalues closest to (2.0,1.0) from mfEigs() (with eigenvectors)")
   !call msDisplay(V, "Eigenvectors for 'SM' from msEigs()")
   call msDisplay(flag, "All requested eigenvalues converged?")
   D = mfDiag(E)
   call check_small( mfNorm(mfMul(A,V)-mfMul(V,D)), "norm(A*V - V*D)",  &
                     check_small_threshold )

   ! --- unsymmetric real matrix : complex eigenvalues

   n = 8
   A = mfDiag( mf([ (i,i=1,n) ]) )
   call msSet(  1.0d0, A, 1, 2 .to. n )
   call msSet( -1.0d0, A, n, 1 .to. n-1 )
   call msSet(  1.0d0, A, 1 .to. n-1, n )
   call msSet( -1.0d0, A, 2 .to. n, 1 )
   call msDisplay(A, "A")

   ! (check with mfEig)
   v = mfEig(A)
   call msDisplay(v, "All eigenvalues from mfEig()")

   print "(/,A)", "*** test number 263 ***"
   d = mfEigs( A, 2 ) ! default : "LM"
   call msDisplay(d, "Largest eigenvalues from mfEigs()")

   print "(/,A)", "*** test number 264 ***"
   d = mfEigs( A, 2, "SM" )
   call msDisplay(d, "Smallest eigenvalues from mfEigs()")

   print "(/,A)", "*** test number 265 ***"
   d = mfEigs( A, 2, sigma=(2.5d0,1.5d0) )
   call msDisplay( d,"Eigenvalues closest to (2.5,1.5) from mfEigs()")

   ! (check with msEig)
   call msEig( mfOut(V,E), A )
   call msDisplay(V, "All eigenvectors from msEig()")

   print "(/,A)", "*** test number 266 ***"
   call msEigs( mfOut(V,E,flag), A, 2 ) ! default : "LM"
   call msDisplay(E, "Largest eigenvalues from msEigs() (with eigenvectors)")
   !call msDisplay(V, "Eigenvectors for 'LM' from msEigs()")
   call msDisplay(flag, "All requested eigenvalues converged?")
   D = mfDiag(E)
   call check_small( mfNorm(mfMul(A,V)-mfMul(V,D)), "norm(A*V - V*D)",  &
                     check_small_threshold )

   print "(/,A)", "*** test number 267 ***"
   call msEigs( mfOut(V,E,flag), A, 2, "SM" )
   call msDisplay(E, "Smallest eigenvalues from msEigs() (with eigenvectors)")
   !call msDisplay(V, "Eigenvectors for 'SM' from msEigs()")
   call msDisplay(flag, "All requested eigenvalues converged?")
   D = mfDiag(E)
   call check_small( mfNorm(mfMul(A,V)-mfMul(V,D)), "norm(A*V - V*D)",  &
                     check_small_threshold )

   print "(/,A)", "*** test number 268 ***"
   call msEigs( mfOut(V,E,flag), A, 2, sigma=(2.5d0,1.5d0) )
   call msDisplay( E,"Eigenvalues closest to (2.5,1.5) from mfEigs() (with eigenvectors)")
   !call msDisplay(V, "Eigenvectors for 'SM' from msEigs()")
   call msDisplay(flag, "All requested eigenvalues converged?")
   D = mfDiag(E)
   call check_small( mfNorm(mfMul(A,V)-mfMul(V,D)), "norm(A*V - V*D)",  &
                     check_small_threshold )

   ! --- complex
   n = 8
   A = mfDiag( mf([ (i,i=1,n) ]) ) - 0.1d0*MF_I*mfOnes(n)
   call msSet( 0.2d0, A, 1, 4 )
   call msDisplay(A, "A")

   ! (check with mfEig)
   v = mfEig(A)
   call msDisplay(v, "All eigenvalues from mfEig()")
   call msDisplay(mfSort(v), "All eigenvalues from mfEig()")

   print "(/,A)", "*** test number 269 ***"
   d = mfEigs( A, 2 ) ! default : "LM"
   call msDisplay(d, "Largest eigenvalues from mfEigs()")

   print "(/,A)", "*** test number 270 ***"
   d = mfEigs( A, 2, "SM" )
   call msDisplay(d, "Smallest eigenvalues from mfEigs()")

   print "(/,A)", "*** test number 271 ***"
   d = mfEigs( A, 2, sigma=(4.5d0,-0.5d0) )
   call msDisplay( d,"Eigenvalues closest to (4.5,-0.5) from mfEigs()")

   ! (check with msEig)
   call msEig( mfOut(V,E), A )
   call msDisplay(V, "All eigenvectors from msEig()")

   print "(/,A)", "*** test number 272 ***"
   call msEigs( mfOut(V,E,flag), A, 2 ) ! default : "LM"
   call msDisplay(E, "Largest eigenvalues from msEigs() (with eigenvectors)")
   !call msDisplay(V, "Eigenvectors for 'LM' from msEigs()")
   call msDisplay(flag, "All requested eigenvalues converged?")
   D = mfDiag(E)
   call check_small( mfNorm(mfMul(A,V)-mfMul(V,D)), "norm(A*V - V*D)",  &
                     check_small_threshold )

   print "(/,A)", "*** test number 273 ***"
   call msEigs( mfOut(V,E,flag), A, 2, "SM" )
   call msDisplay(E, "Smallest eigenvalues from msEigs() (with eigenvectors)")
   !call msDisplay(V, "Eigenvectors for 'SM' from msEigs()")
   call msDisplay(flag, "All requested eigenvalues converged?")
   D = mfDiag(E)
   call check_small( mfNorm(mfMul(A,V)-mfMul(V,D)), "norm(A*V - V*D)",  &
                     check_small_threshold )

   print "(/,A)", "*** test number 274 ***"
   call msEigs( mfOut(V,E,flag), A, 2, sigma=(4.5d0,-0.5d0) )
   call msDisplay( E,"Eigenvalues closest to (4.5,-0.5) from mfEigs() (with eigenvectors)")
   !call msDisplay(V, "Eigenvectors for 'SM' from msEigs()")
   call msDisplay(flag, "All requested eigenvalues converged?")
   D = mfDiag(E)
!!call msDisplay( mfMul(A,V)-mfMul(V,D), "A*V - V*D" )
   call check_small( mfNorm(mfMul(A,V)-mfMul(V,D)), "norm(A*V - V*D)",  &
                     check_small_threshold )

   ! --- case SPARSE ---

   ! --- symmetric matrix : real eigenvalues
   n = 9
   A = mfSpDiags( n, n, mf([ 2.0d0, (1.0d0,i=1,7), 2.0d0 ]), 0 )
   call msSpReAlloc( A, nzmax=22 )
   call msSet( -4.0d0, A, 1, 9 )
   call msSet( -3.0d0, A, 2, 8 )
   call msSet( -2.0d0, A, 3, 7 )
   call msSet( -1.0d0, A, 4, 6 )
   call msSet( -1.0d0, A, 6, 4 )
   call msSet( -2.0d0, A, 7, 3 )
   call msSet( -3.0d0, A, 8, 2 )
   call msSet( -4.0d0, A, 9, 1 )
   call msSet(  1.0d0, A, 5, 4 )
   call msSet(  1.0d0, A, 4, 5 )
   call msSet(  1.0d0, A, 6, 5 )
   call msSet(  1.0d0, A, 5, 6 )
   B = mfFull(A)
   call msDisplay(B, "full(A)")

   call msDisplay(mfCond(B),"CN(A)")

   ! (check with mfEig)
   v = mfEig(B)
   call msDisplay(v, "All eigenvalues from mfEig()")

   print "(/,A)", "*** test number 275 ***"
   d = mfEigs( A, 2 )
   call msDisplay(d, "Largest eigenvalues from mfEigs()")

   print "(/,A)", "*** test number 276 ***"
   call msEigs( mfOut(V,D,flag), A, 2 ) ! default : "LM"
   !call msDisplay(V, "Eigenvectors for 'LM' from msEigs()")
   call msDisplay( flag, "All requested eigenvalues converged?" )
   ! extracts eigenvector
   vec = mfGet( V, MF_COLON, 1 )
   ! compute index for good values
   ind = mfFind( mfAbs(vec) > sqrt(MF_EPS) )
   ! RHS
   A_vec = mfMul(A,vec)
   ! element-wise division
   lambda = mfGet( A_vec/vec, ind )
   call msDisplay( mfMean(lambda),                                      &
        "mean( A*vec ./ vec ) for non-zero components of eigenvect #1" )
   ! extracts eigenvector
   vec = mfGet( V, MF_COLON, 2 )
   ! compute index for good values
   ind = mfFind( mfAbs(vec) > sqrt(MF_EPS) )
   ! RHS
   A_vec = mfMul(A,vec)
   ! element-wise division
   lambda = mfGet( A_vec/vec, ind )
   call msDisplay( mfMean(lambda),                                      &
        "mean( A*vec ./ vec ) for non-zero components of eigenvect #2" )

   print "(/,A)", "*** test number 277 ***"
   d = mfEigs( A, 2, "SM" )
   call msDisplay(d, "Smallest eigenvalues from mfEigs()")

   print "(/,A)", "*** test number 278 ***"
   call msEigs( mfOut(V,D,flag), A, 2, "SM" )
   !call msDisplay(V, "Eigenvectors for 'SM' from msEigs()")
   call msDisplay( flag, "All requested eigenvalues converged?" )
   ! extracts eigenvector
   vec = mfGet( V, MF_COLON, 1 )
   ! compute index for good values
   ind = mfFind( mfAbs(vec) > sqrt(MF_EPS) )
   ! RHS
   A_vec = mfMul(A,vec)
   ! element-wise division
   lambda = mfGet( A_vec/vec, ind )
   tmp = mfMean(lambda)
   call round_values( tmp, 6 )
   call msDisplay( tmp,                                                 &
        "mean( A*vec ./ vec ) for non-zero components of eigenvect #1" )
   ! extracts eigenvector
   vec = mfGet( V, MF_COLON, 2 )
   ! compute index for good values
   ind = mfFind( mfAbs(vec) > sqrt(MF_EPS) )
   ! RHS
   A_vec = mfMul(A,vec)
   ! element-wise division
   lambda = mfGet( A_vec/vec, ind )
   call msDisplay( mfMean(lambda),                                      &
        "mean( A*vec ./ vec ) for non-zero components of eigenvect #2" )

   print "(/,A)", "*** test number 279 ***"
   d = mfEigs( A, 2, "BE" )
   call msDisplay(d, "Both-end eigenvalues from mfEigs()")

   print "(/,A)", "*** test number 280 ***"
   call msEigs( mfOut(V,D,flag), A, 2, "BE" )
   !call msDisplay(V, "Eigenvectors for 'BE' from msEigs()")
   call msDisplay( flag, "All requested eigenvalues converged?" )
   ! extracts eigenvector
   vec = mfGet( V, MF_COLON, 1 )
   ! compute index for good values
   ind = mfFind( mfAbs(vec) > sqrt(MF_EPS) )
   ! RHS
   A_vec = mfMul(A,vec)
   ! element-wise division
   lambda = mfGet( A_vec/vec, ind )
   tmp = mfMean(lambda)
   call round_values( tmp, 6 )
   call msDisplay( tmp,                                                 &
        "mean( A*vec ./ vec ) for non-zero components of eigenvect #1" )
   ! extracts eigenvector
   vec = mfGet( V, MF_COLON, 2 )
   ! compute index for good values
   ind = mfFind( mfAbs(vec) > sqrt(MF_EPS) )
   ! RHS
   A_vec = mfMul(A,vec)
   ! element-wise division
   lambda = mfGet( A_vec/vec, ind )
   call msDisplay( mfMean(lambda),                                      &
        "mean( A*vec ./ vec ) for non-zero components of eigenvect #2" )

   ! --- unsymmetric matrix

   call msSet(  10.0d0, A, 1, 9 )
   B = mfFull(A)
   call msDisplay(B, "full(A)")

   call msDisplay(mfCond(B),"CN(A)")

   ! (check with mfEig)
   v = mfEig(B)
   call msDisplay(mfSort(v), "All eigenvalues from mfEig()")

   print "(/,A)", "*** test number 281 ***"
   d = mfEigs( A, 2, "LM" )
   call msDisplay(d, "Largest eigenvalues from mfEigs()")

   print "(/,A)", "*** test number 282 ***"
   call msEigs( mfOut(V,D,flag), A, 2 ) ! default : "LM"
   !call msDisplay(V, "Eigenvectors for 'LM' from msEigs()")
   call msDisplay( flag, "All requested eigenvalues converged?" )
   ! extracts eigenvector
   vec = mfGet( V, MF_COLON, 1 )
   ! compute index for good values
   ind = mfFind( mfAbs(vec) > sqrt(MF_EPS) )
   ! RHS
   A_vec = mfMul(A,vec)
   ! element-wise division
   lambda = mfGet( A_vec/vec, ind )
   call msDisplay( mfMean(lambda),                                      &
        "mean( A*vec ./ vec ) for non-zero components of eigenvect #1" )
   ! extracts eigenvector
   vec = mfGet( V, MF_COLON, 2 )
   ! compute index for good values
   ind = mfFind( mfAbs(vec) > sqrt(MF_EPS) )
   ! RHS
   A_vec = mfMul(A,vec)
   ! element-wise division
   lambda = mfGet( A_vec/vec, ind )
   call msDisplay( mfMean(lambda),                                      &
        "mean( A*vec ./ vec ) for non-zero components of eigenvect #2" )

   print "(/,A)", "*** test number 283 ***"
   d = mfEigs( A, 2, "SM" )
   call msDisplay(d, "Smallest eigenvalues from mfEigs()")

   print "(/,A)", "*** test number 284 ***"
   call msEigs( mfOut(V,D,flag), A, 2, "SM" )
   !call msDisplay(V, "Eigenvectors for 'SM' from msEigs()")
   call msDisplay( flag, "All requested eigenvalues converged?" )
   ! extracts eigenvector
   vec = mfGet( V, MF_COLON, 1 )
   ! compute index for good values
   ind = mfFind( mfAbs(vec) > sqrt(MF_EPS) )
   ! RHS
   A_vec = mfMul(A,vec)
   ! element-wise division
   lambda = mfGet( A_vec/vec, ind )
   call msDisplay( mfMean(lambda),                                      &
        "mean( A*vec ./ vec ) for non-zero components of eigenvect #1" )
   ! extracts eigenvector
   vec = mfGet( V, MF_COLON, 2 )
   ! compute index for good values
   ind = mfFind( mfAbs(vec) > sqrt(MF_EPS) )
   ! RHS
   A_vec = mfMul(A,vec)
   ! element-wise division
   lambda = mfGet( A_vec/vec, ind )
   call msDisplay( mfMean(lambda),                                      &
        "mean( A*vec ./ vec ) for non-zero components of eigenvect #2" )

   ! --- rank deficient

   allocate( ir(9), jc(9), val(9) )
   ir(:) = [ 1, 1, 2, 2, 3, 4, 4, 5, 5 ]
   jc(:) = [ 1, 5, 2, 4, 3, 2, 4, 1, 5 ]
   val(:) = [ 2.0d0, 1.0d0, 1.0d0, 1.0d0, 1.0d0, 1.0d0, 1.0d0, 1.0d0, 2.0d0 ]

   A = mfSpImport(ir,jc,val)
   call msDisplay(A, "A = mfSpImport(ir,jc,val)")

   B = mfFull(A)
   call msDisplay(B, "")

   deallocate( ir, jc, val )

   call msDisplay(mfRCond(B),"Rcond(A)")

   ! (check with mfEig)
   v = mfEig(B)
   call msDisplay(v, "All eigenvalues from mfEig()")

   print "(/,A)", "*** test number 285 ***"
   d = mfEigs( A, 2 ) ! default : "LM"
   call msDisplay(d, "Largest eigenvalues from mfEigs()")

   print "(/,A)", "*** test number 286 ***"
   call msEigs( mfOut(V,D,flag), A, 2 ) ! default : "LM"
   !call msDisplay(V, "Eigenvectors for 'LM' from msEigs()")
   call msDisplay( flag, "All requested eigenvalues converged?" )
   ! extracts eigenvector
   vec = mfGet( V, MF_COLON, 1 )
   ! compute index for good values
   ind = mfFind( mfAbs(vec) > sqrt(MF_EPS) )
   ! RHS
   A_vec = mfMul(A,vec)
   ! element-wise division
   lambda = mfGet( A_vec/vec, ind )
   call msDisplay( mfMean(lambda),                                      &
        "mean( A*vec ./ vec ) for non-zero components of eigenvect #1" )
   ! extracts eigenvector
   vec = mfGet( V, MF_COLON, 2 )
   ! compute index for good values
   ind = mfFind( mfAbs(vec) > sqrt(MF_EPS) )
   ! RHS
   A_vec = mfMul(A,vec)
   ! element-wise division
   lambda = mfGet( A_vec/vec, ind )
   call msDisplay( mfMean(lambda),                                      &
        "mean( A*vec ./ vec ) for non-zero components of eigenvect #2" )

   print "(/,A)", "*** test number 287 ***"
   d = mfEigs( A, 2, "SM" )
   call msDisplay(d, "Smallest eigenvalues from mfEigs()")

   print "(/,A)", "*** test number 288 ***"
   call msEigs( mfOut(V,D,flag), A, 2, "SM" )
   !call msDisplay(V, "Eigenvectors for 'SM' from msEigs()")
   call msDisplay( flag, "All requested eigenvalues converged?" )
   ! extracts eigenvector
   vec = mfGet( V, MF_COLON, 1 )
   ! compute index for good values
   ind = mfFind( mfAbs(vec) > sqrt(MF_EPS) )
   ! RHS
   A_vec = mfMul(A,vec)
   ! element-wise division
   lambda = mfGet( A_vec/vec, ind )
   tmp = mfMean(lambda)
   call round_values( tmp, 6 )
   call msDisplay( tmp,                                                 &
        "mean( A*vec ./ vec ) for non-zero components of eigenvect #1" )
   ! extracts eigenvector
   vec = mfGet( V, MF_COLON, 2 )
   ! compute index for good values
   ind = mfFind( mfAbs(vec) > sqrt(MF_EPS) )
   ! RHS
   A_vec = mfMul(A,vec)
   ! element-wise division
   lambda = mfGet( A_vec/vec, ind )
   tmp = mfMean(lambda)
   call zeroes_small_values( tmp, 1.0d-16 )
   call msDisplay( tmp,                                                 &
        "mean( A*vec ./ vec ) for non-zero components of eigenvect #2" )

   ! --- request eigenvalues closed to sigma
   ! symmetric case
   A = mfDiag( mf([ 1.0d0, 2.0d0, 3.0d0, 4.0d0, 5.0d0 ]) )
   call msDisplay(A, "A")

   ! (check with mfEig)
   v = mfEig(A)
   call msDisplay(v, "All eigenvalues from mfEig()")

   print "(/,A)", "*** test number 289 ***"
   d = mfEigs( A, 2, (2.5d0,0.5d0) )
   call msDisplay(d, "Eigenvalues closed to sigma = (2.5,0.5)")

   ! (check with msEig)
   call msEig( mfOut(V,D), A )
   call msDisplay(V, "All eigenvectors from msEig()")

   print "(/,A)", "*** test number 290 ***"
   call msEigs( mfOut(V,D,flag), A, 2, (2.5d0,0.5d0) )
   call msDisplay(V, "Corresponding eigenvectors from msEigs()")
   call msDisplay( flag, "All requested eigenvalues converged?" )

   ! unsymmetric case
   allocate( ir(9), jc(9), val(9) )
   ir(:) = [ 1, 1, 2, 2, 3, 4, 4, 5, 5 ]
   jc(:) = [ 1, 5, 2, 4, 3, 2, 4, 1, 5 ]
   val(:) = [ 2.0d0, -1.0d0, 1.0d0, -3.0d0, 1.0d0, 3.0d0, 1.0d0, 1.0d0, 2.0d0 ]

   A = mfSpImport(ir,jc,val)
   call msDisplay(A, "A = mfSpImport(ir,jc,val)")

   B = mfFull(A)
   call msDisplay(B, "")

   deallocate( ir, jc, val )

   ! (check with mfEig)
   v = mfEig(B)
   call msDisplay(v, "All eigenvalues from mfEig()")

   print "(/,A)", "*** test number 291 ***"
   d = mfEigs( A, 1, (1.2d0,2.8d0) )
   call msDisplay(d, "Eigenvalue closed to sigma = (1.2,2.8)")

   ! (check with msEig)
   call msEig( mfOut(V,D), B )
   !call msDisplay(V, "All eigenvectors from msEig()")

   print "(/,A)", "*** test number 292 ***"
   call msEigs( mfOut(V,D,flag), A, 1, (1.2d0,2.8d0) )
   !call msDisplay(V, "Corresponding eigenvectors from msEigs()")
   call msDisplay( flag, "All requested eigenvalues converged?" )
   ! extracts eigenvector
   vec = mfGet( V, MF_COLON, 1 )
   ! compute index for good values
   ind = mfFind( mfAbs(vec) > sqrt(MF_EPS) )
   ! RHS
   A_vec = mfMul(A,vec)
   ! element-wise division
   lambda = mfGet( A_vec/vec, ind )
   call msDisplay( mfMean(lambda),                                      &
        "mean( A*vec ./ vec ) for non-zero components of eigenvect #1" )

   !-- other tests

   !-- 'test11.mtx'

   A = mfLoadSparse( "data/test11.mtx", format="MTX" )
   call msDisplay(A, "A = mfLoadSparse( 'data/test11.mtx', format='MTX' )")

   B = mfFull(A)
   call msDisplay(B, "")

   ! (check with mfEig)
   v = mfEig(B)
   call msDisplay(v, "All eigenvalues from mfEig()")

   ! test about LM or SM eigenvalues must be discarded, because the
   ! eigenvalues have all the same module!

   print "(/,A)", "*** test number 293 ***"
   d = mfEigs( A, 2, sigma=(1.0d0,1.0d0) )
   call msDisplay(d, "Eigenvalues closest to (1.0,1.0) from mfEigs()")

   print "(/,A)", "*** test number 294 ***"
   call msEigs( mfOut(V,D,flag), A, 2, sigma=(1.0d0,1.0d0) )
   !call msDisplay(V, "Eigenvalues closest to (1.0,1.0) from mfEigs()")
   call msDisplay(flag, "All requested eigenvalues converged?")
   ! extracts eigenvector
   vec = mfGet( V, MF_COLON, 1 )
   ! compute index for good values
   ind = mfFind( mfAbs(vec) > sqrt(MF_EPS) )
   ! RHS
   A_vec = mfMul(A,vec)
   ! element-wise division
   lambda = mfGet( A_vec/vec, ind )
   call msDisplay( mfMean(lambda),                                      &
        "mean( A*vec ./ vec ) for non-zero components of eigenvect #1" )
   ! extracts eigenvector
   vec = mfGet( V, MF_COLON, 2 )
   ! compute index for good values
   ind = mfFind( mfAbs(vec) > sqrt(MF_EPS) )
   ! RHS
   A_vec = mfMul(A,vec)
   ! element-wise division
   lambda = mfGet( A_vec/vec, ind )
   call msDisplay( mfMean(lambda),                                      &
        "mean( A*vec ./ vec ) for non-zero components of eigenvect #2" )

   !-- 'lap_64.mtx'

   A = mfLoadSparse( "data/lap_64.mtx", format="MTX" )
   print *, "A = mfLoadSparse( 'data/lap_64.mtx', format='MTX' )"
   call msDisplay( mfShape(A), "mfShape(A)" )
   call msDisplay( mfNnz(A), "mfNnz(A)" )

   print "(/,A)", "*** test number 295 ***"
   d = mfEigs( A, 2, "LM" )
   call msDisplay(d, "Largest eigenvalues from mfEigs()")

   print "(/,A)", "*** test number 296 ***"
   call msEigs( mfOut(V,D,flag), A, 2 ) ! default : "LM"
   call msDisplay(flag, "All requested eigenvalues converged?")
   ! extracts eigenvector
   vec = mfGet( V, MF_COLON, 1 )
   ! compute index for good values
   ind = mfFind( mfAbs(vec) > sqrt(MF_EPS) )
   ! RHS
   A_vec = mfMul(A,vec)
   ! element-wise division
   lambda = mfGet( A_vec/vec, ind )
   call msDisplay( mfMean(lambda),                                      &
        "mean( A*vec ./ vec ) for non-zero components of eigenvect #1" )
   ! extracts eigenvector
   vec = mfGet( V, MF_COLON, 2 )
   ! compute index for good values
   ind = mfFind( mfAbs(vec) > sqrt(MF_EPS) )
   ! RHS
   A_vec = mfMul(A,vec)
   ! element-wise division
   lambda = mfGet( A_vec/vec, ind )
   call msDisplay( mfMean(lambda),                                      &
        "mean( A*vec ./ vec ) for non-zero components of eigenvect #2" )

   print "(/,A)", "*** test number 297 ***"
   d = mfEigs( A, 2, "SM" )
   call msDisplay(d, "Smallest eigenvalues from mfEigs()")

   print "(/,A)", "*** test number 298 ***"
   call msEigs( mfOut(V,D,flag), A, 2, "SM" )
   call msDisplay(flag, "All requested eigenvalues converged?")
   ! extracts eigenvector
   vec = mfGet( V, MF_COLON, 1 )
   ! compute index for good values
   ind = mfFind( mfAbs(vec) > sqrt(MF_EPS) )
   ! RHS
   A_vec = mfMul(A,vec)
   ! element-wise division
   lambda = mfGet( A_vec/vec, ind )
   call msDisplay( mfMean(lambda),                                      &
        "mean( A*vec ./ vec ) for non-zero components of eigenvect #1" )
   ! extracts eigenvector
   vec = mfGet( V, MF_COLON, 2 )
   ! compute index for good values
   ind = mfFind( mfAbs(vec) > sqrt(MF_EPS) )
   ! RHS
   A_vec = mfMul(A,vec)
   ! element-wise division
   lambda = mfGet( A_vec/vec, ind )
   call msDisplay( mfMean(lambda),                                      &
        "mean( A*vec ./ vec ) for non-zero components of eigenvect #2" )

   !-- 'aglo.mtx'        (using 'ncv' optional arg.)

   A = mfLoadSparse( "data/aglo.mtx", format="MTX" )
   print *, "A = mfLoadSparse( 'data/aglo.mtx', format='MTX' )"
   call msDisplay( mfShape(A), "mfShape(A)" )
   call msDisplay( mfNnz(A), "mfNnz(A)" )
   bool = mfIsSymm(A)
   print *, "mfIsSymm(A) : ", bool

   print "(/,A)", "*** test number 299 ***"
   d = mfEigs( A, 2, "LM", ncv=20 )
   call msDisplay(d, "Largest eigenvalues from mfEigs()")

   print "(/,A)", "*** test number 300 ***"
   call mf_save_and_disable_fpe( )
   call msEigs( mfOut(V,D,flag), A, 2, ncv=4 ) ! default : "LM"
   call msDisplay(flag, "With ncv=4: all eigenvalues converged?")
   call msDisplay(D, "Largest eigenvalues from msEigs (NaN indicates non-converged EV)")
   call mf_restore_fpe( )
   call msEigs( mfOut(V,D,flag), A, 2, ncv=20 ) ! default : "LM"
   call msDisplay(flag, "With ncv=20: all eigenvalues converged?")
   call msDisplay(D, "Largest eigenvalues from msEigs")
   ! extracts eigenvector
   vec = mfGet( V, MF_COLON, 1 )
   ! compute index for good values
   ind = mfFind( mfAbs(vec) > sqrt(MF_EPS) )
   ! RHS
   A_vec = mfMul(A,vec)
   ! element-wise division
   lambda = mfGet( A_vec/vec, ind )
   tmp = mfMean(lambda)
   call zeroes_small_values( tmp, 1.0d-4 )
   call msDisplay( tmp,                                                 &
        "mean( A*vec ./ vec ) for non-zero components of eigenvect #1" )
   ! extracts eigenvector
   vec = mfGet( V, MF_COLON, 2 )
   ! compute index for good values
   ind = mfFind( mfAbs(vec) > sqrt(MF_EPS) )
   ! RHS
   A_vec = mfMul(A,vec)
   ! element-wise division
   lambda = mfGet( A_vec/vec, ind )
   tmp = mfMean(lambda)
   call zeroes_small_values( tmp, 1.0d-4 )
   call msDisplay( tmp,                                                 &
        "mean( A*vec ./ vec ) for non-zero components of eigenvect #2" )

   print "(/,A)", "*** test number 301 ***"
   d = mfEigs( A, 2, "SM", ncv=20 )
   call msDisplay(d, "Smallest eigenvalues from mfEigs()")

   print "(/,A)", "*** test number 302 ***"
   call msEigs( mfOut(V,D,flag), A, 2, "SM", ncv=20 )
   call msDisplay(flag, "All requested eigenvalues converged?")
   ! extracts eigenvector
   vec = mfGet( V, MF_COLON, 1 )
   ! compute index for good values
   ind = mfFind( mfAbs(vec) > sqrt(MF_EPS) )
   ! RHS
   A_vec = mfMul(A,vec)
   ! element-wise division
   lambda = mfGet( A_vec/vec, ind )
   call msDisplay( mfMean(lambda),                                      &
        "mean( A*vec ./ vec ) for non-zero components of eigenvect #1" )
   ! extracts eigenvector
   vec = mfGet( V, MF_COLON, 2 )
   ! compute index for good values
   ind = mfFind( mfAbs(vec) > sqrt(MF_EPS) )
   ! RHS
   A_vec = mfMul(A,vec)
   ! element-wise division
   lambda = mfGet( A_vec/vec, ind )
   call msDisplay( mfMean(lambda),                                      &
        "mean( A*vec ./ vec ) for non-zero components of eigenvect #2" )

   ! mfRCond -----------------------------------------------------------
   call print_separation("mfRCond")

   !-- real unsymmetric (via UMFPACK)

   allocate( ir(9), jc(9), val(9) )
   ir(:) = [ 1, 1, 2, 2, 3, 4, 4, 5, 5 ]
   jc(:) = [ 1, 5, 2, 4, 3, 2, 4, 1, 5 ]
   val(:) = [ 2.0d0, -1.0d0, 1.0d0, -3.0d0, 1.0d0, 3.0d0, 1.0d0, 1.0d0, 2.0d0 ]

   A = mfSpImport(ir,jc,val)
   call msDisplay(A, "A = mfSpImport(ir,jc,val)")

   B = mfFull(A)
   call msDisplay(B, "")

   deallocate( ir, jc, val )

   print "(/,A)", "*** test number 303 ***"
   call msDisplay( mfRCond(A), "mfRCond(A) [estimation for sparse matrices]" )

   print "(/,A)", "*** test number 304 ***"
   call msDisplay( mfRCond(B), "mfRCond(mfFull(A))" )

   !-- real symmetric (via CHOLMOD)

   allocate( ir(9), jc(9), val(9) )
   ir(:) = [ 1, 1, 2, 2, 3, 4, 4, 5, 5 ]
   jc(:) = [ 1, 5, 2, 4, 3, 2, 4, 1, 5 ]
   val(:) = [ 2.0d0, 1.0d0, 1.0d0, 3.0d0, 1.0d0, 3.0d0, 1.0d0, 1.0d0, 2.0d0 ]

   A = mfSpImport(ir,jc,val)
   call msDisplay(A, "A = mfSpImport(ir,jc,val)")

   B = mfFull(A)
   call msDisplay(B, "")

   deallocate( ir, jc, val )

   print "(/,A)", "*** test number 305 ***"
   call msDisplay( mfRCond(A), "mfRCond(A) [estimation for sparse matrices]" )

   print "(/,A)", "*** test number 306 ***"
   call msDisplay( mfRCond(B), "mfRCond(mfFull(A))" )

   !-- singular matrix

   allocate( ir(9), jc(9), val(9) )
   ir(:) = [ 1, 1, 2, 2, 3, 4, 4, 5, 5 ]
   jc(:) = [ 1, 5, 2, 4, 3, 2, 4, 1, 5 ]
   val(:) = [ 2.0d0, 1.0d0, 1.0d0, 1.0d0, 1.0d0, 1.0d0, 1.0d0, 1.0d0, 2.0d0 ]

   A = mfSpImport(ir,jc,val)
   call msDisplay(A, "A = mfSpImport(ir,jc,val)")

   B = mfFull(A)
   call msDisplay(B, "")

   deallocate( ir, jc, val )

   print "(/,A)", "*** test number 307 ***"
   call msDisplay( mfRCond(A), "mfRCond(A) [estimation for sparse matrices]" )

   print "(/,A)", "*** test number 308 ***"
   call msDisplay( mfRCond(B), "mfRCond(mfFull(A))" )

   ! --- complex sparse
   A = A*MF_I + mfSpEye(5)
   call msDisplay(A, "A = A*MF_I + mfSpEye(5)")

   B = mfFull(A)
   call msDisplay(B, "")

   print "(/,A)", "*** test number 309 ***"
   call msDisplay( mfRCond(A), "mfRCond(A) [estimation for sparse matrices]" )

   print "(/,A)", "*** test number 310 ***"
   call msDisplay( mfRCond(B), "mfRCond(mfFull(A))" )

   ! mfSVDS ------------------------------------------------------------
   call print_separation("mfSVDS")

   ! --- simple case
   A = mfSpDiags( 5, 5,                                                 &
                  .t. mf([ 1.0d0, 2.0d0, 3.0d0, 4.0d0, 5.0d0 ]), 0 )
   call msDisplay(A, "A")

   B = mfFull(A)
   call msDisplay(B, "")

   print "(/,A)", "*** test number 311 ***"
   d = mfSVDS( A, 3 )
   call msDisplay(d, "Largest singular values from mfSVDS()")

   print "(/,A)", "*** test number 312 ***"
   d = mfSVDS( A, 3, "SM" )
   call msDisplay(d, "Smallest singular values from mfSVDS()")

   ! check with mfSVD
   v = mfSVD(B)
   call msDisplay(v, "All singular values from mfSVD()")

   ! --- unsymmetric matrix
   allocate( ir(9), jc(9), val(9) )
   ir(:) = [ 1, 1, 2, 2, 3, 4, 4, 5, 5 ]
   jc(:) = [ 1, 5, 2, 4, 3, 2, 4, 1, 5 ]
   val(:) = [ 2.0d0, -1.0d0, 1.0d0, -3.0d0, 1.0d0, 3.0d0, 1.0d0, 1.0d0, 2.0d0 ]

   A = mfSpImport(ir,jc,val)
   call msDisplay(A, "A = mfSpImport(ir,jc,val)")

   B = mfFull(A)
   call msDisplay(B, "")

   deallocate( ir, jc, val )

   call msDisplay(mfCond(B),"CN(A)")

   print "(/,A)", "*** test number 313 ***"
   d = mfSVDS( A, 3, "LM" )
   call msDisplay(d, "Largest singular values from mfSVDS()")

   print "(/,A)", "*** test number 314 ***"
   d = mfSVDS( A, 3, "SM" )
   call msDisplay(d, "Smallest singular values from mfSVDS()")

   ! check with mfSVD
   v = mfSVD(B)
   call msDisplay(v, "All singular values from mfSVD()")

   ! --- rank deficient
   allocate( ir(9), jc(9), val(9) )
   ir(:) = [ 1, 1, 2, 2, 3, 4, 4, 5, 5 ]
   jc(:) = [ 1, 5, 2, 4, 3, 2, 4, 1, 5 ]
   val(:) = [ 2.0d0, 1.0d0, 1.0d0, 1.0d0, 1.0d0, 1.0d0, 1.0d0, 1.0d0, 2.0d0 ]

   A = mfSpImport(ir,jc,val)
   call msDisplay(A, "A = mfSpImport(ir,jc,val)")

   B = mfFull(A)
   call msDisplay(B, "")

   deallocate( ir, jc, val )

   call msDisplay(mfRCond(B),"RCond(A)")

   print "(/,A)", "*** test number 315 ***"
   d = mfSVDS( A, 3 )
   call msDisplay(d, "Largest singular values from mfSVDS()")

   print "(/,A)", "*** test number 316 ***"
   d = mfSVDS( A, 3, "SM" )
   call round_values( d, 6 )
   call msDisplay(d, "Smallest singular values from mfSVDS()")

   ! check with mfSVD
   v = mfSVD(B)
   call msDisplay(v, "All singular values from mfSVD()")

   ! --- complex case (general)
   allocate( ir(9), jc(9), val(9) )
   ir(:) = [ 1, 1, 2, 2, 3, 4, 4, 5, 5 ]
   jc(:) = [ 1, 5, 2, 4, 3, 2, 4, 1, 5 ]
   val(:) = [ 2.0d0, -1.0d0, 1.0d0, -3.0d0, 1.0d0, 3.0d0, 1.0d0, 1.0d0, 2.0d0 ]

   A = mfSpImport(ir,jc,val)
   A = A*MF_I + mfSpEye(5)
   call msDisplay(A, "A")

   B = mfFull(A)
   call msDisplay(B, "")

   deallocate( ir, jc, val )

   call msDisplay(mfCond(B),"CN(A)")

   print "(/,A)", "*** test number 317 ***"
   d = mfSVDS( A, 3, "LM" )
   call msDisplay(d, "Largest singular values from mfSVDS()")

   print "(/,A)", "*** test number 318 ***"
   d = mfSVDS( A, 3, "SM" )
   call msDisplay(d, "Smallest singular values from mfSVDS()")

   ! check with mfSVD
   v = mfSVD(B)
   call msDisplay(v, "All singular values from mfSVD()")

   ! msSVDS ------------------------------------------------------------
   call print_separation("msSVDS")

   ! --- unsymmetric matrix
   allocate( ir(9), jc(9), val(9) )
   ir(:) = [ 1, 1, 2, 2, 3, 4, 4, 5, 5 ]
   jc(:) = [ 1, 5, 2, 4, 3, 2, 4, 1, 5 ]
   val(:) = [ 2.0d0, -1.0d0, 1.0d0, -3.0d0, 1.0d0, 3.0d0, 1.0d0, 1.0d0, 2.0d0 ]

   A = mfSpImport(ir,jc,val)
   call msDisplay(A, "A = mfSpImport(ir,jc,val)")

   B = mfFull(A)
   call msDisplay(B, "")

   deallocate( ir, jc, val )

   call msDisplay(mfCond(B),"CN(A)")

   print "(/,A)", "*** test number 319 ***"
   D = mfSvd( B )
   call msDisplay( D, "(all singular values from mfSvd) S" )

   call msSVDS( mfOut(d,flag), A, 3, "LM" )
   call msDisplay(d, "Largest singular values from msSVDS()")
   call msDisplay(flag, "All requested eigenvalues converged?")
   call msSVDS( mfOut(d,flag), A, 3, "SM" )
   call msDisplay(d, "Smallest singular values from msSVDS()")
   call msDisplay(flag, "All requested eigenvalues converged?")
   call msSVDS( mfOut(d,flag), A, 3, "BE" )
   call msDisplay(d, "Both-end singular values from msSVDS()")
   call msDisplay(flag, "All requested eigenvalues converged?")

   A = mfLoadSparse( "data/aglo.mtx" )
   print *, "A = mfLoadSparse( 'data/aglo.mtx' ) : ok"
   call msDisplay( mfShape(A), "Shape(A)" )
   call msDisplay( mfNnz(A), "Nnz(A)" )

   B = mfFull(A)
   call msDisplay(mfCond(B),"CN(A)")
   call msDisplay(mfCondest(A),"condest(A)")

   print "(/,A)", "*** test number 320 ***"
   call msSVDS( mfOut(d,flag), A, 1, "LM" )
   print *, "call msSVDS( mfOut(d,flag), A, 1, 'LM' )"
   call msDisplay(d, "Largest singular value from msSVDS()")
   call msDisplay(flag, "All requested eigenvalues converged?")
   call msSVDS( mfOut(d,flag), A, 1, "SM" )
   print *, "call msSVDS( mfOut(d,flag), A, 1, 'SM' )"
   call msDisplay(d, "Smallest singular value from msSVDS()")
   call msDisplay(flag, "All requested eigenvalues converged?")
   call msSVDS( mfOut(d,flag), A, 2, "BE" )
   print *, "call msSVDS( mfOut(d,flag), A, 2, 'BE' )"
   call msDisplay(d, "Both-end singular value from msSVDS()")
   call msDisplay(flag, "All requested eigenvalues converged?")

   print "(/,A)", "*** test number 321 ***"
   call msSVDS( mfOut(d,flag), A, 1, "LM", ncv=16 )
   print *, "call msSVDS( mfOut(d,flag), A, 1, 'LM', ncv=16 )"
   call msDisplay(d, "Largest singular value from msSVDS()")
   call msDisplay(flag, "All requested eigenvalues converged?")

   ! mfCond ------------------------------------------------------------
   call print_separation("mfCond")

   ! --- simple case
   A = mfSpDiags( 5, 5,                                                 &
                  .t. mf([ 1.0d0, 2.0d0, 3.0d0, 4.0d0, 5.0d0 ]), 0 )
   call msDisplay(A, "A")

   B = mfFull(A)
   call msDisplay(B, "")

   print "(/,A)", "*** test number 322 ***"
   d = mfCond( A )
   call msDisplay(d, "CN(A) [sparse case, via SVDS -- ARPACK]")

   ! check
   print "(/,A)", "*** test number 323 ***"
   v = mfCond(B)
   call msDisplay(v, "CN(A) [dense case, via Lapack]")

   ! --- unsymmetric matrix
   allocate( ir(9), jc(9), val(9) )
   ir(:) = [ 1, 1, 2, 2, 3, 4, 4, 5, 5 ]
   jc(:) = [ 1, 5, 2, 4, 3, 2, 4, 1, 5 ]
   val(:) = [ 2.0d0, -1.0d0, 1.0d0, -3.0d0, 1.0d0, 3.0d0, 1.0d0, 1.0d0, 2.0d0 ]

   A = mfSpImport(ir,jc,val)
   call msDisplay(A, "A = mfSpImport(ir,jc,val)")

   B = mfFull(A)
   call msDisplay(B, "")

   deallocate( ir, jc, val )

   print "(/,A)", "*** test number 324 ***"
   d = mfCond( A )
   call msDisplay(d, "CN(A) [sparse case, via SVDS -- ARPACK]")

   ! check
   print "(/,A)", "*** test number 325 ***"
   v = mfCond(B)
   call msDisplay(v, "CN(A) [dense case, via Lapack]")

   ! --- rank deficient

   allocate( ir(9), jc(9), val(9) )
   ir(:) = [ 1, 1, 2, 2, 3, 4, 4, 5, 5 ]
   jc(:) = [ 1, 5, 2, 4, 3, 2, 4, 1, 5 ]
   val(:) = [ 2.0d0, 1.0d0, 1.0d0, 1.0d0, 1.0d0, 1.0d0, 1.0d0, 1.0d0, 2.0d0 ]

   A = mfSpImport(ir,jc,val)
   call msDisplay(A, "A = mfSpImport(ir,jc,val)")

   B = mfFull(A)
   call msDisplay(B, "")

   deallocate( ir, jc, val )

   print "(/,A)", "*** test number 326 ***"
   d = mfCond( A )
   call msDisplay(d, "CN(A) [sparse case, via SVDS -- ARPACK]")

   ! check
   print "(/,A)", "*** test number 327 ***"
   v = mfCond(B)
   if( mfDble(v) > 1.0d0/MF_EPS ) then
      v = MF_INF
   end if
   call msDisplay(v, "CN(A) [dense case, via Lapack]")

   ! mfColPerm ---------------------------------------------------------
   call print_separation("mfColPerm")

   ! real case
   print "(/,A)", "*** test number 328 ***"
   allocate( ir(6), jc(6), val(6) )
   ir(:) = [ 1, 2, 3, 4, 5, 6 ]
   jc(:) = [ 1, 2, 3, 4, 5, 6 ]
   val(:) = [ 1.0d0, 2.0d0, 3.0d0, 4.0d0, 5.0d0, 6.0d0 ]

   A = mfSpImport(ir,jc,val)
   call msDisplay(A, "A = mfSpImport(ir,jc,val)")

   deallocate( ir, jc, val )

   p = [ 1, 3, 5, 2, 4, 6 ]
   call msDisplay(p, "permutation p")

   B = mfColPerm( A, p )
   call msDisplay(B, "mfColPerm(A,p) = A(:,p)")

   ! msColPerm ---------------------------------------------------------
   call print_separation("msColPerm")

   ! real case
   print "(/,A)", "*** test number 329 ***"
   allocate( ir(6), jc(6), val(6) )
   ir(:) = [ 1, 2, 3, 4, 5, 6 ]
   jc(:) = [ 1, 2, 3, 4, 5, 6 ]
   val(:) = [ 1.0d0, 2.0d0, 3.0d0, 4.0d0, 5.0d0, 6.0d0 ]

   A = mfSpImport(ir,jc,val)
   call msDisplay(A, "A = mfSpImport(ir,jc,val)")

   deallocate( ir, jc, val )

   p = [ 1, 3, 5, 2, 4, 6 ]
   call msDisplay(p, "permutation p")

   call msColPerm( A, p )
   call msDisplay(A, "after 'call msColPerm(A,p)': A")

   ! mfRowPerm ---------------------------------------------------------
   call print_separation("mfRowPerm")

   ! real case
   print "(/,A)", "*** test number 330 ***"
   allocate( ir(6), jc(6), val(6) )
   ir(:) = [ 1, 2, 3, 4, 5, 6 ]
   jc(:) = [ 1, 2, 3, 4, 5, 6 ]
   val(:) = [ 1.0d0, 2.0d0, 3.0d0, 4.0d0, 5.0d0, 6.0d0 ]

   A = mfSpImport(ir,jc,val)
   call msDisplay(A, "A = mfSpImport(ir,jc,val)")

   deallocate( ir, jc, val )

   p = [ 1, 3, 5, 2, 4, 6 ]
   call msDisplay(p, "permutation p")

   B = mfRowPerm( A, p )
   call msDisplay(B, "mfRowPerm(A,p) = A(p,:)")

   ! msRowPerm ---------------------------------------------------------
   call print_separation("msRowPerm")

   ! real case
   print "(/,A)", "*** test number 331 ***"
   allocate( ir(6), jc(6), val(6) )
   ir(:) = [ 1, 2, 3, 4, 5, 6 ]
   jc(:) = [ 1, 2, 3, 4, 5, 6 ]
   val(:) = [ 1.0d0, 2.0d0, 3.0d0, 4.0d0, 5.0d0, 6.0d0 ]

   A = mfSpImport(ir,jc,val)
   call msDisplay(A, "A = mfSpImport(ir,jc,val)")

   deallocate( ir, jc, val )

   p = [ 1, 3, 5, 2, 4, 6 ]
   call msDisplay(p, "permutation p")

   call msRowPerm( A, p )
   call msDisplay(A, "after 'call msRowPerm(A,p)': A")

   ! mfColScale --------------------------------------------------------
   call print_separation("mfColScale")

   ! real case
   print "(/,A)", "*** test number 332 ***"
   allocate( ir(6), jc(6), val(6) )
   ir(:) = [ 1, 2, 3, 4, 5, 6 ]
   jc(:) = [ 1, 2, 3, 4, 5, 6 ]
   val(:) = [ 1.0d0, 2.0d0, 3.0d0, 4.0d0, 5.0d0, 6.0d0 ]

   A = mfSpImport(ir,jc,val)
   call msDisplay(A, "A = mfSpImport(ir,jc,val)")

   deallocate( ir, jc, val )

   C = [ 3.5d0, 3.0d0, 2.5d0, 2.0d0, 1.5d0, 1.0d0 ]
   call msDisplay(C, "scaling C")

   B = mfColScale( A, C )
   call msDisplay(B, "mfColScale(A,C)")

   ! msColScale --------------------------------------------------------
   call print_separation("msColScale")

   ! real case
   print "(/,A)", "*** test number 333 ***"
   allocate( ir(6), jc(6), val(6) )
   ir(:) = [ 1, 2, 3, 4, 5, 6 ]
   jc(:) = [ 1, 2, 3, 4, 5, 6 ]
   val(:) = [ 1.0d0, 2.0d0, 3.0d0, 4.0d0, 5.0d0, 6.0d0 ]

   A = mfSpImport(ir,jc,val)
   call msDisplay(A, "A = mfSpImport(ir,jc,val)")

   deallocate( ir, jc, val )

   C = [ 3.5d0, 3.0d0, 2.5d0, 2.0d0, 1.5d0, 1.0d0 ]
   call msDisplay(C, "scaling C")

   call msColScale( A, C )
   call msDisplay(A, "after 'call msColScale(A,C)': A")

   ! mfRowScale --------------------------------------------------------
   call print_separation("mfRowScale")

   ! real case
   print "(/,A)", "*** test number 334 ***"
   allocate( ir(6), jc(6), val(6) )
   ir(:) = [ 1, 2, 3, 4, 5, 6 ]
   jc(:) = [ 1, 2, 3, 4, 5, 6 ]
   val(:) = [ 1.0d0, 2.0d0, 3.0d0, 4.0d0, 5.0d0, 6.0d0 ]

   A = mfSpImport(ir,jc,val)
   call msDisplay(A, "A = mfSpImport(ir,jc,val)")

   deallocate( ir, jc, val )

   R = [ 3.5d0, 3.0d0, 2.5d0, 2.0d0, 1.5d0, 1.0d0 ]
   call msDisplay(R, "scaling R")

   B = mfColScale( A, R )
   call msDisplay(B, "mfRowScale(A,R)")

   ! msRowScale --------------------------------------------------------
   call print_separation("msRowScale")

   ! real case
   print "(/,A)", "*** test number 335 ***"
   allocate( ir(6), jc(6), val(6) )
   ir(:) = [ 1, 2, 3, 4, 5, 6 ]
   jc(:) = [ 1, 2, 3, 4, 5, 6 ]
   val(:) = [ 1.0d0, 2.0d0, 3.0d0, 4.0d0, 5.0d0, 6.0d0 ]

   A = mfSpImport(ir,jc,val)
   call msDisplay(A, "A = mfSpImport(ir,jc,val)")

   deallocate( ir, jc, val )

   R = [ 3.5d0, 3.0d0, 2.5d0, 2.0d0, 1.5d0, 1.0d0 ]
   call msDisplay(R, "scaling R")

   call msColScale( A, R )
   call msDisplay(A, "after 'call msRowScale(A,R)': A")

   ! msColAutoScale ----------------------------------------------------
   call print_separation("msColAutoScale")

   ! real case
   print "(/,A)", "*** test number 336 ***"
   allocate( ir(8), jc(8), val(8) )
   ir(:) = [ 1, 2, 3, 4, 5, 6, 6, 1 ]
   jc(:) = [ 1, 2, 3, 4, 5, 6, 1, 6 ]
   val(:) = [ 1.0d0, 2.0d0, 3.0d0, 4.0d0, 5.0d0, 6.0d0, 2.0d0, 12.0d0 ]

   A = mfSpImport(ir,jc,val)
   call msDisplay(A, "A = mfSpImport(ir,jc,val)")

   deallocate( ir, jc, val )

   call msColAutoScale( mfOut(s), A )
   call msDisplay(A, "after 'call msColScale(mfOut(s),A)': A",          &
                  s, "scaling used")

   ! msRowAutoScale ----------------------------------------------------
   call print_separation("msRowAutoScale")

   ! real case
   print "(/,A)", "*** test number 337 ***"
   allocate( ir(8), jc(8), val(8) )
   ir(:) = [ 1, 2, 3, 4, 5, 6, 6, 1 ]
   jc(:) = [ 1, 2, 3, 4, 5, 6, 1, 6 ]
   val(:) = [ 1.0d0, 2.0d0, 3.0d0, 4.0d0, 5.0d0, 6.0d0, 2.0d0, 12.0d0 ]

   A = mfSpImport(ir,jc,val)
   call msDisplay(A, "A = mfSpImport(ir,jc,val)")

   deallocate( ir, jc, val )

   call msRowAutoScale( mfOut(s), A )
   call msDisplay(A, "after 'call msRowScale(mfOut(s),A)': A",          &
                  s, "scaling used")

   ! End of tests ------------------------------------------------------
   print "(A)", "                         ┏━━━━━━━━━━━━━━━━━━━━━━━━━━┓"
   print "(A)", "                         ┃ End of test_mod_sparse_1 ┃"
   print "(A)", "                         ┗━━━━━━━━━━━━━━━━━━━━━━━━━━┛"

   !--------------------------------------------------------------------
99 continue

   print "()"
   call msSetMsgLevel(2)

   call msRelease( A, B, C, v, x, y, d )
   call msRelease( L, U, P, Q, R, E, s )
   call msRelease( vec, A_vec, lambda, ind, flag, tmp )

   ! non official Muesli routine: introduced here to clean memory
   call RngStream_end()

end program
