module my_funs

   use fml

contains

   function my_exp( z1 ) result( z2 )
      complex(kind=MF_DOUBLE) :: z1, z2
      z2 = exp( z1 )
   end function my_exp

   function sqr( z1 ) result( z2 )
      complex(kind=MF_DOUBLE) :: z1, z2
      z2 = z1**2
   end function sqr

   function pow_3_half( z1 ) result( z2 )
      complex(kind=MF_DOUBLE) :: z1, z2
      z2 = z1**1.5
   end function pow_3_half

end module
!_______________________________________________________________________
!
program test_mod_matfun_2

   use fml

   use test_aux
   use lib_aux

   use my_funs

   implicit none

   type(mfArray) :: x, A, L, U, P, B, S, V, AI, Q, R, T, D, H
   type(mfArray) :: A_sym, A_nonsym, A_herm, A_nonherm, C, F, E, jpiv
   type(mfArray) :: flag
   real(kind=MF_DOUBLE), pointer :: A_ptr(:,:)
   real(kind=MF_DOUBLE), allocatable :: f90_array(:,:)
   integer :: i, n, nev
   integer :: MsgLevel_save
   real(kind=MF_DOUBLE) :: check_small_threshold = 1.0d3*MF_EPS
   logical :: bool

   character(len=24) :: arpack_version
   character(len=128) :: arpack_info

   ! Msg level = 3 : all messages are printed (verbose mode)
   !             2 : messages of kind 'ERROR' and 'Warning' are
   !                 printed [default]
   !             1 : only messages of kind 'ERROR' are printed
   !             0 : nothing is printed (quiet mode)
   !                 (pause are ignored !)

!!   call msSetMsgLevel(3)
!!   call msSetTrbLevel("all")

   print "()"

   ! for TRACE_MEM_DEBUG, STDERR must be redirected to STDOUT;
   ! the same thing stands for 'make check'
   call msSetStdIO( stderr=STDOUT )

!!goto 10

   ! to avoid escape sequences of color setting in the output file
   ! (default in "on")
   call msSetColoredMsg( "off" )

   ! VERSIONs ----------------------------------------------------------
   print "()"
   print *, "MF_MUESLI_VERSION = '", MF_MUESLI_VERSION, "'"
   print "()"
   print *, "MF_COMPILER_VERSION = '", MF_COMPILER_VERSION, "'"
   print "()"
   print *, "MF_COMPILATION_CONFIG = '", MF_COMPILATION_CONFIG(), "'"

   print "()"
   call msGetArpackInfo( arpack_version, arpack_info )
   print *, "ARPACK version = '", trim(arpack_version), "'"
   print "()"
   print *, "ARPACK info = '", trim(arpack_info), "'"
   print "()"

   ! mfEig -------------------------------------------------------------
   call print_separation("mfEig")

   ! real matrices
   A = mf( reshape( [ 10, 7, 5, 20, 8, 15, 30, 9, 25 ], [ 3, 3 ] ) )
   call sym_decmp( mfOut(A_sym,A_nonsym), A )

   print "(/,A)", "*** test number 1 ***"
   call msDisplay(A_sym,"A_sym")
   B = mfEig( A_sym )
   call msDisplay(B,"eig(A_sym)")

   print "(/,A)", "*** test number 2 ***"
   call msDisplay(A_nonsym,"A_nonsym")
   B = mfEig( A_nonsym )
   call msDisplay(B,"eig(A_nonsym)")

   ! complex matrices
   A = A + MF_I*mf( reshape( [ (5-i, i = 1, 9) ], [ 3, 3 ] ) )
   A_herm = 0.5d0*(A + .h. A)

   print "(/,A)", "*** test number 3 ***"
   call msDisplay(A_herm,"A_herm")
   B = mfEig( A_herm )
   call msDisplay(B,"eig(A_herm)")

   print "(/,A)", "*** test number 4 ***"
   A_nonherm = A
   call msDisplay(A_nonherm,"A_nonherm")
   B = mfEig( A_nonherm )
   call msDisplay(B,"eig(A_nonherm)")

   ! msEig -------------------------------------------------------------
   call print_separation("msEig")

   ! real matrices
   A = mf( reshape( [ 10, 7, 5, 20, 8, 15, 30, 9, 25 ], [ 3, 3 ] ) )
   call sym_decmp( mfOut(A_sym,A_nonsym), A )

   print "(/,A)", "*** test number 5 ***"
   call msDisplay(A_sym,"A_sym")
   call msEig( mfOut(V,D), A_sym )
   call msDisplay(D,"D",V,"V")
   call check_small( mfNorm(mfMul(A_sym,V)-mfMul(V,D)), "norm(A*V - V*D)", &
                     check_small_threshold )

   print "(/,A)", "*** test number 6 ***"
   call msDisplay(A_nonsym,"A_nonsym")
   call msEig( mfOut(V,D), A_nonsym )
   call msDisplay(D,"D",V,"V")
   call check_small( mfNorm(mfMul(A_nonsym,V)-mfMul(V,D)), "norm(A*V - V*D)", &
                     check_small_threshold )

   ! complex matrices
   A = A + MF_I*mf( reshape( [ (5-i, i = 1, 9) ], [ 3, 3 ] ) )
   A_herm = 0.5d0*(A + .h. A)

   print "(/,A)", "*** test number 7 ***"
   call msDisplay(A_herm,"A_herm")
   call msEig( mfOut(V,D), A_herm )
   call msDisplay(D,"D",V,"V")
   call check_small( mfNorm(mfMul(A_herm,V)-mfMul(V,D)), "norm(A*V - V*D)", &
                     check_small_threshold )

   print "(/,A)", "*** test number 8 ***"
   A_nonherm = A
   call msDisplay(A_nonherm,"A_nonherm")
   call msEig( mfOut(V,D), A_nonherm )
   call zeroes_small_values( D, check_small_threshold )
   call msDisplay(D,"D",V,"V")
   call check_small( mfNorm(mfMul(A_nonherm,V)-mfMul(V,D)), "norm(A*V - V*D)", &
                     check_small_threshold )

   ! mfEigs ------------------------------------------------------------
   call print_separation("mfEigs")

   n = 7
   nev = 2

   ! real, symmetric undefinite matrix
   print "(/,A)", "*** test number 9 ***"
   A = mfMagic(n) / dble(n**2)
   A = A + .t. A
   call msDisplay(A,"A")
   bool = mfIsSymm(A)
   print *, "mfIsSymm(A) : ", bool
   bool = mfIsPosDef(A)
   print *, "mfIsPosDef(A) : ", bool

   E = mfEig(A)
   call msDisplay( E,"(all eigenvalues from mfEig) E")

   E = mfEigs( A, nev )
   call msDisplay( E,"[Largest (Magnitude) eigenvalues from ARPACK] E")

   E = mfEigs( A, nev, "SM" )
   call msDisplay( E,"[Smallest (Magnitude) eigenvalues from ARPACK] E")

   E = mfEigs( A, nev, "LA" )
   call msDisplay( E,"[Largest (Algebraic) eigenvalues from ARPACK] E")

   E = mfEigs( A, nev, "SA" )
   call msDisplay( E,"[Smallest (Algebraic) eigenvalues from ARPACK] E")

   E = mfEigs( A, nev, "BE" )
   call msDisplay( E,"[Both-Ends (algebraic) eigenvalues from ARPACK] E")

   E = mfEigs( A, nev, sigma=2.0d0 )
   call msDisplay( E,"[eigenvalues closest to 2.0 from ARPACK] E")

   ! real, symmetric positive definite matrix
   print "(/,A)", "*** test number 10 ***"
   A = mfMagic(n)
   A = mfMul( .t.A, A ) / dble(n**4)
   call msDisplay(A,"A")
   bool = mfIsSymm(A)
   print *, "mfIsSymm(A) : ", bool
   bool = mfIsPosDef(A)
   print *, "mfIsPosDef(A) : ", bool

   E = mfEig(A)
   call msDisplay( E,"(all eigenvalues from mfEig) E")

   E = mfEigs( A, 4 )
   call msDisplay( E,"[Largest (Magnitude) eigenvalues from ARPACK] E")

   E = mfEigs( A, 4, "SM" )
   call msDisplay( E,"[Smallest (Magnitude) eigenvalues from ARPACK] E")

   E = mfEigs( A, 4, "LA" )
   call msDisplay( E,"[Largest (Algebraic) eigenvalues from ARPACK] E")

   E = mfEigs( A, 4, "SA" )
   call msDisplay( E,"[Smallest (Algebraic) eigenvalues from ARPACK] E")

   E = mfEigs( A, 4, "BE" )
   call msDisplay( E,"[Both-Ends (algebraic) eigenvalues from ARPACK] E")

   E = mfEigs( A, 4, sigma=1.0d0 )
   call msDisplay( E,"[eigenvalues closest to 1.0 from ARPACK] E")

   ! real, unsymmetric matrix
   print "(/,A)", "*** test number 11 ***"
   A = mfMagic(n) / dble(n**2)
   call msSet( 3.0d0, A, 1, n )
   call msSet( -1.0d0, A, n, 1 )
   call msSet( 5.0d0, A, 1, n/2 )
   call msSet( -5.0d0, A, n, n/2 )
   call msDisplay(A,"A")
   bool = mfIsSymm(A)
   print *, "mfIsSymm(A) : ", bool
   bool = mfIsPosDef(A)
   print *, "mfIsPosDef(A) : ", bool

   E = mfEig(A)
   call msDisplay( E,"(all eigenvalues from mfEig) E")

   E = mfEigs( A, 2 )
   call msDisplay( E,"[Largest (Magnitude) eigenvalues from ARPACK] E")

   E = mfEigs( A, 2, "SM" )
   call msDisplay( E,"[Smallest (Magnitude) eigenvalues from ARPACK] E")

   E = mfEigs( A, 2, "LR" )
   call msDisplay( E,"[Largest (Real part algebraic) eigenvalues from ARPACK] E")

   E = mfEigs( A, 2, "SR" )
   call msDisplay( E,"[Smallest (Real part algebraic) eigenvalues from ARPACK] E")

   E = mfEigs( A, 2, "LI" )
   call msDisplay( E,"[Largest (Imag part magnitude) eigenvalues from ARPACK] E")

   E = mfEigs( A, 2, "SI" )
   call msDisplay( E,"[Smallest (Imag part magnitude) eigenvalues from ARPACK] E")

   E = mfEigs( A, 2, sigma=1.5d0 )
   call msDisplay( E,"[eigenvalues closest to 1.5 from ARPACK] E")

   ! complex, hermitian positive definite matrix (real eigenvals)
   print "(/,A)", "*** test number 12 ***"
   A = mfMagic(n) / dble(n**2)
   A = A*MF_I + dble(n)*mfEye(n)
   A = mfMul( .h.A, A ) / dble(n**2)
   call msDisplay(A,"A")
   bool = mfIsSymm(A)
   print *, "mfIsSymm(A) : ", bool
   bool = mfIsPosDef(A)
   print *, "mfIsPosDef(A) : ", bool

   E = mfEig(A)
   call msDisplay( E,"(all eigenvalues from mfEig) E")

   E = mfEigs( A, 4 )
   call msDisplay( E,"[Largest (Magnitude) eigenvalues from ARPACK] E")

   E = mfEigs( A, 4, "SM" )
   call msDisplay( E,"[Smallest (Magnitude) eigenvalues from ARPACK] E")

   E = mfEigs( A, 4, "LR" )
   call msDisplay( E,"[Largest (Real part algebraic) eigenvalues from ARPACK] E")

   E = mfEigs( A, 4, "SR" )
   call msDisplay( E,"[Smallest (Real part algebraic) eigenvalues from ARPACK] E")

   E = mfEigs( A, 4, sigma=1.02d0 )
   call msDisplay( E,"[eigenvalues closest to 1.02 from ARPACK] E")

   ! complex, diagonal (not hermitian)
   print "(/,A)", "*** test number 13 ***"
   A = mfDiag( mf([ (1.0d0,0.0d0), (0.0d0,1.0d0), (-1.2d0,-0.1d0), (0.1d0,-1.0d0), &
                    (0.9d0,0.9d0), (1.1d0,-1.3d0), (-0.9d0,1.1d0), (-1.3d0,-1.2d0) ]) )
   call msDisplay(A,"A")
   bool = mfIsSymm(A)
   print *, "mfIsSymm(A) : ", bool
   bool = mfIsPosDef(A)
   print *, "mfIsPosDef(A) : ", bool

   E = mfEig(A)
   call msDisplay( E,"(all eigenvalues from mfEig) E")

   E = mfEigs( A, 2 )
   call msDisplay( E,"[Largest (Magnitude) eigenvalues from ARPACK] E")

   E = mfEigs( A, 2, "SM" )
   call msDisplay( E,"[Smallest (Magnitude) eigenvalues from ARPACK] E")

   E = mfEigs( A, 2, "LR" )
   call msDisplay( E,"[Largest (Real part algebraic) eigenvalues from ARPACK] E")

   E = mfEigs( A, 2, "SR" )
   call msDisplay( E,"[Smallest (Real part algebraic) eigenvalues from ARPACK] E")

   E = mfEigs( A, 2, "LI" )
   call msDisplay( E,"[Largest (Imag part algebraic) eigenvalues from ARPACK] E")

   E = mfEigs( A, 2, "SI" )
   call msDisplay( E,"[Smallest (Imag part algebraic) eigenvalues from ARPACK] E")

   E = mfEigs( A, 2, sigma=(7.0d0,1.0d0) )
   call msDisplay( E,"[eigenvalues closest to (7,1) from ARPACK] E")

   ! complex, unsymmetric positive definite matrix
   print "(/,A)", "*** test number 14 ***"
   A = mfMagic(n) / dble(n**2)
   A = A*MF_I + dble(n)*mfEye(n) + mfHilb(n)
   call msDisplay(A,"A")
   bool = mfIsSymm(A)
   print *, "mfIsSymm(A) : ", bool
   bool = mfIsPosDef(A)
   print *, "mfIsPosDef(A) : ", bool

   E = mfEig(A)
   call msDisplay( E,"(all eigenvalues from mfEig) E")

   E = mfEigs( A, 2 )
   call msDisplay( E,"[Largest (Magnitude) eigenvalues from ARPACK] E")

   E = mfEigs( A, 2, "SM" )
   call msDisplay( E,"[Smallest (Magnitude) eigenvalues from ARPACK] E")

   E = mfEigs( A, 2, "LR" )
   call msDisplay( E,"[Largest (Real part algebraic) eigenvalues from ARPACK] E")

   E = mfEigs( A, 2, "SR" )
   call msDisplay( E,"[Smallest (Real part algebraic) eigenvalues from ARPACK] E")

   E = mfEigs( A, 2, "LI" )
   call msDisplay( E,"[Largest (Imag part algebraic) eigenvalues from ARPACK] E")

   E = mfEigs( A, 2, "SI" )
   call msDisplay( E,"[Smallest (Imag part algebraic) eigenvalues from ARPACK] E")

   E = mfEigs( A, 2, sigma=(7.0d0,1.0d0) )
   call msDisplay( E,"[eigenvalues closest to (7,1) from ARPACK] E")

   ! msEigs ------------------------------------------------------------
   call print_separation("msEigs")

   n = 7

   ! real, symmetric undefinite matrix
   print "(/,A)", "*** test number 15 ***"
   A = mfMagic(n) / dble(n**2)
   A = A + .t. A
   call msDisplay(A,"A")
   bool = mfIsSymm(A)
   print *, "mfIsSymm(A) : ", bool
   bool = mfIsPosDef(A)
   print *, "mfIsPosDef(A) : ", bool

   call msEig( mfOut(V,D), A )
   call msDisplay( .t.mfDiag(D),"(all eigenvalues from msEig) D")
   call msDisplay( V,"(all eigenvectors from msEig) V")

   call msEigs( mfOut(V,E,flag), A, 2 )
   call msDisplay( E,"[Largest (Magnitude) eigenvalues from ARPACK] E")
   call msDisplay( V,"(corresp. eigenvectors from ARPACK) V")
   call msDisplay(flag, "All requested eigenvalues converged?")
   D = mfDiag(E)
   call check_small( mfNorm(mfMul(A,V)-mfMul(V,D)), "norm(A*V - V*D)",  &
                     check_small_threshold )

   call msEigs( mfOut(V,E,flag), A, 2, "SM" )
   call msDisplay( E,"[Smallest (Magnitude) eigenvalues from ARPACK] E")
   call msDisplay( V,"(corresp. eigenvectors from ARPACK) V")
   call msDisplay(flag, "All requested eigenvalues converged?")
   D = mfDiag(E)
   call check_small( mfNorm(mfMul(A,V)-mfMul(V,D)), "norm(A*V - V*D)",  &
                     check_small_threshold )

   call msEigs( mfOut(V,E,flag), A, 2, "LA" )
   call msDisplay( E,"[Largest (Algebraic) eigenvalues from ARPACK] E")
   call msDisplay( V,"(corresp. eigenvectors from ARPACK) V")
   call msDisplay(flag, "All requested eigenvalues converged?")
   D = mfDiag(E)
   call check_small( mfNorm(mfMul(A,V)-mfMul(V,D)), "norm(A*V - V*D)",  &
                     check_small_threshold )

   call msEigs( mfOut(V,E,flag), A, 2, "SA" )
   call msDisplay( E,"[Smallest (Algebraic) eigenvalues from ARPACK] E")
   call msDisplay( V,"(corresp. eigenvectors from ARPACK) V")
   call msDisplay(flag, "All requested eigenvalues converged?")
   D = mfDiag(E)
   call check_small( mfNorm(mfMul(A,V)-mfMul(V,D)), "norm(A*V - V*D)",  &
                     check_small_threshold )

   call msEigs( mfOut(V,E,flag), A, 2, "BE" )
   call msDisplay( E,"[Both-Ends (algebraic) eigenvalues from ARPACK] E")
   call msDisplay( V,"(corresp. eigenvectors from ARPACK) V")
   call msDisplay(flag, "All requested eigenvalues converged?")
   D = mfDiag(E)
   call check_small( mfNorm(mfMul(A,V)-mfMul(V,D)), "norm(A*V - V*D)",  &
                     check_small_threshold )

   call msEigs( mfOut(V,E,flag), A, 2, sigma=2.0d0 )
   call msDisplay( E,"[eigenvalues closest to 2.0 from ARPACK] E")
   call msDisplay( V,"(corresp. eigenvectors from ARPACK) V")
   call msDisplay(flag, "All requested eigenvalues converged?")
   D = mfDiag(E)
   call check_small( mfNorm(mfMul(A,V)-mfMul(V,D)), "norm(A*V - V*D)",  &
                     check_small_threshold )

   ! real, symmetric positive definite matrix
   print "(/,A)", "*** test number 16 ***"
   A = mfMagic(n)
   A = mfMul( .t.A, A ) / dble(n**4)
   call msDisplay(A,"A")
   bool = mfIsSymm(A)
   print *, "mfIsSymm(A) : ", bool
   bool = mfIsPosDef(A)
   print *, "mfIsPosDef(A) : ", bool

   call msEig( mfOut(V,D), A )
   call msDisplay( .t.mfDiag(D),"(all eigenvalues from msEig) D")
   call msDisplay( V,"(all eigenvectors from msEig) V")

   call msEigs( mfOut(V,E,flag), A, 4 )
   call msDisplay( E,"[Largest (Magnitude) eigenvalues from ARPACK] E")
   call msDisplay( V,"(corresp. eigenvectors from ARPACK) V")
   call msDisplay(flag, "All requested eigenvalues converged?")
   D = mfDiag(E)
   call check_small( mfNorm(mfMul(A,V)-mfMul(V,D)), "norm(A*V - V*D)",  &
                     check_small_threshold )

   call msEigs( mfOut(V,E,flag), A, 4, "SM" )
   call msDisplay( E,"[Smallest (Magnitude) eigenvalues from ARPACK] E")
   call msDisplay( V,"(corresp. eigenvectors from ARPACK) V")
   call msDisplay(flag, "All requested eigenvalues converged?")
   D = mfDiag(E)
   call check_small( mfNorm(mfMul(A,V)-mfMul(V,D)), "norm(A*V - V*D)",  &
                     check_small_threshold )

   call msEigs( mfOut(V,E,flag), A, 4, "LA" )
   call msDisplay( E,"[Largest (Algebraic) eigenvalues from ARPACK] E")
   call msDisplay( V,"(corresp. eigenvectors from ARPACK) V")
   call msDisplay(flag, "All requested eigenvalues converged?")
   D = mfDiag(E)
   call check_small( mfNorm(mfMul(A,V)-mfMul(V,D)), "norm(A*V - V*D)",  &
                     check_small_threshold )

   call msEigs( mfOut(V,E,flag), A, 4, "SA" )
   call msDisplay( E,"[Smallest (Algebraic) eigenvalues from ARPACK] E")
   call msDisplay( V,"(corresp. eigenvectors from ARPACK) V")
   call msDisplay(flag, "All requested eigenvalues converged?")
   D = mfDiag(E)
   call check_small( mfNorm(mfMul(A,V)-mfMul(V,D)), "norm(A*V - V*D)",  &
                     check_small_threshold )

   call msEigs( mfOut(V,E,flag), A, 4, "BE" )
   call msDisplay( E,"[Both-Ends (algebraic) eigenvalues from ARPACK] E")
   call msDisplay( V,"(corresp. eigenvectors from ARPACK) V")
   call msDisplay(flag, "All requested eigenvalues converged?")
   D = mfDiag(E)
   call check_small( mfNorm(mfMul(A,V)-mfMul(V,D)), "norm(A*V - V*D)",  &
                     check_small_threshold )

   call msEigs( mfOut(V,E,flag), A, 4, sigma=0.5d0 )
   call msDisplay( E,"[Eigenvalues closest to 0.5 from ARPACK] E")
   call msDisplay( V,"(corresp. eigenvectors from ARPACK) V")
   call msDisplay(flag, "All requested eigenvalues converged?")
   D = mfDiag(E)
   call check_small( mfNorm(mfMul(A,V)-mfMul(V,D)), "norm(A*V - V*D)",  &
                     check_small_threshold )

   ! real, symmetric positive definite matrix, badly conditionned
   print "(/,A)", "*** test number 17 ***"
   A = mfHilb(9)
   call msDisplay(A,"A")
   bool = mfIsSymm(A)
   print *, "mfIsSymm(A) : ", bool
   bool = mfIsPosDef(A)
   print *, "mfIsPosDef(A) : ", bool
   call msDisplay( mfCond(A), "cond(A)" )

   call msFormat( exponent="sci" )

   call msEig( mfOut(V,D), A )
   call msDisplay( .t.mfDiag(D),"(all eigenvalues from msEig) D")
   call msDisplay( V,"(all eigenvectors from msEig) V")

   call msEigs( mfOut(V,E,flag), A, 4 )
   call msDisplay( E,"[Largest (Magnitude) eigenvalues from ARPACK] E")
   call msDisplay( V,"(corresp. eigenvectors from ARPACK) V")
   call msDisplay(flag, "All requested eigenvalues converged?")
   D = mfDiag(E)
   call check_small( mfNorm(mfMul(A,V)-mfMul(V,D)), "norm(A*V - V*D)",  &
                     check_small_threshold )

   call msEigs( mfOut(V,E,flag), A, 4, "SM" )
   call msDisplay( E,"[Smallest (Magnitude) eigenvalues from ARPACK] E")
   call msDisplay( V,"(corresp. eigenvectors from ARPACK) V")
   call msDisplay(flag, "All requested eigenvalues converged?")
   D = mfDiag(E)
   call check_small( mfNorm(mfMul(A,V)-mfMul(V,D)), "norm(A*V - V*D)",  &
                     check_small_threshold*5.0d2 )

   call msEigs( mfOut(V,E,flag), A, 4, "LA" )
   call msDisplay( E,"[Largest (Algebraic) eigenvalues from ARPACK] E")
   call msDisplay( V,"(corresp. eigenvectors from ARPACK) V")
   call msDisplay(flag, "All requested eigenvalues converged?")
   D = mfDiag(E)
   call check_small( mfNorm(mfMul(A,V)-mfMul(V,D)), "norm(A*V - V*D)",  &
                     check_small_threshold )

   call msEigs( mfOut(V,E,flag), A, 4, "SA" )
   call msDisplay( E,"[Smallest (Algebraic) eigenvalues from ARPACK] E")
   call msDisplay( V,"(corresp. eigenvectors from ARPACK) V")
   call msDisplay(flag, "All requested eigenvalues converged?")
   D = mfDiag(E)
   call check_small( mfNorm(mfMul(A,V)-mfMul(V,D)), "norm(A*V - V*D)",  &
                     check_small_threshold )

   call msEigs( mfOut(V,E,flag), A, 4, "BE" )
   call msDisplay( E,"[Both-Ends (algebraic) eigenvalues from ARPACK] E")
   call msDisplay( V,"(corresp. eigenvectors from ARPACK) V")
   call msDisplay(flag, "All requested eigenvalues converged?")
   D = mfDiag(E)
   call check_small( mfNorm(mfMul(A,V)-mfMul(V,D)), "norm(A*V - V*D)",  &
                     check_small_threshold )

   call msEigs( mfOut(V,E,flag), A, 4, sigma=0.5d0 )
   call msDisplay( E,"[Eigenvalues closest to 0.5 from ARPACK] E")
   call msDisplay( V,"(corresp. eigenvectors from ARPACK) V")
   call msDisplay(flag, "All requested eigenvalues converged?")
   D = mfDiag(E)
   call check_small( mfNorm(mfMul(A,V)-mfMul(V,D)), "norm(A*V - V*D)",  &
                     check_small_threshold )

   call msFormat(  )

   ! real, unsymmetric matrix
   print "(/,A)", "*** test number 18 ***"
   A = mfMagic(n) / dble(n**2)
   call msSet( 3.0d0, A, 1, n )
   call msSet( -1.0d0, A, n, 1 )
   call msSet( 5.0d0, A, 1, n/2 )
   call msSet( -5.0d0, A, n, n/2 )
   call msDisplay(A,"A")
   bool = mfIsSymm(A)
   print *, "mfIsSymm(A) : ", bool
   bool = mfIsPosDef(A)
   print *, "mfIsPosDef(A) : ", bool

   call msEig( mfOut(V,D), A )
!### TODO ?: why change message level?
   MsgLevel_save = mfGetMsgLevel()
   call msSetMsgLevel(1)
   call msDisplay( .t.mfDiag(D),"(All eigenvalues from msEig) D")
   call msSetMsgLevel(MsgLevel_save)
   call msDisplay( V,"(all eigenvectors from msEig) V")

   call msEigs( mfOut(V,E,flag), A, 2 )
   call msDisplay( E,"[Largest (Magnitude) eigenvalues from ARPACK] E")
   call msDisplay( V,"(corresp. eigenvectors from ARPACK) V")
   call msDisplay(flag, "All requested eigenvalues converged?")
   D = mfDiag(E)
   call check_small( mfNorm(mfMul(A,V)-mfMul(V,D)), "norm(A*V - V*D)",  &
                     check_small_threshold )

   call msEigs( mfOut(V,E,flag), A, 2, "SM" )
   call msDisplay( E,"[Smallest (Magnitude) eigenvalues from ARPACK] E")
   call msDisplay( V,"(corresp. eigenvectors from ARPACK) V")
   call msDisplay(flag, "All requested eigenvalues converged?")
   D = mfDiag(E)
   call check_small( mfNorm(mfMul(A,V)-mfMul(V,D)), "norm(A*V - V*D)",  &
                     check_small_threshold )

   call msEigs( mfOut(V,E,flag), A, 2, "LR" )
   call msDisplay( E,"[Largest Real part (algebraic) eigenvalues from ARPACK] E")
   call msDisplay( V,"(corresp. eigenvectors from ARPACK) V")
   call msDisplay(flag, "All requested eigenvalues converged?")
   D = mfDiag(E)
   call check_small( mfNorm(mfMul(A,V)-mfMul(V,D)), "norm(A*V - V*D)",  &
                     check_small_threshold )

   call msEigs( mfOut(V,E,flag), A, 2, "SR" )
   call msDisplay( E,"[Smallest Real part (algebraic) eigenvalues from ARPACK] E")
   call msDisplay( V,"(corresp. eigenvectors from ARPACK) V")
   call msDisplay(flag, "All requested eigenvalues converged?")
   D = mfDiag(E)
   call check_small( mfNorm(mfMul(A,V)-mfMul(V,D)), "norm(A*V - V*D)",  &
                     check_small_threshold )

   call msEigs( mfOut(V,E,flag), A, 2, "LI" )
   call msDisplay( E,"[Largest Imaginary part (magnitude) eigenvalues from ARPACK] E")
   call msDisplay( V,"(corresp. eigenvectors from ARPACK) V")
   call msDisplay(flag, "All requested eigenvalues converged?")
   D = mfDiag(E)
   call check_small( mfNorm(mfMul(A,V)-mfMul(V,D)), "norm(A*V - V*D)",  &
                     check_small_threshold )

   call msEigs( mfOut(V,E,flag), A, 2, "SI" )
   call msDisplay( E,"[Smallest Imaginary part (magnitude) eigenvalues from ARPACK] E")
   call msDisplay( V,"(corresp. eigenvectors from ARPACK) V")
   call msDisplay(flag, "All requested eigenvalues converged?")
   D = mfDiag(E)
   call check_small( mfNorm(mfMul(A,V)-mfMul(V,D)), "norm(A*V - V*D)",  &
                     check_small_threshold )

   call msEigs( mfOut(V,E,flag), A, 2, sigma=1.5d0 )
   call msDisplay( E,"[Eigenvalues closest to 1.5 from ARPACK] E")
   call msDisplay( V,"(corresp. eigenvectors from ARPACK) V")
   call msDisplay(flag, "All requested eigenvalues converged?")
   D = mfDiag(E)
   call check_small( mfNorm(mfMul(A,V)-mfMul(V,D)), "norm(A*V - V*D)",  &
                     check_small_threshold )

   ! complex, symmetric positive definite matrix
   print "(/,A)", "*** test number 19 ***"
   A = mfMagic(n) / dble(n**2)
   A = A*MF_I + dble(n)*mfEye(n)
   A = mfMul( .h.A, A ) / dble(n**2)
   call msDisplay(A,"A")
   bool = mfIsSymm(A)
   print *, "mfIsSymm(A) : ", bool
   bool = mfIsPosDef(A)
   print *, "mfIsPosDef(A) : ", bool

   call msEig( mfOut(V,D), A )
   call msDisplay( .t.mfDiag(D),"(all eigenvalues from msEig) D")
   call msDisplay( V,"(all eigenvectors from msEig) V")

   call msEigs( mfOut(V,E,flag), A, 4 )
   call msDisplay( E,"[Largest (Magnitude) eigenvalues from ARPACK] E")
   call msDisplay( V,"(corresp. eigenvectors from ARPACK) V")
   call msDisplay(flag, "All requested eigenvalues converged?")
   D = mfDiag(E)
   call check_small( mfNorm(mfMul(A,V)-mfMul(V,D)), "norm(A*V - V*D)",  &
                     check_small_threshold )

   call msEigs( mfOut(V,E,flag), A, 4, "SM" )
   call msDisplay( E,"[Smallest (Magnitude) eigenvalues from ARPACK] E")
   call msDisplay( V,"(corresp. eigenvectors from ARPACK) V")
   call msDisplay(flag, "All requested eigenvalues converged?")
   D = mfDiag(E)
   call check_small( mfNorm(mfMul(A,V)-mfMul(V,D)), "norm(A*V - V*D)",  &
                     check_small_threshold )

   call msEigs( mfOut(V,E,flag), A, 4, "LR" )
   call msDisplay( E,"[Largest Real part (algebraic) eigenvalues from ARPACK] E")
   call msDisplay( V,"(corresp. eigenvectors from ARPACK) V")
   call msDisplay(flag, "All requested eigenvalues converged?")
   D = mfDiag(E)
   call check_small( mfNorm(mfMul(A,V)-mfMul(V,D)), "norm(A*V - V*D)",  &
                     check_small_threshold )

   call msEigs( mfOut(V,E,flag), A, 4, "SR" )
   call msDisplay( E,"[Smallest Real part (algebraic) eigenvalues from ARPACK] E")
   call msDisplay( V,"(corresp. eigenvectors from ARPACK) V")
   call msDisplay(flag, "All requested eigenvalues converged?")
   D = mfDiag(E)
   call check_small( mfNorm(mfMul(A,V)-mfMul(V,D)), "norm(A*V - V*D)",  &
                     check_small_threshold )

   call msEigs( mfOut(V,E,flag), A, 4, "LI" )
   call msDisplay( E,"[Largest Imaginary part (algebraic) eigenvalues from ARPACK] E")
   call msDisplay( V,"(corresp. eigenvectors from ARPACK) V")
   call msDisplay(flag, "All requested eigenvalues converged?")
   D = mfDiag(E)
   call check_small( mfNorm(mfMul(A,V)-mfMul(V,D)), "norm(A*V - V*D)",  &
                     check_small_threshold )

   call msEigs( mfOut(V,E,flag), A, 4, "SI" )
   call msDisplay( E,"[Smallest Imaginary part (algebraic) eigenvalues from ARPACK] E")
   call msDisplay( V,"(corresp. eigenvectors from ARPACK) V")
   call msDisplay(flag, "All requested eigenvalues converged?")
   D = mfDiag(E)
   call check_small( mfNorm(mfMul(A,V)-mfMul(V,D)), "norm(A*V - V*D)",  &
                     check_small_threshold )

   call msEigs( mfOut(V,E,flag), A, 4, sigma=1.02d0 )
   call msDisplay( E,"[Eigenvalues closest to 1.02 from ARPACK] E")
   call msDisplay( V,"(corresp. eigenvectors from ARPACK) V")
   call msDisplay(flag, "All requested eigenvalues converged?")
   D = mfDiag(E)
   call check_small( mfNorm(mfMul(A,V)-mfMul(V,D)), "norm(A*V - V*D)",  &
                     check_small_threshold )

   ! complex, unsymmetric positive definite matrix
   print "(/,A)", "*** test number 20 ***"
   A = mfMagic(n) / dble(n**2)
   A = A*MF_I + dble(n)*mfEye(n)
   call msDisplay(A,"A")
   bool = mfIsSymm(A)
   print *, "mfIsSymm(A) : ", bool
   bool = mfIsPosDef(A)
   print *, "mfIsPosDef(A) : ", bool

   call msEig( mfOut(V,D), A )
   MsgLevel_save = mfGetMsgLevel()
   call msSetMsgLevel(1)
   call msDisplay( .t.mfDiag(D),"(All eigenvalues from msEig) D")
   call msSetMsgLevel(MsgLevel_save)
   call msDisplay( V,"(all eigenvectors from msEig) V")

   call msEigs( mfOut(V,E,flag), A, 2 )
   call msDisplay( E,"[Largest (Magnitude) eigenvalues from ARPACK] E")
   call msDisplay( V,"(corresp. eigenvectors from ARPACK) V")
   call msDisplay(flag, "All requested eigenvalues converged?")
   D = mfDiag(E)
   call check_small( mfNorm(mfMul(A,V)-mfMul(V,D)), "norm(A*V - V*D)",  &
                     check_small_threshold )

   call msEigs( mfOut(V,E,flag), A, 2, "SM" )
   call msDisplay( E,"[Smallest (Magnitude) eigenvalues from ARPACK] E")
   call msDisplay( V,"(corresp. eigenvectors from ARPACK) V")
   call msDisplay(flag, "All requested eigenvalues converged?")
   D = mfDiag(E)
   call check_small( mfNorm(mfMul(A,V)-mfMul(V,D)), "norm(A*V - V*D)",  &
                     check_small_threshold )

   call msEigs( mfOut(V,E,flag), A, 2, "LR" )
   call msDisplay( E,"[Largest Real part (algebraic) eigenvalues from ARPACK] E")
   call msDisplay( V,"(corresp. eigenvectors from ARPACK) V")
   call msDisplay(flag, "All requested eigenvalues converged?")
   D = mfDiag(E)
   call check_small( mfNorm(mfMul(A,V)-mfMul(V,D)), "norm(A*V - V*D)",  &
                     check_small_threshold )

   call msEigs( mfOut(V,E,flag), A, 2, "SR" )
   call msDisplay( E,"[Smallest Real part (algebraic) eigenvalues from ARPACK] E")
   call msDisplay( V,"(corresp. eigenvectors from ARPACK) V")
   call msDisplay(flag, "All requested eigenvalues converged?")
   D = mfDiag(E)
   call check_small( mfNorm(mfMul(A,V)-mfMul(V,D)), "norm(A*V - V*D)",  &
                     check_small_threshold )

   call msEigs( mfOut(V,E,flag), A, 2, "LI" )
   call msDisplay( E,"[Largest Imaginary part (algebraic) eigenvalues from ARPACK] E")
   call msDisplay( V,"(corresp. eigenvectors from ARPACK) V")
   call msDisplay(flag, "All requested eigenvalues converged?")
   D = mfDiag(E)
   call check_small( mfNorm(mfMul(A,V)-mfMul(V,D)), "norm(A*V - V*D)",  &
                     check_small_threshold )

   call msEigs( mfOut(V,E,flag), A, 2, "SI" )
   call msDisplay( E,"[Smallest Imaginary part (algebraic) eigenvalues from ARPACK] E")
   call msDisplay( V,"(corresp. eigenvectors from ARPACK) V")
   call msDisplay(flag, "All requested eigenvalues converged?")
   D = mfDiag(E)
   call check_small( mfNorm(mfMul(A,V)-mfMul(V,D)), "norm(A*V - V*D)",  &
                     check_small_threshold )

   call msEigs( mfOut(V,E,flag), A, 2, sigma=1.02d0 )
   call msDisplay( E,"[Eigenvalues closest to 1.02 from ARPACK] E")
   call msDisplay( V,"(corresp. eigenvectors from ARPACK) V")
   call msDisplay(flag, "All requested eigenvalues converged?")
   D = mfDiag(E)
   call check_small( mfNorm(mfMul(A,V)-mfMul(V,D)), "norm(A*V - V*D)",  &
                     check_small_threshold )

   ! mfHess ------------------------------------------------------------
   call print_separation("mfHess")

   ! real matrices
   A = mf( reshape( [ (i, i = 1, 16) ], [ 4, 4 ] ) ) + mfEye(4)
   call sym_decmp( mfOut(A_sym,A_nonsym), A )

   print "(/,A)", "*** test number 21 ***"
   call msDisplay(A_sym,"A_sym")
   P = mfHess( A_sym )
   call zeroes_small_values( P, check_small_threshold )
   call msDisplay(P,"Hess(A_sym)")

   print "(/,A)", "*** test number 22 ***"
   call msDisplay(A_nonsym,"A_nonsym")
   P = mfHess( A_nonsym )
   call zeroes_small_values( P, check_small_threshold )
   call msDisplay(P,"Hess(A_nonsym)")

   ! complex matrices
   A = A + MF_I*mf( reshape( [ (10-i, i = 1, 16) ], [ 4, 4 ] ) )
   A_herm = 0.5d0*(A + .h. A)

   print "(/,A)", "*** test number 23 ***"
   call msDisplay(A_herm,"A_herm")
   P = mfHess( A_herm )
   call zeroes_small_values( P, check_small_threshold )
   call msDisplay(P,"Hess(A_herm)")

   print "(/,A)", "*** test number 24 ***"
   A_nonherm = A
   call msDisplay(A_nonherm,"A_nonherm")
   P = mfHess( A_nonherm )
   call zeroes_small_values( P, check_small_threshold )
   call msDisplay(P,"Hess(A_nonherm)")

   ! msHess ------------------------------------------------------------
   call print_separation("msHess")

   ! real matrices
   A = mf( reshape( [ (i, i = 1, 16) ], [ 4, 4 ] ) ) + mfEye(4)
   call sym_decmp( mfOut(A_sym,A_nonsym), A )

   print "(/,A)", "*** test number 25 ***"
   call msDisplay(A_sym,"A_sym")
   call msHess( mfOut(P,H), A_sym )
   call zeroes_small_values( P, check_small_threshold )
   call zeroes_small_values( H, check_small_threshold )
   call msDisplay(P,"P",H,"H")
   call check_small( mfNorm(A_sym-mfMul(P,mfMul(H,.t.P))), "norm(A_sym - P*H*P')", &
                     check_small_threshold )

   print "(/,A)", "*** test number 26 ***"
   call msDisplay(A,"A")
   call msHess( mfOut(P,H), A )
   call zeroes_small_values( P, check_small_threshold )
   call zeroes_small_values( H, check_small_threshold )
   call msDisplay(P,"P",H,"H")
   call check_small( mfNorm(A-mfMul(P,mfMul(H,.t.P))), "norm(A - P*H*P')", &
                     check_small_threshold )

   ! complex matrices
   A = A + MF_I*mf( reshape( [ (10-i, i = 1, 16) ], [ 4, 4 ] ) )
   A_herm = 0.5d0*(A + .h. A)

   print "(/,A)", "*** test number 27 ***"
   call msDisplay(A_herm,"A_herm")
   call msHess( mfOut(P,H), A_herm )
   call zeroes_small_values( P, check_small_threshold )
   call zeroes_small_values( H, check_small_threshold )
   !call msDisplay(P,"P",H,"H")
   call check_small( mfNorm(A_herm-mfMul(P,mfMul(H,.h.P))), "norm(A_herm - P*H*P')", &
                     check_small_threshold )

   print "(/,A)", "*** test number 28 ***"
   call msDisplay(A,"A")
   call msHess( mfOut(P,H), A )
   call zeroes_small_values( P, check_small_threshold )
   call zeroes_small_values( H, check_small_threshold )
   !call msDisplay(P,"P",H,"H")
   call check_small( mfNorm(A-mfMul(P,mfMul(H,.h.P))), "norm(A - P*H*P')", &
                     check_small_threshold )

   ! mfSchur -----------------------------------------------------------
   call print_separation("mfSchur")

   print "(/,A)", "*** test number 29 ***"
   A = mfMagic(5)
   call msDisplay(A,"A")
   B = mfSchur(A)
   call zeroes_small_values( B, check_small_threshold )
   call msDisplay( B, "mfSchur(A)" )

   print "(/,A)", "*** test number 30 ***"
   A = mfHilb(5)
   call msDisplay(A,"A")
   B = mfSchur(A)
   call zeroes_small_values( B, check_small_threshold )
   call msDisplay( B, "mfSchur(A)" )

   print "(/,A)", "*** test number 31 ***"
   A = mfMagic(5) + MF_I*mfHilb(5)
   call msDisplay(A,"A")
   B = mfSchur(A)
   call zeroes_small_values( B, check_small_threshold )
   call msDisplay( B, "mfSchur(A)" )

   ! this real matrix has complex eigenvalues
   print "(/,A)", "*** test number 32 ***"
   A = reshape( [ 0.96, 0.95, 0.14,                                     &
                  0.15, 0.48, 0.42,                                     &
                  0.97, 0.80, 0.91 ], [ 3, 3 ] )
   call msDisplay(A,"A")
   call msDisplay(mfEig(A),"mfEig(A)")
   B = mfSchur(A)
   call zeroes_small_values( B, check_small_threshold )
   call msDisplay( B, "mfSchur(A)" )

   ! same example as previous, but in complex form
   print "(/,A)", "*** test number 33 ***"
   A = reshape( [ 0.96, 0.95, 0.14,                                     &
                  0.15, 0.48, 0.42,                                     &
                  0.97, 0.80, 0.91 ], [ 3, 3 ] )
   call msDisplay(A,"A")
   call msDisplay(mfEig(A),"mfEig(A)")
   B = mfSchur(A,form="complex")
   call zeroes_small_values( B, check_small_threshold )
   call msDisplay( B, "mfSchur(A,form='complex')" )

   ! special case: A is already TRIU
   print "(/,A)", "*** test number 34 ***"
   A = mfTriu(mfMagic(5))
   call msDisplay(A,"A")
   MsgLevel_save = mfGetMsgLevel()
   call msSetMsgLevel(3)
   B = mfSchur(A)
   call msSetMsgLevel(MsgLevel_save)
   call msDisplay( B, "mfSchur(A)" )

   ! with tempo array
   print "(/,A)", "*** test number 35 ***"
   MsgLevel_save = mfGetMsgLevel()
   call msSetMsgLevel(3)
   B = mfSchur(mfTriu(mfMagic(5)))
   call msSetMsgLevel(MsgLevel_save)
   call msDisplay( B, "mfSchur(A)" )

   ! msSchur -----------------------------------------------------------
   call print_separation("msSchur")

   print "(/,A)", "*** test number 36 ***"
   A = mfMagic(5)
   call msDisplay(A,"A")
   call msSchur( mfOut(U,T), A )
   call check_small( mfNorm(A-mfMul(U,mfMul(T,.t.U))), "norm(A - U*T*U')", &
                     check_small_threshold )

   print "(/,A)", "*** test number 37 ***"
   A = mfMagic(5) + MF_I*mfHilb(5)
   call msDisplay(A,"A")
   call msSchur( mfOut(U,T), A )
   call check_small( mfNorm(A-mfMul(U,mfMul(T,.h.U))), "norm(A - U*T*U')", &
                     check_small_threshold )

   ! this real matrix has complex eigenvalues
   print "(/,A)", "*** test number 38 ***"
   A = reshape( [ 0.96, 0.95, 0.14,                                     &
                  0.15, 0.48, 0.42,                                     &
                  0.97, 0.80, 0.91 ], [ 3, 3 ] )
   call msDisplay(A,"A")
   call msDisplay(mfEig(A),"mfEig(A)")
   call msSchur( mfOut(U,T), A )
   call check_small( mfNorm(A-mfMul(U,mfMul(T,.h.U))), "norm(A - U*T*U')", &
                     check_small_threshold )

   ! same example as previous, but in complex form
   print "(/,A)", "*** test number 39 ***"
   A = reshape( [ 0.96, 0.95, 0.14,                                     &
                  0.15, 0.48, 0.42,                                     &
                  0.97, 0.80, 0.91 ], [ 3, 3 ] )
   call msDisplay(A,"A")
   call msDisplay(mfEig(A),"mfEig(A)")
   call msSchur( mfOut(U,T), A, form="complex" )
   call check_small( mfNorm(A-mfMul(U,mfMul(T,.h.U))),                  &
                     "in complex form: norm(A - U*T*U')",               &
                     check_small_threshold )

   ! special case: A is already TRIU
   print "(/,A)", "*** test number 40 ***"
   A = mfTriu(mfMagic(5))
   call msDisplay(A,"A")
   MsgLevel_save = mfGetMsgLevel()
   call msSetMsgLevel(3)
   call msSchur( mfOut(U,T), A )
   call msSetMsgLevel(MsgLevel_save)
   call check_small( mfNorm(A-mfMul(U,mfMul(T,.h.U))), "norm(A - U*T*U')", &
                     check_small_threshold )

   ! with tempo array
   print "(/,A)", "*** test number 41 ***"
   MsgLevel_save = mfGetMsgLevel()
   call msSetMsgLevel(3)
   call msSchur( mfOut(U,T), mfTriu(mfMagic(5)) )
   call msSetMsgLevel(MsgLevel_save)
   call check_small( mfNorm(A-mfMul(U,mfMul(T,.h.U))), "norm(A - U*T*U')", &
                     check_small_threshold )

   ! mfExpm ------------------------------------------------------------
   call print_separation("mfExpm")

   print "(/,A)", "*** test number 42 ***"
   A = mfEye(3)
   call msDisplay(A,"A")
   call msDisplay(mfExpm(A),"mfExpm(A)")
   call check_small( mfNorm(A-mfLogm(mfExpm(A))),                       &
                    "mfNorm(A-mfLogm(mfExpm(A)))",                      &
                     check_small_threshold )

   print "(/,A)", "*** test number 43 ***"
   B = mfHilb(3)
   call msDisplay(B,"B")
   call msDisplay(mfExpm(B),"mfExpm(B)")
   call check_small( mfNorm(B-mfLogm(mfExpm(B))),                       &
                    "mfNorm(B-mfLogm(mfExpm(B)))",                      &
                     check_small_threshold )

   print "(/,A)", "*** test number 44 ***"
   C = [ 0.1d0, 0.2d0, 0.3d0 ] .vc.                                     &
       [ 0.4d0, 0.5d0, 0.6d0 ] .vc.                                     &
       [ 0.7d0, 0.8d0, 0.9d0 ]
   call msDisplay(C,"C")
   call msDisplay(mfExpm(C),"mfExpm(C)")
   call check_small( mfNorm(C-mfLogm(mfExpm(C))),                       &
                    "mfNorm(C-mfLogm(mfExpm(C)))",                      &
                     check_small_threshold )

   ! mfLogm ------------------------------------------------------------
   call print_separation("mfLogm")

   print "(/,A)", "*** test number 45 ***"
   A = mfEye(3)
   call msDisplay(A,"A")
   call msDisplay(mfLogm(A),"mfLogm(A)")
   call check_small( mfNorm(A-mfExpm(mfLogm(A))),                       &
                    "mfNorm(A-mfExpm(mfLogm(A)))",                      &
                     check_small_threshold )

   print "(/,A)", "*** test number 46 ***"
   B = mfHilb(3)
   call msDisplay(B,"B")
   call msDisplay(mfLogm(B),"mfLogm(B)")
   call check_small( mfNorm(B-mfExpm(mfLogm(B))),                       &
                    "mfNorm(B-mfExpm(mfLogm(B)))",                      &
                     check_small_threshold )

   print "(/,A)", "*** test number 47 ***"
   C = [ 0.1d0, 0.2d0, 0.3d0 ] .vc.                                     &
       [ 0.4d0, 0.5d0, 0.6d0 ] .vc.                                     &
       [ 0.7d0, 0.8d0, 0.9d0 ]
   call msDisplay(C,"C")
   call msDisplay(mfLogm(C),"mfLogm(C)")
   call check_small( mfNorm(C-mfExpm(mfLogm(C))),                       &
                    "mfNorm(C-mfExpm(mfLogm(C)))",                      &
                     check_small_threshold )

   ! mfSqrtm -----------------------------------------------------------
   call print_separation("mfSqrtm")

   print "(/,A)", "*** test number 48 ***"
   A = mfEye(3)
   call msDisplay(A,"A")
   R = mfSqrtm(A)
   call msDisplay(R,"R = mfSqrtm(A)")
   call check_small( mfNorm(A-mfMul(R,R)), "mfNorm(A-mfMul(R,R))",      &
                     check_small_threshold )

   print "(/,A)", "*** test number 49 ***"
   B = mfHilb(3)
   call msDisplay(B,"B")
   R = mfSqrtm(B)
   call msDisplay(R,"R = mfSqrtm(B)")
   call check_small( mfNorm(B-mfMul(R,R)), "mfNorm(B-mfMul(R,R))",      &
                     check_small_threshold )

   print "(/,A)", "*** test number 50 ***"
   C = [ 0.1d0, 0.2d0, 0.3d0 ] .vc.                                     &
       [ 0.4d0, 0.5d0, 0.6d0 ] .vc.                                     &
       [ 0.7d0, 0.8d0, 0.9d0 ]
   call msDisplay(C,"C")
   R = mfSqrtm(C)
   call msDisplay(R,"R = mfSqrtm(C)")
   call check_small( mfNorm(C-mfMul(R,R)), "mfNorm(C-mfMul(R,R))",      &
                     check_small_threshold )

   ! msRref ------------------------------------------------------------
   call print_separation("msRref")

   print "(/,A)", "*** test number 51 ***"
   A = mfZeros(5,5)
   call msDisplay(A,"A")
   call msRref( mfOut(R,jpiv), A )
   call msDisplay(R,"R",jpiv,"jpiv")

   print "(/,A)", "*** test number 52 ***"
   A = [ 1.0d0, 2.0d0, 3.0d0 ] .vc.                                     &
       [ 4.0d0, 5.0d0, 6.0d0 ] .vc.                                     &
       [ 7.0d0, 8.0d0, 9.0d0 ]
   call msDisplay(A,"A")
   call msRref( mfOut(R,jpiv), A )
   call msDisplay(R,"R",jpiv,"jpiv")

   print "(/,A)", "*** test number 53 ***"
   A = mfMagic(4)
   call msDisplay(A,"A")
   call msRref( mfOut(R,jpiv), A )
   call msDisplay(R,"R",jpiv,"jpiv")

   print "(/,A)", "*** test number 54 ***"
   A = mfMagic(8)
   call msDisplay(A,"A")
   call msRref( mfOut(R,jpiv), A )
   call msDisplay(R,"R",jpiv,"jpiv")

   ! mfNull ------------------------------------------------------------
   call print_separation("mfNull")

   ! full null space (zero matrix)
   print "(/,A)", "*** test number 55 ***"
   A = mfZeros(5,5)
   call msDisplay(A,"A")
   R = mfNull(A)
   call msDisplay(R,"Nullspace of R")

   ! empty null space
   print "(/,A)", "*** test number 56 ***"
   A = mfEye(3,3)
   call msDisplay(A,"A")
   R = mfNull(A)
   call msDisplay(R,"Nullspace of R")

   print "(/,A)", "*** test number 57 ***"
   A = [ 1.0d0, 2.0d0, 3.0d0 ] .vc.                                     &
       [ 4.0d0, 5.0d0, 6.0d0 ] .vc.                                     &
       [ 7.0d0, 8.0d0, 9.0d0 ]
   call msDisplay(A,"A")
   R = mfNull(A)
   call msDisplay(R,"Nullspace of R")
   ! check : image of the null space should be 0
   B = mfMul(A,R)
   call check_small( B, "A*R", check_small_threshold )

   print "(/,A)", "*** test number 58 ***"
   A = [  1.0d0,  2.0d0,  3.0d0,  4.0d0 ] .vc.                          &
       [  5.0d0,  6.0d0,  7.0d0,  8.0d0 ] .vc.                          &
       [  9.0d0, 10.0d0, 11.0d0, 12.0d0 ]
   call msDisplay(A,"A")
   R = mfNull(A)
   ! check : image of the null space should be 0
   B = mfMul(A,R)
   call check_small( B, "A*R", check_small_threshold )

   print "(/,A)", "*** test number 59 ***"
   print "(/,A)", "(using rational basis)"
   A = mfZeros(5,5)
   call msDisplay(A,"A")
   R = mfNull(A,rational=.true.)
   ! check : image of the null space should be 0
   call msDisplay(R,"Nullspace of R (rational basis)")

   print "(/,A)", "*** test number 60 ***"
   print "(/,A)", "(using rational basis)"
   A = mfOnes(5,5)
   call msDisplay(A,"A")
   R = mfNull(A,rational=.true.)
   ! check : image of the null space should be 0
   call msDisplay(R,"Nullspace of R (rational basis)")

   ! mfOrth ------------------------------------------------------------
   call print_separation("mfOrth")

   ! empty image
   print "(/,A)", "*** test number 61 ***"
   A = mfZeros(3)
   call msDisplay(A,"A")
   R = mfOrth(A)
   call msDisplay(R,"Image R")

   print "(/,A)", "*** test number 62 ***"
   A = [ 1.0d0, 2.0d0, 3.0d0 ] .vc.                                     &
       [ 4.0d0, 5.0d0, 6.0d0 ] .vc.                                     &
       [ 7.0d0, 8.0d0, 9.0d0 ]
   call msDisplay(A,"A")
   R = mfOrth(A)
   call msDisplay(R,"Image R")
   ! check : any vector from the image may always
   !         be as RHS of an equation
   b = R
   x = mfLDiv( A, b ) ! solve of simultaneous equations
   call msDisplay(x,"Solution x")
   call check_small( mfNorm(mfMul(A,x)-b), "Residu |A*x-b|",            &
                     check_small_threshold )

   print "(/,A)", "*** test number 63 ***"
   A = [  1.0d0,  2.0d0,  3.0d0 ] .vc.                                  &
       [  4.0d0,  5.0d0,  6.0d0 ] .vc.                                  &
       [  7.0d0,  8.0d0,  9.0d0 ] .vc.                                  &
       [ 10.0d0, 11.0d0, 12.0d0 ]
   call msDisplay(A,"A")
   R = mfOrth(A)
   call msDisplay(R,"Image R")
   ! check : any vector from the image may always
   !         be as RHS of an equation
   b = R
   x = mfLDiv( A, b ) ! solve of simultaneous equations
   call msDisplay(x,"Solution x")
   call check_small( mfNorm(mfMul(A,x)-b), "Residu |A*x-b|",            &
                     check_small_threshold )

   ! mfFunm ------------------------------------------------------------
   call print_separation("mfFunm")

   A = mfEye(3)
   B = mfHilb(3)
   C = [ 0.1d0, 0.2d0, 0.3d0 ] .vc.                                     &
       [ 0.4d0, 0.5d0, 0.6d0 ] .vc.                                     &
       [ 0.7d0, 0.8d0, 0.9d0 ]

   ! external (user) functions
   print "(/,A)", "*** test number 64 ***"
   call msDisplay(mfFunm(A,my_exp),"mfFunm(A,my_exp)")
   print "(/,A)", "*** test number 65 ***"
   call msDisplay(mfFunm(B,my_exp),"mfFunm(B,my_exp)")
   print "(/,A)", "*** test number 66 ***"
   call msDisplay(mfFunm(C,my_exp),"mfFunm(C,my_exp)")

   ! intrinsic functions
   print "(/,A)", "*** test number 67 ***"
   call msDisplay(mfFunm(A,'exp'),"mfFunm(A,'exp')")
   print "(/,A)", "*** test number 68 ***"
   call msDisplay(mfFunm(B,'exp'),"mfFunm(B,'exp')")
   print "(/,A)", "*** test number 69 ***"
   call msDisplay(mfFunm(C,'exp'),"mfFunm(C,'exp')")

   ! pairs of mutually inversed functions
   print "(/,A)", "*** test number 70 ***"
   call check_small( mfNorm(A-mfFunm(mfFunm(A,'exp'),'log')),           &
                    "mfNorm(A-mfFunm(mfFunm(A,'exp'),'log'))",          &
                     check_small_threshold )
   call check_small( mfNorm(A-mfFunm(mfFunm(A,'log'),'exp')),           &
                    "mfNorm(A-mfFunm(mfFunm(A,'log'),'exp'))",          &
                     check_small_threshold )

   print "(/,A)", "*** test number 71 ***"
   call check_small( mfNorm(B-mfFunm(mfFunm(B,'exp'),'log')),           &
                    "mfNorm(B-mfFunm(mfFunm(B,'exp'),'log'))",          &
                     check_small_threshold )
   call check_small( mfNorm(B-mfFunm(mfFunm(B,'log'),'exp')),           &
                    "mfNorm(B-mfFunm(mfFunm(B,'log'),'exp'))",          &
                     check_small_threshold )

   print "(/,A)", "*** test number 72 ***"
   call check_small( mfNorm(C-mfFunm(mfFunm(C,'exp'),'log')),           &
                    "mfNorm(C-mfFunm(mfFunm(C,'exp'),'log'))",          &
                     check_small_threshold )
   call check_small( mfNorm(C-mfFunm(mfFunm(C,'log'),'exp')),           &
                    "mfNorm(C-mfFunm(mfFunm(C,'log'),'exp'))",          &
                     check_small_threshold )

   print "(/,A)", "*** test number 73 ***"
   call check_small( mfNorm(A-mfFunm(mfFunm(A,sqr),'sqrt')),            &
                    "mfNorm(A-mfFunm(mfFunm(A,sqr),'sqrt'))",           &
                     check_small_threshold )
   call check_small( mfNorm(A-mfFunm(mfFunm(A,'sqrt'),sqr)),            &
                    "mfNorm(A-mfFunm(mfFunm(A,'sqrt'),sqr))",           &
                     check_small_threshold )

   print "(/,A)", "*** test number 74 ***"
   call check_small( mfNorm(B-mfFunm(mfFunm(B,sqr),'sqrt')),            &
                    "mfNorm(B-mfFunm(mfFunm(B,sqr),'sqrt'))",           &
                     check_small_threshold )
   call check_small( mfNorm(B-mfFunm(mfFunm(B,'sqrt'),sqr)),            &
                    "mfNorm(B-mfFunm(mfFunm(B,'sqrt'),sqr))",           &
                     check_small_threshold )
   ! not for C matrix, because sqrt(C) is not unique
   ! (C is not Symm. Pos. Def.)

   ! msFunm ------------------------------------------------------------
   call print_separation("msFunm")

   print "(/,A)", "*** test number 75 ***"
   A = mfEye(3)
   B = mfHilb(3)
   C = [ 0.1d0, 0.2d0, 0.3d0 ] .vc.                                     &
       [ 0.4d0, 0.5d0, 0.6d0 ] .vc.                                     &
       [ 0.7d0, 0.8d0, 0.9d0 ]

   ! external (user) functions
   print "(/,A)", "*** test number 76 ***"
   call msFunm( mfOut(F,E), A, my_exp )
   call msDisplay(F,"funm(A,my_exp)")
   call msDisplay(E,"  estim. error")

   print "(/,A)", "*** test number 77 ***"
   call msFunm( mfOut(F,E), B, my_exp )
   call msDisplay(F,"funm(B,my_exp)")
   call msDisplay(E,"  estim. error")

   print "(/,A)", "*** test number 78 ***"
   call msFunm( mfOut(F,E), C, my_exp )
   call msDisplay(F,"funm(C,my_exp)")
   call msDisplay(E,"  estim. error")

   print "(/,A)", "*** test number 79 ***"
   call msFunm( mfOut(F,E), A, sqr )
   call msDisplay(F,"funm(A,sqr)")
   call msDisplay(E,"  estim. error")
   call msDisplay(mfNorm(F-mfMul(A,A)),"  comput. error")

   print "(/,A)", "*** test number 80 ***"
   call msFunm( mfOut(F,E), B, sqr )
   call msDisplay(F,"funm(B,sqr)")
   call check_small( E, "estimated error", 1.0d2*MF_EPS )
   call check_small( mfNorm(F-mfMul(B,B)), "computed error", 1.0d2*MF_EPS )

   print "(/,A)", "*** test number 81 ***"
   call msFunm( mfOut(F,E), C, sqr )
   call msDisplay(F,"funm(C,sqr)")
   call check_small( E, "estimated error", 1.0d2*MF_EPS )
   call check_small( mfNorm(F-mfMul(C,C)), "computed error", 1.0d2*MF_EPS )

   ! intrinsic functions
   print "(/,A)", "*** test number 82 ***"
   call msFunm( mfOut(F,E), A, 'exp' )
   call msDisplay(F,"funm(A,'exp')")
   call msDisplay(E,"  estim. error")

   print "(/,A)", "*** test number 83 ***"
   call msFunm( mfOut(F,E), B, 'exp' )
   call msDisplay(F,"funm(B,'exp')")
   call msDisplay(E,"  estim. error")

   print "(/,A)", "*** test number 84 ***"
   call msFunm( mfOut(F,E), C, 'exp' )
   call msDisplay(F,"funm(C,'exp')")
   call msDisplay(E,"  estim. error")

   print "(/,A)", "*** test number 85 ***"
   call msFunm( mfOut(F,E), A, 'sqrt' )
   call msDisplay(F,"funm(A,'sqrt')")
   call msDisplay(E,"  estim. error")
   call msDisplay(mfMul(F,F),"mfMul(F,F)")

   print "(/,A)", "*** test number 86 ***"
   call msFunm( mfOut(F,E), B, 'sqrt' )
   call msDisplay(F,"funm(B,'sqrt')")
   call msDisplay(E,"  estim. error")

   print "(/,A)", "*** test number 87 ***"
   call msFunm( mfOut(F,E), C, 'sqrt' )
   call msDisplay(F,"funm(C,'sqrt')")
   call msDisplay(E,"  estim. error")

   ! mfIsSymm ----------------------------------------------------------
   call print_separation("mfIsSymm")

   !-- real matrices

   print "(/,A)", "*** test number 88 ***"
   A = mfHilb(4)
   A = A*A ! mfHilb(4)**2
   A = A*A ! mfHilb(4)**4
   call msFormat( "long" )
   call msDisplay(A,"A = mfHilb(4)**4")
   if( mfIsSymm(A) ) then
      print *, "  --> mfIsSymm: 'A' symmetric : true"
   else
      print *, "  --> mfIsSymm: 'A' symmetric : false"
   end if

   ! out-of-diagonal element modification...
   ! it seems that the resulting array should be the same, but there is
   ! a slighty discrepancy...
   print "(/,A)", "*** test number 89 ***"
   call msSet( 0.00077160493827d0, A, 4, 3 )
   call msDisplay(A,"A (element (4,3) re-written, involving floating-point error)")
   if( mfIsSymm(A) ) then
      print *, "  --> mfIsSymm: 'A' symmetric : true"
   else
      print *, "  --> mfIsSymm: 'A' symmetric : false"
   end if

   print "(/,A)", "*** test number 90 ***"
   if( mfIsSymm(A,tol=1.0d-14) ) then
      print *, "  --> mfIsSymm: 'A' symmetric with tol=1.0d-14 : true"
   else
      print *, "  --> mfIsSymm: 'A' symmetric with tol=1.0d-14 : false"
   end if

   call msDisplay( mfTolForSymm(A), "mfTolForSymm(A)" )

   ! --- matrix properties become locked ---
   call msPointer(A,A_ptr)
   print "()"
   print *, " A_ptr => A, via 'msPointer' : properties locked."
   print "()"
   MsgLevel_save = mfGetMsgLevel()
   call msSetMsgLevel(3)
   print "(/,A)", "*** test number 91 ***"
   if( mfIsSymm(A) ) then
      print *, "  --> mfIsSymm: 'A' symmetric : true"
   else
      print *, "  --> mfIsSymm: 'A' symmetric : false"
   end if

   ! out-of-diagonal element modification...
   ! now, the correction is good...
   A_ptr(4,3) = (1.0d0/6.0d0)**4
   call msDisplay(A,"A restored")
   print "(/,A)", "*** test number 92 ***"
   if( mfIsSymm(A) ) then
      print *, "  --> mfIsSymm: 'A' symmetric : true"
   else
      print *, "  --> mfIsSymm: 'A' symmetric : false"
   end if

   ! --- matrix properties become unlocked ---
   call msFreePointer(A,A_ptr)
   print "()"
   print *, " end of A_ptr => A, via 'msFreePointer' : properties unlocked."
   print "()"
   call msSetMsgLevel(MsgLevel_save)
   print "(/,A)", "*** test number 93 ***"
   if( mfIsSymm(A) ) then
      print *, "  --> mfIsSymm: 'A' symmetric : true"
   else
      print *, "  --> mfIsSymm: 'A' symmetric : false"
   end if

   allocate( f90_array(2,2) )
   f90_array(:,:) = reshape( [ 1, 0, 0, 1 ], [ 2, 2 ] )
   call msDisplay( f90_array, "f90_array" )

   call msEquiv( f90_array, A )
   print "()"
   print *, " A => f90_array, via 'msEquiv' : properties can just be get, not stored."
   print "()"
   print "(/,A)", "*** test number 94 ***"
   if( mfIsSymm(A) ) then
      print *, "  --> mfIsSymm: 'f90_array' symmetric : true"
   else
      print *, "  --> mfIsSymm: 'f90_array' symmetric : false"
   end if

   call msRelease( A ) ! if not, pb in next assignment
   print "()"
   print *, " end of A => f90_array, via 'msRelease'."
   print "()"
   deallocate( f90_array )

   A = mfEye(4)
   print "()"
   print *, " A = mfEye(4)"
   print "()"

   A = A*2.0d0
   call msDisplay(A,"A = A*2.0d0")
   print "(/,A)", "*** test number 95 ***"
   if( mfIsSymm(A) ) then
      print *, "  --> mfIsSymm: 'A' symmetric : true"
   else
      print *, "  --> mfIsSymm: 'A' symmetric : false"
   end if

   A = A + A
   call msDisplay(A,"A = A + A")
   print "(/,A)", "*** test number 96 ***"
   if( mfIsSymm(A) ) then
      print *, "  --> mfIsSymm: 'A' symmetric : true"
   else
      print *, "  --> mfIsSymm: 'A' symmetric : false"
   end if

   call msFormat( "short" )

   !-- complex matrices

   ! not hermitian (diagonal must be real)
   A = mfEye(3)*(1.0d0+MF_I)
   call msDisplay(A,"A = mfEye(3)*(1.0d0+MF_I)")
   print "(/,A)", "*** test number 97 ***"
   if( mfIsSymm(A) ) then
      print *, "  --> mfIsSymm: 'A' hermitian : true"
   else
      print *, "  --> mfIsSymm: 'A' hermitian : false"
   end if

   ! not hermitian (diagonal must be real)
   A = mfMagic(3)*(1.0d0+MF_I)
   call msDisplay(A,"A = mfMagic(3)*(1.0d0+MF_I)")
   print "(/,A)", "*** test number 98 ***"
   if( mfIsSymm(A) ) then
      print *, "  --> mfIsSymm: 'A' hermitian : true"
   else
      print *, "  --> mfIsSymm: 'A' hermitian : false"
   end if

   ! hermitian
   A = A + .h. A
   call msDisplay(A,"A = A + .h. A")
   print "(/,A)", "*** test number 99 ***"
   if( mfIsSymm(A) ) then
      print *, "  --> mfIsSymm: 'A' hermitian : true"
   else
      print *, "  --> mfIsSymm: 'A' hermitian : false"
   end if
   print "()"

   ! mfTolForSymm ------------------------------------------------------
   call print_separation("mfTolForSymm")

   A = mfEye(5)
   call msDisplay(A,"A")
   if( mfIsSymm(A) ) then
      print *, "  --> info: 'A' symmetric : true"
   else
      print *, "  --> info: 'A' symmetric : false"
   end if

   call msSet( 0.001d0, A, 1, 5 )
   call msDisplay(A,"A")
   if( mfIsSymm(A) ) then
      print *, "  --> info: 'A' symmetric : true"
   else
      print *, "  --> info: 'A' symmetric : false"
   end if

   print "(/,A)", "*** test number 100 ***"
   call msDisplay( mfTolForSymm(A), "mfTolForSymm(A)" )
   if( mfIsSymm(A,tol=5.0d-4) ) then
      print *, "  --> info: 'A' symmetric for tol=5.0d-4 : true"
   else
      print *, "  --> info: 'A' symmetric for tol=5.0d-4 : false"
   end if
   print "()"

   ! msLDLT ------------------------------------------------------------
   call print_separation("msLDLT")

   ! should work for any real scalar
   A = -4.0d0
   print "(/,A)", "*** test number 101 ***"
   call msDisplay(A,"A")
   bool = mfIsSymm(A)
   print *, "Is A symmetric? ", bool
   bool = mfIsPosDef(A)
   print *, "Is A positive definite? ", bool
   call msLDLT( mfOut(L,D,P), A )
   call msDisplay(L,"L",D,"D",P,"P")
   call check_small( mfNorm(mfMul(mfMul(.t.p,A),P)-mfMul(L,mfMul(D,.t.L))), &
                     "| P'*A*P - L*D*L'|", check_small_threshold )

   ! real case
   A = mfMagic(5)
   A = A + .t. A
   print "(/,A)", "*** test number 102 ***"
   call msDisplay(A,"A")
   bool = mfIsSymm(A)
   print *, "Is A symmetric? ", bool
   bool = mfIsPosDef(A)
   print *, "Is A positive definite? ", bool
   call msLDLT( mfOut(L,D,P), A )
   call msDisplay(L,"L",D,"D",P,"P")
   call check_small( mfNorm(mfMul(mfMul(.t.p,A),P)-mfMul(L,mfMul(D,.t.L))), &
                     "| P'*A*P - L*D*L'|", check_small_threshold )

   A = mfHilb(5)
   print "(/,A)", "*** test number 103 ***"
   call msDisplay(A,"A")
   bool = mfIsSymm(A)
   print *, "Is A symmetric? ", bool
   bool = mfIsPosDef(A)
   print *, "Is A positive definite? ", bool
   call msLDLT( mfOut(L,D,P), A )
   call msDisplay(L,"L",D,"D",P,"P")
   call check_small( mfNorm(mfMul(mfMul(.t.p,A),P)-mfMul(L,mfMul(D,.t.L))), &
                     "| P'*A*P - L*D*L'|", check_small_threshold )

   ! mfIsPosDef --------------------------------------------------------
   call print_separation("mfIsPosDef")

   ! real case
   A = mfHilb(5)
   call msDisplay(A,"A")
   print "(/,A)", "*** test number 104 ***"
   if( mfIsPosDef(A) ) then
      print *, "  --> mfIsPosDef: 'A' pos. def. : true"
   else
      print *, "  --> mfIsPosDef: 'A' pos. def. : false"
   end if

   A = [ 1.0d0, 2.0d0, 3.0d0 ] .vc.                                     &
       [ 2.0d0, 1.0d0, 2.0d0 ] .vc.                                     &
       [ 3.0d0, 2.0d0, 1.0d0 ]
   call msDisplay(A,"A")
   print "(/,A)", "*** test number 105 ***"
   if( mfIsPosDef(A) ) then
      print *, "  --> mfIsPosDef: 'A' pos. def. : true"
   else
      print *, "  --> mfIsPosDef: 'A' pos. def. : false"
   end if

   A = mfOnes(3)
   call msDisplay(A,"A")
   print "(/,A)", "*** test number 106 ***"
   if( mfIsPosDef(A) ) then
      print *, "  --> mfIsPosDef: 'A' pos. def. : true"
   else
      print *, "  --> mfIsPosDef: 'A' pos. def. : false"
   end if

   print "()"

   ! mfIsDiagDomCol, mfIsStrictDiagDomCol ------------------------------
   call print_separation("mfIsDiagDomCol, mfIsStrictDiagDomCol")

   A = mfHilb(5)
   call msDisplay(A,"A")
   if( mfIsPosDef(A) ) then
      print *, "  --> info: 'A' pos. def. : true"
   else
      print *, "  --> info: 'A' pos. def. : false"
   end if
   print "(/,A)", "*** test number 107 ***"
   if( mfIsDiagDomCol(A) ) then
      print *, "  --> info: 'A' diag. dominant by cols : true"
   else
      print *, "  --> info: 'A' diag. dominant by cols : false"
   end if
   print "(/,A)", "*** test number 108 ***"
   if( mfIsStrictDiagDomCol(A) ) then
      print *, "  --> info: 'A' strictly diag. dominant by cols : true"
   else
      print *, "  --> info: 'A' strictly diag. dominant by cols : false"
   end if

   d = [ 0.5d0, 0.5d0, 0.5d0, 0.5d0 ]
   A = mfEye(5,5) + mfDiag(d,1) + mfDiag(d,-1)
   call msDisplay(A,"A")
   if( mfIsPosDef(A) ) then
      print *, "  --> info: 'A' pos. def. : true"
   else
      print *, "  --> info: 'A' pos. def. : false"
   end if
   print "(/,A)", "*** test number 109 ***"
   if( mfIsDiagDomCol(A) ) then
      print *, "  --> info: 'A' diag. dominant by cols : true"
   else
      print *, "  --> info: 'A' diag. dominant by cols : false"
   end if
   print "(/,A)", "*** test number 110 ***"
   if( mfIsStrictDiagDomCol(A) ) then
      print *, "  --> info: 'A' strictly diag. dominant by cols : true"
   else
      print *, "  --> info: 'A' strictly diag. dominant by cols : false"
   end if
   print "()"

   ! mfPowm ------------------------------------------------------------
   call print_separation("mfPowm")

   ! integer exponent

   A = mfHilb(5)
   call msDisplay(A,"A")

   call msEig( mfOut(V,D), A )
   n = mfRank(V)
   print "(1X,A,I0)", "rank of the matrix of column eigenvectors: ", n
   print "(1X,A,L1)", "is it full rank ? ", mfIsFullRank(V)

   B = mfEye(5)
   print "(/,A)", "*** test number 111 ***"
   C = mfPowm(A,0)
   call msDisplay(mfNorm(C-B),"| I - mfPowm(A,0) |")

   B = A
   print "(/,A)", "*** test number 112 ***"
   C = mfPowm(A,1)
   call msDisplay(mfNorm(C-B),"| A - mfPowm(A,1) |")

   B = mfMul(A,A)
   print "(/,A)", "*** test number 113 ***"
   C = mfPowm(A,2)
   call msDisplay(mfNorm(C-B),"| A*A - mfPowm(A,2) |")

   B = mfMul(mfMul(A,A),A)
   print "(/,A)", "*** test number 114 ***"
   C = mfPowm(A,3)
   call msDisplay(mfNorm(C-B),"| A^3 - mfPowm(A,3) |")

   B = mfMul(mfMul(mfMul(A,A),A),A)
   print "(/,A)", "*** test number 115 ***"
   C = mfPowm(A,4)
   call check_small( mfNorm(C-B), "| A^4 - mfPowm(A,4) |", 1.0d2*MF_EPS )

   B = A
   do i = 1, 5-1
      B = mfMul(B,A)
   end do
   print "(/,A)", "*** test number 116 ***"
   C = mfPowm(A,5)
   call check_small( mfNorm(C-B), "| A^5 - mfPowm(A,5) |", 1.0d2*MF_EPS )

   B = A
   do i = 1, 6-1
      B = mfMul(B,A)
   end do
   print "(/,A)", "*** test number 117 ***"
   C = mfPowm(A,6)
   call check_small( mfNorm(C-B), "| A^6 - mfPowm(A,6) |", 1.0d3*MF_EPS )

   B = A
   do i = 1, 30-1     ! 30 = 2*3*5
      B = mfMul(B,A)
   end do
   print "(/,A)", "*** test number 118 ***"
   C = mfPowm(A,30)
   R = mfNorm(C-B)/mfNorm(B)
   call check_small( R, "| A^30 - mfPowm(A,30) | / | A^30 |", 1.0d2*MF_EPS )

   ! this real matrix has complex eigenvalues --------------
   A = reshape( [ 0.96, 0.95, 0.14,                                     &
                  0.15, 0.48, 0.42,                                     &
                  0.97, 0.80, 0.91 ], [ 3, 3 ] )
   call msDisplay(A,"A")

   call msEig( mfOut(V,D), A )
   n = mfRank(V,sqrt(MF_EPS))
   print "(1X,A,I0)", "rank of the matrix of column eigenvectors: ", n
   print "(1X,A,L1)", "is it full rank ? ", mfIsFullRank(V)

   B = mfMul(A,A)
   print "(/,A)", "*** test number 119 ***"
   C = mfPowm(A,2)
   call msDisplay(mfNorm(C-B),"| A*A - mfPowm(A,2) |")

   B = mfMul(mfMul(mfMul(A,A),A),A)
   print "(/,A)", "*** test number 120 ***"
   C = mfPowm(A,4)
   call check_small( mfNorm(C-B), "| A^4 - mfPowm(A,4) |", 1.0d2*MF_EPS )

   ! a defective matrix ------------------------------------
   A = reshape( [  5,  4,  2,  1,                                       &
                   0,  1, -1, -1,                                       &
                  -1, -1,  3,  0,                                       &
                   1,  1, -1,  2 ], [ 4, 4 ] )
   call msDisplay(A,"A")

   call msEig( mfOut(V,D), A )
   n = mfRank(V,10.0d0*sqrt(MF_EPS))
   print "(1X,A,I0)", "rank of the matrix of column eigenvectors: ", n
   bool = .not. mfIsFullRank(V,10.0d0*sqrt(MF_EPS))
   print "(1X,A,L1)", "is it defective ? ", bool

   B = mfMul(A,A)
   print "(/,A)", "*** test number 121 ***"
   C = mfPowm(A,2)
   call msDisplay(mfNorm(C-B),"| A*A - mfPowm(A,2) |")

   B = A
   do i = 1, 6-1
      B = mfMul(B,A)
   end do
   print "(/,A)", "*** test number 122 ***"
   C = mfPowm(A,6)
   R = mfNorm(C-B)/mfNorm(B)
   print "()"
   print *, "Warning: for a defective matrix, the Powm function gives"
   print *, "         a very poor approximation!"
   call msDisplay( R, "| A^6 - mfPowm(A,6) | / | A^6 |" )

   B = A
   do i = 1, 30-1     ! 30 = 2*3*5
      B = mfMul(B,A)
   end do
   MsgLevel_save = mfGetMsgLevel()
   call msSetMsgLevel(3)
   print "(/,A)", "*** test number 123 ***"
   call msAssign( C, mfPowm(A,30) )
   call msSetMsgLevel(MsgLevel_save)
   R = mfNorm(C-B)/mfNorm(B)
   print "()"
   print *, "Warning: for a defective matrix, the Powm function gives"
   print *, "         a very poor approximation!"
   call msDisplay( R, "| A^30 - mfPowm(A,30) | / | A^30 |" )

   ! real exponent

   A = mfHilb(5)
   call msDisplay(A,"A")

   call msEig( mfOut(V,D), A )
   n = mfRank(V)
   print "(1X,A,I0)", "rank of the matrix of column eigenvectors: ", n
   print "(1X,A,L1)", "is it full rank ? ", mfIsFullRank(V)

   B = mfSqrtm(A)
   print "(/,A)", "*** test number 124 ***"
   C = mfPowm(A,0.5d0)
   call check_small( mfNorm(C-B), "| mfSqrtm(A) - mfPowm(A,0.5) |", 1.0d3*MF_EPS )

   B = mfFunm(A,pow_3_half)
   print "(/,A)", "*** test number 125 ***"
   C = mfPowm(A,1.5d0)
   call check_small( mfNorm(C-B), "| mfFunm(A,pow_3_half) - mfPowm(A,1.5) |", 1.0d3*MF_EPS )

   ! mfNormEst1 --------------------------------------------------------
   call print_separation("mfNormEst1")

   ! some tests, both for A and inv(A)
   ! ('normest1(inv(A))' is required by 'condest')

   ! real matrices

   ! non singular matrix
   print "(/,A)", "*** test number 126 ***"
   A = mf( [ 1, 2, 3 ] ) .vc. &
       mf( [ 5, 4, 2 ] ) .vc. &
       mf( [ 7, 8, 9 ] )
   call msDisplay(A,"A")
   call msDisplay(mfNorm(A,1),"norm(A,1)")
   call msDisplay(mfNormEst1(A),"normest1(A)")

   ! singular matrix
   print "(/,A)", "*** test number 127 ***"
   A = mf( [ 1, 2, 3 ] ) .vc. &
       mf( [ 1, 2, 3 ] ) .vc. &
       mf( [ 7, 8, 9 ] )
   call msDisplay(A,"A")
   call msDisplay(mfNorm(A,1),"norm(A,1)")
   call msDisplay(mfNormEst1(A),"normest1(A)")

   print "(/,A)", "*** test number 128 ***"
   A = mfHilb(5)
   call msDisplay(A,"A")
   call msDisplay(mfNorm(A,1),"norm(A,1)")
   call msDisplay(mfNormEst1(A),"normest1(A)")

   print "(/,A)", "*** test number 129 ***"
   A = mfHilb(7)
   call msDisplay(A,"A")
   call msDisplay(mfNorm(A,1),"norm(A,1)")
   call msDisplay(mfNormEst1(A),"normest1(A)")

   ! complex matrices

   ! non singular matrix
   print "(/,A)", "*** test number 130 ***"
   A = mf( [ 0, 2, 3 ] ) .vc. &
       mf( [ 5, 0, 2 ] ) .vc. &
       mf( [ 7, 8, 0 ] )
   A = A*MF_I + ( mf( [ 3, 2, 0 ] ) .vc. &
                  mf( [ 5, 4, 2 ] ) .vc. &
                  mf( [ 1, 8, 5 ] ) )
   call msDisplay(A,"A")
   call msDisplay(mfNorm(A,1),"norm(A,1)")
   call msDisplay(mfNormEst1(A),"normest1(A)")

   ! singular matrix
   print "(/,A)", "*** test number 131 ***"
   A = mf( [ 0, 2, 3 ] ) .vc. &
       mf( [ 0, 2, 3 ] ) .vc. &
       mf( [ 7, 8, 0 ] )
   A = A*MF_I + ( mf( [ 3, 2, 0 ] ) .vc. &
                  mf( [ 3, 2, 0 ] ) .vc. &
                  mf( [ 1, 8, 5 ] ) )
   call msDisplay(A,"A")
   call msDisplay(mfNorm(A,1),"norm(A,1)")
   call msDisplay(mfNormEst1(A),"normest1(A)")

   print "(/,A)", "*** test number 132 ***"
   A = mfHilb(5) + (1.0d0/5)*mfEye(5)*MF_I
   call msDisplay(A,"A")
   call msDisplay(mfNorm(A,1),"norm(A,1)")
   call msDisplay(mfNormEst1(A),"normest1(A)")

   print "(/,A)", "*** test number 133 ***"
   A = mfHilb(7) + (1.0d0/7)*mfEye(7)*MF_I
   call msDisplay(A,"A")
   call msDisplay(mfNorm(A,1),"norm(A,1)")
   call msDisplay(mfNormEst1(A),"normest1(A)")

   ! mfCondEst ---------------------------------------------------------
   call print_separation("mfCondEst")

   ! singular matrix

   print "(/,A)", "*** test number 134 ***"
   A = mf( [ 1, 2, 3 ] ) .vc. &
       mf( [ 4, 5, 6 ] ) .vc. &
       mf( [ 7, 8, 9 ] )
   call msDisplay(A,"A")
   call msDisplay(mfCondEst(A),"condest(A)")
   call msDisplay(mfCond(A),"cond(A)")
   call msDisplay(mfRCond(A),"rcond(A)")
   call msDisplay(mfRank(A),"rank(A)")

   ! real matrices

   print "(/,A)", "*** test number 135 ***"
   A = mf( [ 1, 2, 3 ] ) .vc. &
       mf( [ 5, 4, 2 ] ) .vc. &
       mf( [ 7, 8, 9 ] )
   call msDisplay(A,"A")
   call msDisplay(mfCond(A),"cond(A)")
   call msDisplay(1.0d0/mfRCond(A),"1/rcond(A)")
   call msDisplay(mfCondEst(A),"condest(A)")

   print "(/,A)", "*** test number 136 ***"
   A = mf( [ 1, 2, 3 ] ) .vc. &
       mf( [ 1, 2, 3 ] ) .vc. &
       mf( [ 7, 8, 9 ] )
   call msDisplay(A,"A")
   call msDisplay(mfCond(A),"cond(A)")
   call msDisplay(1.0d0/mfRCond(A),"1/rcond(A)")
   call msDisplay(mfCondEst(A),"condest(A)")

   print "(/,A)", "*** test number 137 ***"
   A = mfHilb(5)
   call msDisplay(A,"A")
   call msDisplay(mfCond(A),"cond(A)")
   call msDisplay(1.0d0/mfRCond(A),"1/rcond(A)")
   call msDisplay(mfCondEst(A),"condest(A)")

   print "(/,A)", "*** test number 138 ***"
   A = mfHilb(7)
   call msDisplay(A,"A")
   call msDisplay(mfCond(A),"cond(A)")
   call msDisplay(1.0d0/mfRCond(A),"1/rcond(A)")
   call msDisplay(mfCondEst(A),"condest(A)")

   ! complex matrices

   print "(/,A)", "*** test number 139 ***"
   A = mf( [ 0, 2, 3 ] ) .vc. &
       mf( [ 5, 0, 2 ] ) .vc. &
       mf( [ 7, 8, 0 ] )
   A = A*MF_I + ( mf( [ 3, 2, 0 ] ) .vc. &
                  mf( [ 5, 4, 2 ] ) .vc. &
                  mf( [ 1, 8, 5 ] ) )
   call msDisplay(A,"A")
   call msDisplay(mfCond(A),"cond(A)")
   call msDisplay(1.0d0/mfRCond(A),"1/rcond(A)")
   call msDisplay(mfCondEst(A),"condest(A)")

   print "(/,A)", "*** test number 140 ***"
   A = mf( [ 0, 2, 3 ] ) .vc. &
       mf( [ 0, 2, 3 ] ) .vc. &
       mf( [ 7, 8, 0 ] )
   A = A*MF_I + ( mf( [ 3, 2, 0 ] ) .vc. &
                  mf( [ 3, 2, 0 ] ) .vc. &
                  mf( [ 1, 8, 5 ] ) )
   call msDisplay(A,"A")
   call msDisplay(mfCond(A),"cond(A)")
   call msDisplay(1.0d0/mfRCond(A),"1/rcond(A)")
   call msDisplay(mfCondEst(A),"condest(A)")

   print "(/,A)", "*** test number 141 ***"
   A = mfHilb(5) + (1.0d0/5**5)*mfEye(5)*MF_I
   call msDisplay(A,"A")
   call msDisplay(mfCond(A),"cond(A)")
   call msDisplay(1.0d0/mfRCond(A),"1/rcond(A)")
   call msDisplay(mfCondEst(A),"condest(A)")

   print "(/,A)", "*** test number 142 ***"
   n = 7
   A = mfMagic( n )*MF_I
   A = (A + .h. A) + dble(n**2)*mfEye(n)
   call msDisplay(A,"A")
   ! force to check the hermitianness and pos. def. property
   bool = mfIsSymm(A)
   if( bool ) then
      print *, "A is hermitian"
   else
      print *, "A is not hermitian"
   end if
   bool = mfIsPosDef(A)
   if( bool ) then
      print *, "A is positive definite"
   else
      print *, "A is not positive definite"
   end if
   call msDisplay(mfCond(A),"cond(A)")
   call msDisplay(1.0d0/mfRCond(A),"1/rcond(A)")
   call msDisplay(mfCondEst(A),"condest(A)")

   ! mfNormEst ---------------------------------------------------------
   call print_separation("mfNormEst")

   ! real matrices

   print "(/,A)", "*** test number 143 ***"
   A = mf( [ 1, 2, 3 ] ) .vc. &
       mf( [ 5, 4, 2 ] ) .vc. &
       mf( [ 7, 8, 9 ] )
   call msDisplay(A,"A")
   call msDisplay(mfNorm(A),"norm(A)")
   call msDisplay(mfNormEst(A),"normest(A)")

   print "(/,A)", "*** test number 144 ***"
   A = mf( [ 1, 2, 3 ] ) .vc. &
       mf( [ 1, 2, 3 ] ) .vc. &
       mf( [ 7, 8, 9 ] )
   call msDisplay(A,"A")
   call msDisplay(mfNorm(A),"norm(A)")
   call msDisplay(mfNormEst(A),"normest(A)")

   print "(/,A)", "*** test number 145 ***"
   A = mfHilb(5)
   call msDisplay(A,"A")
   call msDisplay(mfNorm(A),"norm(A)")
   call msDisplay(mfNormEst(A),"normest(A)")

   print "(/,A)", "*** test number 146 ***"
   A = mfHilb(7)
   call msDisplay(A,"A")
   call msDisplay(mfNorm(A),"norm(A)")
   call msDisplay(mfNormEst(A),"normest(A)")

   ! non-square real matrices

   print "(/,A)", "*** test number 147 ***"
   A = mf( [ 1, 2, 3 ] ) .vc. &
       mf( [ 5, 4, 2 ] ) .vc. &
       mf( [ 7, 8, 9 ] )
   A = A .hc. A
   call msDisplay(A,"A")
   call msDisplay(mfNorm(A),"norm(A)")
   call msDisplay(mfNormEst(A),"normest(A)")

   ! complex matrices

   print "(/,A)", "*** test number 148 ***"
   A = mf( [ 0, 2, 3 ] ) .vc. &
       mf( [ 5, 0, 2 ] ) .vc. &
       mf( [ 7, 8, 0 ] )
   A = A*MF_I + ( mf( [ 3, 2, 0 ] ) .vc. &
                  mf( [ 5, 4, 2 ] ) .vc. &
                  mf( [ 1, 8, 5 ] ) )
   call msDisplay(A,"A")
   call msDisplay(mfNorm(A),"norm(A)")
   call msDisplay(mfNormEst(A),"normest(A)")

   print "(/,A)", "*** test number 149 ***"
   A = mf( [ 0, 2, 3 ] ) .vc. &
       mf( [ 0, 2, 3 ] ) .vc. &
       mf( [ 7, 8, 0 ] )
   A = A*MF_I + ( mf( [ 3, 2, 0 ] ) .vc. &
                  mf( [ 3, 2, 0 ] ) .vc. &
                  mf( [ 1, 8, 5 ] ) )
   call msDisplay(A,"A")
   call msDisplay(mfNorm(A),"norm(A)")
   call msDisplay(mfNormEst(A),"normest(A)")

   print "(/,A)", "*** test number 150 ***"
   A = mfHilb(5) + (1.0d0/5)*mfEye(5)*MF_I
   call msDisplay(A,"A")
   call msDisplay(mfNorm(A),"norm(A)")
   call msDisplay(mfNormEst(A),"normest(A)")

   print "(/,A)", "*** test number 151 ***"
   A = mfHilb(7) + (1.0d0/7)*mfEye(7)*MF_I
   call msDisplay(A,"A")
   call msDisplay(mfNorm(A),"norm(A)")
   call msDisplay(mfNormEst(A),"normest(A)")

   ! non-square complex matrices

   print "(/,A)", "*** test number 152 ***"
   A = mf( [ 0, 2, 3 ] ) .vc. &
       mf( [ 5, 0, 2 ] ) .vc. &
       mf( [ 7, 8, 0 ] )
   A = A*MF_I + ( mf( [ 3, 2, 0 ] ) .vc. &
                  mf( [ 5, 4, 2 ] ) .vc. &
                  mf( [ 1, 8, 5 ] ) )
   A = A .hc. A
   call msDisplay(A,"A")
   call msDisplay(mfNorm(A),"norm(A)")
   call msDisplay(mfNormEst(A),"normest(A)")

   ! operator(.i.) -----------------------------------------------------
   call print_separation("operator(.i.)")

   print "(/,A)", "*** test number 153 ***"
   A = mfHilb(4)
   call msDisplay( A, "A = mfHilb(4)" )
   call msDisplay( .i. A, ".i. A" )

   ! operator(.ix.) ----------------------------------------------------
   call print_separation("operator(.ix.)")

   print "(/,A)", "*** test number 154 ***"
   A = mfHilb(4)
   b = mfOnes(4,1)
   call msDisplay( A, "A = mfHilb(4)", b, "b" )
   call msDisplay( A .ix. b, "A .ix. b" )

   ! operator(.xi.) ----------------------------------------------------
   call print_separation("operator(.xi.)")

   print "(/,A)", "*** test number 155 ***"
   A = mfHilb(4)
   b = mfOnes(1,4)
   call msDisplay( A, "A = mfHilb(4)", b, "b" )
   call msDisplay( b .xi. A, "b .xi. A" )

   ! mfIsDiag ----------------------------------------------------------
   call print_separation("mfIsDiag")

   print "(/,A)", "*** test number 156 ***"
   A = mfEye(4)
   call msDisplay( A, "A = mfEye(4)" )

   print *, "mfIsDiag(A) : ", mfIsDiag(A)

   call msSet( 2.0d0, A, 1, 4 )
   print *, "mfIsDiag(A) : ", mfIsDiag(A)

   call msSet( 0.0d0, A, 1, 4 )
   print *, "mfIsDiag(A) : ", mfIsDiag(A)

   print "(/,A)", "*** test number 157 ***"
   A = mfEye(4)*MF_I
   call msDisplay( A, "A = mfEye(4)*MF_I" )

   print *, "mfIsDiag(A) : ", mfIsDiag(A)

   call msSet( 2.0d0*MF_I, A, 1, 4 )
   print *, "mfIsDiag(A) : ", mfIsDiag(A)

   call msSet( 0.0d0, A, 1, 4 )
   print *, "mfIsDiag(A) : ", mfIsDiag(A)
   print "()"

   ! mfIsTril -----------------------------------------------------
   call print_separation("mfIsTril")

   print "(/,A)", "*** test number 158 ***"
   A = mfTril(mfOnes(4))
   call msDisplay( A, "A = mfTril(mfOnes(4))" )

   print *, "mfIsTril(A) : ", mfIsTril(A)

   print "(/,A)", "*** test number 159 ***"
   A = mfTriu(mfOnes(4))
   call msDisplay( A, "A = mfTriu(mfOnes(4))" )

   print *, "mfIsTril(A) : ", mfIsTril(A)

   print "(/,A)", "*** test number 160 ***"
   A = mfTril(mfOnes(5,3))
   call msDisplay( A, "A = mfTril(mfOnes(5,3))" )

   print *, "mfIsTril(A) : ", mfIsTril(A)

   print "(/,A)", "*** test number 161 ***"
   A = mfTril(mfOnes(3,5))
   call msDisplay( A, "A = mfTril(mfOnes(3,5))" )

   print *, "mfIsTril(A) : ", mfIsTril(A)
   print "()"

   ! mfIsTriu ----------------------------------------------------------
   call print_separation("mfIsTriu")

   print "(/,A)", "*** test number 162 ***"
   A = mfTriu(mfOnes(4))
   call msDisplay( A, "A = mfTriu(mfOnes(4))" )

   print *, "mfIsTriu(A) : ", mfIsTriu(A)

   print "(/,A)", "*** test number 163 ***"
   A = mfTril(mfOnes(4))
   call msDisplay( A, "A = mfTril(mfOnes(4))" )

   print *, "mfIsTriu(A) : ", mfIsTriu(A)

   print "(/,A)", "*** test number 164 ***"
   A = mfTriu(mfOnes(5,3))
   call msDisplay( A, "A = mfTriu(mfOnes(5,3))" )

   print *, "mfIsTriu(A) : ", mfIsTriu(A)

   print "(/,A)", "*** test number 165 ***"
   A = mfTriu(mfOnes(3,5))
   call msDisplay( A, "A = mfTriu(mfOnes(3,5))" )

   print *, "mfIsTriu(A) : ", mfIsTriu(A)
   print "()"

   ! End of tests ------------------------------------------------------
   print "(A)", "                         ┏━━━━━━━━━━━━━━━━━━━━━━━━━━┓"
   print "(A)", "                         ┃ End of test_mod_matfun_2 ┃"
   print "(A)", "                         ┗━━━━━━━━━━━━━━━━━━━━━━━━━━┛"

   !--------------------------------------------------------------------
99 continue

   print "()"
   call msSetMsgLevel(2)

   call msRelease( x, A, L, U, P, B, S )
   call msRelease( V, AI, Q, R, T, D, H )
   call msRelease( A_sym, A_nonsym, A_herm, A_nonherm, C, F, E )
   call msRelease( jpiv, flag )

   ! internal use of PrimeNumbers in mfPowm
   call msCleanPrimeNumbers()

   ! non official Muesli routine: introduced here to clean memory
   call RngStream_end()

end program
