program test_mod_matfun_1

   use fml

   use test_aux
   use lib_aux

   implicit none

   type(mfArray) :: x, A, L, U, P, B, S, V, AI, Q, R, T, D, H
   type(mfArray) :: A_sym, A_nonsym, A_herm, A_nonherm, C, F, E, jpiv
   type(mfArray) :: flag, rank
   real(kind=MF_DOUBLE), pointer :: A_ptr(:,:)
!!   real(kind=MF_DOUBLE), allocatable :: f90_array(:,:)
   integer :: i, n
   integer :: MsgLevel_save
   real(kind=MF_DOUBLE) :: check_small_threshold = 1.0d3*MF_EPS
   logical :: bool

   ! Msg level = 3 : all messages are printed (verbose mode)
   !             2 : messages of kind 'ERROR' and 'Warning' are
   !                 printed [default]
   !             1 : only messages of kind 'ERROR' are printed
   !             0 : nothing is printed (quiet mode)
   !                 (pause are ignored !)

!!   call msSetMsgLevel(3)
!!   call msSetTrbLevel("all")

   print "()"

   ! for TRACE_MEM_DEBUG, STDERR must be redirected to STDOUT;
   ! the same thing stands for 'make check'
   call msSetStdIO( stderr=STDOUT )

!!goto 10

   ! to avoid escape sequences of color setting in the output file
   ! (default in "on")
   call msSetColoredMsg( "off" )

   ! VERSIONs ----------------------------------------------------------
   print "()"
   print *, "MF_MUESLI_VERSION = '", MF_MUESLI_VERSION, "'"
   print "()"
   print *, "MF_COMPILER_VERSION = '", MF_COMPILER_VERSION, "'"
   print "()"
   print *, "MF_COMPILATION_CONFIG = '", MF_COMPILATION_CONFIG(), "'"
   print "()"

   ! Lapack version ----------------------------------------------------
   call print_separation("MF_LAPACK_VERSION")

   print "()"
   print *, "MF_LAPACK_VERSION = '", trim(MF_LAPACK_VERSION()), "'"

   print "()"
   print *, "mfIsVersion( MF_LAPACK_VERSION(), '>=', '3.0.0' ) : ",     &
             mfIsVersion( MF_LAPACK_VERSION(), '>=', '3.0.0' )

   print "()"

   ! mfDet -------------------------------------------------------------
   call print_separation("mfDet")

   print "(/,A)", "*** test number 1 ***"
   A = [ 1.0d0, 2.0d0, 3.0d0 ] .vc.                                     &
       [ 4.0d0, 5.0d0, 6.0d0 ] .vc.                                     &
       [ 7.0d0, 8.0d0, 9.0d0 ]
   call msDisplay(A,"A")
   ! det(A) should be very small
   call check_small( mfDet(A), "det(A)", check_small_threshold )

   print "(/,A)", "*** test number 2 ***"
   A = mfEye(5)
   call msDisplay(A,"A",mfDet(A),"det(A)")

   print "(/,A)", "*** test number 3 ***"
   A = mfHilb(5)
   call msDisplay(A,"A",mfDet(A),"det(A)")

   print "(/,A)", "*** test number 4 ***"
   A = mfEye(3)*2.0d0 + mfHilb(3)*MF_I
   call msDisplay(A,"A",mfDet(A),"det(A)")

   ! mfTrace -----------------------------------------------------------
   call print_separation("mfTrace")

   print "(/,A)", "*** test number 5 ***"
   A = mfOnes(3)
   call msDisplay(A,"A")
   call msDisplay(mfTrace(A),"mfTrace(A)")

   print "(/,A)", "*** test number 6 ***"
   A = mfOnes(2,4)
   call msDisplay(A,"A")
   call msDisplay(mfTrace(A),"mfTrace(A)")

   print "(/,A)", "*** test number 7 ***"
   A = mfOnes(4,2)*MF_I
   call msDisplay(A,"A")
   call msDisplay(mfTrace(A),"mfTrace(A)")

   ! msLU --------------------------------------------------------------
   call print_separation("msLU")

   ! ------ without P request

   ! should work for any real scalar
   print "(/,A)", "*** test number 8 ***"
   A = -4.0d0
   call msDisplay(A,"A")
   call msLU( mfOut(L,U), A )
   call msDisplay(L,"L",U,"U")
   call check_small( mfNorm(mfMul(L,U)-A), "|L*U - A|",                 &
                     check_small_threshold )

   ! real case
   print "(/,A)", "*** test number 9 ***"
   A = mf( reshape( [ 1, 7, 1, 2, 8, 2, 3, 9, 4 ], [ 3, 3 ] ) )
   call msDisplay(A,"A")
   call msLU( mfOut(L,U), A )
   call msDisplay(L,"L",U,"U")
   call check_small( mfNorm(mfMul(L,U)-A), "|L*U - A|",                 &
                     check_small_threshold )

   print "(/,A)", "*** test number 10 ***"
   A = mf( reshape( [ (i-8,i=1,16) ], [ 4, 4 ] ) ) + mfEye(4)
   call msDisplay(A,"A")
   call msLU( mfOut(L,U), A )
   call msDisplay(L,"L",U,"U")
   call check_small( mfNorm(mfMul(L,U)-A), "|L*U - A|",                 &
                     check_small_threshold )

   print "(/,A)", "*** test number 11 ***"
   A = mf( reshape( [ (i-12,i=1,25) ], [ 5, 5 ] ) ) + mfEye(5)
   call msDisplay(A,"A")
   call msLU( mfOut(L,U), A )
   call msDisplay(L,"L",U,"U")
   call check_small( mfNorm(mfMul(L,U)-A), "|L*U - A|",                 &
                     check_small_threshold )

   ! non-square matrix : m > n
   print "(/,A)", "*** test number 12 ***"
   A = mf( reshape( [ (i-7,i=1,15) ], [ 5, 3 ] ) ) + mfEye(5,3)
   call msDisplay(A,"A")
   call msLU( mfOut(L,U), A )
   call msDisplay(L,"L",U,"U")
   call check_small( mfNorm(mfMul(L,U)-A), "|L*U - A|",                 &
                     check_small_threshold )

   ! non-square matrix : m < n
   print "(/,A)", "*** test number 13 ***"
   A = mf( reshape( [ (i-7,i=1,15) ], [ 3, 5 ] ) ) + mfEye(3,5)
   call msDisplay(A,"A")
   call msLU( mfOut(L,U), A )
   call msDisplay(L,"L",U,"U")
   call check_small( mfNorm(mfMul(L,U)-A), "|L*U - A|",                 &
                     check_small_threshold )

   ! singular matrix
   print "(/,A)", "*** test number 14 ***"
   A = mf( [ 1, 2, 3 ] ) .vc. &
       mf( [ 1, 2, 3 ] ) .vc. &
       mf( [ 7, 8, 9 ] )
   call msDisplay(A,"A")
   MsgLevel_save = mfGetMsgLevel()
   call msSetMsgLevel(3)
   call msLU( mfOut(L,U), A )
   call msSetMsgLevel(MsgLevel_save)
   call msDisplay(L,"L",U,"U")

   ! complex case
   print "(/,A)", "*** test number 15 ***"
   A = mf( reshape( [ 1, 7, 1, 2, 8, 2, 3, 9, 4 ], [ 3, 3 ] ) )
   A = A+ MF_I*mfEye(3,3)
   call msDisplay(A,"A")
   call msLU( mfOut(L,U), A )
   call msDisplay(L,"L",U,"U")
   call check_small( mfNorm(mfMul(L,U)-A), "|L*U - A|",                 &
                     check_small_threshold )

   print "(/,A)", "*** test number 16 ***"
   A = mf( reshape( [ (i-12,i=1,25) ], [ 5, 5 ] ) ) + mfEye(5)
   A = A+ MF_I*mfEye(5,5)
   call msDisplay(A,"A")
   call msLU( mfOut(L,U), A )
   call msDisplay(L,"L",U,"U")
   call check_small( mfNorm(mfMul(L,U)-A), "|L*U - A|",                 &
                     check_small_threshold )

   ! non-square matrix : m > n
   print "(/,A)", "*** test number 17 ***"
   A = mf( reshape( [ (i-7,i=1,15) ], [ 5, 3 ] ) ) + mfEye(5,3)
   A = A+ MF_I*mfEye(5,3)
   call msDisplay(A,"A")
   call msLU( mfOut(L,U), A )
   call msDisplay(L,"L",U,"U")
   call check_small( mfNorm(mfMul(L,U)-A), "|L*U - A|",                 &
                     check_small_threshold )

   ! non-square matrix : m < n
   print "(/,A)", "*** test number 18 ***"
   A = mf( reshape( [ (i-7,i=1,15) ], [ 3, 5 ] ) ) + mfEye(3,5)
   A = A+ MF_I*mfEye(3,5)
   call msDisplay(A,"A")
   call msLU( mfOut(L,U), A )
   call msDisplay(L,"L",U,"U")
   call check_small( mfNorm(mfMul(L,U)-A), "|L*U - A|",                 &
                     check_small_threshold )

   ! singular matrix
   print "(/,A)", "*** test number 19 ***"
   A = mf( [ 1, 2, 3 ] ) .vc. &
       mf( [ 1, 2, 3 ] ) .vc. &
       mf( [ 7, 8, 9 ] )
   A = A*MF_I
   call msDisplay(A,"A")
   MsgLevel_save = mfGetMsgLevel()
   call msSetMsgLevel(3)
   call msLU( mfOut(L,U), A )
   call msSetMsgLevel(MsgLevel_save)
   call msDisplay(L,"L",U,"U")

   ! ------ with P request

   ! real case
   print "(/,A)", "*** test number 20 ***"
   A = mf( reshape( [ 1, 7, 1, 2, 8, 2, 3, 9, 4 ], [ 3, 3 ] ) )
   call msDisplay(A,"A")
   call msLU( mfOut(L,U,p), A )
   call msDisplay(L,"L",U,"U",p,"p")
   call check_small( mfNorm(mfMul(L,U)-mfRowPerm(A,p)), "|A(p,:) - L*U|", &
                     check_small_threshold )

   print "(/,A)", "*** test number 21 ***"
   A = mf( reshape( [ (i-8,i=1,16) ], [ 4, 4 ] ) ) + mfEye(4)
   call msDisplay(A,"A")
   call msLU( mfOut(L,U,p), A )
   call msDisplay(L,"L",U,"U",p,"p")
   call check_small( mfNorm(mfMul(L,U)-mfRowPerm(A,p)), "|A(p,:) - L*U|", &
                     check_small_threshold )

   print "(/,A)", "*** test number 22 ***"
   A = mf( reshape( [ (i-12,i=1,25) ], [ 5, 5 ] ) ) + mfEye(5)
   call msDisplay(A,"A")
   call msLU( mfOut(L,U,p), A )
   call msDisplay(L,"L",U,"U",p,"p")
   call check_small( mfNorm(mfMul(L,U)-mfRowPerm(A,p)), "|A(p,:) - L*U|", &
                     check_small_threshold )

   ! non-square matrix : m > n
   print "(/,A)", "*** test number 23 ***"
   A = mf( reshape( [ (i-7,i=1,15) ], [ 5, 3 ] ) ) + mfEye(5,3)
   call msDisplay(A,"A")
   call msLU( mfOut(L,U,p), A )
   call msDisplay(L,"L",U,"U",p,"p")
   call check_small( mfNorm(mfMul(L,U)-mfRowPerm(A,p)), "|A(p,:) - L*U|", &
                     check_small_threshold )

   ! non-square matrix : m < n
   print "(/,A)", "*** test number 24 ***"
   A = mf( reshape( [ (i-7,i=1,15) ], [ 3, 5 ] ) ) + mfEye(3,5)
   call msDisplay(A,"A")
   call msLU( mfOut(L,U,p), A )
   call msDisplay(L,"L",U,"U",p,"p")
   call check_small( mfNorm(mfMul(L,U)-mfRowPerm(A,p)), "|A(p,:) - L*U|", &
                     check_small_threshold )

   ! complex case
   print "(/,A)", "*** test number 25 ***"
   A = mf( reshape( [ 1, 7, 1, 2, 8, 2, 3, 9, 4 ], [ 3, 3 ] ) )
   A = A+ MF_I*mfEye(3,3)
   call msDisplay(A,"A")
   call msLU( mfOut(L,U,p), A )
   call msDisplay(L,"L",U,"U",p,"p")
   call check_small( mfNorm(mfMul(L,U)-mfRowPerm(A,p)), "|A(p,:) - L*U|", &
                     check_small_threshold )

   print "(/,A)", "*** test number 26 ***"
   A = mf( reshape( [ (i-8,i=1,16) ], [ 4, 4 ] ) ) + mfEye(4)
   A = A+ MF_I*mfEye(4,4)
   call msDisplay(A,"A")
   call msLU( mfOut(L,U,p), A )
   call msDisplay(L,"L",U,"U",p,"p")
   call check_small( mfNorm(mfMul(L,U)-mfRowPerm(A,p)), "|A(p,:) - L*U|", &
                     check_small_threshold )

   print "(/,A)", "*** test number 27 ***"
   A = mf( reshape( [ (i-12,i=1,25) ], [ 5, 5 ] ) ) + mfEye(5)
   A = A+ MF_I*mfEye(5,5)
   call msDisplay(A,"A")
   call msLU( mfOut(L,U,p), A )
   call msDisplay(L,"L",U,"U",p,"p")
   call check_small( mfNorm(mfMul(L,U)-mfRowPerm(A,p)), "|A(p,:) - L*U|", &
                     check_small_threshold )

   ! non-square matrix : m > n
   print "(/,A)", "*** test number 28 ***"
   A = mf( reshape( [ (i-7,i=1,15) ], [ 5, 3 ] ) ) + mfEye(5,3)
   A = A+ MF_I*mfEye(5,3)
   call msDisplay(A,"A")
   call msLU( mfOut(L,U,p), A )
   call msDisplay(L,"L",U,"U",p,"p")
   call check_small( mfNorm(mfMul(L,U)-mfRowPerm(A,p)), "|A(p,:) - L*U|", &
                     check_small_threshold )

   ! non-square matrix : m < n
   print "(/,A)", "*** test number 29 ***"
   A = mf( reshape( [ (i-7,i=1,15) ], [ 3, 5 ] ) ) + mfEye(3,5)
   A = A+ MF_I*mfEye(3,5)
   call msDisplay(A,"A")
   call msLU( mfOut(L,U,p), A )
   call msDisplay(L,"L",U,"U",p,"p")
   call check_small( mfNorm(mfMul(L,U)-mfRowPerm(A,p)), "|A(p,:) - L*U|", &
                     check_small_threshold )

   ! msQR --------------------------------------------------------------
   call print_separation("msQR")

   ! special QR : vector real matrix -- row vector
   ! real case
   print "(/,A)", "*** test number 30 ***"
   A = mf( [ 1, 2, 3 ] )
   call msDisplay(A,"A")
   call msDisplay(mfRank(A),"rank(A) via SVD")
   call msQR( mfOut(Q,R,p), A )
   call msDisplay(Q,"Q",R,"R",p,"p")
   call check_small( mfNorm(mfMul(Q,R)-mfColPerm(A,p)), "|Q*R - A(:,p)|", &
                     check_small_threshold )

   ! special QR : vector real matrix -- column vector
   ! real case
   print "(/,A)", "*** test number 31 ***"
   A = .t. mf( [ 1, 2, 3 ] )
   call msDisplay(A,"A")
   call msDisplay(mfRank(A),"rank(A) via SVD")
   call msQR( mfOut(Q,R,p), A )
   call msDisplay(Q,"Q",R,"R",p,"p")
   call check_small( mfNorm(mfMul(Q,R)-mfColPerm(A,p)), "|Q*R - A(:,p)|", &
                     check_small_threshold )

   ! standard QR : rect. real matrix (m>n) rank deficient
   ! real case
   print "(/,A)", "*** test number 32 ***"
   A = mf( reshape( [ (i-10,i=1,20) ], [ 5, 4 ] ) )
   call msDisplay(A,"A")
   call msDisplay(mfRank(A),"rank(A) via SVD")
   call msQR( mfOut(Q,R,p), A )
   call msDisplay(Q,"Q",R,"R",p,"p")
   call check_small( mfNorm(mfMul(Q,R)-mfColPerm(A,p)), "|Q*R - A(:,p)|", &
                     check_small_threshold )

   print "(/,A)", "*** test number 33 ***"
   A = mf( reshape( [ (i-10,i=1,20) ], [ 4, 5 ] ) )
   call msDisplay(A,"A")
   call msDisplay(mfRank(A),"rank(A) via SVD")
   call msQR( mfOut(Q,R,p), A )
   call msDisplay(Q,"Q",R,"R",p,"p")
   call check_small( mfNorm(mfMul(Q,R)-mfColPerm(A,p)), "|Q*R - A(:,p)|", &
                     check_small_threshold )

   ! complex case
   print "(/,A)", "*** test number 34 ***"
   A = mf( reshape( [ (i-10,i=1,20) ], [ 5, 4 ] ) )*(1.0d0+0.01d0*MF_I)
   call msDisplay(A,"A")
   call msDisplay(mfRank(A),"rank(A) via SVD")
   call msQR( mfOut(Q,R,p), A )
   call msDisplay(Q,"Q",R,"R",p,"p")
   call check_small( mfNorm(mfMul(Q,R)-mfColPerm(A,p)), "|Q*R - A(:,p)|", &
                     check_small_threshold )

   print "(/,A)", "*** test number 35 ***"
   A = mf( reshape( [ (i-10,i=1,20) ], [ 4, 5 ] ) )*(1.0d0+0.01d0*MF_I)
   call msDisplay(A,"A")
   call msDisplay(mfRank(A),"rank(A) via SVD")
   call msQR( mfOut(Q,R,p), A )
   call msDisplay(Q,"Q",R,"R",p,"p")
   call check_small( mfNorm(mfMul(Q,R)-mfColPerm(A,p)), "|Q*R - A(:,p)|", &
                     check_small_threshold )

   ! rank revealing QR : rect. real matrix (m>n) full rank
   ! real case
   print "(/,A)", "*** test number 36 ***"
   A = mf( reshape( [ (i-10,i=1,20) ], [ 5, 4 ] ) )
   call msSet( 0.0d0, A, 1, 3 )
   call msSet( 0.0d0, A, 5, 4 )
   call msDisplay(A,"A")
   call msDisplay(mfRank(A),"rank(A) via SVD")
   call msQR( mfOut(Q,R,p,rank), A )
   call msDisplay(Q,"Q",R,"R",p,"p")
   call msDisplay( rank, "Rank Revealing QR: rank" )
   call check_small( mfNorm(mfMul(Q,R)-mfColPerm(A,p)), "|Q*R - A(:,p)|", &
                     check_small_threshold )

   ! rank revealing QR : rect. real matrix (m>n) full rank [full Q and R]
   print "(/,A)", "*** test number 37 ***"
   A = mf( reshape( [ (i-10,i=1,20) ], [ 5, 4 ] ) )
   call msSet( 0.0d0, A, 1, 3 )
   call msSet( 0.0d0, A, 5, 4 )
   call msDisplay(A,"A")
   call msDisplay(mfRank(A),"rank(A) via SVD")
   call msQR( mfOut(Q,R,p,rank), A, fullQ=.true. )
   call msDisplay(Q,"Q",R,"R",p,"p")
   call msDisplay( rank, "Rank Revealing QR: rank" )
   call check_small( mfNorm(mfMul(Q,R)-mfColPerm(A,p)), "|Q*R - A(:,p)|", &
                     check_small_threshold )

   ! rank revealing QR : rect. real matrix (m>n) rank deficient
   print "(/,A)", "*** test number 38 ***"
   A = mf( reshape( [ (i-10,i=1,20) ], [ 5, 4 ] ) )
   call msDisplay(A,"A")
   call msDisplay(mfRank(A),"rank(A) via SVD")
   call msQR( mfOut(Q,R,p,rank), A )
   call msDisplay(Q,"Q",R,"R",p,"p")
   call msDisplay( rank, "Rank Revealing QR: rank" )
   call check_small( mfNorm(mfMul(Q,R)-mfColPerm(A,p)), "|Q*R - A(:,p)|", &
                     check_small_threshold )

   ! rank revealing QR : rect. real matrix (m<n) full rank
   print "(/,A)", "*** test number 39 ***"
   A = mf( reshape( [ (i-10,i=1,20) ], [ 4, 5 ] ) )
   call msSet( 0.0d0, A, 4, 3 )
   call msSet( 0.0d0, A, 1, 4 )
   call msDisplay(A,"A")
   call msDisplay(mfRank(A),"rank(A) via SVD")
   call msQR( mfOut(Q,R,p,rank), A )
   call msDisplay(Q,"Q",R,"R",p,"p")
   call msDisplay( rank, "Rank Revealing QR: rank" )
   call check_small( mfNorm(mfMul(Q,R)-mfColPerm(A,p)), "|Q*R - A(:,p)|", &
                     check_small_threshold )

   ! rank revealing QR : rect. real matrix (m<n) full rank
   !  [full Q and R resquested, but doesn't change anything when m<n]
   print "(/,A)", "*** test number 40 ***"
   A = mf( reshape( [ (i-10,i=1,20) ], [ 4, 5 ] ) )
   call msSet( 0.0d0, A, 4, 3 )
   call msSet( 0.0d0, A, 1, 4 )
   call msDisplay(A,"A")
   call msDisplay(mfRank(A),"rank(A) via SVD")
   call msQR( mfOut(Q,R,p,rank), A, fullQ=.true. )
   call msDisplay(Q,"Q",R,"R",p,"p")
   call msDisplay( rank, "Rank Revealing QR: rank" )
   call check_small( mfNorm(mfMul(Q,R)-mfColPerm(A,p)), "|Q*R - A(:,p)|", &
                     check_small_threshold )

   ! rank revealing QR : rect. real matrix (m<n) rank deficient
   print "(/,A)", "*** test number 41 ***"
   A = mf( reshape( [ (i-10,i=1,20) ], [ 4, 5 ] ) )
   call msDisplay(A,"A")
   call msDisplay(mfRank(A),"rank(A) via SVD")
   call msQR( mfOut(Q,R,p,rank), A )
   call msDisplay(Q,"Q",R,"R",p,"p")
   call msDisplay( rank, "Rank Revealing QR: rank" )
   call check_small( mfNorm(mfMul(Q,R)-mfColPerm(A,p)), "|Q*R - A(:,p)|", &
                     check_small_threshold )

   ! rank revealing QR : input tolerance
   print "(/,A)", "*** test number 42 ***"
   A = mfColon( 0.0d0, -16.0d0, -2.0d0 )
   A = 10.0d0 ** A
   call msFormat( exponent="sci" )
   call msDisplay(A,"A")
   call msFormat( )
   A = mfDiag( A )
   call msDisplay(A,"A")
   call msQR( mfOut(Q,R,p,rank), A, tol=1.0d-12 )
   call msDisplay( rank, "Rank Revealing QR: rank with tol 1.0d-12" )
   call msQR( mfOut(Q,R,p,rank), A, tol=1.0d-8 )
   call msDisplay( rank, "Rank Revealing QR: rank with tol 1.0d-8" )
   call msQR( mfOut(Q,R,p,rank), A, tol=1.0d-4 )
   call msDisplay( rank, "Rank Revealing QR: rank with tol 1.0d-4" )

   ! QR without column pivoting
   print "(/,A)", "*** test number 43 ***"
   A = mf( reshape( [ (i,i=1,15) ], [ 5, 3 ] ) )
   call msDisplay(A,"A")
   call msQR( mfOut(Q,R), A )
   !call msDisplay(Q,"Q",R,"R")
   call check_small( mfNorm(mfMul(Q,R)-A),"|Q*R - A|",                  &
                     check_small_threshold )

   print "(/,A)", "*** test number 44 ***"
   A = mf( reshape( [ (i,i=1,15) ], [ 3, 5 ] ) )
   call msDisplay(A,"A")
   call msQR( mfOut(Q,R), A )
   !call msDisplay(Q,"Q",R,"R")
   call check_small( mfNorm(mfMul(Q,R)-A),"|Q*R - A|",                  &
                     check_small_threshold )

   print "(/,A)", "*** test number 45 ***"
   A = mf( reshape( [ 1, 7, 1, 2, 8, 2, 3, 9, 4, 3,                     &
                       5, 7, 2, 0, 9, 1, 2, 8, 2, 9 ],                  &
                    [ 5, 4 ] ) )
   call msDisplay(A,"A")
   call msQR( mfOut(Q,R), A )
   !call msDisplay(Q,"Q",R,"R")
   call check_small( mfNorm(mfMul(Q,R)-A),"|Q*R - A|",                  &
                     check_small_threshold )

   print "(/,A)", "*** test number 46 ***"
   A = mf( reshape( [ 1, 7, 1, 2, 8, 2, 3, 9, 4 ], [ 3, 3 ] ) )
   call msDisplay(A,"A")
   call msQR( mfOut(Q,R), A )
   !call msDisplay(Q,"Q",R,"R")
   call check_small( mfNorm(mfMul(Q,R)-A),"|Q*R - A|",                  &
                     check_small_threshold )

   print "(/,A)", "*** test number 47 ***"
   A = mfEye(5,5)*2.0d0 + MF_I*mfHilb(5)
   call msDisplay(A,"A")
   call msQR( mfOut(Q,R), A )
   !call msDisplay(Q,"Q",R,"R")
   call check_small( mfNorm(mfMul(Q,R)-A),"|Q*R - A|",                  &
                     check_small_threshold )

   print "(/,A)", "*** test number 48 ***"
   A = mf( reshape( [ (i,i=1,15) ], [ 5, 3 ] ) )
   A = A+ MF_I*mfEye(5,3)
   call msDisplay(A,"A")
   call msQR( mfOut(Q,R), A )
   !call msDisplay(Q,"Q",R,"R")
   call check_small( mfNorm(mfMul(Q,R)-A),"|Q*R - A|",                  &
                     check_small_threshold )

   print "(/,A)", "*** test number 49 ***"
   A = mf( reshape( [ (i,i=1,15) ], [ 3, 5 ] ) )
   A = A+ MF_I*mfEye(3,5)
   call msDisplay(A,"A")
   call msQR( mfOut(Q,R), A )
   !call msDisplay(Q,"Q",R,"R")
   call check_small( mfNorm(mfMul(Q,R)-A),"|Q*R - A|",                  &
                     check_small_threshold )

   ! mfQR --------------------------------------------------------------
   call print_separation("mfQR")

   ! special QR : vector real matrix -- row vector
   ! real case
   print "(/,A)", "*** test number 50 ***"
   A = mf( [ 1, 2, 3 ] )
   call msDisplay(A,"A")
   R = mfQR(A)
   call zeroes_small_values( R, check_small_threshold )
   call msDisplay(R,"R = mfQR(A)")

   ! special QR : vector real matrix -- column vector
   ! real case
   print "(/,A)", "*** test number 51 ***"
   A = .t. mf( [ 1, 2, 3 ] )
   call msDisplay(A,"A")
   R = mfQR(A)
   call zeroes_small_values( R, check_small_threshold )
   call msDisplay(R,"R = mfQR(A)")

   print "(/,A)", "*** test number 52 ***"
   A = mf( reshape( [ (i-10,i=1,20) ], [ 5, 4 ] ) )
   call msDisplay(A,"A")
   R = mfQR(A)
   call zeroes_small_values( R, check_small_threshold )
   call msDisplay(R,"R = mfQR(A)")

   print "(/,A)", "*** test number 53 ***"
   A = mf( reshape( [ (i-10,i=1,20) ], [ 4, 5 ] ) )
   call msDisplay(A,"A")
   R = mfQR(A)
   call zeroes_small_values( R, check_small_threshold )
   call msDisplay(R,"R = mfQR(A)")

   print "(/,A)", "*** test number 54 ***"
   A = mf( reshape( [ (i-10,i=1,20) ], [ 5, 4 ] ) )*(1.0d0+0.01d0*MF_I)
   call msDisplay(A,"A")
   R = mfQR(A)
   call zeroes_small_values( R, check_small_threshold )
   call msDisplay(R,"R = mfQR(A)")

   print "(/,A)", "*** test number 55 ***"
   A = mf( reshape( [ (i-10,i=1,20) ], [ 4, 5 ] ) )*(1.0d0+0.01d0*MF_I)
   call msDisplay(A,"A")
   R = mfQR(A)
   call zeroes_small_values( R, check_small_threshold )
   call msDisplay(R,"R = mfQR(A)")

   print "(/,A)", "*** test number 56 ***"
   A = mf( reshape( [ (i,i=1,15) ], [ 5, 3 ] ) )
   call msDisplay(A,"A")
   R = mfQR(A)
   call zeroes_small_values( R, check_small_threshold )
   call msDisplay(R,"R = mfQR(A)")

   print "(/,A)", "*** test number 57 ***"
   A = mf( reshape( [ (i,i=1,15) ], [ 3, 5 ] ) )
   call msDisplay(A,"A")
   R = mfQR(A)
   call zeroes_small_values( R, check_small_threshold )
   call msDisplay(R,"R = mfQR(A)")

   print "(/,A)", "*** test number 58 ***"
   A = mf( reshape( [ 1, 7, 1, 2, 8, 2, 3, 9, 4, 3,                     &
                       5, 7, 2, 0, 9, 1, 2, 8, 2, 9 ],                  &
                    [ 5, 4 ] ) )
   call msDisplay(A,"A")
   R = mfQR(A)
   call zeroes_small_values( R, check_small_threshold )
   call msDisplay(R,"R = mfQR(A)")

   print "(/,A)", "*** test number 59 ***"
   A = mf( reshape( [ 1, 7, 1, 2, 8, 2, 3, 9, 4 ], [ 3, 3 ] ) )
   call msDisplay(A,"A")
   R = mfQR(A)
   call zeroes_small_values( R, check_small_threshold )
   call msDisplay(R,"R = mfQR(A)")

   print "(/,A)", "*** test number 60 ***"
   A = mfEye(5,5)*2.0d0 + MF_I*mfHilb(5)
   call msDisplay(A,"A")
   R = mfQR(A)
   call zeroes_small_values( R, check_small_threshold )
   call msDisplay(R,"R = mfQR(A)")

   print "(/,A)", "*** test number 61 ***"
   A = mf( reshape( [ (i,i=1,15) ], [ 5, 3 ] ) )
   A = A+ MF_I*mfEye(5,3)
   call msDisplay(A,"A")
   R = mfQR(A)
   call zeroes_small_values( R, check_small_threshold )
   call msDisplay(R,"R = mfQR(A)")

   print "(/,A)", "*** test number 62 ***"
   A = mf( reshape( [ (i,i=1,15) ], [ 3, 5 ] ) )
   A = A+ MF_I*mfEye(3,5)
   call msDisplay(A,"A")
   R = mfQR(A)
   call zeroes_small_values( R, check_small_threshold )
   call msDisplay(R,"R = mfQR(A)")

   ! mfNorm ------------------------------------------------------------
   call print_separation("mfNorm")

   ! --- real case
   ! vector
   print "(/,A)", "*** test number 63 ***"
   x = mfEye(1,3)
   call msDisplay(x,"x")
   call msDisplay(mfNorm(x,1),"mfNorm(x,1)")
   call msDisplay(mfNorm(x,2),"mfNorm(x,2)")
   call msDisplay(mfNorm(x,"inf"),"mfNorm(x,'inf')")

   print "(/,A)", "*** test number 64 ***"
   x = mf( [ 1, 2, 3 ] )
   call msDisplay(x,"x")
   call msDisplay(mfNorm(x,1),"mfNorm(x,1)")
   call msDisplay(mfNorm(x,2),"mfNorm(x,2)")
   call msDisplay(mfNorm(x,"inf"),"mfNorm(x,'inf')")

   print "(/,A)", "*** test number 65 ***"
   x = mf( [ 1.0d0, 2.0d0, MF_INF ] )
   call msDisplay(x,"x")
   call msDisplay(mfNorm(x,1),"mfNorm(x,1)")
   call msDisplay(mfNorm(x,2),"mfNorm(x,2)")
   call msDisplay(mfNorm(x,"inf"),"mfNorm(x,'inf')")

   print "(/,A)", "*** test number 66 ***"
   call mf_save_and_disable_fpe( )
   x = mf( [ 1.0d0, 2.0d0, MF_NAN ] )
   call mf_restore_fpe( )
   call msDisplay(x,"x")
   call msDisplay(mfNorm(x,1),"mfNorm(x,1)")
   call msDisplay(mfNorm(x,2),"mfNorm(x,2)")
   call msDisplay(mfNorm(x,"inf"),"mfNorm(x,'inf')")

   ! matrix
   print "(/,A)", "*** test number 67 ***"
   A = mfZeros(3)
   call msDisplay(A,"A")
   call msDisplay(mfNorm(A,1),"mfNorm(A,1)")
   call msDisplay(mfNorm(A,2),"mfNorm(A,2)")
   call msDisplay(mfNorm(A,"inf"),"mfNorm(A,'inf')")
   call msDisplay(mfNorm(A,"fro"),"mfNorm(A,'fro')")

   print "(/,A)", "*** test number 68 ***"
   A = mfEye(3)
   call msDisplay(A,"A")
   call msDisplay(mfNorm(A,1),"mfNorm(A,1)")
   call msDisplay(mfNorm(A,2),"mfNorm(A,2)")
   call msDisplay(mfNorm(A,"inf"),"mfNorm(A,'inf')")
   call msDisplay(mfNorm(A,"fro"),"mfNorm(A,'fro')")

   print "(/,A)", "*** test number 69 ***"
   A = mf( reshape( [ 1, 7, 1, 2, 8, 2, 3, 9, 4 ], [ 3, 3 ] ) )
   call msDisplay(A,"A")
   call msDisplay(mfNorm(A,1),"mfNorm(A,1)")
   call msDisplay(mfNorm(A,2),"mfNorm(A,2)")
   call msDisplay(mfNorm(A,"inf"),"mfNorm(A,'inf')")
   call msDisplay(mfNorm(A,"fro"),"mfNorm(A,'fro')")

   ! non-square matrix
   print "(/,A)", "*** test number 70 ***"
   A = mf( reshape( [ 4, 1, 3, 7, 6, 0, 2, 8, 2, 3, 9, 4 ],             &
                    [ 3, 4 ] ) )
   call msDisplay(A,"A")
   call msDisplay(mfNorm(A,1),"mfNorm(A,1)")
   call msDisplay(mfNorm(A,2),"mfNorm(A,2)")
   call msDisplay(mfNorm(A,"inf"),"mfNorm(A,'inf')")
   call msDisplay(mfNorm(A,"fro"),"mfNorm(A,'fro')")

   print "(/,A)", "*** test number 71 ***"
   A = mf( reshape( [ 1.0d0, 2.0d0, MF_INF, 3.0d0, 4.0d0, 0.0d0 ],      &
                    [ 2, 3 ] ) )
   call msDisplay(A,"A")
   call msDisplay(mfNorm(A,1),"mfNorm(A,1)")
   call msDisplay(mfNorm(A,"inf"),"mfNorm(A,'inf')")
   call msDisplay(mfNorm(A,"fro"),"mfNorm(A,'fro')")

   print "(/,A)", "*** test number 72 ***"
   call mf_save_and_disable_fpe( )
   A = mf( reshape( [ 1.0d0, 2.0d0, MF_NAN, 3.0d0, 4.0d0, 0.0d0 ],      &
                    [ 2, 3 ] ) )
   call mf_restore_fpe( )
   call msDisplay(A,"A")
   call msDisplay(mfNorm(A,1),"mfNorm(A,1)")
   call msDisplay(mfNorm(A,"inf"),"mfNorm(A,'inf')")
   call msDisplay(mfNorm(A,"fro"),"mfNorm(A,'fro')")

   ! --- complex case
   ! vector
   print "(/,A)", "*** test number 73 ***"
   x = mfEye(1,3)*MF_I
   call msDisplay(x,"x")
   call msDisplay(mfNorm(x,1),"mfNorm(x,1)")
   call msDisplay(mfNorm(x,2),"mfNorm(x,2)")
   call msDisplay(mfNorm(x,"inf"),"mfNorm(x,'inf')")

   print "(/,A)", "*** test number 74 ***"
   x = mf( [ 1, 2, 3 ] )*MF_I
   call msDisplay(x,"x")
   call msDisplay(mfNorm(x,1),"mfNorm(x,1)")
   call msDisplay(mfNorm(x,2),"mfNorm(x,2)")
   call msDisplay(mfNorm(x,"inf"),"mfNorm(x,'inf')")

   print "(/,A)", "*** test number 75 ***"
   x = mf( [ (0.0d0, 1.0d0), (0.0d0, 2.0d0), cmplx(0.0, MF_INF,kind=MF_DOUBLE) ] )
   call msDisplay(x,"x")
   call msDisplay(mfNorm(x,1),"mfNorm(x,1)")
   call msDisplay(mfNorm(x,2),"mfNorm(x,2)")
   call msDisplay(mfNorm(x,"inf"),"mfNorm(x,'inf')")

   print "(/,A)", "*** test number 76 ***"
   call mf_save_and_disable_fpe( )
   x = mf( [ (0.0d0, 1.0d0), (0.0d0, 2.0d0), cmplx(0.0, MF_NAN,kind=MF_DOUBLE) ] )
   call mf_restore_fpe( )
   call msDisplay(x,"x")
   call msDisplay(mfNorm(x,1),"mfNorm(x,1)")
   call msDisplay(mfNorm(x,2),"mfNorm(x,2)")
   call msDisplay(mfNorm(x,"inf"),"mfNorm(x,'inf')")

   ! matrix
   print "(/,A)", "*** test number 77 ***"
   A = mfHilb(3)*MF_I
   call msDisplay(A,"A")
   call msDisplay(mfNorm(A,1),"mfNorm(A,1)")
   call msDisplay(mfNorm(A,2),"mfNorm(A,2)")
   call msDisplay(mfNorm(A,"inf"),"mfNorm(A,'inf')")
   call msDisplay(mfNorm(A,"fro"),"mfNorm(A,'fro')")

   print "(/,A)", "*** test number 78 ***"
   A = mfEye(3)*MF_I
   call msDisplay(A,"A")
   call msDisplay(mfNorm(A,1),"mfNorm(A,1)")
   call msDisplay(mfNorm(A,2),"mfNorm(A,2)")
   call msDisplay(mfNorm(A,"inf"),"mfNorm(A,'inf')")
   call msDisplay(mfNorm(A,"fro"),"mfNorm(A,'fro')")

   print "(/,A)", "*** test number 79 ***"
   A = mf( reshape( [ 1, 7, 1, 2, 8, 2, 3, 9, 4 ], [ 3, 3 ] ) )
   A = A + mf( reshape( [ 8, 2, 3, 9, 4, 1, 7, 1, 2 ], [ 3, 3 ] ) )*MF_I
   call msDisplay(A,"A")
   call msDisplay(mfNorm(A,1),"mfNorm(A,1)")
   call msDisplay(mfNorm(A,2),"mfNorm(A,2)")
   call msDisplay(mfNorm(A,"inf"),"mfNorm(A,'inf')")
   call msDisplay(mfNorm(A,"fro"),"mfNorm(A,'fro')")

   ! non-square matrix
   print "(/,A)", "*** test number 80 ***"
   A = mf( reshape( [ 4, 1, 3, 7, 6, 0, 2, 8, 2, 3, 9, 4 ],             &
                    [ 3, 4 ] ) )
   A = A + mf( reshape( [ 2, 3, 9, 4, 4, 1, 3, 7, 6, 0, 2, 8 ],         &
                    [ 3, 4 ] ) )*MF_I
   call msDisplay(A,"A")
   call msDisplay(mfNorm(A,1),"mfNorm(A,1)")
   call msDisplay(mfNorm(A,2),"mfNorm(A,2)")
   call msDisplay(mfNorm(A,"inf"),"mfNorm(A,'inf')")
   call msDisplay(mfNorm(A,"fro"),"mfNorm(A,'fro')")

   print "(/,A)", "*** test number 81 ***"
   A = mf( reshape( [ (0.0d0, 1.0d0), (0.0d0, 2.0d0), cmplx(0.0, MF_INF,kind=MF_DOUBLE), &
                       (0.0d0, 3.0d0), (0.0d0, 4.0d0), (0.0d0, 0.0d0) ], &
                    [ 2, 3 ] ) )
   call msDisplay(A,"A")
   call msDisplay(mfNorm(A,1),"mfNorm(A,1)")
   call msDisplay(mfNorm(A,"inf"),"mfNorm(A,'inf')")
   call msDisplay(mfNorm(A,"fro"),"mfNorm(A,'fro')")

   print "(/,A)", "*** test number 82 ***"
   call mf_save_and_disable_fpe( )
   A = mf( reshape( [ (0.0d0, 1.0d0), (0.0d0, 2.0d0), cmplx(0.0, MF_NAN,kind=MF_DOUBLE), &
                       (0.0d0, 3.0d0), (0.0d0, 4.0d0), (0.0d0, 0.0d0) ], &
                    [ 2, 3 ] ) )
   call mf_restore_fpe( )
   call msDisplay(A,"A")
   call msDisplay(mfNorm(A,1),"mfNorm(A,1)")
   call msDisplay(mfNorm(A,"inf"),"mfNorm(A,'inf')")
   call msDisplay(mfNorm(A,"fro"),"mfNorm(A,'fro')")

   ! mfRcond, mfCond ---------------------------------------------------
   call print_separation("mfRcond, mfCond")

   print "(/,A)", "*** test number 83 ***"
   A = mfZeros(3)
   call msDisplay(A,"A",mfRcond(A),"mfRcond(A)")
   ! cond(A) should be Inf
   print *, "Is mfCond(A) > 1.0d0/MF_EPS?"
   call msDisplay( mfCond(A) > 1.0d0/MF_EPS, "ans" )

   print "(/,A)", "*** test number 84 ***"
   A = mfEye(3)
   call msDisplay(A,"A",mfRcond(A),"mfRcond(A)",mfCond(A),"mfCond(A)")

   print "(/,A)", "*** test number 85 ***"
   A = mfOnes(3)
   call msDisplay(A,"A",mfRcond(A),"mfRcond(A)")
   ! cond(A) should be Inf
   print *, "Is mfCond(A) > 1.0d0/MF_EPS?"
   call msDisplay( mfCond(A) > 1.0d0/MF_EPS, "ans" )

   ! a Hilbert matrix is a famous example of badly conditionned matrix
   print "(/,A)", "*** test number 86 ***"
   A = mfHilb(5)
   call msDisplay(A,"A = Hilbert(5)")
   call msDisplay(mfRcond(A),"mfRcond(A)",mfCond(A),"mfCond(A)")

   print "(/,A)", "*** test number 87 ***"
   A = mfHilb(10)
   call msDisplay(mfRcond(A),"mfRcond( Hilbert(10) )",mfCond(A),"mfCond( Hilbert(10) )")

   print "(/,A)", "*** test number 88 ***"
   A = mfZeros(3)*MF_I
   call msDisplay(A,"A",mfRcond(A),"mfRcond(A)",mfCond(A),"mfCond(A)")

   print "(/,A)", "*** test number 89 ***"
   A = mfEye(3)*MF_I
   call msDisplay(A,"A",mfRcond(A),"mfRcond(A)",mfCond(A),"mfCond(A)")

   print "(/,A)", "*** test number 90 ***"
   A = mfHilb(3)*MF_I
   call msDisplay(A,"A",mfRcond(A),"mfRcond(A)",mfCond(A),"mfCond(A)")

   ! non square matrix
   print "(/,A)", "*** test number 91 ***"
   A = mfHilb(4) .hc. mfInvHilb(4)*0.001d0
   call msDisplay(A,"A",mfRcond(A),"mfRcond(A)",mfCond(A),"mfCond(A)")

   print "(/,A)", "*** test number 92 ***"
   A = mfHilb(4) .vc. mfInvHilb(4)*0.001d0
   call msDisplay(A,"A",mfRcond(A),"mfRcond(A)",mfCond(A),"mfCond(A)")

   ! msSvd -------------------------------------------------------------
   call print_separation("msSvd")

   ! real matrices
   print "(/,A)", "*** test number 93 ***"
   A = mf( reshape( [ 10, 7, 5, 20, 8, 15, 30, 9, 25 ], [ 3, 3 ] ) )
   call msDisplay(A,"A")
   call msSvd( mfOut(U,S,V), A )
   !call msDisplay(U,"U",V,"V")
   call msDisplay(S,"S")
   call check_small( mfNorm(A-mfMul(U,mfMul(S,.t. V))),"|A-U*S*V'|",    &
                     check_small_threshold )

   print "(/,A)", "*** test number 94 ***"
   A = .t. mf( reshape( [ (i,i=1,9) ], [ 3, 3 ] ) )
   call msDisplay(A,"A")
   call msSvd( mfOut(U,S,V), A )
   !call msDisplay(U,"U",V,"V")
   call msDisplay(S,"S")
   call check_small( mfNorm(A-mfMul(U,mfMul(S,.t. V))),"|A-U*S*V'|",    &
                     check_small_threshold )

   print "(/,A)", "*** test number 95 ***"
   A = mfHilb(3)
   call msDisplay(A,"A")
   call msSvd( mfOut(U,S,V), A )
   !call msDisplay(U,"U",V,"V")
   call msDisplay(S,"S")
   call check_small( mfNorm(A-mfMul(U,mfMul(S,.t. V))),"|A-U*S*V'|",    &
                     check_small_threshold )

   ! non-square real : m > n
   print "(/,A)", "*** test number 96 ***"
   A = mf( reshape( [ (i,i=1,15) ], [ 5, 3 ] ) )
   call msDisplay(A,"A")
   call msSvd( mfOut(U,S,V), A )
   !call msDisplay(U,"U",V,"V")
   call msDisplay(S,"S")
   call check_small( mfNorm(A-mfMul(U,mfMul(S,.t. V))),"|A-U*S*V'|",    &
                     check_small_threshold )

   ! non-square real : m > n
   print "(/,A)", "*** test number 97 ***"
   A = mf( reshape( [ (i,i=1,15) ], [ 5, 3 ] ) )
   call msDisplay(A,"A")
   call msSvd( mfOut(U,S,V), A, economy_size=.true. )
   !call msDisplay(U,"U",V,"V")
   call msDisplay(S,"S")
   call check_small( mfNorm(A-mfMul(U,mfMul(S,.t. V))),"|A-U*S*V'|",    &
                     check_small_threshold )

   ! non-square real : m < n
   print "(/,A)", "*** test number 98 ***"
   A = mf( reshape( [ (i,i=1,15) ], [ 3, 5 ] ) )
   call msDisplay(A,"A")
   call msSvd( mfOut(U,S,V), A )
   !call msDisplay(U,"U",V,"V")
   call msDisplay(S,"S")
   call check_small( mfNorm(A-mfMul(U,mfMul(S,.t. V))),"|A-U*S*V'|",    &
                     check_small_threshold )

   ! non-square real : m < n
   print "(/,A)", "*** test number 99 ***"
   A = mf( reshape( [ (i,i=1,15) ], [ 3, 5 ] ) )
   call msDisplay(A,"A")
   call msSvd( mfOut(U,S,V), A, economy_size=.true. )
   !call msDisplay(U,"U",V,"V")
   call msDisplay(S,"S")
   call check_small( mfNorm(A-mfMul(U,mfMul(S,.t. V))),"|A-U*S*V'|",    &
                     check_small_threshold )

   ! complex matrices
   print "(/,A)", "*** test number 100 ***"
   A = mf( reshape( [ 10, 7, 5, 20, 8, 15, 30, 9, 25 ], [ 3, 3 ] ) )
   A = A*MF_I
   call msDisplay(A,"A")
   call msSvd( mfOut(U,S,V), A )
   !call msDisplay(U,"U",V,"V")
   call msDisplay(S,"S")
   call check_small( mfNorm(A-mfMul(U,mfMul(S,.h. V))),"|A-U*S*V'|",    &
                     check_small_threshold )

   print "(/,A)", "*** test number 101 ***"
   A = .t. mf( reshape( [ (i,i=1,9) ], [ 3, 3 ] ) )
   A = A*MF_I
   call msDisplay(A,"A")
   call msSvd( mfOut(U,S,V), A )
   !call msDisplay(U,"U",V,"V")
   call msDisplay(S,"S")
   call check_small( mfNorm(A-mfMul(U,mfMul(S,.h. V))),"|A-U*S*V'|",    &
                     check_small_threshold )

   print "(/,A)", "*** test number 102 ***"
   A = mfEye(3) + MF_I*mfHilb(3)
   call msDisplay(A,"A")
   call msSvd( mfOut(U,S,V), A )
   !call msDisplay(U,"U",V,"V")
   call msDisplay(S,"S")
   call check_small( mfNorm(A-mfMul(U,mfMul(S,.h. V))),"|A-U*S*V'|",    &
                     check_small_threshold )

   ! non-square complex : m > n
   print "(/,A)", "*** test number 103 ***"
   A = mf( reshape( [ (i,i=1,15) ], [ 5, 3 ] ) ) + MF_I*mfOnes(5,3)
   call msDisplay(A,"A")
   call msSvd( mfOut(U,S,V), A )
   !call msDisplay(U,"U",V,"V")
   call msDisplay(S,"S")
   call check_small( mfNorm(A-mfMul(U,mfMul(S,.h. V))),"|A-U*S*V'|",    &
                     check_small_threshold )

   ! non-square complex : m > n
   print "(/,A)", "*** test number 104 ***"
   A = mf( reshape( [ (i,i=1,15) ], [ 5, 3 ] ) ) + MF_I*mfOnes(5,3)
   call msDisplay(A,"A")
   call msSvd( mfOut(U,S,V), A, economy_size=.true. )
   !call msDisplay(U,"U",V,"V")
   call msDisplay(S,"S")
   call check_small( mfNorm(A-mfMul(U,mfMul(S,.h. V))),"|A-U*S*V'|",    &
                     check_small_threshold )

   ! non-square complex : m < n
   print "(/,A)", "*** test number 105 ***"
   A = mf( reshape( [ (i,i=1,15) ], [ 3, 5 ] ) ) + MF_I*mfOnes(3,5)
   call msDisplay(A,"A")
   call msSvd( mfOut(U,S,V), A )
   !call msDisplay(U,"U",V,"V")
   call msDisplay(S,"S")
   call check_small( mfNorm(A-mfMul(U,mfMul(S,.h. V))),"|A-U*S*V'|",    &
                     check_small_threshold )

   ! non-square complex : m < n
   print "(/,A)", "*** test number 106 ***"
   A = mf( reshape( [ (i,i=1,15) ], [ 3, 5 ] ) ) + MF_I*mfOnes(3,5)
   call msDisplay(A,"A")
   call msSvd( mfOut(U,S,V), A, economy_size=.true. )
   !call msDisplay(U,"U",V,"V")
   call msDisplay(S,"S")
   call check_small( mfNorm(A-mfMul(U,mfMul(S,.h. V))),"|A-U*S*V'|",    &
                     check_small_threshold )

   ! mfSvd -------------------------------------------------------------
   call print_separation("mfSvd")

   ! real matrices
   print "(/,A)", "*** test number 107 ***"
   A = mf( reshape( [ 10, 7, 5, 20, 8, 15, 30, 9, 25 ], [ 3, 3 ] ) )
   call msDisplay(A,"A")
   call msDisplay(mfSvd( A ),"S")

   print "(/,A)", "*** test number 108 ***"
   A = .t. mf( reshape( [ (i,i=1,9) ], [ 3, 3 ] ) )
   call msDisplay(A,"A")
   call msDisplay(mfSvd( A ),"S")

   print "(/,A)", "*** test number 109 ***"
   A = mfHilb(3)
   call msDisplay(A,"A")
   call msDisplay(mfSvd( A ),"S")

   print "(/,A)", "*** test number 110 ***"
   A = mf( reshape( [ 10, 7, 5, 20, 8, 15, 30, 9, 25 ], [ 3, 3 ] ) )
   A = A*MF_I
   call msDisplay(A,"A")
   call msDisplay(mfSvd( A ),"S")

   ! non-square real : m > n
   print "(/,A)", "*** test number 111 ***"
   A = mf( reshape( [ (i,i=1,15) ], [ 5, 3 ] ) )
   call msDisplay(A,"A")
   call msDisplay(mfSvd( A ),"S")

   ! non-square real : m < n
   print "(/,A)", "*** test number 112 ***"
   A = mf( reshape( [ (i,i=1,15) ], [ 3, 5 ] ) )
   call msDisplay(A,"A")
   call msDisplay(mfSvd( A ),"S")

   ! complex matrices
   print "(/,A)", "*** test number 113 ***"
   A = .t. mf( reshape( [ (i,i=1,9) ], [ 3, 3 ] ) )
   A = A*MF_I
   call msDisplay(A,"A")
   call msDisplay(mfSvd( A ),"S")

   print "(/,A)", "*** test number 114 ***"
   A = mfEye(3) + MF_I*mfHilb(3)
   call msDisplay(A,"A")
   call msDisplay(mfSvd( A ),"S")

   ! non-square complex : m > n
   print "(/,A)", "*** test number 115 ***"
   A = mf( reshape( [ (i,i=1,15) ], [ 5, 3 ] ) ) + MF_I*mfOnes(5,3)
   call msDisplay(A,"A")
   call msDisplay(mfSvd( A ),"S")

   ! non-square complex : m < n
   print "(/,A)", "*** test number 116 ***"
   A = mf( reshape( [ (i,i=1,15) ], [ 3, 5 ] ) ) + MF_I*mfOnes(3,5)
   call msDisplay(A,"A")
   call msDisplay(mfSvd( A ),"S")

   ! mfSVDS ------------------------------------------------------------
   call print_separation("mfSVDS")

   n = 9

   ! real square matrices
   print "(/,A)", "*** test number 117 ***"
   A = mfMagic(n)
   call msDisplay(A,"A")
   call msSvd( mfOut(U,S,V), A )
   call msDisplay( .t. mfDiag(S),"(all singular values from msSvd) S")
   S = mfSVDS( A, 2 )
   call msDisplay( S,"(largest singular values from ARPACK) S")
   S = mfSVDS( A, 2, "SM" )
   call msDisplay( S,"(smallest singular values from ARPACK) S")

   ! non-square real : m > n
   print "(/,A)", "*** test number 118 ***"
   A = mf( reshape( [ (i,i=1,30) ], [ 6, 5 ] ) ) + 100.0d0*mfEye(6,5)
   call msDisplay(A,"A")
   call msSvd( mfOut(U,S,V), A )
   call msDisplay( .t. mfDiag(S),"(all singular values from msSvd) S")
   S = mfSVDS( A, 2 )
   call msDisplay( S,"(largest singular values from ARPACK) S")
   S = mfSVDS( A, 2, "SM" )
   call msDisplay( S,"(smallest singular values from ARPACK) S")

   ! non-square real : m < n
   print "(/,A)", "*** test number 119 ***"
   A = mf( reshape( [ (i,i=1,30) ], [ 5, 6 ] ) ) + 100.0d0*mfEye(5,6)
   call msDisplay(A,"A")
   call msSvd( mfOut(U,S,V), A )
   call msDisplay( .t. mfDiag(S),"(all singular values from msSvd) S")
   S = mfSVDS( A, 2 )
   call msDisplay( S,"(largest singular values from ARPACK) S")
   S = mfSVDS( A, 2, "SM" )
   call msDisplay( S,"(smallest singular values from ARPACK) S")

   ! complex square matrices
   print "(/,A)", "*** test number 120 ***"
   A = mfMagic(n)*MF_I + dble(n)*mfEye(n)
   call msDisplay(A,"A")
   call msSvd( mfOut(U,S,V), A )
   call msDisplay( .t. mfDiag(S),"(all singular values from msSvd) S")
   S = mfSVDS( A, 2 )
   call msDisplay( S,"(largest singular values from ARPACK) S")
   S = mfSVDS( A, 2, "SM" )
   call msDisplay( S,"(smallest singular values from ARPACK) S")

   ! non-square complex : m > n
   print "(/,A)", "*** test number 121 ***"
   A = mf( reshape( [ (i,i=1,30) ], [ 6, 5 ] ) )*MF_I + 100.0d0*mfEye(6,5)
   call msDisplay(A,"A")
   call msSvd( mfOut(U,S,V), A )
   call msDisplay( .t. mfDiag(S),"(all singular values from msSvd) S")
   S = mfSVDS( A, 2 )
   call msDisplay( S,"(largest singular values from ARPACK) S")
   S = mfSVDS( A, 2, "SM" )
   call msDisplay( S,"(smallest singular values from ARPACK) S")

   ! non-square complex : m < n
   print "(/,A)", "*** test number 122 ***"
   A = mf( reshape( [ (i,i=1,30) ], [ 5, 6 ] ) )*MF_I + 100.0d0*mfEye(5,6)
   call msDisplay(A,"A")
   call msSvd( mfOut(U,S,V), A )
   call msDisplay( .t. mfDiag(S),"(all singular values from msSvd) S")
   S = mfSVDS( A, 2 )
   call msDisplay( S,"(largest singular values from ARPACK) S")
   S = mfSVDS( A, 2, "SM" )
   call msDisplay( S,"(smallest singular values from ARPACK) S")

   ! msSVDS ------------------------------------------------------------
   call print_separation("msSVDS")

   n = 9

   ! real matrices
   print "(/,A)", "*** test number 123 ***"
   A = mfMagic(n)
   call msDisplay(A,"A")
   D = mfSvd( A )
   call msDisplay( D, "(all singular values from mfSvd) S" )
   call msSVDS( mfOut(S,flag), A, 2 )
   call msDisplay( S,"(largest singular values from ARPACK) S")
   call msDisplay(flag, "All requested singular values converged?")
   call msSVDS( mfOut(S,flag), A, 2, "SM" )
   call msDisplay( S,"(smallest singular values from ARPACK) S")
   call msDisplay(flag, "All requested singular values converged?")
   call msSVDS( mfOut(S,flag), A, 2, "BE" )
   call msDisplay( S,"(both-end singular values from ARPACK) S")
   call msDisplay(flag, "All requested singular values converged?")

   ! non-square real : m > n
   print "(/,A)", "*** test number 124 ***"
   A = mf( reshape( [ (i,i=1,30) ], [ 6, 5 ] ) ) + 100.0d0*mfEye(6,5)
   call msDisplay(A,"A")
   call msSvd( mfOut(U,S,V), A )
   call msDisplay( .t. mfDiag(S),"(all singular values from msSvd) S")
   call msSVDS( mfOut(S,flag), A, 2 )
   call msDisplay( S,"(largest singular values from ARPACK) S")
   call msDisplay(flag, "All requested singular values converged?")
   call msSVDS( mfOut(S,flag), A, 2, "SM" )
   call msDisplay( S,"(smallest singular values from ARPACK) S")
   call msDisplay(flag, "All requested singular values converged?")
   call msSVDS( mfOut(S,flag), A, 2, "BE" )
   call msDisplay( S,"(both-end singular values from ARPACK) S")
   call msDisplay(flag, "All requested singular values converged?")

   ! non-square real : m < n
   print "(/,A)", "*** test number 125 ***"
   A = mf( reshape( [ (i,i=1,30) ], [ 5, 6 ] ) ) + 100.0d0*mfEye(5,6)
   call msDisplay(A,"A")
   call msSvd( mfOut(U,S,V), A )
   call msDisplay( .t. mfDiag(S),"(all singular values from msSvd) S")
   call msSVDS( mfOut(S,flag), A, 2 )
   call msDisplay( S,"(largest singular values from ARPACK) S")
   call msDisplay(flag, "All requested singular values converged?")
   call msSVDS( mfOut(S,flag), A, 2, "SM" )
   call msDisplay( S,"(smallest singular values from ARPACK) S")
   call msDisplay(flag, "All requested singular values converged?")
   call msSVDS( mfOut(S,flag), A, 2, "BE" )
   call msDisplay( S,"(both-end singular values from ARPACK) S")
   call msDisplay(flag, "All requested singular values converged?")

   ! complex matrices
   print "(/,A)", "*** test number 126 ***"
   A = mfMagic(n)*MF_I + dble(n)*mfEye(n)
   call msDisplay(A,"A")
   call msSvd( mfOut(U,S,V), A )
   call msDisplay( .t. mfDiag(S),"(all singular values from msSvd) S")
   call msSVDS( mfOut(S,flag), A, 2 )
   call msDisplay( S,"(largest singular values from ARPACK) S")
   call msDisplay(flag, "All requested singular values converged?")
   call msSVDS( mfOut(S,flag), A, 2, "SM" )
   call msDisplay( S,"(smallest singular values from ARPACK) S")
   call msDisplay(flag, "All requested singular values converged?")

   ! non-square complex : m > n
   print "(/,A)", "*** test number 127 ***"
   A = mf( reshape( [ (i,i=1,30) ], [ 6, 5 ] ) )*MF_I + 100.0d0*mfEye(6,5)
   call msDisplay(A,"A")
   call msSvd( mfOut(U,S,V), A )
   call msDisplay( .t. mfDiag(S),"(all singular values from msSvd) S")
   call msSVDS( mfOut(S,flag), A, 2 )
   call msDisplay( S,"(largest singular values from ARPACK) S")
   call msDisplay(flag, "All requested singular values converged?")
   call msSVDS( mfOut(S,flag), A, 2, "SM" )
   call msDisplay( S,"(smallest singular values from ARPACK) S")
   call msDisplay(flag, "All requested singular values converged?")

   ! non-square complex : m < n
   print "(/,A)", "*** test number 128 ***"
   A = mf( reshape( [ (i,i=1,30) ], [ 5, 6 ] ) )*MF_I + 100.0d0*mfEye(5,6)
   call msDisplay(A,"A")
   call msSvd( mfOut(U,S,V), A )
   call msDisplay( .t. mfDiag(S),"(all singular values from msSvd) S")
   call msSVDS( mfOut(S,flag), A, 2 )
   call msDisplay( S,"(largest singular values from ARPACK) S")
   call msDisplay(flag, "All requested singular values converged?")
   call msSVDS( mfOut(S,flag), A, 2, "SM" )
   call msDisplay( S,"(smallest singular values from ARPACK) S")
   call msDisplay(flag, "All requested singular values converged?")

   ! mfRank ------------------------------------------------------------
   call print_separation("mfRank")

   print "(/,A)", "*** test number 129 ***"
   A = .t. mf( reshape( [ (i,i=1,9) ], [ 3, 3 ] ) )
   call msDisplay(A,"A")
   call msDisplay(mfRank(a),"mfRank(a)")

   print "(/,A)", "*** test number 130 ***"
   A = mfOnes(3)
   call msDisplay(A,"A",mfRank(a),"mfRank(a)")

   print "(/,A)", "*** test number 131 ***"
   A = .t. mf( reshape( [ (i,i=1,9) ], [ 3, 3 ] ) )
   A = A*MF_I
   call msDisplay(A,"A")
   call msDisplay(mfRank(a),"mfRank(a)")

   print "(/,A)", "*** test number 132 ***"
   A = mfHilb(3)*MF_I
   call msDisplay(A,"A",mfRank(a),"mfRank(a)")

   ! rectangular matrices
   print "(/,A)", "*** test number 133 ***"
   A = mf( reshape( [ (i,i=1,15) ], [ 3, 5 ] ) )
   call msDisplay(A,"A")
   call msDisplay(mfRank(a),"mfRank(A)")

   ! rectangular matrices
   print "(/,A)", "*** test number 134 ***"
   A = mf( reshape( [ (i,i=1,15) ], [ 5, 3 ] ) )
   call msDisplay(A,"A")
   call msDisplay(mfRank(a),"mfRank(A)")

   ! mfInv -------------------------------------------------------------
   call print_separation("mfInv")

   print "(/,A)", "*** test number 135 ***"
   A = mfHilb(3)
   call msDisplay(A,"A")
   AI = mfInv(A)
   call msDisplay(AI,"AI = mfInv(A)")
   B = mfMul(A,AI)-mfEye(3)
   call check_small( mfNorm(B),"|A*AI - I|", check_small_threshold )

   print "(/,A)", "*** test number 136 ***"
   A = .t. mf( reshape( [ (i,i=1,9) ], [ 3, 3 ] ) )
   call msDisplay(A,"A")
   AI = mfInv(A)                       ! A is not inversible
   call msDisplay(AI,"AI = mfInv(A)")

   print "(/,A)", "*** test number 137 ***"
   A = mf( reshape( [ (10.*(i-5)+MF_I**i,i=1,9) ], [ 3, 3 ] ) )
   call msDisplay(A,"A")
   AI = mfInv(A)
   call zeroes_small_values( AI, check_small_threshold )
   call msDisplay(AI,"AI = mfInv(A)")
   B = mfMul(A,AI)-mfEye(3)
   call check_small( mfNorm(B),"|A*AI - I|", check_small_threshold )

   ! mfPseudoInv -------------------------------------------------------
   call print_separation("mfPseudoInv")

   print "(/,A)", "*** test number 138 ***"
   A = mf( [ 0.9839, 0.9100, 0.5480 ] ) .vc.                            &
       mf( [ 0.7000, 0.3045, 0.6138 ] ) .vc.                            &
       mf( [ 0.2753, 0.4843, 0.9714 ] ) .vc.                            &
       mf( [ 0.6611, 0.9854, 0.8819 ] ) .vc.                            &
       mf( [ 0.8098, 0.3471, 0.1290 ] )
   call msDisplay(A,"A")
   AI = mfPseudoInv(A)
   call msDisplay(AI,"AI = mfPseudoInv(A)")
   B = mfMul(mfMul(A,AI),A) - A
   call check_small( mfNorm(B),"|A*AI*A - A|", check_small_threshold )
   B = mfMul(mfMul(AI,A),AI) - AI
   call check_small( mfNorm(B),"|AI*A*AI - AI|", check_small_threshold )

   print "(/,A)", "*** test number 139 ***"
   A = mfRand(3,5) + MF_I*mfRand(3,5)
   A = mf( [ 0.9839, 0.6611, 0.3045, 0.3471, 0.0899 ] ) .vc.            &
       mf( [ 0.7000, 0.8098, 0.4843, 0.5480, 0.8883 ] ) .vc.            &
       mf( [ 0.2753, 0.9100, 0.9854, 0.6138, 0.7010 ] ) + MF_I*         &
       mf( [ 0.9294, 0.0711, 0.6357, 0.7860, 0.9506 ] ) .vc.            &
       mf( [ 0.7634, 0.4041, 0.8792, 0.2313, 0.6212 ] ) .vc.            &
       mf( [ 0.5338, 0.7307, 0.6890, 0.2380, 0.5282 ] )
   call msDisplay(A,"A")
   AI = mfPseudoInv(A)
   call msDisplay(AI,"AI = mfPseudoInv(A)")
   B = mfMul(mfMul(A,AI),A) - A
   call check_small( mfNorm(B),"|A*AI*A - A|", check_small_threshold )
   B = mfMul(mfMul(AI,A),AI) - AI
   call check_small( mfNorm(B),"|AI*A*AI - AI|", check_small_threshold )

   ! mfLDiv ------------------------------------------------------------
   call print_separation("mfLDiv")

   ! real diagonal matrix
   print "(/,A)", "*** test number 140 ***"
   A = mfEye(4)*2.0d0
   call msDisplay(A,"A")
   b = mfOnes(4,1)
   call msDisplay(b,"b")
   x = mfLDiv(A,b)
   call msDisplay(x,"x")
   if( mfIsNotEqual(x,MF_EMPTY) ) then
      call check_small( mfNorm(mfMul(A,x)-b), "residu |A*x-b|",         &
                        check_small_threshold )
   end if

   ! complexe/real diagonal system
   print "(/,A)", "*** test number 141 ***"
   A = mfEye(4)*MF_I
   call msDisplay(A,"A")
   b = mfOnes(4,1)
   call msDisplay(b,"b")
   x = mfLDiv(A,b)
   call msDisplay(x,"x")
   if( mfIsNotEqual(x,MF_EMPTY) ) then
      call check_small( mfNorm(mfMul(A,x)-b), "residu |A*x-b|",         &
                        check_small_threshold )
   end if

   ! real/complexe diagonal system
   print "(/,A)", "*** test number 142 ***"
   A = mfEye(4)
   call msDisplay(A,"A")
   b = mfOnes(4,1)*MF_I
   call msDisplay(b,"b")
   x = mfLDiv(A,b)
   call msDisplay(x,"x")
   if( mfIsNotEqual(x,MF_EMPTY) ) then
      call check_small( mfNorm(mfMul(A,x)-b), "residu |A*x-b|",         &
                        check_small_threshold )
   end if

   ! complexe/complexe diagonal system
   print "(/,A)", "*** test number 143 ***"
   A = mfEye(4)*MF_I
   call msDisplay(A,"A")
   b = mfOnes(4,1)*MF_I
   call msDisplay(b,"b")
   x = mfLDiv(A,b)
   call msDisplay(x,"x")
   if( mfIsNotEqual(x,MF_EMPTY) ) then
      call check_small( mfNorm(mfMul(A,x)-b), "residu |A*x-b|",         &
                        check_small_threshold )
   end if

   ! upper triangular matrix
   print "(/,A)", "*** test number 144 ***"
   A = mfHilb(4)
   A = mfTriu(A)
   call msDisplay(A,"A")
   b = mfOnes(4,1)
   call msDisplay(b,"b")
   x = mfLDiv(A,b)
   call msDisplay(x,"x")
   if( mfIsNotEqual(x,MF_EMPTY) ) then
      call check_small( mfNorm(mfMul(A,x)-b), "residu |A*x-b|",         &
                        check_small_threshold )
   end if

   ! lower triangular matrix
   print "(/,A)", "*** test number 145 ***"
   A = mfHilb(4)
   A = mfTril(A)
   call msDisplay(A,"A")
   b = mfOnes(4,1)
   call msDisplay(b,"b")
   x = mfLDiv(A,b)
   call msDisplay(x,"x")
   if( mfIsNotEqual(x,MF_EMPTY) ) then
      call check_small( mfNorm(mfMul(A,x)-b), "residu |A*x-b|",         &
                        check_small_threshold )
   end if

   ! symmetric indefinite matrix
   ! real case
   print "(/,A)", "*** test number 146 ***"
   a = mfHilb(4)
   call msSet( -1.0d0, A, 1, 1 )
   call msDisplay(a,"A")
   bool = mfIsSymm(A)
   if( bool ) then
      print *, "A is symmetric"
   else
      print *, "A is not symmetric"
   end if
   bool = mfIsPosDef(A)
   if( bool ) then
      print *, "A is positive definite"
   else
      print *, "A is not positive definite"
   end if
   b = mfOnes(4,1)
   call msDisplay(b,"b")
   x = mfLDiv(A,b)
   call msDisplay(x,"x")
   if( mfIsNotEqual(x,MF_EMPTY) ) then
      call check_small( mfNorm(mfMul(A,x)-b), "residu |A*x-b|",         &
                        check_small_threshold )
   end if

   ! hermitian indefinite matrix
   ! complex case
   print "(/,A)", "*** test number 147 ***"
   a = mfHilb(4)
   call msSet( -1.0d0, A, 1, 1 )
   call msSet( -2.0d0*MF_I, A, 1, 4 )
   A = A + .h. A
   call msDisplay(a,"A")
   bool = mfIsSymm(A)
   if( bool ) then
      print *, "A is hermitian"
   else
      print *, "A is not hermitian"
   end if
   bool = mfIsPosDef(A)
   if( bool ) then
      print *, "A is positive definite"
   else
      print *, "A is not positive definite"
   end if
   b = mfOnes(4,1)*MF_I
   call msDisplay(b,"b")
   x = mfLDiv(A,b)
   call msDisplay(x,"x")
   if( mfIsNotEqual(x,MF_EMPTY) ) then
      call check_small( mfNorm(mfMul(A,x)-b), "residu |A*x-b|",         &
                        check_small_threshold )
   end if

   ! symmetric, positive definite matrix
   ! real case
   print "(/,A)", "*** test number 148 ***"
   a = mfHilb(4)
   call msDisplay(a,"A")
   bool = mfIsSymm(A)
   if( bool ) then
      print *, "A is symmetric"
   else
      print *, "A is not symmetric"
   end if
   bool = mfIsPosDef(A)
   if( bool ) then
      print *, "A is positive definite"
   else
      print *, "A is not positive definite"
   end if
   b = mfOnes(4,1)
   call msDisplay(b,"b")
   x = mfLDiv(A,b)
   call msDisplay(x,"x")
   if( mfIsNotEqual(x,MF_EMPTY) ) then
      call check_small( mfNorm(mfMul(A,x)-b), "residu |A*x-b|",         &
                        check_small_threshold )
   end if

   ! symmetric, positive definite matrix
   ! complex case
   print "(/,A)", "*** test number 149 ***"
   a = mfHilb(4) + 4.0d0*mfEye(4)
   call msSet(  0.1d0*MF_I, A, 1, 4 )
   call msSet( -0.1d0*MF_I, A, 4, 1 )
   call msDisplay(a,"A")
   bool = mfIsSymm(A)
   if( bool ) then
      print *, "A is hermitian"
   else
      print *, "A is not hermitian"
   end if
   bool = mfIsPosDef(A)
   if( bool ) then
      print *, "A is positive definite"
   else
      print *, "A is not positive definite"
   end if
   b = mfOnes(4,1)
   call msDisplay(b,"b")
   x = mfLDiv(A,b)
   call msDisplay(x,"x")
   if( mfIsNotEqual(x,MF_EMPTY) ) then
      call check_small( mfNorm(mfMul(A,x)-b), "residu |A*x-b|",         &
                        check_small_threshold )
   end if

   ! solution should be [1,2,3, ...]
   ! real case
   print "(/,A)", "*** test number 150 ***"
   n = 5
   x = .t. [ (i, i=1,n) ]
   call msDisplay(x,"imposed x")
   A = mf( reshape( [ (i, i=1,n*n) ], [n,n] ) ) + mfEye(n)
   call msDisplay(A,"A")
   b = mfMul(A,x)
   x = mfLDiv(A,b)
   call msDisplay(x,"solution : x")
   if( mfIsNotEqual(x,MF_EMPTY) ) then
      call check_small( mfNorm(mfMul(A,x)-b), "residu |A*x-b|",         &
                        check_small_threshold )
   end if

   ! after LU factorization
   print "(/,A)", "*** test number 151 ***"
   call msLU( mfOut(L,U,p), A )
   x = mfLDiv(L,U,p,b)
   call msDisplay(x,"solution : x")
   if( mfIsNotEqual(x,MF_EMPTY) ) then
      call check_small( mfNorm(mfMul(A,x)-b), "residu |A*x-b|",         &
                        check_small_threshold )
   end if

   ! after LU factorization (transpose)
   print "(/,A)", "*** test number 152 ***"
   call msLU( mfOut(L,U,p), A )
   x = mfLDiv(L,U,p,b,option="transp")
   call msDisplay(x,"solution : x")
   if( mfIsNotEqual(x,MF_EMPTY) ) then
      call check_small( mfNorm(mfMul(.t.A,x)-b), "residu |A'*x-b|",     &
                        5*check_small_threshold )
   end if

   ! solution should be [1,2,3, ...]
   ! complex case
   print "(/,A)", "*** test number 153 ***"
   n = 5
   x = .t. [ (i, i=1,n) ]
   call msDisplay(x,"imposed x")
   A = mf( reshape( [ (i, i=1,n*n) ], [n,n] ) ) + mfEye(n)
   A = a*MF_I
   call msDisplay(A,"A")
   b = mfMul(A,x)
   x = mfLDiv(A,b)
   call msDisplay(x,"solution : x")
   if( mfIsNotEqual(x,MF_EMPTY) ) then
      call check_small( mfNorm(mfMul(A,x)-b), "residu |A*x-b|",         &
                        check_small_threshold )
   end if

   ! after LU factorization
   print "(/,A)", "*** test number 154 ***"
   call msLU( mfOut(L,U,p), A )
   x = mfLDiv(L,U,p,b)
   call msDisplay(x,"solution : x")
   if( mfIsNotEqual(x,MF_EMPTY) ) then
      call check_small( mfNorm(mfMul(A,x)-b), "residu |A*x-b|",         &
                        check_small_threshold )
   end if

   ! after LU factorization
   print "(/,A)", "*** test number 155 ***"
   call msLU( mfOut(L,U,p), A )
   x = mfLDiv(L,U,p,b,option="transp")
   call msDisplay(x,"solution : x")
   if( mfIsNotEqual(x,MF_EMPTY) ) then
      call check_small( mfNorm(mfMul(.h.A,x)-b), "residu |A^h*x-b|",     &
                        5*check_small_threshold )
   end if

   ! after Cholesky factorization
   ! solution should be [1,2,3, ...]
   ! real case
   print "(/,A)", "*** test number 156 ***"
   n = 5
   x = .t. [ (i, i=1,n) ]
   call msDisplay(x,"imposed x")
   A = mfHilb( n )
   call msDisplay(A,"A")
   b = mfMul(A,x)
   U = mfChol( A )
   x = mfLDiv(U,b,form="cholesky")
   call msDisplay(x,"solution : x")
   if( mfIsNotEqual(x,MF_EMPTY) ) then
      call check_small( mfNorm(mfMul(A,x)-b), "residu |A*x-b|",         &
                        check_small_threshold )
   end if

   ! with nrhs /= 1
   print "(/,A)", "*** test number 157 ***"
   n = 5
   x = mfReshape( [ (i, i=1,2*n) ], n, 2 )
   call msDisplay(x,"imposed x")
   A = mfHilb( n )
   call msDisplay(A,"A")
   b = mfMul(A,x)
   U = mfChol( A )
   x = mfLDiv(U,b,form="cholesky")
   call msDisplay(x,"solution : x")
   if( mfIsNotEqual(x,MF_EMPTY) ) then
      call check_small( mfNorm(mfMul(A,x)-b), "residu |A*x-b|",         &
                        check_small_threshold )
   end if

   ! solution should be [1,2,3, ...]
   ! complex case
   print "(/,A)", "*** test number 158 ***"
   n = 5
   x = .t. [ (i, i=1,n) ]
   call msDisplay(x,"imposed x")
   A = mfMagic( n )*MF_I
   A = (A + .h. A) + dble(n**2)*mfEye(n)
   call msDisplay(A,"A")
   b = mfMul(A,x)
   U = mfChol( A )
   x = mfLDiv(U,b,form="cholesky")
   call msDisplay(x,"solution : x")
   if( mfIsNotEqual(x,MF_EMPTY) ) then
      call check_small( mfNorm(mfMul(A,x)-b), "residu |A*x-b|",         &
                        check_small_threshold )
   end if

   ! with nrhs /= 1
   print "(/,A)", "*** test number 159 ***"
   n = 5
   x = mfReshape( [ (i, i=1,2*n) ], n, 2 )
   call msDisplay(x,"imposed x")
   A = mfMagic( n )*MF_I
   A = (A + .h. A) + dble(n**2)*mfEye(n)
   call msDisplay(A,"A")
   b = mfMul(A,x)
   U = mfChol( A )
   x = mfLDiv(U,b,form="cholesky")
   call msDisplay(x,"solution : x")
   if( mfIsNotEqual(x,MF_EMPTY) ) then
      call check_small( mfNorm(mfMul(A,x)-b), "residu |A*x-b|",         &
                        check_small_threshold )
   end if

   ! matrix is singular !
   print "(/,A)", "*** test number 160 ***"
   n = 3
   A = mf( reshape( [ (i, i=1,n*n) ], [n,n] ) )
   call msDisplay(A,"A")
   b = mfOnes(3,1)
   x = mfLDiv(A,b)
   call msDisplay(x,"solution : x")
   if( mfIsNotEqual(x,MF_EMPTY) ) then
      call check_small( mfNorm(mfMul(A,x)-b), "residu |A*x-b|",         &
                        check_small_threshold )
   end if

   ! overdetermined system (=> least-square solution)
   ! real case (full-rank)
   print "(/,A)", "*** test number 161 ***"
   A = mf( reshape( [ (i, i=1,15) ], [5,3] ) ) + mfEye(5,3)
   call msDisplay(A,"A")
   bool = mfIsFullRank(A)
   print *, "Is A full rank ? ", bool
   x = mfOnes(3,1)
   call msDisplay(x,"non perturbed solution : x")
   b = mfMul(A,x) +                                                     &
       mf( reshape( [1,0,0,0,1], [5,1] ) )*0.001d0
   print *, "RHS has been perturbed with 0.1%"
   call msDisplay(b,"b")
   x = mfLDiv(A,b)
   call msDisplay(x,"x")
   if( mfIsNotEqual(x,MF_EMPTY) ) then
      call msDisplay(mfNorm(mfMul(A,x)-b),"residu | A*x-b |")
   end if

   ! overdetermined system (=> least-square solution)
   ! complex case (full-rank)
   print "(/,A)", "*** test number 162 ***"
   A = mf( reshape( [ (i, i=1,15) ], [5,3] ) ) + mfEye(5,3)*MF_I
   call msDisplay(A,"A")
   bool = mfIsFullRank(A)
   print *, "Is A full rank ? ", bool
   x = mfOnes(3,1)
   call msDisplay(x,"non perturbed solution : x")
   b = mfMul(A,x) +                                                     &
       mf( reshape( [1,0,0,0,1], [5,1] ) )*0.001d0
   print *, "RHS has been perturbed with 0.1%"
   call msDisplay(b,"b")
   x = mfLDiv(A,b)
   call msDisplay(x,"x")
   if( mfIsNotEqual(x,MF_EMPTY) ) then
      call msDisplay(mfNorm(mfMul(A,x)-b),"residu | A*x-b |")
   end if

   ! under-determined system
   ! real case (full-rank)
   print "(/,A)", "*** test number 163 ***"
   A = mf( reshape( [ (i, i=1,15) ], [3,5] ) ) + mfEye(3,5)
   call msDisplay(A,"A")
   bool = mfIsFullRank(A)
   print *, "Is A full rank ? ", bool
   x = mfOnes(5,1)
   call msDisplay(x,"prescribed solution : x")
   b = mfMul(A,x)
   call msDisplay(b,"b")
   x = mfLDiv(A,b)
   call msDisplay(x,"x")
   if( mfIsNotEqual(x,MF_EMPTY) ) then
      call check_small( mfNorm(mfMul(A,x)-b), "residu |A*x-b|",         &
                        check_small_threshold )
   end if

   ! under-determined system
   ! complex case (full-rank)
   print "(/,A)", "*** test number 164 ***"
   A = mf( reshape( [ (i, i=1,15) ], [3,5] ) ) + mfEye(3,5)*MF_I
   call msDisplay(A,"A")
   bool = mfIsFullRank(A)
   print *, "Is A full rank ? ", bool
   x = mfOnes(5,1)
   call msDisplay(x,"prescribed solution : x")
   b = mfMul(A,x)
   call msDisplay(b,"b")
   x = mfLDiv(A,b)
   call msDisplay(x,"x")
   if( mfIsNotEqual(x,MF_EMPTY) ) then
      call check_small( mfNorm(mfMul(A,x)-b), "residu |A*x-b|",         &
                        check_small_threshold )
   end if

   ! overdetermined system (=> least-square solution)
   ! real case (rank deficient)
   print "(/,A)", "*** test number 165 ***"
   A = mf( reshape( [ (i, i=1,15) ], [5,3] ) )
   call msDisplay(A,"A")
   bool = mfIsFullRank(A)
   print *, "Is A full rank ? ", bool
   x = mfOnes(3,1)
   call msDisplay(x,"non perturbed solution : x")
   b = mfMul(A,x) +                                                     &
       mf( reshape( [1,0,0,0,1], [5,1] ) )*0.001d0
   print *, "RHS has been perturbed with 0.1%"
   call msDisplay(b,"b")
   x = mfLDiv(A,b)
   call msFormat("long")
   call msDisplay(x,"x")
   call msFormat("short")
   if( mfIsNotEqual(x,MF_EMPTY) ) then
      call msDisplay(mfNorm(mfMul(A,x)-b),"residu | A*x-b |")
   end if

   ! overdetermined system (=> least-square solution)
   ! complex case (rank deficient)
   print "(/,A)", "*** test number 166 ***"
   A = mf( reshape( [ (i, i=1,15) ], [5,3] ) )*MF_I
   call msDisplay(A,"A")
   bool = mfIsFullRank(A)
   print *, "Is A full rank ? ", bool
   x = mfOnes(3,1)
   call msDisplay(x,"non perturbed solution : x")
   b = mfMul(A,x) +                                                     &
       mf( reshape( [1,0,0,0,1], [5,1] ) )*0.001d0
   print *, "RHS has been perturbed with 0.1%"
   call msDisplay(b,"b")
   x = mfLDiv(A,b)
   call msFormat("long")
   call zeroes_small_values( x, check_small_threshold )
   call msDisplay(x,"x")
   call msFormat("short")
   if( mfIsNotEqual(x,MF_EMPTY) ) then
      call msDisplay(mfNorm(mfMul(A,x)-b),"residu | A*x-b |")
   end if

   ! under-determined system
   ! real case (rank deficient)
   print "(/,A)", "*** test number 167 ***"
   A = mf( reshape( [ (i, i=1,15) ], [3,5] ) )
   call msDisplay(A,"A")
   x = mfOnes(5,1)
   call msDisplay(x,"prescribed solution : x")
   b = mfMul(A,x)
   call msDisplay(b,"b (inside the image)")
   x = mfLDiv(A,b)
   call msDisplay(x,"x")
   if( mfIsNotEqual(x,MF_EMPTY) ) then
      call check_small( mfNorm(mfMul(A,x)-b), "residu |A*x-b|",         &
                        check_small_threshold )
   end if
   print "(/,A)", "*** test number 168 ***"
   b = b + (.t. [ 1,0,0 ])*0.01d0
   call msDisplay(b,"b (outside the image)")
   x = mfLDiv(A,b)
   call msDisplay(x,"x")
   if( mfIsNotEqual(x,MF_EMPTY) ) then
      call msDisplay(mfNorm(mfMul(A,x)-b),"residu | A*x-b |")
   end if

   ! under-determined system
   ! complex case (rank deficient)
   print "(/,A)", "*** test number 169 ***"
   A = mf( reshape( [ (i, i=1,15) ], [3,5] ) )*MF_I
   call msDisplay(A,"A")
   x = mfOnes(5,1)
   call msDisplay(x,"prescribed solution : x")
   b = mfMul(A,x)
   call msDisplay(b,"b (inside the image)")
   x = mfLDiv(A,b)
   call zeroes_small_values( x, check_small_threshold )
   call msDisplay(x,"x")
   if( mfIsNotEqual(x,MF_EMPTY) ) then
      call check_small( mfNorm(mfMul(A,x)-b), "residu |A*x-b|",         &
                        check_small_threshold )
   end if
   print "(/,A)", "*** test number 170 ***"
   b = b + (.t. [ 1,0,0 ])*0.01d0
   call msDisplay(b,"b (outside the image)")
   x = mfLDiv(A,b)
   call msDisplay(x,"x")
   if( mfIsNotEqual(x,MF_EMPTY) ) then
      call msDisplay(mfNorm(mfMul(A,x)-b),"residu | A*x-b |")
   end if

   ! mfRDiv ------------------------------------------------------------
   call print_separation("mfRDiv")

   ! real diagonal matrix
   print "(/,A)", "*** test number 171 ***"
   A = mfEye(4)*2.0d0
   call msDisplay(A,"A")
   b = mfOnes(1,4)
   call msDisplay(b,"b")
   x = mfRDiv(b,A)
   call msDisplay(x,"x")
   if( mfIsNotEqual(x,MF_EMPTY) ) then
      call check_small( mfNorm(mfMul(x,A)-b), "residu |x*A-b|",         &
                        check_small_threshold )
   end if

   ! complexe/real diagonal system
   print "(/,A)", "*** test number 172 ***"
   A = mfEye(4)*MF_I
   call msDisplay(A,"A")
   b = mfOnes(1,4)
   call msDisplay(b,"b")
   x = mfRDiv(b,A)
   call msDisplay(x,"x")
   if( mfIsNotEqual(x,MF_EMPTY) ) then
      call check_small( mfNorm(mfMul(x,A)-b), "residu |x*A-b|",         &
                        check_small_threshold )
   end if

   ! real/complexe diagonal system
   print "(/,A)", "*** test number 173 ***"
   A = mfEye(4)
   call msDisplay(A,"A")
   b = mfOnes(1,4)*MF_I
   call msDisplay(b,"b")
   x = mfRDiv(b,A)
   call msDisplay(x,"x")
   if( mfIsNotEqual(x,MF_EMPTY) ) then
      call check_small( mfNorm(mfMul(x,A)-b), "residu |x*A-b|",         &
                        check_small_threshold )
   end if

   ! complexe/complexe diagonal system
   print "(/,A)", "*** test number 174 ***"
   A = mfEye(4)*MF_I
   call msDisplay(A,"A")
   b = mfOnes(1,4)*MF_I
   call msDisplay(b,"b")
   x = mfRDiv(b,A)
   call msDisplay(x,"x")
   if( mfIsNotEqual(x,MF_EMPTY) ) then
      call check_small( mfNorm(mfMul(x,A)-b), "residu |x*A-b|",         &
                        check_small_threshold )
   end if

   ! upper triangular matrix
   print "(/,A)", "*** test number 175 ***"
   a = mfHilb(4)
   a = mfTriu(a)
   call msDisplay(a,"A")
   b = mfOnes(1,4)
   call msDisplay(b,"b")
   x = mfRDiv(b,a)
   call msDisplay(x,"x")
   if( mfIsNotEqual(x,MF_EMPTY) ) then
      call check_small( mfNorm(mfMul(x,a)-b), "residu |x*A-b|",         &
                        check_small_threshold )
   end if

   ! lower triangular matrix
   print "(/,A)", "*** test number 176 ***"
   a = mfHilb(4)
   a = mfTril(a)
   call msDisplay(a,"A")
   b = mfOnes(1,4)
   call msDisplay(b,"b")
   x = mfRDiv(b,a)
   call msDisplay(x,"x")
   if( mfIsNotEqual(x,MF_EMPTY) ) then
      call check_small( mfNorm(mfMul(x,a)-b), "residu |x*A-b|",         &
                        check_small_threshold )
   end if

   ! symmetric indefinite matrix
   ! real case
   print "(/,A)", "*** test number 177 ***"
   A = mfHilb(4)
   call msSet( -1.0d0, A, 1, 1 )
   call msDisplay(a,"A")
   bool = mfIsSymm(A)
   if( bool ) then
      print *, "A is symmetric"
   else
      print *, "A is not symmetric"
   end if
   bool = mfIsPosDef(A)
   if( bool ) then
      print *, "A is positive definite"
   else
      print *, "A is not positive definite"
   end if
   b = mfOnes(1,4)
   call msDisplay(b,"b")
   x = mfRDiv(b,A)
   call msDisplay(x,"x")
   if( mfIsNotEqual(x,MF_EMPTY) ) then
      call check_small( mfNorm(mfMul(x,A)-b), "residu |x*A-b|",         &
                        check_small_threshold )
   end if

   ! hermitian indefinite matrix
   ! complex case
   print "(/,A)", "*** test number 178 ***"
   A = mfHilb(4)
   call msSet( -1.0d0, A, 1, 1 )
   call msSet( -2.0d0*MF_I, A, 1, 4 )
   A = A + .h. A
   call msDisplay(A,"A")
   bool = mfIsSymm(A)
   if( bool ) then
      print *, "A is hermitian"
   else
      print *, "A is not hermitian"
   end if
   bool = mfIsPosDef(A)
   if( bool ) then
      print *, "A is positive definite"
   else
      print *, "A is not positive definite"
   end if
   b = mfOnes(1,4)*MF_I
   call msDisplay(b,"b")
   x = mfRDiv(b,A)
   call msDisplay(x,"x")
   if( mfIsNotEqual(x,MF_EMPTY) ) then
      call check_small( mfNorm(mfMul(x,A)-b), "residu |x*A-b|",         &
                        check_small_threshold )
   end if

   ! symmetric, positive definite matrix
   ! real case
   print "(/,A)", "*** test number 179 ***"
   a = mfHilb(4)
   call msDisplay(a,"A")
   bool = mfIsSymm(A)
   if( bool ) then
      print *, "A is symmetric"
   else
      print *, "A is not symmetric"
   end if
   bool = mfIsPosDef(A)
   if( bool ) then
      print *, "A is positive definite"
   else
      print *, "A is not positive definite"
   end if
   b = mfOnes(1,4)
   call msDisplay(b,"b")
   x = mfRDiv(b,a)
   call msDisplay(x,"x")
   if( mfIsNotEqual(x,MF_EMPTY) ) then
      call check_small( mfNorm(mfMul(x,a)-b), "residu |x*A-b|",         &
                        check_small_threshold )
   end if

   ! symmetric, positive definite matrix
   ! complex case
   print "(/,A)", "*** test number 180 ***"
   a = mfHilb(4) + 4.0d0*mfEye(4)
   call msSet(  0.1d0*MF_I, A, 1, 4 )
   call msSet( -0.1d0*MF_I, A, 4, 1 )
   call msDisplay(a,"A")
   bool = mfIsSymm(A)
   if( bool ) then
      print *, "A is hermitian"
   else
      print *, "A is not hermitian"
   end if
   bool = mfIsPosDef(A)
   if( bool ) then
      print *, "A is positive definite"
   else
      print *, "A is not positive definite"
   end if
   b = mfOnes(1,4)
   call msDisplay(b,"b")
   x = mfRDiv(b,a)
   call msDisplay(x,"x")
   if( mfIsNotEqual(x,MF_EMPTY) ) then
      call check_small( mfNorm(mfMul(x,a)-b), "residu |x*A-b|",         &
                        check_small_threshold )
   end if

   ! solution should be [1,2,3, ...]
   ! real case
   print "(/,A)", "*** test number 181 ***"
   n = 5
   x = mf( [ (i, i=1,n) ] )
   call msDisplay(x,"imposed x")
   A = mf( reshape( [ (i, i=1,n*n) ], [n,n] ) ) + mfEye(n)
   call msDisplay(A,"A")
   b = mfMul(x,A)
   x = mfRDiv(b,A)
   call msDisplay(x,"solution : x")
   if( mfIsNotEqual(x,MF_EMPTY) ) then
      call check_small( mfNorm(mfMul(x,A)-b), "residu |x*A-b|",         &
                        check_small_threshold )
   end if

   ! after LU factorization
   print "(/,A)", "*** test number 182 ***"
   call msLU( mfOut(L,U,P), A )
   x = mfRDiv(b,L,U,P)
   call msDisplay(x,"solution : x")
   if( mfIsNotEqual(x,MF_EMPTY) ) then
      call check_small( mfNorm(mfMul(x,A)-b), "residu |x*A-b|",         &
                        check_small_threshold )
   end if

   ! solution should be [1,2,3, ...]
   ! complex case
   print "(/,A)", "*** test number 183 ***"
   n = 5
   x = mf( [ (i, i=1,n) ] )
   call msDisplay(x,"imposed x")
   A = mf( reshape( [ (i, i=1,n*n) ], [n,n] ) ) + mfEye(n)
   A = A*MF_I
   call msDisplay(A,"A")
   b = mfMul(x,A)
   x = mfRDiv(b,A)
   call msDisplay(x,"solution : x")
   if( mfIsNotEqual(x,MF_EMPTY) ) then
      call check_small( mfNorm(mfMul(x,A)-b), "residu |x*A-b|",         &
                        check_small_threshold )
   end if

   ! after LU factorization
   print "(/,A)", "*** test number 184 ***"
   call msLU( mfOut(L,U,P), A )
   x = mfRDiv(b,L,U,P)
   call msDisplay(x,"solution : x")
   if( mfIsNotEqual(x,MF_EMPTY) ) then
      call check_small( mfNorm(mfMul(x,A)-b), "residu |x*A-b|",         &
                        check_small_threshold )
   end if

   ! after Cholesky factorization
   ! solution should be [1,2,3, ...]
   ! real case
   print "(/,A)", "*** test number 185 ***"
   n = 5
   x = [ (i, i=1,n) ]
   call msDisplay(x,"imposed x")
   A = mfHilb( n )
   call msDisplay(A,"A")
   b = mfMul(x,A)
   U = mfChol( A )
   x = mfRDiv(b,U,form="cholesky")
   call msDisplay(x,"solution : x")
   if( mfIsNotEqual(x,MF_EMPTY) ) then
      call check_small( mfNorm(mfMul(x,A)-b), "residu |x*A-b|",         &
                        check_small_threshold )
   end if

   ! with nrhs /= 1
   print "(/,A)", "*** test number 186 ***"
   n = 5
   x = .t. mfReshape( [ (i, i=1,2*n) ], n, 2 )
   call msDisplay(x,"imposed x")
   A = mfHilb( n )
   call msDisplay(A,"A")
   b = mfMul(x,A)
   U = mfChol( A )
   x = mfRDiv(b,U,form="cholesky")
   call msDisplay(x,"solution : x")
   if( mfIsNotEqual(x,MF_EMPTY) ) then
      call check_small( mfNorm(mfMul(x,A)-b), "residu |x*A-b|",         &
                        check_small_threshold )
   end if


   ! solution should be [1,2,3, ...]
   ! complex case
   print "(/,A)", "*** test number 187 ***"
   n = 5
   x = [ (i, i=1,n) ]
   call msDisplay(x,"imposed x")
   A = mfMagic( n )*MF_I
   A = (A + .h. A) + dble(n**2)*mfEye(n)
   call msDisplay(A,"A")
   b = mfMul(x,A)
   U = mfChol( A )
   x = mfRDiv(b,U,form="cholesky")
   call msDisplay(x,"solution : x")
   if( mfIsNotEqual(x,MF_EMPTY) ) then
      call check_small( mfNorm(mfMul(x,A)-b), "residu |x*A-b|",         &
                        check_small_threshold )
   end if

   ! with nrhs /= 1
   print "(/,A)", "*** test number 188 ***"
   n = 5
   x = .t. mfReshape( [ (i, i=1,2*n) ], n, 2 )
   call msDisplay(x,"imposed x")
   A = mfMagic( n )*MF_I
   A = (A + .h. A) + dble(n**2)*mfEye(n)
   call msDisplay(A,"A")
   b = mfMul(x,A)
   U = mfChol( A )
   x = mfRDiv(b,U,form="cholesky")
   call msDisplay(x,"solution : x")
   if( mfIsNotEqual(x,MF_EMPTY) ) then
      call check_small( mfNorm(mfMul(x,A)-b), "residu |x*A-b|",         &
                        check_small_threshold )
   end if

   ! matrix is singular !
   print "(/,A)", "*** test number 189 ***"
   n = 3
   a = .t. mf( reshape( [ (i, i=1,n*n) ], [n,n] ) )
   call msDisplay(a,"A")
   b = mfOnes(1,3)
   call msDisplay(b,"b")
   x = mfRDiv(b,a)
   call msDisplay(x,"solution : x")
   if( mfIsNotEqual(x,MF_EMPTY) ) then
      call check_small( mfNorm(mfMul(x,a)-b), "residu |x*A-b|",         &
                        check_small_threshold )
   end if

   ! overdetermined system (=> least-square solution)
   ! real case (full-rank)
   print "(/,A)", "*** test number 190 ***"
   a = mf( reshape( [ (i, i=1,15) ], [3,5] ) ) + mfEye(3,5)
   ! we should verify that A is full rank
   call msDisplay(a,"A")
   x = mfOnes(1,3)
   call msDisplay(x,"non perturbed solution : x")
   b = mfMul(x,a) +                                                     &
       mf( [1,0,0,0,1] )*0.001d0
   print *, "RHS has been perturbed with 0.1%"
   call msDisplay(b,"b")
   x = mfRDiv(b,a)
   call msDisplay(x,"x")
   if( mfIsNotEqual(x,MF_EMPTY) ) then
      call msDisplay(mfNorm(mfMul(x,a)-b),"residu |x*A-b|")
   end if

   ! overdetermined system (=> least-square solution)
   ! complex case (full-rank)
   print "(/,A)", "*** test number 191 ***"
   a = mf( reshape( [ (i, i=1,15) ], [3,5] ) ) + mfEye(3,5)*MF_I
   ! we should verify that A is full rank
   call msDisplay(a,"A")
   x = mfOnes(1,3)
   call msDisplay(x,"non perturbed solution : x")
   b = mfMul(x,a) +                                                     &
       mf( [1,0,0,0,1] )*0.001d0
   print *, "RHS has been perturbed with 0.1%"
   call msDisplay(b,"b")
   x = mfRDiv(b,a)
   call msDisplay(x,"x")
   if( mfIsNotEqual(x,MF_EMPTY) ) then
      call msDisplay(mfNorm(mfMul(x,a)-b),"residu |x*A-b|")
   end if

   ! under-determined system
   ! real case (full-rank)
   print "(/,A)", "*** test number 192 ***"
   a = mf( reshape( [ (i, i=1,15) ], [5,3] ) ) + mfEye(5,3)
   call msDisplay(a,"A")
   x = mfOnes(1,5)
   call msDisplay(x,"prescribed solution : x")
   b = mfMul(x,a)
   call msDisplay(b,"b")
   x = mfRDiv(b,a)
   call msDisplay(x,"x")
   if( mfIsNotEqual(x,MF_EMPTY) ) then
      call check_small( mfNorm(mfMul(x,a)-b), "residu |x*A-b|",         &
                        check_small_threshold )
   end if

   ! under-determined system
   ! complex case (full-rank)
   print "(/,A)", "*** test number 193 ***"
   a = mf( reshape( [ (i, i=1,15) ], [5,3] ) ) + mfEye(5,3)*MF_I
   call msDisplay(a,"A")
   x = mfOnes(1,5)
   call msDisplay(x,"prescribed solution : x")
   b = mfMul(x,a)
   call msDisplay(b,"b")
   x = mfRDiv(b,a)
   call msDisplay(x,"x")
   if( mfIsNotEqual(x,MF_EMPTY) ) then
      call check_small( mfNorm(mfMul(x,a)-b), "residu |x*A-b|",         &
                        check_small_threshold )
   end if

   ! overdetermined system (=> least-square solution)
   ! real case (rank deficient)
   print "(/,A)", "*** test number 194 ***"
   a = mf( reshape( [ (i, i=1,15) ], [3,5] ) )
   call msDisplay(a,"A")
   x = mfOnes(1,3)
   call msDisplay(x,"non perturbed solution : x")
   b = mfMul(x,a) +                                                     &
       mf( [1,0,0,0,1] )*0.001d0
   print *, "RHS has been perturbed with 0.1%"
   call msDisplay(b,"b")
   x = mfRDiv(b,a)
   call msDisplay(x,"x")
   if( mfIsNotEqual(x,MF_EMPTY) ) then
      call msDisplay(mfNorm(mfMul(x,a)-b),"residu |x*A-b|")
   end if

   ! overdetermined system (=> least-square solution)
   ! complex case (rank deficient)
   print "(/,A)", "*** test number 195 ***"
   a = mf( reshape( [ (i, i=1,15) ], [3,5] ) )*MF_I
   call msDisplay(a,"A")
   x = mfOnes(1,3)
   call msDisplay(x,"non perturbed solution : x")
   b = mfMul(x,a) +                                                     &
       mf( [1,0,0,0,1] )*0.001d0
   print *, "RHS has been perturbed with 0.1%"
   call msDisplay(b,"b")
   x = mfRDiv(b,a)
   call zeroes_small_values( x, check_small_threshold )
   call msDisplay(x,"x")
   if( mfIsNotEqual(x,MF_EMPTY) ) then
      call msDisplay(mfNorm(mfMul(x,a)-b),"residu |x*A-b|")
   end if

   ! under-determined system
   ! real case (rank deficient)
   print "(/,A)", "*** test number 196 ***"
   A = mf( reshape( [ (i, i=1,15) ], [5,3] ) )
   call msDisplay(A,"A")
   x = mfOnes(1,5)
   call msDisplay(x,"prescribed solution : x")
   b = mfMul(x,A)
   call msDisplay(b,"b (inside the image)")
   x = mfRDiv(b,A)
   call msDisplay(x,"x")
   if( mfIsNotEqual(x,MF_EMPTY) ) then
      call check_small( mfNorm(mfMul(x,A)-b), "residu |x*A-b|",         &
                        check_small_threshold )
   end if
   print "(/,A)", "*** test number 197 ***"
   b = b + mf([ 1,0,0 ])*0.01d0
   call msDisplay(b,"b (outside the image)")
   x = mfRDiv(b,A)
   call msDisplay(x,"x")
   if( mfIsNotEqual(x,MF_EMPTY) ) then
      call msDisplay(mfNorm(mfMul(x,A)-b),"residu | x*A-b |")
   end if

   ! under-determined system
   ! complex case (rank deficient)
   print "(/,A)", "*** test number 198 ***"
   a = mf( reshape( [ (i, i=1,15) ], [5,3] ) )*MF_I
   call msDisplay(a,"A")
   x = mfOnes(1,5)
   call msDisplay(x,"prescribed solution : x")
   b = mfMul(x,a)
   call msDisplay(b,"b (inside the image)")
   x = mfRDiv(b,a)
   call zeroes_small_values( x, check_small_threshold )
   call msDisplay(x,"x")
   if( mfIsNotEqual(x,MF_EMPTY) ) then
      call check_small( mfNorm(mfMul(x,a)-b), "residu |x*A-b|",         &
                        check_small_threshold )
   end if
   print "(/,A)", "*** test number 199 ***"
   b = b + mf([ 1,0,0 ])*0.01d0
   call msDisplay(b,"b (outside the image)")
   x = mfRDiv(b,A)
   call msDisplay(x,"x")
   if( mfIsNotEqual(x,MF_EMPTY) ) then
      call msDisplay(mfNorm(mfMul(x,A)-b),"residu | x*A-b |")
   end if

   ! mfChol ------------------------------------------------------------
   call print_separation("mfChol")

   ! should work for a real, positive scalar
   print "(/,A)", "*** test number 200 ***"
   A = 4.0d0
   call msDisplay(A,"A")
   U = mfChol(A)
   call msDisplay(U,"U = mfChol(A)")
   B = mfMul(.t.U,U)-A
   call check_small( mfNorm(B), "norm(U'*U - A)", check_small_threshold )

   print "(/,A)", "*** test number 201 ***"
   A = mfHilb(3)
   call msDisplay(A,"A")
   U = mfChol(A)
   call msDisplay(U,"U = mfChol(A)")
   B = mfMul(.t.U,U)-A
   call check_small( mfNorm(B), "norm(U'*U - A)", check_small_threshold )

   print "(/,A)", "*** test number 202 ***"
   A = mf( reshape( [ 1, 7, 5, 2, 8, 2, 0, 9, 1 ], [ 3, 3 ] ) )
   A = sym_part(A)                ! A must be symmetric...
   A = A + mfEye(3)*3.0d0         ! ...and positive definite
   call msDisplay(A,"A")
   U = mfChol(A)
   call msDisplay(U,"U = mfChol(A)")
   B = mfMul(.t.U,U)-A
   call check_small( mfNorm(B), "norm(U'*U - A)", check_small_threshold )

   print "(/,A)", "*** test number 203 ***"
   A = [    (3.d0,0.d0),  (0.5d0,0.5d0), (0.1d0,0.1d0) ] .vc.           &
       [ (0.5d0,-0.5d0),    (3.d0,0.d0), (0.5d0,0.5d0) ] .vc.           &
       [ (0.1d0,-0.1d0), (0.5d0,-0.5d0),   (3.d0,0.d0) ]
   call msDisplay(A,"A")
   U = mfChol(A)
   call msDisplay(U,"U = mfChol(A)")
   B = mfMul(.h.U,U)-A
   call check_small( mfNorm(B), "norm(U'*U - A)", check_small_threshold )

   ! msBalance ---------------------------------------------------------
   call print_separation("msBalance")

   print "(/,A)", "*** test number 204 ***"
   A = [ 100.0d0, 200.0d0, 300.0d0 ] .vc.                               &
       [   4.0d0,   5.0d0,   6.0d0 ] .vc.                               &
       [   7.0d0,   8.0d0,   9.0d0 ]
   call msDisplay(A,"A")
   call msBalance( mfout(T,B), A )
   call msDisplay(B,"B",T,"T")
   call msDisplay(mfNorm(mfMul(T,B)-mfMul(A,T)),"norm(T*B - A*T)")

   call msDisplay(mfNorm(A),"norm(A)")
   call msDisplay(mfNorm(B),"norm(B)")
   print *, "Is mfCond(A) > 1.0d0/MF_EPS?"
   call msDisplay( mfCond(A) > 1.0d0/MF_EPS, "ans" )
   print *, "Is mfCond(B) > 1.0d0/MF_EPS?"
   call msDisplay( mfCond(B) > 1.0d0/MF_EPS, "ans" )

   call msSvd( mfOut(U,S,V), A )
   call msDisplay(.t.mfDiag(S),"Singular values for A")
   call msDisplay(mfEig(A),"Eigenvalues for A")

   call msSvd( mfOut(U,S,V), B )
   call msDisplay(.t.mfDiag(S),"Singular values for B")
   call msDisplay(mfEig(B),"Eigenvalues for B")

   print "(/,A)", "*** test number 205 ***"
   A = mfHilb(5)
   call msPointer(A,A_ptr)
   A_ptr(1,1) = 1.0d6
   A_ptr(1,5) = 1.0d6
   call msFreePointer(A,A_ptr)
   call msDisplay(A,"A")
   call msBalance( mfout(T,B), A )
   !call msDisplay(B,"B",T,"T")
   call msDisplay(mfNorm(mfMul(T,B)-mfMul(A,T)),"norm(T*B - A*T)")

   call msDisplay(mfNorm(A),"norm(A)")
   call msDisplay(mfNorm(B),"norm(B)")
   call msDisplay(mfCond(A),"cond(A)")
   call msDisplay(mfCond(B),"cond(B)")

   !call msFormat( "long" )

   call msSvd( mfOut(U,S,V), A )
   call msDisplay(.t.mfDiag(S),"Singular values for A")
   call msDisplay(mfEig(A),"Eigenvalues for A")

   call msSvd( mfOut(U,S,V), B )
   call msDisplay(.t.mfDiag(S),"Singular values for B")
   call msDisplay(mfEig(B),"Eigenvalues for B")

   !call msFormat( "short" )

   ! End of tests ------------------------------------------------------
   print "(A)", "                         ┏━━━━━━━━━━━━━━━━━━━━━━━━━━┓"
   print "(A)", "                         ┃ End of test_mod_matfun_1 ┃"
   print "(A)", "                         ┗━━━━━━━━━━━━━━━━━━━━━━━━━━┛"

   !--------------------------------------------------------------------
99 continue

   print "()"
   call msSetMsgLevel(2)

   call msRelease( x, A, L, U, P, B, S )
   call msRelease( V, AI, Q, R, T, D, H )
   call msRelease( A_sym, A_nonsym, A_herm, A_nonherm, C, F, E )
   call msRelease( jpiv, flag, rank )

   ! non official Muesli routine: introduced here to clean memory
   call RngStream_end()

end program
