program test_mod_funfun

   use fml

   use test_aux
   use lib_aux

   use int_funs
   use ode_funs
   use dae_funs
   use fzero_funs
   use optim_funs_2

   implicit none

   real(kind=MF_DOUBLE) :: t_0, t_end, res
   integer :: i, k, m, n
   integer :: MsgLevel_save

   type(mfArray) :: x, y, abs_err, fct_eval, status, tolout, y_end, yp, &
                    new_err, t_span, solve_log, tol, yp_end, non_neg,   &
                    val, fvec, y_0, yp_0, y_out, yp_out, ident, z, p,   &
                    resnorm, res_log, p_log, t_log, order_log
   type(mf_DE_Options) :: options_DE
   type(mf_NL_Options) :: options_NL

   !--------------------------------------------------------------------

   ! Msg level = 3 : all messages are printed (verbose mode)
   !             2 : messages of kind 'ERROR' and 'Warning' are
   !                 printed [default]
   !             1 : only messages of kind 'ERROR' are printed
   !             0 : nothing is printed (quiet mode)
   !                 (pause are ignored !)

!!   call msSetMsgLevel(3)
!!   call msSetTrbLevel("all")

   print "()"

   ! for TRACE_MEM_DEBUG, STDERR must be redirected to STDOUT;
   ! the same thing stands for 'make check'
   call msSetStdIO( stderr=STDOUT )

!   call msSetRoundingMode( "down" )

   ! mandatory, because some tests below ask a jacobian check
   MF_NUMERICAL_CHECK = .true.

!!goto 10

   ! to avoid escape sequences of color setting in the output file
   ! (default in "on")
   call msSetColoredMsg( "off" )

   ! VERSIONs ----------------------------------------------------------
   print "()"
   print *, "MF_MUESLI_VERSION = '", MF_MUESLI_VERSION, "'"
   print "()"
   print *, "MF_COMPILER_VERSION = '", MF_COMPILER_VERSION, "'"
   print "()"
   print *, "MF_COMPILATION_CONFIG = '", MF_COMPILATION_CONFIG(), "'"
   print "()"
   print *, "MF_NUMERICAL_CHECK = ", MF_NUMERICAL_CHECK
   print "()"

   ! mfQuad ------------------------------------------------------------
   call print_separation("mfQuad")

   print "(/,A)", "*** test number 1 ***"
   print "()"
   print *, "integration of 'sqrt(x)' over [0,1] with rel. tol=1.0d-6:"
   x = mfQuad( fun_sqrt, 0.0d0, 1.0d0, rel_tol=1.0d-6 )
   call msFormat( "long" )
   call msDisplay( x, "numerical result" )
   call msDisplay( 2.0d0/3.0d0, "exact answer" )
   call msFormat( "short" )

   print "(/,A)", "*** test number 2 ***"
   print "()"
   print *, "integration of 'sqrt(x)' over [0,1] with rel. tol=1.0d-12:"
   x = mfQuad( fun_sqrt, 0.0d0, 1.0d0, rel_tol=1.0d-12 )
   call msFormat( "long" )
   call msDisplay( x, "numerical result" )
   call msDisplay( 2.0d0/3.0d0, "exact answer" )
   call msFormat( "short" )

   print "(/,A)", "*** test number 3 ***"
   print "()"
   print *, "integration of 'log(x)' over [0,1] with rel. tol=1.0d-12:"
   x = mfQuad( fun_log, 0.0d0, 1.0d0, rel_tol=1.0d-12 )
   call msFormat( "long" )
   call msDisplay( x, "numerical result" )
   call msDisplay( -1.0d0, "exact answer" )
   call msFormat( "short" )

   print "(/,A)", "*** test number 4 ***"
   print "()"
   print *, "integration of 'log(x)' over [0,1] (other method for singularity):"
   x = mfQuad( fun_log, 0.0d0, 1.0d0, sing=.true. )
   call msFormat( "long" )
   call round_values( x, d=14 )
   call msDisplay( x, "numerical result" )
   call msDisplay( -1.0d0, "exact answer" )
   call msFormat( "short" )

   print "(/,A)", "*** test number 5 ***"
   print "()"
   print *, "integration of 'sin(x)' over [0,2*pi] with abs. tol=1.0d-6:"
   x = mfQuad( fun_sin, 0.0d0, 2*MF_PI, abs_tol=1.0d-6 )
   call msDisplay( x, "numerical result" )
   call msDisplay( 0.0d0, "exact answer" )

   print "(/,A)", "*** test number 6 ***"
   print "()"
   print *, "integration of '1/x^2' over [1,+Inf]:"
   x = mfQuad( fun_one_over_x2, 1.0d0, +MF_INF )
   call msDisplay( x, "numerical result" )
   call msDisplay( 1.0d0, "exact answer" )

   print "(/,A)", "*** test number 7 ***"
   print "()"
   print *, "integration of 'x*exp(-x^2)' over [-Inf,+Inf]:"
   x = mfQuad( fun_x_times_gaussian, -MF_INF, +MF_INF )
   call msDisplay( x, "numerical result" )
   call msDisplay( 0.0d0, "exact answer" )

   print "(/,A)", "*** test number 8 ***"
   print "()"
   print *, "integration of '1/(x+1)/sqrt(x)' over [0,+Inf]:"
   x = mfQuad( fun_which_gives_pi, 0.0d0, +MF_INF )
   call msDisplay( x, "numerical result" )
   call msDisplay( MF_PI, "exact answer" )

   ! msQuad ------------------------------------------------------------
   call print_separation("msQuad")

   print "(/,A)", "*** test number 9 ***"
   print "()"
   print *, "integration of 'sqrt(x)' over [0,1]:"
   call msQuad( mfOut(x,abs_err), fun_sqrt, 0.0d0, 1.0d0 )
   call msDisplay( x, "numerical result" )
   y = 2.0d0/3.0d0
   call msDisplay( y, "exact answer", mfAbs(x-y)/y, "relat. error" )

   print "(/,A)", "*** test number 10 ***"
   print "()"
   print *, "integration of 'sqrt(x)' over [0,1] with rel. tol=1.0d-6:"
   call msQuad( mfOut(x,abs_err,status), fun_sqrt, 0.0d0, 1.0d0, rel_tol=1.0d-6 )
   call msDisplay( status, "status" )
   call msDisplay( x, "numerical result", abs_err, "estimated error" )
   y = 2.0d0/3.0d0
   call msDisplay( y, "exact answer", mfAbs(x-y)/y, "relat. error" )

   print "(/,A)", "*** test number 11 ***"
   print "()"
   print *, "integration of 'sqrt(x)' over [0,1]:"
   call msQuad( mfOut(x,abs_err,status,fct_eval), fun_sqrt, 0.0d0, 1.0d0 )
   call msDisplay( x, "numerical result" )
   call check_small( abs_err, "estimated error", 1.0d-12 )
   call msDisplay( fct_eval, "nb of fct evaluation", status, "returned status" )
   y = 2.0d0/3.0d0
   call msDisplay( y, "exact answer", mfAbs(x-y)/y, "relat. error" )

   ! testing MF_NO_ARG
   print "(/,A)", "*** test number 12 ***"
   print "()"
   print *, "integration of 'sqrt(x)' over [0,1]:"
   call msQuad( mfOut(x,abs_err,MF_NO_ARG,fct_eval), fun_sqrt, 0.0d0, 1.0d0 )
   call msDisplay( x, "numerical result" )
   call check_small( abs_err, "estimated error", 1.0d-12 )
   call msDisplay( fct_eval, "nb of fct evaluation" )
   y = 2.0d0/3.0d0
   call msDisplay( y, "exact answer", mfAbs(x-y)/y, "relat. error" )

   print "(/,A)", "*** test number 13 ***"
   print "()"
   print *, "integration of 'log(x)' over [0,1]:"
   call msQuad( mfOut(x,abs_err,status,fct_eval), fun_log, 0.0d0, 1.0d0, &
                rel_tol=1.0d-12 )
   call msDisplay( x, "numerical result" )
   call check_small( abs_err, "estimated error", 1.0d-12 )
   call msDisplay( fct_eval, "nb of fct evaluation", status, "returned status" )
   y = -1.0d0
   call msDisplay( y, "exact answer", mfAbs(x-y)/y, "relat. error" )

   print "(/,A)", "*** test number 14 ***"
   print "()"
   print *, "integration of 'log(x)' over [0,1]:"
   call msQuad( mfOut(x,abs_err,status,fct_eval), fun_log, 0.0d0, 1.0d0, &
                sing=.true. )
   call round_values( x, d=14 )
   call msDisplay( x, "numerical result", abs_err, "estimated error" )
   call msDisplay( fct_eval, "nb of fct evaluation", status, "returned status" )
   y = -1.0d0
   call msDisplay( y, "exact answer", mfAbs(x-y)/y, "relat. error" )

   print "(/,A)", "*** test number 15 ***"
   print "()"
   print *, "integration of 'sin(x)' over [0,2*pi]:"
   call msQuad( mfOut(x,abs_err,status,fct_eval), fun_sin, 0.0d0, 2*MF_PI )
   call msDisplay( x, "numerical result", abs_err, "estimated error" )
   call msDisplay( fct_eval, "nb of fct evaluation", status, "returned status" )
   call msDisplay( 0.0d0, "exact answer" )

   print "(/,A)", "*** test number 16 ***"
   print "()"
   print *, "integration of '1/x^2' over [1,+Inf]:"
   call msQuad( mfOut(x,abs_err,status,fct_eval),                       &
                fun_one_over_x2, 1.0d0, +MF_INF )
   call msDisplay( x, "numerical result", abs_err, "estimated error" )
   call msDisplay( fct_eval, "nb of fct evaluation", status, "returned status" )
   call msDisplay( 1.0d0, "exact answer" )

   print "(/,A)", "*** test number 17 ***"
   print "()"
   print *, "integration of 'x*exp(-x^2)' over [-Inf,+Inf]:"
   call msQuad( mfOut(x,abs_err,status,fct_eval),                       &
                fun_x_times_gaussian, -MF_INF, +MF_INF )
   call msDisplay( x, "numerical result", abs_err, "estimated error" )
   call msDisplay( fct_eval, "nb of fct evaluation", status, "returned status" )
   call msDisplay( 0.0d0, "exact answer" )

   print "(/,A)", "*** test number 18 ***"
   print "()"
   print *, "integration of '1/(x+1)/sqrt(x)' over [0,+Inf]:"
   call msQuad( mfOut(x,abs_err,status,fct_eval),                       &
                fun_which_gives_pi, 0.0d0, +MF_INF )
   call msDisplay( x, "numerical result", abs_err, "estimated error" )
   call msDisplay( fct_eval, "nb of fct evaluation", status, "returned status" )
   call msDisplay( MF_PI, "exact answer" )

   ! mfDblQuad ---------------------------------------------------------
   call print_separation("mfDblQuad")

   print "(/,A)", "*** test number 19 ***"
   print "()"
   print *, "integration of 'x+y' over [0,1]x[0,1] with rel. tol=1.0d-6:"
   x = mfDblQuad( fun_2_lin, 0.0d0, 1.0d0, 0.0d0, 1.0d0, rel_tol=1.0d-6 )
   call msFormat( "long" )
   call msDisplay( x, "numerical result" )
   call msDisplay( 1.0d0, "exact answer" )
   call msFormat( "short" )

   print "(/,A)", "*** test number 20 ***"
   print "()"
   print *, "integration of 'exp(-x**2-y**2)' over [-1,1]x[-1,1] with rel. tol=1.0d-6:"
   x = mfDblQuad( fun_2_exp, -1.0d0, 1.0d0, -1.0d0, 1.0d0, rel_tol=1.0d-6 )
   call msFormat( "long" )
   call msDisplay( x, "numerical result" )
   call msDisplay( MF_PI*erf(1.0d0)**2, "exact answer" )
   call msFormat( "short" )

   print "(/,A)", "*** test number 21 ***"
   print "()"
   print *, "integration of 'sqrt(x**2+y**2)' over [0,1]x[0,1] with rel. tol=1.0d-6:"
   x = mfDblQuad( fun_2_sqrt, 0.0d0, 1.0d0, 0.0d0, 1.0d0, rel_tol=1.0d-6 )
   call msFormat( "long" )
   call msDisplay( x, "numerical result" )
   call msDisplay( 7.65195715841183d-01, "exact answer" )
   call msFormat( "short" )

   print "(/,A)", "*** test number 22 ***"
   print "()"
   print *, "integration of a function with x-range depending on y:"
   x = mfDblQuad( fun_2_var, fun_xa, fun_xb, 0.0d0, 2.0d0, rel_tol=1.0d-6 )
   call msFormat( "long" )
   call msDisplay( x, "numerical result" )
   call msDisplay( 20.0d0/3.0d0*sin(8.0d0), "exact answer" )
   call msFormat( "short" )

   print "(/,A)", "*** test number 23 ***"
   print "()"
   print *, "integration of a function with y-range depending on x:"
   x = mfDblQuad( fun_2_var, 0.0d0, 2.0d0*sqrt(2.0d0), fun_ya, fun_yb, fun_y=.true., &
                  rel_tol=1.0d-6 )
   call msFormat( "long" )
   call msDisplay( x, "numerical result" )
   call msDisplay( 20.0d0/3.0d0*sin(8.0d0), "exact answer" )
   call msFormat( "short" )

   ! msDblQuad ---------------------------------------------------------
   call print_separation("msDblQuad")

   print "(/,A)", "*** test number 24 ***"
   print "()"
   print *, "integration of 'x+y' over [0,1][0,1]x[0,1] with rel. tol=1.0d-6:"
   call msDblQuad( mfOut(x,abs_err,status,fct_eval), fun_2_lin,         &
                   0.0d0, 1.0d0, 0.0d0, 1.0d0, rel_tol=1.0d-6 )
   call msDisplay( x, "numerical result" )
   call check_small( abs_err, "estimated error", 1.0d-12 )
   call msDisplay( fct_eval, "nb of fct evaluation", status, "returned status" )
   y = 1.0d0
   call msDisplay( y, "exact answer", mfAbs(x-y)/y, "relat. error" )

   print "(/,A)", "*** test number 25 ***"
   print "()"
   print *, "integration of 'exp(-x**2-y**2)' over [-1,1]x[-1,1] with rel. tol=1.0d-6:"
   call msDblQuad( mfOut(x,abs_err,status,fct_eval), fun_2_exp,         &
                   -1.0d0, 1.0d0, -1.0d0, 1.0d0, rel_tol=1.0d-6 )
   call msDisplay( x, "numerical result" )
   call check_small( abs_err, "estimated error", 1.0d-7 )
   call msDisplay( fct_eval, "nb of fct evaluation", status, "returned status" )
   y = MF_PI*erf(1.0d0)**2
   call msDisplay( y, "exact answer", mfAbs(x-y)/y, "relat. error" )

   print "(/,A)", "*** test number 26 ***"
   print "()"
   print *, "integration of 'sqrt(x**2+y**2)' over [0,1]x[0,1] with rel. tol=1.0d-6:"
   call msDblQuad( mfOut(x,abs_err,status,fct_eval), fun_2_sqrt,        &
                   0.0d0, 1.0d0, 0.0d0, 1.0d0, rel_tol=1.0d-6 )
   call msDisplay( x, "numerical result" )
   call check_small( abs_err, "estimated error", 1.0d-6 )
   call msDisplay( fct_eval, "nb of fct evaluation", status, "returned status" )
   y = 7.65195715841183d-01
   call msDisplay( y, "exact answer", mfAbs(x-y)/y, "relat. error" )

   print "(/,A)", "*** test number 27 ***"
   print "()"
   print *, "integration of a function with x-range depending on y:"
   call msDblQuad( mfOut(x,abs_err,status,fct_eval), fun_2_var,         &
                   fun_xa, fun_xb, 0.0d0, 2.0d0, rel_tol=1.0d-6 )
   call msDisplay( x, "numerical result" )
   call check_small( abs_err, "estimated error", 1.0d-6 )
   call msDisplay( fct_eval, "nb of fct evaluation", status, "returned status" )
   y = 20.0d0/3.0d0*sin(8.0d0)
   call msDisplay( y, "exact answer", mfAbs(x-y)/y, "relat. error" )

   print "(/,A)", "*** test number 28 ***"
   print "()"
   print *, "integration of a function with y-range depending on x:"
   call msDblQuad( mfOut(x,abs_err,status,fct_eval), fun_2_var,         &
                   0.0d0, 2.0d0*sqrt(2.0d0), fun_ya, fun_yb, fun_y=.true., &
                   rel_tol=1.0d-6 )
   call msDisplay( x, "numerical result" )
   call check_small( abs_err, "estimated error", 1.0d-6 )
   call msDisplay( fct_eval, "nb of fct evaluation", status, "returned status" )
   y = 20.0d0/3.0d0*sin(8.0d0)
   call msDisplay( y, "exact answer", mfAbs(x-y)/y, "relat. error" )

   ! mfOdeSolve --------------------------------------------------------
   call print_separation("mfOdeSolve")

   ! default method : Runge-Kutta Fehlberg
   print "(/,' ----- ',A,' -----',/)",                                  &
         "default method: Runge-Kutta Fehlberg"

   print "(/,A)", "*** test number 29 ***"
   print "()"
   print *, "integration of {y'' = - y} over [0,2*pi]:"
   print *, "(the default tolerance, 1e-3, is not very stringent)"
   print *, "  [ solution is: y(t) = sin(t) ]"
   t_0 = 0.0d0
   t_end = 2.0d0*MF_PI
   t_span = .t. mf( [ t_0, t_end ] )
   y = [ sin(t_0), cos(t_0) ]
   ! without any option (tol not very stringent)
   y_end = mfOdeSolve( deriv, t_span, y )
   x = [ sin(t_end), cos(t_end) ]
   call msDisplay( x, "exact answer" )
   call msDisplay( y_end, "numerical result" )
   call msDisplay( mfNorm(mfAbs(x-y_end))/mfNorm(x), "relat. error" )

   print "(/,A)", "*** test number 30 ***"
   print "()"
   print *, "integration of {y'' = - y} over [0,2*pi]:"
   print *, "  [ solution is: y(t) = sin(t) ]"
   t_0 = 0.0d0
   t_end = 2.0d0*MF_PI
   t_span = .t. mf( [ t_0, t_end ] )
   y = [ sin(t_0), cos(t_0) ]
   call msRelease(options_DE)
   options_DE%tol = 1.0d-6
   y_end = mfOdeSolve( deriv, t_span, y, options_DE )
   x = [ sin(t_end), cos(t_end) ]
   call msDisplay( x, "exact answer" )
   call msDisplay( y_end, "numerical result" )
   call msDisplay( mfNorm(mfAbs(x-y_end))/mfNorm(x), "relat. error" )

   print "(/,A)", "*** test number 31 ***"
   print "()"
   print *, "  [ same with intermediate output ]"
   t_span = .t. mfLinSpace( t_0, t_end, 20 )
   y = [ sin(t_0), cos(t_0) ]
   call msRelease(options_DE)
   options_DE%tol = 1.0d-6
   y_out = mfOdeSolve( deriv, t_span, y, options_DE )
   x = mfSin(t_span) .hc. mfCos(t_span)
   call msDisplay( x, "exact answer" )
   call msDisplay( y_out, "numerical result" )
   call msDisplay( mfNorm(mfAbs(x-y_out))/mfNorm(x), "relat. error" )

   print "(/,A)", "*** test number 32 ***"
   print "()"
   print *, "  [ rtol is too small => warning emitted]"
   t_span = .t. mfLinSpace( t_0, t_end, 20 )
   y = [ sin(t_0), cos(t_0) ]
   call msRelease(options_DE)
   options_DE%tol = 0.0d0
   y_out = mfOdeSolve( deriv, t_span, y, options_DE )
   x = mfSin(t_span) .hc. mfCos(t_span)
   call msDisplay( x, "exact answer" )
   call msDisplay( y_out, "numerical result" )
   call msDisplay( mfNorm(mfAbs(x-y_out))/mfNorm(x), "relat. error" )

   print "(/,A)", "*** test number 33 ***"
   print "()"
   print *, "integration of {y' =  2*t}"
   print *, '               with the "Illegal condition" : 1 < y'
   print *, "  [ solution is: y(t) = t**2 ]"
   t_0 = 0.0d0
   t_end = 2.0d0
   t_span = .t. mf( [ t_0, t_end ] )
   call msDisplay( t_span, "input t_span" )
   y_0 = [ 0.0d0 ]
   y = mfOdeSolve( deriv_illegal_condition, t_span, y_0 )
   call msDisplay( t_span, "output t_span" )
   call msDisplay( y, "numerical result" )

   print "(/,A)", "*** test number 34 ***"
   print "()"
   print *, "integration of {y' =  2*t}"
   print *, '               with the "Illegal condition" : 1 < y'
   print *, "  [ solution is: y(t) = t**2 ]"
   t_0 = 0.0d0
   t_end = 2.0d0
   t_span = .t. mfLinSpace( t_0, t_end, 21 )
   call msDisplay( t_span, "input t_span" )
   y_0 = [ 0.0d0 ]
   y = mfOdeSolve( deriv_illegal_condition, t_span, y_0 )
   ! find the first row containing NaNs
   k = size(t_span)
   do i = 1, size(t_span)
      if( all(mfIsNaN( mfGet(t_span,i) )) ) then
         k = i - 1
         exit
      end if
   end do
   y_out = mfGet(t_span,1 .to. k) .hc. mfGet(y,1 .to. k)
   call msDisplay( y_out, "    time        y" )

   print "(/,A)", "*** test number 35 ***"
   print "()"
   print *, "integration of {y' =  2*t}"
   print *, '               with the "Emergency exit" : 1 < y'
   print *, "  [ solution is: y(t) = t**2 ]"
   t_0 = 0.0d0
   t_end = 2.0d0
   t_span = .t. mf( [ t_0, t_end ] )
   call msDisplay( t_span, "input t_span" )
   y_0 = [ 0.0d0 ]
   y = mfOdeSolve( deriv_emergency_exit, t_span, y_0 )
   call msDisplay( t_span, "output t_span" )
   call msDisplay( y, "numerical result" )

   print "(/,A)", "*** test number 36 ***"
   print "()"
   print *, "integration of {y' =  2*t}"
   print *, '               with the "Emergency exit" : 1 < y'
   print *, "  [ solution is: y(t) = t**2 ]"
   t_0 = 0.0d0
   t_end = 2.0d0
   t_span = .t. mfLinSpace( t_0, t_end, 21 )
   call msDisplay( t_span, "input t_span" )
   y_0 = [ 0.0d0 ]
   y = mfOdeSolve( deriv_emergency_exit, t_span, y_0 )
   ! find the first row containing NaNs
   k = size(t_span)
   do i = 1, size(t_span)
      if( all(mfIsNaN( mfGet(t_span,i) )) ) then
         k = i - 1
         exit
      end if
   end do
   y_out = mfGet(t_span,1 .to. k) .hc. mfGet(y,1 .to. k)
   call msDisplay( y_out, "    time        y" )

   print "(/,A)", "*** test number 37 ***"
   print "()"
   print *, "integration of {y' =  2*t}"
   print *, '               with the "End condition" : 1 < y'
   print *, "  [ solution is: y(t) = t**2 ]"
   t_0 = 0.0d0
   t_end = 2.0d0
   t_span = .t. mf( [ t_0, t_end ] )
   call msDisplay( t_span, "input t_span" )
   y_0 = [ 0.0d0 ]
   y = mfOdeSolve( deriv_end_condition, t_span, y_0 )
   call msDisplay( t_span, "output t_span" )
   call msDisplay( y, "numerical result" )

   print "(/,A)", "*** test number 38 ***"
   print "()"
   print *, "integration of {y' =  2*t}"
   print *, '               with the "End condition" : 1 < y'
   print *, "  [ solution is: y(t) = t**2 ]"
   t_0 = 0.0d0
   t_end = 2.0d0
   t_span = .t. mfLinSpace( t_0, t_end, 21 )
   call msDisplay( t_span, "input t_span" )
   y_0 = [ 0.0d0 ]
   y = mfOdeSolve( deriv_end_condition, t_span, y_0 )
   ! find the first row containing NaNs
   k = size(t_span)
   do i = 1, size(t_span)
      if( all(mfIsNaN( mfGet(t_span,i) )) ) then
         k = i - 1
         exit
      end if
   end do
   y_out = mfGet(t_span,1 .to. k) .hc. mfGet(y,1 .to. k)
   call msDisplay( y_out, "    time        y" )

   print "(/,A)", "*** test number 39 ***"
   print "()"
   print *, "integration of {y' =  2*t}"
   print *, '               with the "Combined condition" : 0.99 <= y <= 1.01'
   print *, "  [ solution is: y(t) = t**2 ]"
   t_0 = 0.0d0
   t_end = 2.0d0
   t_span = .t. mf( [ t_0, t_end ] )
   call msDisplay( t_span, "input t_span" )
   y_0 = [ 0.0d0 ]
   y = mfOdeSolve( deriv_combined_conditions, t_span, y_0 )
   call msDisplay( t_span, "output t_span" )
   call msDisplay( y, "numerical result" )

   print "(/,A)", "*** test number 40 ***"
   print "()"
   print *, "integration of {y' =  2*t}"
   print *, '               with the "Combined condition" : 0.99 <= y <= 1.01'
   print *, "  [ solution is: y(t) = t**2 ]"
   t_0 = 0.0d0
   t_end = 2.0d0
   t_span = .t. mfLinSpace( t_0, t_end, 21 )
   call msDisplay( t_span, "input t_span" )
   y_0 = [ 0.0d0 ]
   y = mfOdeSolve( deriv_combined_conditions, t_span, y_0 )
   ! find the first row containing NaNs
   k = size(t_span)
   do i = 1, size(t_span)
      if( all(mfIsNaN( mfGet(t_span,i) )) ) then
         k = i - 1
         exit
      end if
   end do
   y_out = mfGet(t_span,1 .to. k) .hc. mfGet(y,1 .to. k)
   call msDisplay( y_out, "    time        y" )

   ! Adams-BashForth-Moulton
   print "(/,' ----- ',A,' -----',/)",                                  &
         "Adams-BashForth-Moulton"

   print "(/,A)", "*** test number 41 ***"
   print "()"
   print *, "integration of {y'' = - y} over [0,2*pi]:"
   print *, "  [ solution is: y(t) = sin(t) ]"
   t_0 = 0.0d0
   t_end = 2.0d0*MF_PI
   t_span = .t. mf( [ t_0, t_end ] )
   y = [ sin(t_0), cos(t_0) ]
   call msRelease(options_DE)
   options_DE%tol = 1.0d-6
   options_DE%method="ABM"
   y_end = mfOdeSolve( deriv, t_span, y, options_DE )
   x = [ sin(t_end), cos(t_end) ]
   call msDisplay( x, "exact answer" )
   call msDisplay( y_end, "numerical result" )
   call msDisplay( mfNorm(mfAbs(x-y_end))/mfNorm(x), "relat. error" )

   print "(/,A)", "*** test number 42 ***"
   print "()"
   print *, "  [ same with intermediate output ]"
   t_span = .t. mfLinSpace( t_0, t_end, 20 )
   y = [ sin(t_0), cos(t_0) ]
   call msRelease(options_DE)
   options_DE%tol = 1.0d-6
   options_DE%method="ABM"
   y_out = mfOdeSolve( deriv, t_span, y, options_DE )
   x = mfSin(t_span) .hc. mfCos(t_span)
   call msDisplay( x, "exact answer" )
   call msDisplay( y_out, "numerical result" )
   call msDisplay( mfNorm(mfAbs(x-y_out))/mfNorm(x), "relat. error" )

   ! Backward Differentiation Formula (Finite Diff. Jacobian)
   print "(/,' ----- ',A,' -----',/)",                                  &
         "Backward Differentiation Formula (Finite Diff. Jacobian)"

   print "(/,A)", "*** test number 43 ***"
   print "()"
   print *, "integration of {y'' = - y} over [0,2*pi]:"
   print *, "  [ solution is: y(t) = sin(t) ]"
   t_0 = 0.0d0
   t_end = 2.0d0*MF_PI
   t_span = .t. mf( [ t_0, t_end ] )
   y = [ sin(t_0), cos(t_0) ]
   call msRelease(options_DE)
   options_DE%tol = 1.0d-6
   options_DE%method="BDF"
   y_end = mfOdeSolve( deriv, t_span, y, options_DE )
   x = [ sin(t_end), cos(t_end) ]
   call msDisplay( x, "exact answer" )
   call msDisplay( y_end, "numerical result" )
   call msDisplay( mfNorm(mfAbs(x-y_end))/mfNorm(x), "relat. error" )

   print "(/,A)", "*** test number 44 ***"
   print "()"
   print *, "  [ same with intermediate output ]"
   t_span = .t. mfLinSpace( t_0, t_end, 20 )
   y = [ sin(t_0), cos(t_0) ]
   call msRelease(options_DE)
   options_DE%tol = 1.0d-6
   options_DE%method="BDF"
   y_out = mfOdeSolve( deriv, t_span, y, options_DE )
   x = mfSin(t_span) .hc. mfCos(t_span)
   call msDisplay( x, "exact answer" )
   call msDisplay( y_out, "numerical result" )
   call msDisplay( mfNorm(mfAbs(x-y_out))/mfNorm(x), "relat. error" )

   ! Backward Differentiation Formula (User's Jacobian routine)
   print "(/,' ----- ',A,' -----',/)",                                  &
         "Backward Differentiation Formula (User's Jacobian routine)"

   ! DENSE case
   print *, "*** DENSE case ***"

   print "(/,A)", "*** test number 45 ***"
   print "()"
   print *, "integration of {y'' = - y} over [0,2*pi]:"
   print *, "  [ solution is: y(t) = sin(t) ]"
   t_0 = 0.0d0
   t_end = 2.0d0*MF_PI
   t_span = .t. mf( [ t_0, t_end ] )
   y = [ sin(t_0), cos(t_0) ]
   call msRelease(options_DE)
   options_DE%tol = 1.0d-6
   options_DE%method="BDF"
   y_end = mfOdeSolve( deriv, t_span, y, options_DE, jac=jac )
   x = [ sin(t_end), cos(t_end) ]
   call msDisplay( x, "exact answer" )
   call msDisplay( y_end, "numerical result" )
   call msDisplay( mfNorm(mfAbs(x-y_end))/mfNorm(x), "relat. error" )

   print "(/,A)", "*** test number 46 ***"
   print "()"
   print *, "integration of {y'' = - y} over [0,2*pi]:"
   print *, "  [ solution is: y(t) = sin(t) ]"
   print *, "(jacobian provided, quick check)"
   t_0 = 0.0d0
   t_end = 2.0d0*MF_PI
   t_span = .t. mf( [ t_0, t_end ] )
   y = [ sin(t_0), cos(t_0) ]
   call msRelease(options_DE)
   options_DE%tol = 1.0d-6
   options_DE%method="BDF"
   options_DE%check_jac=1
!!   options_DE%print_check_jac = 1
   y_end = mfOdeSolve( deriv, t_span, y, options_DE, jac=jac )
   x = [ sin(t_end), cos(t_end) ]
   call msDisplay( x, "exact answer" )
   call msDisplay( y_end, "numerical result" )
   call msDisplay( mfNorm(mfAbs(x-y_end))/mfNorm(x), "relat. error" )

   print "(/,A)", "*** test number 47 ***"
   print "()"
   print *, "integration of {y'' = - y} over [0,2*pi]:"
   print *, "  [ solution is: y(t) = sin(t) ]"
   print *, "(jacobian provided, full check)"
   t_0 = 0.0d0
   t_end = 2.0d0*MF_PI
   t_span = .t. mf( [ t_0, t_end ] )
   y = [ sin(t_0), cos(t_0) ]
   call msRelease(options_DE)
   options_DE%tol = 1.0d-6
   options_DE%method="BDF"
   options_DE%check_jac=2
!!   options_DE%print_check_jac = 1
   y_end = mfOdeSolve( deriv, t_span, y, options_DE, jac=jac )
   x = [ sin(t_end), cos(t_end) ]
   call msDisplay( x, "exact answer" )
   call msDisplay( y_end, "numerical result" )
   call msDisplay( mfNorm(mfAbs(x-y_end))/mfNorm(x), "relat. error" )

   print "(/,A)", "*** test number 48 ***"
   print "()"
   print *, "  [ same with intermediate output ]"
   t_span = .t. mfLinSpace( t_0, t_end, 20 )
   y = [ sin(t_0), cos(t_0) ]
   call msRelease(options_DE)
   options_DE%tol = 1.0d-6
   options_DE%method="BDF"
   y_out = mfOdeSolve( deriv, t_span, y, options_DE, jac=jac )
   x = mfSin(t_span) .hc. mfCos(t_span)
   call msDisplay( x, "exact answer" )
   call msDisplay( y_out, "numerical result" )
   call msDisplay( mfNorm(mfAbs(x-y_out))/mfNorm(x), "relat. error" )

   ! SPARSE case
   print *, "*** SPARSE case ***"

   print "(/,A)", "*** test number 49 ***"
   print "()"
   print *, "integration of {y'' = - y} over [0,2*pi]:"
   print *, "  [ solution is: y(t) = sin(t) ]"
   t_0 = 0.0d0
   t_end = 2.0d0*MF_PI
   t_span = .t. mf( [ t_0, t_end ] )
   y = [ sin(t_0), cos(t_0) ]
   call msRelease(options_DE)
   options_DE%tol = 1.0d-6
   options_DE%method="BDF"
   y_end = mfOdeSolve( deriv, t_span, y, options_DE, jac=spjac, sparse=.true. )
   x = [ sin(t_end), cos(t_end) ]
   call msDisplay( x, "exact answer" )
   call msDisplay( y_end, "numerical result" )
   call msDisplay( mfNorm(mfAbs(x-y_end))/mfNorm(x), "relat. error" )

   print "(/,A)", "*** test number 50 ***"
   print "()"
   print *, "  [ same with intermediate output ]"
   t_span = .t. mfLinSpace( t_0, t_end, 20 )
   y = [ sin(t_0), cos(t_0) ]
   call msRelease(options_DE)
   options_DE%tol = 1.0d-6
   options_DE%method="BDF"
   y_out = mfOdeSolve( deriv, t_span, y, options_DE, jac=spjac, sparse=.true. )
   x = mfSin(t_span) .hc. mfCos(t_span)
   call msDisplay( x, "exact answer" )
   call msDisplay( y_out, "numerical result" )
   call msDisplay( mfNorm(mfAbs(x-y_out))/mfNorm(x), "relat. error" )

   print "(/,A)", "*** test number 51 ***"
   print "()"
   print *, "integration of {y' =  2*t}"
   print *, '               with the "End condition" : 1 < y'
   print *, "  [ solution is: y(t) = t**2 ]"
   t_0 = 0.0d0
   t_end = 12.0d0
   t_span = .t. mf( [ t_0, t_end ] )
   call msDisplay( t_span, "input t_span" )
   y_0 = [ 0.0d0 ]
   call msRelease(options_DE)
   options_DE%tol = 1.0d-6
   options_DE%method="BDF"
   y = mfOdeSolve( deriv_end_condition, t_span, y_0, options_DE )
   call msDisplay( t_span, "output t_span" )
   call msDisplay( y, "numerical result" )

   print "(/,A)", "*** test number 52 ***"
   print "()"
   print *, "integration of {y' =  2*t}"
   print *, '               with the "End condition" : 1 < y'
   print *, "  [ solution is: y(t) = t**2 ]"
   t_0 = 0.0d0
   t_end = 2.0d0
   t_span = .t. mf( [ t_0, t_end ] )
   call msDisplay( t_span, "input t_span" )
   y_0 = [ 0.0d0 ]
   call msRelease(options_DE)
   options_DE%tol = 1.0d-6
   options_DE%method="BDF"
   y = mfOdeSolve( deriv_end_condition, t_span, y_0, options_DE )
   call msDisplay( t_span, "output t_span" )
   call msDisplay( y, "numerical result" )

   print "(/,A)", "*** test number 53 ***"
   print "()"
   print *, "integration of {y' =  2*t}"
   print *, '               with the "End condition" : 1 < y'
   print *, "  [ solution is: y(t) = t**2 ]"
   t_0 = 0.0d0
   t_end = 12.0d0
   t_span = .t. mfLinSpace( t_0, t_end, 21 )
   call msDisplay( t_span, "input t_span" )
   y_0 = [ 0.0d0 ]
   call msRelease(options_DE)
   options_DE%tol = 1.0d-6
   options_DE%method="BDF"
   y = mfOdeSolve( deriv_end_condition, t_span, y_0, options_DE )
   ! find the first row containing NaNs
   k = size(t_span)
   do i = 1, size(t_span)
      if( all(mfIsNaN( mfGet(t_span,i) )) ) then
         k = i - 1
         exit
      end if
   end do
   y_out = mfGet(t_span,1 .to. k) .hc. mfGet(y,1 .to. k)
   call msFormat( exponent="sci" )
   call msDisplay( y_out, "    time        y" )
   call msFormat( )

   print "(/,A)", "*** test number 54 ***"
   print "()"
   print *, "integration of {y' =  2*t}"
   print *, '               with the "End condition" : 1 < y'
   print *, "  [ solution is: y(t) = t**2 ]"
   t_0 = 0.0d0
   t_end = 2.0d0
   t_span = .t. mfLinSpace( t_0, t_end, 21 )
   call msDisplay( t_span, "input t_span" )
   y_0 = [ 0.0d0 ]
   call msRelease(options_DE)
   options_DE%tol = 1.0d-6
   options_DE%method="BDF"
   y = mfOdeSolve( deriv_end_condition, t_span, y_0, options_DE )
   ! find the first row containing NaNs
   k = size(t_span)
   do i = 1, size(t_span)
      if( all(mfIsNaN( mfGet(t_span,i) )) ) then
         k = i - 1
         exit
      end if
   end do
   y_out = mfGet(t_span,1 .to. k) .hc. mfGet(y,1 .to. k)
   call msFormat( exponent="sci" )
   call msDisplay( y_out, "    time        y" )
   call msFormat( )

   print "(/,A)", "*** test number 55 ***"
   print "()"
   print *, "integration of {y' =  2*t}"
   print *, '               with the "Illegal condition" : 1 < y'
   print *, "  [ solution is: y(t) = t**2 ]"
   t_0 = 0.0d0
   t_end = 2.0d0
   t_span = .t. mf( [ t_0, t_end ] )
   call msDisplay( t_span, "input t_span" )
   y_0 = [ 0.0d0 ]
   call msRelease(options_DE)
   options_DE%method="BDF"
   y = mfOdeSolve( deriv_illegal_condition, t_span, y_0, options_DE )
   call msDisplay( t_span, "output t_span" )
   call msDisplay( y, "numerical result" )

   print "(/,A)", "*** test number 56 ***"
   print "()"
   print *, "integration of {y' =  2*t}"
   print *, '               with the "Illegal condition" : 1 < y'
   print *, "  [ solution is: y(t) = t**2 ]"
   t_0 = 0.0d0
   t_end = 2.0d0
   t_span = .t. mfLinSpace( t_0, t_end, 21 )
   call msDisplay( t_span, "input t_span" )
   y_0 = [ 0.0d0 ]
   call msRelease(options_DE)
   options_DE%method="BDF"
   y = mfOdeSolve( deriv_illegal_condition, t_span, y_0, options_DE )
   ! find the first row containing NaNs
   k = size(t_span)
   do i = 1, size(t_span)
      if( all(mfIsNaN( mfGet(t_span,i) )) ) then
         k = i - 1
         exit
      end if
   end do
   y_out = mfGet(t_span,1 .to. k) .hc. mfGet(y,1 .to. k)
   call msFormat( exponent="sci" )
   call msDisplay( y_out, "    time        y" )
   call msFormat( )

   print "(/,A)", "*** test number 57 ***"
   print "()"
   print *, "integration of {y' =  2*t}"
   print *, '               with the "Emergency exit" : 1 < y'
   print *, "  [ solution is: y(t) = t**2 ]"
   t_0 = 0.0d0
   t_end = 2.0d0
   t_span = .t. mf( [ t_0, t_end ] )
   call msDisplay( t_span, "input t_span" )
   y_0 = [ 0.0d0 ]
   call msRelease(options_DE)
   options_DE%method="BDF"
   y = mfOdeSolve( deriv_emergency_exit, t_span, y_0, options_DE )
   call msDisplay( t_span, "output t_span" )
   call msDisplay( y, "numerical result" )

   print "(/,A)", "*** test number 58 ***"
   print "()"
   print *, "integration of {y' =  2*t}"
   print *, '               with the "Emergency exit" : 1 < y'
   print *, "  [ solution is: y(t) = t**2 ]"
   t_0 = 0.0d0
   t_end = 2.0d0
   t_span = .t. mfLinSpace( t_0, t_end, 21 )
   call msDisplay( t_span, "input t_span" )
   y_0 = [ 0.0d0 ]
   call msRelease(options_DE)
   options_DE%method="BDF"
   y = mfOdeSolve( deriv_emergency_exit, t_span, y_0, options_DE )
   ! find the first row containing NaNs
   k = size(t_span)
   do i = 1, size(t_span)
      if( all(mfIsNaN( mfGet(t_span,i) )) ) then
         k = i - 1
         exit
      end if
   end do
   y_out = mfGet(t_span,1 .to. k) .hc. mfGet(y,1 .to. k)
   call msFormat( exponent="sci" )
   call msDisplay( y_out, "    time        y" )
   call msFormat( )

   print "(/,A)", "*** test number 59 ***"
   print "()"
   print *, "integration of {y' =  (3/2)*sqrt(t)}"
   print *, '               with the "Emergency exit" : 1 < y'
   print *, "  [ solution is: y(t) = t**(3/2) ]"
   t_0 = 0.0d0
   t_end = 2.0d0
   t_span = .t. mf( [ t_0, t_end ] )
   call msDisplay( t_span, "input t_span" )
   y_0 = [ 0.0d0 ]
   call msRelease(options_DE)
   options_DE%method="BDF"
   y = mfOdeSolve( deriv_emergency_exit_2, t_span, y_0, options_DE )
   call msDisplay( t_span, "output t_span" )
   call msDisplay( y, "numerical result" )

   print "(/,A)", "*** test number 60 ***"
   print "()"
   print *, "integration of {y' =  (3/2)*sqrt(t)}"
   print *, '               with the "Emergency exit" : 1 < y'
   print *, "  [ solution is: y(t) = t**(3/2) ]"
   t_0 = 0.0d0
   t_end = 2.0d0
   t_span = .t. mfLinSpace( t_0, t_end, 21 )
   call msDisplay( t_span, "input t_span" )
   y_0 = [ 0.0d0 ]
   call msRelease(options_DE)
   options_DE%method="BDF"
   y = mfOdeSolve( deriv_emergency_exit_2, t_span, y_0, options_DE )
   ! find the first row containing NaNs
   k = size(t_span)
   do i = 1, size(t_span)
      if( all(mfIsNaN( mfGet(t_span,i) )) ) then
         k = i - 1
         exit
      end if
   end do
   y_out = mfGet(t_span,1 .to. k) .hc. mfGet(y,1 .to. k)
   call msFormat( exponent="sci" )
   call msDisplay( y_out, "    time        y" )
   call msFormat( )

   print "(/,A)", "*** test number 61 ***"
   print "()"
   print *, "integration of {y' =  2*t}"
   print *, '               with the "Combined condition" : 0.99 <= y <= 1.01'
   print *, "  [ solution is: y(t) = t**2 ]"
   t_0 = 0.0d0
   t_end = 2.0d0
   t_span = .t. mf( [ t_0, t_end ] )
   call msDisplay( t_span, "input t_span" )
   y_0 = [ 0.0d0 ]
   call msRelease(options_DE)
   options_DE%method="BDF"
   y = mfOdeSolve( deriv_combined_conditions, t_span, y_0, options_DE )
   call msDisplay( t_span, "output t_span" )
   call msDisplay( y, "numerical result" )

   print "(/,A)", "*** test number 62 ***"
   print "()"
   print *, "integration of {y' =  2*t}"
   print *, '               with the "Combined condition" : 0.99 <= y <= 1.01'
   print *, "  [ solution is: y(t) = t**2 ]"
   t_0 = 0.0d0
   t_end = 2.0d0
   t_span = .t. mfLinSpace( t_0, t_end, 21 )
   call msDisplay( t_span, "input t_span" )
   y_0 = [ 0.0d0 ]
   call msRelease(options_DE)
   options_DE%method="BDF"
   y = mfOdeSolve( deriv_combined_conditions, t_span, y_0, options_DE )
   ! find the first row containing NaNs
   k = size(t_span)
   do i = 1, size(t_span)
      if( all(mfIsNaN( mfGet(t_span,i) )) ) then
         k = i - 1
         exit
      end if
   end do
   y_out = mfGet(t_span,1 .to. k) .hc. mfGet(y,1 .to. k)
   call msFormat( exponent="sci" )
   call msDisplay( y_out, "    time        y" )
   call msFormat( )

   ! msOdeSolve --------------------------------------------------------
   call print_separation("msOdeSolve")

   ! default method : Runge-Kutta Fehlberg
   print "(/,' ----- ',A,' -----',/)",                                  &
         "default method : Runge-Kutta Fehlberg"

   print "(/,A)", "*** test number 63 ***"
   print "()"
   print *, "integration of {y'' = - y} over [0,2*pi]:"
   print *, "  [ solution is: y(t) = sin(t) ]"
   t_0 = 0.0d0
   t_end = 2.0d0*MF_PI
   t_span = .t. mf( [ t_0, t_end ] )
   y = [ sin(t_0), cos(t_0) ]
   call msRelease(options_DE)
   options_DE%tol = 1.0d-6
   call msOdeSolve( mfOut(y_end,status),                                &
                    deriv, t_span, y, options_DE )
   x = [ sin(t_end), cos(t_end) ]
   call msDisplay( x, "exact answer" )
   call msDisplay( y_end, "numerical result" )
   call msDisplay( mfNorm(mfAbs(x-y_end))/mfNorm(x), "relat. error" )
   call msDisplay( status, "returned status" )

   print "(/,A)", "*** test number 64 ***"
   print "()"
   print *, "  [ same with intermediate output ]"
   t_span = .t. mfLinSpace( t_0, t_end, 20 )
   y = [ sin(t_0), cos(t_0) ]
   call msRelease(options_DE)
   options_DE%tol = 1.0d-6
   call msOdeSolve( mfOut(y_out,status),                                &
                    deriv, t_span, y, options_DE )
   x = mfSin(t_span) .hc. mfCos(t_span)
   call msDisplay( x, "exact answer" )
   call msDisplay( y_out, "numerical result" )
   call msDisplay( mfNorm(mfAbs(x-y_out))/mfNorm(x), "relat. error" )
   call msDisplay( status, "returned status" )

   print "(/,A)", "*** test number 65 ***"
   print "()"
   print *, "integration of {y'' = - y} over [0,2*pi]:"
   print *, "  [ solution is: y(t) = sin(t) ]"
   t_0 = 0.0d0
   t_end = 2.0d0*MF_PI
   t_span = .t. mf( [ t_0, t_end ] )
   y = [ sin(t_0), cos(t_0) ]
   call msRelease(options_DE)
   options_DE%tol = 1.0d-6
   call msOdeSolve( mfOut(y_end,status,new_err),                        &
                    deriv, t_span, y, options_DE )
   x = [ sin(t_end), cos(t_end) ]
   call msDisplay( x, "exact answer" )
   call msDisplay( y_end, "numerical result" )
   call msDisplay( mfNorm(mfAbs(x-y_end))/mfNorm(x), "relat. error" )
   call msDisplay( status, "returned status" )
   if( mfDble(status) == dble(-2) ) then
      call msDisplay( new_err, "new optim. error" )
   else
      print *, "imposed relat. error was acceptable."
   end if

   print "(/,A)", "*** test number 66 ***"
   print "()"
   print *, "integration of {y'' = - y} over [0,2*pi]:"
   print *, "  [ solution is: y(t) = sin(t) ]"
   t_0 = 0.0d0
   t_end = 2.0d0*MF_PI
   t_span = .t. mf( [ t_0, t_end ] )
   y = [ sin(t_0), cos(t_0) ]
   call msRelease(options_DE)
   options_DE%tol = 1.0d-6
   call msOdeSolve( mfOut(y_end,status,new_err,yp,solve_log),           &
                    deriv, t_span, y, options_DE )
   call msDisplay( y_end, "numerical result" )
   call msDisplay( yp, "deriv. of y" )
   call msDisplay( status, "returned status" )
   call msDisplay( mfGet(solve_log,1), "[statistics] nb_step" )
   call msDisplay( mfGet(solve_log,2), "[statistics] dt_min" )
   call msDisplay( mfGet(solve_log,3), "[statistics] dt_max" )
   call msDisplay( mfGet(solve_log,4), "[statistics] nb_deriv" )

   print "(/,A)", "*** test number 67 ***"
   print "()"
   print *, "  [ same with intermediate output ]"
   t_span = .t. mfLinSpace( t_0, t_end, 20 )
   y = [ sin(t_0), cos(t_0) ]
   call msRelease(options_DE)
   options_DE%tol = 1.0d-6
   call msOdeSolve( mfOut(y_end,status,new_err,yp,solve_log),           &
                    deriv, t_span, y, options_DE )
   call msDisplay( y_end, "numerical result" )
   call msDisplay( yp, "deriv. of y" )
   call msDisplay( status, "returned status" )
   call msDisplay( mfGet(solve_log,1), "[statistics] nb_step" )
   call msDisplay( mfGet(solve_log,2), "[statistics] dt_min" )
   call msDisplay( mfGet(solve_log,3), "[statistics] dt_max" )
   call msDisplay( mfGet(solve_log,4), "[statistics] nb_deriv" )

   ! testing MF_NO_ARG
   print "(/,A)", "*** test number 68 ***"
   print "()"
   print *, "  [ same with intermediate output ]"
   t_span = .t. mfLinSpace( t_0, t_end, 20 )
   y = [ sin(t_0), cos(t_0) ]
   call msRelease(options_DE)
   options_DE%tol = 1.0d-6
   call msOdeSolve( mfOut(y_end,status,MF_NO_ARG,MF_NO_ARG,solve_log),  &
                    deriv, t_span, y, options_DE )
   call msDisplay( y_end, "numerical result" )
   call msDisplay( status, "returned status" )
   call msDisplay( mfGet(solve_log,1), "[statistics] nb_step" )
   call msDisplay( mfGet(solve_log,2), "[statistics] dt_min" )
   call msDisplay( mfGet(solve_log,3), "[statistics] dt_max" )
   call msDisplay( mfGet(solve_log,4), "[statistics] nb_deriv" )

   ! testing the output of t_log
   print "(/,A)", "*** test number 69 ***"
   print "()"
   print *, "  [ times along integration process ]"
   t_span = .t. mfLinSpace( t_0, t_end, 20 )
   y = [ sin(t_0), cos(t_0) ]
   call msRelease(options_DE)
   options_DE%tol = 1.0d-6
   call msOdeSolve( mfOut(y_end,status,MF_NO_ARG,MF_NO_ARG,MF_NO_ARG,t_log), &
                    deriv, t_span, y, options_DE )
   call msDisplay( y_end, "numerical result" )
   call msDisplay( status, "returned status" )
   call msDisplay( .t. t_log, "t_log", head=5, tail=5 )

   ! trying a stiff ODE
   print "(/,A)", "*** test number 70 ***"
   print "()"
   print *, "integration of a stiff ODE system from chemical kinetics"
   print *, "  (example of [Sundials/IDA] package)"
   t_0 = 0.0d0
   t_end = 4.0d0
   t_span = .t. mf( [ t_0, t_end ] )
   y = [ 1.0d0, 0.0d0, 0.0d0 ]
   call msRelease(options_DE)
   options_DE%tol = 1.0d-3
   call msOdeSolve( mfOut(y_end,status,new_err,yp,solve_log),           &
                    deriv_chemical, t_span, y, options_DE )

   print "(/,A)", "*** test number 71 ***"
   print "()"
   print *, "integration of {y' =  2*t}"
   print *, '               with the "Illegal condition" : 1 < y'
   print *, "  [ solution is: y(t) = t**2 ]"
   t_0 = 0.0d0
   t_end = 2.0d0
   t_span = .t. mf( [ t_0, t_end ] )
   call msDisplay( t_span, "input t_span" )
   y_0 = [ 0.0d0 ]
   call msRelease(options_DE)
   options_DE%tol = 1.0d-6
   call msOdeSolve( mfOut(y,status,tolout,yp,solve_log),                &
                    deriv_illegal_condition, t_span, y_0, options_DE )
   call msDisplay( status, "returned status" )
   call msDisplay( mfGet(solve_log,1), "[statistics] nb_step" )
   call msDisplay( mfGet(solve_log,2), "[statistics] dt_min" )
   call msDisplay( mfGet(solve_log,3), "[statistics] dt_max" )
   call msDisplay( mfGet(solve_log,4), "[statistics] nb_deriv" )
   call msDisplay( t_span, "output t_span" )
   call msDisplay( y, "numerical result (y)" )
   call msDisplay( yp, "numerical result (yp)" )

   print "(/,A)", "*** test number 72 ***"
   print "()"
   print *, "integration of {y' =  2*t}"
   print *, '               with the "Illegal condition" : 1 < y'
   print *, "  [ solution is: y(t) = t**2 ]"
   t_0 = 0.0d0
   t_end = 2.0d0
   t_span = .t. mfLinSpace( t_0, t_end, 21 )
   call msDisplay( t_span, "input t_span" )
   y_0 = [ 0.0d0 ]
   call msRelease(options_DE)
   options_DE%tol = 1.0d-6
   call msOdeSolve( mfOut(y,status,tolout,yp,solve_log),                &
                    deriv_illegal_condition, t_span, y_0, options_DE )
   call msDisplay( status, "returned status" )
   call msDisplay( mfGet(solve_log,1), "[statistics] nb_step" )
   call msDisplay( mfGet(solve_log,2), "[statistics] dt_min" )
   call msDisplay( mfGet(solve_log,3), "[statistics] dt_max" )
   call msDisplay( mfGet(solve_log,4), "[statistics] nb_deriv" )
   ! find the first row containing NaNs
   k = size(t_span)
   do i = 1, size(t_span)
      if( all(mfIsNaN( mfGet(t_span,i) )) ) then
         k = i - 1
         exit
      end if
   end do
   y_out = mfGet(t_span,1 .to. k) .hc. mfGet(y,1 .to. k)                &
                                  .hc. mfGet(yp,1 .to. k)
   call msDisplay( y_out, "    time        y        yp" )

   print "(/,A)", "*** test number 73 ***"
   print "()"
   print *, "integration of {y' =  2*t}"
   print *, '               with the "Emergency exit" : 1 < y'
   print *, "  [ solution is: y(t) = t**2 ]"
   t_0 = 0.0d0
   t_end = 2.0d0
   t_span = .t. mf( [ t_0, t_end ] )
   call msDisplay( t_span, "input t_span" )
   y_0 = [ 0.0d0 ]
   call msRelease(options_DE)
   options_DE%tol = 1.0d-6
   call msOdeSolve( mfOut(y,status,tolout,yp,solve_log),                &
                    deriv_emergency_exit, t_span, y_0, options_DE )
   call msDisplay( status, "returned status" )
   call msDisplay( mfGet(solve_log,1), "[statistics] nb_step" )
   call msDisplay( mfGet(solve_log,2), "[statistics] dt_min" )
   call msDisplay( mfGet(solve_log,3), "[statistics] dt_max" )
   call msDisplay( mfGet(solve_log,4), "[statistics] nb_deriv" )
   call msDisplay( t_span, "output t_span" )
   call msDisplay( y, "numerical result (y)" )
   call msDisplay( yp, "numerical result (yp)" )

   print "(/,A)", "*** test number 74 ***"
   print "()"
   print *, "integration of {y' =  2*t}"
   print *, '               with the "Emergency exit" : 1 < y'
   print *, "  [ solution is: y(t) = t**2 ]"
   t_0 = 0.0d0
   t_end = 2.0d0
   t_span = .t. mfLinSpace( t_0, t_end, 21 )
   call msDisplay( t_span, "input t_span" )
   y_0 = [ 0.0d0 ]
   call msRelease(options_DE)
   options_DE%tol = 1.0d-6
   call msOdeSolve( mfOut(y,status,tolout,yp,solve_log),                &
                    deriv_emergency_exit, t_span, y_0, options_DE )
   call msDisplay( status, "returned status" )
   call msDisplay( mfGet(solve_log,1), "[statistics] nb_step" )
   call msDisplay( mfGet(solve_log,2), "[statistics] dt_min" )
   call msDisplay( mfGet(solve_log,3), "[statistics] dt_max" )
   call msDisplay( mfGet(solve_log,4), "[statistics] nb_deriv" )
   ! find the first row containing NaNs
   k = size(t_span)
   do i = 1, size(t_span)
      if( all(mfIsNaN( mfGet(t_span,i) )) ) then
         k = i - 1
         exit
      end if
   end do
   y_out = mfGet(t_span,1 .to. k) .hc. mfGet(y,1 .to. k)                &
                                  .hc. mfGet(yp,1 .to. k)
   call msDisplay( y_out, "    time        y        yp" )

   print "(/,A)", "*** test number 75 ***"
   print "()"
   print *, "integration of {y' =  2*t}"
   print *, '               with the "End condition" : 1 < y'
   print *, "  [ solution is: y(t) = t**2 ]"
   t_0 = 0.0d0
   t_end = 2.0d0
   t_span = .t. mf( [ t_0, t_end ] )
   call msDisplay( t_span, "input t_span" )
   y_0 = [ 0.0d0 ]
   call msRelease(options_DE)
   options_DE%tol = 1.0d-6
   call msOdeSolve( mfOut(y,status,tolout,yp,solve_log),                &
                    deriv_end_condition, t_span, y_0, options_DE )
   call msDisplay( status, "returned status" )
   call msDisplay( mfGet(solve_log,1), "[statistics] nb_step" )
   call msDisplay( mfGet(solve_log,2), "[statistics] dt_min" )
   call msDisplay( mfGet(solve_log,3), "[statistics] dt_max" )
   call msDisplay( mfGet(solve_log,4), "[statistics] nb_deriv" )
   call msDisplay( t_span, "output t_span" )
   call msDisplay( y, "numerical result (y)" )
   call msDisplay( yp, "numerical result (yp)" )

   print "(/,A)", "*** test number 76 ***"
   print "()"
   print *, "integration of {y' =  2*t}"
   print *, '               with the "End condition" : 1 < y'
   print *, "  [ solution is: y(t) = t**2 ]"
   t_0 = 0.0d0
   t_end = 2.0d0
   t_span = .t. mfLinSpace( t_0, t_end, 21 )
   call msDisplay( t_span, "input t_span" )
   y_0 = [ 0.0d0 ]
   call msRelease(options_DE)
   options_DE%tol = 1.0d-6
   call msOdeSolve( mfOut(y,status,tolout,yp,solve_log),                &
                    deriv_end_condition, t_span, y_0, options_DE )
   call msDisplay( status, "returned status" )
   call msDisplay( mfGet(solve_log,1), "[statistics] nb_step" )
   call msDisplay( mfGet(solve_log,2), "[statistics] dt_min" )
   call msDisplay( mfGet(solve_log,3), "[statistics] dt_max" )
   call msDisplay( mfGet(solve_log,4), "[statistics] nb_deriv" )
   ! find the first row containing NaNs
   k = size(t_span)
   do i = 1, size(t_span)
      if( all(mfIsNaN( mfGet(t_span,i) )) ) then
         k = i - 1
         exit
      end if
   end do
   y_out = mfGet(t_span,1 .to. k) .hc. mfGet(y,1 .to. k)                &
                                  .hc. mfGet(yp,1 .to. k)
   call msDisplay( y_out, "    time        y        yp" )

   print "(/,A)", "*** test number 77 ***"
   print "()"
   print *, "integration of {y' =  2*t}"
   print *, '               with the "Combined condition" : 0.99 <= y <= 1.01'
   print *, "  [ solution is: y(t) = t**2 ]"
   t_0 = 0.0d0
   t_end = 2.0d0
   t_span = .t. mf( [ t_0, t_end ] )
   call msDisplay( t_span, "input t_span" )
   y_0 = [ 0.0d0 ]
   call msRelease(options_DE)
   options_DE%tol = 1.0d-6
   call msOdeSolve( mfOut(y,status,tolout,yp,solve_log),                &
                    deriv_combined_conditions, t_span, y_0, options_DE )
   call msDisplay( t_span, "output t_span" )
   call msDisplay( y, "numerical result" )

   print "(/,A)", "*** test number 78 ***"
   print "()"
   print *, "integration of {y' =  2*t}"
   print *, '               with the "Combined condition" : 0.99 <= y <= 1.01'
   print *, "  [ solution is: y(t) = t**2 ]"
   t_0 = 0.0d0
   t_end = 2.0d0
   t_span = .t. mfLinSpace( t_0, t_end, 21 )
   call msDisplay( t_span, "input t_span" )
   y_0 = [ 0.0d0 ]
   call msRelease(options_DE)
   options_DE%tol = 1.0d-6
   call msOdeSolve( mfOut(y,status,tolout,yp,solve_log),                &
                    deriv_combined_conditions, t_span, y_0, options_DE )
   call msDisplay( status, "returned status" )
   call msDisplay( mfGet(solve_log,1), "[statistics] nb_step" )
   call msDisplay( mfGet(solve_log,2), "[statistics] dt_min" )
   call msDisplay( mfGet(solve_log,3), "[statistics] dt_max" )
   call msDisplay( mfGet(solve_log,4), "[statistics] nb_deriv" )
   ! find the first row containing NaNs
   k = size(t_span)
   do i = 1, size(t_span)
      if( all(mfIsNaN( mfGet(t_span,i) )) ) then
         k = i - 1
         exit
      end if
   end do
   y_out = mfGet(t_span,1 .to. k) .hc. mfGet(y,1 .to. k)                &
                                  .hc. mfGet(yp,1 .to. k)
   call msDisplay( y_out, "    time        y        yp" )

   ! Adams-BashForth-Moulton
   print "(/,' ----- ',A,' -----',/)",                                  &
         "Adams-BashForth-Moulton"

   print "(/,A)", "*** test number 79 ***"
   print "()"
   print *, "integration of {y'' = - y} over [0,2*pi]:"
   print *, "  [ solution is: y(t) = sin(t) ]"
   t_0 = 0.0d0
   t_end = 2.0d0*MF_PI
   t_span = .t. mf( [ t_0, t_end ] )
   y = [ sin(t_0), cos(t_0) ]
   call msRelease(options_DE)
   options_DE%tol = 1.0d-6
   options_DE%method="ABM"
   call msOdeSolve( mfOut(y_end,status), deriv, t_span, y, options_DE )
   x = [ sin(t_end), cos(t_end) ]
   call msDisplay( x, "exact answer" )
   call msDisplay( y_end, "numerical result" )
   call msDisplay( mfNorm(mfAbs(x-y_end))/mfNorm(x), "relat. error" )
   call msDisplay( status, "returned status" )

   print "(/,A)", "*** test number 80 ***"
   print "()"
   print *, "integration of {y'' = - y} over [0,2*pi]:"
   print *, "  [ solution is: y(t) = sin(t) ]"
   t_0 = 0.0d0
   t_end = 2.0d0*MF_PI
   t_span = .t. mf( [ t_0, t_end ] )
   y = [ sin(t_0), cos(t_0) ]
   call msRelease(options_DE)
   options_DE%tol = 1.0d-6
   options_DE%method="ABM"
   call msOdeSolve( mfOut(y_end,status,new_err,yp,solve_log),           &
                    deriv, t_span, y, options_DE )
   call msDisplay( y_end, "numerical result" )
   call msDisplay( yp, "deriv. of y" )
   call msDisplay( status, "returned status" )
   call msDisplay( mfGet(solve_log,1), "[statistics] nb_step" )
   call msDisplay( mfGet(solve_log,2), "[statistics] dt_min" )
   call msDisplay( mfGet(solve_log,3), "[statistics] dt_max" )
   call msDisplay( mfGet(solve_log,4), "[statistics] nb_deriv" )

   print "(/,A)", "*** test number 81 ***"
   print "()"
   print *, "  [ same with intermediate output ]"
   t_span = .t. mfLinSpace( t_0, t_end, 20 )
   y = [ sin(t_0), cos(t_0) ]
   call msRelease(options_DE)
   options_DE%tol = 1.0d-6
   options_DE%method="ABM"
   call msOdeSolve( mfOut(y_end,status,new_err,yp,solve_log),           &
                    deriv, t_span, y, options_DE )
   call msDisplay( y_end, "numerical result" )
   call msDisplay( yp, "deriv. of y" )
   call msDisplay( status, "returned status" )
   call msDisplay( mfGet(solve_log,1), "[statistics] nb_step" )
   call msDisplay( mfGet(solve_log,2), "[statistics] dt_min" )
   call msDisplay( mfGet(solve_log,3), "[statistics] dt_max" )
   call msDisplay( mfGet(solve_log,4), "[statistics] nb_deriv" )

   ! Backward Differentiation Formula (Finite Diff. Jacobian)
   print "(/,' ----- ',A,' -----',/)",                                  &
         "Backward Differentiation Formula (Finite Diff. Jacobian)"

   print "(/,A)", "*** test number 82 ***"
   print "()"
   print *, "integration of {y'' = - y} over [0,2*pi]:"
   print *, "  [ solution is: y(t) = sin(t) ]"
   t_0 = 0.0d0
   t_end = 2.0d0*MF_PI
   t_span = .t. mf( [ t_0, t_end ] )
   y = [ sin(t_0), cos(t_0) ]
   call msRelease(options_DE)
   options_DE%tol = 1.0d-6
   options_DE%method="BDF"
   call msOdeSolve( mfOut(y_end,status,new_err,yp,solve_log),           &
                    deriv, t_span, y, options_DE )
   x = [ sin(t_end), cos(t_end) ]
   call msDisplay( x, "exact answer" )
   call msDisplay( y_end, "numerical result" )
   call msDisplay( mfNorm(mfAbs(x-y_end))/mfNorm(x), "relat. error" )
   call msDisplay( status, "returned status" )
   call msDisplay( mfGet(solve_log,1), "[statistics] nb_step" )
   call msDisplay( mfGet(solve_log,2), "[statistics] dt_min" )
   call msDisplay( mfGet(solve_log,3), "[statistics] dt_max" )
   call msDisplay( mfGet(solve_log,4), "[statistics] nb_deriv" )
   call msDisplay( mfGet(solve_log,5), "[statistics] nb_jac" )
   call msDisplay( mfGet(solve_log,6), "[statistics] nb_solv" )

   print "(/,A)", "*** test number 83 ***"
   print "()"
   print *, "  [ same with intermediate output ]"
   t_span = .t. mfLinSpace( t_0, t_end, 20 )
   y = [ sin(t_0), cos(t_0) ]
   call msRelease(options_DE)
   options_DE%tol = 1.0d-6
   options_DE%method="BDF"
   call msOdeSolve( mfOut(y_out,status,new_err,yp,solve_log),           &
                    deriv, t_span, y, options_DE )
   x = mfSin(t_span) .hc. mfCos(t_span)
   call msDisplay( x, "exact answer" )
   call msDisplay( y_out, "numerical result" )
   call msDisplay( mfNorm(mfAbs(x-y_out))/mfNorm(x), "relat. error" )
   call msDisplay( status, "returned status" )
   call msDisplay( mfGet(solve_log,1), "[statistics] nb_step" )
   call msDisplay( mfGet(solve_log,2), "[statistics] dt_min" )
   call msDisplay( mfGet(solve_log,3), "[statistics] dt_max" )
   call msDisplay( mfGet(solve_log,4), "[statistics] nb_deriv" )
   call msDisplay( mfGet(solve_log,5), "[statistics] nb_jac" )
   call msDisplay( mfGet(solve_log,6), "[statistics] nb_solv" )

   ! testing the output of t_log and order_log
   print "(/,A)", "*** test number 84 ***"
   print "()"
   print *, "  [ times and orders at each time step ]"
   t_span = .t. mfLinSpace( t_0, t_end, 20 )
   y = [ sin(t_0), cos(t_0) ]
   call msRelease(options_DE)
   options_DE%tol = 1.0d-6
   options_DE%method="BDF"
   call msOdeSolve( mfOut(y_end,status,MF_NO_ARG,MF_NO_ARG,MF_NO_ARG,   &
                          t_log,order_log),                             &
                    deriv, t_span, y, options_DE )
   call msDisplay( y_end, "numerical result" )
   call msDisplay( status, "returned status" )
   call msDisplay( .t. t_log, "t_log", head=5, tail=5 )
   ! removing the first element (always equal to NaN)
   order_log = mfGet( order_log, 2 .to. MF_END )
   call msDisplay( .t. order_log, "order_log", head=5, tail=5 )
   print "(2X,A,I0)", "max. order reached = ", mfInt(mfMax(order_log))

   ! Backward Differentiation Formula (User's Jacobian routine)
   print "(/,' ----- ',A,' -----',/)",                                  &
         "Backward Differentiation Formula (User's Jacobian routine)"

   ! DENSE case
   print *, "*** DENSE case ***"

   print "(/,A)", "*** test number 85 ***"
   print "()"
   print *, "integration of {y'' = - y} over [0,2*pi]:"
   print *, "  [ solution is: y(t) = sin(t) ]"
   t_0 = 0.0d0
   t_end = 2.0d0*MF_PI
   t_span = .t. mf( [ t_0, t_end ] )
   y = [ sin(t_0), cos(t_0) ]
   call msRelease(options_DE)
   options_DE%tol = 1.0d-6
   options_DE%method="BDF"
   call msOdeSolve( mfOut(y_end,status,new_err,yp,solve_log),           &
                    deriv, t_span, y, options_DE, jac=jac )
   x = [ sin(t_end), cos(t_end) ]
   call msDisplay( x, "exact answer" )
   call msDisplay( y_end, "numerical result" )
   call msDisplay( mfNorm(mfAbs(x-y_end))/mfNorm(x), "relat. error" )
   call msDisplay( status, "returned status" )
   call msDisplay( mfGet(solve_log,1), "[statistics] nb_step" )
   call msDisplay( mfGet(solve_log,2), "[statistics] dt_min" )
   call msDisplay( mfGet(solve_log,3), "[statistics] dt_max" )
   call msDisplay( mfGet(solve_log,4), "[statistics] nb_deriv" )
   call msDisplay( mfGet(solve_log,5), "[statistics] nb_jac" )
   call msDisplay( mfGet(solve_log,6), "[statistics] nb_solv" )

   print "(/,A)", "*** test number 86 ***"
   print "()"
   print *, "  [ same with intermediate output ]"
   t_span = .t. mfLinSpace( t_0, t_end, 20 )
   y = [ sin(t_0), cos(t_0) ]
   call msRelease(options_DE)
   options_DE%tol = 1.0d-6
   options_DE%method="BDF"
   call msOdeSolve( mfOut(y_end,status,new_err,yp,solve_log),           &
                    deriv, t_span, y, options_DE, jac=jac )
   x = mfSin(t_span) .hc. mfCos(t_span)
   call msDisplay( x, "exact answer" )
   call msDisplay( y_out, "numerical result" )
   call msDisplay( mfNorm(mfAbs(x-y_out))/mfNorm(x), "relat. error" )
   call msDisplay( status, "returned status" )
   call msDisplay( mfGet(solve_log,1), "[statistics] nb_step" )
   call msDisplay( mfGet(solve_log,2), "[statistics] dt_min" )
   call msDisplay( mfGet(solve_log,3), "[statistics] dt_max" )
   call msDisplay( mfGet(solve_log,4), "[statistics] nb_deriv" )
   call msDisplay( mfGet(solve_log,5), "[statistics] nb_jac" )
   call msDisplay( mfGet(solve_log,6), "[statistics] nb_solv" )

   ! SPARSE case
   print *, "*** SPARSE case ***"

   print "(/,A)", "*** test number 87 ***"
   print "()"
   print *, "integration of {y'' = - y} over [0,2*pi]:"
   print *, "  [ solution is: y(t) = sin(t) ]"
   t_0 = 0.0d0
   t_end = 2.0d0*MF_PI
   t_span = .t. mf( [ t_0, t_end ] )
   y = [ sin(t_0), cos(t_0) ]
   call msRelease(options_DE)
   options_DE%tol = 1.0d-6
   options_DE%method="BDF"
   call msOdeSolve( mfOut(y_end,status,new_err,yp,solve_log),           &
                    deriv, t_span, y, options_DE, jac=spjac, sparse=.true. )
   x = [ sin(t_end), cos(t_end) ]
   call msDisplay( x, "exact answer" )
   call msDisplay( y_end, "numerical result" )
   call msDisplay( mfNorm(mfAbs(x-y_end))/mfNorm(x), "relat. error" )
   call msDisplay( status, "returned status" )
   call msDisplay( mfGet(solve_log,1), "[statistics] nb_step" )
   call msDisplay( mfGet(solve_log,2), "[statistics] dt_min" )
   call msDisplay( mfGet(solve_log,3), "[statistics] dt_max" )
   call msDisplay( mfGet(solve_log,4), "[statistics] nb_deriv" )
   call msDisplay( mfGet(solve_log,5), "[statistics] nb_jac" )
   call msDisplay( mfGet(solve_log,6), "[statistics] nb_solv" )

   print "(/,A)", "*** test number 88 ***"
   print "()"
   print *, "  [ same with intermediate output ]"
   t_span = .t. mfLinSpace( t_0, t_end, 20 )
   y = [ sin(t_0), cos(t_0) ]
   call msRelease(options_DE)
   options_DE%tol = 1.0d-6
   options_DE%method="BDF"
   call msOdeSolve( mfOut(y_end,status,new_err,yp,solve_log),           &
                    deriv, t_span, y, options_DE, jac=spjac, sparse=.true. )
   x = mfSin(t_span) .hc. mfCos(t_span)
   call msDisplay( x, "exact answer" )
   call msDisplay( y_out, "numerical result" )
   call msDisplay( mfNorm(mfAbs(x-y_out))/mfNorm(x), "relat. error" )
   call msDisplay( status, "returned status" )
   call msDisplay( mfGet(solve_log,1), "[statistics] nb_step" )
   call msDisplay( mfGet(solve_log,2), "[statistics] dt_min" )
   call msDisplay( mfGet(solve_log,3), "[statistics] dt_max" )
   call msDisplay( mfGet(solve_log,4), "[statistics] nb_deriv" )
   call msDisplay( mfGet(solve_log,5), "[statistics] nb_jac" )
   call msDisplay( mfGet(solve_log,6), "[statistics] nb_solv" )

   print "(/,A)", "*** test number 89 ***"
   print "()"
   print *, "integration of {y' =  2*t}"
   print *, '               with the "Illegal condition" : 1 < y'
   print *, "  [ solution is: y(t) = t**2 ]"
   t_0 = 0.0d0
   t_end = 2.0d0
   t_span = .t. mf( [ t_0, t_end ] )
   call msDisplay( t_span, "input t_span" )
   y_0 = [ 0.0d0 ]
   call msRelease(options_DE)
   options_DE%method="BDF"
   call msOdeSolve( mfOut(y,status,tolout,yp,solve_log),                &
                    deriv_illegal_condition, t_span, y_0, options_DE )
   call msDisplay( t_span, "output t_span" )
   call msDisplay( y, "numerical result" )
   call msDisplay( yp, "numerical result (yp)" )

   print "(/,A)", "*** test number 90 ***"
   print "()"
   print *, "integration of {y' =  2*t}"
   print *, '               with the "Illegal condition" : 1 < y'
   print *, "  [ solution is: y(t) = t**2 ]"
   t_0 = 0.0d0
   t_end = 2.0d0
   t_span = .t. mfLinSpace( t_0, t_end, 21 )
   call msDisplay( t_span, "input t_span" )
   y_0 = [ 0.0d0 ]
   call msRelease(options_DE)
   options_DE%method="BDF"
   call msOdeSolve( mfOut(y,status,tolout,yp,solve_log),                &
                    deriv_illegal_condition, t_span, y_0, options_DE )
   call msDisplay( status, "returned status" )
   call msDisplay( mfGet(solve_log,1), "[statistics] nb_step" )
   call msDisplay( mfGet(solve_log,2), "[statistics] dt_min" )
   call msDisplay( mfGet(solve_log,3), "[statistics] dt_max" )
   call msDisplay( mfGet(solve_log,4), "[statistics] nb_deriv" )
   ! find the first row containing NaNs
   k = size(t_span)
   do i = 1, size(t_span)
      if( all(mfIsNaN( mfGet(t_span,i) )) ) then
         k = i - 1
         exit
      end if
   end do
   y_out = mfGet(t_span,1 .to. k) .hc. mfGet(y,1 .to. k)                &
                                  .hc. mfGet(yp,1 .to. k)
   call msDisplay( y_out, "    time        y        yp" )

   print "(/,A)", "*** test number 91 ***"
   print "()"
   print *, "integration of {y' =  2*t}"
   print *, '               with the "Emergency exit" : 1 < y'
   print *, "  [ solution is: y(t) = t**2 ]"
   t_0 = 0.0d0
   t_end = 2.0d0
   t_span = .t. mf( [ t_0, t_end ] )
   call msDisplay( t_span, "input t_span" )
   y_0 = [ 0.0d0 ]
   call msRelease(options_DE)
   options_DE%method="BDF"
   call msOdeSolve( mfOut(y,status,tolout,yp,solve_log),                &
                    deriv_emergency_exit, t_span, y_0, options_DE )
   call msDisplay( t_span, "output t_span" )
   call msDisplay( y, "numerical result" )
   call msDisplay( yp, "numerical result (yp)" )

   print "(/,A)", "*** test number 92 ***"
   print "()"
   print *, "integration of {y' =  2*t}"
   print *, '               with the "Emergency exit" : 1 < y'
   print *, "  [ solution is: y(t) = t**2 ]"
   t_0 = 0.0d0
   t_end = 2.0d0
   t_span = .t. mfLinSpace( t_0, t_end, 21 )
   call msDisplay( t_span, "input t_span" )
   y_0 = [ 0.0d0 ]
   call msRelease(options_DE)
   options_DE%method="BDF"
   call msOdeSolve( mfOut(y,status,tolout,yp,solve_log),                &
                    deriv_emergency_exit, t_span, y_0, options_DE )
   call msDisplay( status, "returned status" )
   call msDisplay( mfGet(solve_log,1), "[statistics] nb_step" )
   call msDisplay( mfGet(solve_log,2), "[statistics] dt_min" )
   call msDisplay( mfGet(solve_log,3), "[statistics] dt_max" )
   call msDisplay( mfGet(solve_log,4), "[statistics] nb_deriv" )
   ! find the first row containing NaNs
   k = size(t_span)
   do i = 1, size(t_span)
      if( all(mfIsNaN( mfGet(t_span,i) )) ) then
         k = i - 1
         exit
      end if
   end do
   y_out = mfGet(t_span,1 .to. k) .hc. mfGet(y,1 .to. k)                &
                                  .hc. mfGet(yp,1 .to. k)
   call msDisplay( y_out, "    time        y        yp" )

   print "(/,A)", "*** test number 93 ***"
   print "()"
   print *, "integration of {y' =  (3/2)*sqrt(t)}"
   print *, '               with the "Emergency exit" : 1 < y'
   print *, "  [ solution is: y(t) = t**(3/2) ]"
   t_0 = 0.0d0
   t_end = 2.0d0
   t_span = .t. mf( [ t_0, t_end ] )
   call msDisplay( t_span, "input t_span" )
   y_0 = [ 0.0d0 ]
   call msRelease(options_DE)
   options_DE%method="BDF"
   call msOdeSolve( mfOut(y,status,tolout,yp,solve_log),                &
                    deriv_emergency_exit_2, t_span, y_0, options_DE )
   call msDisplay( t_span, "output t_span" )
   call msDisplay( y, "numerical result" )
   call msDisplay( yp, "numerical result (yp)" )

   print "(/,A)", "*** test number 94 ***"
   print "()"
   print *, "integration of {y' =  (3/2)*sqrt(t)}"
   print *, '               with the "Emergency exit" : 1 < y'
   print *, "  [ solution is: y(t) = t**(3/2) ]"
   t_0 = 0.0d0
   t_end = 2.0d0
   t_span = .t. mfLinSpace( t_0, t_end, 21 )
   call msDisplay( t_span, "input t_span" )
   y_0 = [ 0.0d0 ]
   call msRelease(options_DE)
   options_DE%method="BDF"
   call msOdeSolve( mfOut(y,status,tolout,yp,solve_log),                &
                    deriv_emergency_exit_2, t_span, y_0, options_DE )
   call msDisplay( status, "returned status" )
   call msDisplay( mfGet(solve_log,1), "[statistics] nb_step" )
   call msDisplay( mfGet(solve_log,2), "[statistics] dt_min" )
   call msDisplay( mfGet(solve_log,3), "[statistics] dt_max" )
   call msDisplay( mfGet(solve_log,4), "[statistics] nb_deriv" )
   ! find the first row containing NaNs
   k = size(t_span)
   do i = 1, size(t_span)
      if( all(mfIsNaN( mfGet(t_span,i) )) ) then
         k = i - 1
         exit
      end if
   end do
   y_out = mfGet(t_span,1 .to. k) .hc. mfGet(y,1 .to. k)                &
                                  .hc. mfGet(yp,1 .to. k)
   call msDisplay( y_out, "    time        y        yp" )

   print "(/,A)", "*** test number 95 ***"
   print "()"
   print *, "integration of {y' =  2*t}"
   print *, '               with the "End condition" : 1 < y'
   print *, "  [ solution is: y(t) = t**2 ]"
   t_0 = 0.0d0
   t_end = 12.0d0
   t_span = .t. mf( [ t_0, t_end ] )
   call msDisplay( t_span, "input t_span" )
   y_0 = [ 0.0d0 ]
   call msRelease(options_DE)
   options_DE%tol = 1.0d-6
   options_DE%method="BDF"
   call msOdeSolve( mfOut(y,status,tolout,yp,solve_log),                &
                    deriv_end_condition, t_span, y_0, options_DE )
   call msDisplay( status, "returned status" )
   call msDisplay( mfGet(solve_log,1), "[statistics] nb_step" )
   call msDisplay( mfGet(solve_log,2), "[statistics] dt_min" )
   call msDisplay( mfGet(solve_log,3), "[statistics] dt_max" )
   call msDisplay( mfGet(solve_log,4), "[statistics] nb_deriv" )
   call msDisplay( t_span, "output t_span" )
   call msDisplay( y, "numerical result (y)" )
   call msDisplay( yp, "numerical result (yp)" )

   print "(/,A)", "*** test number 96 ***"
   print "()"
   print *, "integration of {y' =  2*t}"
   print *, '               with the "End condition" : 1 < y'
   print *, "  [ solution is: y(t) = t**2 ]"
   t_0 = 0.0d0
   t_end = 2.0d0
   t_span = .t. mf( [ t_0, t_end ] )
   call msDisplay( t_span, "input t_span" )
   y_0 = [ 0.0d0 ]
   call msRelease(options_DE)
   options_DE%tol = 1.0d-6
   options_DE%method="BDF"
   call msOdeSolve( mfOut(y,status,tolout,yp,solve_log),                &
                    deriv_end_condition, t_span, y_0, options_DE )
   call msDisplay( status, "returned status" )
   call msDisplay( mfGet(solve_log,1), "[statistics] nb_step" )
   call msDisplay( mfGet(solve_log,2), "[statistics] dt_min" )
   call msDisplay( mfGet(solve_log,3), "[statistics] dt_max" )
   call msDisplay( mfGet(solve_log,4), "[statistics] nb_deriv" )
   call msDisplay( t_span, "output t_span" )
   call msDisplay( y, "numerical result (y)" )
   call msDisplay( yp, "numerical result (yp)" )

   print "(/,A)", "*** test number 97 ***"
   print "()"
   print *, "integration of {y' =  2*t}"
   print *, '               with the "End condition" : 1 < y'
   print *, "  [ solution is: y(t) = t**2 ]"
   t_0 = 0.0d0
   t_end = 12.0d0
   t_span = .t. mfLinSpace( t_0, t_end, 21 )
   call msDisplay( t_span, "input t_span" )
   y_0 = [ 0.0d0 ]
   call msRelease(options_DE)
   options_DE%tol = 1.0d-6
   options_DE%method="BDF"
   call msOdeSolve( mfOut(y,status,tolout,yp,solve_log),                &
                    deriv_end_condition, t_span, y_0, options_DE )
   call msDisplay( status, "returned status" )
   call msDisplay( mfGet(solve_log,1), "[statistics] nb_step" )
   call msDisplay( mfGet(solve_log,2), "[statistics] dt_min" )
   call msDisplay( mfGet(solve_log,3), "[statistics] dt_max" )
   call msDisplay( mfGet(solve_log,4), "[statistics] nb_deriv" )
   ! find the first row containing NaNs
   k = size(t_span)
   do i = 1, size(t_span)
      if( all(mfIsNaN( mfGet(t_span,i) )) ) then
         k = i - 1
         exit
      end if
   end do
   y_out = mfGet(t_span,1 .to. k) .hc. mfGet(y,1 .to. k)                &
                                  .hc. mfGet(yp,1 .to. k)
   call msDisplay( y_out, "    time        y        yp" )

   print "(/,A)", "*** test number 98 ***"
   print "()"
   print *, "integration of {y' =  2*t}"
   print *, '               with the "End condition" : 1 < y'
   print *, "  [ solution is: y(t) = t**2 ]"
   t_0 = 0.0d0
   t_end = 2.0d0
   t_span = .t. mfLinSpace( t_0, t_end, 21 )
   call msDisplay( t_span, "input t_span" )
   y_0 = [ 0.0d0 ]
   call msRelease(options_DE)
   options_DE%tol = 1.0d-6
   options_DE%method="BDF"
   call msOdeSolve( mfOut(y,status,tolout,yp,solve_log),                &
                    deriv_end_condition, t_span, y_0, options_DE )
   call msDisplay( status, "returned status" )
   call msDisplay( mfGet(solve_log,1), "[statistics] nb_step" )
   call msDisplay( mfGet(solve_log,2), "[statistics] dt_min" )
   call msDisplay( mfGet(solve_log,3), "[statistics] dt_max" )
   call msDisplay( mfGet(solve_log,4), "[statistics] nb_deriv" )
   ! find the first row containing NaNs
   k = size(t_span)
   do i = 1, size(t_span)
      if( all(mfIsNaN( mfGet(t_span,i) )) ) then
         k = i - 1
         exit
      end if
   end do
   y_out = mfGet(t_span,1 .to. k) .hc. mfGet(y,1 .to. k)                &
                                  .hc. mfGet(yp,1 .to. k)
   call msDisplay( y_out, "    time        y        yp" )

   print "(/,A)", "*** test number 99 ***"
   print "()"
   print *, "integration of {y' =  2*t}"
   print *, '               with the "Combined condition" : 0.99 <= y <= 1.01'
   print *, "  [ solution is: y(t) = t**2 ]"
   t_0 = 0.0d0
   t_end = 2.0d0
   t_span = .t. mf( [ t_0, t_end ] )
   call msDisplay( t_span, "input t_span" )
   y_0 = [ 0.0d0 ]
   call msRelease(options_DE)
   options_DE%method="BDF"
   call msOdeSolve( mfOut(y,status,tolout,yp,solve_log),                &
                    deriv_combined_conditions, t_span, y_0, options_DE )
   call msDisplay( status, "returned status" )
   call msDisplay( mfGet(solve_log,1), "[statistics] nb_step" )
   call msDisplay( mfGet(solve_log,2), "[statistics] dt_min" )
   call msDisplay( mfGet(solve_log,3), "[statistics] dt_max" )
   call msDisplay( mfGet(solve_log,4), "[statistics] nb_deriv" )
   call msDisplay( t_span, "output t_span" )
   call msDisplay( y, "numerical result (y)" )
   call msDisplay( yp, "numerical result (yp)" )

   print "(/,A)", "*** test number 100 ***"
   print "()"
   print *, "integration of {y' =  2*t}"
   print *, '               with the "Combined condition" : 0.99 <= y <= 1.01'
   print *, "  [ solution is: y(t) = t**2 ]"
   t_0 = 0.0d0
   t_end = 2.0d0
   t_span = .t. mfLinSpace( t_0, t_end, 21 )
   call msDisplay( t_span, "input t_span" )
   y_0 = [ 0.0d0 ]
   call msRelease(options_DE)
   options_DE%method="BDF"
   call msOdeSolve( mfOut(y,status,tolout,yp,solve_log),                &
                    deriv_combined_conditions, t_span, y_0, options_DE )
   call msDisplay( status, "returned status" )
   call msDisplay( mfGet(solve_log,1), "[statistics] nb_step" )
   call msDisplay( mfGet(solve_log,2), "[statistics] dt_min" )
   call msDisplay( mfGet(solve_log,3), "[statistics] dt_max" )
   call msDisplay( mfGet(solve_log,4), "[statistics] nb_deriv" )
   ! find the first row containing NaNs
   k = size(t_span)
   do i = 1, size(t_span)
      if( all(mfIsNaN( mfGet(t_span,i) )) ) then
         k = i - 1
         exit
      end if
   end do
   y_out = mfGet(t_span,1 .to. k) .hc. mfGet(y,1 .to. k)                &
                                  .hc. mfGet(yp,1 .to. k)
   call msDisplay( y_out, "    time        y        yp" )

   ! mfDaeSolve --------------------------------------------------------
   call print_separation("mfDaeSolve")

   print "(/,A)", "*** test number 101 ***"
   print "()"
   print *, "integration of {y_1' =  y_2}"
   print *, "               {y_2' = -y_1} over [0,2*pi]:"
   print *, "  [ solution is: y(t) = sin(t) ]"
   t_0 = 0.0d0
   t_end = 2.0d0*MF_PI
   t_span = .t. mf( [ t_0, t_end ] )
   y_0 = [ sin(t_0), cos(t_0) ]
   yp_0 = [ cos(t_0), -sin(t_0) ]
   call msRelease(options_DE)
   options_DE%tol = 1.0d-6
   y = mfDaeSolve( resid, t_span, y_0, yp_0, options_DE )
   x = [ sin(t_end), cos(t_end) ]
   call msDisplay( x, "exact answer" )
   call msDisplay( y, "numerical result" )
   call msDisplay( mfNorm(mfAbs(x-y))/mfNorm(x), "relat. error" )

   ! the following DAE system degenerates at t = pi/2, so we have
   ! restricted the time interval.
   print "(/,A)", "*** test number 102 ***"
   print "()"
   print *, "integration of {y_1' =  y_2}"
   print *, "               {y_1**2 + y_2**2 = 1} over [0,pi/4]:"
   print *, "  [ solution is: y(t) = sin(t) ]"
   t_0 = 0.0d0
   t_end = MF_PI/4.0d0
   t_span = .t. mf( [ t_0, t_end ] )
   y_0 = [ sin(t_0), cos(t_0) ]
   yp_0 = [ cos(t_0), -sin(t_0) ]
   call msRelease(options_DE)
   options_DE%tol = 1.0d-6
   y = mfDaeSolve( resid_2, t_span, y_0, yp_0, options_DE )
   x = [ sin(t_end), cos(t_end) ]
   call msDisplay( x, "exact answer" )
   call msDisplay( y, "numerical result" )
   call msDisplay( mfNorm(mfAbs(x-y))/mfNorm(x), "relat. error" )

   print "(/,A)", "*** test number 103 ***"
   print "()"
   print *, "integration of three DA equations from chemical kinetics"
   print *, "  (Robertson example of [Sundials/IDA] package)"
   t_span = .t. mf( [ 0.0d0, 0.4d0, 4.0d0, 4.0d1, 4.0d2, 4.0d3, 4.0d4,  &
                      4.0d5, 4.0d6, 4.0d7, 4.0d8, 4.0d9, 4.0d10 ] )
   y_0 = [ 1.0d0, 0.0d0, 0.0d0 ]
   yp_0 = [ -0.04d0, 0.04d0, 0.0d0 ]
   tol = mf( [ 1.0d-4, 1.0d-4,  1.0d-4 ] ) .vc.                         &
         mf( [ 1.0d-6, 1.0d-10, 1.0d-6 ] )
   tol = .t. tol
   call msFormat( exponent="sci" )
   call msDisplay( tol, "tol" )
   call msFormat( )
   call msRelease(options_DE)
   options_DE%tol = tol
   y = mfDaeSolve( resid_chem_kinetics, t_span, y_0, yp_0, options_DE )
   call msFormat( exponent="sci" )
   y_out = t_span .hc. y
   call msDisplay( y_out, "time (col 1); numerical result: y(1:3) (col 2-4)" )
   call msFormat( )

   print "(/,A)", "*** test number 104 ***"
   print "()"
   print *, "same as previous example, but with non-negativity constraints"
   print *, "for all variables"
   t_span = .t. mf( [ 0.0d0, 0.4d0, 4.0d0, 4.0d1, 4.0d2, 4.0d3, 4.0d4,  &
                      4.0d5, 4.0d6, 4.0d7, 4.0d8, 4.0d9, 4.0d10 ] )
   y_0 = [ 1.0d0, 0.0d0, 0.0d0 ]
   yp_0 = [ -0.04d0, 0.04d0, 0.0d0 ]
   tol = mf( [ 1.0d-4, 1.0d-4,  1.0d-4 ] ) .vc.                         &
         mf( [ 1.0d-6, 1.0d-10, 1.0d-6 ] )
   tol = .t. tol
   call msFormat( exponent="sci" )
   call msDisplay( tol, "tol" )
   call msFormat( )
   call msRelease(options_DE)
   options_DE%tol = tol
   options_DE%non_neg = [1,2,3]
   y = mfDaeSolve( resid_chem_kinetics, t_span, y_0, yp_0, options_DE )
   call msFormat( exponent="sci" )
   y_out = t_span .hc. y
   call msDisplay( y_out, "time (col 1); numerical result: y(1:3) (col 2-4)" )
   call msFormat( )

   print "(/,A)", "*** test number 105 ***"
   print "()"
   print *, "same example as before except that yp_0 is unknown"
   print *, "  (solution should be slightly better)"
   t_span = .t. mf( [ 0.0d0, 0.4d0, 4.0d0, 4.0d1, 4.0d2, 4.0d3, 4.0d4,  &
                      4.0d5, 4.0d6, 4.0d7, 4.0d8, 4.0d9, 4.0d10 ] )
   y_0 = [ 1.0d0, 0.0d0, 0.0d0 ]
   yp_0 = MF_EMPTY
   tol = mf( [ 1.0d-4, 1.0d-4,  1.0d-4 ] ) .vc.                         &
         mf( [ 1.0d-6, 1.0d-10, 1.0d-6 ] )
   tol = .t. tol
   call msFormat( exponent="sci" )
   call msDisplay( tol, "tol" )
   call msFormat( )
   call msRelease(options_DE)
   options_DE%tol = tol
   options_DE%IC_known = .false.
   y = mfDaeSolve( resid_chem_kinetics, t_span, y_0, yp_0, options_DE )
   call msFormat( exponent="sci" )
   y_out = t_span .hc. y
   call msDisplay( y_out, "time (col 1); numerical result: y(1:3) (col 2-4)" )
   call msFormat( )

   print "(/,A)", "*** test number 106 ***"
   print "()"
   print *, "same example as before except that showing partial results"
   t_span = .t. mf( [ 0.0d0, 0.4d0, 4.0d0, 4.0d1, 4.0d2, 4.0d3, 4.0d4,  &
                      4.0d5, 4.0d6, 4.0d7, 4.0d8, 4.0d9, 4.0d10 ] )
   y_0 = [ 1.0d0, 0.0d0, 0.0d0 ]
   yp_0 = MF_EMPTY
   tol = mf( [ 1.0d-4, 1.0d-4,  1.0d-4 ] ) .vc.                         &
         mf( [ 1.0d-6, 1.0d-10, 1.0d-6 ] )
   tol = .t. tol
   call msFormat( exponent="sci" )
   call msDisplay( tol, "tol" )
   call msFormat( )
   call msRelease(options_DE)
   options_DE%tol = tol
   options_DE%IC_known = .false.
   options_DE%y_ind_out = [2]
   y = mfDaeSolve( resid_chem_kinetics, t_span, y_0, yp_0, options_DE )
   call msFormat( exponent="sci" )
   y_out = t_span .hc. y
   call msDisplay( y_out, "time (col 1); numerical result: y(2) (col 2)" )
   call msFormat( )

   print "(/,A)", "*** test number 107 ***"
   print "()"
   print *, "dense jacobian provided as a user routine"
   t_span = .t. mf( [ 0.0d0, 0.4d0, 4.0d0, 4.0d1, 4.0d2, 4.0d3, 4.0d4,  &
                      4.0d5, 4.0d6, 4.0d7, 4.0d8, 4.0d9, 4.0d10 ] )
   y_0 = [ 1.0d0, 0.0d0, 0.0d0 ]
   yp_0 = MF_EMPTY
   tol = mf( [ 1.0d-4, 1.0d-4,  1.0d-4 ] ) .vc.                         &
         mf( [ 1.0d-6, 1.0d-10, 1.0d-6 ] )
   tol = .t. tol
   call msFormat( exponent="sci" )
   call msDisplay( tol, "tol" )
   call msFormat( )
   call msRelease(options_DE)
   options_DE%tol = tol
   options_DE%IC_known = .false.
   y = mfDaeSolve( resid_chem_kinetics, t_span, y_0, yp_0, options_DE,  &
                   jac=jac_chem_kinetics )
   call msFormat( exponent="sci" )
   y_out = t_span .hc. y
   call msDisplay( y_out, "time (col 1); numerical result: y(1:3) (col 2-4)" )
   call msFormat( )

   print "(/,A)", "*** test number 108 ***"
   print "()"
   print *, "same example as before except that some components of y_0 or yp_0"
   print *, "are unknown"
   t_span = .t. mf( [ 0.0d0, 0.4d0, 4.0d0, 4.0d1, 4.0d2, 4.0d3, 4.0d4,  &
                      4.0d5, 4.0d6, 4.0d7, 4.0d8, 4.0d9, 4.0d10 ] )

   ! exacte initial values are:
   !   y_0 = [ 1.0d0, 0.0d0, 0.0d0 ]
   !   yp_0 = [ -0.04d0, 0.04d0, 0.0d0 ]

   ! guess values not too far from the exact solution
   y_0 = [ 1.0d0, 0.0d0, 1.0d0 ]
   yp_0 = [ 1.0d0, -1.0d0, 0.0d0 ]

   tol = mf( [ 1.0d-4, 1.0d-4,  1.0d-4 ] ) .vc.                         &
         mf( [ 1.0d-6, 1.0d-10, 1.0d-6 ] )
   tol = .t. tol
   call msFormat( exponent="sci" )
   call msDisplay( tol, "tol" )
   call msFormat( )
   call msRelease(options_DE)
   options_DE%tol = tol
   options_DE%IC_known = .false.

   ! prescribed indices are the following:
   ! (not all cases are possible, due to the nature of the DAE system)

   ! case not possible --
!!   options_DE%y0_ind = [ 1, 1, 1 ] ! all y_0 are prescribed

   ! case not possible
!!   options_DE%yp0_ind = [ 1, 1, 1 ] ! all yp_0 are prescribed

   ! case not possible
!!   options_DE%y0_ind  = [ 0, 0, 1 ]
!!   options_DE%yp0_ind = [ 1, 1, 0 ]

   ! ok
!!   options_DE%y0_ind  = [ 0, 1, 0 ]
!!   options_DE%yp0_ind = [ 1, 0, 1 ]

   ! case not possible
!!   options_DE%y0_ind  = [ 1, 0, 0 ]
!!   options_DE%yp0_ind = [ 0, 1, 1 ]

   ! ok
   options_DE%y0_ind  = [ 1, 1, 0 ]
   options_DE%yp0_ind = [ 0, 0, 1 ]

   y = mfDaeSolve( resid_chem_kinetics, t_span, y_0, yp_0, options_DE,  &
                   jac=jac_chem_kinetics )
   call msFormat( exponent="sci" )
   y_out = t_span .hc. y
   call msDisplay( y_out, "time (col 1); numerical result: y(1:3) (col 2-4)" )
   call msFormat( )

   print "(/,A)", "*** test number 109 ***"
   print "()"
   print *, "dense jacobian provided as a user routine (showing partial results)"
   t_span = .t. mf( [ 0.0d0, 0.4d0, 4.0d0, 4.0d1, 4.0d2, 4.0d3, 4.0d4,  &
                      4.0d5, 4.0d6, 4.0d7, 4.0d8, 4.0d9, 4.0d10 ] )
   y_0 = [ 1.0d0, 0.0d0, 0.0d0 ]
   yp_0 = MF_EMPTY
   tol = mf( [ 1.0d-4, 1.0d-4,  1.0d-4 ] ) .vc.                         &
         mf( [ 1.0d-6, 1.0d-10, 1.0d-6 ] )
   tol = .t. tol
   call msFormat( exponent="sci" )
   call msDisplay( tol, "tol" )
   call msFormat( )
   call msRelease(options_DE)
   options_DE%tol = tol
   options_DE%IC_known = .false.
   options_DE%y_ind_out = [1,3]
   y = mfDaeSolve( resid_chem_kinetics, t_span, y_0, yp_0, options_DE,  &
                   jac=jac_chem_kinetics )
   call msFormat( exponent="sci" )
   y_out = t_span .hc. y
   call msDisplay( y_out, "time (col 1); numerical result: y(1), y(3) (col 2-3)" )
   call msFormat( )

   print "(/,A)", "*** test number 110 ***"
   print "()"
   print *, "dense jacobian provided as a user routine"
   print *, "(quick check of the jacobian)"
   t_span = .t. mf( [ 0.0d0, 0.5d0, 1.0d0, 2.0d0, 5.0d0 ] )
   y_0 = [ 1.0d0, 0.0d0, 0.0d0 ]
   yp_0 = MF_EMPTY
   call msRelease(options_DE)
   options_DE%IC_known = .false.
   options_DE%check_jac = 1
!!   options_DE%print_check_jac = 1
   ! avoid warnings because 'chkder' is relatively strict when checking
   ! the jacobian...
   MsgLevel_save = mfGetMsgLevel()
   call msSetMsgLevel( 1 ) ! only Errors are processed
   y = mfDaeSolve( resid_3, t_span, y_0, yp_0, options_DE, jac=jac_resid_3 )
   call msSetMsgLevel( MsgLevel_save )
   call msFormat( exponent="sci" )
   y_out = t_span .hc. y
   call msDisplay( y_out, "time (col 1); numerical result (col 2-4)" )
   call msFormat( )

   print "(/,A)", "*** test number 111 ***"
   print "()"
   print *, "dense jacobian provided as a user routine"
   print *, "(full check of the jacobian)"
   t_span = .t. mf( [ 0.0d0, 0.5d0, 1.0d0, 2.0d0, 5.0d0 ] )
   y_0 = [ 1.0d0, 0.0d0, 0.0d0 ]
   yp_0 = MF_EMPTY
   call msRelease(options_DE)
   options_DE%IC_known = .false.
   options_DE%check_jac = 2
   options_DE%print_check_jac = 1
   y = mfDaeSolve( resid_3, t_span, y_0, yp_0, options_DE, jac=jac_resid_3 )
   call msFormat( exponent="sci" )
   y_out = t_span .hc. y
   call msDisplay( y_out, "time (col 1); numerical result (col 2-4)" )
   call msFormat( )

   print "(/,A)", "*** test number 112 ***"
   print "()"
   print *, "integration of {y' =  2*t}"
   print *, '               with the "Illegal condition" : 1 < y'
   print *, "  [ solution is: y(t) = t**2 ]"
   t_0 = 0.0d0
   t_end = 2.0d0
   t_span = .t. mf( [ t_0, t_end ] )
   call msDisplay( t_span, "input t_span" )
   y_0 = [ 0.0d0 ]
   yp_0 = [ 0.0d0 ]
   y = mfDaeSolve( resid_illegal_condition, t_span, y_0, yp_0 )
   call msDisplay( t_span, "output t_span" )
   call msDisplay( y, "numerical result (y)" )

   print "(/,A)", "*** test number 113 ***"
   print "()"
   print *, "integration of {y' =  2*t}"
   print *, '               with the "Illegal condition" : 1 < y'
   print *, "  [ solution is: y(t) = t**2 ]"
   t_0 = 0.0d0
   t_end = 2.0d0
   t_span = .t. mfLinSpace( t_0, t_end, 21 )
   call msDisplay( t_span, "input t_span" )
   y_0 = [ 0.0d0 ]
   yp_0 = [ 0.0d0 ]
   y = mfDaeSolve( resid_illegal_condition, t_span, y_0, yp_0 )
   ! find the first row containing NaNs
   k = size(t_span)
   do i = 1, size(t_span)
      if( all(mfIsNaN( mfGet(t_span,i) )) ) then
         k = i - 1
         exit
      end if
   end do
   y_out = mfGet(t_span,1 .to. k) .hc. mfGet(y,1 .to. k)
   call msDisplay( y_out, "    time        y" )

   print "(/,A)", "*** test number 114 ***"
   print "()"
   print *, "integration of {y' =  2*t}"
   print *, '               with the "Emergency exit" : 1 < y'
   print *, "  [ solution is: y(t) = t**2 ]"
   t_0 = 0.0d0
   t_end = 2.0d0
   t_span = .t. mf( [ t_0, t_end ] )
   call msDisplay( t_span, "input t_span" )
   y_0 = [ 0.0d0 ]
   yp_0 = [ 0.0d0 ]
   y = mfDaeSolve( resid_emergency_exit, t_span, y_0, yp_0 )
   call msDisplay( t_span, "output t_span" )
   call msDisplay( y, "numerical result (y)" )

   print "(/,A)", "*** test number 115 ***"
   print "()"
   print *, "integration of {y' =  2*t}"
   print *, '               with the "Emergency exit" : 1 < y'
   print *, "  [ solution is: y(t) = t**2 ]"
   t_0 = 0.0d0
   t_end = 2.0d0
   t_span = .t. mfLinSpace( t_0, t_end, 21 )
   call msDisplay( t_span, "input t_span" )
   y_0 = [ 0.0d0 ]
   yp_0 = [ 0.0d0 ]
   y = mfDaeSolve( resid_emergency_exit, t_span, y_0, yp_0 )
   ! find the first row containing NaNs
   k = size(t_span)
   do i = 1, size(t_span)
      if( all(mfIsNaN( mfGet(t_span,i) )) ) then
         k = i - 1
         exit
      end if
   end do
   y_out = mfGet(t_span,1 .to. k) .hc. mfGet(y,1 .to. k)
   call msDisplay( y_out, "    time        y" )

   print "(/,A)", "*** test number 116 ***"
   print "()"
   print *, "integration of {y' =  2*t}"
   print *, '               with the "End condition" : 1 < y'
   print *, "  [ solution is: y(t) = t**2 ]"
   t_0 = 0.0d0
   t_end = 2.0d0
   t_span = .t. mf( [ t_0, t_end ] )
   call msDisplay( t_span, "input t_span" )
   y_0 = [ 0.0d0 ]
   yp_0 = [ 0.0d0 ]
   y = mfDaeSolve( resid_end_condition, t_span, y_0, yp_0 )
   call msDisplay( t_span, "output t_span" )
   call msDisplay( y, "numerical result (y)" )

   print "(/,A)", "*** test number 117 ***"
   print "()"
   print *, "integration of {y' =  2*t}"
   print *, '               with the "End condition" : 1 < y'
   print *, "  [ solution is: y(t) = t**2 ]"
   t_0 = 0.0d0
   t_end = 1.1d0
   t_span = .t. mf( [ t_0, t_end ] )
   call msDisplay( t_span, "input t_span" )
   y_0 = [ 0.0d0 ]
   yp_0 = [ 0.0d0 ]
   y = mfDaeSolve( resid_end_condition, t_span, y_0, yp_0 )
   call msDisplay( t_span, "output t_span" )
   call msDisplay( y, "numerical result (y)" )

   print "(/,A)", "*** test number 118 ***"
   print "()"
   print *, "integration of {y' =  2*t}"
   print *, '               with the "End condition" : 1 < y'
   print *, "  [ solution is: y(t) = t**2 ]"
   t_0 = 0.0d0
   t_end = 2.0d0
   t_span = .t. mfLinSpace( t_0, t_end, 21 )
   call msDisplay( t_span, "input t_span" )
   y_0 = [ 0.0d0 ]
   yp_0 = [ 0.0d0 ]
   y = mfDaeSolve( resid_end_condition, t_span, y_0, yp_0 )
   ! find the first row containing NaNs
   k = size(t_span)
   do i = 1, size(t_span)
      if( all(mfIsNaN( mfGet(t_span,i) )) ) then
         k = i - 1
         exit
      end if
   end do
   y_out = mfGet(t_span,1 .to. k) .hc. mfGet(y,1 .to. k)
   call msDisplay( y_out, "    time        y" )

   print "(/,A)", "*** test number 119 ***"
   print "()"
   print *, "integration of {y' =  2*t}"
   print *, '               with the "Combined condition" : 0.99 <= y <= 1.01'
   print *, "  [ solution is: y(t) = t**2 ]"
   t_0 = 0.0d0
   t_end = 2.0d0
   t_span = .t. mf( [ t_0, t_end ] )
   call msDisplay( t_span, "input t_span" )
   y_0 = [ 0.0d0 ]
   yp_0 = [ 0.0d0 ]
   call msRelease(options_DE)
   options_DE%tol = 1.0d-6
   y = mfDaeSolve( resid_combined_conditions, t_span, y_0, yp_0, options_DE )
   call msDisplay( t_span, "output t_span" )
   call msDisplay( y, "numerical result (y)" )

   print "(/,A)", "*** test number 120 ***"
   print "()"
   print *, "integration of {y' =  2*t}"
   print *, '               with the "Combined condition" : 0.99 <= y <= 1.01'
   print *, "  [ solution is: y(t) = t**2 ]"
   t_0 = 0.0d0
   t_end = 2.0d0
   t_span = .t. mfLinSpace( t_0, t_end, 21 )
   call msDisplay( t_span, "input t_span" )

   y_0 = [ 0.0d0 ]
   yp_0 = [ 0.0d0 ]
   call msRelease(options_DE)
   options_DE%tol = 1.0d-6
   y = mfDaeSolve( resid_combined_conditions, t_span, y_0, yp_0, options_DE )
   ! find the first row containing NaNs
   k = size(t_span)
   do i = 1, size(t_span)
      if( all(mfIsNaN( mfGet(t_span,i) )) ) then
         k = i - 1
         exit
      end if
   end do
   y_out = mfGet(t_span,1 .to. k) .hc. mfGet(y,1 .to. k)
   call msDisplay( y_out, "    time        y" )

   print "(/,A)", "*** test number 121 ***"
   print "()"
   print *, "integration of {y' =  -1/sqrt(y)} (singular ODE)"
   print *, '               with the "Illegal condition" : y <= 0'
   print *, "  [ solution is: y(t) = 1/4*(8-12*t)**(2/3) ]"
   t_0 = 0.0d0
   t_end = 2.0d0
   t_span = .t. mf( [ t_0, t_end ] )
   call msDisplay( t_span, "input t_span" )
   y_0 = [ 1.0d0 ]
   yp_0 = [ -1.0d0 ]
   y = mfDaeSolve( resid_illegal_condition_sing, t_span, y_0, yp_0 )
   call msDisplay( t_span, "output t_span" )
   x = 0.0d0
   call msDisplay( x, "exact answer (y)" )
   call msDisplay( y, "numerical result (y)" )

   print "(/,A)", "*** test number 122 ***"
   print "()"
   print *, "integration of {y' =  -1/sqrt(y)} (singular ODE)"
   print *, '               with the "Illegal condition" : y <= 0'
   print *, "  [ solution is: y(t) = 1/4*(8-12*t)**(2/3) ]"
   t_0 = 0.0d0
   t_end = 2.0d0
   t_span = .t. mfLinSpace( t_0, t_end, 51 )
   call msDisplay( t_span, "input t_span" )
   y_0 = [ 1.0d0 ]
   yp_0 = [ -1.0d0 ]
   y = mfDaeSolve( resid_illegal_condition_sing, t_span, y_0, yp_0 )
   ! find the first row containing NaNs
   k = size(t_span)
   do i = 1, size(t_span)
      if( all(mfIsNaN( mfGet(t_span,i) )) ) then
         k = i - 1
         exit
      end if
   end do
   y_out = mfGet(t_span,1 .to. k) .hc. mfGet(y,1 .to. k)
   call msDisplay( y_out, "    time        y" )

   ! msDaeSolve --------------------------------------------------------
   call print_separation("msDaeSolve")

   print "(/,A)", "*** test number 123 ***"
   print "()"
   print *, "integration of {y_1' =  y_2}"
   print *, "               {y_2' = -y_1} over [0,2*pi]:"
   print *, "  [ solution is: y(t) = sin(t) ]"
   t_0 = 0.0d0
   t_end = 2.0d0*MF_PI
   t_span = .t. mf( [ t_0, t_end ] )
   y_0 = [ sin(t_0), cos(t_0) ]
   yp_0 = [ cos(t_0), -sin(t_0) ]
   call msRelease(options_DE)
   options_DE%tol = 1.0d-6
   call msDaeSolve( mfOut(y,status),                                    &
                    resid, t_span, y_0, yp_0, options_DE )
   x = [ sin(t_end), cos(t_end) ]
   call msDisplay( x, "exact answer" )
   call msDisplay( y, "numerical result" )
   call msDisplay( mfNorm(mfAbs(x-y))/mfNorm(x), "relat. error" )
   call msDisplay( status, "returned status" )

   ! the following DAE system degenerates at t = pi/2, so we have
   ! restricted the time interval.
   print "(/,A)", "*** test number 124 ***"
   print "()"
   print *, "integration of {y_1' =  y_2}"
   print *, "               {y_1**2 + y_2**2 = 1} over [0,pi/4]:"
   print *, "  [ solution is: y(t) = sin(t) ]"
   t_0 = 0.0d0
   t_end = MF_PI/4.0d0
   t_span = .t. mf( [ t_0, t_end ] )
   y_0 = [ sin(t_0), cos(t_0) ]
   yp_0 = [ cos(t_0), -sin(t_0) ]
   call msRelease(options_DE)
   options_DE%tol = 1.0d-6
   call msDaeSolve( mfOut(y,status),                                    &
                    resid_2, t_span, y_0, yp_0, options_DE )
   x = [ sin(t_end), cos(t_end) ]
   call msDisplay( x, "exact answer" )
   call msDisplay( y, "numerical result" )
   call msDisplay( mfNorm(mfAbs(x-y))/mfNorm(x), "relat. error" )
   call msDisplay( status, "returned status" )

   print "(/,A)", "*** test number 125 ***"
   print "()"
   print *, "integration of three DA equations from chemical kinetics"
   print *, "  (Robertson example of [Sundials/IDA] package)"
   t_span = .t. mf( [ 0.0d0, 0.4d0, 4.0d0, 4.0d1, 4.0d2, 4.0d3, 4.0d4,  &
                      4.0d5, 4.0d6, 4.0d7, 4.0d8, 4.0d9, 4.0d10 ] )
   y_0 = [ 1.0d0, 0.0d0, 0.0d0 ]
   yp_0 = [ -0.04d0, 0.04d0, 0.0d0 ]
   tol = mf( [ 1.0d-4, 1.0d-4,  1.0d-4 ] ) .vc.                         &
         mf( [ 1.0d-6, 1.0d-10, 1.0d-6 ] )
   tol = .t. tol
   call msFormat( exponent="sci" )
   call msDisplay( tol, "tol" )
   call msFormat( )
   call msRelease(options_DE)
   options_DE%tol = tol
   call msDaeSolve( mfOut(y,status,new_err),                            &
                    resid_chem_kinetics, t_span, y_0, yp_0, options_DE )
   call msFormat( exponent="sci" )
   y_out = t_span .hc. y
   call msDisplay( y_out, "time (col 1); numerical result: y(1:3) (col 2-4)" )
   call msFormat( )
   call msDisplay( status, "returned status" )
   if( mfDble(status) == dble(-2) ) then
      call msDisplay( new_err, "new optim. error" )
   else
      print *, "imposed relat. error was acceptable."
   end if

   print "(/,A)", "*** test number 126 ***"
   print "()"
   print *, "same as previous example but with nonnegativity contraints"
   print *, "for all variables"
   t_span = .t. mf( [ 0.0d0, 0.4d0, 4.0d0, 4.0d1, 4.0d2, 4.0d3, 4.0d4,  &
                      4.0d5, 4.0d6, 4.0d7, 4.0d8, 4.0d9, 4.0d10 ] )
   y_0 = [ 1.0d0, 0.0d0, 0.0d0 ]
   yp_0 = [ -0.04d0, 0.04d0, 0.0d0 ]
   tol = mf( [ 1.0d-4, 1.0d-4,  1.0d-4 ] ) .vc.                         &
         mf( [ 1.0d-6, 1.0d-10, 1.0d-6 ] )
   tol = .t. tol
   call msFormat( exponent="sci" )
   call msDisplay( tol, "tol" )
   call msFormat( )
   call msRelease(options_DE)
   options_DE%tol = tol
   options_DE%non_neg = [1,2,3]
   call msDaeSolve( mfOut(y,status,new_err),                            &
                    resid_chem_kinetics, t_span, y_0, yp_0, options_DE )
   call msFormat( exponent="sci" )
   y_out = t_span .hc. y
   call msDisplay( y_out, "time (col 1); numerical result: y(1:3) (col 2-4)" )
   call msFormat( )
   call msDisplay( status, "returned status" )
   if( mfDble(status) == dble(-2) ) then
      call msDisplay( new_err, "new optim. error" )
   else
      print *, "imposed relat. error was acceptable."
   end if

   print "(/,A)", "*** test number 127 ***"
   print "()"
   print *, "same example as before except that yp_0 is unknown"
   print *, "  (solution should be slightly better)"
   t_span = .t. mf( [ 0.0d0, 0.4d0, 4.0d0, 4.0d1, 4.0d2, 4.0d3, 4.0d4,  &
                      4.0d5, 4.0d6, 4.0d7, 4.0d8, 4.0d9, 4.0d10 ] )
   y_0 = [ 1.0d0, 0.0d0, 0.0d0 ]
   yp_0 = MF_EMPTY
   tol = mf( [ 1.0d-4, 1.0d-4,  1.0d-4 ] ) .vc.                         &
         mf( [ 1.0d-6, 1.0d-10, 1.0d-6 ] )
   tol = .t. tol
   call msFormat( exponent="sci" )
   call msDisplay( tol, "tol" )
   call msFormat( )
   call msRelease(options_DE)
   options_DE%tol = tol
   options_DE%IC_known = .false.
   call msDaeSolve( mfOut(y,status,new_err),                            &
                    resid_chem_kinetics, t_span, y_0, yp_0, options_DE )
   call msFormat( exponent="sci" )
   y_out = t_span .hc. y
   call msDisplay( y_out, "time (col 1); numerical result: y(1:3) (col 2-4)" )
   call msFormat( )
   call msDisplay( status, "returned status" )
   if( mfDble(status) == dble(-2) ) then
      call msDisplay( new_err, "new optim. error" )
   else
      print *, "imposed relat. error was acceptable."
   end if

   print "(/,A)", "*** test number 128 ***"
   print "()"
   print *, "same example as before except that yp_0 is unknown"
   print *, "  (but providing a good guess)"
   t_span = .t. mf( [ 0.0d0, 0.4d0, 4.0d0, 4.0d1, 4.0d2, 4.0d3, 4.0d4,  &
                      4.0d5, 4.0d6, 4.0d7, 4.0d8, 4.0d9, 4.0d10 ] )
   y_0 = [ 1.0d0, 0.0d0, 0.0d0 ]
   yp_0 = [ -0.04d0, 0.04d0, 0.0d0 ]
   tol = mf( [ 1.0d-4, 1.0d-4,  1.0d-4 ] ) .vc.                         &
         mf( [ 1.0d-6, 1.0d-10, 1.0d-6 ] )
   tol = .t. tol
   call msFormat( exponent="sci" )
   call msDisplay( tol, "tol" )
   call msFormat( )
   call msRelease(options_DE)
   options_DE%tol = tol
   options_DE%IC_known = .false.
   call msDaeSolve( mfOut(y,status,new_err,yp,solve_log),               &
                    resid_chem_kinetics, t_span, y_0, yp_0, options_DE )
   call msFormat( exponent="sci" )
   y_out = t_span .hc. y
   call msDisplay( y_out, "time (col 1); numerical result: y(1:3) (col 2-4)" )
   yp_out = t_span .hc. yp
   call msDisplay( yp_out, "time (col 1); derivatives: yp(1:3) (col 2-4)" )
   call msFormat( )
   call msDisplay( status, "returned status" )
   if( mfDble(status) == dble(-2) ) then
      call msDisplay( new_err, "new optim. error" )
   else
      print *, "imposed relat. error was acceptable."
   end if
   call msDisplay( mfGet(solve_log,1), "[statistics] nb_step" )
   call msDisplay( mfGet(solve_log,2), "[statistics] dt_min" )
   call msDisplay( mfGet(solve_log,3), "[statistics] dt_max" )
   call msDisplay( mfGet(solve_log,4), "[statistics] nb_resid" )
   call msDisplay( mfGet(solve_log,5), "[statistics] nb_jac" )
   call msDisplay( mfGet(solve_log,6), "[statistics] nb_solv" )

   print "(/,A)", "*** test number 129 ***"
   print "()"
   print *, "same example as before except a user Jacobian is provided"
   t_span = .t. mf( [ 0.0d0, 0.4d0, 4.0d0, 4.0d1, 4.0d2, 4.0d3, 4.0d4,  &
                      4.0d5, 4.0d6, 4.0d7, 4.0d8, 4.0d9, 4.0d10 ] )
   y_0 = [ 1.0d0, 0.0d0, 0.0d0 ]
   yp_0 = [ -0.04d0, 0.04d0, 0.0d0 ]
   tol = mf( [ 1.0d-4, 1.0d-4,  1.0d-4 ] ) .vc.                         &
         mf( [ 1.0d-6, 1.0d-10, 1.0d-6 ] )
   tol = .t. tol
   call msFormat( exponent="sci" )
   call msDisplay( tol, "tol" )
   call msFormat( )
   call msRelease(options_DE)
   options_DE%tol = tol
   options_DE%IC_known = .false.
   call msDaeSolve( mfOut(y,status,new_err,yp,solve_log),               &
                    resid_chem_kinetics, t_span, y_0, yp_0, options_DE, &
                    jac=jac_chem_kinetics )
   call msFormat( exponent="sci" )
   y_out = t_span .hc. y
   call msDisplay( y_out, "time (col 1); numerical result: y(1:3) (col 2-4)" )
   yp_out = t_span .hc. yp
   call msDisplay( yp_out, "time (col 1); derivatives: yp(1:3) (col 2-4)" )
   call msFormat( )
   call msDisplay( status, "returned status" )
   if( mfDble(status) == dble(-2) ) then
      call msDisplay( new_err, "new optim. error" )
   else
      print *, "imposed relat. error was acceptable."
   end if
   call msDisplay( mfGet(solve_log,1), "[statistics] nb_step" )
   call msDisplay( mfGet(solve_log,2), "[statistics] dt_min" )
   call msDisplay( mfGet(solve_log,3), "[statistics] dt_max" )
   call msDisplay( mfGet(solve_log,4), "[statistics] nb_resid" )
   call msDisplay( mfGet(solve_log,5), "[statistics] nb_jac" )
   call msDisplay( mfGet(solve_log,6), "[statistics] nb_solv" )

   ! testing MF_NO_ARG and the output of t_log
   print "(/,A)", "*** test number 130 ***"
   print "()"
   print *, "same example as before except a user Jacobian is provided"
   t_span = .t. mf( [ 0.0d0, 0.4d0, 4.0d0, 4.0d1, 4.0d2, 4.0d3, 4.0d4,  &
                      4.0d5, 4.0d6, 4.0d7, 4.0d8, 4.0d9, 4.0d10 ] )
   y_0 = [ 1.0d0, 0.0d0, 0.0d0 ]
   yp_0 = [ -0.04d0, 0.04d0, 0.0d0 ]
   tol = mf( [ 1.0d-4, 1.0d-4,  1.0d-4 ] ) .vc.                         &
         mf( [ 1.0d-6, 1.0d-10, 1.0d-6 ] )
   tol = .t. tol
   call msFormat( exponent="sci" )
   call msDisplay( tol, "tol" )
   call msFormat( )
   call msRelease(options_DE)
   options_DE%tol = tol
   options_DE%IC_known = .false.
   call msDaeSolve( mfOut(y,status,MF_NO_ARG,MF_NO_ARG,MF_NO_ARG,MF_NO_ARG, &
                          t_log,order_log),                             &
                    resid_chem_kinetics, t_span, y_0, yp_0, options_DE, &
                    jac=jac_chem_kinetics )
   call msFormat( exponent="sci" )
   y_out = t_span .hc. y
   call msDisplay( y_out, "time (col 1); numerical result: y(1:3) (col 2-4)" )
   yp_out = t_span .hc. yp
   call msDisplay( yp_out, "time (col 1); derivatives: yp(1:3) (col 2-4)" )
   call msDisplay( status, "returned status" )
   call msDisplay( .t. t_log, "t_log", head=5, tail=5 )
   call msFormat( )
   ! removing the first element (always equal to NaN)
   order_log = mfGet( order_log, 2 .to. MF_END )
   call msDisplay( .t. order_log, "order_log", head=22, tail=22 )
   print "(2X,A,I0)", "max. order reached = ", mfInt(mfMax(order_log))

   print "(/,A)", "*** test number 131 ***"
   print "()"
   print *, "same example as before except that some components of y_0 or yp_0"
   print *, "are unknown"
   t_span = .t. mf( [ 0.0d0, 0.4d0, 4.0d0, 4.0d1, 4.0d2, 4.0d3, 4.0d4,  &
                      4.0d5, 4.0d6, 4.0d7, 4.0d8, 4.0d9, 4.0d10 ] )

   ! exacte initial values are:
   !   y_0 = [ 1.0d0, 0.0d0, 0.0d0 ]
   !   yp_0 = [ -0.04d0, 0.04d0, 0.0d0 ]

   ! guess values not too far from the exact solution
   y_0 = [ 1.0d0, 0.0d0, 1.0d0 ]
   yp_0 = [ 1.0d0, -1.0d0, 0.0d0 ]

   tol = mf( [ 1.0d-4, 1.0d-4,  1.0d-4 ] ) .vc.                         &
         mf( [ 1.0d-6, 1.0d-10, 1.0d-6 ] )
   tol = .t. tol
   call msFormat( exponent="sci" )
   call msDisplay( tol, "tol" )
   call msFormat( )
   call msRelease(options_DE)
   options_DE%tol = tol
   options_DE%IC_known = .false.

   ! prescribed indices are the following:
   ! (not all cases are possible, due to the nature of the DAE system --
   !  see the same mfDaeSolve example)

   ! ok
!!   options_DE%y0_ind  = [ 0, 1, 0 ]
!!   options_DE%yp0_ind = [ 1, 0, 1 ]

   ! ok
   options_DE%y0_ind  = [ 1, 1, 0 ]
   options_DE%yp0_ind = [ 0, 0, 1 ]

   call msDaeSolve( mfOut(y,status,new_err,yp,solve_log),               &
                    resid_chem_kinetics, t_span, y_0, yp_0, options_DE, &
                    jac=jac_chem_kinetics )
   call msFormat( exponent="sci" )
   y_out = t_span .hc. y
   call msDisplay( y_out, "time (col 1); numerical result: y(1:3) (col 2-4)" )
   print *, "(*) Note, above, that y(3) keeps its value given at initial time... this is due"
   print *, "    to the nature of the DAE system and the algorithm used in CIC."
   yp_out = t_span .hc. yp
   call msDisplay( yp_out, "time (col 1); derivatives: yp(1:3) (col 2-4)" )
   call msFormat( )
   call msDisplay( status, "returned status" )
   if( mfDble(status) == dble(-2) ) then
      call msDisplay( new_err, "new optim. error" )
   else
      print *, "imposed relat. error was acceptable."
   end if

   print "(/,A)", "*** test number 132 ***"
   print "()"
   print *, "same example as before but with non-negativity constraints"
   print *, "for all variables"
   t_span = .t. mf( [ 0.0d0, 0.4d0, 4.0d0, 4.0d1, 4.0d2, 4.0d3, 4.0d4,  &
                      4.0d5, 4.0d6, 4.0d7, 4.0d8, 4.0d9, 4.0d10 ] )
   y_0 = [ 1.0d0, 0.0d0, 0.0d0 ]
   yp_0 = [ -0.04d0, 0.04d0, 0.0d0 ]
   tol = mf( [ 1.0d-4, 1.0d-4,  1.0d-4 ] ) .vc.                         &
         mf( [ 1.0d-6, 1.0d-10, 1.0d-6 ] )
   tol = .t. tol
   call msFormat( exponent="sci" )
   call msDisplay( tol, "tol" )
   call msFormat( )
   call msRelease(options_DE)
   options_DE%tol = tol
   options_DE%IC_known = .false.
   options_DE%non_neg = [1,2,3]
   call msDaeSolve( mfOut(y,status,new_err,yp,solve_log),               &
                    resid_chem_kinetics, t_span, y_0, yp_0, options_DE, &
                    jac=jac_chem_kinetics )
   call msFormat( exponent="sci" )
   y_out = t_span .hc. y
   call msDisplay( y_out, "time (col 1); numerical result: y(1:3) (col 2-4)" )
   call msFormat( )
   call msDisplay( status, "returned status" )
   if( mfDble(status) == dble(-2) ) then
      call msDisplay( new_err, "new optim. error" )
   else
      print *, "imposed relat. error was acceptable."
   end if
   call msDisplay( mfGet(solve_log,1), "[statistics] nb_step" )
   call msDisplay( mfGet(solve_log,2), "[statistics] dt_min" )
   call msDisplay( mfGet(solve_log,3), "[statistics] dt_max" )
   call msDisplay( mfGet(solve_log,4), "[statistics] nb_resid" )
   call msDisplay( mfGet(solve_log,5), "[statistics] nb_jac" )
   call msDisplay( mfGet(solve_log,6), "[statistics] nb_solv" )

   print "(/,A)", "*** test number 133 ***"
   print "()"
   print *, "integration of {y' =  2*t}"
   print *, '               with the "Illegal condition" : 1 < y'
   print *, "  [ solution is: y(t) = t**2 ]"
   t_0 = 0.0d0
   t_end = 2.0d0
   t_span = .t. mf( [ t_0, t_end ] )
   call msDisplay( t_span, "input t_span" )
   y_0 = [ 0.0d0 ]
   yp_0 = [ 0.0d0 ]
   call msRelease(options_DE)
   options_DE%tol = 1.0d-6
   call msDaeSolve( mfOut(y,status,tolout,yp,solve_log),                &
                    resid_illegal_condition, t_span, y_0, yp_0, options_DE )
   call msDisplay( status, "returned status" )
   call msDisplay( mfGet(solve_log,1), "[statistics] nb_step" )
   call msDisplay( mfGet(solve_log,2), "[statistics] dt_min" )
   call msDisplay( mfGet(solve_log,3), "[statistics] dt_max" )
   call msDisplay( mfGet(solve_log,4), "[statistics] nb_resid" )
   call msDisplay( t_span, "output t_span" )
   call msDisplay( y, "numerical result (y)" )
   call msDisplay( yp, "numerical result (yp)" )

   print "(/,A)", "*** test number 134 ***"
   print "()"
   print *, "integration of {y' =  2*t}"
   print *, '               with the "Illegal condition" : 1 < y'
   print *, "  [ solution is: y(t) = t**2 ]"
   t_0 = 0.0d0
   t_end = 2.0d0
   t_span = .t. mf( [ t_0, t_end ] )
   t_span = .t. mfLinSpace( t_0, t_end, 21 )
   call msDisplay( t_span, "input t_span" )
   y_0 = [ 0.0d0 ]
   yp_0 = [ 0.0d0 ]
   call msRelease(options_DE)
   options_DE%tol = 1.0d-6
   call msDaeSolve( mfOut(y,status,tolout,yp,solve_log),                &
                    resid_illegal_condition, t_span, y_0, yp_0, options_DE )
   call msDisplay( status, "returned status" )
   call msDisplay( mfGet(solve_log,1), "[statistics] nb_step" )
   call msDisplay( mfGet(solve_log,2), "[statistics] dt_min" )
   call msDisplay( mfGet(solve_log,3), "[statistics] dt_max" )
   call msDisplay( mfGet(solve_log,4), "[statistics] nb_resid" )
   ! find the first row containing NaNs
   k = size(t_span)
   do i = 1, size(t_span)
      if( all(mfIsNaN( mfGet(t_span,i) )) ) then
         k = i - 1
         exit
      end if
   end do
   y_out = mfGet(t_span,1 .to. k) .hc. mfGet(y,1 .to. k)                &
                                  .hc. mfGet(yp,1 .to. k)
   call msDisplay( y_out, "    time        y        yp" )

   print "(/,A)", "*** test number 135 ***"
   print "()"
   print *, "integration of {y' =  2*t}"
   print *, '               with the "Emergency exit" : 1 < y'
   print *, "  [ solution is: y(t) = t**2 ]"
   t_0 = 0.0d0
   t_end = 2.0d0
   t_span = .t. mf( [ t_0, t_end ] )
   call msDisplay( t_span, "input t_span" )
   y_0 = [ 0.0d0 ]
   yp_0 = [ 0.0d0 ]
   call msRelease(options_DE)
   options_DE%tol = 1.0d-6
   call msDaeSolve( mfOut(y,status,tolout,yp,solve_log),                &
                    resid_emergency_exit, t_span, y_0, yp_0, options_DE )
   call msDisplay( status, "returned status" )
   call msDisplay( mfGet(solve_log,1), "[statistics] nb_step" )
   call msDisplay( mfGet(solve_log,2), "[statistics] dt_min" )
   call msDisplay( mfGet(solve_log,3), "[statistics] dt_max" )
   call msDisplay( mfGet(solve_log,4), "[statistics] nb_resid" )
   call msDisplay( t_span, "output t_span" )
   call msDisplay( y, "numerical result (y)" )
   call msDisplay( yp, "numerical result (yp)" )

   print "(/,A)", "*** test number 136 ***"
   print "()"
   print *, "integration of {y' =  2*t}"
   print *, '               with the "Emergency exit" : 1 < y'
   print *, "  [ solution is: y(t) = t**2 ]"
   t_0 = 0.0d0
   t_end = 2.0d0
   t_span = .t. mf( [ t_0, t_end ] )
   t_span = .t. mfLinSpace( t_0, t_end, 21 )
   call msDisplay( t_span, "input t_span" )
   y_0 = [ 0.0d0 ]
   yp_0 = [ 0.0d0 ]
   call msRelease(options_DE)
   options_DE%tol = 1.0d-6
   call msDaeSolve( mfOut(y,status,tolout,yp,solve_log),                &
                    resid_emergency_exit, t_span, y_0, yp_0, options_DE )
   call msDisplay( status, "returned status" )
   call msDisplay( mfGet(solve_log,1), "[statistics] nb_step" )
   call msDisplay( mfGet(solve_log,2), "[statistics] dt_min" )
   call msDisplay( mfGet(solve_log,3), "[statistics] dt_max" )
   call msDisplay( mfGet(solve_log,4), "[statistics] nb_resid" )
   ! find the first row containing NaNs
   k = size(t_span)
   do i = 1, size(t_span)
      if( all(mfIsNaN( mfGet(t_span,i) )) ) then
         k = i - 1
         exit
      end if
   end do
   y_out = mfGet(t_span,1 .to. k) .hc. mfGet(y,1 .to. k)                &
                                  .hc. mfGet(yp,1 .to. k)
   call msDisplay( y_out, "    time        y        yp" )

   print "(/,A)", "*** test number 137 ***"
   print "()"
   print *, "integration of {y' =  2*t}"
   print *, '               with the "End condition" : 1 < y'
   print *, "  [ solution is: y(t) = t**2 ]"
   t_0 = 0.0d0
   t_end = 2.0d0
   t_span = .t. mf( [ t_0, t_end ] )
   call msDisplay( t_span, "input t_span" )
   y_0 = [ 0.0d0 ]
   yp_0 = [ 0.0d0 ]
   call msRelease(options_DE)
   options_DE%tol = 1.0d-6
   call msDaeSolve( mfOut(y,status,tolout,yp,solve_log),                &
                    resid_end_condition, t_span, y_0, yp_0, options_DE )
   call msDisplay( status, "returned status" )
   call msDisplay( mfGet(solve_log,1), "[statistics] nb_step" )
   call msDisplay( mfGet(solve_log,2), "[statistics] dt_min" )
   call msDisplay( mfGet(solve_log,3), "[statistics] dt_max" )
   call msDisplay( mfGet(solve_log,4), "[statistics] nb_resid" )
   call msDisplay( t_span, "output t_span" )
   call msDisplay( y, "numerical result (y)" )
   call msDisplay( yp, "numerical result (yp)" )

   print "(/,A)", "*** test number 138 ***"
   print "()"
   print *, "integration of {y' =  2*t}"
   print *, '               with the "End condition" : 1 < y'
   print *, "  [ solution is: y(t) = t**2 ]"
   t_0 = 0.0d0
   t_end = 2.0d0
   t_span = .t. mf( [ t_0, t_end ] )
   t_span = .t. mfLinSpace( t_0, t_end, 21 )
   call msDisplay( t_span, "input t_span" )
   y_0 = [ 0.0d0 ]
   yp_0 = [ 0.0d0 ]
   call msRelease(options_DE)
   options_DE%tol = 1.0d-6
   call msDaeSolve( mfOut(y,status,tolout,yp,solve_log),                &
                    resid_end_condition, t_span, y_0, yp_0, options_DE )
   call msDisplay( status, "returned status" )
   call msDisplay( mfGet(solve_log,1), "[statistics] nb_step" )
   call msDisplay( mfGet(solve_log,2), "[statistics] dt_min" )
   call msDisplay( mfGet(solve_log,3), "[statistics] dt_max" )
   call msDisplay( mfGet(solve_log,4), "[statistics] nb_resid" )
   ! find the first row containing NaNs
   k = size(t_span)
   do i = 1, size(t_span)
      if( all(mfIsNaN( mfGet(t_span,i) )) ) then
         k = i - 1
         exit
      end if
   end do
   y_out = mfGet(t_span,1 .to. k) .hc. mfGet(y,1 .to. k)                &
                                  .hc. mfGet(yp,1 .to. k)
   call msDisplay( y_out, "    time        y        yp" )

   print "(/,A)", "*** test number 139 ***"
   print "()"
   print *, "integration of {y' =  2*t}"
   print *, '               with the "Combined condition" : 0.99 <= y <= 1.01'
   print *, "  [ solution is: y(t) = t**2 ]"
   t_0 = 0.0d0
   t_end = 2.0d0
   t_span = .t. mf( [ t_0, t_end ] )
   call msDisplay( t_span, "input t_span" )
   y_0 = [ 0.0d0 ]
   yp_0 = [ 0.0d0 ]
   call msRelease(options_DE)
   options_DE%tol = 1.0d-6
   call msDaeSolve( mfOut(y,status,tolout,yp,solve_log),                &
                    resid_combined_conditions, t_span, y_0, yp_0, options_DE )
   call msDisplay( status, "returned status" )
   call msDisplay( mfGet(solve_log,1), "[statistics] nb_step" )
   call msDisplay( mfGet(solve_log,2), "[statistics] dt_min" )
   call msDisplay( mfGet(solve_log,3), "[statistics] dt_max" )
   call msDisplay( mfGet(solve_log,4), "[statistics] nb_resid" )
   call msDisplay( t_span, "output t_span" )
   call msDisplay( y, "numerical result (y)" )
   call msDisplay( yp, "numerical result (yp)" )

   print "(/,A)", "*** test number 140 ***"
   print "()"
   print *, "integration of {y' =  2*t}"
   print *, '               with the "Combined condition" : 0.99 <= y <= 1.01'
   print *, "  [ solution is: y(t) = t**2 ]"
   t_0 = 0.0d0
   t_end = 2.0d0
   t_span = .t. mfLinSpace( t_0, t_end, 21 )
   call msDisplay( t_span, "input t_span" )
   y_0 = [ 0.0d0 ]
   yp_0 = [ 0.0d0 ]
   call msRelease(options_DE)
   options_DE%tol = 1.0d-6
   call msDaeSolve( mfOut(y,status,tolout,yp,solve_log),                &
                    resid_combined_conditions, t_span, y_0, yp_0, options_DE )
   call msDisplay( status, "returned status" )
   call msDisplay( mfGet(solve_log,1), "[statistics] nb_step" )
   call msDisplay( mfGet(solve_log,2), "[statistics] dt_min" )
   call msDisplay( mfGet(solve_log,3), "[statistics] dt_max" )
   call msDisplay( mfGet(solve_log,4), "[statistics] nb_resid" )
   ! find the first row containing NaNs
   k = size(t_span)
   do i = 1, size(t_span)
      if( all(mfIsNaN( mfGet(t_span,i) )) ) then
         k = i - 1
         exit
      end if
   end do
   y_out = mfGet(t_span,1 .to. k) .hc. mfGet(y,1 .to. k)                &
                                  .hc. mfGet(yp,1 .to. k)
   call msDisplay( y_out, "    time        y        yp" )

   print "(/,A)", "*** test number 141 ***"
   print "()"
   print *, "integration of {y' =  -1/sqrt(y)} (singular ODE)"
   print *, '               with the "Illegal condition" : y <= 0'
   print *, "  [ solution is: y(t) = 1/4*(8-12*t)**(2/3) ]"
   t_0 = 0.0d0
   t_end = 2.0d0
   t_span = .t. mf( [ t_0, t_end ] )
   call msDisplay( t_span, "input t_span" )
   y_0 = [ 1.0d0 ]
   yp_0 = [ -1.0d0 ]
   call msRelease(options_DE)
   options_DE%tol = 1.0d-6
   call msDaeSolve( mfOut(y,status,tolout,yp,solve_log),                &
                    resid_illegal_condition_sing, t_span, y_0, yp_0, options_DE )
   call msDisplay( status, "returned status" )
   call msDisplay( mfGet(solve_log,1), "[statistics] nb_step" )
   call msDisplay( mfGet(solve_log,2), "[statistics] dt_min" )
   call msDisplay( mfGet(solve_log,3), "[statistics] dt_max" )
   call msDisplay( mfGet(solve_log,4), "[statistics] nb_resid" )
   call msDisplay( mf(2.0d0/3.0d0), "exact answer (last t)" )
   call msDisplay( mfGet(t_span,MF_END), "output t for singularity" )
   call msDisplay( mf(0.0d0), "exact answer (y)" )
   call msDisplay( y, "numerical result (y)" )
   call msDisplay( -MF_INF, "exact answer (yp)" )
   call msDisplay( yp, "numerical result (yp)" )

   print "(/,A)", "*** test number 142 ***"
   print "()"
   print *, "integration of {y' =  -1/sqrt(y)} (singular ODE)"
   print *, '               with the "Illegal condition" : y <= 0'
   print *, "  [ solution is: y(t) = 1/4*(8-12*t)**(2/3) ]"
   t_0 = 0.0d0
   t_end = 2.0d0
   t_span = .t. mfLinSpace( t_0, t_end, 51 )
   call msDisplay( t_span, "input t_span" )
   y_0 = [ 1.0d0 ]
   yp_0 = [ -1.0d0 ]
   call msRelease(options_DE)
   options_DE%tol = 1.0d-6
   call msDaeSolve( mfOut(y,status,tolout,yp,solve_log),                &
                    resid_illegal_condition_sing, t_span, y_0, yp_0, options_DE )
   call msDisplay( status, "returned status" )
   call msDisplay( mfGet(solve_log,1), "[statistics] nb_step" )
   call msDisplay( mfGet(solve_log,2), "[statistics] dt_min" )
   call msDisplay( mfGet(solve_log,3), "[statistics] dt_max" )
   call msDisplay( mfGet(solve_log,4), "[statistics] nb_resid" )
   ! find the first row containing NaNs
   k = size(t_span)
   do i = 1, size(t_span)
      if( all(mfIsNaN( mfGet(t_span,i) )) ) then
         k = i - 1
         exit
      end if
   end do
   y_out = mfGet(t_span,1 .to. k) .hc. mfGet(y,1 .to. k)                &
                                  .hc. mfGet(yp,1 .to. k)
   call msFormat( exponent="sci" )
   call msDisplay( y_out, "    time           y           yp" )
   call msFormat( )

   ! mfTrapz -----------------------------------------------------------
   call print_separation("mfTrapz")

   ! one argument call
   print "(/,A)", "*** test number 143 ***"
   print "()"
   print *, "integration of 3*x**2 over [ 0, 10 ]"
   print *, "  (using unit spacing, i.e. 10 intervals)"
   x = mfColon( 0.0d0, 10.0d0 )
   y = 3.0d0 * x**2
   res = mfTrapz( y )
   print "(/,A,ES12.5)", " numerical result = ", res
   print *, "theoretical result = 1000"

   print "(/,A)", "*** test number 144 ***"
   print "()"
   print *, "integration of 3*x**2 over [ 0, 10 ]"
   print *, "  (using 100 intervals)"
   x = mfLinSpace( 0.0d0, 10.0d0, 101 )
   y = 3.0d0 * x**2
   res = mfTrapz( y ) * 0.1d0
   print "(/,A,ES12.5)", " numerical result = ", res
   print *, "theoretical result = 1000"

   ! two arguments call
   print "(/,A)", "*** test number 145 ***"
   print "()"
   print *, "integration of sin(x) over [ 0, Pi ]"
   print *, "  (using 100 intervals)"
   x = mfLinSpace( 0.0d0, MF_PI, 101 )
   y = mfSin( x )
   res = mfTrapz( x, y )
   print "(/,A,ES12.5)", " numerical result = ", res
   print *, "theoretical result = 2"

   ! non uniform spacing
   print "(/,A)", "*** test number 146 ***"
   print "()"
   print *, "integration of 'sqrt(x)' over [0,1]"
   print *, "  (using 100 unequal intervals)"
   ! primary uniform grid
   x = mfLinSpace( 0.0d0, 1.0d0, 101 )
   ! stretching of this grid
   x = x**2
   y = mfSqrt( x )
   res = mfTrapz( x, y )
   print "(/,A,ES12.5)", " numerical result = ", res
   print *, "theoretical result = 2/3"
   print "()"

   ! mfSimpson ---------------------------------------------------------
   call print_separation("mfSimpson")

   print "(/,A)", "*** test number 147 ***"
   print "()"
   print *, "integration of 3*x**2 over [ 0, 10 ]"
   print *, "  (using unit spacing, i.e. 10 intervals)"
   x = mfColon( 0.0d0, 10.0d0 )
   y = 3.0d0 * x**2
   res = mfSimpson( y )
   print "(/,A,ES12.5)", " numerical result = ", res
   print *, "theoretical result = 1000"

   ! unequally spaced abscissa
   print "(/,A)", "*** test number 148 ***"
   print "()"
   print *, "integration of 3*x**2 over 10 unequal intervals)"
   x = [ 0.00d0, 0.75d0, 0.95d0, 2.03d0, 2.45d0, 2.98d0,                &
                 4.50d0, 5.20d0, 6.00d0, 8.00d0, 10.0d0 ]
   y = 3.0d0 * x**2
   res = mfSimpson( x, y )
   print "(/,A,ES12.5)", " numerical result = ", res
   print *, "theoretical result = 1000"

   print "(/,A)", "*** test number 149 ***"
   print "()"
   print *, "integration of sin(x) over [ 0, Pi ]"
   print *, "  (using 100 intervals)"
   x = mfLinSpace( 0.0d0, MF_PI, 101 )
   y = mfSin( x )
   res = mfSimpson( y ) * MF_PI/100.0d0
   print "(/,A,ES12.5)", " numerical result = ", res
   print *, "theoretical result = 2"

   print "(/,A)", "*** test number 150 ***"
   print "()"
   print *, "integration of 'sqrt(x)' over [0,1]"
   print *, "  (using 100 intervals)"
   x = mfLinSpace( 0.0d0, 1.0d0, 101 )
   y = mfSqrt( x )
   res = mfSimpson( y ) * 0.01d0
   print "(/,A,ES12.5)", " numerical result = ", res
   print *, "theoretical result = 2/3"
   print "()"

   ! mfFZero, msFZero --------------------------------------------------
   call print_separation("mfFZero, msFZero")

   ! search in a given interval
   print "(/,A)", "*** test number 151 ***"
   print "()"
   print *, "searching zero of 'x**2-0.5' in [0,1]"
   res = mfFZero( fun_sqr_minus_onehalf, x0=mf([ 0, 1 ]) )
   print "(/,A,F12.8)", " numerical result = ", res
   print *, "theoretical result = 0.70710678"

   print "(/,A)", "*** test number 152 ***"
   print "()"
   print *, "searching zero of 'tan(x)' in [1,2]"
   res = mfFZero( fun_tan, x0=mf([ 1, 2 ]) )
   print "(/,A,F12.8)", " numerical result   = ", res
   print "(A,F12.8)",   " theoretical result = ", MF_PI/2

   print "(/,A)", "*** test number 153 ***"
   print "()"
   print *, "searching zero of 'tan(x)' in [1,2]"
   call msFZero( mfOut(y,val), fun_tan, x0=mf([ 1, 2 ]) )
   print "(/,A,F12.8)", " numerical result   = ", mfDble(y)
   print "(A,F12.8)",   " theoretical result = ", MF_PI/2
   print "(A,ES11.3)", " value of the function = ", mfDble(val)
   print "()"

   ! mfFSolve ----------------------------------------------------------
   call print_separation("mfFSolve")

   print "(/,A)", "*** test number 154 ***"
   print "()"
   print *, "searching zero of 2 eqn of 2 variables (first ex. of Matlab)"
   x = mfFSolve( exp_fcn, n=2, x0=mf([ -5, -5 ]) )
   call msDisplay( x, "x" )

   print "(/,A)", "*** test number 155 ***"
   print "()"
   print *, "searching zero of 2 eqn of 2 variables (first ex. of Matlab)"
   x = mfFSolve( exp_fcn, n=2, x0=mf([ -5, -5 ]), jac=exp_fcn_jac )
   call msDisplay( x, "x" )

   print "(/,A)", "*** test number 156 ***"
   print "()"
   print *, "searching zero of 2 eqn of 2 variables (first ex. of Matlab)"
   call msRelease( options_NL )
   options_NL%tol = 1.0d-12
   x = mfFSolve( exp_fcn, n=2, x0=mf([ -5, -5 ]), options=options_NL )
   call msFormat( "long" )
   call msDisplay( x, "x" )
   call msFormat( )

   print "(/,A)", "*** test number 157 ***"
   print "()"
   print *, "searching zero of 2 eqn of 2 variables (first ex. of Matlab)"
   call msRelease( options_NL )
   options_NL%tol = 1.0d-12
   x = mfFSolve( exp_fcn, n=2, x0=mf([ -5, -5 ]), options=options_NL,   &
                 jac=exp_fcn_jac )
   call msFormat( "long" )
   call msDisplay( x, "x" )
   call msFormat( )

   print "(/,A)", "*** test number 158 ***"
   print "()"
   print *, "searching zero of 3 eqn of 3 variables (ex. #1 of Octave-4.2.1)"
   x = mfFSolve( fcn_oct_1, n=3, x0=mf([ 0.5d0, 2.0d0, 2.5d0 ]) )
   call msDisplay( x, "x" )

   print "(/,A)", "*** test number 159 ***"
   print "()"
   print *, "searching zero of 3 eqn of 3 variables (ex. #1 of Octave-4.2.1)"
   x = mfFSolve( fcn_oct_1, n=3, x0=mf([ 0.5d0, 2.0d0, 2.5d0 ]),        &
                 jac=fcn_oct_1_jac )
   call msDisplay( x, "x" )

   print "(/,A)", "*** test number 160 ***"
   print "()"
   print *, "searching zero of 3 eqn of 3 variables (ex. #1 of Octave-4.2.1)"
   options_NL%tol = 1.0d-12
   x = mfFSolve( fcn_oct_1, n=3, x0=mf([ 0.5d0, 2.0d0, 2.5d0 ]),        &
                 options=options_NL )
   call msFormat( "long" )
   call msDisplay( x, "x" )
   call msFormat( )

   print "(/,A)", "*** test number 161 ***"
   print "()"
   print *, "searching zero of 3 eqn of 3 variables (ex. #1 of Octave-4.2.1)"
   options_NL%tol = 1.0d-12
   x = mfFSolve( fcn_oct_1, n=3, x0=mf([ 0.5d0, 2.0d0, 2.5d0 ]),        &
                 options=options_NL, jac=fcn_oct_1_jac )
   call msFormat( "long" )
   call msDisplay( x, "x" )
   call msFormat( )

   print "(/,A)", "*** test number 162 ***"
   print "()"
   print *, "searching zero of 4 eqn of 4 variables (ex. #2 of Octave-4.2.1)"
   x = mfFSolve( fcn_oct_2, n=4, x0=mf([ -1, 1, 2, -1 ]) )
   call msDisplay( x, "x" )

   print "(/,A)", "*** test number 163 ***"
   print "()"
   print *, "searching zero of 4 eqn of 4 variables (ex. #2 of Octave-4.2.1)"
   x = mfFSolve( fcn_oct_2, n=4, x0=mf([ -1, 1, 2, -1 ]),               &
                 jac=fcn_oct_2_jac )
   call msDisplay( x, "x" )

   print "(/,A)", "*** test number 164 ***"
   print "()"
   print *, "searching zero of 4 eqn of 4 variables (ex. #2 of Octave-4.2.1)"
   options_NL%tol = 1.0d-12
   x = mfFSolve( fcn_oct_2, n=4, x0=mf([ -1, 1, 2, -1 ]),               &
                 options=options_NL )
   call msFormat( "long" )
   call msDisplay( x, "x" )
   call msFormat( )

   print "(/,A)", "*** test number 165 ***"
   print "()"
   print *, "searching zero of 4 eqn of 4 variables (ex. #2 of Octave-4.2.1)"
   options_NL%tol = 1.0d-12
   x = mfFSolve( fcn_oct_2, n=4, x0=mf([ -1, 1, 2, -1 ]),               &
                 options=options_NL, jac=fcn_oct_2_jac )
   call msFormat( "long" )
   call msDisplay( x, "x" )
   call msFormat( )

   print "(/,A)", "*** test number 166 ***"
   print "()"
   print *, "searching zero of 4 eqn of 4 variables (other ex. for sparse test)"
   x = mfFSolve( fcn_4_ec, n=4, x0=mf([ 0.8, 1.2, 0.8, 1.2 ]) )
   call msDisplay( x, "x" )

   print "(/,A)", "*** test number 167 ***"
   print "()"
   print *, "searching zero of 4 eqn of 4 variables (other ex. for sparse test)"
   x = mfFSolve( fcn_4_ec, n=4, x0=mf([ 0.8, 1.2, 0.8, 1.2 ]),          &
                 jac=fcn_4_ec_spjac, sparse=.true. )
   call msDisplay( x, "x" )

   print "(/,A)", "*** test number 168 ***"
   print "()"
   print *, "searching zero of 4 eqn of 4 variables (other ex. for sparse test)"
   options_NL%tol = 1.0d-12
   x = mfFSolve( fcn_4_ec, n=4, x0=mf([ 0.8, 1.2, 0.8, 1.2 ]),          &
                 options=options_NL, jac=fcn_4_ec_spjac, sparse=.true. )
   call msFormat( "long" )
   call msDisplay( x, "x" )
   call msFormat( )

   ! msFSolve ----------------------------------------------------------
   call print_separation("msFSolve")

   print "(/,A)", "*** test number 169 ***"
   print "()"
   print *, "searching zero of 2 eqn of 2 variables (first ex. of Matlab)"
   call msFSolve( mfOut(x,fvec,status), exp_fcn, n=2, x0=mf([ -5, -5 ]) )
   call msDisplay( x, "x" )
   call msDisplay( fvec, "fvec" )
   call msDisplay( status, "status" )

   print "(/,A)", "*** test number 170 ***"
   print "()"
   print *, "searching zero of 2 eqn of 2 variables (first ex. of Matlab)"
   call msFSolve( mfOut(x,fvec,status), exp_fcn, n=2, x0=mf([ -5, -5 ]), &
                  jac=exp_fcn_jac )
   call msDisplay( x, "x" )
   call msDisplay( fvec, "fvec" )
   call msDisplay( status, "status" )

   print "(/,A)", "*** test number 171 ***"
   print "()"
   print *, "searching zero of 2 eqn of 2 variables (first ex. of Matlab)"
   call msRelease( options_NL )
   options_NL%tol = 1.0d-12
   call msFSolve( mfOut(x,fvec,status), exp_fcn, n=2, x0=mf([ -5, -5 ]), &
                  options=options_NL )
   call msFormat( "long" )
   call msDisplay( x, "x" )
   call msFormat( )
   call msDisplay( fvec, "fvec" )
   call msDisplay( status, "status" )

   print "(/,A)", "*** test number 172 ***"
   print "()"
   print *, "searching zero of 2 eqn of 2 variables (first ex. of Matlab)"
   call msRelease( options_NL )
   options_NL%tol = 1.0d-12
   call msFSolve( mfOut(x,fvec,status), exp_fcn, n=2, x0=mf([ -5, -5 ]), &
                  options=options_NL, jac=exp_fcn_jac )
   call msFormat( "long" )
   call msDisplay( x, "x" )
   call msFormat( )
   call msDisplay( fvec, "fvec" )
   call msDisplay( status, "status" )

   print "(/,A)", "*** test number 173 ***"
   print "()"
   print *, "searching zero of 3 eqn of 3 variables (ex. #1 of Octave-4.2.1)"
   call msFSolve( mfOut(x,fvec,status), fcn_oct_1, n=3,                 &
                  x0=mf([ 0.5d0, 2.0d0, 2.5d0 ]) )
   call msDisplay( x, "x" )
   call msDisplay( fvec, "fvec" )
   call msDisplay( status, "status" )

   print "(/,A)", "*** test number 174 ***"
   print "()"
   print *, "searching zero of 3 eqn of 3 variables (ex. #1 of Octave-4.2.1)"
   call msFSolve( mfOut(x,fvec,status), fcn_oct_1, n=3,                 &
                  x0=mf([ 0.5d0, 2.0d0, 2.5d0 ]),                       &
                  jac=fcn_oct_1_jac )
   call msDisplay( x, "x" )
   call msDisplay( fvec, "fvec" )
   call msDisplay( status, "status" )

   print "(/,A)", "*** test number 175 ***"
   print "()"
   print *, "searching zero of 3 eqn of 3 variables (ex. #1 of Octave-4.2.1)"
   options_NL%tol = 1.0d-12
   call msFSolve( mfOut(x,fvec,status), fcn_oct_1, n=3,                 &
                  x0=mf([ 0.5d0, 2.0d0, 2.5d0 ]),                       &
                  options=options_NL )
   call msFormat( "long" )
   call msDisplay( x, "x" )
   call msDisplay( fvec, "fvec" )
   call msDisplay( status, "status" )
   call msFormat( )

   print "(/,A)", "*** test number 176 ***"
   print "()"
   print *, "searching zero of 3 eqn of 3 variables (ex. #1 of Octave-4.2.1)"
   options_NL%tol = 1.0d-12
   call msFSolve( mfOut(x,fvec,status), fcn_oct_1, n=3,                 &
                  x0=mf([ 0.5d0, 2.0d0, 2.5d0 ]),                       &
                  options=options_NL, jac=fcn_oct_1_jac )
   call msFormat( "long" )
   call msDisplay( x, "x" )
   call msDisplay( fvec, "fvec" )
   call msDisplay( status, "status" )
   call msFormat( )

   print "(/,A)", "*** test number 177 ***"
   print "()"
   print *, "searching zero of 4 eqn of 4 variables (ex. #2 of Octave-4.2.1)"
   call msFSolve( mfOut(x,fvec,status), fcn_oct_2, n=4,                 &
                  x0=mf([ -1, 1, 2, -1 ]) )
   call msDisplay( x, "x" )
   call msDisplay( fvec, "fvec" )
   call msDisplay( status, "status" )

   print "(/,A)", "*** test number 178 ***"
   print "()"
   print *, "searching zero of 4 eqn of 4 variables (ex. #2 of Octave-4.2.1)"
   call msFSolve( mfOut(x,fvec,status), fcn_oct_2, n=4,                 &
                  x0=mf([ -1, 1, 2, -1 ]), jac=fcn_oct_2_jac )
   call msDisplay( x, "x" )
   call msDisplay( fvec, "fvec" )
   call msDisplay( status, "status" )

   print "(/,A)", "*** test number 179 ***"
   print "()"
   print *, "searching zero of 4 eqn of 4 variables (ex. #2 of Octave-4.2.1)"
   options_NL%tol = 1.0d-12
   call msFSolve( mfOut(x,fvec,status), fcn_oct_2, n=4,                 &
                  x0=mf([ -1, 1, 2, -1 ]), options=options_NL )
   call msFormat( "long" )
   call msDisplay( x, "x" )
   call msDisplay( fvec, "fvec" )
   call msDisplay( status, "status" )
   call msFormat( )

   print "(/,A)", "*** test number 180 ***"
   print "()"
   print *, "searching zero of 4 eqn of 4 variables (ex. #2 of Octave-4.2.1)"
   options_NL%tol = 1.0d-12
   call msFSolve( mfOut(x,fvec,status), fcn_oct_2, n=4,                 &
                  x0=mf([ -1, 1, 2, -1 ]),                              &
                  options=options_NL, jac=fcn_oct_2_jac )
   call msFormat( "long" )
   call msDisplay( x, "x" )
   call msDisplay( fvec, "fvec" )
   call msDisplay( status, "status" )
   call msFormat( )

   print "(/,A)", "*** test number 181 ***"
   print "()"
   print *, "searching zero of 4 eqn of 4 variables (other ex. for sparse test)"
   call msFSolve( mfOut(x,fvec,status), fcn_4_ec, n=4,                  &
                  x0=mf([ 0.8, 1.2, 0.8, 1.2 ]) )
   call msDisplay( x, "x" )
   call msDisplay( fvec, "fvec" )
   call msDisplay( status, "status" )

   print "(/,A)", "*** test number 182 ***"
   print "()"
   print *, "searching zero of 4 eqn of 4 variables (other ex. for sparse test)"
   call msFSolve( mfOut(x,fvec,status), fcn_4_ec, n=4,                  &
                  x0=mf([ 0.8, 1.2, 0.8, 1.2 ]),                        &
                  jac=fcn_4_ec_spjac, sparse=.true. )
   call msDisplay( x, "x" )
   call msDisplay( fvec, "fvec" )
   call msDisplay( status, "status" )

   print "(/,A)", "*** test number 183 ***"
   print "()"
   print *, "searching zero of 4 eqn of 4 variables (other ex. for sparse test)"
   options_NL%tol = 1.0d-12
   call msFSolve( mfOut(x,fvec,status), fcn_4_ec, n=4,                  &
                  x0=mf([ 0.8, 1.2, 0.8, 1.2 ]),                        &
                  options=options_NL, jac=fcn_4_ec_spjac, sparse=.true. )
   call msFormat( "long" )
   call msDisplay( x, "x" )
   call msDisplay( fvec, "fvec" )
   call msDisplay( status, "status" )
   call msFormat( )

   ! mfLsqNonLin -------------------------------------------------------
   call print_separation("mfLsqNonLin")

   print "(/,A)", "*** test number 184 ***"
   print "()"
   print *, "Minimizing a nonlinear vector-valued function"
   print *, "(no initial guess)"

   m = 10
   n = 2
   p = MF_EMPTY
   z = mfLsqNonLin( m, exp_min, p, n )
   call msDisplay( z, "parameters after minimization" )
   if( Any(mfAbs(z-mf([1.0877,3.0444])) > 1.0d-4) ) then
      print *, "   *** mfLsqNonLin failed! ***   <---------------"
   end if

   print "(/,A)", "*** test number 185 ***"
   print "()"
   print *, "Minimizing a nonlinear vector-valued function"

   m = 10
   n = 2
   p = [ 2.0d0, 0.2d0 ]
   z = mfLsqNonLin( m, exp_min, p, n )
   call msDisplay( z, "parameters after minimization" )
   if( Any(mfAbs(z-mf([1.0881,3.0443])) > 1.0d-4) ) then
      print *, "   *** mfLsqNonLin failed! ***   <---------------"
   end if

   print "(/,A)", "*** test number 186 ***"
   print "()"
   print *, "Minimizing a nonlinear vector-valued function"

   m = 10
   n = 2
   p = [ 2.0d0, 0.2d0 ]
   call msRelease( options_NL )
   options_NL%tol = 1.0d-3
   z = mfLsqNonLin( m, exp_min, p, n, options_NL )
   call msDisplay( z, "parameters after minimization" )
   if( Any(mfAbs(z-mf([1.0881,3.0443])) > 1.0d-4) ) then
      print *, "   *** mfLsqNonLin failed! ***   <---------------"
   end if

   print "(/,A)", "*** test number 187 ***"
   print "()"
   print *, "Minimizing a nonlinear vector-valued function"
   print *, "(jacobian provided)"

   m = 10
   n = 2
   p = [ 2.0d0, 0.2d0 ]
   z = mfLsqNonLin( m, exp_min, p, n, jac=exp_min_jac )
   call msDisplay( z, "parameters after minimization" )
   if( Any(mfAbs(z-mf([1.0881,3.0443])) > 1.0d-4) ) then
      print *, "   *** mfLsqNonLin failed! ***   <---------------"
   end if

   print "(/,A)", "*** test number 188 ***"
   print "()"
   print *, "Minimizing a nonlinear vector-valued function"
   print *, "(jacobian provided)"

   m = 10
   n = 2
   p = [ 2.0d0, 0.2d0 ]
   call msRelease( options_NL )
   options_NL%tol = 1.0d-3
   z = mfLsqNonLin( m, exp_min, p, n, options_NL, jac=exp_min_jac )
   call msDisplay( z, "parameters after minimization" )
   if( Any(mfAbs(z-mf([1.0881,3.0443])) > 1.0d-4) ) then
      print *, "   *** mfLsqNonLin failed! ***   <---------------"
   end if

   print "(/,A)", "*** test number 189 ***"
   print "()"
   print *, "Minimizing a nonlinear vector-valued function"
   print *, "(jacobian provided, quick check)"

   m = 10
   n = 2
   p = [ 2.0d0, 0.2d0 ]
   call msRelease( options_NL )
   options_NL%tol = 1.0d-3
   options_NL%check_jac = 1
!!   options_NL%print_check_jac = 1
   z = mfLsqNonLin( m, exp_min, p, n, options_NL, jac=exp_min_jac )
   call msDisplay( z, "parameters after minimization" )
   if( Any(mfAbs(z-mf([1.0881,3.0443])) > 1.0d-4) ) then
      print *, "   *** mfLsqNonLin failed! ***   <---------------"
   end if

   print "(/,A)", "*** test number 190 ***"
   print "()"
   print *, "Minimizing a nonlinear vector-valued function"
   print *, "(jacobian provided, full check)"

   m = 10
   n = 2
   p = [ 2.0d0, 0.2d0 ]
   call msRelease( options_NL )
   options_NL%tol = 1.0d-3
   options_NL%check_jac = 2
!!   options_NL%print_check_jac = 1
   z = mfLsqNonLin( m, exp_min, p, n, options_NL, jac=exp_min_jac )
   call msDisplay( z, "parameters after minimization" )
   if( Any(mfAbs(z-mf([1.0881,3.0443])) > 1.0d-4) ) then
      print *, "   *** mfLsqNonLin failed! ***   <---------------"
   end if

   print "(/,A)", "*** test number 191 ***"
   print "()"
   print *, "Minimizing a nonlinear vector-valued function"
   print *, "(multiple tolerances)"

   m = 10
   n = 2
   p = [ 2.0d0, 0.2d0 ]
   call msRelease( options_NL )
   options_NL%tol = [ 1.0d-4, 1.0d-5, 1.0d-6 ]
   z = mfLsqNonLin( m, exp_min, p, n, options_NL )
   call msDisplay( z, "parameters after minimization" )
   if( Any(mfAbs(z-mf([1.0881,3.0443])) > 1.0d-4) ) then
      print *, "   *** mfLsqNonLin failed! ***   <---------------"
   end if

   print "(/,A)", "*** test number 192 ***"
   print "()"
   print *, "Minimizing a nonlinear vector-valued function"
   print *, "(jacobian provided, multiple tolerances)"

   m = 10
   n = 2
   p = [ 2.0d0, 0.2d0 ]
   call msRelease( options_NL )
   options_NL%tol = [ 1.0d-4, 1.0d-5, 1.0d-6 ]
   z = mfLsqNonLin( m, exp_min, p, n, options_NL, jac=exp_min_jac )
   call msDisplay( z, "parameters after minimization" )
   if( Any(mfAbs(z-mf([1.0881,3.0443])) > 1.0d-4) ) then
      print *, "   *** mfLsqNonLin failed! ***   <---------------"
   end if

   ! msLsqNonLin -------------------------------------------------------
   call print_separation("msLsqNonLin")

   print "(/,A)", "*** test number 193 ***"
   print "()"
   print *, "Minimizing a nonlinear vector-valued function"

   m = 10
   n = 2
   p = [ 2.0d0, 0.2d0 ]
   call msLsqNonLin( mfOut(z,resnorm), m, exp_min, p, n )
   call msDisplay( z, "parameters after minimization" )
   call msDisplay( resnorm, "residual norm" )
   if( Any(mfAbs(z-mf([1.0881,3.0443])) > 1.0d-4) ) then
      print *, "   *** msLsqNonLin failed! ***   <---------------"
   end if

   print "(/,A)", "*** test number 194 ***"
   print "()"
   print *, "Minimizing a nonlinear vector-valued function"

   m = 10
   n = 2
   p = [ 2.0d0, 0.2d0 ]
   call msRelease( options_NL )
   call msLsqNonLin( mfOut(z,resnorm), m, exp_min, p, n, options_NL )
   call msDisplay( z, "parameters after minimization" )
   call msDisplay( resnorm, "residual norm" )
   if( Any(mfAbs(z-mf([1.0881,3.0443])) > 1.0d-4) ) then
      print *, "   *** msLsqNonLin failed! ***   <---------------"
   end if

   print "(/,A)", "*** test number 195 ***"
   print "()"
   print *, "Minimizing a nonlinear vector-valued function"

   m = 10
   n = 2
   p = [ 2.0d0, 0.2d0 ]
   call msRelease( options_NL )
   call msLsqNonLin( mfOut(z,resnorm,status), m, exp_min, p, n,         &
                     options_NL )
   call msDisplay( z, "parameters after minimization" )
   call msDisplay( resnorm, "residual norm" )
   if( mfInt(status) < 0 ) then
      print *, "   *** msLsqNonLin failed! (status /= 0) ***   <---------------"
   end if

   print "(/,A)", "*** test number 196 ***"
   print "()"
   print *, "Minimizing a nonlinear vector-valued function"
   print *, "(jacobian provided)"

   m = 10
   n = 2
   p = [ 2.0d0, 0.2d0 ]
   call msLsqNonLin( mfOut(z,resnorm), m, exp_min, p, n,                &
                     jac=exp_min_jac )
   call msDisplay( z, "parameters after minimization" )
   if( Any(mfAbs(z-mf([1.0881,3.0443])) > 1.0d-4) ) then
      print *, "   *** mfLsqNonLin failed! ***   <---------------"
   end if

   print "(/,A)", "*** test number 197 ***"
   print "()"
   print *, "Minimizing a nonlinear vector-valued function"
   print *, "(jacobian provided)"

   m = 10
   n = 2
   p = [ 2.0d0, 0.2d0 ]
   call msRelease( options_NL )
   call msLsqNonLin( mfOut(z,resnorm), m, exp_min, p, n,                &
                     options_NL, jac=exp_min_jac )
   call msDisplay( z, "parameters after minimization" )
   if( Any(mfAbs(z-mf([1.0881,3.0443])) > 1.0d-4) ) then
      print *, "   *** mfLsqNonLin failed! ***   <---------------"
   end if

   print "(/,A)", "*** test number 198 ***"
   print "()"
   print *, "Minimizing a nonlinear vector-valued function"
   print *, "(jacobian provided)"

   m = 10
   n = 2
   p = [ 2.0d0, 0.2d0 ]
   call msRelease( options_NL )
   call msLsqNonLin( mfOut(z,resnorm,status), m, exp_min, p, n,         &
                     options_NL, jac=exp_min_jac )
   call msDisplay( z, "parameters after minimization" )
   if( mfInt(status) < 0 ) then
      print *, "   *** msLsqNonLin failed! (status /= 0) ***   <---------------"
      print "()"
   end if

   print "(/,A)", "*** test number 199 ***"
   print "()"
   print *, "Minimizing a nonlinear vector-valued function"
   print *, "(jacobian by F.D. -- parameters' sensitivity)"

   m = 3
   n = 3
   p = MF_EMPTY
   call msLsqNonLin( mfOut(z,resnorm,status,res_log,p_log,ident),       &
                     m, lin_regress, p, n )
   call msDisplay( z, "parameters after minimization" )
   if( mfInt(status) < 0 ) then
      print *, "   *** msLsqNonLin failed! (status /= 0) ***   <---------------"
      print "()"
   end if
   call msDisplay( res_log, "vector of residues" )
   call msDisplay( p_log, "vector of parameters" )
   call msFormat( "long" )
   call msDisplay( ident, "parameters' identifiability" )
   call msFormat( )

   print "(/,A)", "*** test number 200 ***"
   print "()"
   print *, "Minimizing a nonlinear vector-valued function"
   print *, "(jacobian provided -- parameters' sensitivity)"

   m = 3
   n = 3
   p = MF_EMPTY
   call msLsqNonLin( mfOut(z,resnorm,status,res_log,p_log,ident),       &
                     m, lin_regress, p, n, jac=lin_regress_jac )
   call msDisplay( z, "parameters after minimization" )
   if( mfInt(status) < 0 ) then
      print *, "   *** msLsqNonLin failed! (status /= 0) ***   <---------------"
      print "()"
   end if
   call msDisplay( res_log, "vector of residues" )
   call msDisplay( p_log, "vector of parameters" )
   call msFormat( "long" )
   call msDisplay( ident, "parameters' identifiability" )
   call msFormat( )

   ! testing MF_NO_ARG
   print "(/,A)", "*** test number 201 ***"
   print "()"
   print *, "Minimizing a nonlinear vector-valued function"
   print *, "(jacobian provided -- parameters' sensitivity)"

   m = 3
   n = 3
   p = MF_EMPTY
   call msLsqNonLin( mfOut(z,resnorm,status,MF_NO_ARG,p_log,ident),     &
                     m, lin_regress, p, n, jac=lin_regress_jac )
   call msDisplay( z, "parameters after minimization" )
   if( mfInt(status) < 0 ) then
      print *, "   *** msLsqNonLin failed! (status /= 0) ***   <---------------"
      print "()"
   end if
   call msDisplay( p_log, "vector of parameters" )
   call msFormat( "long" )
   call msDisplay( ident, "parameters' identifiability" )
   call msFormat( )

   ! End of tests ------------------------------------------------------
   print "(A)", "                         ┏━━━━━━━━━━━━━━━━━━━━━━━━┓"
   print "(A)", "                         ┃ End of test_mod_funfun ┃"
   print "(A)", "                         ┗━━━━━━━━━━━━━━━━━━━━━━━━┛"

   !--------------------------------------------------------------------
99 continue

   print "()"
   call msSetMsgLevel(2)

   ! Clean internal arrays of ODE and DAE solvers.
   call msOdeSolve( "finalize" )
   call msDaeSolve( "finalize" )

   call msRelease( x, y, abs_err, fct_eval, status, tolout )
   call msRelease( y_end, yp, new_err, t_span, solve_log, t_log, order_log )
   call msRelease( tol, yp_end, non_neg, val, fvec )
   call msRelease( y_0, yp_0, y_out, yp_out )
   call msRelease( z, p, resnorm, res_log, p_log, ident )
   call msRelease( options_DE )
   call msRelease( options_NL )

end program
