program test_mod_core_flops

   use fml

   use test_aux

   implicit none

   type(mfArray) :: x, y, data, u, v
   integer*8 :: flops

   ! Msg level = 3 : all messages are printed (verbose mode)
   !             2 : messages of kind 'ERROR' and 'Warning' are
   !                 printed [default]
   !             1 : only messages of kind 'ERROR' are printed
   !             0 : nothing is printed (quiet mode)
   !                 (pause are ignored !)

!!   call msSetMsgLevel(3)

   print "()"

   ! pour TRACE_MEM_DEBUG, il faut rediriger STDERR vers STDOUT
   call msSetStdIO( stderr=STDOUT )

!!goto 10

   ! mfIsFlopsOk --------------------------------------------------------
   call print_separation("mfIsFlopsOk")

   print "()"
   if( mfIsFlopsOk() ) then
      print *, "Flops is Ok"
   else
      print *, "Flops is not Ok"
   end if

   ! msFlops ------------------------------------------------------------
   call print_separation("msFlops")

   print "()"
   print *, "calling msFlops without initialization :"
   call msFlops( flops )
   print "(1X,A,I0)", "flops = ", flops

   print "()"
   print *, "one FP operation :"
   call msFlops(init=0) !----- begin ----
   x = 1.0d0 + 1.0d0
   call msFlops(count=flops) !--- end ---
   print "(1X,A,I0)", "flops = ", flops

   print "()"
   print *, "one FP operation, again :"
   call msFlops(init=0) !----- begin ----
   x = 1.0d0 + 1.0d0
   call msFlops(count=flops) !--- end ---
   print "(1X,A,I0)", "flops = ", flops

   print "()"
   print *, "multiplying a 10x10 matrix by a scalar :"
   x = mfOnes(10,10)
   call msFlops(init=0) !----- begin ----
   u = x * 2.0d0
   call msFlops(count=flops) !--- end ---
   print "(1X,A,I0)", "flops = ", flops

   print "()"
   print *, "multiplying a 10x10 matrix by a scalar, again :"
   x = mfOnes(10,10)
   call msFlops(init=0) !----- begin ----
   u = x * 2.0d0
   call msFlops(count=flops) !--- end ---
   print "(1X,A,I0)", "flops = ", flops

   print "()"
   print *, "vector dot-product 1x100 by 100x1 :"
   x = mfOnes(1,100)
   y = mfOnes(100,1)
   call msFlops(init=0) !----- begin ----
   u = mfMul( x, y )
   call msFlops(count=flops) !--- end ---
   print "(1X,A,I0)", "flops = ", flops

   print "()"
   print *, "vector dot-product 1x100 by 100x1, again :"
   x = mfOnes(1,100)
   y = mfOnes(100,1)
   call msFlops(init=0) !----- begin ----
   u = mfMul( x, y )
   call msFlops(count=flops) !--- end ---
   print "(1X,A,I0)", "flops = ", flops

   print "()"
   print *, "matrix product 100x100 by 100x100 :"
   x = mfOnes(100,100)
   y = mfOnes(100,100)
   call msFlops(init=0) !----- begin ----
   u = mfMul( x, y )
   call msFlops(count=flops) !--- end ---
   print "(1X,A,I0)", "flops = ", flops

   print "()"
   print *, "matrix product 100x100 by 100x100, again :"
   x = mfOnes(100,100)
   y = mfOnes(100,100)
   call msFlops(init=0) !----- begin ----
   u = mfMul( x, y )
   call msFlops(count=flops) !--- end ---
   print "(1X,A,I0)", "flops = ", flops
   print "()"

   ! End of tests ------------------------------------------------------
   print "(A)", "                         ┏━━━━━━━━━━━━━━━━━━━━━━━━━━━━┓"
   print "(A)", "                         ┃ End of test_mod_core_flops ┃"
   print "(A)", "                         ┗━━━━━━━━━━━━━━━━━━━━━━━━━━━━┛"

   !--------------------------------------------------------------------
99 continue

   print "()"
   call msSetMsgLevel(2)

   call msRelease( x, y, data, u, v )

end program
