program test_mod_core

   use fml

   use test_aux
   use lib_aux

   implicit none

   type(mfArray) :: x, y, data, u, v
   real(kind=MF_DOUBLE), pointer :: f90_ptr(:,:)
   real(kind=MF_DOUBLE), pointer :: f90_ptr_vec(:)
   real(kind=MF_DOUBLE), allocatable, target :: f90_array(:,:)
   real(kind=MF_DOUBLE), allocatable, target :: f90_vec(:)

   integer :: i, n
   integer, allocatable :: i_vec(:), i_mat(:,:)

   real :: r, r_vec(5), r_mat(5,5)

   real(kind=MF_DOUBLE) :: r1, r2
   real(kind=MF_DOUBLE), allocatable :: r2_vec(:), r2_mat(:,:)

   complex :: c, c_vec(5), c_mat(5,5)
   complex(kind=MF_DOUBLE) :: c2, c2_vec(5) ! , c2_mat(5,5)
   complex(kind=MF_DOUBLE), allocatable :: c2_mat(:,:)
   logical :: bool, bool_vec(5), bool_mat(5,5)

   type(mf_Int_List) :: int_list, int_list_2, int_list_vec(5)
   type(mf_Real_List) :: real_list, real_list_2, real_list_vec(5)

   character(len=7) :: rounding_mode

   integer :: MsgLevel_save

   ! Msg level = 3 : all messages are printed (verbose mode)
   !             2 : messages of kind 'ERROR' and 'Warning' are
   !                 printed [default]
   !             1 : only messages of kind 'ERROR' are printed
   !             0 : nothing is printed (quiet mode)
   !                 (pause are ignored !)

!!   call msSetMsgLevel(3)
!!   call msSetTrbLevel("all")

   print "()"

   ! for TRACE_MEM_DEBUG, STDERR must be redirected to STDOUT;
   ! the same thing stands for 'make check'
   call msSetStdIO( stderr=STDOUT )

!!goto 10

   ! to avoid escape sequences of color setting in the output file
   ! (default in "on")
   call msSetColoredMsg( "off" )

   ! public parameters -------------------------------------------------
   call print_separation("public parameters")

   print "(/,A)", "*** test number 1 ***"
   print "()"
   print *, "MF_MUESLI_VERSION = '", MF_MUESLI_VERSION, "'"
   print "()"
   print *, "MF_COMPILER_VERSION = '", MF_COMPILER_VERSION, "'"
   print "()"
   print *, "MF_COMPILATION_CONFIG = '", MF_COMPILATION_CONFIG(), "'"

   print "(/,A)", "*** test number 2 ***"
   call msDisplay(MF_PI, "MF_PI")

   print "(/,A)", "*** test number 3 ***"
   call msDisplay(MF_EPS, "MF_EPS")

   print "(/,A)", "*** test number 4 ***"
   call msDisplay(MF_E, "MF_E")

   print "(/,A)", "*** test number 5 ***"
   call msDisplay(MF_REALMAX, "MF_REALMAX")

   print "(/,A)", "*** test number 6 ***"
   call msDisplay(MF_REALMIN, "MF_REALMIN")

   print "(/,A)", "*** test number 7 ***"
   call msDisplay(MF_INF, "MF_INF")

   print "(/,A)", "*** test number 8 ***"
   call mf_save_and_disable_fpe( )
   call msDisplay(MF_NAN, "MF_NAN")
   call mf_restore_fpe( )

   print "(/,A)", "*** test number 9 ***"
   x = [ -1.0d0, 0.0d0, 1.0d0 ]
   call msDisplay(x, "x")
   x = x / 0.0d0
   call msDisplay(x, "x / 0.0d0")

   print "(/,A)", "*** test number 10 ***"
   x = [ -MF_INF, MF_INF ]
   call msDisplay(x, "x")
   x = 1.0d0 / x
   call msDisplay(x, "1.0d0 / x")

   print "(/,A)", "*** test number 11 ***"
   ! special IEEE values (Inf and NaN) in arrays...
   x = mf( ( [ -1.0d0, 1.0d0, -1.0d0, 1.0d0 ]*(1.0d0 + MF_I) )*MF_INF ) .vc. &
             [ -1.0d0, 1.0d0, -1.0d0, 1.0d0 ]*(1.0d0 + MF_I)            .vc. &
             [ -1.0d0, 1.0d0, -1.0d0, 1.0d0 ]*(1.0d0 + MF_I)*99.0d0
   call msDisplay(x, "x")

   print "(/,A)", "*** test number 12 ***"
   call mf_save_and_disable_fpe( )
   x = mf( ( [ -1.0d0, 1.0d0, -1.0d0, 1.0d0 ]*(1.0d0 + MF_I) )*MF_NAN ) .vc. &
             [ -1.0d0, 1.0d0, -1.0d0, 1.0d0 ]*(1.0d0 + MF_I)            .vc. &
             [ -1.0d0, 1.0d0, -1.0d0, 1.0d0 ]*(1.0d0 + MF_I)*99.0d0
   call mf_restore_fpe( )
   call msDisplay(x, "x")

   print "(/,A)", "*** test number 13 ***"
   call msFormat("long")
   x = mf( ( [ -1.0d0, 1.0d0 ]*(1.0d0 + MF_I) )*MF_INF ) .vc.           &
             [ -1.0d0, 1.0d0 ]                           .vc.           &
             [ -1.0d0,-1.0d0 ]*(1.0d0 + MF_I)*99.0d0
   call msDisplay(x, "x")

   print "(/,A)", "*** test number 14 ***"
   call mf_save_and_disable_fpe( )
   x = mf( ( [ -1.0d0, 1.0d0 ]*(1.0d0 + MF_I) )*MF_NAN ) .vc.           &
             [ -1.0d0, 1.0d0 ]                           .vc.           &
             [ -1.0d0,-1.0d0 ]*(1.0d0 + MF_I)*99.0d0
   call mf_restore_fpe( )
   call msDisplay(x, "x")
   call msFormat("short")

   ! msDisplay ---------------------------------------------------------
   call print_separation("msDisplay")

   ! format exponent="auto"

   print "(/,A)", "*** test number 15 ***"
   call msDisplay(MF_EMPTY,                                             &
                 "MF_EMPTY")

   print "(/,A)", "*** test number 16 ***"
   call msDisplay(MF_COLON,                                             &
                 "MF_COLON")

   print "(/,A)", "*** test number 17 ***"
   call msDisplay(MF_END,                                               &
                 "MF_END")

   print "(/,A)", "*** test number 18 ***"
   call msDisplay(mf([ (10*i, i = 1, 5) ]),                             &
                 "mf([ (10*i, i = 1, 5) ])") ! msDisplay_mfArray

   print "(/,A)", "*** test number 19 ***"
   call msDisplay([ (10*i, i = 1, 5) ],                                 &
                 "[ (10*i, i = 1, 5) ]") ! msDisplay_vec_int

   print "(/,A)", "*** test number 20 ***"
   call msDisplay(reshape( [ (10*i, i = 1, 10) ], [ 2, 5 ] ),           &
                 "reshape( [ (10*i, i = 1, 10) ], [ 2, 5 ] )") ! msDisplay_array_int

   print "(/,A)", "*** test number 21 ***"
   call msDisplay([ (10.*i, i = 1, 5) ],                                &
                 "[ (10.*i, i = 1, 5) ]") ! msDisplay_vec_single

   print "(/,A)", "*** test number 22 ***"
   call msDisplay(reshape( [ (10.*i, i = 1, 10) ], [ 2, 5 ] ),          &
                 "reshape( [ (10.*i, i = 1, 10) ], [ 2, 5 ] )") ! msDisplay_array_single

   print "(/,A)", "*** test number 23 ***"
   call msDisplay([ (10.0d0*i, i = 1, 5) ],                             &
                 "[ (10.0d0*i, i = 1, 5) ]") ! msDisplay_vec_double

   print "(/,A)", "*** test number 24 ***"
   call msDisplay(reshape( [ (10.0d0*i, i = 1, 10) ], [ 2, 5 ] ),       &
                 "reshape( [ (10.0d0*i, i = 1, 10) ], [ 2, 5 ] )") ! msDisplay_array_double

   print "(/,A)", "*** test number 25 ***"
   call msDisplay([ (MF_I*i, i = 1, 5) ],                               &
                 "[ (MF_I*i, i = 1, 5) ]") ! msDisplay_vec_cmplx

   print "(/,A)", "*** test number 26 ***"
   call msDisplay(reshape( [ (MF_I*i, i = 1, 10) ], [ 2, 5 ] ),         &
                 "reshape( [ (MF_I*i, i = 1, 10) ], [ 2, 5 ] )") ! msDisplay_array_cmplx

   print "(/,A)", "*** test number 27 ***"
   x = mf( [ 0.00001d0, 0.0000001d0 ] ) ! real
   call msDisplay(x, "x")

   print "(/,A)", "*** test number 28 ***"
   x = mf( [ (0.d0,0.00001d0), (0.d0,0.0000001d0) ] ) ! complex
   call msDisplay(x, "x")

   print "(/,A)", "*** test number 29 ***"
   x = mfEye(8,4)
   call msDisplay(x, "x", "c. 1", "c. 2", "c. 3", "c. 4")

   print "(/,A)", "*** test number 30 ***"
   x = mfRand(8,4)
   call msDisplay(x, "x", "col 1", "col 2", "col 3", "col 4")

   print "(/,A)", "*** test number 31 ***"
   call msFormat( "long" )
   call msDisplay(x, "x", "column 1", "column 2", "column 3", "column 4")
   call msFormat( "short" )

   ! display of booleans are delayed in the test_mod_ops program

   ! mfDisplayColumns --------------------------------------------------
   call print_separation("mfDisplayColumns")

   print "(/,A)", "*** test number 32 ***"
   x = mfOnes(1,33)
   call msDisplay(x, "x")
   print "(1X,A,I0)", "mfDisplayColumns(x) = ", mfDisplayColumns(x)

   print "(/,A)", "*** test number 33 ***"
   x = mfOnes(1,17)*1000.0d0
   call msDisplay(x, "x")
   print "(1X,A,I0)", "mfDisplayColumns(x) = ", mfDisplayColumns(x)

   print "(/,A)", "*** test number 34 ***"
   x = mfOnes(1,20)*MF_PI
   call msDisplay(x, "x")
   print "(1X,A,I0)", "mfDisplayColumns(x) = ", mfDisplayColumns(x)

   print "(/,A)", "*** test number 35 ***"
   call msFormat("long")
   x = mfOnes(1,11)*MF_PI
   call msDisplay(x, "x")
   print "(1X,A,I0)", "mfDisplayColumns(x) = ", mfDisplayColumns(x)
   call msFormat("short")

   print "(/,A)", "*** test number 36 ***"
   x = mfOnes(1,11)*MF_I*MF_PI
   call msDisplay(x, "x")
   print "(1X,A,I0)", "mfDisplayColumns(x) = ", mfDisplayColumns(x)

   print "(/,A)", "*** test number 37 ***"
   call msFormat("long")
   x = mfOnes(1,6)*MF_I*MF_PI
   call msDisplay(x, "x")
   print "(1X,A,I0)", "mfDisplayColumns(x) = ", mfDisplayColumns(x)
   call msFormat("short")

   print "()"

   ! msDisplay (screen layout) -----------------------------------------
   call print_separation("msDisplay (screen layout)")

   ! small integer fmt

   print "(/,A)", "*** test number 38 ***"
   call msDisplay(reshape( [ (10*i-50, i = 1, 9) ], [ 3, 3 ] ),         &
                 "reshape( [ (10*i-50, i = 1, 9) ], [ 3, 3 ] )")

   print "(/,A)", "*** test number 39 ***"
   call msDisplay(reshape( [ (10*i-130, i = 1, 25) ], [ 5, 5 ] ),       &
                 "reshape( [ (10*i-130, i = 1, 25) ], [ 5, 5 ] )")

   print "(/,A)", "*** test number 40 ***"
   call msDisplay(mfEye(13),"mfEye(13)")

   print "(/,A)", "*** test number 41 ***"
   call msDisplay(mfEye(14),"mfEye(14)")

   print "(/,A)", "*** test number 42 ***"
   call msDisplay(mfEye(15),"mfEye(15)")

   print "(/,A)", "*** test number 43 ***"
   print *, "writing partially the following mfArray : (small integer fmt)"
   x = .t. [ (i, i = 1, 15) ]
   call msDisplay(x,"x = .t. [ (i, i = 1, 15) ]")
   call msDisplay(x,"x (head=5)",head=5)
   print "(/,A)", "*** test number 44 ***"
   call msDisplay(x,"x (tail=5)",tail=5)
   print "(/,A)", "*** test number 45 ***"
   call msDisplay(x,"x (head=5,tail=5)",head=5,tail=5)

   print "(/,A)", "*** test number 46 ***"
   x = reshape( [(i, i = 1, 45)], [15,3] )
   call msDisplay(x,"x = reshape( [(i, i = 1, 45)], [15,3] )")
   call msDisplay(x,"x (head=5)",head=5)
   print "(/,A)", "*** test number 47 ***"
   call msDisplay(x,"x (tail=5)",tail=5)
   print "(/,A)", "*** test number 48 ***"
   call msDisplay(x,"x (head=5,tail=5)",head=5,tail=5)

   print "(/,A)", "*** test number 49 ***"
   x = [ (i, i = -12, -1) ]
   call msDisplay(x,"x = [ (i, i = -12, -1) ]")
   call msDisplay(x,"x (head=5)",head=5)
   print "(/,A)", "*** test number 50 ***"
   call msDisplay(x,"x (tail=5)",tail=5)
   print "(/,A)", "*** test number 51 ***"
   call msDisplay(x,"x (head=5,tail=5)",head=5,tail=5)

   print "(/,A)", "*** test number 52 ***"
   x = [ (i, i = 1, 25) ]
   call msDisplay(x,"x = [ (i, i = 1, 25) ]")
   call msDisplay(x,"x (head=6)",head=6)
   print "(/,A)", "*** test number 53 ***"
   call msDisplay(x,"x (tail=6)",tail=6)
   print "(/,A)", "*** test number 54 ***"
   call msDisplay(x,"x (head=6,tail=6)",head=6,tail=6)
   print "(/,A)", "*** test number 55 ***"
   call msDisplay(x,"x (head=7,tail=7)",head=7,tail=7) ! too long

   ! large integer fmt

   print "(/,A)", "*** test number 56 ***"
   call msDisplay(reshape( [ ((i-13)*1e2, i = 1, 25) ], [ 5, 5 ] ),     &
                 "reshape( [ ((i-13)*1e2, i = 1, 25) ], [ 5, 5 ] )")

   print "(/,A)", "*** test number 57 ***"
   call msDisplay(reshape( [ ((i-13)*1e5, i = 1, 25) ], [ 5, 5 ] ),     &
                 "reshape( [ ((i-13)*1e5, i = 1, 25) ], [ 5, 5 ] )")

   print "(/,A)", "*** test number 58 ***"
   call msDisplay(mfEye(6)*1000.0d0,"mfEye(6)*1000.0d0")

   print "(/,A)", "*** test number 59 ***"
   call msDisplay(mfEye(7)*1000.0d0,"mfEye(7)*1000.0d0")

   print "(/,A)", "*** test number 60 ***"
   call msDisplay(mfEye(8)*1000.0d0,"mfEye(8)*1000.0d0")

   print "(/,A)", "*** test number 61 ***"
   print *, "writing partially the following mfArray : (large integer fmt)"
   x = .t. [ (i*1000, i = 1, 15) ]
   call msDisplay(x,"x = .t. [ (i*1000, i = 1, 15) ]")
   call msDisplay(x,"x (head=5)",head=5)
   print "(/,A)", "*** test number 62 ***"
   call msDisplay(x,"x (tail=5)",tail=5)
   print "(/,A)", "*** test number 63 ***"
   call msDisplay(x,"x (head=5,tail=5)",head=5,tail=5)

   print "(/,A)", "*** test number 64 ***"
   x = [ (i*1000, i = -6, -1) ]
   call msDisplay(x,"x = [ (i*1000, i = -6, -1) ]")
   call msDisplay(x,"x (head=3)",head=3)
   print "(/,A)", "*** test number 65 ***"
   call msDisplay(x,"x (tail=2)",tail=2)
   print "(/,A)", "*** test number 66 ***"
   call msDisplay(x,"x (head=3,tail=2)",head=3,tail=2)

   print "(/,A)", "*** test number 67 ***"
   x = [ (i*1000, i = 1, 9) ]
   call msDisplay(x,"x = [ (i*1000, i = 1, 9) ]")
   call msDisplay(x,"x (head=3)",head=3)
   print "(/,A)", "*** test number 68 ***"
   call msDisplay(x,"x (tail=2)",tail=2)
   print "(/,A)", "*** test number 69 ***"
   call msDisplay(x,"x (head=3,tail=2)",head=3,tail=2)
   print "(/,A)", "*** test number 70 ***"
   call msDisplay(x,"x (head=3,tail=3)",head=3,tail=3) ! too long

   ! small float fmt (format short)
   print "(/,A)", "*** test number 71 ***"
   call msDisplay(mfHilb(1)*2.0d0-1.0d0,"mfHilb(1)*2.0d0-1.0d0")

   print "(/,A)", "*** test number 72 ***"
   call msDisplay((mfHilb(1)*2.0d0-1.0d0)*100.0d0,                      &
                 "(mfHilb(1)*2.0d0-1.0d0)*100.0d0")

   print "(/,A)", "*** test number 73 ***"
   call msDisplay((mfHilb(1)*2.0d0-1.0d0)*10000.0d0,                    &
                 "(mfHilb(1)*2.0d0-1.0d0)*10000.0d0")

   print "(/,A)", "*** test number 74 ***"
   call msDisplay(mfEye(7)*1.0d-2,"mfEye(7)*1.0d-2")

   print "(/,A)", "*** test number 75 ***"
   call msDisplay(mfEye(7)*1.0d-3,"mfEye(7)*1.0d-3")

   print "(/,A)", "*** test number 76 ***"
   call msDisplay(mfEye(7)*1.0d-111,"mfEye(7)*1.0d-111")

   print "(/,A)", "*** test number 77 ***"
   call msDisplay(mfHilb(7)*2.0d0-1.0d0,"mfHilb(7)*2.0d0-1.0d0")

   print "(/,A)", "*** test number 78 ***"
   call msDisplay(mfHilb(8)*2.0d0-1.0d0,"mfHilb(8)*2.0d0-1.0d0")

   print "(/,A)", "*** test number 79 ***"
   call msDisplay(mfHilb(9)*2.0d0-1.0d0,"mfHilb(9)*2.0d0-1.0d0")

   print "(/,A)", "*** test number 80 ***"
   call msDisplay((mfHilb(7)*2.0d0-1.0d0)*1000.0d0,                     &
                 "(mfHilb(7)*2.0d0-1.0d0)*1000.0d0")

   print "(/,A)", "*** test number 81 ***"
   call msDisplay((mfHilb(7)*2.0d0-1.0d0)*10000.0d0,                    &
                 "(mfHilb(7)*2.0d0-1.0d0)*10000.0d0")

   print "(/,A)", "*** test number 82 ***"
   call msDisplay((mfHilb(8)*2.0d0-1.0d0)*10000.0d0,                    &
                 "(mfHilb(8)*2.0d0-1.0d0)*10000.0d0")

   print "(/,A)", "*** test number 83 ***"
   call msDisplay((mfHilb(7)*2.0d0-1.0d0)*1.0d-2,                       &
                 "(mfHilb(7)*2.0d0-1.0d0)*1.0d-2")

   print "(/,A)", "*** test number 84 ***"
   call msDisplay((mfHilb(7)*2.0d0-1.0d0)*1.0d-3,                       &
                 "(mfHilb(7)*2.0d0-1.0d0)*1.0d-3")

   print "(/,A)", "*** test number 85 ***"
   call msDisplay(reshape( [ ((i-13)*1e7, i = 1, 25) ], [ 5, 5 ] ),     &
                 "reshape( [ ((i-13)*1e7, i = 1, 25) ], [ 5, 5 ] )")

   print "(/,A)", "*** test number 86 ***"
   print *, "writing partially the following mfArrays : (small float IEEE)"
   x = .t. mf( [ (i*1.001d0, i = 1, 15) ] )
   call msSet( MF_INF, x, 1 )
   call msDisplay(x,"x")
   call msDisplay(x,"x (head=5)",head=5)
   print "(/,A)", "*** test number 87 ***"
   call msDisplay(x,"x (tail=5)",tail=5)
   print "(/,A)", "*** test number 88 ***"
   call msDisplay(x,"x (head=5,tail=5)",head=5,tail=5)

   print "(/,A)", "*** test number 89 ***"
   x = .t. mf( [ (i*1.001d0, i = 1, 15) ] )
   call msDisplay(x,"x")
   call msDisplay(x,"x (head=5)",head=5)
   print "(/,A)", "*** test number 90 ***"
   call msDisplay(x,"x (tail=5)",tail=5)
   print "(/,A)", "*** test number 91 ***"
   call msDisplay(x,"x (head=5,tail=5)",head=5,tail=5)

   print "(/,A)", "*** test number 92 ***"
   x = .t. [ (i*1.01d0, i = 1, 15) ] ! column vector
   call msDisplay(x,"x")
   call msDisplay(x,"x (head=5)",head=5)
   print "(/,A)", "*** test number 93 ***"
   call msDisplay(x,"x (tail=5)",tail=5)
   print "(/,A)", "*** test number 94 ***"
   call msDisplay(x,"x (head=5,tail=5)",head=5,tail=5)

   print "(/,A)", "*** test number 95 ***"
   x = [ (i*1.01d0, i = -8, -1) ] ! row vector
   call msDisplay(x,"x")
   call msDisplay(x,"x (head=4)",head=4)
   print "(/,A)", "*** test number 96 ***"
   call msDisplay(x,"x (tail=3)",tail=3)
   print "(/,A)", "*** test number 97 ***"
   call msDisplay(x,"x (head=4,tail=3)",head=4,tail=3)

   print "(/,A)", "*** test number 98 ***"
   call msSet( MF_INF, x, 1 ) ! adding special IEEE values
   call mf_save_and_disable_fpe( )
   call msSet( MF_NAN, x, 8 )
   call mf_restore_fpe( )
   call msDisplay(x,"x")
   call msDisplay(x,"x (head=4)",head=4)
   print "(/,A)", "*** test number 99 ***"
   call msDisplay(x,"x (tail=3)",tail=3)
   print "(/,A)", "*** test number 100 ***"
   call msDisplay(x,"x (head=4,tail=3)",head=4,tail=3)

   ! small float fmt (format long)
   call msFormat("long")

   print "(/,A)", "*** test number 101 ***"
   call msDisplay(mfHilb(1)*2.0d0-1.0d0,"mfHilb(1)*2.0d0-1.0d0")

   print "(/,A)", "*** test number 102 ***"
   call msDisplay((mfHilb(1)*2.0d0-1.0d0)*1000.0d0,                     &
                 "(mfHilb(1)*2.0d0-1.0d0)*1000.0d0")

   print "(/,A)", "*** test number 103 ***"
   call msDisplay(mfHilb(4)*2.0d0-1.0d0,"mfHilb(4)*2.0d0-1.0d0")

   print "(/,A)", "*** test number 104 ***"
   call msDisplay(mfHilb(5)*2.0d0-1.0d0,"mfHilb(5)*2.0d0-1.0d0")

   print "(/,A)", "*** test number 105 ***"
   call msDisplay(mfHilb(6)*2.0d0-1.0d0,"mfHilb(6)*2.0d0-1.0d0")

   print "(/,A)", "*** test number 106 ***"
   call msDisplay((mfHilb(4)*2.0d0-1.0d0)*100.0d0,                      &
                 "(mfHilb(4)*2.0d0-1.0d0)*100.0d0")

   print "(/,A)", "*** test number 107 ***"
   call msDisplay((mfHilb(4)*2.0d0-1.0d0)*1000.0d0,                     &
                 "(mfHilb(4)*2.0d0-1.0d0)*1000.0d0")

   print "(/,A)", "*** test number 108 ***"
   call msDisplay((mfHilb(5)*2.0d0-1.0d0)*1000.0d0,                     &
                 "(mfHilb(5)*2.0d0-1.0d0)*1000.0d0")

   print "(/,A)", "*** test number 109 ***"
   call msDisplay((mfHilb(5)*2.0d0-1.0d0)*1.0d-111,                     &
                 "(mfHilb(5)*2.0d0-1.0d0)*1.0d-111")

   print "(/,A)", "*** test number 110 ***"
   print *, "writing partially the following mfArray : (small float IEEE)"
   x = [ (i*1.000001d0, i = -4, -1) ] ! row vector
   call msDisplay(x,"x")
   call msDisplay(x,"x (head=2)",head=2)
   print "(/,A)", "*** test number 111 ***"
   call msDisplay(x,"x (tail=1)",tail=1)
   print "(/,A)", "*** test number 112 ***"
   call msDisplay(x,"x (head=2,tail=1)",head=2,tail=1)

   print "(/,A)", "*** test number 113 ***"
   call msSet( MF_INF, x, 1 ) ! adding special IEEE values
   call mf_save_and_disable_fpe( )
   call msSet( MF_NAN, x, 4 )
   call mf_restore_fpe( )
   call msDisplay(x,"x")
   call msDisplay(x,"x (head=2)",head=2)
   print "(/,A)", "*** test number 114 ***"
   call msDisplay(x,"x (tail=1)",tail=1)
   print "(/,A)", "*** test number 115 ***"
   call msDisplay(x,"x (head=2,tail=1)",head=2,tail=1)

   ! hexadecimal output (only for reals)
   call msFormat( "hex" )

   print "(/,A)", "*** test number 116 ***"
   print *, "using hexadecimal output"
   call msDisplay(mfHilb(4)*2.0d0-1.0d0,"mfHilb(4)*2.0d0-1.0d0")

   print "(/,A)", "*** test number 117 ***"
   print *, "writing partially the following mfArray : (small float, in hexa)"
   x = [ (i*1.000001d0, i = -4, -1) ] ! row vector
   call msDisplay(x,"x")
   call msDisplay(x,"x (head=2)",head=2)
   print "(/,A)", "*** test number 118 ***"
   call msDisplay(x,"x (tail=1)",tail=1)
   print "(/,A)", "*** test number 119 ***"
   call msDisplay(x,"x (head=2,tail=1)",head=2,tail=1)

   print "(/,A)", "*** test number 120 ***"
   print *, "writing partially the following mfArray : (small float, in hexa)"
   x = .t. x ! col vector
   call msDisplay(x,"x")
   call msDisplay(x,"x (head=2)",head=2)
   print "(/,A)", "*** test number 121 ***"
   call msDisplay(x,"x (tail=1)",tail=1)
   print "(/,A)", "*** test number 122 ***"
   call msDisplay(x,"x (head=2,tail=1)",head=2,tail=1)

   print "(/,A)", "*** test number 123 ***"
   print *, "writing partially the following mfArray : (small float with IEEE, in hexa)"
   call msSet( MF_INF, x, 1 ) ! adding special IEEE values
   call mf_save_and_disable_fpe( )
   call msSet( MF_NAN, x, 4 )
   call mf_restore_fpe( )
   call msDisplay(x,"x")
   call msDisplay(x,"x (head=2)",head=2)
   print "(/,A)", "*** test number 124 ***"
   call msDisplay(x,"x (tail=1)",tail=1)
   print "(/,A)", "*** test number 125 ***"
   call msDisplay(x,"x (head=2,tail=1)",head=2,tail=1)

   call msFormat("short")

   ! large float fmt (format short)

   print "(/,A)", "*** test number 126 ***"
   print *, "writing partially the following mfArray : (large floats)"
   x = .t. [ (i*1.01d8, i = 1, 15) ] ! column vector
   call msDisplay(x,"x")
   call msDisplay(x,"x (head=5)",head=5)
   print "(/,A)", "*** test number 127 ***"
   call msDisplay(x,"x (tail=5)",tail=5)
   print "(/,A)", "*** test number 128 ***"
   call msDisplay(x,"x (head=5,tail=5)",head=5,tail=5)

   print "(/,A)", "*** test number 129 ***"
   x = [ (i*1.01d8, i = -8, -1) ] ! row vector
   call msDisplay(x,"x")
   call msDisplay(x,"x (head=4)",head=4)
   print "(/,A)", "*** test number 130 ***"
   call msDisplay(x,"x (tail=3)",tail=3)
   print "(/,A)", "*** test number 131 ***"
   call msDisplay(x,"x (head=4,tail=3)",head=4,tail=3)

   print "(/,A)", "*** test number 132 ***"
   call msSet( MF_INF, x, 1 ) ! adding special IEEE values
   call mf_save_and_disable_fpe( )
   call msSet( MF_NAN, x, 8 )
   call mf_restore_fpe( )
   call msDisplay(x,"x")
   call msDisplay(x,"x (head=4)",head=4)
   print "(/,A)", "*** test number 133 ***"
   call msDisplay(x,"x (tail=3)",tail=3)
   print "(/,A)", "*** test number 134 ***"
   call msDisplay(x,"x (head=4,tail=3)",head=4,tail=3)

   ! large float fmt (format long)

   call msFormat( "long" ) ! idem but using long format

   print "(/,A)", "*** test number 135 ***"
   x = [ (i*1.000001d8, i = -4, -1) ] ! row vector
   call msDisplay(x,"x")
   call msDisplay(x,"x (head=2)",head=2)
   print "(/,A)", "*** test number 136 ***"
   call msDisplay(x,"x (tail=1)",tail=1)
   print "(/,A)", "*** test number 137 ***"
   call msDisplay(x,"x (head=2,tail=1)",head=2,tail=1)

   print "(/,A)", "*** test number 138 ***"
   call msSet( MF_INF, x, 1 ) ! adding special IEEE values
   call mf_save_and_disable_fpe( )
   call msSet( MF_NAN, x, 4 )
   call mf_restore_fpe( )
   call msDisplay(x,"x")
   call msDisplay(x,"x (head=2)",head=2)
   print "(/,A)", "*** test number 139 ***"
   call msDisplay(x,"x (tail=1)",tail=1)
   print "(/,A)", "*** test number 140 ***"
   call msDisplay(x,"x (head=2,tail=1)",head=2,tail=1)

   print "(/,A)", "*** test number 141 ***"
   x = [ (i*1.000001d8, i = -5, -1) ] ! row vector
   call msDisplay(x,"x")
   call msDisplay(x,"x (head=2)",head=2)
   print "(/,A)", "*** test number 142 ***"
   call msDisplay(x,"x (tail=1)",tail=1)
   print "(/,A)", "*** test number 143 ***"
   call msDisplay(x,"x (head=2,tail=1)",head=2,tail=1)

   print "(/,A)", "*** test number 144 ***"
   call msSet( MF_INF, x, 1 ) ! adding special IEEE values
   call mf_save_and_disable_fpe( )
   call msSet( MF_NAN, x, 4 )
   call mf_restore_fpe( )
   call msDisplay(x,"x")
   call msDisplay(x,"x (head=2)",head=2)
   print "(/,A)", "*** test number 145 ***"
   call msDisplay(x,"x (tail=1)",tail=1)
   print "(/,A)", "*** test number 146 ***"
   call msDisplay(x,"x (head=2,tail=1)",head=2,tail=1)

   call msFormat( "short" )

   ! small cmplx fmt (format short)
   x = [ ((-1)**i+MF_I*(-1)**(i+1), i = 1, 4) ]
   print "(/,A)", "*** test number 147 ***"
   call msDisplay(x,"[ ((-1)**i+MF_I*(-1)**(i+1), i = 1, 4) ]")

   x = [ (((-1)**i+MF_I*(-1)**(i+1))*10, i = 1, 4) ]
   print "(/,A)", "*** test number 148 ***"
   call msDisplay(x,"[ (((-1)**i+MF_I*(-1)**(i+1))*10, i = 1, 4) ]")

   x = [ (((-1)**i+MF_I*(-1)**(i+1))*10, i = 1, 5) ]
   print "(/,A)", "*** test number 149 ***"
   call msDisplay(x,"[ (((-1)**i+MF_I*(-1)**(i+1))*10, i = 1, 5) ]")

   x = [ (((-1)**i+MF_I*(-1)**(i+1))*10, i = 1, 6) ]
   print "(/,A)", "*** test number 150 ***"
   call msDisplay(x,"[ (((-1)**i+MF_I*(-1)**(i+1))*10, i = 1, 6) ]")

   x = 100-MF_I*100
   print "(/,A)", "*** test number 151 ***"
   call msDisplay(x,"100-MF_I*100")

   x = -100+MF_I*100
   print "(/,A)", "*** test number 152 ***"
   call msDisplay(x,"-100+MF_I*100")

   x = [ (((-1)**i+MF_I*(-1)**(i+1))*100, i = 1, 4) ]
   print "(/,A)", "*** test number 153 ***"
   call msDisplay(x,"[ (((-1)**i+MF_I*(-1)**(i+1))*100, i = 1, 4) ]")

   x = [ (((-1)**i+MF_I*(-1)**(i+1))*100, i = 1, 5) ]
   print "(/,A)", "*** test number 154 ***"
   call msDisplay(x,"[ (((-1)**i+MF_I*(-1)**(i+1))*100, i = 1, 5) ]")

   x = [ (((-1)**i+MF_I*(-1)**(i+1))*100, i = 1, 6) ]
   print "(/,A)", "*** test number 155 ***"
   call msDisplay(x,"[ (((-1)**i+MF_I*(-1)**(i+1))*100, i = 1, 6) ]")

   print "(/,A)", "*** test number 156 ***"
   print *, "writing partially the following mfArray : (small cmplx IEEE)"
   x = .t. mf( [ (i*1.001d0, i = 1, 15) ] )
   call msSet( MF_INF, x, 1 )
   x = x*MF_I
   call msDisplay(x,"x")
   call msDisplay(x,"x (head=5)",head=5)
   print "(/,A)", "*** test number 157 ***"
   call msDisplay(x,"x (tail=5)",tail=5)
   print "(/,A)", "*** test number 158 ***"
   call msDisplay(x,"x (head=5,tail=5)",head=5,tail=5)

   print "(/,A)", "*** test number 159 ***"
   x = mf( [ (i*1.001d0, i = 1, 4) ] )
   x = x*MF_I
   call msDisplay(x,"x")
   call msDisplay(x,"x (head=3)",head=3)
   print "(/,A)", "*** test number 160 ***"
   call msDisplay(x,"x (tail=3)",tail=3)
   print "(/,A)", "*** test number 161 ***"
   call msDisplay(x,"x (head=2,tail=1)",head=2,tail=1)

   print "(/,A)", "*** test number 162 ***"
   x = mf( [ (i*1.001d0, i = 1, 4) ] )
   call msSet( MF_INF, x, 1 )
   x = x*MF_I
   call msDisplay(x,"x")
   call msDisplay(x,"x (head=3)",head=3)
   print "(/,A)", "*** test number 163 ***"
   call msDisplay(x,"x (tail=3)",tail=3)
   print "(/,A)", "*** test number 164 ***"
   call msDisplay(x,"x (head=2,tail=1)",head=2,tail=1)

   print "(/,A)", "*** test number 165 ***"
   x = mf( [ (i*1.001d0, i = 1, 5) ] )
   x = x*MF_I
   call msDisplay(x,"x")
   call msDisplay(x,"x (head=3)",head=3)
   print "(/,A)", "*** test number 166 ***"
   call msDisplay(x,"x (tail=3)",tail=3)
   print "(/,A)", "*** test number 167 ***"
   call msDisplay(x,"x (head=2,tail=1)",head=2,tail=1)

   print "(/,A)", "*** test number 168 ***"
   x = mf( [ (i*1.001d0, i = 1, 5) ] )
   call msSet( MF_INF, x, 1 )
   x = x*MF_I
   call msDisplay(x,"x")
   call msDisplay(x,"x (head=3)",head=3)
   print "(/,A)", "*** test number 169 ***"
   call msDisplay(x,"x (tail=3)",tail=3)
   print "(/,A)", "*** test number 170 ***"
   call msDisplay(x,"x (head=2,tail=1)",head=2,tail=1)

   ! small cmplx fmt (format long)
   call msFormat("long")

   x = 1-MF_I
   print "(/,A)", "*** test number 171 ***"
   call msDisplay(x,"1-MF_I")

   x = [ ((-1)**i+MF_I*(-1)**(i+1), i = 1, 2) ]
   print "(/,A)", "*** test number 172 ***"
   call msDisplay(x,"[ ((-1)**i+MF_I*(-1)**(i+1), i = 1, 2) ]")

   x = [ (((-1)**i+MF_I*(-1)**(i+1))*10, i = 1, 2) ]
   print "(/,A)", "*** test number 173 ***"
   call msDisplay(x,"[ (((-1)**i+MF_I*(-1)**(i+1))*10, i = 1, 2) ]")

   x = [ (((-1)**i+MF_I*(-1)**(i+1))*10, i = 1, 3) ]
   print "(/,A)", "*** test number 174 ***"
   call msDisplay(x,"[ (((-1)**i+MF_I*(-1)**(i+1))*10, i = 1, 3) ]")

   x = [ (((-1)**i+MF_I*(-1)**(i+1))*10, i = 1, 4) ]
   print "(/,A)", "*** test number 175 ***"
   call msDisplay(x,"[ (((-1)**i+MF_I*(-1)**(i+1))*10, i = 1, 4) ]")

   x = 100-MF_I*100
   print "(/,A)", "*** test number 176 ***"
   call msDisplay(x,"100-MF_I*100")

   x = -100+MF_I*100
   print "(/,A)", "*** test number 177 ***"
   call msDisplay(x,"-100+MF_I*100")

   x = [ (((-1)**i+MF_I*(-1)**(i+1))*100, i = 1, 2) ]
   print "(/,A)", "*** test number 178 ***"
   call msDisplay(x,"[ (((-1)**i+MF_I*(-1)**(i+1))*100, i = 1, 2) ]")

   x = [ (((-1)**i+MF_I*(-1)**(i+1))*100, i = 1, 3) ]
   print "(/,A)", "*** test number 179 ***"
   call msDisplay(x,"[ (((-1)**i+MF_I*(-1)**(i+1))*100, i = 1, 3) ]")

   x = [ (((-1)**i+MF_I*(-1)**(i+1))*100, i = 1, 4) ]
   print "(/,A)", "*** test number 180 ***"
   call msDisplay(x,"[ (((-1)**i+MF_I*(-1)**(i+1))*100, i = 1, 4) ]")

   print "(/,A)", "*** test number 181 ***"
   print *, "writing partially the following mfArray : (small cmplx IEEE)"
   x = .t. mf( [ (i*1.001d0, i = 1, 15) ] )
   call msSet( MF_INF, x, 1 )
   x = x*MF_I
   call msDisplay(x,"x")
   call msDisplay(x,"x (head=5)",head=5)
   print "(/,A)", "*** test number 182 ***"
   call msDisplay(x,"x (tail=5)",tail=5)
   print "(/,A)", "*** test number 183 ***"
   call msDisplay(x,"x (head=5,tail=5)",head=5,tail=5)

   print "(/,A)", "*** test number 184 ***"
   x = mf( [ (i*1.001d0, i = 1, 2) ] )
   x = x*MF_I
   call msDisplay(x,"x")
   call msDisplay(x,"x (head=1)",head=1)
   print "(/,A)", "*** test number 185 ***"
   call msDisplay(x,"x (tail=1)",tail=1)

   print "(/,A)", "*** test number 186 ***"
   x = mf( [ (i*1.001d0, i = 1, 2) ] )
   call msSet( MF_INF, x, 1 )
   x = x*MF_I
   call msDisplay(x,"x")
   call msDisplay(x,"x (head=1)",head=1)
   print "(/,A)", "*** test number 187 ***"
   call msDisplay(x,"x (tail=1)",tail=1)

   print "(/,A)", "*** test number 188 ***"
   x = mf( [ (i*1.001d0, i = 1, 3) ] )
   x = x*MF_I
   call msDisplay(x,"x")
   call msDisplay(x,"x (head=1)",head=1)
   print "(/,A)", "*** test number 189 ***"
   call msDisplay(x,"x (tail=1)",tail=1)

   print "(/,A)", "*** test number 190 ***"
   x = mf( [ (i*1.001d0, i = 1, 3) ] )
   call msSet( MF_INF, x, 1 )
   x = x*MF_I
   call msDisplay(x,"x")
   call msDisplay(x,"x (head=1)",head=1)
   print "(/,A)", "*** test number 191 ***"
   call msDisplay(x,"x (tail=1)",tail=1)

   call msFormat("short")

   ! large cmplx fmt (format short)

   print "(/,A)", "*** test number 192 ***"
   print *, "writing partially the following mfArray : (large cmplx IEEE)"
   x = mf( [ (i*1.001d8, i = 1, 4) ] )
   x = x*MF_I
   call msDisplay(x,"x")
   call msDisplay(x,"x (head=3)",head=3)
   print "(/,A)", "*** test number 193 ***"
   call msDisplay(x,"x (tail=3)",tail=3)
   print "(/,A)", "*** test number 194 ***"
   call msDisplay(x,"x (head=2,tail=1)",head=2,tail=1)

   print "(/,A)", "*** test number 195 ***"
   x = mf( [ (i*1.001d8, i = 1, 4) ] )
   call msSet( MF_INF, x, 1 )
   x = x*MF_I
   call msDisplay(x,"x")
   call msDisplay(x,"x (head=3)",head=3)
   print "(/,A)", "*** test number 196 ***"
   call msDisplay(x,"x (tail=3)",tail=3)
   print "(/,A)", "*** test number 197 ***"
   call msDisplay(x,"x (head=2,tail=1)",head=2,tail=1)

   print "(/,A)", "*** test number 198 ***"
   x = mf( [ (i*1.001d8, i = 1, 5) ] )
   x = x*MF_I
   call msDisplay(x,"x")
   call msDisplay(x,"x (head=3)",head=3)
   print "(/,A)", "*** test number 199 ***"
   call msDisplay(x,"x (tail=3)",tail=3)
   print "(/,A)", "*** test number 200 ***"
   call msDisplay(x,"x (head=2,tail=1)",head=2,tail=1)

   print "(/,A)", "*** test number 201 ***"
   x = mf( [ (i*1.001d8, i = 1, 5) ] )
   call msSet( MF_INF, x, 1 )
   x = x*MF_I
   call msDisplay(x,"x")
   call msDisplay(x,"x (head=3)",head=3)
   print "(/,A)", "*** test number 202 ***"
   call msDisplay(x,"x (tail=3)",tail=3)
   print "(/,A)", "*** test number 203 ***"
   call msDisplay(x,"x (head=2,tail=1)",head=2,tail=1)

   ! large cmplx fmt (format long)

   call msFormat("long")
   print *, "writing partially the following mfArray : (large cmplx IEEE)"

   print "(/,A)", "*** test number 204 ***"
   x = [ (i*1.001d8, i = 1, 2) ]
   x = x*MF_I
   call msDisplay(x,"x")
   call msDisplay(x,"x (head=1)",head=1)
   print "(/,A)", "*** test number 205 ***"
   call msDisplay(x,"x (tail=1)",tail=1)

   print "(/,A)", "*** test number 206 ***"
   x = [ (i*1.001d8, i = 1, 2) ]
   call msSet( MF_INF, x, 1 )
   x = x*MF_I
   call msDisplay(x,"x")
   call msDisplay(x,"x (head=1)",head=1)
   print "(/,A)", "*** test number 207 ***"
   call msDisplay(x,"x (tail=1)",tail=1)

   print "(/,A)", "*** test number 208 ***"
   x = [ (i*1.001d8, i = 1, 3) ]
   x = x*MF_I
   call msDisplay(x,"x")
   call msDisplay(x,"x (head=1)",head=1)
   print "(/,A)", "*** test number 209 ***"
   call msDisplay(x,"x (tail=1)",tail=1)

   print "(/,A)", "*** test number 210 ***"
   x = [ (i*1.001d8, i = 1, 3) ]
   call msSet( MF_INF, x, 1 )
   x = x*MF_I
   call msDisplay(x,"x")
   call msDisplay(x,"x (head=1)",head=1)
   print "(/,A)", "*** test number 211 ***"
   call msDisplay(x,"x (tail=1)",tail=1)

   call msFormat("short")

   ! format exponent="sci"
   call msFormat( exponent="sci" )

   x = mfEye(6)
   call msSet(-1.2345678d0,x,1,2)
   print "(/,A)", "*** test number 212 ***"
   call msDisplay(x,"x")

   x = -mfEye(7)
   print "(/,A)", "*** test number 213 ***"
   call msDisplay(x,"-mfEye(7)")

   x = mfEye(4)
   call mf_save_and_disable_fpe( )
   call msSet(MF_NAN,x,2,2)
   call mf_restore_fpe( )
   call msSet(MF_INF,x,3,3)
   call msSet(-MF_INF,x,4,4)
   print "(/,A)", "*** test number 214 ***"
   call msDisplay(x,"x")

   print "(A,/)", "*** test number 199 ***"
   print *, "writing partially the following mfArray : (format exponent='sci')"
   x = .t. mf( [ (i*1.001d0, i = 1, 15) ] )
   call msSet( MF_INF, x, 1 )
   call msDisplay(x,"x")
   call msDisplay(x,"x (head=5)",head=5)
   print "(/,A)", "*** test number 215 ***"
   call msDisplay(x,"x (tail=5)",tail=5)
   print "(/,A)", "*** test number 216 ***"
   call msDisplay(x,"x (head=5,tail=5)",head=5,tail=5)

   x = mf( [ 0.00001d0, 0.0000001d0 ] )
   print "(/,A)", "*** test number 217 ***"
   call msDisplay(x, "x")

   x = [ ((-1)**i+MF_I*(-1)**(i+1), i = 1, 4) ]
   print "(/,A)", "*** test number 218 ***"
   call msDisplay(x,"[ ((-1)**i+MF_I*(-1)**(i+1), i = 1, 4) ]")

   x = mf( [ (0.d0,0.00001d0), (0.d0,0.0000001d0) ] )
   print "(/,A)", "*** test number 219 ***"
   call msDisplay(x, "x")

   call msFormat( mantissa="long", exponent="sci" )

   print "(/,A)", "*** test number 220 ***"
   x = mfEye(6)
   call msSet(-1.2345678d0,x,1,2)
   call msDisplay(x,"x")

   print "(/,A)", "*** test number 221 ***"
   x = -mfEye(7)
   call msDisplay(x,"-mfEye(7)")

   print "(/,A)", "*** test number 222 ***"
   x = mfEye(4)
   call mf_save_and_disable_fpe( )
   call msSet(MF_NAN,x,2,2)
   call mf_restore_fpe( )
   call msSet(MF_INF,x,3,3)
   call msSet(-MF_INF,x,4,4)
   call msDisplay(x,"x")

   print "(/,A)", "*** test number 223 ***"
   x = .t. mf( [ (i*1.001d0, i = 1, 15) ] )
   call msSet( MF_INF, x, 1 )
   call msDisplay(x,"x")
   call msDisplay(x,"x (head=5)",head=5)
   print "(/,A)", "*** test number 224 ***"
   call msDisplay(x,"x (tail=5)",tail=5)
   print "(/,A)", "*** test number 225 ***"
   call msDisplay(x,"x (head=5,tail=5)",head=5,tail=5)

   x = mf( [ 0.00001d0, 0.0000001d0 ] )
   print "(/,A)", "*** test number 226 ***"
   call msDisplay(x, "x")

   x = [ ((-1)**i+MF_I*(-1)**(i+1), i = 1, 4) ]
   print "(/,A)", "*** test number 227 ***"
   call msDisplay(x,"[ ((-1)**i+MF_I*(-1)**(i+1), i = 1, 4) ]")

   x = mf( [ (0.d0,0.00001d0), (0.d0,0.0000001d0) ] )
   print "(/,A)", "*** test number 228 ***"
   call msDisplay(x, "x")

   ! format exponent="eng"
   call msFormat( exponent="eng" )

   x = [ 0.01d0, 0.1d0, 1.0d0, 10.0d0, 100.0d0 ]
   print "(/,A)", "*** test number 229 ***"
   call msDisplay(x,"x")

   x = x*1.0d4
   print "(/,A)", "*** test number 230 ***"
   call msDisplay(x,"x")

   x = x*1.0d4
   print "(/,A)", "*** test number 231 ***"
   call msDisplay(x,"x")

   x = x/1.0d10
   print "(/,A)", "*** test number 232 ***"
   call msDisplay(x,"x")

   x = x/1.0d4
   print "(/,A)", "*** test number 233 ***"
   call msDisplay(x,"x")

   x = x/1.0d4
   print "(/,A)", "*** test number 234 ***"
   call msDisplay(x,"x")

   x = mf( [ 0.00001d0, 0.0000001d0 ] )
   print "(/,A)", "*** test number 235 ***"
   call msDisplay(x, "x")

   x = mf( [ 0.00001d0, 0.0000001d0 ] )*MF_I
   print "(/,A)", "*** test number 236 ***"
   call msDisplay(x, "x")

   x = mf( [ 0.0001d0, 0.0000001d0 ] )*MF_I
   print "(/,A)", "*** test number 237 ***"
   call msDisplay(x, "x")

   print "(/,A)", "*** test number 238 ***"
   call msDisplay(1.234567D+95, "1.234567D+95")
   print "(/,A)", "*** test number 239 ***"
   call msDisplay(1.234567D-95, "1.234567D-95")

!!   call msDisplay(1.234567D+105, "1.234567D+105")
!!   call msDisplay(1.234567D-105, "1.234567D-105")

   print "(/,A)", "*** test number 240 ***"
   call msDisplay(1.234567D+95*(1.0d0+MF_I), "1.234567D+95*(1.0d0+MF_I)")
   print "(/,A)", "*** test number 241 ***"
   call msDisplay(1.234567D-95*(1.0d0+MF_I), "1.234567D-95*(1.0d0+MF_I)")

   call msFormat( mantissa="long", exponent="eng" )

   print "(/,A)", "*** test number 242 ***"
   x = mfEye(6)
   x = x*1.0d4
   call msSet(-1.2345678d0,x,1,2)
   call msDisplay(x,"x")

   print "(/,A)", "*** test number 243 ***"
   call msDisplay(1.234567D+95, "1.234567D+95")
   print "(/,A)", "*** test number 244 ***"
   call msDisplay(1.234567D-95, "1.234567D-95")

   print "(/,A)", "*** test number 245 ***"
   call msDisplay(1.234567D+95*(1.0d0+MF_I), "1.234567D+95*(1.0d0+MF_I)")
   print "(/,A)", "*** test number 246 ***"
   call msDisplay(1.234567D-95*(1.0d0+MF_I), "1.234567D-95*(1.0d0+MF_I)")

   print "(/,A)", "*** test number 247 ***"
   x = mf( [ 0.00001d0, 0.0000001d0 ] )
   call msDisplay(x, "x")

   print "(/,A)", "*** test number 248 ***"
   x = mf( [ 0.00001d0, 0.0000001d0 ] )*MF_I
   call msDisplay(x, "x")

   print "(/,A)", "*** test number 249 ***"
   x = mf( [ 0.0001d0, 0.0000001d0 ] )*MF_I
   call msDisplay(x, "x")

   call msFormat() ! back to default values

   ! mf ----------------------------------------------------------------
   call print_separation("mf")

   print "(/,A)", "*** test number 250 ***"
   call msDisplay(mf(1),                                                &
                 "mf(1)")

   print "(/,A)", "*** test number 251 ***"
   call msDisplay(mf([ (10*i, i = 1, 5) ]),                             &
                 "mf([ (10*i, i = 1, 5) ])")

   print "(/,A)", "*** test number 252 ***"
   call msDisplay(mf(reshape( [ (100*i, i = 1, 10) ], [ 2, 5 ] )),      &
                 "mf(reshape( [ (100*i, i = 1, 10) ], [ 2, 5 ] ))")

   print "(/,A)", "*** test number 253 ***"
   call msDisplay(mf(1.),                                               &
                 "mf(1.)")

   print "(/,A)", "*** test number 254 ***"
   call msDisplay(mf([ (10.*i, i = 1, 5) ]),                            &
                 "mf([ (10.*i, i = 1, 5) ])")

   print "(/,A)", "*** test number 255 ***"
   call msDisplay(mf(reshape( [ (100.*i, i = 1, 10) ], [ 2, 5 ] )),     &
                 "mf(reshape( [ (100.*i, i = 1, 10) ], [ 2, 5 ] ))")

   print "(/,A)", "*** test number 256 ***"
   call msDisplay(mf(1.0d0),                                            &
                 "mf(1.0d0)")

   print "(/,A)", "*** test number 257 ***"
   call msDisplay(mf([ (10.0d0*i, i = 1, 5) ]),                         &
                 "mf([ (10.0d0*i, i = 1, 5) ])")

   print "(/,A)", "*** test number 258 ***"
   call msDisplay(mf(reshape( [ (100.0d0*i, i = 1, 10) ], [ 2, 5 ] )),  &
                 "mf(reshape( [ (100.0d0*i, i = 1, 10) ], [ 2, 5 ] ))")

   print "(/,A)", "*** test number 259 ***"
   call msDisplay(mf(MF_I),                                             &
                 "mf(MF_I)")

   print "(/,A)", "*** test number 260 ***"
   call msDisplay(mf([ (MF_I*i, i = 1, 4) ]),                           &
                 "mf([ (MF_I*i, i = 1, 4) ])")

   print "(/,A)", "*** test number 261 ***"
   call msDisplay(mf(reshape( [ (MF_I*i, i = 1, 12) ], [ 3, 4 ] )),     &
                 "mf(reshape( [ (MF_I*i, i = 1, 12) ], [ 3, 4 ] ))")

   print "(/,A)", "*** test number 262 ***"
   call msDisplay(mf([ (10*i, i = 1, 5) ],transpose=.true.),                       &
                 "mf([ (10*i, i = 1, 5) ],transpose=.true.)")

   print "(/,A)", "*** test number 263 ***"
   call msDisplay(mf([ (1.5*i, i = 1, 5) ],transpose=.true.),                      &
                 "mf([ (1.5*i, i = 1, 5) ],transpose=.true.)")

   print "(/,A)", "*** test number 264 ***"
   call msDisplay(mf([ (MF_PI*i, i = 1, 5) ],transpose=.true.),                    &
                 "mf([ (MF_PI*i, i = 1, 5) ],transpose=.true.)")

   print "(/,A)", "*** test number 265 ***"
   call msDisplay(mf([ (MF_I*i, i = 1, 5) ],transpose=.true.),                     &
                 "mf([ (MF_I*i, i = 1, 5) ],transpose=.true.)")

   print "(/,A)", "*** test number 266 ***"
   call msDisplay(mf([ .true., .false., .true. ],transpose=.true.),                &
                 "mf([ .true., .false., .true. ],transpose=.true.)")

   print "(/,A)", "*** test number 267 ***"
   allocate( i_mat(4,3) )
   i_mat(:,:) = 1
   x = mf(i_mat,transpose=.true.)
   call msDisplay( x, "mf(i_mat,transpose=.true.)")
   if( all(shape(x) == [3,4]) ) then
      print *, "mf( integer_matrix, transpose=.true. ) ----------------> ok"
   else
      print *, "mf( integer_matrix, transpose=.true. ) ----------------> FAILED"
   end if
   deallocate( i_mat )

   print "(/,A)", "*** test number 268 ***"
   allocate( r2_mat(4,3) )
   r2_mat(:,:) = 1.5d0
   x = mf(r2_mat,transpose=.true.)
   call msDisplay( x, "mf(r2_mat,transpose=.true.)")
   if( all(shape(x) == [3,4]) ) then
      print *, "mf( double_real_matrix, transpose=.true. ) ------------> ok"
   else
      print *, "mf( double_real_matrix, transpose=.true. ) ------------> FAILED"
   end if
   deallocate( r2_mat )

   print "(/,A)", "*** test number 269 ***"
   allocate( c2_mat(4,3) )
   c2_mat(:,:) = 1.5d0
   x = mf(c2_mat,transpose=.true.)
   call msDisplay( x, "mf(c2_mat,transpose=.true.)")
   if( all(shape(x) == [3,4]) ) then
      print *, "mf( double_complex_matrix, transpose=.true. ) ---------> ok"
   else
      print *, "mf( double_complex_matrix, transpose=.true. ) ---------> FAILED"
   end if
   deallocate( c2_mat )

   ! mf_Int_List (list of integers) ------------------------------------

   print "(/,A)", "*** test number 270 ***"
   call msDisplay( int_list, "int_list" )

   print "(/,A)", "*** test number 271 ***"
   n = 7                                    ! short integers
   allocate( int_list%list(n) )
   int_list%list(:) = [ (i, i = 1, n) ]
   call msDisplay( int_list, "int_list")
   deallocate( int_list%list )

   print "(/,A)", "*** test number 272 ***"
   n = 15                                    ! medium integers (col < 80)
   allocate( int_list%list(n) )
   int_list%list(:) = [ (i, i = 101, 115) ]
   call msDisplay( int_list, "int_list" )

   print "(/,A)", "*** test number 273 ***"
   !                                         ! long integers (col > 80)
   int_list%list(:) = [ 0, 0, 0, 0, 0,                                  &
                        (i, i = 100001, 100005),                        &
                        0, 0, 0, 0, 0 ]
   call msDisplay( int_list, "int_list" )

   print "(/,A)", "*** test number 274 ***"
   !                                         ! compact display
   call msDisplay( int_list, "int_list", compact=.true. )

   print "(/,A)", "*** test number 275 ***"
   !                                         ! copy between 2 int. lists
   int_list_2 = int_list
   call msDisplay( int_list_2, "int_list_2", compact=.true. )

   call msRelease( int_list )
   call msRelease( int_list_2 )

   ! (vector of list of integers)

   print "(/,A)", "*** test number 276 ***"
   n = 7
   allocate( int_list_vec(1)%list(n) )
   int_list_vec(1)%list(:) = [ (i, i = 1, n) ]
   n = 15
   allocate( int_list_vec(3)%list(n) )
   int_list_vec(3)%list(:) = [ (i, i = 101, 115) ]
   allocate( int_list_vec(5)%list(n) )
   int_list_vec(5)%list(:) = [ 0, 0, 0, 0, 0,                           &
                              (i, i = 100001, 100005),                  &
                               0, 0, 0, 0, 0 ]
   call msDisplay( int_list_vec, "int_list_vec" )

   print "(/,A)", "*** test number 277 ***"
   !                                         ! compact display
   call msDisplay( int_list_vec, "int_list_vec", compact=.true. )

   call msRelease( int_list_vec )

   ! mf_Real_List (list of reals) --------------------------------------

   print "(/,A)", "*** test number 278 ***"
   call msDisplay( real_list, "real_list" )

   print "(/,A)", "*** test number 279 ***"
   n = 7                                    ! short integers
   allocate( real_list%list(n) )
   real_list%list(:) = [ (i, i = 1, n) ]
   call msDisplay( real_list, "real_list")
   deallocate( real_list%list )

   print "(/,A)", "*** test number 280 ***"
   n = 15                                    ! medium integers (col < 80)
   allocate( real_list%list(n) )
   real_list%list(:) = [ (i, i = 101, 115) ]
   call msDisplay( real_list, "real_list" )

   print "(/,A)", "*** test number 281 ***"
   !                                         ! long integers (col > 80)
   real_list%list(:) = [ 0, 0, 0, 0, 0,                                 &
                        (i, i = 100001, 100005),                        &
                        0, 0, 0, 0, 0 ]
   call msDisplay( real_list, "real_list" )

   call msRelease( real_list )

   ! (vector of list of reals)

   print "(/,A)", "*** test number 282 ***"
   n = 7
   allocate( real_list_vec(1)%list(n) )
   real_list_vec(1)%list(:) = [ (i, i = 1, n) ]
   n = 15
   allocate( real_list_vec(3)%list(n) )
   real_list_vec(3)%list(:) = [ (i, i = 101, 115) ]
   allocate( real_list_vec(5)%list(n) )
   real_list_vec(5)%list(:) = [ 0, 0, 0, 0, 0,                          &
                              (i, i = 100001, 100005),                  &
                               0, 0, 0, 0, 0 ]
   call msDisplay( real_list_vec, "real_list_vec" )

   call msRelease( real_list_vec )

   ! Assignment (msAssign) ---------------------------------------------
   call print_separation("Assignment (msAssign)")

   print "(/,A)", "*** test number 283 ***"
   x = MF_EMPTY ! light warning
   call msDisplay(x,"MF_EMPTY")

   ! real
   print "(/,A)", "*** test number 284 ***"
   x = 1
   call msDisplay(x,"1")

   print "(/,A)", "*** test number 285 ***"
   x = [ (10*i, i = 1, 5) ]
   call msDisplay(x,"[ (10*i, i = 1, 5) ]")

   print "(/,A)", "*** test number 286 ***"
   x = reshape( [ (100*i, i = 1, 10) ], [ 2, 5 ] )
   call msDisplay(x,"reshape( [ (100*i, i = 1, 10) ], [ 2, 5 ] )")

   print "(/,A)", "*** test number 287 ***"
   x = 1.
   call msDisplay(x,"1.")

   print "(/,A)", "*** test number 288 ***"
   x = [ (10.*i, i = 1, 5) ]
   call msDisplay(x,"[ (10.*i, i = 1, 5) ]")

   print "(/,A)", "*** test number 289 ***"
   x = reshape( [ (100.*i, i = 1, 10) ], [ 2, 5 ] )
   call msDisplay(x,"reshape( [ (100.*i, i = 1, 10) ], [ 2, 5 ] )")

   print "(/,A)", "*** test number 290 ***"
   x = 1.0d0
   call msDisplay(x,"1.0d0")

   print "(/,A)", "*** test number 291 ***"
   x = [ (10.0d0*i, i = 1, 5) ]
   call msDisplay(x,"[ (10.0d0*i, i = 1, 5) ]")

   print "(/,A)", "*** test number 292 ***"
   x = reshape( [ (100.0d0*i, i = 1, 10) ], [ 2, 5 ] )
   call msDisplay(x,"reshape( [ (100.0d0*i, i = 1, 10) ], [ 2, 5 ] )")

   print "(/,A)", "*** test number 293 ***"
   y = x
   call msDisplay(y,"y = %, y")

   ! cmplx
   print "(/,A)", "*** test number 294 ***"
   x = MF_I
   call msDisplay(x,"MF_I")

   print "(/,A)", "*** test number 295 ***"
   x = [ ((-1)**i+MF_I*(-1)**(i+1), i = 1, 4) ]
   call msDisplay(x,"[ ((-1)**i+MF_I*(-1)**(i+1), i = 1, 4) ]")

   print "(/,A)", "*** test number 296 ***"
   x = [ (((-1)**i+MF_I*(-1)**(i+1))*10, i = 1, 4) ]
   call msDisplay(x,"[ (((-1)**i+MF_I*(-1)**(i+1))*10, i = 1, 4) ]")

   print "(/,A)", "*** test number 297 ***"
   x = [ (((-1)**i+MF_I*(-1)**(i+1))*10, i = 1, 5) ]
   call msDisplay(x,"[ (((-1)**i+MF_I*(-1)**(i+1))*10, i = 1, 5) ]")

   print "(/,A)", "*** test number 298 ***"
   x = [ (((-1)**i+MF_I*(-1)**(i+1))*10, i = 1, 6) ]
   call msDisplay(x,"[ (((-1)**i+MF_I*(-1)**(i+1))*10, i = 1, 6) ]")

   print "(/,A)", "*** test number 299 ***"
   x = 100-MF_I*100
   call msDisplay(x,"100-MF_I*100")

   print "(/,A)", "*** test number 300 ***"
   x = -100+MF_I*100
   call msDisplay(x,"-100+MF_I*100")

   print "(/,A)", "*** test number 301 ***"
   x = [ (((-1)**i+MF_I*(-1)**(i+1))*100, i = 1, 4) ]
   call msDisplay(x,"[ (((-1)**i+MF_I*(-1)**(i+1))*100, i = 1, 4) ]")

   ! Assignment (special) ----------------------------------------------
   call print_separation("Assignment (special)")

   i = 0
   MsgLevel_save = mfGetMsgLevel()
   call msSetMsgLevel(1)

   !-----------------

   print "(/,A)", "*** test number 302 ***"
   print "()"
   i = mfOnes(1)                    ! mfArray_to_scalar_int
   print "(1X,A,I0)", "i = ", i

   print "(/,A)", "*** test number 303 ***"
   print "()"
   i = mfOnes(1)*MF_PI              ! mfArray_to_scalar_int
   print "(1X,A,I0)", "i = ", i

   allocate( i_vec(5) )

   print "(/,A)", "*** test number 304 ***"
   print "()"
   i_vec(:) = 0
   i_vec(3) = mfOnes(1)             ! mfArray_to_scalar_int
   print "(1X,A,5(1X,I0))", "i_vec = ", i_vec

   print "(/,A)", "*** test number 305 ***"
   print "()"
   i_vec = mfOnes(1,5)              ! mfArray_to_vector_int
   print "(1X,A,5(1X,I0))", "i_vec = ", i_vec

   print "(/,A)", "*** test number 306 ***"
   print "()"
   i_vec = mfOnes(5,1)*MF_PI        ! mfArray_to_vector_int
   print "(1X,A,5(1X,I0))", "i_vec = ", i_vec

   print "(/,A)", "*** test number 307 ***"
   print "()"
   i_vec(2:4) = 2.0d0*mfOnes(1,3)   ! mfArray_to_vector_int
   print "(1X,A,5(1X,I0))", "i_vec = ", i_vec

   deallocate( i_vec )
   allocate( i_vec(1) )

   print "(/,A)", "*** test number 308 ***"
   print "()"
   x = 1
   i_vec = x                        ! mfArray_to_vector_int (size 1)
   print "(1X,A,5(1X,I0))", "i_vec = ", i_vec

   deallocate( i_vec )
   allocate( i_mat(5,5) )

   print "(/,A)", "*** test number 309 ***"
   print "()"
   i_mat = mfOnes(5,5)              ! mfArray_to_matrix_int
   print "(1X,A,/,5(1X,I0))", "i_mat = ", i_mat

   deallocate( i_mat )

   !-----------------

   print "(/,A)", "*** test number 310 ***"
   print "()"
   r = mfOnes(1)                    ! mfArray_to_scalar_real
   print "(1X,A,F7.4)", "r = ", r

   print "(/,A)", "*** test number 311 ***"
   print "()"
   r = mfOnes(1)*MF_PI              ! mfArray_to_scalar_real
   print "(1X,A,F7.4)", "r = ", r

   print "(/,A)", "*** test number 312 ***"
   print "()"
   r_vec(:) = 0.
   r_vec(3) = mfOnes(1)             ! mfArray_to_scalar_real
   print "(1X,A,5(1X,F7.4))", "r_vec = ", r_vec

   print "(/,A)", "*** test number 313 ***"
   print "()"
   r_vec = mfOnes(1,5)              ! mfArray_to_vector_real
   print "(1X,A,5(1X,F7.4))", "r_vec = ", r_vec

   print "(/,A)", "*** test number 314 ***"
   print "()"
   r_vec = mfOnes(5,1)*MF_PI        ! mfArray_to_vector_real
   print "(1X,A,5(1X,F7.4))", "r_vec = ", r_vec

   print "(/,A)", "*** test number 315 ***"
   print "()"
   r_vec(2:4) = 2.0d0*mfOnes(1,3)   ! mfArray_to_vector_real
   print "(1X,A,5(1X,F7.4))", "r_vec = ", r_vec

   print "(/,A)", "*** test number 316 ***"
   print "()"
   r_mat = mfOnes(5,5)              ! mfArray_to_matrix_real
   print "(1X,A,/,5(1X,F7.4))", "r_mat = ", r_mat

   !-----------------

   print "(/,A)", "*** test number 317 ***"
   print "()"
   r2 = mfOnes(1)*MF_PI             ! mfArray_to_scalar_dble
   print "(1X,A,F11.8)", "r2 = ", r2

   print "(/,A)", "*** test number 318 ***"
   print "()"
   r2 = mfOnes(1) + MF_I*mfZeros(1) ! mfArray_to_scalar_dble
   print "(1X,A,F11.8)", "r2 = ", r2

   allocate( r2_vec(5) )

   print "(/,A)", "*** test number 319 ***"
   print "()"
   r2_vec(:) = 0.
   r2_vec(3) = mfOnes(1)            ! mfArray_to_scalar_dble
   print "(1X,A,5(1X,F11.8))", "r2_vec = ", r2_vec

   print "(/,A)", "*** test number 320 ***"
   print "()"
   r2_vec = mfOnes(1,5)             ! mfArray_to_vector_dble
   print "(1X,A,5(1X,F11.8))", "r2_vec = ", r2_vec

   print "(/,A)", "*** test number 321 ***"
   print "()"
   r2_vec = mfOnes(5,1)*MF_PI       ! mfArray_to_vector_dble
   print "(1X,A,5(1X,F11.8))", "r2_vec = ", r2_vec

   print "(/,A)", "*** test number 322 ***"
   print "()"
   r2_vec(2:4) = 2.0d0*mfOnes(1,3)  ! mfArray_to_vector_dble
   print "(1X,A,5(1X,F11.8))", "r2_vec = ", r2_vec

   deallocate( r2_vec )
   allocate( r2_vec(1) )

   print "(/,A)", "*** test number 323 ***"
   print "()"
   r2_vec = mfOnes(1)                ! mfArray_to_vector_dble (size=1)
   print "(1X,A,5(1X,F11.8))", "r2_vec = ", r2_vec

   deallocate( r2_vec )
   allocate( r2_mat(5,5) )

   print "(/,A)", "*** test number 324 ***"
   print "()"
   r2_mat = mfOnes(5,5)              ! mfArray_to_matrix_dble
   print "(1X,A,/,5(1X,F11.8))", "r2_mat = ", r2_mat

   !-----------------

   print "(/,A)", "*** test number 325 ***"
   print "()"
   c = mfOnes(1)                    ! mfArray_to_scalar_cmplx
   print "(1X,A,'(',F7.4,',',F7.4,')')", "c = ", c

   print "(/,A)", "*** test number 326 ***"
   print "()"
   c = mfOnes(1)*MF_PI              ! mfArray_to_scalar_cmplx
   print "(1X,A,'(',F7.4,',',F7.4,')')", "c = ", c

   print "(/,A)", "*** test number 327 ***"
   print "()"
   c_vec(:) = 0.
   c_vec(3) = mfOnes(1)             ! mfArray_to_scalar_cmplx
   print "(1X,A,5(1X,'(',F7.4,',',F7.4,')'))", "c_vec = ", c_vec

   print "(/,A)", "*** test number 328 ***"
   print "()"
   c_vec = mfOnes(1,5)              ! mfArray_to_vector_cmplx
   print "(1X,A,5(1X,'(',F7.4,',',F7.4,')'))", "c_vec = ", c_vec

   print "(/,A)", "*** test number 329 ***"
   print "()"
   c_vec = mfOnes(5,1)*MF_PI        ! mfArray_to_vector_cmplx
   print "(1X,A,5(1X,'(',F7.4,',',F7.4,')'))", "c_vec = ", c_vec

   print "(/,A)", "*** test number 330 ***"
   print "()"
   c_vec(2:4) = 2.0d0*mfOnes(1,3)   ! mfArray_to_vector_cmplx
   print "(1X,A,5(1X,'(',F7.4,',',F7.4,')'))", "c_vec = ", c_vec

   print "(/,A)", "*** test number 331 ***"
   print "()"
   c_mat = mfOnes(5,5)              ! mfArray_to_matrix_cmplx
   print "(1X,A,/,5(1X,'(',F7.4,',',F7.4,')'))", "c_mat = ", c_mat

   !-----------------

   print "(/,A)", "*** test number 332 ***"
   print "()"
   c2 = mfOnes(1)*MF_PI             ! mfArray_to_scalar_dble_cmplx
   print "(1X,A,'(',F11.8,',',F11.8,')')", "c2 = ", c2

   print "(/,A)", "*** test number 333 ***"
   print "()"
   c2 = mfOnes(1) + MF_I*mfZeros(1) ! mfArray_to_scalar_dble_cmplx
   print "(1X,A,'(',F11.8,',',F11.8,')')", "c2 = ", c2

   print "(/,A)", "*** test number 334 ***"
   print "()"
   c2_vec(:) = 0.
   c2_vec(3) = mfOnes(1)            ! mfArray_to_scalar_dble_cmplx
   print "(1X,A,5(1X,'(',F11.8,',',F11.8,')'))", "c2_vec = ", c2_vec

   print "(/,A)", "*** test number 335 ***"
   print "()"
   c2_vec = mfOnes(1,5)             ! mfArray_to_vector_dble_cmplx
   print "(1X,A,5(1X,'(',F11.8,',',F11.8,')'))", "c2_vec = ", c2_vec

   print "(/,A)", "*** test number 336 ***"
   print "()"
   c2_vec = mfOnes(5,1)*MF_PI       ! mfArray_to_vector_dble_cmplx
   print "(1X,A,5(1X,'(',F11.8,',',F11.8,')'))", "c2_vec = ", c2_vec

   print "(/,A)", "*** test number 337 ***"
   print "()"
   c2_vec(2:4) = 2.0d0*mfOnes(1,3)  ! mfArray_to_vector_dble_cmplx
   print "(1X,A,5(1X,'(',F11.8,',',F11.8,')'))", "c2_vec = ", c2_vec

   print "(/,A)", "*** test number 338 ***"
   print "()"
   allocate( c2_mat(5,5) )
   c2_mat = mfOnes(5,5)             ! mfArray_to_matrix_dble_cmplx
   print "(1X,A,/,5(1X,'(',F11.8,',',F11.8,')'))", "c2_mat = ", c2_mat
   deallocate( c2_mat )

   !-----------------

   print "(/,A)", "*** test number 339 ***"
   print "()"
   x = .true.
   bool = x                         ! mfArray_to_scalar_bool
   print *, "bool = ", bool

   print "(/,A)", "*** test number 340 ***"
   print "()"
   x = .true.
   bool_vec(:) = .false.
   bool_vec(3) = x                  ! mfArray_to_scalar_bool
   print *, "bool_vec = ", bool_vec

   print "(/,A)", "*** test number 341 ***"
   print "()"
   bool_vec = mfOnes(1,5) == mfOnes(1,5) ! mfArray_to_vector_bool
   print *, "bool_vec = ", bool_vec

   print "(/,A)", "*** test number 342 ***"
   print "()"
   bool_mat = mfOnes(5,5) == mfOnes(5,5) ! mfArray_to_matrix_bool
   print *, "bool_mat = ", bool_mat

   call msSetMsgLevel(MsgLevel_save)

   print "()"

   ! msPointer, msFreePointer ------------------------------------------
   call print_separation("msPointer, msFreePointer")

   print "(/,A)", "*** test number 343 ***"
   x = [ 1, 2, 3 ]
   call msDisplay(x,"x")
   call msPointer(x,f90_ptr) ! f90_ptr => x
   print *, "'msPointer(x,f90_ptr)'"
   call msDisplay(f90_ptr,"f90_ptr (=> x)")
   f90_ptr(1,2) = 777
   print *, "'f90_ptr(1,2) = 777'"
   call msDisplay(x,"x") ! check
   call msSet(8.0d0,x,3)
   print *, "'msSet(8.0d0,x,3)'"
   call msDisplay(f90_ptr,"f90_ptr") ! check
   call msFreePointer(x,f90_ptr) ! f90_ptr => null()

   print "(/,A)", "*** test number 344 ***"
   x = mfEye(3)
   call msDisplay(x,"x")
   call msPointer(x,f90_ptr_vec) ! f90_ptr_vec => x
   print *, "'msPointer(x,f90_ptr_vec)'"
   call msDisplay(f90_ptr_vec,"f90_ptr_vec (=> x)")
   f90_ptr_vec(2) = 7
   print *, "'f90_ptr_vec(2) = 7'"
   call msDisplay(x,"x") ! check
   call msSet(-22.0d0,x,1,3)
   print *, "'msSet(-22.0d0,x,1,3)'"
   call msDisplay(f90_ptr_vec,"f90_ptr_vec") ! check
   call msFreePointer(x,f90_ptr_vec) ! f90_ptr_vec => null()

   ! msEquiv -----------------------------------------------------------
   call print_separation("msEquiv")

   print "(/,A)", "*** test number 345 ***"
   allocate( f90_array(3,3) )
   f90_array(:,:) = 0.
   f90_array(1,1) = 1.
   f90_array(1,3) = 3.
   call msDisplay(f90_array,"f90_array")

   call msEquiv(f90_array,x)
   print *, "'msEquiv(f90_array,x)' (i.e. x => f90_array)"
   call msDisplay(x,"x")

   x = x*2.0d0
   print *, "'x = x*2.0d0'"
   call msDisplay(x,"x")
   call msDisplay(f90_array,"f90_array")

   x = .t. x
   print *, "'x = .t. x'"
   call msDisplay(x,"x")
   call msDisplay(f90_array,"f90_array")

   call msRelease(x) ! else error during next assignment of x
   ! previous release doesn't deallocate f90_array !
   deallocate( f90_array )

   print "(/,A)", "*** test number 346 ***"
   allocate( f90_vec(6) )
   f90_vec(:) = 0.
   f90_vec(1) = -1.
   f90_vec(3) = sqrt(2.0d0)/2.0d0
   f90_vec(6) = 1.
   call msDisplay(f90_vec,"f90_vec")

   call msEquiv(f90_vec,x)
   print *, "'msEquiv(f90_vec,x)' (i.e. x => f90_vec)"
   call msDisplay(x,"x")

   x = x * 2.0d0
   print *, "'x = x*2.0d0'"
   call msDisplay(x,"x")
   call msDisplay(f90_vec,"f90_vec")

   ! but cannot transpose 'x' because it is a restricted array !

   call msRelease(x) ! else error during next assignment of x
   ! previous release doesn't deallocate f90_vec !
   deallocate( f90_vec )

   ! msFormat ----------------------------------------------------------
   call print_separation("msFormat")

   print "(/,A)", "*** test number 347 ***"
   x = reshape( [ (sqrt(dble(i)), i = 1, 9) ], [ 9, 1 ] )
   call msDisplay(x,"reshape( [ (sqrt(dble(i)), i = 1, 9) ], [ 9, 1 ] )")
   call round_values( x, d=15 )

   call msFormat("long")
   call msDisplay(x,"(% in long format)")

   call msFormat("short")
   call msDisplay(x,"(% in short format)")

   print "(/,A)", "*** test number 348 ***"
   x = reshape( [ (sqrt(dble(i)), i = 1, 9) ], [ 1, 9 ] )
   call msDisplay(x,"reshape( [ (sqrt(dble(i)), i = 1, 9) ], [ 1, 9 ] )")
   call round_values( x, d=15 )

   call msFormat("long")
   call msDisplay(x,"(% in long format)")

   call msFormat("short")
   call msDisplay(x,"(% in short format)")

   print "(/,A)", "*** test number 349 ***"
   x = [ 1.5, 2.6E1, 3.7E2, 4.8E4 ]
   call msFormat(exponent="sci")
   call msDisplay(x,"x (scientific format)")

   call msFormat(exponent="eng")
   call msDisplay(x,"x (engineer format)")

   call msFormat()

   ! mfGet -------------------------------------------------------------
   call print_separation("mfGet")

   ! vector case
   x = [ (i, i = 1, 12) ]
   call msDisplay(x,"x")

   print "(/,A)", "*** test number 350 ***"
   call msDisplay(mfGet(x,3),                                           &
                 "mfGet(x,3)") ! mfGet_element_in_vec

   print "(/,A)", "*** test number 351 ***"
   call msDisplay(mfGet(x,[6,4,2]),                                     &
                 "mfGet(x,[6,4,2])") ! mfGet_section_in_vec

   print "(/,A)", "*** test number 352 ***"
   call msDisplay(mfGet(x,[(13-i,i=1,12)]),                             &
                 "mfGet(x,[(13-i,i=1,12)])") ! mfGet_section_in_vec

   x = reshape( [ (i, i = 1, 12) ], [ 3, 4 ] )
   call msDisplay(x,"x")

   print "(/,A)", "*** test number 353 ***"
   call msDisplay(mfGet(x,[1,5,7,11]),                                  &
                 "mfGet(x,[1,5,7,11])") ! mfGet_section_in_vec

   x = reshape( [ (i, i = 1, 12) ], [ 3, 4 ] )
   x = x*MF_I
   call msDisplay(x,"x")

   print "(/,A)", "*** test number 354 ***"
   call msDisplay(mfGet(x,[1,5,7,11]),                                  &
                 "mfGet(x,[1,5,7,11])") ! mfGet_section_in_vec

   x = reshape( [ (i, i = 1, 12) ], [ 3, 4 ] )
   call msDisplay(x,"x")

   print "(/,A)", "*** test number 355 ***"
   call msDisplay(mfGet(x,mf([1,5,7,11])),                              &
                 "mfGet(x,mf([1,5,7,11]))") ! mfGet_section_in_vec

   x = reshape( [ (i, i = 1, 12) ], [ 3, 4 ] )
   x = x*MF_I
   call msDisplay(x,"x")

   print "(/,A)", "*** test number 356 ***"
   call msDisplay(mfGet(x,mf([1,5,7,11])),                              &
                 "mfGet(x,mf([1,5,7,11]))") ! mfGet_section_in_vec

   x = [ (i, i = 1, 12) ]
   call msDisplay(x,"x")

   print "(/,A)", "*** test number 357 ***"
   call msDisplay(mfGet(x, 12 .to. 1 .by. -1 ),                         &
                 "mfGet(x, 12 .to. 1 .by. -1 )") ! mfGet_section_in_vec_seq

   print "(/,A)", "*** test number 358 ***"
   call msDisplay(mfGet(x,mf([2,4,6])),                                 &
                 "mfGet(x,mf([2,4,6]))") ! mfGet_elems_in_array

   x = [ 8, 0, 3, -2, 10, 5, 20 ]
   call msDisplay(x,"x")
   print "(/,A)", "*** test number 359 ***"
   call msDisplay(mfGet(x,x>6.0d0),                                     &
                 "mfGet(x,x>6.0d0)") ! mfGet_elems_in_array (bool filter)
   x = .t. x
   call msDisplay(x,"x")
   print "(/,A)", "*** test number 360 ***"
   call msDisplay(mfGet(x,x<6.0d0),                                     &
                 "mfGet(x,x<6.0d0)") ! mfGet_elems_in_array (bool filter)

   x = reshape( [ (i, i = 1, 9) ], [ 3, 3 ] )
   call mf_save_and_disable_fpe( )
   call msSet( MF_NAN, x, 1, 1 )
   call mf_restore_fpe( )
   call msSet( MF_INF, x, 1, 3 )
   call msSet(-MF_INF, x, 3, 1 )
   call mf_save_and_disable_fpe( )
   call msSet( MF_NAN, x, 3, 3 )
   call mf_restore_fpe( )
   call msDisplay(x,"x")
   print "(/,A)", "*** test number 361 ***"
   call msDisplay(mfGet(x,mfIsFinite(x)),                               &
                 "mfGet(x,mfIsFinite(x))") ! mfGet_elems_in_array (bool filter)

   ! matrix case
   x = reshape( [ (i, i = 1, 36) ], [ 6, 6 ] )
   call msDisplay(x,"x")

   print "(/,A)", "*** test number 362 ***"
   call msDisplay(mfGet(x,3,2),                                         &
                 "mfGet(x,3,2)") ! mfGet_element

   print "(/,A)", "*** test number 363 ***"
   call msDisplay(mfGet(x,MF_COLON,[1,2]),                              &
                 "mfGet(x,MF_COLON,[1,2])") ! mfGet_section_array_vec

   print "(/,A)", "*** test number 364 ***"
   call msDisplay(mfGet(x,mf([2,4]),[3,5]),                             &
                 "mfGet(x,mf([2,4]),[3,5])") ! mfGet_section_array_vec

   print "(/,A)", "*** test number 365 ***"
   call msDisplay(mfGet(x,MF_COLON, 2 .to. 6 .by. 2 ),                  &
                 "mfGet(x,MF_COLON, 2 .to. 6 .by. 2 )") ! mfGet_section_array_vec_seq

   print "(/,A)", "*** test number 366 ***"
   call msDisplay(mfGet(x,mf([1,3,5]), 2 .to. 6 .by. 2 ),               &
                 "mfGet(x,mf([1,3,5]), 2 .to. 6 .by. 2 )") ! mfGet_section_array_vec_seq

   print "(/,A)", "*** test number 367 ***"
   call msDisplay(mfGet(x,[1,2],MF_COLON),                              &
                 "mfGet(x,[1,2],MF_COLON)") ! mfGet_section_vec_array

   print "(/,A)", "*** test number 368 ***"
   call msDisplay(mfGet(x,[1,2],mf([2,4])),                             &
                 "mfGet(x,[1,2],mf([2,4]))") ! mfGet_section_vec_array

   print "(/,A)", "*** test number 369 ***"
   call msDisplay(mfGet(x, 6 .to. 2 .by. -2, MF_COLON),                 &
                 "mfGet(x, 6 .to. 2 .by. -2, MF_COLON)") ! mfGet_section_vec_seq_array

   print "(/,A)", "*** test number 370 ***"
   call msDisplay(mfGet(x, 6 .to. 2 .by. -2, mf([2,4])),                &
                 "mfGet(x, 6 .to. 2 .by. -2, mf([2,4]))") ! mfGet_section_vec_seq_array

   print "(/,A)", "*** test number 371 ***"
   call msDisplay(mfGet(x,[2,3],[2,3,4]),                               &
                 "mfGet(x,[2,3],[2,3,4])") ! mfGet_section_vec_vec

   print "(/,A)", "*** test number 372 ***"
   call msDisplay(mfGet(x,[4,2],[4,2]),                                 &
                 "mfGet(x,[4,2],[4,2])") ! mfGet_section_vec_vec

   print "(/,A)", "*** test number 373 ***"
   call msDisplay(mfGet(x, 2 .to. 6 .by. 2, 5 .to. 1 .by. -1 ),         &
                 "mfGet(x, 2 .to. 6 .by. 2, 5 .to. 1 .by. -1 )") ! mfGet_section_vec_seq_vec_seq

   print "(/,A)", "*** test number 374 ***"
   call msDisplay(mfGet(x,MF_COLON,3),                                  &
                 "mfGet(x,MF_COLON,3)") ! mfGet_section_array_int

   print "(/,A)", "*** test number 375 ***"
   call msDisplay(mfGet(x,mf([2,4]),3),                                 &
                 "mfGet(x,mf([2,4]),3)") ! mfGet_section_array_int

   print "(/,A)", "*** test number 376 ***"
   call msDisplay(mfGet(x,3,MF_COLON),                                  &
                 "mfGet(x,3,MF_COLON)") ! mfGet_section_int_array

   print "(/,A)", "*** test number 377 ***"
   call msDisplay(mfGet(x,3,mf([2,4])),                                 &
                 "mfGet(x,3,mf([2,4]))") ! mfGet_section_int_array

   print "(/,A)", "*** test number 378 ***"
   call msDisplay(mfGet(x,mf([2,3]),mf([2,3,4])),                       &
                 "mfGet(x,mf([2,3]),mf([2,3,4])") ! mfGet_section_array_array

   print "(/,A)", "*** test number 379 ***"
   u = reshape( [1,2,3,4], [2,2] )
   call msDisplay(u,"u")
   v = reshape( [2,3,4,5], [2,2] )
   call msDisplay(v,"v")
   call msDisplay(mfGet(x,u,v),                                         &
                 "mfGet(x,u,v)") ! mfGet_section_array_array

   ! usage of MF_END

   print "(/,A)", "*** test number 380 ***"
   v = mfColon(1,4)
   call msDisplay(v,"v")
   call msDisplay( mfGet(v,MF_END), "v(end)" ) ! mfGet_elems_in_array
   call msDisplay( mfGet(v,MF_END-1), "v(end-1)" )

   print "(/,A)", "*** test number 381 ***"
   v = mfColon(1,4)
   call msDisplay(v,"v")
   call msDisplay( mfGet(v,MF_END-1.to.MF_END), "v(end-1:end)" ) ! mfGet_elems_in_array

   print "(/,A)", "*** test number 382 ***"
   v = .t. mfColon(1,4)
   call msDisplay(v,"v")
   call msDisplay( mfGet(v,MF_END), "v(end)" ) ! mfGet_elems_in_array
   call msDisplay( mfGet(v,MF_END-1), "v(end-1)" )

   print "(/,A)", "*** test number 383 ***"
   v = mfGet(mfMagic(4),MF_COLON,1.to.3)
   call msDisplay(v,"v")
   call msDisplay( mfGet(v,MF_END,2), "v(end,2)" ) ! mfGet_section_array_int
   call msDisplay( mfGet(v,MF_END-1,2), "v(end-1,2)" ) ! mfGet_section_array_int

   print "(/,A)", "*** test number 384 ***"
   v = mfGet(mfMagic(4),1.to.3,MF_COLON)
   call msDisplay(v,"v")
   call msDisplay( mfGet(v,2,MF_END), "v(2,end)" ) ! mfGet_section_int_array
   call msDisplay( mfGet(v,2,MF_END-1), "v(2,end-1)" ) ! mfGet_section_int_array

   print "(/,A)", "*** test number 385 ***"
   v = mfGet(mfMagic(4),MF_COLON,1.to.3)
   call msDisplay(v,"v")
   call msDisplay( mfGet(v,MF_END,[2,3]), "v(end,2:3)" ) ! mfGet_section_array_vec
   call msDisplay( mfGet(v,MF_END-1,[2,3]), "v(end-1,2:3)" ) ! mfGet_section_array_vec

   print "(/,A)", "*** test number 386 ***"
   v = mfGet(mfMagic(4),1.to.3,MF_COLON)
   call msDisplay(v,"v")
   call msDisplay( mfGet(v,[2,3],MF_END), "v(2:3,end)" ) ! mfGet_section_vec_array
   call msDisplay( mfGet(v,[2,3],MF_END-1), "v(2:3,end-1)" ) ! mfGet_section_vec_array

   print "(/,A)", "*** test number 387 ***"
   v = mfGet(mfMagic(4),MF_COLON,1.to.3)
   call msDisplay(v,"v")
   call msDisplay( mfGet(v,MF_END,2.to.3), "v(end,2:3)" ) ! mfGet_section_array_vseq
   call msDisplay( mfGet(v,MF_END-1,2.to.3), "v(end-1,2:3)" ) ! mfGet_section_array_vseq

   print "(/,A)", "*** test number 388 ***"
   v = mfGet(mfMagic(4),1.to.3,MF_COLON)
   call msDisplay(v,"v")
   call msDisplay( mfGet(v,2.to.3,MF_END), "v(2:3,end)" ) ! mfGet_section_vseq_array
   call msDisplay( mfGet(v,2.to.3,MF_END-1), "v(2:3,end-1)" ) ! mfGet_section_vseq_array

   print "(/,A)", "*** test number 389 ***"
   v = mfGet(mfMagic(4),MF_COLON,1.to.3)
   call msDisplay(v,"v")
   call msDisplay( mfGet(v,MF_COLON,MF_END), "v(:,end)" ) ! mfGet_section_array_array
   call msDisplay( mfGet(v,MF_COLON,MF_END-1), "v(:,end-1)" ) ! mfGet_section_array_array

   print "(/,A)", "*** test number 390 ***"
   v = mfGet(mfMagic(4),1.to.3,MF_COLON)
   call msDisplay(v,"v")
   call msDisplay( mfGet(v,MF_END,MF_COLON), "v(end,:)" ) ! mfGet_section_array_array
   call msDisplay( mfGet(v,MF_END-1,MF_COLON), "v(end-1,:)" ) ! mfGet_section_array_array

   print "(/,A)", "*** test number 391 ***"
   v = mfGet(mfMagic(4),MF_COLON,1.to.3)
   call msDisplay(v,"v")
   call msDisplay( mfGet(v,mf([2,3]),MF_END), "v(2:3,end)" ) ! mfGet_section_array_array
   call msDisplay( mfGet(v,mf([2,3]),MF_END-1), "v(2:3,end-1)" ) ! mfGet_section_array_array

   print "(/,A)", "*** test number 392 ***"
   v = mfGet(mfMagic(4),1.to.3,MF_COLON)
   call msDisplay(v,"v")
   call msDisplay( mfGet(v,MF_END,mf([2,3])), "v(end,2:3)" ) ! mfGet_section_array_array
   call msDisplay( mfGet(v,MF_END-1,mf([2,3])), "v(end-1,2:3)" ) ! mfGet_section_array_array

   print "(/,A)", "*** test number 393 ***"
   v = mfGet(mfMagic(4),MF_COLON,1.to.3)
   call msDisplay(v,"v")
   call msDisplay( mfGet(v,MF_END,MF_END), "v(end,end)" ) ! mfGet_section_array_array
   call msDisplay( mfGet(v,MF_END-1,MF_END-1), "v(end-1,end-1)" ) ! mfGet_section_array_array

   print "(/,A)", "*** test number 394 ***"
   v = mfGet(mfMagic(5),1,MF_COLON)
   call msDisplay(v,"v")
   call msDisplay( mfGet(v,2.to.MF_END-1), "v(2:end-1)" ) ! mfGet_section_in_vseq

   print "(/,A)", "*** test number 395 ***"
   v = mfGet(mfMagic(5),1.to.4,MF_COLON)
   call msDisplay(v,"v")
   call msDisplay( mfGet(v,2,2.to.MF_END-1), "v(2,2:end-1)" ) ! mfGet_section_int_vseq

   print "(/,A)", "*** test number 396 ***"
   v = mfGet(mfMagic(5),1.to.4,MF_COLON)
   call msDisplay(v,"v")
   call msDisplay( mfGet(v,2.to.MF_END-1,2), "v(2:end-1,2)" ) ! mfGet_section_vseq_int

   print "(/,A)", "*** test number 397 ***"
   v = mfGet(mfMagic(5),1.to.4,MF_COLON)
   call msDisplay(v,"v")
   call msDisplay( mfGet(v,mf(2),2.to.MF_END-1), "v(2,2:end-1)" ) ! mfGet_section_array_vseq

   print "(/,A)", "*** test number 398 ***"
   v = mfGet(mfMagic(5),1.to.4,MF_COLON)
   call msDisplay(v,"v")
   call msDisplay( mfGet(v,2.to.MF_END-1,mf(2)), "v(2:end-1,2)" ) ! mfGet_section_vseq_array

   print "(/,A)", "*** test number 399 ***"
   v = mfMagic(5)
   call msDisplay(v,"v")
   call msDisplay( mfGet(v,2.to.MF_END-1,2.to.MF_END-1), "v(2:end-1,2:end-1)" ) ! mfGet_section_vseq_vseq

   ! special tests for .and. and .but. operators

   print "(/,A)", "*** test number 400 ***"
   v = mfColon(1,5)
   call msDisplay(v,"v")
   call msDisplay( mfGet(v, (MF_END.to.2.by.-1) .and. (1.to.4) ),       &
                  "mfGet(v, (MF_END.to.2.by.-1) .and. (1.to.4) )" )

   print "(/,A)", "*** test number 401 ***"
   v = mfColon(1,5)
   call msDisplay(v,"v")
   call msDisplay( mfGet(v, (3.to.MF_END) .and. (1.to.4) ),             &
                  "mfGet(v, (3.to.MF_END) .and. (1.to.4) )" )

   print "(/,A)", "*** test number 402 ***"
   v = mfColon(1,5)
   call msDisplay(v,"v")
   call msDisplay( mfGet(v, (1.to.4) .and. (MF_END-3.to.MF_END) ),      &
                  "mfGet(v, (1.to.4) .and. (MF_END-3.to.MF_END) )" )

   print "(/,A)", "*** test number 403 ***"
   v = mfColon(1,9)
   call msDisplay(v,"v")
   call msDisplay( mfGet(v, (1.to.9.by.2) .but. 5 ),                    &
                  "mfGet(v, (1.to.9.by.2) .but. 5 )" )

   print "(/,A)", "*** test number 404 ***"
   v = mfColon(1,9)
   call msDisplay(v,"v")
   call msDisplay( mfGet(v, (1.to.MF_END.by. 2) .but. 5 ),              &
                  "mfGet(v, (1.to.MF_END.by. 2) .but. 5 )" )

   print "(/,A)", "*** test number 405 ***"
   v = mfColon(1,9)
   call msDisplay(v,"v")
   call msDisplay( mfGet(v, (1.to.MF_END.by. 2) .but. 4 ),              &
                  "mfGet(v, (1.to.MF_END.by. 2) .but. 4 )" )

   print "(/,A)", "*** test number 406 ***"
   v = mfColon(1,5)
   call msDisplay(v,"v")
   call msDisplay( mfGet(v, (2.to.MF_END) .but. MF_END-1 ),             &
                  "mfGet(v, (2.to.MF_END) .but. MF_END-1 )" )

   print "(/,A)", "*** test number 407 ***"
   v = mfColon(1,5)
   call msDisplay(v,"v")
   call msDisplay( mfGet(v, MF_ALL .but. 2 ),                           &
                  "mfGet(v, MF_ALL .but. 2 )" )

   print "(/,A)", "*** test number 408 ***"
   v = mfColon(1,5)
   call msDisplay(v,"v")
   call msDisplay( mfGet(v, MF_ALL .but. MF_END-1 ),                    &
                  "mfGet(v, MF_ALL .but. MF_END-1 )" )

   ! msSet -------------------------------------------------------------
   call print_separation("msSet")

   print "(/,A)", "*** test number 409 ***"
   x = MF_EMPTY
   call msDisplay(x,"x")
   call msSet(0.5d0,x,2) ! msSet_element_real8_in_vec (with realloc_array)
   call msDisplay(x,"msSet(0.5d0,x,2), x")

   print "(/,A)", "*** test number 410 ***"
   x = MF_EMPTY
   call msDisplay(x,"x")
   call msSet(0.5d0,x,2,2) ! msSet_element_real8 (with realloc_array)
   call msDisplay(x,"msSet(0.5d0,x,2,2), x")

   print "(/,A)", "*** test number 411 ***"
   x = reshape( [ (i, i = 1, 9) ], [ 3, 3 ] )
   call msDisplay(x,"x")
   call msSet(0.5d0,x,2,2) ! msSet_element_real8
   call msDisplay(x,"msSet(0.5d0,x,2,2), x")

   call msSet(0.75d0,x,4,5) ! msSet_element_real8 (with realloc_array)
   call msDisplay(x,"msSet(0.75d0,x,4,5), x")

   print "(/,A)", "*** test number 412 ***"
   x = MF_EMPTY
   call msDisplay(x,"x")
   call msSet((0.0d0,1.0d0),x,2) ! msSet_element_cmplx_in_vec (with realloc_array)
   call msDisplay(x,"msSet((0.0d0,1.0d0),x,2), x")

   print "(/,A)", "*** test number 413 ***"
   x = MF_EMPTY
   call msDisplay(x,"x")
   call msSet((0.0d0,1.0d0),x,2,2) ! msSet_element_cmplx (with realloc_array)
   call msDisplay(x,"msSet((0.0d0,1.0d0),x,2,2), x")

   print "(/,A)", "*** test number 414 ***"
   x = reshape( [ (i, i = 1, 9) ], [ 3, 3 ] )
   call msDisplay(x,"x")
   call msSet((0.0d0,1.0d0),x,2,2) ! msSet_element_cmplx
   call msDisplay(x,"msSet((0.0d0,1.0d0),x,2,2), x")

   print "(/,A)", "*** test number 415 ***"
   call msSet((0.0d0,1.0d0),x,4,5) ! msSet_element_cmplx (with realloc_array)
   call msDisplay(x,"msSet(0.75d0,x,4,5), x")

   print "(/,A)", "*** test number 416 ***"
   x = [ (i, i = 1, 5) ]
   call msDisplay(x,"x")
   call msSet(0.5d0,x,3) ! msSet_element_real8_in_vec
   call msDisplay(x,"msSet(0.5d0,x,3), x")

   print "(/,A)", "*** test number 417 ***"
   call msSet(0.25d0,x,7) ! msSet_element_real8_in_vec (with realloc_array)
   call msDisplay(x,"msSet(0.25d0,x,7), x")

   print "(/,A)", "*** test number 418 ***"
   x = .t. [ (i, i = 1, 5) ]
   call msDisplay(x,"x")
   call msSet(0.5d0,x,3) ! msSet_element_real8_in_vec
   call msDisplay(x,"msSet(0.5d0,x,3), x")

   print "(/,A)", "*** test number 419 ***"
   call msSet(0.25d0,x,7) ! msSet_element_real8_in_vec (with realloc_array)
   call msDisplay(x,"msSet(0.25d0,x,7), x")

   print "(/,A)", "*** test number 420 ***"
   x = [ (i*MF_I, i = 1, 5) ]
   call msDisplay(x,"x")
   call msSet(0.5d0,x,3) ! msSet_element_real8_in_vec
   call msDisplay(x,"msSet(0.5d0,x,3), x")

   print "(/,A)", "*** test number 421 ***"
   call msSet(0.25d0,x,7) ! msSet_element_real8_in_vec (with realloc_array)
   call msDisplay(x,"msSet(0.25d0,x,7), x")

   print "(/,A)", "*** test number 422 ***"
   x = [ (i, i = 1, 5) ]
   call msDisplay(x,"x")
   call msSet(0.5d0*MF_I,x,3) ! msSet_element_cmplx_in_vec
   call msDisplay(x,"msSet(0.5d0*MF_I,x,3), x")

   print "(/,A)", "*** test number 423 ***"
   call msSet(0.25d0*MF_I,x,7) ! msSet_element_cmplx_in_vec (with realloc_array)
   call msDisplay(x,"msSet(0.25d0*MF_I,x,7), x")

   print "(/,A)", "*** test number 424 ***"
   x = .t. [ (i, i = 1, 5) ]
   call msDisplay(x,"x")
   call msSet(0.5d0*MF_I,x,3) ! msSet_element_cmplx_in_vec
   call msDisplay(x,"msSet(0.5d0*MF_I,x,3), x")

   print "(/,A)", "*** test number 425 ***"
   call msSet(0.25d0*MF_I,x,7) ! msSet_element_cmplx_in_vec (with realloc_array)
   call msDisplay(x,"msSet(0.25d0*MF_I,x,7), x")

   print "(/,A)", "*** test number 426 ***"
   x = [ (i*MF_I, i = 1, 5) ]
   call msDisplay(x,"x")
   call msSet(0.5d0*MF_I,x,3) ! msSet_element_cmplx_in_vec
   call msDisplay(x,"msSet(0.5d0*MF_I,x,3), x")

   print "(/,A)", "*** test number 427 ***"
   call msSet(0.25d0*MF_I,x,7) ! msSet_element_cmplx_in_vec (with realloc_array)
   call msDisplay(x,"msSet(0.25d0*MF_I,x,7), x")

   print "(/,A)", "*** test number 428 ***"
   x = mfOnes(3,3)
   call msDisplay(x,"x")
   call msSet(0.0d0,x,MF_END,MF_END) ! msSet_r8_array_array
   call msDisplay(x,"msSet(0.0d0,x,MF_END,MF_END), x")

   print "(/,A)", "*** test number 429 ***"
   call msSet(0.0d0,x,MF_END-1,MF_END-1) ! msSet_r8_array_array
   call msDisplay(x,"msSet(0.0d0,x,MF_END-1,MF_END-1), x")

   print "(/,A)", "*** test number 430 ***"
   x = mfOnes(3,3) + MF_I*mfOnes(3,3)
   call msDisplay(x,"x")
   call msSet((0.0d0,0.0d0),x,MF_END,MF_END) ! msSet_cmplx_array_array
   call msDisplay(x,"msSet((0.0d0,0.0d0),x,MF_END,MF_END), x")

   print "(/,A)", "*** test number 431 ***"
   call msSet((0.0d0,0.0d0),x,MF_END-1,MF_END-1) ! msSet_cmplx_array_array
   call msDisplay(x,"msSet((0.0d0,0.0d0),x,MF_END-1,MF_END-1), x")

   print "(/,A)", "*** test number 432 ***"
   x = MF_EMPTY
   call msDisplay(x,"x")
   call msSet(mf(0.25d0),x,3) ! msSet_array_element_in_vec
   call msDisplay(x,"msSet(mf(0.25d0),x,3), x")

   print "(/,A)", "*** test number 433 ***"
   x = [ (i, i = 1, 5) ]
   call msDisplay(x,"x")
   call msSet(mf(0.25d0),x,3) ! msSet_array_element_in_vec
   call msDisplay(x,"msSet(mf(0.25d0),x,3), x")

   print "(/,A)", "*** test number 434 ***"
   call msSet(mf(0.75d0),x,7) ! msSet_array_element_in_vec
   call msDisplay(x,"msSet(mf(0.75d0),x,7), x")

   print "(/,A)", "*** test number 435 ***"
   call msSet(MF_EMPTY,x,4) ! msSet_array_element_in_vec
   call msDisplay(x,"msSet(MF_EMPTY,x,4), x")

   print "(/,A)", "*** test number 436 ***"
   x = MF_EMPTY
   call msDisplay(x,"x")
   call msSet(mf(0.25d0*MF_I),x,3) ! msSet_array_element_in_vec
   call msDisplay(x,"msSet(mf(0.25d0*MF_I),x,3), x")

   print "(/,A)", "*** test number 437 ***"
   x = [ (i, i = 1, 5) ]
   call msDisplay(x,"x")
   call msSet(mf(0.25d0*MF_I),x,3) ! msSet_array_element_in_vec
   call msDisplay(x,"msSet(mf(0.25d0*MF_I),x,3), x")

   print "(/,A)", "*** test number 438 ***"
   call msSet(mf(0.75d0*MF_I),x,7) ! msSet_array_element_in_vec
   call msDisplay(x,"msSet(mf(0.75d0*MF_I),x,7), x")

   print "(/,A)", "*** test number 439 ***"
   x = .t. [ (i, i = 1, 5) ]
   call msDisplay(x,"x")
   call msSet(mf(0.25d0),x,3) ! msSet_array_element_in_vec
   call msDisplay(x,"msSet(mf(0.25d0),x,3), x")

   print "(/,A)", "*** test number 440 ***"
   call msSet(mf(0.75d0),x,7) ! msSet_array_element_in_vec
   call msDisplay(x,"msSet(mf(0.75d0),x,7), x")

   print "(/,A)", "*** test number 441 ***"
   call msSet(MF_EMPTY,x,4) ! msSet_array_element_in_vec
   call msDisplay(x,"msSet(MF_EMPTY,x,4), x")

   print "(/,A)", "*** test number 442 ***"
   x = .t. [ (i, i = 1, 5) ]
   call msDisplay(x,"x")
   call msSet(mf(0.25d0*MF_I),x,3) ! msSet_array_element_in_vec
   call msDisplay(x,"msSet(mf(0.25d0*MF_I),x,3), x")

   print "(/,A)", "*** test number 443 ***"
   call msSet(mf(0.75d0*MF_I),x,7) ! msSet_array_element_in_vec
   call msDisplay(x,"msSet(mf(0.75d0*MF_I),x,7), x")

   print "(/,A)", "*** test number 444 ***"
   x = MF_EMPTY
   call msDisplay(x,"x")
   call msSet(1.0d0,x,[3,4]) ! msSet_spread_real8_in_vec_section
   call msDisplay(x,"msSet(1.0d0,x,[3,4]), x")

   print "(/,A)", "*** test number 445 ***"
   x = [ (i, i = 1, 5) ]
   call msDisplay(x,"x")
   call msSet(0.0d0,x,[3,4]) ! msSet_spread_real8_in_vec_section
   call msDisplay(x,"msSet(0.0d0,x,[3,4]), x")

   print "(/,A)", "*** test number 446 ***"
   x = [ (i, i = 1, 5) ]
   call msDisplay(x,"x")
   call msSet(-1.0d0,x,[3,7]) ! msSet_spread_real8_in_vec_section (with realloc_array)
   call msDisplay(x,"msSet(-1.0d0,x,[3,7]), x")

   print "(/,A)", "*** test number 447 ***"
   x = MF_I*[ (i, i = 1, 5) ]
   call msDisplay(x,"x")
   call msSet(0.0d0,x,[3,4]) ! msSet_spread_real8_in_vec_section
   call msDisplay(x,"msSet(0.0d0,x,[3,4]), x")

   print "(/,A)", "*** test number 448 ***"
   x = MF_I*[ (i, i = 1, 5) ]
   call msDisplay(x,"x")
   call msSet(-1.0d0,x,[3,7]) ! msSet_spread_real8_in_vec_section (with realloc_array)
   call msDisplay(x,"msSet(-1.0d0,x,[3,7]), x")

   print "(/,A)", "*** test number 449 ***"
   x = MF_EMPTY
   call msDisplay(x,"x")
   call msSet(MF_I,x,[3,4]) ! msSet_spread_cmplx_in_vec_section
   call msDisplay(x,"msSet(MF_I,x,[3,4]), x")

   print "(/,A)", "*** test number 450 ***"
   x = [ (i, i = 1, 5) ]
   call msDisplay(x,"x")
   call msSet(MF_I,x,[3,4]) ! msSet_spread_cmplx_in_vec_section
   call msDisplay(x,"msSet(MF_I,x,[3,4]), x")

   print "(/,A)", "*** test number 451 ***"
   x = [ (i, i = 1, 5) ]
   call msDisplay(x,"x")
   call msSet(MF_I,x,[3,7]) ! msSet_spread_cmplx_in_vec_section (with realloc_array)
   call msDisplay(x,"msSet(MF_I,x,[3,7]), x")

   print "(/,A)", "*** test number 452 ***"
   x = MF_I*[ (i, i = 1, 5) ]
   call msDisplay(x,"x")
   call msSet(-1.0d0*MF_I,x,[3,4]) ! msSet_spread_cmplx_in_vec_section
   call msDisplay(x,"msSet(-1.0d0*MF_I,x,[3,4]), x")

   print "(/,A)", "*** test number 453 ***"
   x = MF_I*[ (i, i = 1, 5) ]
   call msDisplay(x,"x")
   call msSet(-1.0d0*MF_I,x,[3,7]) ! msSet_spread_cmplx_in_vec_section (with realloc_array)
   call msDisplay(x,"msSet(-1.0d0*MF_I,x,[3,7]), x")

   print "(/,A)", "*** test number 454 ***"
   x = MF_EMPTY
   call msDisplay(x,"x")
   call msSet(1.0d0,x,mf([3,4])) ! msSet_spread_real8_in_vec_sect2
   call msDisplay(x,"msSet(1.0d0,x,mf([3,4])), x")

   print "(/,A)", "*** test number 455 ***"
   x = [ (i, i = 1, 5) ]
   call msDisplay(x,"x")
   call msSet(0.0d0,x,mf([3,4])) ! msSet_spread_real8_in_vec_sect2
   call msDisplay(x,"msSet(0.0d0,x,mf([3,4])), x")

   print "(/,A)", "*** test number 456 ***"
   x = [ (i, i = 1, 5) ]
   call msDisplay(x,"x")
   call msSet(-1.0d0,x,mf([3,7])) ! msSet_spread_real8_in_vec_sect2 (with realloc_array)
   call msDisplay(x,"msSet(-1.0d0,x,mf([3,7])), x")

   print "(/,A)", "*** test number 457 ***"
   x = MF_I*[ (i, i = 1, 5) ]
   call msDisplay(x,"x")
   call msSet(0.0d0,x,mf([3,4])) ! msSet_spread_real8_in_vec_sect2
   call msDisplay(x,"msSet(0.0d0,x,mf([3,4])), x")

   print "(/,A)", "*** test number 458 ***"
   x = MF_I*[ (i, i = 1, 5) ]
   call msDisplay(x,"x")
   call msSet(-1.0d0,x,mf([3,7])) ! msSet_spread_real8_in_vec_sect2 (with realloc_array)
   call msDisplay(x,"msSet(-1.0d0,x,mf([3,7])), x")

   print "(/,A)", "*** test number 459 ***"
   x = MF_EMPTY
   call msDisplay(x,"x")
   call msSet(MF_I,x,mf([3,4])) ! msSet_spread_cmplx_in_vec_sect2
   call msDisplay(x,"msSet(MF_I,x,mf([3,4])), x")

   print "(/,A)", "*** test number 460 ***"
   x = [ (i, i = 1, 5) ]
   call msDisplay(x,"x")
   call msSet(MF_I,x,mf([3,4])) ! msSet_spread_cmplx_in_vec_sect2
   call msDisplay(x,"msSet(MF_I,x,mf([3,4])), x")

   print "(/,A)", "*** test number 461 ***"
   x = [ (i, i = 1, 5) ]
   call msDisplay(x,"x")
   call msSet(MF_I,x,mf([3,7])) ! msSet_spread_cmplx_in_vec_sect2 (with realloc_array)
   call msDisplay(x,"msSet(MF_I,x,mf([3,7])), x")

   print "(/,A)", "*** test number 462 ***"
   x = MF_I*[ (i, i = 1, 5) ]
   call msDisplay(x,"x")
   call msSet(-1.0d0*MF_I,x,mf([3,4])) ! msSet_spread_cmplx_in_vec_sect2
   call msDisplay(x,"msSet(-1.0d0*MF_I,x,mf([3,4])), x")

   print "(/,A)", "*** test number 463 ***"
   x = MF_I*[ (i, i = 1, 5) ]
   call msDisplay(x,"x")
   call msSet(-1.0d0*MF_I,x,mf([3,7])) ! msSet_spread_cmplx_in_vec_sect2 (with realloc_array)
   call msDisplay(x,"msSet(-1.0d0*MF_I,x,mf([3,7])), x")

   print "(/,A)", "*** test number 464 ***"
   x = MF_EMPTY
   call msDisplay(x,"x")
   call msSet(mf([1.0d0,1.0d0]),x,[3,4]) ! msSet_array_in_vec_section
   call msDisplay(x,"msSet(mf([1.0d0,1.0d0]),x,[3,4]), x")

   print "(/,A)", "*** test number 465 ***"
   x = MF_EMPTY
   call msDisplay(x,"x")
   call msSet(.t.mf([1.0d0,1.0d0]),x,[3,4]) ! msSet_array_in_vec_section
   call msDisplay(x,"msSet(.t.mf([1.0d0,1.0d0]),x,[3,4]), x")

   print "(/,A)", "*** test number 466 ***"
   x = [ (i, i = 1, 5) ]
   call msDisplay(x,"x")
   call msSet(mf([0.0d0,0.0d0]),x,[3,4]) ! msSet_array_in_vec_section
   call msDisplay(x,"msSet(mf([0.0d0,0.0d0]),x,[3,4]), x")

   print "(/,A)", "*** test number 467 ***"
   x = [ (i, i = 1, 5) ]
   call msDisplay(x,"x")
   call msSet(mf([-1.0d0,-1.0d0]),x,[3,7]) ! msSet_array_in_vec_section (with realloc_array)
   call msDisplay(x,"msSet(mf([-1.0d0,-1.0d0]),x,[3,7]), x")

   print "(/,A)", "*** test number 468 ***"
   x = MF_I*[ (i, i = 1, 5) ]
   call msDisplay(x,"x")
   call msSet(mf([0.0d0,0.0d0]),x,[3,4]) ! msSet_array_in_vec_section
   call msDisplay(x,"msSet(mf([0.0d0,0.0d0]),x,[3,4]), x")

   print "(/,A)", "*** test number 469 ***"
   x = MF_I*[ (i, i = 1, 5) ]
   call msDisplay(x,"x")
   call msSet(mf([-1.0d0,-1.0d0]),x,[3,7]) ! msSet_array_in_vec_section (with realloc_array)
   call msDisplay(x,"msSet(mf([-1.0d0,-1.0d0]),x,[3,7]), x")

   print "(/,A)", "*** test number 470 ***"
   x = MF_EMPTY
   call msDisplay(x,"x")
   call msSet(MF_I*mf([0.5d0,0.5d0]),x,[3,4]) ! msSet_array_in_vec_section
   call msDisplay(x,"msSet(MF_I*mf([0.5d0,0.5d0]),x,[3,4]), x")

   print "(/,A)", "*** test number 471 ***"
   x = MF_EMPTY
   call msDisplay(x,"x")
   call msSet(.h.mf(MF_I*([0.5d0,0.5d0])),x,[3,4]) ! msSet_array_in_vec_section
   call msDisplay(x,"msSet(.h.mf(MF_I*([0.5d0,0.5d0])),x,[3,4]), x")

   print "(/,A)", "*** test number 472 ***"
   x = [ (i, i = 1, 5) ]
   call msDisplay(x,"x")
   call msSet(MF_I*mf([0.5d0,0.5d0]),x,[3,4]) ! msSet_array_in_vec_section
   call msDisplay(x,"msSet(MF_I*mf([0.5d0,0.5d0]),x,[3,4]), x")

   print "(/,A)", "*** test number 473 ***"
   x = [ (i, i = 1, 5) ]
   call msDisplay(x,"x")
   call msSet(MF_I*mf([0.5d0,0.5d0]),x,[3,7]) ! msSet_array_in_vec_section (with realloc_array)
   call msDisplay(x,"msSet(MF_I*mf([0.5d0,0.5d0]),x,[3,7]), x")

   print "(/,A)", "*** test number 474 ***"
   x = MF_I*[ (i, i = 1, 5) ]
   call msDisplay(x,"x")
   call msSet(MF_I*mf([0.5d0,0.5d0]),x,[3,4]) ! msSet_array_in_vec_section
   call msDisplay(x,"msSet(MF_I*mf([0.5d0,0.5d0]),x,[3,4]), x")

   print "(/,A)", "*** test number 475 ***"
   x = MF_I*[ (i, i = 1, 5) ]
   call msDisplay(x,"x")
   call msSet(MF_I*mf([0.5d0,0.5d0]),x,[3,7]) ! msSet_array_in_vec_section (with realloc_array)
   call msDisplay(x,"msSet(MF_I*mf([0.5d0,0.5d0]),x,[3,7]), x")

   print "(/,A)", "*** test number 476 ***"
   x = MF_EMPTY
   data = reshape( [1,2,3,4], [ 2, 2 ] )
   call msDisplay(data,"data")
   call msSet(data,x,[3,4],[2,3]) ! msSet_array_section_vec_vec
   call msDisplay(x,"msSet(data,x,[3,4],[2,3]), x")

   print "(/,A)", "*** test number 477 ***"
   x = reshape( [ (sqrt(dble(i)), i = 1, 9) ], [ 3, 3 ] )
   call msDisplay(x,"x")
   data = reshape( [6,7,8,9], [ 2, 2 ] )
   call msDisplay(data,"data")
   call msSet(data,x,[1,2],[1,2]) ! msSet_array_section_vec_vec
   call msDisplay(x,"msSet(data,x,[1,2],[1,2]), x")

   print "(/,A)", "*** test number 478 ***"
   data = reshape( [1,2,3,4], [ 2, 2 ] )
   call msDisplay(data,"data")
   call msSet(data,x,[3,4],[2,3]) ! msSet_array_section_vec_vec
   call msDisplay(x,"msSet(data,x,[3,4],[2,3]), x")

   print "(/,A)", "*** test number 479 ***"
   x = reshape( [ (sqrt(dble(i)), i = 1, 9) ], [ 3, 3 ] )
   call msDisplay(x,"x")
   data = reshape( [6,7,8,9], [ 2, 2 ] )
   call msDisplay(data,"data")
   call msSet(data,x,[3,4],[3,4]) ! msSet_array_section_vec_vec
   call msDisplay(x,"msSet(data,x,[3,4],[3,4]), x")

   print "(/,A)", "*** test number 480 ***"
   data = reshape( [1,2,3,4]*MF_I, [ 2, 2 ] )
   call msDisplay(data,"data")
   call msSet(data,x,[3,4],[2,3]) ! msSet_array_section_vec_vec
   call msDisplay(x,"msSet(data,x,[3,4],[2,3]), x")

   print "(/,A)", "*** test number 481 ***"
   x = reshape( [ (sqrt(dble(i)), i = 1, 9) ], [ 3, 3 ] )
   call msDisplay(x,"x")
   data = reshape( [6,7,8,9], [ 2, 2 ] )
   call msDisplay(data,"data")
   call msSet( data, x, 1 .to. 2, 1 .to. 2 ) ! msSet_arr_sect_vec_seq_vec_seq
   call msDisplay(x,"msSet( data, x, 1 .to. 2, 1 .to. 2 ), x")

   ! spreading data
   print "(/,A)", "*** test number 482 ***"
   call msSet(mf(-1.0d0),x, 2 .to. 3, 2 .to. 3) ! msSet_arr_sect_vec_seq_vec_seq
   call msDisplay(x,"msSet( mf(0.0d0), x, 2 .to. 3, 2 .to. 3 ), x")

   ! extending 1 dim
   print "(/,A)", "*** test number 483 ***"
   data = reshape( [1,2,3,4], [ 2, 2 ] )
   call msDisplay(data,"data")
   call msSet( data, x, 3 .to. 4, 2 .to. 3 ) ! msSet_arr_sect_vec_seq_vec_seq
   call msDisplay(x,"msSet( data, x, 3 .to. 4, 2 .to. 3 ), x")

   ! extending 2 dims
   print "(/,A)", "*** test number 484 ***"
   x = reshape( [ (sqrt(dble(i)), i = 1, 9) ], [ 3, 3 ] )
   call msDisplay(x,"x")
   data = reshape( [6,7,8,9], [ 2, 2 ] )
   call msDisplay(data,"data")
   call msSet( data, x, 3 .to. 4, 3 .to. 4 ) ! msSet_arr_sect_vec_seq_vec_seq
   call msDisplay(x,"msSet( data, x, 3 .to. 4, 3 .to. 4 ), x")

   ! complex data
   print "(/,A)", "*** test number 485 ***"
   data = reshape( [1,2,3,4]*MF_I, [ 2, 2 ] )
   call msDisplay(data,"data")
   call msSet( data, x, 3 .to. 4, 2 .to. 3 ) ! msSet_arr_sect_vec_seq_vec_seq
   call msDisplay(x,"msSet( data, x, 3 .to. 4, 2 .to. 3 ), x")

   ! spreading real*8 data in array section
   print "(/,A)", "*** test number 486 ***"
   x = reshape( [ (sqrt(dble(i)), i = 1, 9) ], [ 3, 3 ] )
   call msDisplay(x,"x")
   data = reshape( [6,7,8,9], [ 2, 2 ] )
   call msSet( -1.0d0, x, 1 .to. 2, 1 .to. 2 ) ! msSet_sprd_r8_in_vec_seq_vec_seq
   call msDisplay(x,"msSet( -1.0d0, x, 1 .to. 2, 1 .to. 2 ), x")

   ! spreading real*8 data in array section
   print "(/,A)", "*** test number 487 ***"
   x = reshape( [ (sqrt(dble(i)), i = 1, 9) ], [ 3, 3 ] )
   call msDisplay(x,"x")
   data = reshape( [6,7,8,9], [ 2, 2 ] )
   call msSet( -1.0d0, x, 2, 1 .to. 2 ) ! msSet_sprd_r8_in_int_vec_seq
   call msDisplay(x,"msSet( -1.0d0, x, 2, 1 .to. 2 ), x")

   ! spreading real*8 data in array section
   print "(/,A)", "*** test number 488 ***"
   x = reshape( [ (sqrt(dble(i)), i = 1, 9) ], [ 3, 3 ] )
   call msDisplay(x,"x")
   data = reshape( [6,7,8,9], [ 2, 2 ] )
   call msSet( -1.0d0, x, 1 .to. 2, 2 ) ! msSet_sprd_r8_in_vec_seq_int
   call msDisplay(x,"msSet( -1.0d0, x, 1 .to. 2, 2 ), x")

   x = reshape( [ (sqrt(dble(i)), i = 1, 9) ], [ 3, 3 ] )
   call msDisplay(x,"x")
   data = reshape( [6,7,8,9], [ 2, 2 ] )
   call msDisplay(data,"data")
   print "(/,A)", "*** test number 489 ***"
   call msSet(data,x,mf([1,2]),mf([1,2])) ! msSet_array_section_array_array
   call msDisplay(x,"msSet(data,x,mf([1,2]),mf([1,2])), x")

   data = reshape( [1,2,3,4], [ 2, 2 ] )
   call msDisplay(data,"data")
   print "(/,A)", "*** test number 490 ***"
   call msSet(data,x,mf([3,4]),mf([2,3])) ! msSet_array_section_array_array
   call msDisplay(x,"msSet(data,x,mf([3,4]),mf([2,3])), x")

   x = reshape( [ (sqrt(dble(i)), i = 1, 9) ], [ 3, 3 ] )
   call msDisplay(x,"x")
   data = reshape( [6,7,8,9], [ 2, 2 ] )
   call msDisplay(data,"data")
   print "(/,A)", "*** test number 491 ***"
   call msSet(data,x,mf([3,4]),mf([3,4])) ! msSet_array_section_array_array
   call msDisplay(x,"msSet(data,x,mf([3,4]),mf([3,4])), x")

   data = reshape( [1,2,3,4]*MF_I, [ 2, 2 ] )
   call msDisplay(data,"data")
   print "(/,A)", "*** test number 492 ***"
   call msSet(data,x,mf([3,4]),mf([2,3])) ! msSet_array_section_array_array
   call msDisplay(x,"msSet(data,x,mf([3,4]),mf([2,3])), x")

   x = reshape( [ (i, i = 1, 9) ], [ 3, 3 ] )
   call msDisplay(x,"x")
   print "(/,A)", "*** test number 493 ***"
   call msSet(0.25d0,x,[2,3],[2,3]) ! msSet_spread_real8_in_section
   call msDisplay(x,"msSet(0.25d0,x,[2,3],[2,3]), x")

   print "(/,A)", "*** test number 494 ***"
   call msSet(-0.25d0,x,[3,4],[4,5]) ! msSet_spread_real8_in_section
   call msDisplay(x,"msSet(-0.25d0,x,[3,4],[4,5]), x")

   x = reshape( [ (i*MF_I, i = 1, 9) ], [ 3, 3 ] )
   call msDisplay(x,"x")
   print "(/,A)", "*** test number 495 ***"
   call msSet(0.25d0,x,[2,3],[2,3]) ! msSet_spread_real8_in_section
   call msDisplay(x,"msSet(0.25d0,x,[2,3],[2,3]), x")

   x = reshape( [ (i, i = 1, 9) ], [ 3, 3 ] )
   call msDisplay(x,"x")
   print "(/,A)", "*** test number 496 ***"
   call msSet(0.25d0*MF_I,x,[2,3],[2,3]) ! msSet_spread_cmplx_in_section
   call msDisplay(x,"msSet(0.25d0*MF_I,x,[2,3],[2,3]), x")

   print "(/,A)", "*** test number 497 ***"
   call msSet(-0.25d0*MF_I,x,[3,4],[4,5]) ! msSet_spread_cmplx_in_section
   call msDisplay(x,"msSet(-0.25d0*MF_I,x,[3,4],[4,5]), x")

   x = reshape( [ (i*MF_I, i = 1, 9) ], [ 3, 3 ] )
   call msDisplay(x,"x")
   print "(/,A)", "*** test number 498 ***"
   call msSet(0.25d0*MF_I,x,[2,3],[2,3]) ! msSet_spread_cmplx_in_section
   call msDisplay(x,"msSet(0.25d0,x,[2,3],[2,3]), x")

   x = reshape( [ (i+0.5, i = 1, 9) ], [ 3, 3 ] )
   call msDisplay(x,"x")
   print "(/,A)", "*** test number 499 ***"
   call msSet(0.0d0,x,MF_COLON,[3]) ! msSet_spread_real8_in_colon_vec
   call msDisplay(x,"msSet(0.0d0,x,MF_COLON,[3]), x")

   x = reshape( [ (i+0.5, i = 1, 9) ], [ 3, 3 ] )
   call msDisplay(x,"x")
   print "(/,A)", "*** test number 500 ***"
   call msSet(0.0d0,x,[3],MF_COLON) ! msSet_spread_real8_in_colon_vec
   call msDisplay(x,"msSet(0.0d0,x,[3],MF_COLON), x")

   x = reshape( [ (i+0.5, i = 1, 9) ], [ 3, 3 ] )
   call msDisplay(x,"x")
   print "(/,A)", "*** test number 501 ***"
   call msSet(0.0d0*MF_I,x,MF_COLON,[3]) ! msSet_spread_cmplx_in_colon_vec
   call msDisplay(x,"msSet(0.0d0*MF_I,x,MF_COLON,[3]), x")

   x = reshape( [ (i+0.5, i = 1, 9) ], [ 3, 3 ] )
   call msDisplay(x,"x")
   print "(/,A)", "*** test number 502 ***"
   call msSet(0.0d0*MF_I,x,[3],MF_COLON) ! msSet_spread_cmplx_in_colon_vec
   call msDisplay(x,"msSet(0.0d0*MF_I,x,[3],MF_COLON), x")

   x = reshape( [ (i+0.5, i = 1, 9) ], [ 3, 3 ] )
   call msDisplay(x,"x")
   data = reshape( [0,0,0], [ 3, 1 ] )
   call msDisplay(data,"data")
   print "(/,A)", "*** test number 503 ***"
   call msSet(data,x,MF_COLON,[3]) ! msSet_array_section_colon_vec
   call msDisplay(x,"msSet(data,x,MF_COLON,[3]), x")

   data = reshape( [8,8,8], [ 3, 1 ] )
   call msDisplay(data,"data")
   print "(/,A)", "*** test number 504 ***"
   call msSet(data,x,MF_COLON,[5]) ! msSet_array_section_colon_vec
   call msDisplay(x,"msSet(data,x,MF_COLON,[5]), x")

   x = reshape( [ (i+0.5, i = 1, 9) ], [ 3, 3 ] )
   call msDisplay(x,"x")
   print "(/,A)", "*** test number 505 ***"
   call msSet(MF_EMPTY,x,MF_COLON,[2]) ! msSet_array_section_colon_vec
   call msDisplay(x,"msSet(MF_EMPTY,x,MF_COLON,[2]), x")

   x = reshape( [ (i+0.5, i = 1, 25) ], [ 5, 5 ] )
   call msDisplay(x,"x")
   print "(/,A)", "*** test number 506 ***"
   call msSet(MF_EMPTY,x,MF_COLON,[1,3,5]) ! msSet_array_section_colon_vec
   call msDisplay(x,"msSet(MF_EMPTY,x,MF_COLON,[1,3,5]), x")

   x = reshape( [ (i+0.5, i = 1, 25) ], [ 5, 5 ] )
   call msDisplay(x,"x")
   print "(/,A)", "*** test number 507 ***"
   call msSet(MF_EMPTY,x,MF_COLON,[1,5,3,1,3,5]) ! msSet_array_section_colon_vec
   call msDisplay(x,"msSet(MF_EMPTY,x,MF_COLON,[1,5,3,1,3,5]), x")

   x = reshape( [ (i+0.5, i = 1, 25) ], [ 5, 5 ] )
   call msDisplay(x,"x")
   print "(/,A)", "*** test number 508 ***"
   call msSet(MF_EMPTY,x,MF_COLON,[5,2,3,1,4]) ! msSet_array_section_colon_vec
   call msDisplay(x,"msSet(MF_EMPTY,x,MF_COLON,[5,2,3,1,4]), x")

   x = reshape( [ (i+0.5, i = 1, 9) ], [ 3, 3 ] )
   data = reshape( [0,0,0], [ 1, 3 ] )
   call msDisplay(data,"data")
   print "(/,A)", "*** test number 509 ***"
   call msSet(data,x,[3],MF_COLON) ! msSet_array_section_vec_colon
   call msDisplay(x,"msSet(data,x,MF_COLON,[3]), x")

   data = reshape( [8,8,8], [ 1, 3 ] )
   call msDisplay(data,"data")
   print "(/,A)", "*** test number 510 ***"
   call msSet(data,x,[5],MF_COLON) ! msSet_array_section_vec_colon
   call msDisplay(x,"msSet(data,x,[5],MF_COLON), x")

   x = reshape( [ (i+0.5, i = 1, 9) ], [ 3, 3 ] )
   call msDisplay(x,"x")
   print "(/,A)", "*** test number 511 ***"
   call msSet(MF_EMPTY,x,[2],MF_COLON) ! msSet_array_section_vec_colon
   call msDisplay(x,"msSet(MF_EMPTY,x,[2],MF_COLON), x")

   x = reshape( [ (i+0.5, i = 1, 25) ], [ 5, 5 ] )
   call msDisplay(x,"x")
   print "(/,A)", "*** test number 512 ***"
   call msSet(MF_EMPTY,x,[1,3,5],MF_COLON) ! msSet_array_section_vec_colon
   call msDisplay(x,"msSet(MF_EMPTY,x,[1,3,5],MF_COLON), x")

   x = reshape( [ (i+0.5, i = 1, 25) ], [ 5, 5 ] )
   call msDisplay(x,"x")
   print "(/,A)", "*** test number 513 ***"
   call msSet(MF_EMPTY,x,[1,5,3,1,3,5],MF_COLON) ! msSet_array_section_vec_colon
   call msDisplay(x,"msSet(MF_EMPTY,x,[1,5,3,1,3,5],MF_COLON), x")

   x = reshape( [ (i+0.5, i = 1, 25) ], [ 5, 5 ] )
   call msDisplay(x,"x")
   print "(/,A)", "*** test number 514 ***"
   call msSet(MF_EMPTY,x,[5,2,3,1,4],MF_COLON) ! msSet_array_section_vec_colon
   call msDisplay(x,"msSet(MF_EMPTY,x,[5,2,3,1,4],MF_COLON), x")

   ! combined usage of MF_EMPTY, MF_COLON and MF_END

   x = reshape( [ (i+0.5, i = 1, 25) ], [ 5, 5 ] )
   call msDisplay(x,"x")
   print "(/,A)", "*** test number 515 ***"
   call msSet(MF_EMPTY,x,MF_COLON,MF_END) ! msSet_array_section_array_array
   call msDisplay(x,"msSet(MF_EMPTY,x,MF_COLON,MF_END), x")

   x = reshape( [ (i+0.5, i = 1, 25) ], [ 5, 5 ] )
   call msDisplay(x,"x")
   print "(/,A)", "*** test number 516 ***"
   call msSet(MF_EMPTY,x,MF_END,MF_COLON) ! msSet_array_section_array_array
   call msDisplay(x,"msSet(MF_EMPTY,x,MF_COLON,MF_END), x")

   ! usage of MF_END

   print "(/,A)", "*** test number 517 ***"
   v = mfColon(1,4)
   call msDisplay(v,"v")
   call msSet(-1.0d0,v,MF_END) ! msSet_spread_real8_in_vec_sect2
   print *, "msSet(-1.0d0,v,MF_END)"
   call msDisplay( v, "v" )
   call msSet(-2.0d0,v,MF_END-1) ! msSet_spread_real8_in_vec_sect2
   print *, "msSet(-2.0d0,v,MF_END-1)"
   call msDisplay( v, "v" )

   print "(/,A)", "*** test number 518 ***"
   v = .t. mfColon(1,4)
   call msDisplay(v,"v")
   call msSet(-1.0d0,v,MF_END) ! msSet_spread_real8_in_vec_sect2
   print *, "msSet(-1.0d0,v,MF_END)"
   call msDisplay( v, "v" )
   call msSet(-2.0d0,v,MF_END-1) ! msSet_spread_real8_in_vec_sect2
   print *, "msSet(-2.0d0,v,MF_END-1)"
   call msDisplay( v, "v" )

   print "(/,A)", "*** test number 519 ***"
   v = mfColon(1,4) * MF_I
   call msDisplay(v,"v")
   call msSet(-1.0d0,v,MF_END) ! msSet_spread_cmplx_in_vec_sect2
   print *, "msSet(-1.0d0,v,MF_END)"
   call msDisplay( v, "v" )
   call msSet(-2.0d0,v,MF_END-1) ! msSet_spread_cmplx_in_vec_sect2
   print *, "msSet(-2.0d0,v,MF_END-1)"
   call msDisplay( v, "v" )

   print "(/,A)", "*** test number 520 ***"
   v = (.t. mfColon(1,4)) * MF_I
   call msDisplay(v,"v")
   call msSet(-1.0d0,v,MF_END) ! msSet_spread_cmplx_in_vec_sect2
   print *, "msSet(-1.0d0,v,MF_END)"
   call msDisplay( v, "v" )
   call msSet(-2.0d0,v,MF_END-1) ! msSet_spread_cmplx_in_vec_sect2
   print *, "msSet(-2.0d0,v,MF_END-1)"
   call msDisplay( v, "v" )

   print "(/,A)", "*** test number 521 ***"
   v = mfColon(1,4)
   call msDisplay(v,"v")
   u = -1.0d0
   call msSet(u,v,MF_END) ! msSet_array_in_vec_sect2
   print *, "u = -1.0d0; msSet(u,v,MF_END)"
   call msDisplay( v, "v" )
   u = -2.0d0
   call msSet(u,v,MF_END-1) ! msSet_array_in_vec_sect2
   print *, "u = -2.0d0; msSet(u,v,MF_END-1)"
   call msDisplay( v, "v" )

   print "(/,A)", "*** test number 522 ***"
   v = .t. mfColon(1,4)
   call msDisplay(v,"v")
   u = -1.0d0
   call msSet(u,v,MF_END) ! msSet_array_in_vec_sect2
   print *, "u = -1.0d0; msSet(u,v,MF_END)"
   call msDisplay( v, "v" )
   u = -2.0d0
   call msSet(u,v,MF_END-1) ! msSet_array_in_vec_sect2
   print *, "u = -2.0d0; msSet(u,v,MF_END-1)"
   call msDisplay( v, "v" )

   print "(/,A)", "*** test number 523 ***"
   v = mfColon(1,6)
   call msDisplay(v,"v")
   call msSet(MF_EMPTY,v,mf([2,3,5])) ! msSet_array_in_vec_sect2
   print *, "msSet(MF_EMPTY,v,mf([2,3,5]))"
   call msDisplay( v, "v" )

   print "(/,A)", "*** test number 524 ***"
   v = .t. mfColon(1,6)
   call msDisplay(v,"v")
   call msSet(MF_EMPTY,v,mf([2,3,5])) ! msSet_array_in_vec_sect2
   print *, "msSet(MF_EMPTY,v,mf([2,3,5]))"
   call msDisplay( v, "v" )

   print "(/,A)", "*** test number 525 ***"
   x = mfOnes(3,4)
   call msDisplay( x, "x" )
   call msSet(mf(0.5d0),x,mf([2,4,6])) ! msSet_array_in_vec_sect2
   print *, "msSet(mf(0.5d0),x,mf([2,4,6]))"
   call msDisplay( x, "x" )

   print "(/,A)", "*** test number 526 ***"
   x = mfOnes(3,4)*MF_I
   call msDisplay( x, "x" )
   call msSet(mf(0.5d0),x,mf([2,4,6])) ! msSet_array_in_vec_sect2
   print *, "msSet(mf(0.5d0),x,mf([2,4,6]))"
   call msDisplay( x, "x" )

   print "(/,A)", "*** test number 527 ***"
   x = mfOnes(3,4)
   call msDisplay( x, "x" )
   call msSet(mf(0.5d0*MF_I),x,mf([2,4,6])) ! msSet_array_in_vec_sect2
   print *, "msSet(mf(0.5d0*MF_I),x,mf([2,4,6]))"
   call msDisplay( x, "x" )

   print "(/,A)", "*** test number 528 ***"
   x = mfOnes(3,4)*MF_I
   call msDisplay( x, "x" )
   call msSet(mf(0.5d0*MF_I),x,mf([2,4,6])) ! msSet_array_in_vec_sect2
   print *, "msSet(mf(0.5d0*MF_I),x,mf([2,4,6]))"
   call msDisplay( x, "x" )

   print "(/,A)", "*** test number 529 ***"
   x = mfOnes(3,4)
   call msDisplay( x, "x" )
   call msSet(0.5d0,x,mf([2,4,6])) ! msset_spread_real8_in_vec_sect2
   print *, "msSet(0.5d0,x,mf([2,4,6]))"
   call msDisplay( x, "x" )

   print "(/,A)", "*** test number 530 ***"
   x = mfOnes(3,4)*MF_I
   call msDisplay( x, "x" )
   call msSet(0.5d0,x,mf([2,4,6])) ! msset_spread_real8_in_vec_sect2
   print *, "msSet(0.5d0,x,mf([2,4,6]))"
   call msDisplay( x, "x" )

   print "(/,A)", "*** test number 531 ***"
   x = mfOnes(3,4)
   call msDisplay( x, "x" )
   call msSet(0.5d0*MF_I,x,mf([2,4,6])) ! msset_spread_cmplx_in_vec_sect2
   print *, "msSet(0.5d0*MF_I,x,mf([2,4,6]))"
   call msDisplay( x, "x" )

   print "(/,A)", "*** test number 532 ***"
   x = mfOnes(3,4)*MF_I
   call msDisplay( x, "x" )
   call msSet(0.5d0*MF_I,x,mf([2,4,6])) ! msset_spread_cmplx_in_vec_sect2
   print *, "msSet(0.5d0*MF_I,x,mf([2,4,6]))"
   call msDisplay( x, "x" )

   print "(/,A)", "*** test number 533 ***"
   x = mfOnes(3,4)
   call msDisplay( x, "x" )
   call msSet(0.5d0,x,[2,4,6]) ! msSet_spread_real8_in_vec_section
   print *, "msSet(0.5d0,x,[2,4,6])"
   call msDisplay( x, "x" )

   print "(/,A)", "*** test number 534 ***"
   x = mfOnes(3,4)*MF_I
   call msDisplay( x, "x" )
   call msSet(0.5d0,x,[2,4,6]) ! msSet_spread_real8_in_vec_section
   print *, "msSet(0.5d0,x,[2,4,6])"
   call msDisplay( x, "x" )

   print "(/,A)", "*** test number 535 ***"
   x = mfOnes(3,4)
   call msDisplay( x, "x" )
   call msSet(0.5d0*MF_I,x,[2,4,6]) ! msSet_spread_cmplx_in_vec_section
   print *, "msSet(0.5d0*MF_I,x,[2,4,6])"
   call msDisplay( x, "x" )

   print "(/,A)", "*** test number 536 ***"
   x = mfOnes(3,4)*MF_I
   call msDisplay( x, "x" )
   call msSet(0.5d0*MF_I,x,[2,4,6]) ! msSet_spread_cmplx_in_vec_section
   print *, "msSet(0.5d0*MF_I,x,[2,4,6])"
   call msDisplay( x, "x" )

   print "(/,A)", "*** test number 537 ***"
   x = mfOnes(3,4)
   call msDisplay( x, "x" )
   call msSet(mf(0.5d0),x,[2,4,6]) ! msSet_array_in_vec_section
   print *, "msSet(mf(0.5d0),x,[2,4,6])"
   call msDisplay( x, "x" )

   print "(/,A)", "*** test number 538 ***"
   x = mfOnes(3,4)*MF_I
   call msDisplay( x, "x" )
   call msSet(mf(0.5d0),x,[2,4,6]) ! msSet_array_in_vec_section
   print *, "msSet(mf(0.5d0),x,[2,4,6])"
   call msDisplay( x, "x" )

   print "(/,A)", "*** test number 539 ***"
   x = mfOnes(3,4)
   call msDisplay( x, "x" )
   call msSet(mf(0.5d0*MF_I),x,[2,4,6]) ! msSet_array_in_vec_section
   print *, "msSet(mf(0.5d0*MF_I),x,[2,4,6])"
   call msDisplay( x, "x" )

   print "(/,A)", "*** test number 540 ***"
   x = mfOnes(3,4)*MF_I
   call msDisplay( x, "x" )
   call msSet(mf(0.5d0*MF_I),x,[2,4,6]) ! msSet_array_in_vec_section
   print *, "msSet(mf(0.5d0*MF_I),x,[2,4,6])"
   call msDisplay( x, "x" )

   print "(/,A)", "*** test number 541 ***"
   x = mfOnes(3,6)
   call msDisplay( x, "x" )
   call msSet(0.5d0,x,MF_END,[2,4,6]) ! msSet_spread_real8_in_colon_vec
   print *, "msSet(0.5d0,x,MF_END,[2,3])"
   call msDisplay( x, "x" )

   print "(/,A)", "*** test number 542 ***"
   x = mfOnes(6,3)
   call msDisplay( x, "x" )
   call msSet(0.5d0,x,[2,4,6],MF_END) ! msSet_spread_real8_in_vec_colon
   print *, "msSet(0.5d0,x,[2,3],MF_END)"
   call msDisplay( x, "x" )

   print "(/,A)", "*** test number 543 ***"
   x = mfOnes(6,3)
   call msDisplay( x, "x" )
   call msSet(mf(0.5d0),x,MF_END,2) ! msSet_array_section_colon_int
   print *, "msSet(mf(0.5d0),x,MF_END,2)"
   call msDisplay( x, "x" )

   print "(/,A)", "*** test number 544 ***"
   x = mfOnes(6,3)
   call msDisplay( x, "x" )
   call msSet(mf(0.5d0),x,2,MF_END) ! msSet_array_section_int_colon
   print *, "msSet(mf(0.5d0),x,2,MF_END)"
   call msDisplay( x, "x" )

   print "(/,A)", "*** test number 545 ***"
   x = mfOnes(6,3)
   call msDisplay( x, "x" )
   call msSet(mf([0.5d0,1.5d0]),x,MF_END,[2,3]) ! msSet_array_section_colon_vec
   print *, "msSet(mf([0.5d0,1.5d0]),x,MF_END,[2,3])"
   call msDisplay( x, "x" )

   print "(/,A)", "*** test number 546 ***"
   x = mfOnes(6,3)
   call msDisplay( x, "x" )
   call msSet(.t.mf([0.5d0,1.5d0]),x,[2,3],MF_END) ! msSet_array_section_vec_colon
   print *, "msSet(.t.mf([0.5d0,1.5d0]),x,[2,3],MF_END)"
   call msDisplay( x, "x" )

   print "(/,A)", "*** test number 547 ***"
   x = mfOnes(6,3)
   call msDisplay( x, "x" )
   call msSet(mf([0.5d0,1.5d0]),x,MF_END,2.to.3) ! msSet_array_section_colon_vseq
   print *, "msSet(mf([0.5d0,1.5d0]),x,MF_END,2.to.3)"
   call msDisplay( x, "x" )

   print "(/,A)", "*** test number 548 ***"
   x = mfOnes(6,3)
   call msDisplay( x, "x" )
   call msSet(.t.mf([0.5d0,1.5d0]),x,2.to.3,MF_END) ! msSet_array_section_vseq_colon
   print *, "msSet(.t.mf([0.5d0,1.5d0]),x,2.to.3,MF_END)"
   call msDisplay( x, "x" )

   print "(/,A)", "*** test number 549 ***"
   x = mfOnes(3,6)
   call msDisplay( x, "x" )
   call msSet(mf([0.5d0,1.5d0,2.5d0]),x,MF_END,mf([1,3,5])) ! msSet_array_section_array_array
   print *, "msSet(mf([0.5d0,1.5d0]),x,MF_END,mf([1,3,5]))"
   call msDisplay( x, "x" )

   print "(/,A)", "*** test number 550 ***"
   x = mfOnes(6,3)
   call msDisplay( x, "x" )
   call msSet(.t.mf([0.5d0,1.5d0,2.5d0]),x,mf([1,3,5]),MF_END) ! msSet_array_section_array_array
   print *, "msSet(.t.mf([0.5d0,1.5d0,2.5d0]),x,mf([1,3,5]),MF_END)"
   call msDisplay( x, "x" )

   print "(/,A)", "*** test number 551 ***"
   x = MF_EMPTY
   call msDisplay( x, "x" )
   call msSet(0.5d0,x,2.to.3) ! msSet_spread_real8_in_vec_vseq
   print *, "msSet(0.5d0,x,2.to.3)"
   call msDisplay( x, "x" )

   print "(/,A)", "*** test number 552 ***"
   x = mfOnes(1,6)
   call msDisplay( x, "x" )
   call msSet(0.5d0,x,2.to.MF_END-1) ! msSet_spread_real8_in_vec_vseq
   print *, "msSet(0.5d0,x,2.to.MF_END-1)"
   call msDisplay( x, "x" )

   print "(/,A)", "*** test number 553 ***"
   x = .t. mfOnes(1,6)
   call msDisplay( x, "x" )
   call msSet(0.5d0,x,2.to.MF_END-1) ! msSet_spread_real8_in_vec_vseq
   print *, "msSet(0.5d0,x,2.to.MF_END-1)"
   call msDisplay( x, "x" )

   print "(/,A)", "*** test number 554 ***"
   x = MF_EMPTY
   call msDisplay( x, "x" )
   data = [ 1.5, 2.5, 3.5, 4.5 ]
   call msDisplay( data, "data" )
   call msSet(data,x,2.to.5) ! msSet_array_in_vec_vseq
   print *, "msSet(data,x,2.to.5)"
   call msDisplay( x, "x" )

   print "(/,A)", "*** test number 555 ***"
   x = MF_EMPTY
   call msDisplay( x, "x" )
   data = .t. [ 1.5d0, 2.5d0, 3.5d0, 4.5d0 ]
   call msDisplay( data, "data" )
   call msSet(data,x,2.to.5) ! msSet_array_in_vec_vseq
   print *, "msSet(data,x,2.to.5)"
   call msDisplay( x, "x" )

   print "(/,A)", "*** test number 556 ***"
   x = mfOnes(1,6)
   call msDisplay( x, "x" )
   data = [ 1.5, 2.5, 3.5, 4.5 ]
   call msDisplay( data, "data" )
   call msSet(data,x,2.to.MF_END-1) ! msSet_array_in_vec_vseq
   print *, "msSet(data,x,2.to.MF_END-1)"
   call msDisplay( x, "x" )

   print "(/,A)", "*** test number 557 ***"
   x = .t. mfOnes(1,6)
   call msDisplay( x, "x" )
   data = .t. mf([ 1.5, 2.5, 3.5, 4.5 ])
   call msDisplay( data, "data" )
   call msSet(data,x,2.to.MF_END-1) ! msSet_array_in_vec_vseq
   print *, "msSet(data,x,2.to.MF_END-1)"
   call msDisplay( x, "x" )

   print "(/,A)", "*** test number 558 ***"
   x = mfZeros(3,5)
   call msDisplay( x, "x" )
   call msSet(mfMagic(3),x,MF_COLON,2.to.MF_END-1) ! msSet_array_section_colon_vseq
   print *, "msSet(mfMagic(3),x,MF_COLON,2.to.MF_END-1)"
   call msDisplay( x, "x" )

   print "(/,A)", "*** test number 559 ***"
   x = mfZeros(3,5)
   call msDisplay( x, "x" )
   call msSet(mf([1,2,3]),x,MF_END,2.to.MF_END-1) ! msSet_array_section_colon_vseq
   print *, "msSet(mf([1,2,3]),x,MF_COLON,2.to.MF_END-1)"
   call msDisplay( x, "x" )

   print "(/,A)", "*** test number 560 ***"
   x = mfZeros(5,3)
   call msDisplay( x, "x" )
   call msSet(mfMagic(3),x,2.to.MF_END-1,MF_COLON) ! msSet_array_section_vseq_colon
   print *, "msSet(mfMagic(3),x,2.to.MF_END-1,MF_COLON)"
   call msDisplay( x, "x" )

   print "(/,A)", "*** test number 561 ***"
   x = mfZeros(5,3)
   call msDisplay( x, "x" )
   call msSet(.t.mf([1,2,3]),x,2.to.MF_END-1,MF_END) ! msSet_array_section_colon_vseq
   print *, "msSet(.t.mf([1,2,3]),x,2.to.MF_END-1,MF_END)"
   call msDisplay( x, "x" )

   print "(/,A)", "*** test number 562 ***"
   x = mfZeros(5,5)
   call msDisplay( x, "x" )
   call msSet(mfMagic(3),x,2.to.MF_END-1,2.to.MF_END-1) ! msSet_arr_sect_vseq_vseq
   print *, "msSet(mfMagic(3),x,2.to.MF_END-1,2.to.MF_END-1)"
   call msDisplay( x, "x" )

   print "(/,A)", "*** test number 563 ***"
   x = mfZeros(5,5)
   call msDisplay( x, "x" )
   call msSet(0.5d0,x,2.to.MF_END-1,2.to.MF_END-1) ! msSet_sprd_r8_vseq_vseq
   print *, "msSet(0.5d0,x,2.to.MF_END-1,2.to.MF_END-1)"
   call msDisplay( x, "x" )

   print "(/,A)", "*** test number 564 ***"
   x = mfZeros(3,5)
   call msDisplay( x, "x" )
   call msSet(0.5d0,x,2,2.to.MF_END-1) ! msSet_sprd_r8_int_vseq
   print *, "msSet(0.5d0,x,2,2.to.MF_END-1)"
   call msDisplay( x, "x" )

   print "(/,A)", "*** test number 565 ***"
   x = mfZeros(5,3)
   call msDisplay( x, "x" )
   call msSet(0.5d0,x,2.to.MF_END-1,2) ! msSet_sprd_r8_vseq_int
   print *, "msSet(0.5d0,x,2.to.MF_END-1,2)"
   call msDisplay( x, "x" )

   ! special tests for .and. and .but. operators

   print "(/,A)", "*** test number 566 ***"
   v = mfZeros(1,9)
   call msDisplay(v,"v")
   call msSet( 1.0d0, v, (MF_END.to.7.by.-1) .and. (1.to.4) )
   print *, "msSet( 1.0d0, v, (MF_END.to.7.by.-1) .and. (1.to.4) )"
   call msDisplay( v, "v" )

   print "(/,A)", "*** test number 567 ***"
   v = mfZeros(1,9)
   call msDisplay(v,"v")
   call msSet( 1.0d0, v, (6.to.MF_END) .and. (1.to.3) )
   print *, "msSet( 1.0d0, v, (6.to.MF_END) .and. (1.to.3) )"
   call msDisplay( v, "v" )

   print "(/,A)", "*** test number 568 ***"
   v = mfZeros(1,9)
   call msDisplay(v,"v")
   call msSet( 1.0d0, v, (1.to.3) .and. (MF_END-3.to.MF_END) )
   print *, "msSet( 1.0d0, v, (1.to.3) .and. (MF_END-3.to.MF_END) )"
   call msDisplay( v, "v" )

   print "(/,A)", "*** test number 569 ***"
   v = mfZeros(1,9)
   call msDisplay(v,"v")
   call msSet( 1.0d0, v, (1.to.9.by.2) .but. 5 )
   print *, "msSet( 1.0d0, v, (1.to.9.by.2) .but. 5 )"
   call msDisplay( v, "v" )

   print "(/,A)", "*** test number 570 ***"
   v = mfZeros(1,9)
   call msDisplay(v,"v")
   call msSet( 1.0d0, v, (1.to.MF_END.by. 2) .but. 5 )
   print *, "msSet( 1.0d0, v, (1.to.MF_END.by. 2) .but. 5 )"
   call msDisplay( v, "v" )

   print "(/,A)", "*** test number 571 ***"
   v = mfZeros(1,9)
   call msDisplay(v,"v")
   call msSet( 1.0d0, v, (1.to.MF_END.by. 2) .but. 4 )
   print *, "msSet( 1.0d0, v, (1.to.MF_END.by. 2) .but. 4 )"
   call msDisplay( v, "v" )

   print "(/,A)", "*** test number 572 ***"
   v = mfZeros(1,9)
   call msDisplay(v,"v")
   call msSet( 1.0d0, v, (4.to.MF_END) .but. MF_END-1 )
   print *, "msSet( 1.0d0, v, (4.to.MF_END) .but. MF_END-1 )"
   call msDisplay( v, "v" )

   print "(/,A)", "*** test number 573 ***"
   v = mfZeros(1,9)
   call msDisplay(v,"v")
   call msSet( 1.0d0, v, MF_ALL .but. 2 )
   print *, "msSet( 1.0d0, v, MF_ALL .but. 2 )"
   call msDisplay( v, "v" )

   print "(/,A)", "*** test number 574 ***"
   v = mfZeros(1,9)
   call msDisplay(v,"v")
   call msSet( 1.0d0, v, MF_ALL .but. MF_END-1 )
   print *, "msSet( 1.0d0, v, MF_ALL .but. MF_END-1 )"
   call msDisplay( v, "v" )

   ! msSetAutoFilling, mfGetAutoFilling --------------------------------
   call print_separation("msSetAutoFilling, mfGetAutoFilling")

   print "(/,A)", "*** test number 575 ***"
   print "(/,2X,A)", "Default value used for filling out-of-range elements by msSet: "
   print "(A,G0.5)", "    r = ", mfGetAutoFilling()

   print "(/,A)", "*** test number 576 ***"
   call msSetAutoFilling( 0.0d0 )
   print "(/,2X,A)", "After setting it to zero:"
   print "(A,G0.5)", "    r = ", mfGetAutoFilling()

   print "(/,A)", "*** test number 577 ***"
   print "(/,2X,A)", "Return back to the default value: "
   call msSetAutoFilling( MF_NAN )
   print "(A,G0.5)", "    r = ", mfGetAutoFilling()
   print *

   ! msInitArgs, msFreeArgs --------------------------------------------
   call print_separation("msInitArgs, msFreeArgs")

   print "(/,A)", "*** test number 578 ***"
   call msDisplay(mfSin(mfSin(mfSin(mf(1)))),                           &
                 "mfSin(mfSin(mfSin(mf(1))))")

   x = mf(reshape( [(i, i = 1, 9)], [ 3, 3 ] ))
   call msDisplay(x, "x")
   print "(/,A)", "*** test number 579 ***"
   call sym_decmp( mfOut(u,v), mf(reshape( [(i, i = 1, 9)], [ 3, 3 ] )) )
   call msDisplay(u,"sym. part of (x)")
   call msDisplay(v,"antisym. part of (x)")

   ! mfIsEqual ---------------------------------------------------------
   call print_separation("mfIsEqual")

   x = 0.
   y = 1.
   call msDisplay(x, "x")
   call msDisplay(y, "y")
   print "(/,A)", "*** test number 580 ***"
   if( mfIsEqual(x,y) ) then
      write (*,*) "x and y are equal"
   else
      write (*,*) "x and y are not equal"
   end if

   print "()"

   ! mfIsEmpty ---------------------------------------------------------
   call print_separation("mfIsEmpty")

   x = 0.
   call msDisplay(x, "x")
   print "(/,A)", "*** test number 581 ***"
   if( mfIsEmpty(x) ) then
      write (*,*) "x is empty"
   else
      write (*,*) "x is not empty"
   end if

   call msRelease(x)
   call msDisplay(x, "x")
   print "(/,A)", "*** test number 582 ***"
   if( mfIsEmpty(x) ) then
      write (*,*) "x is empty"
   else
      write (*,*) "x is not empty"
   end if

   print "()"

   ! mfShape and Shape -------------------------------------------------
   call print_separation("mfShape and Shape")

   x = mfZeros(3,5)
   call msDisplay(x, "x")
   print "(/,A)", "*** test number 583 ***"
   call msDisplay( mfShape(x), "mfShape(x)" )

   print "(/,A)", "*** test number 584 ***"
   call msDisplay( Shape(x), "Shape(x)" )

   ! mfSize and Size ---------------------------------------------------
   call print_separation("mfSize and Size")

   x = mfZeros(3,5)
   call msDisplay(x, "x")
   print "(/,A)", "*** test number 585 ***"
   call msDisplay( mfSize(x), "mfSize(x)" )
   call msDisplay( mfSize(x,1), "mfSize(x,1)" )

   print "(/,A)", "*** test number 586 ***"
   call msDisplay( Size(x), "Size(x)" )
   call msDisplay( Size(x,2), "Size(x,2)" )

   ! mfCount -----------------------------------------------------------
   call print_separation("mfCount")

   v = [ 1, 2, 3, 4, 5, 6 ]
   call msDisplay(v, "v")

   print "(/,A)", "*** test number 587 ***"
   call msDisplay( mfCount(v>3.0d0), "mfCount(v>3.0d0)" )

   x = mfMagic(3)
   call msDisplay(x, "x")

   print "(/,A)", "*** test number 588 ***"
   call msDisplay( mfCount(x>5.0d0), "mfCount(x>5.0d0)" )
   print "(/,A)", "*** test number 589 ***"
   call msDisplay( mfCount(x>4.0d0,2), "mfCount(x>4.0d0,2)" )

   ! sparse boolean mfArray

   x = mf([ 0, 0, 2, 1, 1, 0 ]) .vc.                                    &
       mf([ 0, 0, 1, 0, 0, 2 ]) .vc.                                    &
       mf([ 0, 3, 0, 0, 4, 1 ]) .vc.                                    &
       mf([ 0, 0, 4, 0, 2, 0 ])
   call msDisplay( x, "x (dense)" )
   x = mfSparse( x )

   call msDisplay( x, "x (sparse)" )

   print "(/,A)", "*** test number 590 ***"
   call msDisplay( mfCount(x>2.0d0), "mfCount(x>2.0d0)" )

   print "(/,A)", "*** test number 591 ***"
   call msDisplay( mfCount(x<=1.0d0), "mfCount(x<=1.0d0)" )

#if !defined(_WINDOWS) && !defined(_DARWIN)
   ! msSetRoundingMode, mfGetRoundingMode ------------------------------
   call print_separation("msSetRoundingMode, mfGetRoundingMode")

   r1 = 0.1d0
   r2 = 10.d0
   print "()"
   print "(A,F5.1)", " r1 = ", r1
   print "(A,F5.1)", " r2 = ", r2

   ! saving current rounding mode
   rounding_mode = mfGetRoundingMode()

   ! by default, rounding_mode should be equal to "nearest"
   print "(/,A)", "*** test number 592 ***"
   print "()"
   print *, "floating-point rounding mode: '",                          &
            mfGetRoundingMode(), "'"
   print "(A,ES23.16)", " r1*r2 = ", r1*r2

   print "(/,A)", "*** test number 593 ***"
   call msSetRoundingMode('down')
   print "()"
   print *, "floating-point rounding mode: '",                          &
            mfGetRoundingMode(), "'"
   print "(A,ES23.16)", " r1*r2 = ", r1*r2

   print "(/,A)", "*** test number 594 ***"
   call msSetRoundingMode('up')
   print "()"
   print *, "floating-point rounding mode: '",                          &
            mfGetRoundingMode(), "'"
   print "(A,ES23.16)", " r1*r2 = ", r1*r2

   ! restore rounding mode
   call msSetRoundingMode(rounding_mode)
   print "()"
   print *, "floating-point rounding mode reset to: '",                 &
            mfGetRoundingMode(), "'"

   print "()"
#endif

   ! mfIsVersion -------------------------------------------------------
   call print_separation("mfIsVersion")

   print "()"
   print "(/,A)", "*** test number 595 ***"
   if( mfIsVersion( MF_MUESLI_VERSION, '==', MF_MUESLI_VERSION ) ) then
      print *, "mfIsVersion( MF_MUESLI_VERSION, '==', MF_MUESLI_VERSION ) is true: ok"
   else
      print *, "mfIsVersion( MF_MUESLI_VERSION, '==', MF_MUESLI_VERSION ) is false: failed ! <----- ?????"
      call msPause()
   end if

   print "()"
   print "(/,A)", "*** test number 596 ***"
   print *, "mfIsVersion( MF_MUESLI_VERSION, '>=', '1.8.1' ) : ",       &
             mfIsVersion( MF_MUESLI_VERSION, '>=', '1.8.1' )

   print "()"
   print "(/,A)", "*** test number 597 ***"
   print *, "mfIsVersion( MF_MUESLI_VERSION, '<=', '9.0.0' ) : ",       &
             mfIsVersion( MF_MUESLI_VERSION, '<=', '9.0.0' )
   print "()"

   ! End of tests ------------------------------------------------------
   print "(A)", "                         ┏━━━━━━━━━━━━━━━━━━━━━━┓"
   print "(A)", "                         ┃ End of test_mod_core ┃"
   print "(A)", "                         ┗━━━━━━━━━━━━━━━━━━━━━━┛"

   !--------------------------------------------------------------------
99 continue

   print "()"
   call msSetMsgLevel(2)

   call msRelease( x, y, data, u, v )
   if( allocated( r2_mat ) ) then
      deallocate( r2_mat )
   end if

   ! non official Muesli routine: introduced here to clean memory
   call RngStream_end()

end program
