program test_muesli_config_fml

   use fml

   implicit none

   type(mfArray) :: A

   character(len=128) :: BLAS_LIB, LAPACK_LIB

   !--------------------------------------------------------------------

   ! Warning level = 2 : all messages are printed (verbose mode) [default]
   !                 1 : only important messages are printed
   !                 0 : nothing is printed (quiet mode)
   !
   call msSetMsgLevel(1)

   ! the two following tests ('msGetBlasLib' and 'msGetLapackLib') must
   ! be kept here, because they need 'make install' to be applied.

   call msGetBlasLib( BLAS_LIB )
   print "()"
   print *, "BLAS implementation   = '", trim(BLAS_LIB), "'"

   call msGetLapackLib( LAPACK_LIB )
   print "()"
   print *, "LAPACK implementation = '", trim(LAPACK_LIB), "'"

   print "()"
   print *, "MF_LAPACK_VERSION = '", trim(MF_LAPACK_VERSION()), "'"

   !--------------------------------------------------------------------

   A = mfEye(3,3) * 2.0d0

   call msDisplay(A,"A")

   call msDisplay(mfDet(A),"Det(A)")

   call msDisplay(mfNorm(A),"Norm(A)")

   call msDisplay(mfCond(A),"Cond(A)")

   !--------------------------------------------------------------------

   call msRelease(A)

end program
