module test_aux

   use fml
   use fgl

   implicit none

   integer :: message_level

   logical :: X11_OFF

contains
!_______________________________________________________________________
!
   subroutine run_options( )

      character :: value
      logical :: MFPLOT_X11_DEVICE, TEST_FPE_ON

      call getenv( "MFPLOT_X11_DEVICE", value )
      ! By default, X11 is ON
      ! (X11 is OFF only if MFPLOT_X11_DEVICE is set and equal to 0)
      MFPLOT_X11_DEVICE = .not. value == "0"
      print "(/,1X,A,L)", "MFPLOT_X11_DEVICE = ", MFPLOT_X11_DEVICE
      if( MFPLOT_X11_DEVICE ) then
         X11_OFF = .false.
      else
         X11_OFF = .true.
      end if

      call getenv( "TEST_FPE_ON", value )
      ! By default, TEST_FPE is OFF
      TEST_FPE_ON = value == "1"
      print "(/,1X,A,L)", "TEST_FPE_ON = ", TEST_FPE_ON
      if( TEST_FPE_ON ) then
         call msEnableFPE( "usual_exceptions" )
         print "(1X,A)", "FPE enabled"
      end if

      print *

      ! Message Level setting
      message_level = 2
      call msSetMsgLevel( message_level )

      select case( message_level )
         case( 1 )
            print *, "Only ERRORS are displayed, not Warnings or infos."
         case( 2 )
            print *, "ERRORS and Warnings are displayed, not infos."
         case( 3 )
            print *, "ERRORS, Warnings and infos are displayed."
      end select

      print *
      print *, "==================================================================="

   end subroutine run_options
!_______________________________________________________________________
!
end module test_aux
