program pcolor_ij_flat

   ! test de PcolorCoreVec* (indices seuls)
   !
   ! shading flat

   use fml
   use fgl

   implicit none

   integer, parameter :: nx = 101, ny = 123,                            &
                         grid_step(2) = [ 4, 5 ]

!!integer, parameter :: nx = 15, ny = 17,                            &
!!                      grid_step(2) = [ 1, 1 ]

   type(mfArray) :: x, y, z, r2

!!call msSetX11Device( "off" )
   call msSetMsgLevel( 2 ) ! only severe warnings are displayed

   !----------------------------------

   call msFigure(1)
   call msCharInPixels( "on" )

   call msMeshGrid( mfOut(x,y), mfLinSpace(-1.0d0, 1.0d0, nx),          &
                            .t. mfLinSpace(1.0d0, -1.0d0, ny) )
   r2 = x**2 + y**2
   z = x + y + 2.5d0*mfExp( -4.0d0*r2 )

!!call msDisplay( x, "x", y, "y", z, "z" )

   call msColormapSize( 64 )
   call msColormap( "parula" )

   call msPcolor( z, view="ji", grid=.true.,                            &
                  grid_col_rgb=[0.35d0,0.35d0,0.35d0], grid_step=grid_step )

   call msColorbar( "on" )

   call msXLabel( "col index" )
   call msYLabel( "row index" )
   call msTitle( "Top view of Z values" )

   call msPrint( "pcolor_ji_flat.eps" )
   call msPrint( "pcolor_ji_flat.pdf" )

   !----------------------------------

   call msFigure(2)
   call msCharInPixels( "on" )

   call msColormapSize( 64 )
   call msColormap( "parula" )

   call msPcolor( z, view="iZ", grid=.true.,                            &
                  grid_col_rgb=[0.35d0,0.35d0,0.35d0], grid_step=grid_step )

   call msXLabel( "row index" )
   call msYLabel( "Z" )
   call msTitle( "Projection onto the (i,Z) plane (forward view)" )
   call msColorbar( "on" )

   call msPrint( "pcolor_iZ_flat.eps" )
   call msPrint( "pcolor_iZ_flat.pdf" )

   !----------------------------------

   call msFigure(3)
   call msCharInPixels( "on" )

   call msColormapSize( 64 )
   call msColormap( "parula" )

   call msPcolor( z, view="iZb", grid=.true.,                           &
                  grid_col_rgb=[0.35d0,0.35d0,0.35d0], grid_step=grid_step )

   call msXLabel( "row index" )
   call msYLabel( "Z" )
   call msTitle( "Projection onto the (i,Z) plane (backward view)" )
   call msColorbar( "on" )

   call msPrint( "pcolor_iZb_flat.eps" )
   call msPrint( "pcolor_iZb_flat.pdf" )

   !----------------------------------

   call msFigure(4)
   call msCharInPixels( "on" )

   call msColormapSize( 64 )
   call msColormap( "parula" )

   call msPcolor( z, view="jZ", grid=.true.,                            &
                  grid_col_rgb=[0.35d0,0.35d0,0.35d0], grid_step=grid_step )

   call msXLabel( "col index" )
   call msYLabel( "Z" )
   call msTitle( "Projection onto the (j,Z) plane (forward view)" )
   call msColorbar( "on" )

   call msPrint( "pcolor_jZ_flat.eps" )
   call msPrint( "pcolor_jZ_flat.pdf" )

   !----------------------------------

   call msFigure(5)
   call msCharInPixels( "on" )

   call msColormapSize( 64 )
   call msColormap( "parula" )

   call msPcolor( z, view="jZb", grid=.true.,                           &
                  grid_col_rgb=[0.35d0,0.35d0,0.35d0], grid_step=grid_step )

   call msXLabel( "col index" )
   call msYLabel( "Z" )
   call msTitle( "Projection onto the (j,Z) plane (backward view)" )
   call msColorbar( "on" )

   call msPrint( "pcolor_jZb_flat.eps" )
   call msPrint( "pcolor_jZb_flat.pdf" )

!_______________________________________________________________________
!
99 continue

   ! waits for a user answer (avoids that all graphic windows disappear)
   ! then, cleans internal memory
   call msExitFgl()

   call msRelease( x, y, z, r2 )

end program
