program pcolor_XY_flat_light

   ! test de PcolorCoreVec* (coords x et y : vecteurs)
   !
   ! shading flat

   use fml
   use fgl

   implicit none

   integer, parameter :: nx = 101, ny = 123,                            &
                         grid_step(2) = [ 4, 5 ]

   type(mfArray) :: x, y, z, r2

!!call msSetX11Device( "off" )
   call msSetMsgLevel( 2 ) ! only severe warnings are displayed

   !----------------------------------

   call msFigure(1)
   call msCharInPixels( "on" )

   call msMeshGrid( mfOut(x,y), mfLinSpace(-1.0d0, 1.0d0, nx),          &
                            .t. mfLinSpace(1.0d0, -1.0d0, ny) )
   r2 = x**2 + y**2
   z = x + y + 2.5d0*mfExp( -4.0d0*r2 )

   x = mfGet( x, 1, MF_ALL )
   y = mfGet( y, MF_ALL, 1 )
!!call msDisplay( x, "x", y, "y", z, "z" )

   call msColormapSize( 64 )
   call msColormap( "parula" )
   call msAxis( "equal" )

   call msPcolor( x, y, z, view="XY", grid=.true.,                      &
                  grid_col_rgb=[0.35d0,0.35d0,0.35d0], grid_step=grid_step )

   call msColorbar( "on" )

   call msXLabel( "X" )
   call msYLabel( "Y" )
   call msTitle( "Top view of Z values" )

   call msPrint( "pcolor_XY_flat_light.eps" )
   call msPrint( "pcolor_XY_flat_light.pdf" )

   !----------------------------------

   call msFigure(2)
   call msCharInPixels( "on" )

   call msAxis( [ 1.025d0, -1.025d0, -2.05d0, 2.60d0 ] )

   call msColormapSize( 64 )
   call msColormap( "grey" )

   ! natural lighting: colors are not related to the z value, but on the
   !                   orientation of the normal
   call msPcolor( x, y, z, view="YZ", lighting=.true. )

   call msXLabel( "Y" )
   call msYLabel( "Z" )
   call msTitle( "Projection onto the (Y,Z) plane (forward view)" )

   call msPrint( "pcolor_YZ_flat_light.eps" )
   call msPrint( "pcolor_YZ_flat_light.pdf" )

   !----------------------------------

   call msFigure(3)
   call msCharInPixels( "on" )

   call msAxis( [ -1.025d0, 1.025d0, -2.05d0, 2.60d0 ] )

   call msColormapSize( 64 )
   call msColormap( "grey" )

   ! natural lighting: colors are not related to the z value, but on the
   !                   orientation of the normal
   call msPcolor( x, y, z, view="YZb", lighting=.true. )

   call msXLabel( "Y" )
   call msYLabel( "Z" )
   call msTitle( "Projection onto the (Y,Z) plane (backward view)" )

   call msPrint( "pcolor_YZb_flat_light.eps" )
   call msPrint( "pcolor_YZb_flat_light.pdf" )

   !----------------------------------

   call msFigure(4)
   call msCharInPixels( "on" )

   call msAxis( [ -1.025d0, 1.025d0, -2.05d0, 2.60d0 ] )

   call msColormapSize( 64 )
   call msColormap( "grey" )

   ! natural lighting: colors are not related to the z value, but on the
   !                   orientation of the normal
   call msPcolor( x, y, z, view="XZ", lighting=.true. )

   call msXLabel( "X" )
   call msYLabel( "Z" )
   call msTitle( "Projection onto the (X,Z) plane (forward view)" )

   call msPrint( "pcolor_XZ_flat_light.eps" )
   call msPrint( "pcolor_XZ_flat_light.pdf" )

   !----------------------------------

   call msFigure(5)
   call msCharInPixels( "on" )

   call msAxis( [ 1.025d0, -1.025d0, -2.05d0, 2.60d0 ] )

   call msColormapSize( 64 )
   call msColormap( "grey" )

   ! natural lighting: colors are not related to the z value, but on the
   !                   orientation of the normal
   call msPcolor( x, y, z, view="XZb", lighting=.true. )

   call msXLabel( "X" )
   call msYLabel( "Z" )
   call msTitle( "Projection onto the (X,Z) plane (backward view)" )

   call msPrint( "pcolor_XZb_flat_light.eps" )
   call msPrint( "pcolor_XZb_flat_light.pdf" )

!_______________________________________________________________________
!
99 continue

   ! waits for a user answer (avoids that all graphic windows disappear)
   ! then, cleans internal memory
   call msExitFgl()

   call msRelease( x, y, z, r2 )

end program
