program Symbol_test

   use fml
   use fgl

   use test_aux

   implicit none

   type(mfArray) :: x, y
   integer :: i
   character(len=1) :: ans
   logical :: skip

!_______________________________________________________________________
!

   call run_options()

   print *, "zooming in some figures:"
   write(*,"(a)",advance="no") "  --------> skip interactive part ? [Y]/N "
   read "(a)", ans
   if( ans == "n" .or. ans == "N" ) then
      skip = .false.
   else
      skip = .true.
   end if

!------------------------------

   call msFigure(1)

   call msAxis( "equal" )
   call msAxis( [ -0.1d0, 1.1d0, -0.1d0, 1.1d0] )

   x = [ 0.00, 0.20, 0.40, 0.60, 0.80, 1.00 ]
   y = [ 0.95, 0.98, 1.00, 1.00, 0.98, 0.95 ]

   call msPlot( x, y, linespec=".r", markersize=2.50d0 )

   call msHold( "on" )
   call msPlot( x, y-0.125d0, linespec="+", markersize=2.50d0 )

   call msPlot( x, y-0.250d0, linespec="*", markersize=2.50d0 )

   call msPlot( x, y-0.375d0, linespec="o", markersize=2.50d0 )

   call msPlot( x, y-0.500d0, linespec="x", markersize=2.50d0 )

   call msPlot( x, y-0.625d0, linespec="s", markersize=2.50d0 )

   call msPlot( x, y-0.750d0, linespec="^", markersize=2.50d0 )

   call msPlot( x, y-0.875d0, linespec="d", markersize=2.50d0 )

   !!call msPause("you can now resize the window ...")
   !!call msRedrawFigure( win_resized=.true. )

   print *, "printing ..."
   call msPrint( "Symbol_1.eps" )
   call msPrint( "Symbol_1.pdf" )

!------------------------------

   call msFigure(2)

   call msCharInPixels( "on" )

   call msAxis( [ -0.05d0, 1.05d0, -0.05d0, 1.05d0] )
   call msAxis( "equal" )

   x = 0.25d0 + 0.1d0*mfRandN(1,20)
   y = 0.25d0 + 0.1d0*mfRandN(1,20)
   call msPlot( x, y, "k\M05", markersize=1.5d0 ) ! Hash

   call msHold( "on" )

   x = 0.50d0 + 0.1d0*mfRandN(1,20)
   y = 0.25d0 + 0.1d0*mfRandN(1,20)
   call msPlot( x, y, "k\M09", markersize=1.5d0 ) ! Five-pointed star

   x = 0.75d0 + 0.1d0*mfRandN(1,20)
   y = 0.25d0 + 0.1d0*mfRandN(1,20)
   call msPlot( x, y, "k\M10", markersize=1.5d0 ) ! Triangle Up

   x = 0.25d0 + 0.1d0*mfRandN(1,20)
   y = 0.50d0 + 0.1d0*mfRandN(1,20)
   call msPlot( x, y, "k\M11", markersize=1.5d0 ) ! Triangle Down

   x = 0.50d0 + 0.1d0*mfRandN(1,20)
   y = 0.50d0 + 0.1d0*mfRandN(1,20)
   call msPlot( x, y, "k\M12", markersize=1.5d0 ) ! Triangle Left

   x = 0.75d0 + 0.1d0*mfRandN(1,20)
   y = 0.50d0 + 0.1d0*mfRandN(1,20)
   call msPlot( x, y, "k\M13", markersize=1.5d0 ) ! Triangle Right

   ! Filled markers

   x = 0.25d0 + 0.1d0*mfRandN(1,20)
   y = 0.75d0 + 0.1d0*mfRandN(1,20)
   call msPlot( x, y, "k\M14", markersize=1.5d0 ) ! Circle filled

   x = 0.50d0 + 0.1d0*mfRandN(1,20)
   y = 0.75d0 + 0.1d0*mfRandN(1,20)
   call msPlot( x, y, "k\M15", markersize=1.5d0 ) ! Square filled

   x = 0.75d0 + 0.1d0*mfRandN(1,20)
   y = 0.75d0 + 0.1d0*mfRandN(1,20)
   call msPlot( x, y, "k\M17", markersize=1.5d0 ) ! Five-pointed star filled

   x = 0.50d0 + 0.25d0*mfRandN(1,20)
   y = 0.50d0 + 0.25d0*mfRandN(1,20)
   call msPlot( x, y, "k\M18", markersize=1.5d0 ) ! Triangle Up filled

   print *, "printing ..."
   call msPrint( "Symbol_2.eps" )
   call msPrint( "Symbol_2.pdf" )

!------------------------------
   call msFigure(3)

   call msCharInPixels( "on" )

   call msAxis( [ -0.05d0, 1.05d0, -0.05d0, 1.05d0] )
   call msAxis( "equal" )

   ! Filled markers only, with a white border

   x = 0.25d0 + 0.1d0*mfRandN(1,30)
   y = 0.25d0 + 0.1d0*mfRandN(1,30)
   call msPlot( x, y, "k\M15", markersize=1.5d0 ) ! Square filled

   call msHold( "on" )

   x = 0.50d0 + 0.1d0*mfRandN(1,30)
   y = 0.25d0 + 0.1d0*mfRandN(1,30)
   call msPlot( x, y, "k\M16", markersize=1.5d0 ) ! Five-pointed star filled

   x = 0.75d0 + 0.1d0*mfRandN(1,30)
   y = 0.25d0 + 0.1d0*mfRandN(1,30)
   call msPlot( x, y, "k\M18", markersize=1.5d0 ) ! Triangle Up filled

   x = 0.25d0 + 0.1d0*mfRandN(1,30)
   y = 0.75d0 + 0.1d0*mfRandN(1,30)
   call msPlot( x, y, "k\M19", markersize=1.5d0 ) ! Triangle Down filled

   x = 0.50d0 + 0.1d0*mfRandN(1,30)
   y = 0.75d0 + 0.1d0*mfRandN(1,30)
   call msPlot( x, y, "k\M20", markersize=1.5d0 ) ! Triangle Left filled

   x = 0.75d0 + 0.1d0*mfRandN(1,30)
   y = 0.75d0 + 0.1d0*mfRandN(1,30)
   call msPlot( x, y, "k\M21", markersize=1.5d0 ) ! Triangle Right filled



   x = 0.50d0 + 0.25d0*mfRandN(1,90)
   y = 0.50d0 + 0.25d0*mfRandN(1,90)
   call msPlot( x, y, "k\M14", markersize=1.5d0 ) ! Circle filled

   x = 0.50d0 + 0.25d0*mfRandN(1,90)
   y = 0.50d0 + 0.25d0*mfRandN(1,90)
   call msPlot( x, y, "k\M17", markersize=1.5d0 ) ! Five-pointed star filled

   print *, "printing ..."
   call msPrint( "Symbol_3.eps" )
   call msPrint( "Symbol_3.pdf" )

!------------------------------
   call msFigure(4)

   call msCharInPixels( "on" )

   call msAxis( [ -0.05d0, 1.05d0, -0.05d0, 1.05d0] )
   call msAxis( "equal" )

   ! Filled markers only, with a white border

   x = 0.25d0 + 0.1d0*mfRandN(1,30)
   y = 0.25d0 + 0.1d0*mfRandN(1,30)
   call msPlot( x, y, "k\M-15", markersize=1.5d0 ) ! Square filled

   call msHold( "on" )

   x = 0.50d0 + 0.1d0*mfRandN(1,30)
   y = 0.25d0 + 0.1d0*mfRandN(1,30)
   call msPlot( x, y, "k\M-16", markersize=1.5d0 ) ! Five-pointed star filled

   x = 0.75d0 + 0.1d0*mfRandN(1,30)
   y = 0.25d0 + 0.1d0*mfRandN(1,30)
   call msPlot( x, y, "k\M-18", markersize=1.5d0 ) ! Triangle Up filled

   x = 0.25d0 + 0.1d0*mfRandN(1,30)
   y = 0.75d0 + 0.1d0*mfRandN(1,30)
   call msPlot( x, y, "k\M-19", markersize=1.5d0 ) ! Triangle Down filled

   x = 0.50d0 + 0.1d0*mfRandN(1,30)
   y = 0.75d0 + 0.1d0*mfRandN(1,30)
   call msPlot( x, y, "k\M-20", markersize=1.5d0 ) ! Triangle Left filled

   x = 0.75d0 + 0.1d0*mfRandN(1,30)
   y = 0.75d0 + 0.1d0*mfRandN(1,30)
   call msPlot( x, y, "k\M-21", markersize=1.5d0 ) ! Triangle Right filled

   x = 0.50d0 + 0.25d0*mfRandN(1,90)
   y = 0.50d0 + 0.25d0*mfRandN(1,90)
   call msPlot( x, y, "k\M-14", markersize=1.5d0 ) ! Circle filled

   x = 0.50d0 + 0.25d0*mfRandN(1,90)
   y = 0.50d0 + 0.25d0*mfRandN(1,90)
   call msPlot( x, y, "k\M-17", markersize=1.5d0 ) ! Five-pointed star filled

#ifndef _NO_X11
   if( .not. skip ) then
      call msPanAndZoom()
   end if
#endif

   print *, "printing ..."
   call msPrint( "Symbol_4.eps" )
   call msPrint( "Symbol_4.pdf" )

!------------------------------
   call msFigure(5)

   call msCharInPixels( "on" )

   call msAxis( [ -0.1d0, 1.1d0, -0.1d0, 1.1d0] )
   call msAxis( "equal" )

   x = [ 0.00, 0.20, 0.40, 0.60, 0.80, 1.00 ]
   y = [ 0.95, 0.98, 1.00, 1.00, 0.98, 0.95 ]

   call msPlot( x, y, linespec="\Circle", markersize=1.50d0 )

   call msHold( "on" )
   call msPlot( x, y-0.125d0, linespec="\CircleFilled", markersize=1.50d0 )

   call msPlot( x, y-0.250d0, linespec="\Square", markersize=1.50d0 )

   call msPlot( x, y-0.375d0, linespec="\SquareFilled", markersize=1.50d0 )

   call msPlot( x, y-0.500d0, linespec="\Diamond", markersize=1.50d0 )

   call msPlot( x, y-0.625d0, linespec="\DiamondFilled", markersize=1.50d0 )

   call msPlot( x, y-0.750d0, linespec="\Star", markersize=1.50d0 )

   call msPlot( x, y-0.875d0, linespec="\StarFilled", markersize=1.50d0 )

   call msPlot( x, y-1.000d0, linespec="\TriangleUp", markersize=1.50d0 )

#ifndef _NO_X11
   if( .not. skip ) then
      call msPanAndZoom()
   end if
#endif

   print *, "printing ..."
   call msPrint( "Symbol_5.eps" )
   call msPrint( "Symbol_5.pdf" )

!------------------------------
   call msFigure(6)

   call msCharInPixels( "on" )

   call msAxis( [ -0.1d0, 1.1d0, -0.1d0, 1.1d0] )
   call msAxis( "equal" )

   x = [ 0.00, 0.20, 0.40, 0.60, 0.80, 1.00 ]
   y = [ 0.95, 0.98, 1.00, 1.00, 0.98, 0.95 ]

   call msPlot( x, y, linespec="\HeavyFourBalloon", markersize=2.50d0 )

   call msHold( "on" )
   call msPlot( x, y-0.125d0, linespec="\HeavyTearDrop", markersize=2.50d0 )

   call msPlot( x, y-0.250d0, linespec="\WhiteFlorette", markersize=2.50d0 )

   call msPlot( x, y-0.375d0, linespec="\Snowflake", markersize=2.50d0 )

   call msPlot( x, y-0.500d0, linespec="\BlackDiamondMinusWhiteX", markersize=2.50d0 )

#ifndef _NO_X11
   if( .not. skip ) then
      call msPanAndZoom()
   end if
#endif

   print *, "printing ..."
   call msPrint( "Symbol_6.eps" )
   call msPrint( "Symbol_6.pdf" )

!_______________________________________________________________________
!
99 continue

   ! Waits for a user answer (avoids that all graphic windows disappear)
   ! then, cleans internal memory
   call msExitFgl()

   call msRelease( x, y )

end program
