program Streamline_test

   use fml
   use fgl

   use test_aux

   implicit none

   ! nodes coordinates and velocity components
   type(mfArray) :: x, y, ux, uy

   type(mfArray) :: start, tmp, x_mat, y_mat

   integer :: k, N

!_______________________________________________________________________
!

   call run_options()

   !----------------------------------------------
   call msFigure(1)
   call msAxis( [ 0.8d0, 4.2d0, 4.2d0, 0.8d0 ] )
   call msAxis( "equal" )
   call msHold( "on" )

   ! velocity field: special case, involving source, sink, stretching
   ! and rotation...
   ux = reshape( [ -1., -1.,  1.,  1.,                                  &
                    1., -1.,  1., -1.,                                  &
                    1., -1.,  1.,  1.,                                  &
                   -1.,  1., -1., -1.                                   &
                    ], [4,4] )
   ux = .t. ux

   uy = reshape( [ -1.,  1.,  1.,  1.,                                  &
                   -1., -1., -1.,  1.,                                  &
                    1.,  1.,  1., -1.,                                  &
                   -1.,  1.,  1., -1.                                   &
                    ], [4,4] )
   uy = .t. uy

   ! all start points can be stored in one mfArray
   start = reshape( [ 2.00d0, 1.20d0,                                   &
                      2.00d0, 1.60d0,                                   &
                      2.45d0, 2.00d0,                                   &
                      2.60d0, 2.00d0,                                   &
                      2.60d0, 3.40d0,                                   &
                      2.40d0, 3.60d0,                                   &
                      3.50d0, 3.10d0,                                   &
                      1.60d0, 3.40d0,                                   &
                      3.00d0, 1.70d0,                                   &
                      3.00d0, 1.78d0,                                   &
                      1.00d0, 3.20d0,                                   &
                      2.60d0, 1.20d0                                    &
                    ], [2,12] )
   start = .t. start

   call msQuiver( ux, uy, arrow_head=1.0d0, arrow_length=0.25d0 )
   call msPlot( mfGet(start,MF_ALL,1), mfGet(start,MF_ALL,2), "ob" )
   call msXLabel( "j" )
   call msYLabel( "i" )
   call msStreamline( ux, uy, start, color="r" )
!!call msPanAndZoom()

   write(STDOUT,"(/,A)",advance="no") "  *** printing..."
   call msFlush(STDOUT)
   call msPrint( "Streamline_1.eps" )
   call msPrint( "Streamline_1.pdf" )
   write(STDOUT,"(A,/)") " done ***"

   !----------------------------------------------
   call msFigure(2)
   call msAxis( [ 0.9d0, 5.6d0, 5.1d0, 0.3d0 ] )
   call msAxis( "equal" )
   call msHold( "on" )

   ! velocity field: random
   ! components between 0 and 1: easy test for computing streamlines
   N = 5
   ux = mfRand(N,N)
   uy = mfRand(N,N)

   ! all start points can be stored in one mfArray
   start = reshape( [ 1.5, 1.5,                                         &
                      1.5, 2.5,                                         &
                      2.5, 1.5,                                         &
                      2.5, 2.5,                                         &
                      2.5, 3.5,                                         &
                      3.5, 2.5,                                         &
                      3.5, 3.5,                                         &
                      4.5, 3.5,                                         &
                      4.5, 4.5                                          &
                    ], [2,9] )
   start = .t. start

   call msQuiver( ux, uy, arrow_head=1.0d0 )
   call msPlot( mfGet(start,MF_ALL,1), mfGet(start,MF_ALL,2), "ob" )
   call msXLabel( "j" )
   call msYLabel( "i" )
   call msStreamline( ux, uy, start, color="r", direction="forward" )
!!call msPanAndZoom()

   write(STDOUT,"(/,A)",advance="no") "  *** printing..."
   call msFlush(STDOUT)
   call msPrint( "Streamline_2.eps" )
   call msPrint( "Streamline_2.pdf" )
   write(STDOUT,"(A,/)") " done ***"

   !-------------------------------------------
   call msFigure(3)
   call msAxis( [ -2.1d0, 2.6d0, -2.1d0, 2.7d0 ] )
   call msAxis( "equal" )
   call msHold( "on" )

   ! nodes coordinates
   x = [ -2., -1., 0.,  1.,  2. ]
   y = [  2.,  1., 0., -1., -2. ]
   if( size(x) /= N ) then
      stop "*** 'x' must have its size equal to N (see figure(1)"
   end if
   if( size(y) /= N ) then
      stop "*** 'y' must have its size equal to N (see figure(1)"
   end if

   ! velocity field: same as in figure(1)

   ! all start points can be stored in one mfArray
   start = reshape( [ -1.5,  1.5,                                       &
                      -1.5,  0.5,                                       &
                      -0.5,  1.5,                                       &
                      -0.5,  0.5,                                       &
                      -0.5, -0.5,                                       &
                       0.5,  0.5,                                       &
                       0.5, -0.5,                                       &
                       0.5, -1.5,                                       &
                       1.5, -1.5                                        &
                    ], [2,9] )
   start = .t. start

   ! drawing of the rectangular mesh
   do k = 1, N
      call msPlot( x, mfGet(y,k)*mfOnes(1,N), color=[0.7d0,0.7d0,0.7d0] )
   end do
   do k = 1, N
      call msPlot( mfGet(x,k)*mfOnes(1,N), y, color=[0.7d0,0.7d0,0.7d0] )
   end do
   call msQuiver( x, y, ux, uy, arrow_head=1.0d0 )
   call msPlot( mfGet(start,MF_ALL,1), mfGet(start,MF_ALL,2), "ob" )
   call msXLabel( "x" )
   call msYLabel( "y" )
   call msStreamline( x, y, ux, uy, start, color="r", direction="backward" )
!!call msPanAndZoom()

   write(STDOUT,"(/,A)",advance="no") "  *** printing..."
   call msFlush(STDOUT)
   call msPrint( "Streamline_3.eps" )
   call msPrint( "Streamline_3.pdf" )
   write(STDOUT,"(A,/)") " done ***"

   !-------------------------------------------
   call msFigure(4)
   call msAxis( [ -2.1d0, 2.6d0, -2.1d0, 2.7d0 ] )
   call msAxis( "equal" )
   call msHold( "on" )

   ! nodes coordinates: same as before

   ! velocity field: same as before

   ! all start points can be stored in one mfArray
   start = reshape( [ -1.5,  1.5,                                       &
                      -1.5,  0.5,                                       &
                      -0.5,  1.5,                                       &
                      -0.5,  0.5,                                       &
                      -0.5, -0.5,                                       &
                       0.5,  0.5,                                       &
                       0.5, -0.5,                                       &
                       0.5, -1.5,                                       &
                       1.5, -1.5                                        &
                    ], [2,9] )
   start = .t. start

   ! drawing of the rectangular mesh
   do k = 1, N
      call msPlot( x, mfGet(y,k)*mfOnes(1,N), color=[0.7d0,0.7d0,0.7d0] )
   end do
   do k = 1, N
      call msPlot( mfGet(x,k)*mfOnes(1,N), y, color=[0.7d0,0.7d0,0.7d0] )
   end do
   call msQuiver( x, y, ux, uy, arrow_head=1.0d0 )
   call msPlot( mfGet(start,MF_ALL,1), mfGet(start,MF_ALL,2), "ob" )
   call msXLabel( "x" )
   call msYLabel( "y" )
   call msStreamline( x, y, ux, uy, start, color="r", direction="both" )
!!call msPanAndZoom()

   write(STDOUT,"(/,A)",advance="no") "  *** printing..."
   call msFlush(STDOUT)
   call msPrint( "Streamline_4.eps" )
   call msPrint( "Streamline_4.pdf" )
   write(STDOUT,"(A,/)") " done ***"

   !-------------------------------------------
   call msFigure(5)
   call msAxis( [ -2.1d0, 2.6d0, -2.1d0, 2.7d0 ] )
   call msAxis( "equal" )
   call msHold( "on" )

   ! nodes coordinates: same as before

   ! velocity field: same as before

   ! all start points can be stored in one mfArray
   start = reshape( [ -2.0, -2.0,                                       &
                      -1.5, -2.0,                                       &
                      -1.0, -2.0,                                       &
                      -0.5, -2.0,                                       &
                       0.0, -2.0,                                       &
                       0.5, -2.0,                                       &
                       1.0, -2.0,                                       &
                       1.5, -2.0,                                       &
                       2.0, -2.0                                        &
                    ], [2,9] )
   start = .t. start

   ! drawing of the rectangular mesh
   do k = 1, N
      call msPlot( x, mfGet(y,k)*mfOnes(1,N), color=[0.7d0,0.7d0,0.7d0] )
   end do
   do k = 1, N
      call msPlot( mfGet(x,k)*mfOnes(1,N), y, color=[0.7d0,0.7d0,0.7d0] )
   end do
   call msQuiver( x, y, ux, uy, arrow_head=1.0d0 )
   call msPlot( mfGet(start,MF_ALL,1), mfGet(start,MF_ALL,2), "ob" )
   call msXLabel( "x" )
   call msYLabel( "y" )
   call msStreamline( x, y, ux, uy, start, color="r", linestyle="--",   &
                      n_arrow=0, direction="both" )
!!call msPanAndZoom()

   write(STDOUT,"(/,A)",advance="no") "  *** printing..."
   call msFlush(STDOUT)
   call msPrint( "Streamline_5.eps" )
   call msPrint( "Streamline_5.pdf" )
   write(STDOUT,"(A,/)") " done ***"

   !-------------------------------------------
   call msFigure(6)
   call msAxis( [ -2.3d0, 2.4d0, -2.5d0, 2.65d0 ] )
   call msAxis( "equal" )
   call msHold( "on" )

   ! nodes coordinates: same as before

   ! velocity field: random
   ! components between 0 and 1: easy test for computing streamlines
   tmp = mfRandN(30,1) ! generate some random numbers to shift the stream
   ux = mfRandN(N,N)
   uy = mfRandN(N,N)

   ! all start points can be stored in one mfArray
   call msMeshGrid( mfOut(x_mat,y_mat), mfLinspace( -1.5d0, 1.5d0, 4 ), &
                                    .t. mfLinspace( -1.5d0, 1.5d0, 4 ) )
   x_mat = mfReshape( x_mat, MF_EMPTY, 1 )
   y_mat = mfReshape( y_mat, MF_EMPTY, 1 )
   start = x_mat .hc. y_mat

   ! drawing of the rectangular mesh
   do k = 1, N
      call msPlot( x, mfGet(y,k)*mfOnes(1,N), color=[0.7d0,0.7d0,0.7d0] )
   end do
   do k = 1, N
      call msPlot( mfGet(x,k)*mfOnes(1,N), y, color=[0.7d0,0.7d0,0.7d0] )
   end do
   call msQuiver( x, y, ux, uy, arrow_head=1.0d0 )
   call msPlot( mfGet(start,MF_ALL,1), mfGet(start,MF_ALL,2), "ob" )
   call msXLabel( "x" )
   call msYLabel( "y" )
   call msStreamline( x, y, ux, uy, start, color="r", direction="both" )
!!call msPanAndZoom()

   write(STDOUT,"(/,A)",advance="no") "  *** printing..."
   call msFlush(STDOUT)
   call msPrint( "Streamline_6.eps" )
   call msPrint( "Streamline_6.pdf" )
   write(STDOUT,"(A,/)") " done ***"

!_______________________________________________________________________
!
99 continue

   ! Waits for a user answer (avoids that all graphic windows disappear)
   ! then, cleans internal memory
   call msExitFgl()

   call msRelease( x, y, ux, uy, start )

   ! non official Muesli routine: introduced here to clean memory
   call RngStream_end()

end program
