program Spy_test

   use fml
   use fgl

   use test_aux

   implicit none

   type(mfArray) :: A
   integer :: N
   character(len=1) :: ans
   logical :: skip

!_______________________________________________________________________
!

   call run_options()

   print *, "zooming in most of figures:"
   write(*,"(a)",advance="no") "  --------> skip zoom ? [Y]/N "
   read "(a)", ans
   if( ans == "n" .or. ans == "N" ) then
      skip = .false.
   else
      skip = .true.
   end if

   call msFigure(1)

!------

   print *, " test 1"

   ! classical use (sparse, like spy of Matlab)
   A = mfSpEye(10)
   call msSpy( A )
   call msXLabel("column index")
   call msYLabel("row index")
   call msTitle("mfSpEye(10)")

   write(STDOUT,"(A)",advance="no") "  *** printing..."
   call msFlush(STDOUT)
   call msPrint( "Spy_1.eps" )
   call msPrint( "Spy_1.pdf" )
   write(STDOUT,"(A,/)") " done ***"

   call msPause()

!------

   ! if we switch to a classical plot, axis must come back to standard
   call msPlot( mf([ 0.0, 1.5, 3.0 ]), mf([ 0.0, 1.2, -0.3 ]) )
   call msPause()

!------

   ! arg. is a tempo
   call msSpy( mfSpEye(50) )
   call msTitle("mfSpEye(50)")
   call msPause()

!------

   ! testing zoom
   call msSpy( mfSpEye(500) )
   call msTitle("mfSpEye(500)")
#ifndef _NO_X11
   if( .not. skip ) then
      call msZoom()
   else
      call msPause()
   end if
#else
   call msPause()
#endif

!------

   print *, " test 2"

   A = mfLoadSparse("../data/C.csc",format="CSC")
   call msSpy( A )
   call msTitle("Sparse matrix from smlib-poisson ex.")
#ifndef _NO_X11
   if( .not. skip ) then
      call msZoom()
   end if
#endif

   write(STDOUT,"(A)",advance="no") "  *** printing..."
   call msFlush(STDOUT)
   call msPrint( "Spy_2.eps" )
   call msPrint( "Spy_2.pdf" )
   write(STDOUT,"(A,/)") " done ***"

   call msPause()

!------

   print *, " test 3"

   ! new continuous optional argument
   N = 200
   A = mfRand(N,N) + 5.0d0*mfEye(N,N)
   call msSpy( A, continuous=.true. )
   call msTitle("Id. matrix + random values")
#ifndef _NO_X11
   if( .not. skip ) then
      call msZoom()
   else
      call msPause()
   end if
#else
   call msPause()
#endif

!------

   print *, " test 4"

   ! all elements with the same value
   A = 2.0d0*mfOnes(20)
   call msSpy( A, continuous=.true. )
   call msTitle("constant matrix")
   call msPause()

!------

   print *, " test 5"

   ! all elements are null
   A = mfZeros(20)
   call msSpy( A, continuous=.true. )
   call msTitle("null matrix")
   call msPause()

!------

   print *, " test 6"

   ! IEEE special values in dense
   A = mfEye(80)
   call mf_save_and_disable_fpe( )
   call msSet( MF_NAN, A, 3, 7 )
   call msSet( MF_INF, A, 9, 4 )
   call msSet( -MF_INF, A, 1, 4 )
   call mf_restore_fpe( )
   call msSpy( A, continuous=.true. )
   call msTitle("matrix with IEEE special values")
#ifndef _NO_X11
   if( .not. skip ) then
      call msZoom()
   end if
#endif

   write(STDOUT,"(A)",advance="no") "  *** printing..."
   call msFlush(STDOUT)
   call msPrint( "Spy_6.eps" )
   call msPrint( "Spy_6.pdf" )
   write(STDOUT,"(A,/)") " done ***"

   call msPause()

!------

   print *, " test 7"

   ! sparse
   A = mfSpEye(500)
   call msSpy( A, continuous=.true. )
   call msTitle("mfSpEye(500)")
#ifndef _NO_X11
   if( .not. skip ) then
      call msZoom()
   end if
#endif

   write(STDOUT,"(A)",advance="no") "  *** printing..."
   call msFlush(STDOUT)
   call msPrint( "Spy_7.eps" )
   call msPrint( "Spy_7.pdf" )
   write(STDOUT,"(A,/)") " done ***"
#ifndef _NO_X11
   if( .not. skip ) then
      call msZoom()
   end if
#endif

   write(STDOUT,"(A)",advance="no") "  *** printing..."
   call msFlush(STDOUT)
   call msPrint( "Spy_7b.eps" )
   call msPrint( "Spy_7b.pdf" )
   write(STDOUT,"(A,/)") " done ***"

   call msPause()

!------

   print *, " test 8"

   ! IEEE special values in sparse
   A = mfSpEye(80)
   call msSpReAlloc( A, mfNzmax(A)+3 )
   call mf_save_and_disable_fpe( )
   call msSet( MF_NAN, A, 3, 7 )
   call msSet( MF_INF, A, 9, 4 )
   call msSet( -MF_INF, A, 1, 4 )
   call mf_restore_fpe( )
   call msSpy( A, continuous=.true. )
   call msTitle("matrix with IEEE special values")
#ifndef _NO_X11
   if( .not. skip ) then
      call msZoom()
   end if
#endif

!------

   print *, " test 9"

   ! matrice dense avec du bruit numérique
   N = 10
   A = 1.0d-12*mfRandN(N)**3 + mfEye(N)
   call msSet( 1.1d-2, A, 2, 5 )
   call msSet( 1.1d-4, A, 7, 2 )
   call msSet( 1.1d-6, A, 7, 8 )
   call msSet( 1.1d-8, A, 9, 4 )
   call msSet( 1.1d-10, A, 6, 10 )
   call msSpy( A, continuous=.true., show_nnz=.true. )
   call msTitle("A : Id. matrix + small random values")

   write(STDOUT,"(A)",advance="no") "  *** printing..."
   call msFlush(STDOUT)
   call msPrint( "Spy_9.eps" )
   call msPrint( "Spy_9.pdf" )
   write(STDOUT,"(A,/)") " done ***"

   call msPause()

!------

   print *, " test 10"

   call msSpy( A, continuous=.true., show_nnz=.true.,                   &
               color_scale="log" )
   call msTitle("matrix A with log grey scale")

   write(STDOUT,"(A)",advance="no") "  *** printing..."
   call msFlush(STDOUT)
   call msPrint( "Spy_10.eps" )
   call msPrint( "Spy_10.pdf" )
   write(STDOUT,"(A,/)") " done ***"

   call msPause()

!------

   print *, " test 11"

   call msSpy( A, continuous=.true., show_nnz=.true.,                   &
               nz_threshold=1.0d-10 )
   call msTitle("matrix A with filtering")

   write(STDOUT,"(A)",advance="no") "  *** printing..."
   call msFlush(STDOUT)
   call msPrint( "Spy_11.eps" )
   call msPrint( "Spy_11.pdf" )
   write(STDOUT,"(A,/)") " done ***"

   call msPause()

!------

   print *, " test 12"

   call msSpy( A, continuous=.true., show_nnz=.true.,                   &
               nz_threshold=1.0d-10, color_scale="log" )
   call msTitle("matrix A with filtering and log grey scale")

!------

   print *, " test 13"

   ! matrice creuse avec du bruit numérique
   N = 10
   A = mfSpEye(N)
   call msSpReAlloc( A, mfNzmax(A)+8 )
   call msSet( 1.1d-1, A, 2, 5 )
   call msSet( 1.1d-3, A, 7, 2 )
   call msSet( 1.1d-5, A, 7, 8 )
   call msSet( 1.1d-7, A, 9, 4 )
   call msSet( 1.1d-9, A, 6, 10 )
   call msSet( 1.1d-11, A, 2, 1 )
   call msSet( 1.1d-13, A, 3, 9 )
   call msSet( 1.1d-15, A, 6, 1 )
   call msSpy( A, continuous=.true., show_nnz=.true. )
   call msTitle("matrix A")
#ifndef _NO_X11
   if( .not. skip ) then
      call msZoom()
   end if
#endif

   write(STDOUT,"(A)",advance="no") "  *** printing..."
   call msFlush(STDOUT)
   call msPrint( "Spy_13.eps" )
   call msPrint( "Spy_13.pdf" )
   write(STDOUT,"(A,/)") " done ***"

   call msPause()

!------

   print *, " test 14"

   call msSpy( A, continuous=.true., show_nnz=.true.,                   &
               color_scale="log" )
   call msTitle("matrix A with log grey scale")
#ifndef _NO_X11
   if( .not. skip ) then
      call msZoom()
   end if
#endif

   write(STDOUT,"(A)",advance="no") "  *** printing..."
   call msFlush(STDOUT)
   call msPrint( "Spy_14.eps" )
   call msPrint( "Spy_14.pdf" )
   write(STDOUT,"(A,/)") " done ***"

   call msPause()

!------

   print *, " test 15"

   call msSpy( A, continuous=.true., show_nnz=.true.,                   &
               nz_threshold=1.0d-10 )
   call msTitle("matrix A with filtering")
#ifndef _NO_X11
   if( .not. skip ) then
      call msZoom()
   end if
#endif

   write(STDOUT,"(A)",advance="no") "  *** printing..."
   call msFlush(STDOUT)
   call msPrint( "Spy_15.eps" )
   call msPrint( "Spy_15.pdf" )
   write(STDOUT,"(A,/)") " done ***"

   call msPause()

!------

   print *, " test 16"

   call msSpy( A, continuous=.true., show_nnz=.true.,                   &
               nz_threshold=1.0d-10, color_scale="log" )
   call msTitle("matrix A with filtering and log grey scale")

   write(STDOUT,"(A)",advance="no") "  *** printing..."
   call msFlush(STDOUT)
   call msPrint( "Spy_16.eps" )
   call msPrint( "Spy_16.pdf" )
   write(STDOUT,"(A,/)") " done ***"

!_______________________________________________________________________
!
99 continue

   ! Waits for a user answer (avoids that all graphic windows disappear)
   ! then, cleans internal memory
   call msExitFgl()

   call msRelease( A )

   ! non official Muesli routine: introduced here to clean memory
   call RngStream_end()

end program
