program Plot_test

   use fml
   use fgl

   use test_aux

   implicit none

   type(mfArray) :: x, y, c
   integer :: i, h(7)
   character(len=72) :: name, mutex_name

!_______________________________________________________________________
!

   call run_options()

   y = [ 0., 0., 1., 1., 0., 0. ]

   call msPlot( y )
   call msPause()

   ! Trying different line attribut
   call msPlot( y, linewidth=2.5d0 )
   call msPause()

   call msPlot( y, linewidth=0.05d0 )
   call msPause()

   call msPlot( y, linespec="--", linewidth=0.2d0 )
   call msPause()

   x = [ 0., 0.333, 0.333, 0.666, 0.666, 1. ]

   call msPlot( x, y )
   call msPause()

   call msHold( "on" )
   call msPlot( x, y, "or" )
   call msPause()

   call msAxis( [ -0.1d0, 1.1d0, -0.1d0, 1.1d0] )
   call msAxis( "equal" )
   call msPause()

   call msAxis( "unequal" )

   ! Test Inf or NaN

   call msClf()
   call msAxis( "auto" )
   call msAxis( [ -0.1d0, 1.1d0, -10.0d0, 10.0d0 ] )
   x = mfLinspace( 0.0d0, 1.0d0, 5 )

   y = [ 1.0d0, MF_INF, MF_NAN, -MF_INF, -1.0d0 ]
!!   y = [ 1.0d0, MF_NAN, 0.0d0, -MF_NAN, -1.0d0 ]
!!   y = [ -MF_INF, -1.0d0, 0.0d0, 1.0d0, MF_INF ]
!!   y = [ -MF_REALMAX, -1.0d0, 0.0d0, 1.0d0, MF_REALMAX ]
!!   y = [ -2.0d0, -1.0d0, MF_NAN, 1.0d0, 2.0d0 ]
!!   y = [ -2.0d0, -1.0d0, -MF_INF, 1.0d0, 2.0d0 ]

   call msPlot( x, y )

   call msHold( "on" )
   call msPlot( x, y, "or" )
   call msPause()
   call msHold( "off" )

   ! Test sur des complexes
   call msClf()
   call msAxis( "auto" )

   x = mfLinspace( 0.0d0, 1.0d0, 25 )
   y = mfComplex( mfRand(1,25), mfRand(1,25) )
   call msPlot( x, y ) ! should ignore Imag() part [warning]
   call msXLabel( "x" )
   call msYLabel( "real(y)" )
   call msTitle( "y is complex (imaginary part ignored)" )
   call msPause()

   call msPlot( y ) ! should plot Imag() versus Real()
   call msXLabel( "real(y)" )
   call msYLabel( "imag(y)" )
   call msTitle( "y is complex (both parts plotted)" )

   !-------------------------------------------------------------------

   ! Test of transparency of some types of graphic object, set via msSetGrObj
   call msFigure(2)
   call msAxis( [ -0.1d0, 1.1d0, -0.1d0, 1.1d0] )

   ! Draw first a colored polygon in the background
   x = [ 0.2, 0.9, 0.9, 0.2 ]
   y = [ 0.2, 0.2, 0.9, 0.9 ]
   call msPatch( x, y, "g" )

   call msHold( "on" )

   h(1) = mfPlot( mf([0.,0.8]), mf([0.,0.6]), linewidth=20.0d0 )
   call msSetGrObj( h(1), "opacity", 0.5d0 )

   h(2) = mfText( 0.1d0, 0.85d0, "\fNHello World!", height=4.0d0 )
   call msSetGrObj( h(2), "opacity", 0.5d0 )

   call msRedrawFigure() ! required to see the changes applied by msSetGrObj

   call msPause()

   call msClf()

   ! Test now relative position of the grobj in the stack
   x = [ 0.15, 0.45, 0.45, 0.15 ]
   y = [ 0.55, 0.55, 0.85, 0.85 ]
   h(1) = mfPatch( x, y, "\C01" )

   call msHold( "on" )

   x = x + 0.075
   y = y - 0.075
   h(2) = mfPatch( x, y, "\C02" )

   x = x + 0.075
   y = y - 0.075
   h(3) = mfPatch( x, y, "\C03" )

   x = x + 0.075
   y = y - 0.075
   h(4) = mfPatch( x, y, "\C04" )

   x = x + 0.075
   y = y - 0.075
   h(5) = mfPatch( x, y, "\C05" )

   x = x + 0.075
   y = y - 0.075
   h(6) = mfPatch( x, y, "\C06" )

   x = x + 0.075
   y = y - 0.075
   h(7) = mfPatch( x, y, "\C07" )

   call msPause()

   print *, 'Moving the purple rect. "up" (w.r.t. drawing order)'
   call msSetGrObj( h(4), "position", "up" )
   call msRedrawFigure

   call msPause()

   print *, 'Moving the orange rect. "down" (w.r.t. drawing order)'
   call msSetGrObj( h(2), "position", "down" )
   call msRedrawFigure

   call msPause()

   print *, 'Moving the dark blue rect. "last" (i.e. under all others)'
   call msSetGrObj( h(1), "position", "last" )
   call msRedrawFigure

   call msPause()

   print *, 'Reverse drawing order...'
   do i = 6, 1, -1
      call msSetGrObj( h(i), "position", "first" )
   end do
   call msRedrawFigure

   call msPause()

   call msClf()

   ! Test now mixed attributes (linewidth and markersize), and clipping
   call msAxis( [ 0.0d0, 1.0d0, 0.0d0, 1.0d0] )

   x = [ 0.2, 0.4, 0.6, 0.8 ]
   y = [ 0.0, 0.4, 0.0, 1.2 ]

   call msPlot( x, y, "--o", linewidth=1.5d0, markersize=2.0d0 )

   call msPrint( "Plot_2.eps" )
   call msPrint( "Plot_2.pdf" )

   !-------------------------------------------------------------------

   ! Test for the automatic color selection
   ! (cycling in six colors)
   call msFigure(3)
   call msHold( "on" )

   y = [ 0., 1., 0., 1., 0., 1. ]
   do i = 1, 7
      h(i) = mfPlot( y )
      y = y*0.8d0
   end do

   call msPrint( "Plot_3.eps" )
   call msPrint( "Plot_3.pdf" )
   do i = 1, 7

      ! With this first call, optional content will be named by the
      ! graphic object handle. A PDF viewer will show: 'handle i', ...
      !!call msSetPdfOC( h(i) )

      ! Here, each optional content is named by the user:
      write(name,"(I0)") i
      name = "curve " // trim(name)
      call msSetPdfOC( h(i), trim(name) )

   end do
   call msPrint( "Plot_3_OC.pdf" )

   !-------------------------------------------------------------------

   ! Test for "mutually exclusive" optional contents, without persistent
   ! choice ('mutex' arg. in msSetPdfOC)
   call msFigure(4)
   call msAxis( [ 0.9d0, 6.1d0, -0.1d0, 1.1d0] )
   call msHold( "on" )

   y = [ 0., 1., 0., 1., 0., 1. ]
   h(1) = mfPlot( y, linespec="bo-" )

   call msPause()

   call msSetGrObj( h(1), "visible", "off" )
   call msRedrawFigure() ! required to see the changes applied by msSetGrObj

   h(2) = mfPlot( y, linespec="ro--" )

   call msPause()

   call msSetGrObj( h(2), "visible", "off" )
   call msRedrawFigure() ! required to see the changes applied by msSetGrObj

   h(3) = mfPlot( y, linespec="m:o" )

   ! Before setting Optional Contents in the PDF, we must choose which
   ! line style will be visible by default (only one of them must be visible)
   call msSetGrObj( h(2:3), "visible", "off" )
   call msSetGrObj( h(1), "visible", "on" ) ! default line style

   call msSetPdfOC( h(1), name="Continuous + Blue", mutex="Line style" )
   call msSetPdfOC( h(2), name="Dashed + Red", mutex="Line style" )
   call msSetPdfOC( h(3), name="Dotted + Magenta", mutex="Line style" )

   call msPrint( "Plot_4_OC_mutex.pdf" )

   !-------------------------------------------------------------------

   ! Test for "mutually exclusive" optional contents, with persistent choice
   ! ('mutex' arg. in msSetPdfOC)
   call msFigure(5)
   call msAxis( [ 0.9d0, 6.1d0, -0.1d0, 1.1d0] )
   call msHold( "on" )

   y = [ 0., 1., 0., 1., 0., 1. ]
   h(1) = mfPlot( y, linespec="bo-" )

   call msPause()

   call msSetGrObj( h(1), "visible", "off" )
   call msRedrawFigure() ! required to see the changes applied by msSetGrObj

   h(2) = mfPlot( y, linespec="ro--" )

   call msPause()

   call msSetGrObj( h(2), "visible", "off" )
   call msRedrawFigure() ! required to see the changes applied by msSetGrObj

   h(3) = mfPlot( y, linespec="m:o" )

   mutex_name = "Line style (default: Cont. + Blue)"

   !-----------------------------------
   ! No needs to reset visibility of each grobj associated to OC: this will
   ! be done automatically by the library when using the 'persistent' option.

   call msSetPdfOC( h(1), persistent=.true., mutex=mutex_name )
   call msSetPdfOC( h(2), name="Dash. + Red", mutex=mutex_name )
   call msSetPdfOC( h(3), name="Dott. + Magenta", mutex=mutex_name )

   call msPrint( "Plot_5_OC_mutex_persistent.pdf" )

!_______________________________________________________________________
!
99 continue

   ! Waits for a user answer (avoids that all graphic windows disappear)
   ! then, cleans internal memory
   call msExitFgl()

   call msRelease( x, y, c )

   ! Non official Muesli routine: introduced here to clean memory
   call RngStream_end()

end program
