program Pcolor_test

   use fml
   use fgl

   use test_aux

   implicit none

   type(mfArray) :: x, y, r, theta, z, x1, y1
   type(mfArray) :: tri
   integer :: color_depth, m, n
   real(kind=MF_DOUBLE), allocatable :: z_f90(:,:)

!_______________________________________________________________________
!

   call run_options()

   call msFigure(1)

   color_depth = mfGetX11ColorDepth()
   write(STDOUT,"(A,I0)") " Color Depth = ", color_depth

   call msAxis( "equal" )
   call msAxis( "tight" )

!------

   call msColormapSize( 64 )
   call msColormap( "rainbow" )

   print *, " test 1"

   write(STDOUT,"(A,I0)") " Colormap size = ", mfColormapSize()

   z = mfEye(7,9)
   call msSet( 1.0d0, z, 7, 9 )
   call msSet( 1.0d0, z, 6, 8 )
   call msSet( 1.0d0, z, 5, 7 )

   call msShading( "interp" ) ! default is "flat"
   call msPcolor( z )
   call msXLabel( "column indexes" )
   call msYLabel( "row indexes" )
   call msTitle( '7 x 9 -- data_centering="vertex" (default), shading="interp"' )
   call msColorbar( "on" )
   ! call msPanAndZoom()

   write(STDOUT,"(A)",advance="no") "  *** printing..."
   call msFlush(STDOUT)
   call msPrint( "Pcolor_1.eps" )
   call msPrint( "Pcolor_1.pdf" )
   write(STDOUT,"(A,/)") " done ***"

   call msPause()

!------

   ! from now, increase the colormap size
   call msColormapSize( 256 )
   call msColormap( "rainbow" )

   print *, " test 2"

   print *, " Colormap size = ", mfColormapSize()

   z = mfEye(7,9)
   call msSet( 1.0d0, z, 7, 9 )
   call msSet( 1.0d0, z, 6, 8 )
   call msSet( 1.0d0, z, 5, 7 )

   call msShading( "flat" )
   call msPcolor( z )
   call msXLabel( "column indexes" )
   call msYLabel( "row indexes" )
   call msTitle( '7 x 9 -- data_centering="vertex" (default), shading="flat" (default)' )
   call msColorbar( "on" )

   write(STDOUT,"(A)",advance="no") "  *** printing..."
   call msFlush(STDOUT)
   call msPrint( "Pcolor_2.eps" )
   call msPrint( "Pcolor_2.pdf" )
   write(STDOUT,"(A,/)") " done ***"

   call msPause()

!------

   print *, " test 3"

   m = 7
   n = 9
   z = mfEye(m,n)
   call msSet( 1.0d0, z, 7, 9 )
   call msSet( 1.0d0, z, 6, 8 )
   call msSet( 1.0d0, z, 5, 7 )

   ! shading can be only flat for the cell-centered case
   call msShading( "flat" )
   call msPcolor( z, data_centering="cell" )
   call msXLabel( "column indexes" )
   call msYLabel( "row indexes" )
   call msTitle( '7 x 9 -- data_centering="cell", shading="flat" (always)' )
   call msColorbar( "on" )

   write(STDOUT,"(A)",advance="no") "  *** printing..."
   call msFlush(STDOUT)
   call msPrint( "Pcolor_3.eps" )
   call msPrint( "Pcolor_3.pdf" )
   write(STDOUT,"(A,/)") " done ***"

   call msPause()

!------

   print *, " test 4"

   z = 0.5d0 + 0.25d0*(2.0d0*mfRand(5,5)-1.0d0)
   call msDiag( z, 0.9d0*mfOnes(5,1) )

   call msDisplay(mfCAxis(),"Color Axis")

   ! shading can be only flat for the cell-centered case
   call msShading( "flat" )
   call msPcolor( z, data_centering="cell", grid=.true. )

   call msXLabel( "column indexes" )
   call msYLabel( "row indexes" )
   call msTitle( 'data_centering="cell", shading="flat"' )
   call msColorbar( "on" )

   write(STDOUT,"(A)",advance="no") "  *** printing..."
   call msFlush(STDOUT)
   call msPrint( "Pcolor_4.eps" )
   call msPrint( "Pcolor_4.pdf" )
   write(STDOUT,"(A,/)") " done ***"

   call msPause()

!------

   print *, " test 5"

   z = 0.5d0 + 0.5d0*mfRandN(5,5) ! leads to color overflow

   call msPcolor( z, data_centering="cell" )

   call msXLabel( "column indexes" )
   call msYLabel( "row indexes" )
   call msTitle( "color overflow: black for values < 0, white for values > 1" )
   call msColorbar( "on" )

   write(STDOUT,"(A)",advance="no") "  *** printing..."
   call msFlush(STDOUT)
   call msPrint( "Pcolor_5.eps" )
   call msPrint( "Pcolor_5.pdf" )
   write(STDOUT,"(A,/)") " done ***"

   call msPause()

   call msShading( "interp" )

   print *, " test 6"

   z = 0.5d0 + 0.25d0*(2.0d0*mfRand(5,5)-1.0d0)
   call msDiag( z, 0.9d0*mfOnes(5,1) )

   call msDisplay(mfCAxis(),"Color Axis")

   call msPcolor( z, data_centering="vertex" )

   call msXLabel( "column indexes" )
   call msYLabel( "row indexes" )
   call msTitle( 'data_centering="vertex", shading="interp"' )
   call msColorbar( "on" )

   write(STDOUT,"(A)",advance="no") "  *** printing..."
   call msFlush(STDOUT)
   call msPrint( "Pcolor_6.eps" )
   call msPrint( "Pcolor_6.pdf" )
   write(STDOUT,"(A,/)") " done ***"

   call msPause()

!------

   print *, " test 7"

   z = 0.5d0 + 0.5d0*mfRandN( 5 ) ! leads to color overflow => Warning

   ! displaying where color overflow occurs
   allocate( z_f90(size(z,1),size(z,2)) )
   z_f90 = z
   where( z_f90 < 0.0d0 )
      z_f90 = -MF_INF
   else where( z_f90 > 1.0d0 )
      z_f90 = +MF_INF
   else where
      z_f90 = 0.0d0
   end where
   call msDisplay( z_f90, "z (where color overflow occurs: value is ±INF)" )
   deallocate( z_f90 )

   call msPcolor( z, data_centering="vertex" )

   call msXLabel( "column indexes" )
   call msYLabel( "row indexes" )
   call msTitle( "color overflow: Warning: data is out of Color Axis" )
   call msColorbar( "on" )

   write(STDOUT,"(A)",advance="no") "  *** printing..."
   call msFlush(STDOUT)
   call msPrint( "Pcolor_7.eps" )
   call msPrint( "Pcolor_7.pdf" )
   write(STDOUT,"(A,/)") " done ***"

   call msPause()

!------
   call msShading( "flat" )
!------

   print *, " test 8"

   z = mfRand(8,5)
   call msMeshGrid( mfOut(x,y), mfLinspace(2.0d0, 5.0d0, 6),            &
                            .t. mfLinspace(4.0d0, 9.0d0, 9) )
   call msDisplay( z, "z" )
   call msDisplay( x, "x" )
   call msDisplay( y, "y" )

   ! x and y are matrices
   call msPcolor( x, y, z, data_centering="cell" )

   call msXLabel( "x" )
   call msYLabel( "y" )
   call msTitle( "use of actual (matrix) coordinates for data" )
   call msColorbar( "on" )

   write(STDOUT,"(A)",advance="no") "  *** printing..."
   call msFlush(STDOUT)
   call msPrint( "Pcolor_8.eps" )
   call msPrint( "Pcolor_8.pdf" )
   write(STDOUT,"(A,/)") " done ***"

   call msPause()

!------

   print *, " test 9"

   x = mfLinspace(2.0d0, 5.0d0, 6)
   y = .t. mfLinspace(4.0d0, 9.0d0, 9)

   ! x and y are vectors
   call msPcolor( x, y, z, data_centering="cell" )

   call msXLabel( "x" )
   call msYLabel( "y" )
   call msTitle( "use of vector coordinates for data" )
   call msColorbar( "on" )

   write(STDOUT,"(A)",advance="no") "  *** printing..."
   call msFlush(STDOUT)
   call msPrint( "Pcolor_9.eps" )
   call msPrint( "Pcolor_9.pdf" )
   write(STDOUT,"(A,/)") " done ***"

   call msPause()

!------

   print *, " test 10"

   x = mfRandN( 10 )

   call msCAxis( [ -3.0d0, +3.0d0 ] ) ! hope there will be no color overflow
   call msDisplay(mfCAxis(),"Color Axis")

   call msShading( "flat" )
   call msPcolor( x )

   call msXLabel( "column indexes" )
   call msYLabel( "row indexes" )
   call msColorbar( "on" )

!!   call msZoom() ! <-----------------
   call msDisplay(mfAxis(),"current axis")

   write(STDOUT,"(A)",advance="no") "  *** printing..."
   call msFlush(STDOUT)
   call msPrint( "Pcolor_10.eps" )
   call msPrint( "Pcolor_10.pdf" )
   write(STDOUT,"(A,/)") " done ***"

   call msPause()

!------

   print *, " test 11"

   call msMeshGrid( mfOut(x,y), mfLinspace(0.0d0, 10*MF_PI, 30),        &
                            .t. mfLinspace(0.0d0, 1.0d0, 2) )
   x = x**0.25d0
   z = mfCos( x**4 )

   call msCAxis( [ -1.0d0, +1.0d0 ] )
   call msDisplay(mfCAxis(),"Color Axis")

   call msShading( "interp" )
   call msPcolor( mfGet(x,1,MF_ALL), mfGet(y,MF_ALL,1), z )

   call msXLabel( "x" )
   call msYLabel( "y" )
   call msColorbar( "on" )

!!   call msZoom() ! <-----------------

   write(STDOUT,"(A)",advance="no") "  *** printing..."
   call msFlush(STDOUT)
   call msPrint( "Pcolor_11.eps" )
   call msPrint( "Pcolor_11.pdf" )
   write(STDOUT,"(A,/)") " done ***"

   call msPause()

!------

   print *, " test 12"

   call msMeshGrid( mfOut(x,y), mfLinspace(0.0d0,  5.0d0, 10),          &
                            .t. mfLinspace(0.0d0, 10.0d0, 20) )
   r = mfSqrt(x**2 + y**2)
   z = mfSin( r ) / r
   call msSet( 1.0d0, z, 1, 1 ) ! avoid NaN value : sin(0)/0 = 1

   call msCAxis( [ -0.3d0, +1.0d0 ] )
   call msDisplay(mfCAxis(),"Color Axis")

   call msShading( "flat" )

   call msPcolor( x, y, z ) ! (x,y) vectors
   call msPcolor( mfFlipLR(x), y, z )
   call msPcolor( x, mfFlipUD(y), z )
   call msPcolor( mfFlipLR(x), mfFlipUD(y), z )

   call msXLabel( "x" )
   call msYLabel( "y" )
   call msColorbar( "on" )

!!   call msZoom() ! <-----------------

   write(STDOUT,"(A)",advance="no") "  *** printing..."
   call msFlush(STDOUT)
   call msPrint( "Pcolor_12.eps" )
   call msPrint( "Pcolor_12.pdf" )
   write(STDOUT,"(A,/)") " done ***"

   call msPause()

!------

   print *, " test 13"

   call msMeshGrid( mfOut(x,y), mfLinspace(0.0d0,  5.0d0, 20),          &
                            .t. mfLinspace(0.0d0, 10.0d0, 40) )
   r = mfSqrt(x**2 + y**2)
   z = mfSin( r ) / r
   call msSet( 1.0d0, z, 1, 1 ) ! avoid NaN value : sin(0)/0 = 1

   call msAxis( "auto" )
   call msAxis( "equal" )
   call msCAxis( [ -0.3d0, +1.0d0 ] )
   call msDisplay(mfCAxis(),"Color Axis")

   call msShading( "interp" )
   call msPcolor( mfGet(x,1,MF_ALL), mfGet(y,MF_ALL,1), z )

   call msXLabel( "x" )
   call msYLabel( "y" )
   call msColorbar( "on" )

!!   call msZoom() ! <-----------------

   write(STDOUT,"(A)",advance="no") "  *** printing..."
   call msFlush(STDOUT)
   call msPrint( "Pcolor_13.eps" )
   call msPrint( "Pcolor_13.pdf" )
   write(STDOUT,"(A,/)") " done ***"

   call msPause()

!------

   print *, " test 14"

   ! We can apply any transformation on previous (x,y) coordinates
   x1 = x - y
   y1 = x + y

   call msAxis( "auto" )
   call msAxis( "equal" )
   call msShading( "flat" )
   call msPcolor( x1, y1, z )

   call msXLabel( "x" )
   call msYLabel( "y" )
   call msColorbar( "on" )

!!   call msZoom() ! <-----------------

   write(STDOUT,"(A)",advance="no") "  *** printing..."
   call msFlush(STDOUT)
   call msPrint( "Pcolor_14.eps" )
   call msPrint( "Pcolor_14.pdf" )
   write(STDOUT,"(A,/)") " done ***"

   call msPause()

!------

   print *, " test 15"

   ! same transformation on (x,y) coordinates

   call msAxis( "auto" )
   call msAxis( "equal" )
   call msShading( "interp" )
   call msPcolor( x1, y1, z )

   call msXLabel( "x" )
   call msYLabel( "y" )
   call msColorbar( "on" )

!!   call msZoom() ! <-----------------

   write(STDOUT,"(A)",advance="no") "  *** printing..."
   call msFlush(STDOUT)
   call msPrint( "Pcolor_15.eps" )
   call msPrint( "Pcolor_15.pdf" )
   write(STDOUT,"(A,/)") " done ***"

   call msPause()

!------

   print *, " test 16"

   call msMeshGrid( mfOut(r,theta), mfLinspace(0.0d0,  5.0d0, 10),      &
                                .t. mfLinspace(0.0d0, MF_PI/2, 20) )
   z = mfSin( r ) / r
   call msSet( 1.0d0, z, MF_ALL, [1] ) ! avoid NaN value : sin(0)/0 = 1

   call msAxis( "auto" )
   call msAxis( "equal" )
   call msCAxis( [ -0.3d0, +1.0d0 ] )

   ! the transformation is globally non-linear, but locally linear
   x = r * mfCos(theta)
   y = r * mfSin(theta)

   call msPcolor( x, y, z, grid=.true. )

   call msXLabel( "x" )
   call msYLabel( "y" )
   call msColorbar( "on" )

!!   call msZoom() ! <-----------------

   write(STDOUT,"(A)",advance="no") "  *** printing..."
   call msFlush(STDOUT)
   call msPrint( "Pcolor_16.eps" )
   call msPrint( "Pcolor_16.pdf" )
   write(STDOUT,"(A,/)") " done ***"

   call msPause()

!------

   print *, " test 17"

   call msShading( "interp" )
   call msColormap( "parula" )

   call msMeshGrid( mfOut(r,theta), mfLinspace(0.0d0,  5.0d0, 5),       &
                                .t. mfLinspace(0.0d0, MF_PI/2, 10) )
   z = mfSin( r ) / r
   call msSet( 1.0d0, z, MF_ALL, [1] ) ! avoid NaN value : sin(0)/0 = 1

   call msAxis( "auto" )
   call msAxis( "equal" )
   call msCAxis( [ -0.3d0, +1.0d0 ] )

   ! the transformation is globally non-linear, but locally linear
   x = r * mfCos(theta)
   y = r * mfSin(theta)

   call msPcolor( x, y, z, grid=.true. )

   call msXLabel( "x" )
   call msYLabel( "y" )
   call msColorbar( "on" )

!!   call msZoom() ! <-----------------

   write(STDOUT,"(A)",advance="no") "  *** printing..."
   call msFlush(STDOUT)
   call msPrint( "Pcolor_17.eps" )
   call msPrint( "Pcolor_17.pdf" )
   write(STDOUT,"(A,/)") " done ***"

   call msPause()

!------

   print *, " test 18"

   call msMeshGrid( mfOut(r,theta), mfLinspace(1.0d0,  4.0d0, 10),      &
                                .t. mfLinspace(0.0d0, MF_PI, 40) )
   z = mfSin( r ) / r
   call msSet( 1.0d0, z, MF_ALL, [1] ) ! avoid NaN value : sin(0)/0 = 1

   call msAxis( "auto" )
   call msAxis( "equal" )
   call msCAxis( [ -0.7d0, +1.2d0 ] )

   ! the transformation is globally non-linear, but locally linear
   x = r * mfCos(theta)
   y = r * mfSin(theta)
   z = z + y/8. + x/8.

   call msPcolor( x, y, z, grid=.true. )

   call msXLabel( "x" )
   call msYLabel( "y" )
   call msColorbar( "on" )

!!   call msZoom() ! <-----------------

   write(STDOUT,"(A)",advance="no") "  *** printing..."
   call msFlush(STDOUT)
   call msPrint( "Pcolor_18.eps" )
   call msPrint( "Pcolor_18.pdf" )
   write(STDOUT,"(A,/)") " done ***"

   call msPause()

!=======================================================================

   print *, " test 19"

   x = [ 0.05d0,  1.05d0, 1.0d0, -0.15d0, 0.65d0, 0.4d0, 1.2d0, 0.2d0, 0.4d0 ]
   y = [ 0.00d0, -0.05d0, 1.0d0,  0.95d0, 0.50d0, 1.3d0, 0.3d0, 0.4d0, 0.9d0 ]
   z = x**2 + mfSqrt(mfAbs(y))
   call msDisplay( .t.(x .vc. y .vc. z), "nodes (x, y, value)" )

   tri = mfDelaunay( x, y )
   call msDisplay( tri, "triangles" )

   call msShading( "flat" )

   call msColormap( "fusion" )
   call msAxis( [ -0.1d0, 1.2d0, -0.1d0, 1.15d0 ] )
   call msCAxis( [ 0.0d0, 2.0d0 ] )
   call msTriPcolor( x, y, z, tri )

   call msHold( "on" )
   call msTriMesh( x, y, tri, color=[0.75d0,0.75d0,0.75d0] )

   call msXLabel( "x" )
   call msYLabel( "y" )
   call msColorbar( "on" )

   write(STDOUT,"(A)",advance="no") "  *** printing..."
   call msFlush(STDOUT)
   call msPrint( "Pcolor_19.eps" )
   call msPrint( "Pcolor_19.pdf" )
   write(STDOUT,"(A,/)") " done ***"

   call msPause()

!------

   print *, " test 20"

   call msShading( "interp" )
   call msRedrawFigure()

   write(STDOUT,"(A)",advance="no") "  *** printing..."
   call msFlush(STDOUT)
   call msPrint( "Pcolor_20.eps" )
   call msPrint( "Pcolor_20.pdf" )
   write(STDOUT,"(A,/)") " done ***"

!------

   print *, " test 21"

   call msFigure(2)
   call msColormap( "rainbow" )

   z = 0.5d0 + 0.5d0*mfRandN( 5 )

   ! from 2020-01-01, ColorAxis is set automatically
   call msPcolor( z )

   call msXLabel( "column indexes" )
   call msYLabel( "row indexes" )
   call msColorbar( "on" )

   write(STDOUT,"(A)",advance="no") "  *** printing..."
   call msFlush(STDOUT)
   call msPrint( "Pcolor_21.eps" )
   call msPrint( "Pcolor_21.pdf" )
   write(STDOUT,"(A,/)") " done ***"

   call msPause()

!_______________________________________________________________________
!
99 continue

   ! Waits for a user answer (avoids that all graphic windows disappear)
   ! then, cleans internal memory
   call msExitFgl()

   call msRelease( x, y, r, theta, z, x1, y1 )
   call msRelease( tri )

   ! non official Muesli routine: introduced here to clean memory
   call RngStream_end()

end program
