program Image_test

   use fml
   use fgl

   use test_aux

   implicit none

   type(mfArray) :: image, cmap, infos
   character(len=80) :: image_name
   integer :: ncol

!_______________________________________________________________________
!

   call run_options()

   call msFigure(1)
   call msAxis( "off" )
   call msAxis( "equal" )

   print "()"

   !--------------------------- basic colors ---------------------------

   image_name = "images/Basic_colors.xpm"
   print *, "reading ", trim(image_name), " ..."
   call msImRead( mfOut(infos), trim(image_name), only_infos=.true. )
   call msDisplay( infos, "image size (width, height)" )
   call msImRead( mfOut(image,cmap), trim(image_name) )
   call msDisplay( cmap, "colormap" )
   call msDisplay( image, "image" )
   call msColormap( cmap )
   call msImage( image )

   call msPrint( "Image_1.eps" )
   call msPrint( "Image_1.pdf" )
   call msPause()

#ifdef _HAS_IM_CONVERT
   image_name = "images/Basic_colors.png"
   print *, "reading ", trim(image_name), " ..."
   call msImRead( mfOut(infos), trim(image_name), only_infos=.true. )
   call msDisplay( infos, "image size (width, height)" )
   call msImRead( mfOut(image,cmap), trim(image_name) )
   call msDisplay( cmap, "colormap" )
   call msDisplay( image, "image" )
   call msColormap( cmap )
   call msImage( image )

   call msPause()
#endif

   !----------- XPM with explicit colorname (without space) ------------

   image_name = "images/XPM_with_colornames_1.xpm"
   print *, "reading ", trim(image_name), " ..."
   call msImRead( mfOut(infos), trim(image_name), only_infos=.true. )
   call msDisplay( infos, "image size (width, height)" )
   call msImRead( mfOut(image,cmap), trim(image_name) )
   call msDisplay( cmap, "colormap" )
   call msDisplay( image, "image" )
   call msColormap( cmap )
   call msImage( image )

   call msPrint( "Image_2.eps" )
   call msPrint( "Image_2.pdf" )
   call msPause()

   !------------- XPM with explicit colorname (with space) -------------

   image_name = "images/XPM_with_colornames_2.xpm"
   print *, "reading ", trim(image_name), " ..."
   call msImRead( mfOut(infos), trim(image_name), only_infos=.true. )
   call msDisplay( infos, "image size (width, height)" )
   call msImRead( mfOut(image,cmap), trim(image_name) )
   call msDisplay( cmap, "colormap" )
   call msDisplay( image, "image" )
   call msColormap( cmap )
   call msImage( image )

   call msPrint( "Image_3.eps" )
   call msPrint( "Image_3.pdf" )
   call msPause()

   !-------------- XPM from the official XPM Manual (1996) -------------

   image_name = "images/plaid.xpm"
   print *, "reading ", trim(image_name), " ..."
   call msImRead( mfOut(infos), trim(image_name), only_infos=.true. )
   call msDisplay( infos, "image size (width, height)" )
   call msImRead( mfOut(image,cmap), trim(image_name) )
   call msDisplay( cmap, "colormap" )
   call msDisplay( image, "image" )
   call msColormap( cmap )
   call msImage( image )

   call msPrint( "Image_4.eps" )
   call msPrint( "Image_4.pdf" )
   call msPause()

   !---------------------- manipulation of images ----------------------

   ! standard image (no transparency) using "real valued pixels"
   image_name = "images/XPM_without_NONE.xpm"
   print *, "reading ", trim(image_name), " ..."
   call msImRead( mfOut(infos), trim(image_name), only_infos=.true. )
   call msDisplay( infos, "image size (width, height)" )
   call msImRead( mfOut(image,cmap), trim(image_name) )
   call msDisplay( cmap, "colormap" )
   call msDisplay( image, "image" )
   call msColormap( cmap )
   call msImage( image )
!!call msImWrite( image, cmap, "image_real_valued_without_NONE.xpm")

   call msPause()

   ! standard image (no transparency) using "indexed pixels"
   image_name = "images/XPM_without_NONE.xpm"
   print *, "reading ", trim(image_name), " ..."
   call msImRead( mfOut(infos), trim(image_name), only_infos=.true. )
   call msDisplay( infos, "image size (width, height)" )
   call msImRead( mfOut(image,cmap), trim(image_name), indexed=.true. )
   call msDisplay( cmap, "colormap" )
   call msDisplay( image, "image" )
   call msColormap( cmap )
   call msImage( image, indexed=.true. )
!!call msImWrite( image, cmap, "image_indexed_without_NONE.xpm", indexed=.true. )

   call msPause()

   ! transparency (NONE in XPM) using "real valued pixels"
   image_name = "images/XPM_with_NONE.xpm"
   print *, "reading ", trim(image_name), " ..."
   call msImRead( mfOut(infos), trim(image_name), only_infos=.true. )
   call msDisplay( infos, "image size (width, height)" )
   call msImRead( mfOut(image,cmap), trim(image_name) ) ! real valued pixels
   call msDisplay( cmap, "colormap" )
   call msDisplay( image, "image" )
   call msColormap( cmap )
   call msImage( image )

   call msPrint( "Image_5.eps" )
   call msPrint( "Image_5.pdf" )

!!call msImWrite( image, cmap, "image_real_valued_with_NONE.xpm" )

   call msPause()

   ! transparency (NONE in XPM) using "indexed pixels"
   image_name = "images/XPM_with_NONE.xpm"
   print *, "reading ", trim(image_name), " ..."
   call msImRead( mfOut(infos), trim(image_name), only_infos=.true. )
   call msDisplay( infos, "image size (width, height)" )
   call msImRead( mfOut(image,cmap), trim(image_name), indexed=.true. )
   call msDisplay( cmap, "colormap" )
   call msDisplay( image, "image" )
   call msColormap( cmap )
   call msImage( image, indexed=.true. )

   call msPrint( "Image_6.eps" )
   call msPrint( "Image_6.pdf" )

!!call msImWrite( image, cmap, "image_indexed_with_NONE.xpm", indexed=.true. )

   call msPause()

!### TODO ?:
! ajout transparence :
!   depuis un "real valued pixels" mfArray, en mettant des éléments à NaN
!   depuis un "indexed pixels", en mettant une couleur de la colormap à
!     (NaN, NaN, NaN)

! msImWrite devra comporter des tests plus poussés:
!     - pour un "real valued pixels" mfArray, pas de NaN dans la colormap
!     - pour un "indexed pixels", pas de NaN dans l'image

!--------------------------

   print *
   call msPause("  XPM format")
   image_name = "images/XPM_image.xpm"
   call msImRead( mfOut(infos), trim(image_name), only_infos=.true. )
   call msDisplay( infos, "image size (width, height)" )
   call msImRead( mfOut(image,cmap), trim(image_name) )
   call msColormap( cmap )

!!   print *, " Colormap size = ", mfColormapSize()
!!   call msDisplay(mfColormap(),"Color map")
!!   call msDisplay(mfCAxis(),"Color axis")

   call msImage( image )
   call msTitle( trim(image_name) )

   call msPause("  ready to flip vert. (upside/downside swap)?")

   call msImage( image, angle=0.0d0, flip="vert" )
   call msTitle( trim(image_name) )

   call msPrint( "Image_7.eps" )
   call msPrint( "Image_7.pdf" )

!!   call msZoom( "on" )

!--------------------------

#ifdef _HAS_IM_CONVERT
   print *
   call msPause("  JPG format")
   image_name = "images/JPEG_image.jpg"
   call msImRead( mfOut(infos), trim(image_name), only_infos=.true. )
   call msDisplay( infos, "image size (width, height)" )
   call msImRead( mfOut(image,cmap), trim(image_name) )
   call msColormap( cmap )

   call msImage( image, angle=0.0d0, flip="vert" )
   call msTitle( trim(image_name) )

   call msPrint( "Image_8.eps" )
   call msPrint( "Image_8.pdf" )

!--------------------------

   print *
   call msPause("  TIFF format")
   image_name = "images/TIFF_image.tif"
   call msImRead( mfOut(infos), trim(image_name), only_infos=.true. )
   call msDisplay( infos, "image size (width, height)" )
   call msImRead( mfOut(image,cmap), trim(image_name) )
   call msColormap( cmap )

   call msImage( image, angle=0.0d0, flip="vert" )
   call msTitle( trim(image_name) )

   call msPrint( "Image_9.eps" )
   call msPrint( "Image_9.pdf" )

!--------------------------

   print *
   call msPause("  Compressed TIFF format")
   image_name = "images/Compressed_TIFF_image.tifz"
   call msImRead( mfOut(infos), trim(image_name), only_infos=.true. )
   call msDisplay( infos, "image size (width, height)" )
   call msImRead( mfOut(image,cmap), trim(image_name) )
   call msColormap( cmap )

   call msImage( image )
   call msTitle( trim(image_name) )

!--------------------------

   print *
   call msPause("  GIF format")
   image_name = "images/GIF_image.gif"
   call msImRead( mfOut(infos), trim(image_name), only_infos=.true. )
   call msDisplay( infos, "image size (width, height)" )
   call msImRead( mfOut(image,cmap), trim(image_name) )
   call msColormap( cmap )

   call msImage( image )
   call msTitle( trim(image_name) )

!--------------------------

   print *
   call msPause("  PNG format")
   image_name = "images/PNG_image.png"
   call msImRead( mfOut(infos), trim(image_name), only_infos=.true. )
   call msDisplay( infos, "image size (width, height)" )
   call msImRead( mfOut(image,cmap), trim(image_name) )
   call msColormap( cmap )

   call msImage( image, angle=0.0d0, flip="vert" )
   call msTitle( trim(image_name) )

   call msPrint( "Image_10.eps" )
   call msPrint( "Image_10.pdf" )
#endif

!_______________________________________________________________________
!
99 continue

   ! Waits for a user answer (avoids that all graphic windows disappear)
   ! then, cleans internal memory
   call msExitFgl()

   call msRelease( image, cmap, infos )

end program
