! this program test needs that X11 device is not disabled.

module GinputCustom_mod

   use fml

   real(kind=MF_DOUBLE) :: x_min = -1.0d0, x_max = 10.0d0,               &
                           y_min = -1.0d0, y_max = 10.0d0

contains

   subroutine magnetic_grid_rule( icase, x1, y1, x2, y2, valid )

      integer,              intent(in)  :: icase
      real(kind=MF_DOUBLE), intent(in)  :: x1, y1
      real(kind=MF_DOUBLE), intent(out) :: x2, y2
      logical,              intent(out) :: valid

      if( x1 < x_min .or. x_max < x1 .or.                               &
          y1 < y_min .or. y_max < y1 ) then
         x2 = x1
         y2 = y1
         return
      end if

      if( icase == 1 ) then
         x2 = nint(x1)
         y2 = nint(y1)
      else
         x2 = nint(x1+0.5d0) - 0.5d0
         y2 = nint(y1+0.5d0) - 0.5d0
      end if

      if( 0.0d0 <= x2 .and. x2 <= x_max .and.                           &
          0.0d0 <= y2 .and. y2 <= y_max ) then
         valid = .true.
      else
         valid = .false.
      end if

   end subroutine

end module
!_______________________________________________________________________
!
program GinputCustom_test

   use fml
   use fgl

   use GinputCustom_mod

   implicit none

   type(mfArray) :: pos
   character(len=1) :: ans

!_______________________________________________________________________
!

#ifdef _NO_X11

   print *, "This test requires X11."

#else

   call msSetMsgLevel( 2 ) ! Errors and Warnings are displayed, not infos.

   write(*,"(a)",advance="no") "  --------> skip interactive session ? [Y]/N "
   read "(a)", ans

   if( mfGetX11Device() == "off" .or. mfToUpper(ans) /= "N" ) then
      print *
      stop
   end if

   call msFigure(1)

   call msAxis( [ x_min, x_max, y_min, y_max ] )
   call msGrid( "on", minor=.true. )

   call msDefineCustomCursors(                                          &
          "cursors/cursor_1.xbm", "cursors/cursor_1_mask.xbm", "green", &
          "cursors/cursor_2.xbm", "cursors/cursor_2_mask.xbm", "red" )

   print "(/,A)", "========== first case, without magnetic grid =========="

   pos = mfGinputCustom( )
   call msDisplay( mfGet(pos,1.to.2), "position" )
   call msDisplay( mfGet(pos,3), "case" )

   print *, "=========== second case, with magnetic grid ==========="

   pos = mfGinputCustom( magnetic_grid_rule )
   call msDisplay( mfGet(pos,1.to.2), "position" )
   call msDisplay( mfGet(pos,3), "case" )

!_______________________________________________________________________
!

   ! Waits for a user answer (avoids that all graphic windows disappear)
   ! then, cleans internal memory
   call msExitFgl()

   call msRelease( pos )

#endif

end program
