program Color_Text_and_Lines_test

   use fml
   use fgl

   use test_aux

   implicit none

   type(mfArray) :: x, y
   integer :: i, h
   integer :: iseq(6) = [ 1, 2, 4, 10, 20, 40 ]
   character(len=40) :: string
   real(kind=MF_DOUBLE) :: angle, y0
   character(len=1) :: ans
   logical :: skip, interactive

!_______________________________________________________________________
!

   call run_options()

   write(*,"(A)",advance="no") " --------> skip interactive session ? [Y]/N "
   read "(A)", ans
   interactive = mfToUpper(ans) == "N"

   !----------------------------------
   call msFigure(1)

   ! unit square increased by 10%
   ! (this imply switching to 'manual' mode)
   call msAxis( [ -1.05d0, 1.05d0, -1.05d0, 1.05d0] )

   print *, "animation with different heights:"
   write(*,"(a)",advance="no") "  --------> skip animation ? [Y]/N "
   read "(a)", ans
   if( ans == "n" .or. ans == "N" ) then
      skip = .false.
   else
      skip = .true.
   end if
   ! partie pour tester 'height' et 'just'
   do i = 1, 6

      write(string,"(I0)") iseq(i)
      string = "this is a string of height = " // trim(string)
      h = mfText( 1.0d0, -1.0d0, trim(string),                          &
                  just=1.0d0, height=dble(iseq(i)), color="m" )

      if( skip ) exit

      call msPause( duration=0.50d0 ) ! duration in sec.
      if( i /= 6 ) then
         call msRemoveGrObj(h)
      end if

   end do

   call msPause()
   call msRemoveGrObj(h)

   print *, "animation with different heights:"
   write(*,"(a)",advance="no") "  --------> skip animation ? [Y]/N "
   read "(a)", ans
   if( ans == "n" .or. ans == "N" ) then
      skip = .false.
   else
      skip = .true.
   end if
   ! test de la justification verticale, le caractère 'h' doit rester
   ! centré en position verticale: son y_min et son y_max sont à des
   ! coordonnées opposées
   do i = 1, 6

      write(string,"(I0)") iseq(i)
      string = "h"
      h = mfText( -1.0d0, 0.0d0, trim(string),                          &
                  just_vert=0.0d0, height=dble(iseq(i)), color="r" )

      if( skip ) exit

      call msPause( duration=0.50d0 ) ! duration in sec.
      if( i /= 6 ) then
         call msRemoveGrObj(h)
      end if

   end do

   call msPause()
   call msRemoveGrObj(h)

   if( .not. X11_OFF ) then

      print *, "animation with different angles:"
      write(*,"(a)",advance="no") "  --------> skip animations ? [Y]/N "
      read "(a)", ans
      if( ans == "n" .or. ans == "N" ) then
         skip = .false.
      else
         skip = .true.
      end if
      ! et les autres arguments optionnels : 'angle', 'just', ...
      string = "this string rotates!"
      call msAnimation("on")
      do i = 1, 145

         angle = (i-1.0d0)*2.5
         call msCla
         call msText( 0.0d0, 0.0d0, trim(string),                       &
                     angle=angle, height=2.0d0, color="b" )
         call msShowNow()

         if( skip ) exit

         call msPause( duration=0.01d0 ) ! duration in sec.

      end do
      call msAnimation("off")

   end if

   !----------------------------------
   call msFigure(2)

   ! partie pour tester le clipping sur les axes
   call msAxis( [ -1.05d0, 1.05d0, -1.05d0, 1.05d0] )

   call msText( -0.82d0, 0.3d0, "(without clipping)", height=2.0d0 )
   call msText( -0.82d0, 0.0d0,                                         &
                "this is a very long text string which should be longer than the axes", &
                height=2.0d0, clipping=.false. )

   call msXLabel("X axis")
   call msYLabel("Y axis")
   call msTitle("Title")

   call msText( -0.82d0, -0.3d0, "(with clipping)", height=2.0d0 )
   call msText( -0.82d0, -0.6d0,                                        &
                "this is another long text string which should be clipped to the axes", &
                height=2.0d0 )

#ifndef _NO_X11
   if( mfGetX11Device() == "on" .and. interactive ) then
      print "(/,A)", " *** Warning: during the scroll on the window, not clipped text"
      print "(A)",   "     may partially disappear; the whole figure should be redraw after ***"
      call msPan()
      call msRedrawFigure()
   end if
#endif

   call msPrint("Color_Text_and_Lines_1.eps")
   call msPrint("Color_Text_and_Lines_1.pdf")

   call msPause()

   !----------------------------------
   call msFigure(3)

   call msAxis( "off" )
   call msAxis( [ -0.1d0, 1.6d0, -0.8d0, 1.1d0] )

   call msPatch( mf([-0.1d0,1.6d0,1.6d0,-0.1d0]),                       &
                 mf([0.15d0,0.15d0,1.1d0,1.1d0]),                       &
                 color=[0.5d0,0.5d0,0.5d0] )
   call msHold( "on" )
   call msPatch( mf([-0.1d0,1.6d0,1.6d0,-0.1d0]),                       &
                 mf([-0.8d0,-0.8d0,0.05d0,0.05d0]),                     &
                 color=[0.5d0,0.5d0,0.5d0] )

   x = [ 0., 0.975 ]
   y0 = 1.0d0
   y = [ y0, y0 ]
   call msPlot( x, y, "k", linewidth=3.0d0 )
   call msText( 1.0d0, y0, "black (with one-letter-code)" )

   y0 = y0 - 0.1d0
   y = [ y0, y0 ]
   call msPlot( x, y, "w", linewidth=3.0d0 )
   call msText( 1.0d0, y0, "white (with one-letter-code)" )

   y0 = y0 - 0.1d0
   y = [ y0, y0 ]
   call msPlot( x, y, "r", linewidth=3.0d0 )
   call msText( 1.0d0, y0, "red" )

   y0 = y0 - 0.1d0
   y = [ y0, y0 ]
   call msPlot( x, y, "g", linewidth=3.0d0 )
   call msText( 1.0d0, y0, "green" )

   y0 = y0 - 0.1d0
   y = [ y0, y0 ]
   call msPlot( x, y, "b", linewidth=3.0d0 )
   call msText( 1.0d0, y0, "blue" )

   y0 = y0 - 0.1d0
   y = [ y0, y0 ]
   call msPlot( x, y, "c", linewidth=3.0d0 )
   call msText( 1.0d0, y0, "cyan" )

   y0 = y0 - 0.1d0
   y = [ y0, y0 ]
   call msPlot( x, y, "m", linewidth=3.0d0 )
   call msText( 1.0d0, y0, "magenta" )

   y0 = y0 - 0.1d0
   y = [ y0, y0 ]
   call msPlot( x, y, "y", linewidth=3.0d0 )
   call msText( 1.0d0, y0, "yellow", color="y" )

   y0 = y0 - 0.1d0
   y = [ y0, y0 ]
   call msPlot( x, y, color=[0.25d0,0.25d0,0.25d0], linewidth=3.0d0 )
   call msText( 1.0d0, y0, "dark grey" )

   y0 = y0 - 0.1d0
   y = [ y0, y0 ]
   call msPlot( x, y, color=[0.5d0,0.5d0,0.5d0], linewidth=3.0d0 )
   call msText( 1.0d0, y0, "medium grey",                               &
                           color=[0.5d0,0.5d0,0.5d0] )

   y0 = y0 - 0.1d0
   y = [ y0, y0 ]
   call msPlot( x, y, color=[0.75d0,0.75d0,0.75d0], linewidth=3.0d0 )
   call msText( 1.0d0, y0, "light grey" )

   y0 = y0 - 0.1d0
   y = [ y0, y0 ]
   call msPlot( x, y, color="orange", linewidth=3.0d0 )
   call msText( 1.0d0, y0, "orange", color="orange" )

   y0 = y0 - 0.1d0
   y = [ y0, y0 ]
   call msPlot( x, y, color="yellow green", linewidth=3.0d0 )
   call msText( 1.0d0, y0, "yellow green" )

   y0 = y0 - 0.1d0
   y = [ y0, y0 ]
   call msPlot( x, y, color="indian red", linewidth=3.0d0 )
   call msText( 1.0d0, y0, "indian red" )

   y0 = y0 - 0.1d0
   y = [ y0, y0 ]
   call msPlot( x, y, color="\C04", linewidth=3.0d0 )
   call msText( 1.0d0, y0, "4th col in current color scheme" )

   y0 = y0 - 0.1d0
   y = [ y0, y0 ]
   call msPlot( x, y, color="\C07", linewidth=3.0d0 )
   call msText( 1.0d0, y0, "7th col in current color scheme" )

   y0 = y0 - 0.1d0
   y = [ y0, y0 ]
   call msPlot( x, y, color=[0.0d0,0.0d0,0.0d0], linewidth=3.0d0 )
   call msText( 1.0d0, y0, "black (with RGB-code)" )

   y0 = y0 - 0.1d0
   y = [ y0, y0 ]
   call msPlot( x, y, color=[1.0d0,1.0d0,1.0d0], linewidth=3.0d0 )
   call msText( 1.0d0, y0, "white (with RGB-code)" )

   call msPrint("Color_Text_and_Lines_3.eps")
   call msPrint("Color_Text_and_Lines_3.pdf")

!_______________________________________________________________________
!
99 continue

   ! Waits for a user answer (avoids that all graphic windows disappear)
   ! then, cleans internal memory
   call msExitFgl()

   call msRelease( x, y )

end program
