program ColorMap_Intern_test

   use fml
   use fgl

   use test_aux

   implicit none

   type(mfArray) :: c

!_______________________________________________________________________
!

   call run_options()

   !----------------------------------
   call msFigure(1)

   ! unit square increased to 10%
   ! (this imply switching to 'manual' mode)
   call msAxis( [ -0.1d0, 1.1d0, -0.1d0, 1.1d0] )
   call msAxis( "equal" )
   call msColorbar( "on" )
   call msColormapSize( 256 )
   call msTitle( "(no colormap)" )
   call msPause( "no current colormap!" )

   ! install new colormap (256 shades)
   call msColormap( "rainbow" )
   c = mfColormap()
   print *
   print *, " 'Rainbow' colormap :"
   call msDisplay( c, "   colormap values", head=10, tail=10 )
   call msDisplay( mfShape(c), "   colormap size" )
   call msTitle( "'Rainbow' colormap" )

   call msPrint( "Colormap_rainbow.eps" )
   call msPrint( "Colormap_rainbow.pdf" )

   call msPause()

   ! install new colormap (256 shades)
   call msColormap( "hot" )
   c = mfColormap()
   print *
   print *, " 'Hot' colormap :"
   call msDisplay( c, "   colormap values", head=10, tail=10 )
   call msDisplay( mfShape(c), "   colormap size" )
   call msTitle( "'Hot' colormap" )
   call msPrint( "Colormap_hot.eps" )
   call msPrint( "Colormap_hot.pdf" )

   call msPause()

   ! install new colormap (256 shades)
   call msColormap( "parula" )
   c = mfColormap()
   print *
   print *, " 'Parula' colormap :"
   call msDisplay( c, "   colormap values", head=10, tail=10 )
   call msDisplay( mfShape(c), "   colormap size" )
   call msTitle( "'Parula' colormap" )

   call msPrint( "Colormap_parula.eps" )
   call msPrint( "Colormap_parula.pdf" )

   call msPause()

   ! install new colormap (256 shades)
   call msColormap( "bluered" )
   c = mfColormap()
   print *
   print *, " 'Bluered' colormap :"
   call msDisplay( c, "   colormap values", head=10, tail=10 )
   call msDisplay( mfShape(c), "   colormap size" )
   call msTitle( "'Bluered' colormap" )

   call msPrint( "Colormap_bluered.eps" )
   call msPrint( "Colormap_bluered.pdf" )

   call msPause()

   ! install new colormap (256 shades)
   call msColormap( "fusion" )
   c = mfColormap()
   print *
   print *, " 'Fusion' colormap :"
   call msDisplay( c, "   colormap values", head=10, tail=10 )
   call msDisplay( mfShape(c), "   colormap size" )
   call msTitle( "'Fusion' colormap" )

   call msPrint( "Colormap_fusion.eps" )
   call msPrint( "Colormap_fusion.pdf" )

   call msPause()

   ! install new colormap (256 shades)
   call msColormap( "grey" )
   c = mfColormap()
   print *
   print *, " 'Grey' colormap :"
   call msDisplay( c, "   colormap values", head=10, tail=10 )
   call msDisplay( mfShape(c), "   colormap size" )
   call msTitle( "'Grey' colormap" )

   call msPrint( "Colormap_grey.eps" )
   call msPrint( "Colormap_grey.pdf" )

   call msPause()

   ! change colormap size
   call msColormapSize( 128 )
   call msColormap( "flag" )
   c = mfColormap()
   print *
   print *, " 'Flag' colormap :"
   call msDisplay( c, "   colormap values", head=10, tail=10 )
   call msDisplay( mfShape(c), "   colormap size" )
   call msTitle( "'Flag' colormap" )

   call msPrint( "Colormap_flag.eps" )
   call msPrint( "Colormap_flag.pdf" )

   call msPause()

!_______________________________________________________________________
!

   ! Waits for a user answer (avoids that all graphic windows disappear)
   ! then, cleans internal memory
   call msExitFgl()

   call msRelease( c )

end program
