program Bar_test

   use fml
   use fgl

   use test_aux

   implicit none

   type(mfArray) :: x, y
   integer :: n, i
   real(kind=MF_DOUBLE), allocatable :: col_rgb(:,:)
   character(len=32), allocatable :: col_name(:)
   character(len=6), allocatable :: labels(:)

!_______________________________________________________________________
!

   call run_options()

   print *

!--------------------------

   call msFigure(1)

   y = [ 2.0d0,  0.0d0,  5.8d0,  1.0d0,  -2.0d0,  3.0d0 ]
   call msBar( y )

   write(STDOUT,"(A)",advance="no") "  *** printing..."
   call msPrint( "Bar_1.eps" )
   call msPrint( "Bar_1.pdf" )
   write(STDOUT,"(A,/)") " done ***"

!--------------------------

   call msPause()
   call msClf

   ! using temporary args
   call msBar( mf([ 8.0d0,  9.0d0, 10.0d0, 11.0d0,  12.0d0, 13.0d0 ]),  &
               mf([ 2.0d0,  0.0d0,  5.8d0,  1.0d0,  -2.0d0,  3.0d0 ]) )

   write(STDOUT,"(A)",advance="no") "  *** printing..."
   call msPrint( "Bar_1b.eps" )
   call msPrint( "Bar_1b.pdf" )
   write(STDOUT,"(A,/)") " done ***"

!--------------------------

   call msPause()

   ! using user labels for the X-axis
   n = mfGetXAxisTicksNb()
   allocate( labels(n) )
   labels(1) = "Feb" ; labels(2) = "Apr" ; labels(3) = "Jun"
   labels(4) = "Aug" ; labels(5) = "Oct" ; labels(6) = "Dec"
   call msSetXAxisUserLabels( labels )

   write(STDOUT,"(A)",advance="no") "  *** printing..."
   call msPrint( "Bar_1c.eps" )
   call msPrint( "Bar_1c.pdf" )
   write(STDOUT,"(A,/)") " done ***"

!--------------------------

   call msFigure(2)

   call msAxis( [5.0d0, 15.0d0, -3.0d0, 8.0d0] )
   x = [ 8.0d0,  9.0d0, 10.0d0, 11.0d0,  12.0d0, 13.0d0 ]
   y = [ 2.0d0,  MF_NAN, 5.8d0,  1.0d0,  -2.0d0,  3.0d0 ]
   call msBar( x, y, "r", width=0.25d0 )

   write(STDOUT,"(A)",advance="no") "  *** printing..."
   call msPrint( "Bar_2.eps" )
   call msPrint( "Bar_2.pdf" )
   write(STDOUT,"(A,/)") " done ***"

!--------------------------

   call msPause()
   call msClf

   x = mfColon( 1975, 2017 )
   n = size(x)
   y = mfRandn(1,n)
   allocate( col_rgb(3,1) )
   col_rgb(:,1) = [ 0.2d0, 0.6d0, 0.2d0 ]
   call msBar( x, y, color=col_rgb )
   call msAxis( [1970.0d0, 2020.0d0, -2.5d0, 2.5d0] )
   call msTitle("Random numbers: Normal Distribution")

   write(STDOUT,"(A)",advance="no") "  *** printing..."
   call msPrint( "Bar_2b.eps" )
   call msPrint( "Bar_2b.pdf" )
   write(STDOUT,"(A,/)") " done ***"

!--------------------------

   call msFigure(3)

   x = mfColon( 1, 45 )
   n = size(x)
   y = mfRand(1,n)
   call msAxis( [0.01d0, 1.0d0], "y" )
   call msAxis( "linlog" )
   col_rgb(:,1) = [ 0.65d0, 0.25d0, 0.45d0 ]
   call msBar( x, y, color=col_rgb, baseline=0.01d0 )
   call msTitle("Random numbers: Uniform Distribution")

   write(STDOUT,"(A)",advance="no") "  *** printing..."
   call msPrint( "Bar_3.eps" )
   call msPrint( "Bar_3.pdf" )
   write(STDOUT,"(A,/)") " done ***"

!--------------------------

   call msPause()
   call msClf

   x = mfColon( 1, 45 )
   n = size(x)
   y = mfRand(1,n)
   call msAxis( [0.5d0, 45.5d0, 0.01d0, 1.0d0] )
   call msAxis( "linlog" )
   col_rgb(:,1) = [ 0.4d0, 0.3d0, 0.4d0 ]
   call msBar( x, y, color=col_rgb )
   call msTitle("Random numbers: Uniform Distribution")

   write(STDOUT,"(A)",advance="no") "  *** printing..."
   call msPrint( "Bar_3b.eps" )
   call msPrint( "Bar_3b.pdf" )
   write(STDOUT,"(A,/)") " done ***"

   deallocate( col_rgb )

!--------------------------

   call msFigure(4)

   ! matrix data: 3 different series with 4 elements
   y = reshape( [ 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12 ], [ 4, 3 ] )

   call msBar( y )
   call msTitle("Groups of Bars")

   write(STDOUT,"(A)",advance="no") "  *** printing..."
   call msPrint( "Bar_4.eps" )
   call msPrint( "Bar_4.pdf" )
   write(STDOUT,"(A,/)") " done ***"

!--------------------------

   call msPause()
   call msClf

   ! matrix data: 6 different series with 4 elements
   y = reshape( [ (i,i=1,24) ], [ 4, 6 ] )

   call msBar( y )
   call msTitle("Groups of Bars (default color scheme)")

   write(STDOUT,"(A)",advance="no") "  *** printing..."
   call msPrint( "Bar_4b.eps" )
   call msPrint( "Bar_4b.pdf" )
   write(STDOUT,"(A,/)") " done ***"

!--------------------------

   call msPause()
   call msClf

   x = .t. mf( [ 2014, 2015, 2016, 2017 ] )
   ! matrix data: 7 different series with 4 elements
   y = reshape( [ (i,i=1,28) ], [ 4, 7 ] )

   ! from X11 RGB database
   allocate( col_name(7) )
   col_name(1) = "cornflower blue"
   col_name(2) = "lavender blush"
   col_name(3) = "medium turquoise"
   col_name(4) = "dark olive green"
   col_name(5) = "pale goldenrod"
   col_name(6) = "dark salmon"
   col_name(7) = "medium violet red"

   call msBar( x, y, color=col_name )
   call msTitle("Groups of Bars (using color names from X11 RGB database)")

   write(STDOUT,"(A)",advance="no") "  *** printing..."
   call msPrint( "Bar_4c.eps" )
   call msPrint( "Bar_4c.pdf" )
   write(STDOUT,"(A,/)") " done ***"

   deallocate( col_name )

!--------------------------

   call msFigure(5)

   x = .t. mf( [ 2014, 2015, 2016, 2017 ] )
   ! matrix data: 7 different series with 4 elements
   y = reshape( [ (i,i=1,28) ], [ 4, 7 ] )

   call msSetColorScheme(2) ! only for the current figure

   call msAxis( [2013.0d0, 2018.0d0, 0.0d0, 120.0d0] )
   call msBar( x, y, style="stacked" )
   call msTitle("Stacked Bars (color scheme: old Matlab colors)")

   write(STDOUT,"(A)",advance="no") "  *** printing..."
   call msPrint( "Bar_5.eps" )
   call msPrint( "Bar_5.pdf" )
   write(STDOUT,"(A,/)") " done ***"

!--------------------------

   call msFigure(6)

   ! matrix data: 3 different series with 4 elements
   y = reshape( [ 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12 ], [ 4, 3 ] )

   call msBar( y )
   call msTitle("Groups of Bars")

   call msLegend( "First data series", "Second data series", "Third data series" )

   write(STDOUT,"(A)",advance="no") "  *** printing..."
   call msPrint( "Bar_6.eps" )
   call msPrint( "Bar_6.pdf" )
   write(STDOUT,"(A,/)") " done ***"

!--------------------------

   call msFigure(7)

   x = .t. mf( [ 2014, 2015, 2016, 2017 ] )
   ! matrix data: 4 different series with 4 elements
   y = reshape( [ (i,i=1,16) ], [ 4, 4 ] )

   call msBar( x, y )
   call msTitle("Groups of Bars (default color scheme)")

   call msLegend( "1st data series", "2nd data series",                 &
                  "3rd data series", "4th data series" )

   write(STDOUT,"(A)",advance="no") "  *** printing..."
   call msPrint( "Bar_7.eps" )
   call msPrint( "Bar_7.pdf" )
   write(STDOUT,"(A,/)") " done ***"

!--------------------------

   call msFigure(8)

   x = .t. mf( [ 2014, 2015, 2016, 2017 ] )
   ! matrix data: 4 different series with 4 elements
   y = reshape( [ (i,i=1,16) ], [ 4, 4 ] )
   allocate( col_rgb(3,4) )
   col_rgb(:,1) = [0.3d0,0.2d0,0.1d0]
   col_rgb(:,2) = [0.5d0,0.4d0,0.2d0]
   col_rgb(:,3) = [0.7d0,0.6d0,0.3d0]
   col_rgb(:,4) = [0.9d0,0.8d0,0.4d0]

   call msBar( x, y, color=col_rgb )
   call msTitle("Groups of Bars (user-defined colors)")

   call msLegend( "1st data series", "2nd data series",                 &
                  "3rd data series", "4th data series" )

   write(STDOUT,"(A)",advance="no") "  *** printing..."
   call msPrint( "Bar_8.eps" )
   call msPrint( "Bar_8.pdf" )
   write(STDOUT,"(A,/)") " done ***"

   deallocate( col_rgb )
!_______________________________________________________________________
!

   ! Waits for a user answer (avoids that all graphic windows disappear)
   ! then, cleans internal memory
   call msExitFgl()

   call msRelease( x, y )

   ! non official Muesli routine: introduced here to clean memory
   call RngStream_end()

end program
