program AxisFontSize_test

   use fml
   use fgl

   use test_aux

   implicit none

   real(kind=MF_DOUBLE) :: d = 0.015d0
   real(kind=MF_DOUBLE) :: xbox(5), ybox(5)

!_______________________________________________________________________
!

   call run_options()

   !----------------------------------

   call msFigure(1)

   call msAxis( [ 0.0d0, 1.0d0, 0.0d0, 1.3d0 ] )

   call msHold( "on" )

   call msText( 0.1d0, 0.1d0, "mbgdy_MBGDY, angle=0.",                  &
                height=4.0d0, xbox=xbox, ybox=ybox )
   call msPlot( mf([0.1d0,0.1d0]), mf([0.1d0-d,0.1d0+d]),  "r" )
   call msPlot( mf([0.1d0-d,0.1d0+d]),  mf([0.1d0,0.1d0]), "r" )
   xbox(5) = xbox(1)
   ybox(5) = ybox(1)
   call msPlot( mf(xbox), mf(ybox),  "b--" )

   call msText( 0.2d0, 0.25d0, "mbgdy_MBGDY, angle=60.",                &
                height=3.0d0, angle=60.0d0, xbox=xbox, ybox=ybox )
   call msPlot( mf([0.2d0,0.2d0]), mf([0.25d0-d,0.25d0+d]),  "r" )
   call msPlot( mf([0.2d0-d,0.2d0+d]),  mf([0.25d0,0.25d0]), "r" )
   xbox(5) = xbox(1)
   ybox(5) = ybox(1)
   call msPlot( mf(xbox), mf(ybox),  "b--" )

   call msText( 0.9d0, 0.4d0, "mbgdy_MBGDY, angle=150.",                &
                height=2.0d0, angle=150.0d0, xbox=xbox, ybox=ybox )
   call msPlot( mf([0.9d0,0.9d0]), mf([0.4d0-d,0.4d0+d]),  "r" )
   call msPlot( mf([0.9d0-d,0.9d0+d]),  mf([0.4d0,0.4d0]), "r" )
   xbox(5) = xbox(1)
   ybox(5) = ybox(1)
   call msPlot( mf(xbox), mf(ybox),  "b--" )

   call msPrint( "Axis_font_size_1.eps" )
   call msPrint( "Axis_font_size_1.pdf" )

   call msPause()

   !----------------------------------

   call msFigure(2)

   call msAxis( "xy" )
   call msPause()

   call msXLabel( "X-axis" )
   call msYLabel( "Y-axis" )
   call msTitle( "Title (axis: mode 'xy')" )
   call msPause()

   call msTitleFontSize( 3.5d0 )
   call msPause()

   call msAxisFontSize( 2.0d0 )
   call msLabelFontSize( 0.75d0 )
   call msPause()

   call msTitleFontSize( 1.0d0 )
   call msAxisFontSize( 0.75d0 )
   call msLabelFontSize( 2.0d0 )
   call msPause()

   call msTitleFontSize( 2.0d0 )
   call msAxisFontSize( 1.0d0 )
   call msLabelFontSize( 1.0d0 )
   call msPause()

   call msPrint( "Axis_font_size_2.eps" )
   call msPrint( "Axis_font_size_2.pdf" )

   !----------------------------------

   call msFigure(3)

   call msAxis( "ij" )
   call msPause()

   call msXLabel( "X-axis" )
   call msYLabel( "Y-axis" )
   call msTitle( "Title (axis: mode 'ij')" )
   call msPause()

   call msTitleFontSize( 3.5d0 )
   call msPause()

   call msAxisFontSize( 2.0d0 )
   call msLabelFontSize( 0.75d0 )
   call msPause()

   call msTitleFontSize( 1.0d0 )
   call msAxisFontSize( 0.75d0 )
   call msLabelFontSize( 2.0d0 )
   call msPause()

   call msTitleFontSize( 2.0d0 )
   call msAxisFontSize( 1.0d0 )
   call msLabelFontSize( 1.0d0 )
   call msPause()

   call msPrint( "Axis_font_size_3.eps" )
   call msPrint( "Axis_font_size_3.pdf" )

   !----------------------------------

   call msFigure(4)

   call msAxis( "off" )

   call msText( 0.5d0, 0.5d0, "Help yourself!" )

   call msPrint( "Axis_font_size_4.eps" )
   call msPrint( "Axis_font_size_4.pdf" )

   call msPause()

!_______________________________________________________________________
!
99 continue

   ! Waits for a user answer (avoids that all graphic windows disappear)
   ! then, cleans internal memory
   call msExitFgl()

end program
