module mod_prop

   ! Part of MUESLI Numerical Library
   ! Copyright É. Canot 2003-2025 -- IPR/CNRS

   ! version : december 8, 2008

   use mod_mfdebug ! kind_1, UNKNOWN, FALSE, TRUE

   implicit none

   public

   type :: properties
      ! structure pattern (independant of matrix values)
      integer(kind=kind_1) :: tril = UNKNOWN ! lower triangular
      integer(kind=kind_1) :: triu = UNKNOWN ! upper triangular
      ! matrix properties (depend on values)
      integer(kind=kind_1) :: symm = UNKNOWN ! symmetric/hermitian
      integer(kind=kind_1) :: posd = UNKNOWN ! positive definite
   end type properties

   type(properties), parameter ::                                       &
                       PROP_ALL_UNKNOWN = properties( UNKNOWN, UNKNOWN, &
                                                      UNKNOWN, UNKNOWN )

   interface operator(==)
      module procedure prop_equal_prop
   end interface

   ! WARNING: 'hide_prop' and 'unhide_prop' must be done only once, for
   !          a given array. Because 'hide_prop' applied twice is identity!
   !          This is checked in the family msPointer routines...

contains
!_______________________________________________________________________
!
   subroutine reset_prop( prop )

      type(properties) :: prop
      !------ API end ------

#ifdef _DEVLP
   !------ end of declarations -- execution starts hereafter  ------

      prop%tril = UNKNOWN
      prop%triu = UNKNOWN
      prop%symm = UNKNOWN
      prop%posd = UNKNOWN

#endif
   end subroutine reset_prop
!_______________________________________________________________________
!
   subroutine hide_prop( prop )

      type(properties) :: prop
      !------ API end ------

#ifdef _DEVLP
      ! changes : -1          -1
      !            0    ->    -2
      !            1          -3

   !------ end of declarations -- execution starts hereafter  ------

      prop%tril = -(prop%tril + 2)
      prop%triu = -(prop%triu + 2)
      prop%symm = -(prop%symm + 2)
      prop%posd = -(prop%posd + 2)

#endif
   end subroutine hide_prop
!_______________________________________________________________________
!
   subroutine unhide_prop( prop )

      type(properties) :: prop
      !------ API end ------

#ifdef _DEVLP
      ! changes : -1          -1
      !           -2    ->     0
      !           -3           1

   !------ end of declarations -- execution starts hereafter  ------

      prop%tril = -(prop%tril + 2)
      prop%triu = -(prop%triu + 2)
      prop%symm = -(prop%symm + 2)
      prop%posd = -(prop%posd + 2)

#endif
   end subroutine unhide_prop
!_______________________________________________________________________
!
   function prop_equal_prop( p1, p2 ) result( bool )

      type(properties), intent(in) :: p1, p2
      logical :: bool
      !------ API end ------

#ifdef _DEVLP
   !------ end of declarations -- execution starts hereafter  ------

      bool = .false.

      if( p1%tril /= p2%tril ) return
      if( p1%triu /= p2%triu ) return
      if( p1%symm /= p2%symm ) return
      if( p1%posd /= p2%posd ) return

      bool = .true.

#endif
   end function prop_equal_prop
!_______________________________________________________________________
!
end module mod_prop
