module mod_fileio ! File Input/Output

   ! Part of MUESLI Numerical Library
   ! Copyright É. Canot 2003-2025 -- IPR/CNRS

!-----------------------------------------------------------------------
!                             used modules
!-----------------------------------------------------------------------

   use mod_elmat

!!   use iso_varying_string, only: varying_string, get, adjustl, extract,&
!!                                 len_trim, char
   use iso_varying_string, index_VS => index

#ifndef _DEVLP
   use mod_mfdebug ! required for the 2nd pass of the double compilation
   use mod_mfarray ! required for the 2nd pass of the double compilation
   use mod_core ! required for the 2nd pass of the double compilation
#endif

   use f90_gzlib

#ifdef _HDF5
! external fortran 90 module
#if defined _GNU_GFC
! bug: GNU-gfortran-4.3 must include all hdf5 (else: internal error)
   use hdf5
#else
! (only clause: avoids loading all declared module items)
   use hdf5, only: hid_t, &
                   hsize_t, &
                   H5F_ACC_RDWR_F, &
                   H5F_ACC_RDONLY_F, &
                   H5F_ACC_TRUNC_F, &
                   H5G_DATASET_F, &
                   H5G_GROUP_F, &
                   H5S_SCALAR_F, &
                   H5T_INTEGER_F, &
                   H5T_FLOAT_F, &
                   H5T_STRING_F, &
                   H5T_NATIVE_CHARACTER, &
                   H5T_NATIVE_DOUBLE, &
                   H5T_NATIVE_INTEGER, &
                   H5P_DATASET_CREATE_F, &
                   h5open_f, &
                   h5close_f, &
                   h5aclose_f, &
                   h5acreate_f, &
                   h5aget_name_f, &
                   h5aget_num_attrs_f, &
                   h5aget_space_f, &
                   h5aget_type_f, &
                   h5aopen_idx_f, &
                   h5aopen_name_f, &
                   h5aread_f, &
                   h5awrite_f, &
                   h5dclose_f, &
                   h5dcreate_f, &
                   h5dget_space_f, &
                   h5dget_type_f, &
                   h5dopen_f, &
                   h5dread_f, &
                   h5dwrite_f, &
                   h5fclose_f, &
                   h5fcreate_f, &
                   h5fopen_f, &
                   h5gcreate_f, &
                   h5gclose_f, &
                   h5gget_obj_info_idx_f, &
                   h5gn_members_f, &
                   h5gopen_f, &
                   h5gunlink_f, &
                   h5pcreate_f, &
                   h5pset_chunk_f, &
                   h5pset_deflate_f, &
                   h5screate_f, &
                   h5screate_simple_f, &
                   h5sclose_f, &
                   h5sget_simple_extent_dims_f, &
                   h5sget_simple_extent_ndims_f, &
                   h5tcopy_f, &
                   h5tget_class_f, &
                   h5tset_size_f
#endif
#endif

#if defined _INTEL_IFC
      use iflport, only: system, getpid ! (msMedit)
#endif

   implicit none

#ifndef _DEVLP
   private
#endif

#include "fml_polyfun/mfTriConnect.inc"
   public :: mfTriConnect

   interface msSave
      module procedure msSave_mfArray
      module procedure msSave_mfTriConnect
   end interface

   private :: msSave_mfArray, msSave_mfTriConnect

   public :: msSaveAscii, &
             mfLoadAscii, &
             msSave, &
             mfLoad, &
             mfLoadTriConnect

   ! HDF5 support
#ifdef _HDF5
   public :: msSaveHDF5, &
             mfLoadHDF5
#endif

#ifndef _NO_X11
   public :: msMedit
#endif

   public :: mfLoadSparse, &
             msLoadSparse, &
             msSaveSparse

   ! signature for MF release <= 0.1.3    --- NOT SUPPORTED ---
   ! (release 0.2.1 and 0.2.2 doesn't support file I/O)
   ! (only little-endian: i386)
   character(len=18), parameter :: MF_BIN_SIGN_22 = "MF-2.2_ECanot_CNRS"

   ! signature for MF release >= 0.2.3
   ! size = 20 (must be multiple of 4)
   character(len=20), parameter :: MF_BIN_SIGN_23 = "MF-2.3_ECanot_CNRS  "

   ! signature for MF release >= 2.8.0
   ! size = 20 (must be multiple of 4)
   character(len=20), parameter :: MF_BIN_SIGN_24 = "MF-2.4_ECanot_CNRS  "

   ! signature for MF release >= 2.21.1
   ! size = 20 (must be multiple of 4)
   character(len=20), parameter :: MF_BIN_SIGN_25 = "MF-2.5_ECanot_CNRS  "

   ! endianness test
   integer, parameter :: MF_ENDIAN_NATIVE = 875770417 ! = "1234"
   integer, parameter :: MF_ENDIAN_SWAP   = 825373492 ! = "4321"

contains
!_______________________________________________________________________
!
#include "fml_fileio/msSaveAscii.inc"
!_______________________________________________________________________
!
#include "fml_fileio/mfLoadAscii.inc"
!_______________________________________________________________________
!
#include "fml_fileio/msSave_mfArray.inc"
!_______________________________________________________________________
!
#include "fml_fileio/mfLoad.inc"
!_______________________________________________________________________
!
#include "fml_fileio/msSave_mfTriConnect.inc"
!_______________________________________________________________________
!
#include "fml_fileio/mfLoadTriConnect.inc"
!_______________________________________________________________________
!
#include "fml_fileio/msSaveSparse.inc"
!_______________________________________________________________________
!
#include "fml_fileio/mfLoadSparse.inc"
!_______________________________________________________________________
!
#include "fml_fileio/msLoadSparse.inc"
!_______________________________________________________________________
!
#ifdef _HDF5
#include "fml_fileio/msSaveHDF5.inc"
!_______________________________________________________________________
!
#include "fml_fileio/mfLoadHDF5.inc"
#endif
!_______________________________________________________________________
!
#include "fml_fileio/swap_bytes.inc"
!_______________________________________________________________________
!
#ifndef _NO_X11
   subroutine msMedit( x )

#if defined _INTEL_IFC
      use ifport
#endif

      type(mfArray), intent(in out) :: x
      !------ API end ------

#ifdef _DEVLP
      ! open the matrix-editor (Qt4 version) named 'meditor'

      type(mfArray) :: A
      integer :: m, n, status, unit, mypid
      character(len=16) :: str_mypid

   !------ end of declarations -- execution starts hereafter  ------

      if( x%parameter ) then
         call PrintMessage( "msMedit", "E",                             &
                            "'x' cannot be a protected array (pseudo-parameter)." )
         return
      end if

      ! test if the 'meditor' command is available...
#if defined _INTEL_IFC | defined _GNU_GFC
      status = system("which meditor > /dev/null")
#else
- '(MUESLI mod_fileio:) compiler not defined!'
#endif
      if( status /= 0 ) then
         call PrintMessage( "msMedit", "E",                             &
                            "'meditor' not in your PATH!",              &
                            "Therefore, you cannot edit mfArray's ..." )
         return
      end if

      ! first, saving the mfArray in a temporary ASCII file
      m = x%shape(1)
      n = x%shape(2)

      mypid = getpid()
      write( str_mypid, "(I0)" ) mypid
!!print *, "(MUESLI DBG:) msMedit: mypid = '" // trim(str_mypid) // "'"

      call find_unit( unit )
      open( unit=unit, file="/tmp/meditor."//trim(str_mypid)//".tmp1" )
      write( unit=unit, fmt=* ) m, n
      close( unit )

      if( x%data_type == MF_DT_DBLE ) then
         call msSaveAscii( "/tmp/meditor."//trim(str_mypid)//".tmp2", x )
      else if( x%data_type == MF_DT_SP_DBLE ) then
         A = mfFull( x )
         call msSaveAscii( "/tmp/meditor."//trim(str_mypid)//".tmp2", A )
         call msSilentRelease( A )
      else
         call PrintMessage( "msMedit", "E",                             &
                            "datatype not supported for editing!" )
         return
      end if

#if defined _INTEL_IFC | defined _GNU_GFC
      status = system( "cat /tmp/meditor." // trim(str_mypid) //        &
                       ".tmp1 /tmp/meditor." // trim(str_mypid) //      &
                       ".tmp2 > /tmp/meditor." // trim(str_mypid) // ".in" )
#else
- '(MUESLI mod_fileio:) compiler not defined!'
#endif
      if( status /= 0 ) then
         call PrintMessage( "msMedit", "E",                             &
                            "cannot cat two files ! (quota ?)" )
      end if
      status = system( "rm /tmp/meditor." // trim(str_mypid) // ".tmp1 " &
                       // "/tmp/meditor." // trim(str_mypid) // ".tmp2" )

#if defined _INTEL_IFC | defined _GNU_GFC
      ! 'unset SESSION_MANAGER' is added to avoid the following error:
      !   "Qt: Session management error: Could not open network socket";
      ! 'NO_AT_BRIDGE=1' is added to avoid a long message error about dbus;
      ! 'LC_NUMERIC=en_US.utf-8' is added to be sure that the decimal separator
      ! is the dot '.' and not the comma ',' like in french country.
      status = system("unset SESSION_MANAGER; NO_AT_BRIDGE=1 LC_NUMERIC=en_US.utf-8 " &
                      // "meditor < /tmp/meditor." // trim(str_mypid) // ".in > " &
                      // "/tmp/meditor." // trim(str_mypid) // ".out" )
#else
- '(MUESLI mod_fileio:) compiler not defined!'
#endif
      if( status /= 0 ) then
         call PrintMessage( "msMedit", "E",                             &
                            "cannot launch 'meditor'!" )
      end if
      status = system( "rm /tmp/meditor." // trim(str_mypid) // ".in" )

      if( x%data_type == MF_DT_DBLE ) then
         x = mfLoadAscii( "/tmp/meditor." // trim(str_mypid) // ".out", &
                          IEEE=.true. )
      else if( x%data_type == MF_DT_SP_DBLE ) then
         A = mfLoadAscii( "/tmp/meditor." // trim(str_mypid) // ".out", &
                          IEEE=.true. )
         x = mfSparse( A )
         call msSilentRelease( A )
      end if
      status = system( "rm /tmp/meditor." // trim(str_mypid) // ".out" )

      x%prop%symm = UNKNOWN
      x%prop%posd = UNKNOWN

#endif
   end subroutine msMedit
#endif
!_______________________________________________________________________
!
   subroutine post_chk_der( routine_name, M, N, quality,                &
                            print_check_jac, iter, time )

      character(len=*), intent(in) :: routine_name
      integer,          intent(in) :: M, N, print_check_jac
      double precision, intent(in) :: quality(M)

      ! for LsqNonLin and FSolve
      integer, intent(in), optional :: iter

      ! for OdeSolve and DaeSolve
      double precision, intent(in), optional :: time
      !------ API end ------

#ifdef _DEVLP
      !---------------------------------

      ! *******************************************************************
      ! ** this is when check_jac = 1 (i.e. quick check of the jacobian) **
      ! *******************************************************************

      logical :: iter_not_time

      double precision :: min_quality
      character(len=20) :: string1, string2, str
      integer :: i_min_quality(1)
      character :: str_level
      character(len=3) :: str_iter
      character(len=13) :: str_time
      character(len=30) :: filename
      integer :: mf_traceback_level_save

      integer :: i_eqn_group, i_group_eqn
      character(len=10) :: i_group_eqn_str

      !---------------------------------

      if( present(iter) ) then
         iter_not_time = .true.
      else if( present(time) ) then
         iter_not_time = .false.
      else
         write(STDERR,"(1X,A)") "(MUESLI Ode/Daesolve:) post_chk_der: internal error"
         write(STDERR,"(1X,A)") "                       'iter' or 'time' must be present!"
         call msPause() ! for debugging purpose
         stop
      end if

      min_quality = minval( quality )
      write( string1, "(F5.3)" ) min_quality

      ! diagnostic
      if( min_quality == 1.0d0 ) then
         return ! Economic return
      else if( min_quality >= 0.5d0 ) then
         str_level = "I"
      else if( min_quality > 0.0d0 ) then
         str_level = "W"
      else ! min_quality = 0.0d0
         str_level = "E"
      end if

      i_min_quality(:) = minloc( quality )
      write( string2, "(I0)" ) i_min_quality(1)

      if( iter_not_time ) then

         if( present(time) ) then
            write(STDERR,"(1X,A)") "(MUESLI Ode/Daesolve:) post_chk_der: internal error"
            write(STDERR,"(1X,A)") "                       'iter' and 'time' cannot be present together!"
            call msPause() ! for debugging purpose
            stop
         end if

         write( str_iter, "(I0)" ) iter
         if( iter < 10 ) then
            str_iter = "00" // str_iter(1:1)
         else if( iter < 100 ) then
            str_iter = "0" // str_iter(1:2)
         end if

         str = "iteration: " // str_iter

      else ! time_not_iter

         write( str_time, "(ES13.6)" ) time

         str = "time: " // str_time

      end if

      mf_traceback_level_save = mf_traceback_level
      mf_traceback_level = 0
      call PrintMessage( trim(routine_name), str_level,                 &
                         trim(str) )
      mf_traceback_level = mf_traceback_level_save

      ! information sent to the user
      if( print_check_jac == 1 ) then
         ! write information on screen
         call msDisplay( .t. mf(quality), "quality" )
      else if( print_check_jac == 2 ) then
         ! write information in a file
         filename = trim(routine_name)
         if( iter_not_time ) then
            filename = trim(filename) // "_quality_iter=" // str_iter // ".res"
         else ! time_not_iter
            filename = trim(filename) // "_jac_quality.res"
         end if
         call msSaveAscii( trim(filename), .t. mf(quality) )
      end if

      mf_traceback_level_save = mf_traceback_level
      mf_traceback_level = 0
      if( min_quality == 1.0d0 ) then
         call PrintMessage( trim(routine_name), str_level,              &
                            "user jacobian appears as",                 &
                            "numerically good." )
      else if( min_quality >= 0.5d0 ) then
         call PrintMessage( trim(routine_name), str_level,              &
                            "user jacobian appears as",                 &
                            "probably correct (not sure, however)." )
      else if( min_quality > 0.0d0 ) then
         call PrintMessage( trim(routine_name), str_level,              &
                            "user jacobian appears as",                 &
                            "probably *** incorrect ***!" )
      else ! min_quality = 0.0d0
         call PrintMessage( trim(routine_name), str_level,              &
                            "user jacobian appears as",                 &
                            "certainly *** wrong ***!" )
      end if
      mf_traceback_level = mf_traceback_level_save

      if( NAMED_EQN_PRESENCE ) then
         call search_index_in_eqn_groups( i_min_quality(1), i_eqn_group, &
                                                            i_group_eqn )
         write(i_group_eqn_str,"(I0)") i_group_eqn
         call PrintMessage( trim(routine_name), str_level,              &
                            "quick check of the user jacobian:",        &
                            "  min. of quality vector is: " // trim(string1), &
                            "and occurs for named equation ",           &
                            "  '" // trim(NAMED_EQN_PTR(i_eqn_group)%name) // "'" &
                            // " (num: " // trim(i_group_eqn_str) // ")", &
                            no_pause=.true. )
      else
         call PrintMessage( trim(routine_name), str_level,              &
                            "quick check of the user jacobian:",        &
                            "  min. of quality vector is: " // trim(string1), &
                            "    and occurs for equation: " // trim(string2), &
                            " " )
      end if

#endif
   end subroutine post_chk_der
!_______________________________________________________________________
!
   subroutine post_full_chk_der( routine_name, M, N, err,               &
                                 print_check_jac, iter, time )

      character(len=*), intent(in) :: routine_name
      integer,          intent(in) :: M, N, print_check_jac
      real,             intent(in) :: err(M,N)

      ! for LsqNonLin and FSolve
      integer, intent(in), optional :: iter

      ! for OdeSolve and DaeSolve
      double precision, intent(in), optional :: time
      !------ API end ------

#ifdef _DEVLP
      !---------------------------------

      ! *******************************************************************
      ! ** this is when check_jac = 2 (i.e. full check of the jacobian)  **
      ! *******************************************************************

      logical :: iter_not_time

      ! single precision is sufficient
      real :: max_err

      character(len=20) :: string1, string2, str
      integer :: ij_max_err(2)
      character :: str_level
      character(len=3) :: str_iter
      character(len=13) :: str_time
      character(len=30) :: filename
      integer :: mf_traceback_level_save
      logical :: msg_to_be_displayed

      integer :: i_eqn_group, i_group_eqn, i_var_group, i_group_var
      character(len=10) :: i_group_eqn_str, i_group_var_str

      !---------------------------------

      if( present(iter) ) then
         iter_not_time = .true.
      else if( present(time) ) then
         iter_not_time = .false.
      else
         write(STDERR,"(1X,A)") "(MUESLI Ode/Daesolve:) post_full_chk_der: internal error"
         write(STDERR,"(1X,A)") "                       'iter' or 'time' must be present!"
         call msPause() ! for debugging purpose
         stop
      end if

      ! relative error
      max_err = maxval( err )
      write( string1, "(ES11.3)" ) max_err
      ij_max_err(:) = maxloc( err )
      write( string2, "(I0,2X,I0)" ) ij_max_err(:)

      ! diagnostic
      if( max_err > 1.0e-1 ) then
         str_level = "E"
      else if( max_err < 1.0e-6 ) then
         str_level = "I"
      else
         str_level = "W"
      end if

      if( iter_not_time ) then

         if( present(time) ) then
            write(STDERR,"(1X,A)") "(MUESLI Ode/Daesolve:) post_full_chk_der: internal error"
            write(STDERR,"(1X,A)") "                       'iter' and 'time' cannot be present together!"
            call msPause() ! for debugging purpose
            stop
         end if

         write( str_iter, "(I0)" ) iter
         if( iter < 10 ) then
            str_iter = "00" // str_iter(1:1)
         else if( iter < 100 ) then
            str_iter = "0" // str_iter(1:2)
         end if

         str = "iteration: " // str_iter

      else ! time_not_iter

         write( str_time, "(ES13.6)" ) time

         str = "time: " // str_time

      end if

      mf_traceback_level_save = mf_traceback_level
      mf_traceback_level = 0
      call PrintMessage( trim(routine_name), str_level,                 &
                         trim(str) )
      mf_traceback_level = mf_traceback_level_save

      msg_to_be_displayed = .false.
      ! information sent to the user
      if( print_check_jac == 1 ) then
         ! write information on screen
         call msDisplay( mf(err), "errors in the jacobian" )
      else if( print_check_jac == 2 ) then
         ! write information in a file
         filename = trim(routine_name)
         if( iter_not_time ) then
            filename = trim(filename) // "_jac_err_iter=" // str_iter // ".res"
         else ! time_not_iter
            filename = trim(filename) // "_jac_err.res"
         end if
         call msSaveAscii( trim(filename), mf(err) )
         if( .not. iter_not_time ) then
            ! message is delayed at the end...
            msg_to_be_displayed = .true.
         end if
      end if

      mf_traceback_level_save = mf_traceback_level
      mf_traceback_level = 0
      if( max_err > 1.0e-1 ) then
         call PrintMessage( trim(routine_name), str_level,              &
                   "user jacobian appears as pretty *** wrong ***!",    &
                   "(max. of relative error is greater than 10 %)" )
      else if( max_err < 1.0e-6 ) then
         call PrintMessage( trim(routine_name), str_level,              &
                   "user jacobian appears as pretty *** good ***!",     &
                   "(max. of relative error is less than 1e-4 %)" )
      else
         call PrintMessage( trim(routine_name), str_level,              &
                   "user jacobian appears as more or less accurate!",   &
                   "(use another option to inspect the err matrix)" )
      end if
      mf_traceback_level = mf_traceback_level_save

      if( NAMED_EQN_PRESENCE ) then
         call search_index_in_eqn_groups( ij_max_err(1), i_eqn_group,   &
                                                         i_group_eqn )
         write(i_group_eqn_str,"(I0)") i_group_eqn
         if( NAMED_VAR_PRESENCE ) then
            call search_index_in_var_groups( ij_max_err(2), i_var_group, &
                                                            i_group_var )
            write(i_group_var_str,"(I0)") i_group_var
            call PrintMessage( trim(routine_name), str_level,           &
                      "full check of the user jacobian:",               &
                      "  max. relat. error is: " // trim(string1),      &
                      "and occurs for: named equation ",                &
                      "  '" // trim(NAMED_EQN_PTR(i_eqn_group)%name) // "'" &
                      // " (num: " // trim(i_group_eqn_str) // ")",     &
                      "                named variable ",                &
                      "  '" // trim(NAMED_VAR_PTR(i_var_group)%name) // "'" &
                      // " (num: " // trim(i_group_var_str) // ")",     &
                      no_pause=.true. )
         else
            call PrintMessage( trim(routine_name), str_level,           &
                      "full check of the user jacobian:",               &
                      "  max. relat. error is: " // trim(string1),      &
                      "and occurs for named equation ",                 &
                      "  '" // trim(NAMED_EQN_PTR(i_eqn_group)%name) // "'" &
                      // " (num: " // trim(i_group_eqn_str) // ")",     &
                      no_pause=.true. )
         end if
      else
         call PrintMessage( trim(routine_name), str_level,              &
                   "full check of the user jacobian:",                  &
                   "  max. relat. error is: " // trim(string1),         &
                   "  and occurs at (row,col): " // trim(string2),      &
                   " " )
      end if

      if( msg_to_be_displayed ) then
         print *, " -> the jacobian in " // trim(routine_name) //       &
                  " has been checked..."
         call msPause( "     you can now inspect the file: '" //        &
                       trim(filename) // "'" )
      end if

#endif
   end subroutine post_full_chk_der
!_______________________________________________________________________
!
end module mod_fileio
