! f90 include file

!_______________________________________________________________________
!
   function seq_from( start ) result( seq )

      integer, intent(in) :: start
      integer             :: seq
      !------ API end ------

#ifdef _DEVLP
      ! implements:  .from. start

   !------ end of declarations -- execution starts hereafter  ------

      seq = start

#endif
   end function seq_from
!_______________________________________________________________________
!
   function seq_from_to( start, end ) result( seq )

      integer, intent(in) :: start
      integer, intent(in) :: end
      type(seq_def)       :: seq
      !------ API end ------

#ifdef _DEVLP
      ! implements:  start .to. end

   !------ end of declarations -- execution starts hereafter  ------

      seq%start_1 = start
      seq%end_1   = end

#endif
   end function seq_from_to
!_______________________________________________________________________
!
   function seq_range_to( range, end ) result( seq )

      type(seq_def), intent(in) :: range
      integer,       intent(in) :: end
      type(seq_def)             :: seq
      !------ API end ------

#ifdef _DEVLP
      ! implements:  range .to. end

   !------ end of declarations -- execution starts hereafter  ------

      ! this operation must concern the first part only
      if( range%end_2 /= 0 ) then
         if( mf_message_level >= 1 ) then
            write(STDERR,*) "(MUESLI operator(.to.):) ERROR: bad definition sequence!"
            mf_message_displayed = .true.
            call muesli_trace( pause ="yes" )
         end if
         return
      end if

      seq       = range
      seq%end_1 = end

#endif
   end function seq_range_to
!_______________________________________________________________________
!
   function seq_range_by( range, step ) result( seq )

      type(seq_def), intent(in) :: range
      integer,       intent(in) :: step
      type(seq_def)             :: seq
      !------ API end ------

#ifdef _DEVLP
      ! implements:  range .by. step

   !------ end of declarations -- execution starts hereafter  ------

      ! this operation must concern the first part only
      if( range%end_2 /= 0 ) then
         if( mf_message_level >= 1 ) then
            write(STDERR,*) "(MUESLI operator(.by.):) ERROR: bad definition sequence!"
            mf_message_displayed = .true.
            call muesli_trace( pause ="yes" )
         end if
         return
      end if

      seq        = range
      seq%step_1 = step

#endif
   end function seq_range_by
!_______________________________________________________________________
!
   function seq_from_by( start, step ) result( seq )

      integer, intent(in) :: start
      integer, intent(in) :: step
      type(seq_def)       :: seq
      !------ API end ------

#ifdef _DEVLP
      ! implements:  start .by. step

   !------ end of declarations -- execution starts hereafter  ------

      seq%start_1 = start
      seq%step_1  = step

#endif
   end function seq_from_by
!_______________________________________________________________________
!
   function seq_range_but( range, i ) result( seq )

      type(seq_def), intent(in) :: range
      integer,       intent(in) :: i
      type(seq_def)             :: seq
      !------ API end ------

#ifdef _DEVLP
      logical :: found
      integer :: j, end_1

      ! implements:  range .but. i

   !------ end of declarations -- execution starts hereafter  ------

      ! this operation must concern the first part only
      if( range%end_2 /= 0 ) then
         if( mf_message_level >= 1 ) then
            write(STDERR,*) "(MUESLI operator(.but.):) ERROR: bad definition sequence!"
            mf_message_displayed = .true.
            call muesli_trace( pause ="yes" )
         end if
         return
      end if

      seq = range

      if( seq%start_1_EndIndex .or. seq%end_1_EndIndex ) then
         ! process of the .but. operator must be delayed inside mfGet or msSet
         seq%but_present = .true.
         seq%but = i
         return
      end if

      if( i < range%start_1 .or. range%end_1 < i ) then
         if( mf_message_level == 3 ) then
            write(STDERR,*) "(MUESLI operator(.but.):) info: integer is out of range!"
         end if
         return
      end if

      ! index 'i' is in 'range', but maybe not present (due to a step /= 1)
      found = .false.
      end_1 = 0
      seq%start_2 = 0
      do j = seq%start_1, seq%end_1, seq%step_1
         if( j < i ) then
            end_1 = j
         else if( j == i ) then
            found = .true.
         else ! j > i
            seq%start_2 = j
            exit
         end if
      end do
      if( .not. found ) return

      if( end_1 == 0 ) then
         if( seq%start_2 == 0 ) then
            write(STDERR,*) "(MUESLI operator(.but.):) Warning: empty sequence!"
            seq%start_1 = 1
            seq%end_1 = 0
            seq%start_2 = 1
            seq%end_2 = 0
         else
            ! first item of sequence has been removed
            seq%start_1 = seq%start_2
         end if
      else
         if( seq%start_2 == 0 ) then
            ! last item of sequence has been removed
            seq%end_1  = end_1
            seq%start_2 = 1
         else
            ! general case. (seq%start_2 is already defined)
            seq%step_2 = seq%step_1
            seq%end_2  = seq%end_1
            seq%end_1  = end_1 ! must be the last statement
         end if
      end if

#endif
   end function seq_range_but
!_______________________________________________________________________
!
   function seq_range_and_range( seq_1, seq_2 ) result( seq )

      type(seq_def), intent(in) :: seq_1, seq_2
      type(seq_def)             :: seq
      !------ API end ------

#ifdef _DEVLP
      ! implements:  range .and. range

   !------ end of declarations -- execution starts hereafter  ------

      ! this operation must concern the first part only
      if( seq_1%end_2 /= 0 ) then
         if( mf_message_level >= 1 ) then
            write(STDERR,*) "(MUESLI operator(.and.):) ERROR: bad definition for first sequence!"
            mf_message_displayed = .true.
            call muesli_trace( pause ="yes" )
         end if
         return
      end if
      if( seq_2%end_2 /= 0 ) then
         if( mf_message_level >= 1 ) then
            write(STDERR,*) "(MUESLI operator(.and.):) ERROR: bad definition for second sequence!"
            mf_message_displayed = .true.
            call muesli_trace( pause ="yes" )
         end if
         return
      end if

      seq%start_1 = seq_1%start_1
      seq%end_1   = seq_1%end_1
      seq%step_1  = seq_1%step_1
      seq%start_1_EndIndex = seq_1%start_1_EndIndex
      seq%end_1_EndIndex   = seq_1%end_1_EndIndex

      seq%start_2 = seq_2%start_1
      seq%end_2   = seq_2%end_1
      seq%step_2  = seq_2%step_1
      seq%start_2_EndIndex = seq_2%start_1_EndIndex
      seq%end_2_EndIndex   = seq_2%end_1_EndIndex

#endif
   end function seq_range_and_range
!_______________________________________________________________________
!
   function seq_range_and_int( seq_1, i ) result( seq )

      type(seq_def), intent(in) :: seq_1
      integer,       intent(in) :: i
      type(seq_def)             :: seq
      !------ API end ------

#ifdef _DEVLP
      ! implements:  range .and. i

   !------ end of declarations -- execution starts hereafter  ------

      ! this operation must concern the first part only
      if( seq_1%end_2 /= 0 ) then
         if( mf_message_level >= 1 ) then
            write(STDERR,*) "(MUESLI operator(.and.):) ERROR: bad definition for first sequence!"
            mf_message_displayed = .true.
            call muesli_trace( pause ="yes" )
         end if
         return
      end if

      seq%start_1 = seq_1%start_1
      seq%end_1   = seq_1%end_1
      seq%step_1  = seq_1%step_1
      seq%start_1_EndIndex = seq_1%start_1_EndIndex
      seq%end_1_EndIndex   = seq_1%end_1_EndIndex

      seq%start_2 = i
      seq%end_2   = i
      seq%step_2  = 1

#endif
   end function seq_range_and_int
!_______________________________________________________________________
!
   function seq_int_and_range( i, seq_2 ) result( seq )

      integer,       intent(in) :: i
      type(seq_def), intent(in) :: seq_2
      type(seq_def)             :: seq
      !------ API end ------

#ifdef _DEVLP
      ! implements:  i .and. range

   !------ end of declarations -- execution starts hereafter  ------

      ! this operation must concern the first part only
      if( seq_2%end_2 /= 0 ) then
         if( mf_message_level >= 1 ) then
            write(STDERR,*) "(MUESLI operator(.and.):) ERROR: bad definition for second sequence!"
            mf_message_displayed = .true.
            call muesli_trace( pause ="yes" )
         end if
         return
      end if

      seq%start_1 = i
      seq%end_1   = i
      seq%step_1  = 1

      seq%start_2 = seq_2%start_1
      seq%end_2   = seq_2%end_1
      seq%step_2  = seq_2%step_1
      seq%start_2_EndIndex = seq_2%start_1_EndIndex
      seq%end_2_EndIndex   = seq_2%end_1_EndIndex

#endif
   end function seq_int_and_range
!_______________________________________________________________________
!
   subroutine build_int_seq( int_tab, seq, calling_routine )

      type(seq_def),    intent(in) :: seq
      integer, pointer             :: int_tab(:)
      character(len=*), intent(in) :: calling_routine
      !------ API end ------

#ifdef _DEVLP
      integer :: i, j, n

   !------ end of declarations -- execution starts hereafter  ------

      n = 0
      if( seq%but_present ) then
         do i = seq%start_1, seq%end_1, seq%step_1
            if( i == seq%but ) cycle
            n = n + 1
         end do
         do i = seq%start_2, seq%end_2, seq%step_2
            if( i == seq%but ) cycle
            n = n + 1
         end do
      else
         do i = seq%start_1, seq%end_1, seq%step_1
            n = n + 1
         end do
         do i = seq%start_2, seq%end_2, seq%step_2
            n = n + 1
         end do
      end if

#ifndef _TRACE_MEM_ALLOC
      allocate( int_tab(n) ) ! include the failed case n=0 (empty sequence),
                             ! which will be processed in msSet and mfGet.
#else
      call mf_allocate( array=int_tab, n=n,                             &
                        file="seq_def.inc", line="???",                 &
                        symb="int_tab", unit="build_int_seq" )
#endif

      if( n == 0 ) then
         if( mf_message_level == 3 ) then
            write(STDERR,*) "(MUESLI " // trim(calling_routine) // ":) info: empty sequence!"
         end if
         return
      end if

      if( seq%but_present ) then
         if( seq%but < seq%start_1 .or. seq%end_1 < seq%but ) then
            if( mf_message_level == 3 ) then
               write(STDERR,*) "(MUESLI operator(.but.):) info: integer is out of range!"
            end if
            return
         end if
      end if

      j = 0
      if( seq%but_present ) then
         do i = seq%start_1, seq%end_1, seq%step_1
            if( i == seq%but ) cycle
            j = j + 1
            int_tab(j) = i
         end do
      else
         do i = seq%start_1, seq%end_1, seq%step_1
            j = j + 1
            int_tab(j) = i
         end do
         do i = seq%start_2, seq%end_2, seq%step_2
            j = j + 1
            int_tab(j) = i
         end do
      end if

#endif
   end subroutine build_int_seq
