! f90 include file

!_______________________________________________________________________
!
   subroutine realloc_vec_int( vec, n, ncopy )

      integer, pointer :: vec(:)
      integer, intent(in) :: n
      integer, intent(in), optional :: ncopy
      !------ API end ------

#ifdef _DEVLP
      ! If the optional argument 'ncopy' is present, only a subpart
      ! of the vector is copied (useful for the sparse case)

      integer, pointer :: tmp(:)
      integer :: n_old

   !------ end of declarations -- execution starts hereafter  ------

      ! The value of 'n' must be checked in the calling program.
      ! Here, if the new dimension 'n' is less than the older one,
      ! some data are lost!
      ! id. for 'ncopy'; we must have: ncopy <= min(n_old,n)
#ifndef _TRACE_MEM_ALLOC
      allocate( tmp(n) )
#else
      call mf_allocate( array=tmp, n=n,                                 &
                        file="realloc.inc", line="???",                 &
                        symb="tmp", unit="realloc_vec_int" )
#endif
      if( associated(vec) ) then
         if( present(ncopy) ) then
            tmp(1:ncopy) = vec(1:ncopy)
         else
            n_old = size(vec)
            if( n >= n_old ) then
               tmp(1:n_old) = vec(:)
            else ! n < n_old
               tmp(:) = vec(1:n)
            end if
         end if
#ifndef _TRACE_MEM_ALLOC
         deallocate( vec )
#else
         call mf_deallocate( array=vec,                                 &
                             file="realloc.inc", line="???",            &
                             symb="vec", unit="realloc_vec_int" )
#endif
      end if
      vec => tmp

#endif
   end subroutine realloc_vec_int
!_______________________________________________________________________
!
   subroutine realloc_vec_real8( vec, n, ncopy )

      real(kind=MF_DOUBLE), pointer :: vec(:)
      integer, intent(in) :: n
      integer, intent(in), optional :: ncopy
      !------ API end ------

#ifdef _DEVLP
      ! If the optional argument 'ncopy' is present, only a subpart
      ! of the vector is copied (useful for the sparse case)

      real(kind=MF_DOUBLE), pointer :: tmp(:)
      integer :: n_old

   !------ end of declarations -- execution starts hereafter  ------

      ! The value of 'n' must be checked in the calling program.
      ! Here, if the new dimension 'n' is less than the older one,
      ! some data are lost!
      ! id. for 'ncopy'; we must have: ncopy <= min(n_old,n)
#ifndef _TRACE_MEM_ALLOC
      allocate( tmp(n) )
#else
      call mf_allocate( array=tmp, n=n,                                 &
                        file="realloc.inc", line="???",                 &
                        symb="tmp", unit="realloc_vec_real8" )
#endif
      if( associated(vec) ) then
         if( present(ncopy) ) then
            tmp(1:ncopy) = vec(1:ncopy)
         else
            n_old = size(vec)
            if( n >= n_old ) then
               tmp(1:n_old) = vec(:)
            else ! n < n_old
               tmp(:) = vec(1:n)
            end if
         end if
#ifndef _TRACE_MEM_ALLOC
         deallocate( vec )
#else
         call mf_deallocate( array=vec,                                 &
                             file="realloc.inc", line="???",            &
                             symb="vec", unit="realloc_vec_real8" )
#endif
      end if
      vec => tmp

#endif
   end subroutine realloc_vec_real8
!_______________________________________________________________________
!
   subroutine realloc_vec_cmplx( vec, n, ncopy )

      complex(kind=MF_DOUBLE), pointer :: vec(:)
      integer, intent(in) :: n
      integer, intent(in), optional :: ncopy
      !------ API end ------

#ifdef _DEVLP
      ! If the optional argument 'ncopy' is present, only a subpart
      ! of the vector is copied (useful for the sparse case)

      complex(kind=MF_DOUBLE), pointer :: tmp(:)
      integer :: n_old

   !------ end of declarations -- execution starts hereafter  ------

      ! The value of 'n' must be checked in the calling program.
      ! Here, if the new dimension 'n' is less than the older one,
      ! some data are lost!
      ! id. for 'ncopy'; we must have: ncopy <= min(n_old,n)
#ifndef _TRACE_MEM_ALLOC
      allocate( tmp(n) )
#else
      call mf_allocate( array=tmp, n=n,                                 &
                        file="realloc.inc", line="???",                 &
                        symb="tmp", unit="realloc_vec_cmplx" )
#endif
      if( associated(vec) ) then
         if( present(ncopy) ) then
            tmp(1:ncopy) = vec(1:ncopy)
         else
            n_old = size(vec)
            if( n >= n_old ) then
               tmp(1:n_old) = vec(:)
            else ! n < n_old
               tmp(:) = vec(1:n)
            end if
         end if
#ifndef _TRACE_MEM_ALLOC
         deallocate( vec )
#else
         call mf_deallocate( array=vec,                                 &
                             file="realloc.inc", line="???",            &
                             symb="vec", unit="realloc_vec_cmplx" )
#endif
      end if
      vec => tmp

#endif
   end subroutine realloc_vec_cmplx
!_______________________________________________________________________
!
   subroutine realloc_vec_real8_to_cmplx( vec, cmplx, n, ncopy )

      real(kind=MF_DOUBLE), pointer :: vec(:)
      complex(kind=MF_DOUBLE), pointer :: cmplx(:)
      integer, intent(in) :: n
      integer, intent(in), optional :: ncopy
      !------ API end ------

#ifdef _DEVLP
      ! If the optional argument 'ncopy' is present, only a subpart
      ! of the vector is copied (useful for the sparse case)

      complex(kind=MF_DOUBLE), pointer :: tmp(:)
      integer :: n_old

   !------ end of declarations -- execution starts hereafter  ------

      ! The value of 'n' must be checked in the calling program.
      ! Here, if the new dimension 'n' is less than the older one,
      ! some data are lost!
      ! id. for 'ncopy'; we must have: ncopy <= min(n_old,n)
#ifndef _TRACE_MEM_ALLOC
      allocate( tmp(n) )
#else
      call mf_allocate( array=tmp, n=n,                                 &
                        file="realloc.inc", line="???",                 &
                        symb="tmp", unit="realloc_vec_real8_to_cmplx" )
#endif
      if( associated(vec) ) then
         if( present(ncopy) ) then
            tmp(1:ncopy) = vec(1:ncopy)
         else
            n_old = size(vec)
            if( n >= n_old ) then
               tmp(1:n_old) = vec(:)
            else ! n < n_old
               tmp(:) = vec(1:n)
            end if
         end if
#ifndef _TRACE_MEM_ALLOC
         deallocate( vec )
#else
         call mf_deallocate( array=vec,                                 &
                             file="realloc.inc", line="???",            &
                             symb="vec", unit="realloc_vec_real8_to_cmplx" )
#endif
         vec => null()
      end if
      cmplx => tmp

#endif
   end subroutine realloc_vec_real8_to_cmplx
!_______________________________________________________________________
!
   subroutine realloc_array_real8( array, n1, n2, fill )

      real(kind=MF_DOUBLE), pointer :: array(:,:)
      integer, intent(in) :: n1, n2
      real(kind=MF_DOUBLE), intent(in), optional :: fill
      !------ API end ------

#ifdef _DEVLP
      real(kind=MF_DOUBLE), pointer :: tmp(:,:)
      integer :: n1_old, n2_old
      character(len=11) :: str_11

   !------ end of declarations -- execution starts hereafter  ------

      ! The values (n1,n2) must be checked in the calling program.
      ! Here, if the new dimensions n1 and n2 are less than the olders,
      ! some data are lost!

#ifndef _TRACE_MEM_ALLOC
      allocate( tmp(n1,n2) )
#else
      call mf_allocate( array=tmp, m=n1, n=n2,                          &
                        file="realloc.inc", line="???",                 &
                        symb="tmp", unit="realloc_array_real8" )
#endif

      ! we are sure that the current routine is called from 'msSet',
      ! so we can print a warning with this reference...
      if( present(fill) ) then
         write(str_11,"(ES11.4)") fill
         call PrintMessage( "msSet", "I",                               &
                            "some indexes was out-of-range, and the mfArray has", &
                            "been reallocated, and new elements are initialized", &
                            "using the value: " // str_11 )
      else
         call PrintMessage( "msSet", "W",                               &
                            "some indexes was out-of-range, and the mfArray has", &
                            "been reallocated... but the new elements have not", &
                            "been initialized (they can contain any number)!" )
      end if

      if( associated(array) ) then
         n1_old = size(array,1)
         n2_old = size(array,2)
         if( n1 >= n1_old ) then
            if( n2 >= n2_old ) then
               tmp(1:n1_old,1:n2_old) = array(:,:)
               if( present(fill) ) then
                  tmp(n1_old+1:n1,1:n2_old) = fill
                  tmp(:,n2_old+1:n2) = fill
               end if
            else ! n2 < n2_old
               tmp(1:n1_old,:) = array(:,1:n2)
               if( present(fill) ) then
                  tmp(n1_old+1:n1,:) = fill
               end if
            end if
         else ! n1 < n1_old
            if( n2 >= n2_old ) then
               tmp(:,1:n2_old) = array(1:n1,:)
               if( present(fill) ) then
                  tmp(:,n2_old+1:n2) = fill
               end if
            else ! n2 < n2_old
               tmp(:,:) = array(1:n1,1:n2)
            end if
         end if
#ifndef _TRACE_MEM_ALLOC
         deallocate( array )
#else
         call mf_deallocate( array=array,                               &
                             file="realloc.inc", line="???",            &
                             symb="array", unit="realloc_array_real8" )
#endif
      else
         if( present(fill) ) then
            tmp(:,:) = fill
         end if
      end if
      array => tmp

#endif
   end subroutine realloc_array_real8
!_______________________________________________________________________
!
   subroutine realloc_array_cmplx( array, n1, n2, fill )

      complex(kind=MF_DOUBLE), pointer :: array(:,:)
      integer, intent(in) :: n1, n2
      complex(kind=MF_DOUBLE), intent(in), optional :: fill
      !------ API end ------

#ifdef _DEVLP
      complex(kind=MF_DOUBLE), pointer :: tmp(:,:)
      integer :: n1_old, n2_old
      character(len=25) :: str_25

   !------ end of declarations -- execution starts hereafter  ------

      ! The values (n1,n2) must be checked in the calling program.
      ! Here, if the new dimensions n1 and n2 are less than the olders,
      ! some data are lost!

#ifndef _TRACE_MEM_ALLOC
      allocate( tmp(n1,n2) )
#else
      call mf_allocate( array=tmp, m=n1, n=n2,                          &
                        file="realloc.inc", line="???",                 &
                        symb="tmp", unit="realloc_array_cmplx" )
#endif

      ! we are sure that the current routine is called from 'msSet',
      ! so we can print a warning with this reference...
      if( present(fill) ) then
         write(str_25,"('(',ES11.4,',',ES11.4,')')") fill
         call PrintMessage( "msSet", "I",                               &
                            "some indexes was out-of-range, and the mfArray has", &
                            "been reallocated, and new elements are initialized", &
                            "using the complex value: " // str_25 )
      else
         call PrintMessage( "msSet", "W",                               &
                            "some indexes was out-of-range, and the mfArray has", &
                            "been reallocated... but the new elements have not", &
                            "been initialized (they can contain any number)!" )
      end if

      if( associated(array) ) then
         n1_old = size(array,1)
         n2_old = size(array,2)
         if( n1 >= n1_old ) then
            if( n2 >= n2_old ) then
               tmp(1:n1_old,1:n2_old) = array(:,:)
               if( present(fill) ) then
                  tmp(n1_old+1:n1,1:n2_old) = fill
                  tmp(:,n2_old+1:n2) = fill
               end if
            else ! n2 < n2_old
               tmp(1:n1_old,:) = array(:,1:n2)
               if( present(fill) ) then
                  tmp(n1_old+1:n1,:) = fill
               end if
            end if
         else ! n1 < n1_old
            if( n2 >= n2_old ) then
               tmp(:,1:n2_old) = array(1:n1,:)
               if( present(fill) ) then
                  tmp(:,n2_old+1:n2) = fill
               end if
            else ! n2 < n2_old
               tmp(:,:) = array(1:n1,1:n2)
            end if
         end if
#ifndef _TRACE_MEM_ALLOC
         deallocate( array )
#else
         call mf_deallocate( array=array,                               &
                             file="realloc.inc", line="???",            &
                             symb="array", unit="realloc_array_cmplx" )
#endif
      else
         if( present(fill) ) then
            tmp(:,:) = fill
         end if
      end if
      array => tmp

#endif
   end subroutine realloc_array_cmplx
!_______________________________________________________________________
!
   subroutine realloc_array_real8_to_cmplx( array, cmplx, n1, n2, fill )

      real(kind=MF_DOUBLE), pointer :: array(:,:)
      complex(kind=MF_DOUBLE), pointer :: cmplx(:,:)
      integer, intent(in) :: n1, n2
      complex(kind=MF_DOUBLE), intent(in), optional :: fill
      !------ API end ------

#ifdef _DEVLP
      complex(kind=MF_DOUBLE), pointer :: tmp(:,:)
      integer :: n1_old, n2_old
      character(len=25) :: str_25

   !------ end of declarations -- execution starts hereafter  ------

      ! The values (n1,n2) must be checked in the calling program.
      ! Here, if the new dimensions n1 and n2 are less than the olders,
      ! some data are lost!

#ifndef _TRACE_MEM_ALLOC
      allocate( tmp(n1,n2) )
#else
      call mf_allocate( array=tmp, m=n1, n=n2,                          &
                        file="realloc.inc", line="???",                 &
                        symb="tmp", unit="realloc_array_real8_to_cmplx" )
#endif

      ! we are sure that the current routine is called from 'msSet',
      ! so we can print a warning with this reference...
      if( present(fill) ) then
         write(str_25,"('(',ES11.4,',',ES11.4,')')") fill
         call PrintMessage( "msSet", "I",                               &
                            "some indexes was out-of-range, and the mfArray has", &
                            "been reallocated, and new elements are initialized", &
                            "using the complex value: " // str_25 )
      else
         call PrintMessage( "msSet", "W",                               &
                            "some indexes was out-of-range, and the mfArray has", &
                            "been reallocated... but the new elements have not", &
                            "been initialized (they can contain any number)!" )
      end if

      if( associated(array) ) then
         n1_old = size(array,1)
         n2_old = size(array,2)
         if( n1 >= n1_old ) then
            if( n2 >= n2_old ) then
               tmp(1:n1_old,1:n2_old) = array(:,:)
               if( present(fill) ) then
                  tmp(n1_old+1:n1,1:n2_old) = fill
                  tmp(:,n2_old+1:n2) = fill
               end if
            else ! n2 < n2_old
               tmp(1:n1_old,:) = array(:,1:n2)
               if( present(fill) ) then
                  tmp(n1_old+1:n1,:) = fill
               end if
            end if
         else ! n1 < n1_old
            if( n2 >= n2_old ) then
               tmp(:,1:n2_old) = array(1:n1,:)
               if( present(fill) ) then
                  tmp(:,n2_old+1:n2) = fill
               end if
            else ! n2 < n2_old
               tmp(:,:) = array(1:n1,1:n2)
            end if
         end if
#ifndef _TRACE_MEM_ALLOC
         deallocate( array )
#else
         call mf_deallocate( array=array,                               &
                             file="realloc.inc", line="???",            &
                             symb="array", unit="realloc_array_real8_to_cmplx" )
#endif
      else
         if( present(fill) ) then
            tmp(:,:) = fill
         end if
      end if
      cmplx => tmp

#endif
   end subroutine realloc_array_real8_to_cmplx
