! f90 include file

!_______________________________________________________________________
!
   recursive subroutine quick_sort_1( mode, A )

      character(len=3),     intent(in)     :: mode
      real(kind=MF_DOUBLE), intent(in out) :: A(:)
      !------ API end ------

#ifdef _DEVLP
      ! Recursive Fortran quicksort routine
      !   sorts real numbers into ascending (mode="asc") or
      !   descending (mode/="asc") numerical order
      ! -------------------
      ! modified (É. Canot) Oct 2013

      integer :: ipiv, n
      real(kind=MF_DOUBLE) :: temp

   !------ end of declarations -- execution starts hereafter  ------

      n = size(A)

      if( n > 2 ) then
         if( mode == "asc" ) then
            ! ascending
            call partition_sort_1_asc( A, ipiv )
         else
            ! descending
            call partition_sort_1_des( A, ipiv )
         end if
         if( 2 <= ipiv-1 ) then
            call quick_sort_1( mode, A(:ipiv-1) )
         end if
         if( ipiv+1 <= n-1 ) then
            call quick_sort_1( mode, A(ipiv+1:) )
         end if
      else if( n == 2 ) then
         if( mode == "asc" ) then
            ! ascending
            if( A(1) > A(2) ) then
               temp = A(1)
               A(1) = A(2)
               A(2) = temp
            end if
         else
            ! descending
            if( A(1) < A(2) ) then
               temp = A(1)
               A(1) = A(2)
               A(2) = temp
            end if
         end if
      end if

#endif
   end subroutine quick_sort_1
!_______________________________________________________________________
!
   subroutine partition_sort_1_asc( A, ipiv )

      real(kind=MF_DOUBLE), intent(in out) :: A(:)
      integer, intent(out) :: ipiv
      !------ API end ------

#ifdef _DEVLP
      ! Auxiliary routine for 'quick_sort_1'
      ! sorts real numbers into ascending numerical order
      ! -------------------
      ! corrected (É. Canot) and modified April 2008.

      integer :: i, j, n
      real(kind=MF_DOUBLE) :: temp
      real(kind=MF_DOUBLE) :: piv ! pivot

   !------ end of declarations -- execution starts hereafter  ------

      n = size(A)
      piv = A(n/2+1)
      i = 1
      j = n

      do
         do
            if( A(i) >= piv ) exit
            i = i + 1
         end do
         do
            if( A(j) <= piv ) exit
            j = j - 1
         end do
         if( i < j ) then
            if( A(i) /= A(j) ) then
               ! exchange A(i) and A(j)
               temp = A(i)
               A(i) = A(j)
               A(j) = temp
            else
               i = i + 1
            end if
         else
            if( A(i) == piv ) then
               ipiv = i
            else
               if( A(j) /= piv ) then
                  write(STDERR,*) "(MUESLI quick_sort:) internal ERROR:"
                  write(STDERR,*) "                     pb in partition_sort_1_asc"
                  mf_message_displayed = .true.
                  call muesli_trace( pause="yes" )
                  stop
               end if
               ipiv = j
            end if
            return
         end if
     end do

#endif
   end subroutine partition_sort_1_asc
!_______________________________________________________________________
!
   subroutine partition_sort_1_des( A, ipiv )

      real(kind=MF_DOUBLE), intent(in out) :: A(:)
      integer, intent(out) :: ipiv
      !------ API end ------

#ifdef _DEVLP
      ! Auxiliary routine for 'quick_sort_1'
      ! sorts real numbers into descending numerical order
      ! -------------------
      ! (É. Canot) Oct 2013

      integer :: i, j, n
      real(kind=MF_DOUBLE) :: temp
      real(kind=MF_DOUBLE) :: piv ! pivot

   !------ end of declarations -- execution starts hereafter  ------

      n = size(A)
      piv = A(n/2+1)
      i = 1
      j = n

      do
         do
            if( A(i) <= piv ) exit
            i = i + 1
         end do
         do
            if( A(j) >= piv ) exit
            j = j - 1
         end do
         if( i < j ) then
            if( A(i) /= A(j) ) then
               ! exchange A(i) and A(j)
               temp = A(i)
               A(i) = A(j)
               A(j) = temp
            else
               i = i + 1
            end if
         else
            if( A(i) == piv ) then
               ipiv = i
            else
               if( A(j) /= piv ) then
                  write(STDERR,*) "(MUESLI quick_sort:) internal ERROR:"
                  write(STDERR,*) "                     pb in partition_sort_1_des"
                  mf_message_displayed = .true.
                  call muesli_trace( pause="yes" )
                  stop
               end if
               ipiv = j
            end if
            return
         end if
     end do

#endif
   end subroutine partition_sort_1_des
!_______________________________________________________________________
!
   recursive subroutine quick_sort_2( mode, A, ind )

      character(len=3),     intent(in)     :: mode
      real(kind=MF_DOUBLE), intent(in out) :: A(:)
      real(kind=MF_DOUBLE), intent(in out) :: ind(:)
      !------ API end ------

#ifdef _DEVLP
      ! Recursive Fortran quicksort routine
      !   sorts real numbers into ascending (mode="asc") or
      !   descending (mode/="asc") numerical order
      ! -------------------
      ! modified (É. Canot) Oct 2013

      real(kind=MF_DOUBLE) :: temp
      integer :: ipiv, n

   !------ end of declarations -- execution starts hereafter  ------

      n = size(A)

      if( n > 2 ) then
         if( mode == "asc" ) then
            ! ascending
            call partition_sort_2_asc( A, ind, ipiv )
         else
            ! descending
            call partition_sort_2_des( A, ind, ipiv )
         end if
         if( 2 <= ipiv-1 ) then
            call quick_sort_2( mode, A(:ipiv-1), ind(:ipiv-1) )
         end if
         if( ipiv+1 <= n-1 ) then
            call quick_sort_2( mode, A(ipiv+1:), ind(ipiv+1:) )
         end if
      else if( n == 2 ) then
         if( mode == "asc" ) then
            ! ascending
            if( A(1) > A(2) ) then
               temp = A(1)
               A(1) = A(2)
               A(2) = temp
               temp = ind(1)
               ind(1) = ind(2)
               ind(2) = temp
            end if
         else
            ! descending
            if( A(1) < A(2) ) then
               temp = A(1)
               A(1) = A(2)
               A(2) = temp
               temp = ind(1)
               ind(1) = ind(2)
               ind(2) = temp
            end if
         end if
      end if

#endif
   end subroutine quick_sort_2
!_______________________________________________________________________
!
   subroutine partition_sort_2_asc( A, ind, ipiv )

      real(kind=MF_DOUBLE), intent(in out) :: A(:)
      real(kind=MF_DOUBLE), intent(in out) :: ind(:)
      integer,              intent(out) :: ipiv
      !------ API end ------

#ifdef _DEVLP
      ! Auxiliary routine for 'quick_sort_2'
      ! sorts real numbers into ascending numerical order
      ! -------------------
      ! corrected (É. Canot) and modified April 2008

      integer :: i, j, n
      real(kind=MF_DOUBLE) :: temp
      real(kind=MF_DOUBLE) :: piv      !pivot point

   !------ end of declarations -- execution starts hereafter  ------

      n = size(A)
      piv = A(n/2+1)
      i = 1
      j = n

      do
         do
            if( A(i) >= piv ) exit
            i = i + 1
         end do
         do
            if( A(j) <= piv ) exit
            j = j - 1
         end do
         if( i < j ) then
            if( A(i) /= A(j) ) then
               ! exchange A(i) and A(j)
               temp = A(i)
               A(i) = A(j)
               A(j) = temp

               temp = ind(i)
               ind(i) = ind(j)
               ind(j) = temp
            else
               i = i + 1
            end if
         else
            if( A(i) == piv ) then
               ipiv = i
            else
               if( A(j) /= piv ) then
                  write(STDERR,*) "(MUESLI quick_sort:) internal ERROR:"
                  write(STDERR,*) "                     pb in partition_sort_2_asc"
                  mf_message_displayed = .true.
                  call muesli_trace( pause="yes" )
                  stop
               end if
               ipiv = j
            end if
            return
         end if
     end do

#endif
   end subroutine partition_sort_2_asc
!_______________________________________________________________________
!
   subroutine partition_sort_2_des( A, ind, ipiv )

      real(kind=MF_DOUBLE), intent(in out) :: A(:)
      real(kind=MF_DOUBLE), intent(in out) :: ind(:)
      integer, intent(out) :: ipiv
      !------ API end ------

#ifdef _DEVLP
      ! Auxiliary routine for 'quick_sort_2'
      ! sorts real numbers into descending numerical order
      ! -------------------
      ! (É. Canot) Oct 2013

      integer :: i, j, n
      real(kind=MF_DOUBLE) :: temp
      real(kind=MF_DOUBLE) :: piv      !pivot point

   !------ end of declarations -- execution starts hereafter  ------

      n = size(A)
      piv = A(n/2+1)
      i = 1
      j = n

      do
         do
            if( A(i) <= piv ) exit
            i = i + 1
         end do
         do
            if( A(j) >= piv ) exit
            j = j - 1
         end do
         if( i < j ) then
            if( A(i) /= A(j) ) then
               ! exchange A(i) and A(j)
               temp = A(i)
               A(i) = A(j)
               A(j) = temp

               temp = ind(i)
               ind(i) = ind(j)
               ind(j) = temp
            else
               i = i + 1
            end if
         else
            if( A(i) == piv ) then
               ipiv = i
            else
               if( A(j) /= piv ) then
                  write(STDERR,*) "(MUESLI quick_sort:) internal ERROR:"
                  write(STDERR,*) "                     pb in partition_sort_2_des"
                  mf_message_displayed = .true.
                  call muesli_trace( pause="yes" )
                  stop
               end if
               ipiv = j
            end if
            return
         end if
     end do

#endif
   end subroutine partition_sort_2_des
!_______________________________________________________________________
!
   recursive subroutine quick_sort_3( mode, A, ind )

      character(len=3),     intent(in)     :: mode
      real(kind=MF_DOUBLE), intent(in out) :: A(:)
      integer,              intent(in out) :: ind(:)
      !------ API end ------

#ifdef _DEVLP
      ! Recursive Fortran quicksort routine
      !   sorts real numbers into ascending (mode="asc") or
      !   descending (mode/="asc") numerical order
      ! -------------------
      ! modified (É. Canot) Oct 2013

      real(kind=MF_DOUBLE) :: temp
      integer :: ipiv, n, itmp

   !------ end of declarations -- execution starts hereafter  ------

      n = size(A)

      if( n > 2 ) then
         if( mode == "asc" ) then
            ! ascending
            call partition_sort_3_asc( A, ind, ipiv )
         else
            ! descending
            call partition_sort_3_des( A, ind, ipiv )
         end if
         if( 2 <= ipiv-1 ) then
            call quick_sort_3( mode, A(:ipiv-1), ind(:ipiv-1) )
         end if
         if( ipiv+1 <= n-1 ) then
            call quick_sort_3( mode, A(ipiv+1:), ind(ipiv+1:) )
         end if
      else if( n == 2 ) then
         if( mode == "asc" ) then
            ! ascending
            if( A(1) > A(2) ) then
               temp = A(1)
               A(1) = A(2)
               A(2) = temp
               itmp = ind(1)
               ind(1) = ind(2)
               ind(2) = itmp
            end if
         else
            ! descending
            if( A(1) < A(2) ) then
               temp = A(1)
               A(1) = A(2)
               A(2) = temp
               itmp = ind(1)
               ind(1) = ind(2)
               ind(2) = itmp
            end if
         end if
      end if

#endif
   end subroutine quick_sort_3
!_______________________________________________________________________
!
   subroutine partition_sort_3_asc( A, ind, ipiv )

      real(kind=MF_DOUBLE), intent(in out) :: A(:)
      integer, intent(out) :: ind(:)
      integer, intent(out) :: ipiv
      !------ API end ------

#ifdef _DEVLP
      ! Auxiliary routine for 'quick_sort_3'
      ! sorts real numbers into ascending numerical order
      ! -------------------
      ! corrected (É. Canot) and modified April 2008

      integer :: i, j, itmp, n
      real(kind=MF_DOUBLE) :: temp
      real(kind=MF_DOUBLE) :: piv      !pivot point

   !------ end of declarations -- execution starts hereafter  ------

      n = size(A)
      piv = A(n/2+1)
      i = 1
      j = n

      do
         do
            if( A(i) >= piv ) exit
            i = i + 1
         end do
         do
            if( A(j) <= piv ) exit
            j = j - 1
         end do
         if( i < j ) then
            if( A(i) /= A(j) ) then
               ! exchange A(i) and A(j)
               temp = A(i)
               A(i) = A(j)
               A(j) = temp

               itmp = ind(i)
               ind(i) = ind(j)
               ind(j) = itmp
            else
               i = i + 1
            end if
         else
            if( A(i) == piv ) then
               ipiv = i
            else
               if( A(j) /= piv ) then
                  write(STDERR,*) "(MUESLI quick_sort:) internal ERROR:"
                  write(STDERR,*) "                     pb in partition_sort_3_asc"
                  mf_message_displayed = .true.
                  call muesli_trace( pause="yes" )
                  stop
               end if
               ipiv = j
            end if
            return
         end if
     end do

#endif
   end subroutine partition_sort_3_asc
!_______________________________________________________________________
!
   subroutine partition_sort_3_des( A, ind, ipiv )

      real(kind=MF_DOUBLE), intent(in out) :: A(:)
      integer, intent(out) :: ind(:)
      integer, intent(out) :: ipiv
      !------ API end ------

#ifdef _DEVLP
      ! Auxiliary routine for 'quick_sort_3'
      ! sorts real numbers into descending numerical order
      ! -------------------
      ! (É. Canot) Oct 2013

      integer :: i, j, itmp, n
      real(kind=MF_DOUBLE) :: temp
      real(kind=MF_DOUBLE) :: piv      !pivot point

   !------ end of declarations -- execution starts hereafter  ------

      n = size(A)
      piv = A(n/2+1)
      i = 1
      j = n

      do
         do
            if( A(i) <= piv ) exit
            i = i + 1
         end do
         do
            if( A(j) >= piv ) exit
            j = j - 1
         end do
         if( i < j ) then
            if( A(i) /= A(j) ) then
               ! exchange A(i) and A(j)
               temp = A(i)
               A(i) = A(j)
               A(j) = temp

               itmp = ind(i)
               ind(i) = ind(j)
               ind(j) = itmp
            else
               i = i + 1
            end if
         else
            if( A(i) == piv ) then
               ipiv = i
            else
               if( A(j) /= piv ) then
                  write(STDERR,*) "(MUESLI quick_sort:) internal ERROR:"
                  write(STDERR,*) "                     pb in partition_sort_3_des"
                  mf_message_displayed = .true.
                  call muesli_trace( pause="yes" )
                  stop
               end if
               ipiv = j
            end if
            return
         end if
     end do

#endif
   end subroutine partition_sort_3_des
!_______________________________________________________________________
!
   recursive subroutine quick_sort_1_int( mode, A )

      character(len=3), intent(in)     :: mode
      integer,          intent(in out) :: A(:)
      !------ API end ------

#ifdef _DEVLP
      ! Recursive Fortran quicksort routine
      !   sorts integer numbers into ascending (mode="asc") or
      !   descending (mode/="asc") numerical order
      ! -------------------
      ! modified (É. Canot) Oct 2013

      integer :: ipiv, n, itmp

   !------ end of declarations -- execution starts hereafter  ------

      n = size(A)

      if( n > 2 ) then
         if( mode == "asc" ) then
            ! ascending
            call partition_sort_1_int_asc( A, ipiv )
         else
            ! descending
            call partition_sort_1_int_des( A, ipiv )
         end if
         if( 2 <= ipiv-1 ) then
            call quick_sort_1_int( mode, A(:ipiv-1) )
         end if
         if( ipiv+1 <= n-1 ) then
            call quick_sort_1_int( mode, A(ipiv+1:) )
         end if
      else if( n == 2 ) then
         if( mode == "asc" ) then
            ! ascending
            if( A(1) > A(2) ) then
               itmp = A(1)
               A(1) = A(2)
               A(2) = itmp
            end if
         else
            ! descending
            if( A(1) < A(2) ) then
               itmp = A(1)
               A(1) = A(2)
               A(2) = itmp
            end if
         end if
      end if

#endif
   end subroutine quick_sort_1_int
!_______________________________________________________________________
!
   subroutine partition_sort_1_int_asc( A, ipiv )

      integer, intent(in out) :: A(:)
      integer, intent(out) :: ipiv
      !------ API end ------

#ifdef _DEVLP
      ! Auxiliary routine for 'quick_sort_1_int'
      ! sorts integer numbers into ascending numerical order
      ! -------------------
      ! corrected (É. Canot) and modified April 2008

      integer :: i, j, itmp, n
      integer :: piv ! pivot

   !------ end of declarations -- execution starts hereafter  ------

      n = size(A)
      piv = A(n/2+1)
      i = 1
      j = n

      do
         do
            if( A(i) >= piv ) exit
            i = i + 1
         end do
         do
            if( A(j) <= piv ) exit
            j = j - 1
         end do
         if( i < j ) then
            if( A(i) /= A(j) ) then
               ! exchange A(i) and A(j)
               itmp = A(i)
               A(i) = A(j)
               A(j) = itmp
            else
               i = i + 1
            end if
         else
            if( A(i) == piv ) then
               ipiv = i
            else
               if( A(j) /= piv ) then
                  write(STDERR,*) "(MUESLI quick_sort:) internal ERROR:"
                  write(STDERR,*) "                     pb in partition_sort_1_int_asc"
                  mf_message_displayed = .true.
                  call muesli_trace( pause="yes" )
                  stop
               end if
               ipiv = j
            end if
            return
         end if
     end do

#endif
   end subroutine partition_sort_1_int_asc
!_______________________________________________________________________
!
   subroutine partition_sort_1_int_des( A, ipiv )

      integer, intent(in out) :: A(:)
      integer, intent(out) :: ipiv
      !------ API end ------

#ifdef _DEVLP
      ! Auxiliary routine for 'quick_sort_1_int'
      ! sorts integer numbers into descending numerical order
      ! -------------------
      ! (É. Canot) Oct 2013

      integer :: i, j, itmp, n
      integer :: piv ! pivot

   !------ end of declarations -- execution starts hereafter  ------

      n = size(A)
      piv = A(n/2+1)
      i = 1
      j = n

      do
         do
            if( A(i) <= piv ) exit
            i = i + 1
         end do
         do
            if( A(j) >= piv ) exit
            j = j - 1
         end do
         if( i < j ) then
            if( A(i) /= A(j) ) then
               ! exchange A(i) and A(j)
               itmp = A(i)
               A(i) = A(j)
               A(j) = itmp
            else
               i = i + 1
            end if
         else
            if( A(i) == piv ) then
               ipiv = i
            else
               if( A(j) /= piv ) then
                  write(STDERR,*) "(MUESLI quick_sort:) internal ERROR:"
                  write(STDERR,*) "                     pb in partition_sort_1_int_des"
                  mf_message_displayed = .true.
                  call muesli_trace( pause="yes" )
                  stop
               end if
               ipiv = j
            end if
            return
         end if
     end do

#endif
   end subroutine partition_sort_1_int_des
!_______________________________________________________________________
!
   recursive subroutine quick_sort_3_int( mode, A, ind )

      character(len=3), intent(in)     :: mode
      integer,          intent(in out) :: A(:)
      integer,          intent(out)    :: ind(:)
      !------ API end ------

#ifdef _DEVLP
      ! Recursive Fortran quicksort routine
      !   sorts integer numbers into ascending (mode="asc") or
      !   descending (mode/="asc") numerical order
      ! -------------------
      ! modified (É. Canot) Oct 2013

      integer :: temp
      integer :: ipiv, n, itmp

   !------ end of declarations -- execution starts hereafter  ------

      n = size(A)

      if( n > 2 ) then
         if( mode == "asc" ) then
            ! ascending
            call partition_sort_3_int_asc( A, ind, ipiv )
         else
            ! descending
            call partition_sort_3_int_des( A, ind, ipiv )
         end if
         if( 2 <= ipiv-1 ) then
            call quick_sort_3_int( mode, A(:ipiv-1), ind(:ipiv-1) )
         end if
         if( ipiv+1 <= n-1 ) then
            call quick_sort_3_int( mode, A(ipiv+1:), ind(ipiv+1:) )
         end if
      else if( n == 2 ) then
         if( mode == "asc" ) then
            ! ascending
            if( A(1) > A(2) ) then
               temp = A(1)
               A(1) = A(2)
               A(2) = temp
               itmp = ind(1)
               ind(1) = ind(2)
               ind(2) = itmp
            end if
         else
            ! descending
            if( A(1) < A(2) ) then
               temp = A(1)
               A(1) = A(2)
               A(2) = temp
               itmp = ind(1)
               ind(1) = ind(2)
               ind(2) = itmp
            end if
         end if
      end if

#endif
   end subroutine quick_sort_3_int
!_______________________________________________________________________
!
   subroutine partition_sort_3_int_asc( A, ind, ipiv )

      integer, intent(in out) :: A(:)
      integer, intent(out)    :: ind(:)
      integer, intent(out)    :: ipiv
      !------ API end ------

#ifdef _DEVLP
      ! Auxiliary routine for 'quick_sort_3_int'
      ! sorts integer numbers into ascending numerical order
      ! -------------------
      ! created (É. Canot) May 2008

      integer :: i, j, itmp, n
      integer :: temp
      integer :: piv      !pivot point

   !------ end of declarations -- execution starts hereafter  ------

      n = size(A)
      piv = A(n/2+1)
      i = 1
      j = n

      do
         do
            if( A(i) >= piv ) exit
            i = i + 1
         end do
         do
            if( A(j) <= piv ) exit
            j = j - 1
         end do
         if( i < j ) then
            if( A(i) /= A(j) ) then
               ! exchange A(i) and A(j)
               temp = A(i)
               A(i) = A(j)
               A(j) = temp

               itmp = ind(i)
               ind(i) = ind(j)
               ind(j) = itmp
            else
               i = i + 1
            end if
         else
            if( A(i) == piv ) then
               ipiv = i
            else
               if( A(j) /= piv ) then
                  write(STDERR,*) "(MUESLI quick_sort:) internal ERROR:"
                  write(STDERR,*) "                     pb in partition_sort_3_int_asc"
                  mf_message_displayed = .true.
                  call muesli_trace( pause="yes" )
                  stop
               end if
               ipiv = j
            end if
            return
         end if
     end do

#endif
   end subroutine partition_sort_3_int_asc
!_______________________________________________________________________
!
   subroutine partition_sort_3_int_des( A, ind, ipiv )

      integer, intent(in out) :: A(:)
      integer, intent(out)    :: ind(:)
      integer, intent(out)    :: ipiv
      !------ API end ------

#ifdef _DEVLP
      ! Auxiliary routine for 'quick_sort_3_int'
      ! sorts real numbers into ascending numerical order
      ! -------------------
      ! (É. Canot) Oct 2013

      integer :: i, j, itmp, n
      integer :: temp
      integer :: piv      !pivot point

   !------ end of declarations -- execution starts hereafter  ------

      n = size(A)
      piv = A(n/2+1)
      i = 1
      j = n

      do
         do
            if( A(i) <= piv ) exit
            i = i + 1
         end do
         do
            if( A(j) >= piv ) exit
            j = j - 1
         end do
         if( i < j ) then
            if( A(i) /= A(j) ) then
               ! exchange A(i) and A(j)
               temp = A(i)
               A(i) = A(j)
               A(j) = temp

               itmp = ind(i)
               ind(i) = ind(j)
               ind(j) = itmp
            else
               i = i + 1
            end if
         else
            if( A(i) == piv ) then
               ipiv = i
            else
               if( A(j) /= piv ) then
                  write(STDERR,*) "(MUESLI quick_sort:) internal ERROR:"
                  write(STDERR,*) "                     pb in partition_sort_3_int_des"
                  mf_message_displayed = .true.
                  call muesli_trace( pause="yes" )
                  stop
               end if
               ipiv = j
            end if
            return
         end if
     end do

#endif
   end subroutine partition_sort_3_int_des
!_______________________________________________________________________
!
   recursive subroutine quick_sort_3_int8( mode, A, ind )

      character(len=3), intent(in)     :: mode
      integer*8,        intent(in out) :: A(:)
      integer,          intent(out)    :: ind(:)
      !------ API end ------

#ifdef _DEVLP
      ! Recursive Fortran quicksort routine
      !   sorts int8 numbers into ascending (mode="asc") or
      !   descending (mode/="asc") numerical order
      ! -------------------
      ! modified (É. Canot) Oct 2013

      integer*8 :: temp
      integer   :: itmp, ipiv, n

   !------ end of declarations -- execution starts hereafter  ------

      n = size(A)

      if( n > 2 ) then
         if( mode == "asc" ) then
            ! ascending
            call partition_sort_3_int8_asc( A, ind, ipiv )
         else
            ! descending
            call partition_sort_3_int8_des( A, ind, ipiv )
         end if
         if( 2 <= ipiv-1 ) then
            call quick_sort_3_int8( mode, A(:ipiv-1), ind(:ipiv-1) )
         end if
         if( ipiv+1 <= n-1 ) then
            call quick_sort_3_int8( mode, A(ipiv+1:), ind(ipiv+1:) )
         end if
      else if( n == 2 ) then
         if( mode == "asc" ) then
            ! ascending
            if( A(1) > A(2) ) then
               temp = A(1)
               A(1) = A(2)
               A(2) = temp
               itmp = ind(1)
               ind(1) = ind(2)
               ind(2) = itmp
            end if
         else
            ! descending
            if( A(1) < A(2) ) then
               temp = A(1)
               A(1) = A(2)
               A(2) = temp
               itmp = ind(1)
               ind(1) = ind(2)
               ind(2) = itmp
            end if
         end if
      end if

#endif
   end subroutine quick_sort_3_int8
!_______________________________________________________________________
!
   subroutine partition_sort_3_int8_asc( A, ind, ipiv )

      integer*8, intent(in out) :: A(:)
      integer,   intent(out)    :: ind(:)
      integer,   intent(out)    :: ipiv
      !------ API end ------

#ifdef _DEVLP
      ! Auxiliary routine for 'quick_sort_3_int8'
      ! sorts int8 numbers into ascending numerical order
      ! -------------------
      ! created (É. Canot) May 2008

      integer :: i, j, itmp, n
      integer*8 :: temp
      integer*8 :: piv      !pivot point

   !------ end of declarations -- execution starts hereafter  ------

      n = size(A)
      piv = A(n/2+1)
      i = 1
      j = n

      do
         do
            if( A(i) >= piv ) exit
            i = i + 1
         end do
         do
            if( A(j) <= piv ) exit
            j = j - 1
         end do
         if( i < j ) then
            if( A(i) /= A(j) ) then
               ! exchange A(i) and A(j)
               temp = A(i)
               A(i) = A(j)
               A(j) = temp

               itmp = ind(i)
               ind(i) = ind(j)
               ind(j) = itmp
            else
               i = i + 1
            end if
         else
            if( A(i) == piv ) then
               ipiv = i
            else
               if( A(j) /= piv ) then
                  write(STDERR,*) "(MUESLI quick_sort:) internal ERROR:"
                  write(STDERR,*) "                     pb in partition_sort_3_int_asc"
                  mf_message_displayed = .true.
                  call muesli_trace( pause="yes" )
                  stop
               end if
               ipiv = j
            end if
            return
         end if
     end do

#endif
   end subroutine partition_sort_3_int8_asc
!_______________________________________________________________________
!
   subroutine partition_sort_3_int8_des( A, ind, ipiv )

      integer*8, intent(in out) :: A(:)
      integer,   intent(out)    :: ind(:)
      integer,   intent(out)    :: ipiv
      !------ API end ------

#ifdef _DEVLP
      ! Auxiliary routine for 'quick_sort_3_int8'
      ! sorts int8 numbers into descending numerical order
      ! -------------------
      ! created (É. Canot) May 2008

      integer :: i, j, itmp, n
      integer*8 :: temp
      integer*8 :: piv      !pivot point

   !------ end of declarations -- execution starts hereafter  ------

      n = size(A)
      piv = A(n/2+1)
      i = 1
      j = n

      do
         do
            if( A(i) <= piv ) exit
            i = i + 1
         end do
         do
            if( A(j) >= piv ) exit
            j = j - 1
         end do
         if( i < j ) then
            if( A(i) /= A(j) ) then
               ! exchange A(i) and A(j)
               temp = A(i)
               A(i) = A(j)
               A(j) = temp

               itmp = ind(i)
               ind(i) = ind(j)
               ind(j) = itmp
            else
               i = i + 1
            end if
         else
            if( A(i) == piv ) then
               ipiv = i
            else
               if( A(j) /= piv ) then
                  write(STDERR,*) "(MUESLI quick_sort:) internal ERROR:"
                  write(STDERR,*) "                     pb in partition_sort_3_int_des"
                  mf_message_displayed = .true.
                  call muesli_trace( pause="yes" )
                  stop
               end if
               ipiv = j
            end if
            return
         end if
     end do

#endif
   end subroutine partition_sort_3_int8_des
