! f90 include file

!_______________________________________________________________________
!
   function mf_max_omitNaN_scal_scal( a, b ) result( res )
      real(kind=MF_DOUBLE) :: a, b
      real(kind=MF_DOUBLE) :: res
      !------ API end ------

#ifdef _DEVLP
      ! the routine discards NaN value(s) found in the vector

   !------ end of declarations -- execution starts hereafter  ------

      if( a /= a ) then
         ! a is a NaN
         res = b
         return
      end if

      if( b /= b ) then
         ! b is a NaN
         res = a
      else
         ! b is not a NaN
         res = max( a, b )
      end if

#endif
   end function mf_max_omitNaN_scal_scal
!_______________________________________________________________________
!
   function mf_max_includeNaN_scal_scal( a, b ) result( res )
      real(kind=MF_DOUBLE) :: a, b
      real(kind=MF_DOUBLE) :: res
      !------ API end ------

#ifdef _DEVLP
      ! the routine returns as soon as a NaN is found

   !------ end of declarations -- execution starts hereafter  ------

      if( a /= a ) then
         ! a is a NaN
         res = a
         return
      end if

      if( b /= b ) then
         ! b is a NaN
         res = b
         return
      end if

      res = max( a, b )

#endif
   end function mf_max_includeNaN_scal_scal
!_______________________________________________________________________
!
   function mf_min_omitNaN_scal_scal( a, b ) result( res )
      real(kind=MF_DOUBLE) :: a, b
      real(kind=MF_DOUBLE) :: res
      !------ API end ------

#ifdef _DEVLP
      ! the routine discards NaN value(s) found in the vector

   !------ end of declarations -- execution starts hereafter  ------

      if( a /= a ) then
         ! a is a NaN
         res = b
         return
      end if

      if( b /= b ) then
         ! b is a NaN
         res = a
      else
         ! b is not a NaN
         res = min( a, b )
      end if

#endif
   end function mf_min_omitNaN_scal_scal
!_______________________________________________________________________
!
   function mf_min_includeNaN_scal_scal( a, b ) result( res )
      real(kind=MF_DOUBLE) :: a, b
      real(kind=MF_DOUBLE) :: res
      !------ API end ------

#ifdef _DEVLP
      ! the routine returns as soon as a NaN is found

   !------ end of declarations -- execution starts hereafter  ------

      if( a /= a ) then
         ! a is a NaN
         res = a
         return
      end if

      if( b /= b ) then
         ! b is a NaN
         res = b
         return
      end if

      res = min( a, b )

#endif
   end function mf_min_includeNaN_scal_scal
!_______________________________________________________________________
!
   function mf_max_omitNaN_mat_scal( A, b ) result( res )
      real(kind=MF_DOUBLE) :: A(:,:), b
      real(kind=MF_DOUBLE) :: res(size(A,1),size(A,2))
      !------ API end ------

#ifdef _DEVLP
      integer :: i, j

   !------ end of declarations -- execution starts hereafter  ------

      do j = 1, size(A,2)
         do i = 1, size(A,1)
            res(i,j) = mf_max_omitNaN_scal_scal( A(i,j), b )
         end do
      end do

#endif
   end function mf_max_omitNaN_mat_scal
!_______________________________________________________________________
!
   function mf_max_omitNaN_mat_mat( A, B ) result( res )
      real(kind=MF_DOUBLE) :: A(:,:), B(:,:)
      real(kind=MF_DOUBLE) :: res(size(A,1),size(A,2))
      !------ API end ------

#ifdef _DEVLP
      integer :: i, j

   !------ end of declarations -- execution starts hereafter  ------

      do j = 1, size(A,2)
         do i = 1, size(A,1)
            res(i,j) = mf_max_omitNaN_scal_scal( A(i,j), B(i,j) )
         end do
      end do

#endif
   end function mf_max_omitNaN_mat_mat
!_______________________________________________________________________
!
   function mf_max_includeNaN_mat_scal( A, b ) result( res )
      real(kind=MF_DOUBLE) :: A(:,:), b
      real(kind=MF_DOUBLE) :: res(size(A,1),size(A,2))
      !------ API end ------

#ifdef _DEVLP
      integer :: i, j

   !------ end of declarations -- execution starts hereafter  ------

      do j = 1, size(A,2)
         do i = 1, size(A,1)
            res(i,j) = mf_max_includeNaN_scal_scal( A(i,j), b )
         end do
      end do

#endif
   end function mf_max_includeNaN_mat_scal
!_______________________________________________________________________
!
   function mf_max_includeNaN_mat_mat( A, B ) result( res )
      real(kind=MF_DOUBLE) :: A(:,:), B(:,:)
      real(kind=MF_DOUBLE) :: res(size(A,1),size(A,2))
      !------ API end ------

#ifdef _DEVLP
      integer :: i, j

   !------ end of declarations -- execution starts hereafter  ------

      do j = 1, size(A,2)
         do i = 1, size(A,1)
            res(i,j) = mf_max_includeNaN_scal_scal( A(i,j), B(i,j) )
         end do
      end do

#endif
   end function mf_max_includeNaN_mat_mat
!_______________________________________________________________________
!
   function mf_min_omitNaN_mat_scal( A, b ) result( res )
      real(kind=MF_DOUBLE) :: A(:,:), b
      real(kind=MF_DOUBLE) :: res(size(A,1),size(A,2))
      !------ API end ------

#ifdef _DEVLP
      integer :: i, j

   !------ end of declarations -- execution starts hereafter  ------

      do j = 1, size(A,2)
         do i = 1, size(A,1)
            res(i,j) = mf_min_omitNaN_scal_scal( A(i,j), b )
         end do
      end do

#endif
   end function mf_min_omitNaN_mat_scal
!_______________________________________________________________________
!
   function mf_min_omitNaN_mat_mat( A, B ) result( res )
      real(kind=MF_DOUBLE) :: A(:,:), B(:,:)
      real(kind=MF_DOUBLE) :: res(size(A,1),size(A,2))
      !------ API end ------

#ifdef _DEVLP
      integer :: i, j

   !------ end of declarations -- execution starts hereafter  ------

      do j = 1, size(A,2)
         do i = 1, size(A,1)
            res(i,j) = mf_min_omitNaN_scal_scal( A(i,j), B(i,j) )
         end do
      end do

#endif
   end function mf_min_omitNaN_mat_mat
!_______________________________________________________________________
!
   function mf_min_includeNaN_mat_scal( A, b ) result( res )
      real(kind=MF_DOUBLE) :: A(:,:), b
      real(kind=MF_DOUBLE) :: res(size(A,1),size(A,2))
      !------ API end ------

#ifdef _DEVLP
      ! the routine returns as soon as a NaN is found

      integer :: i, j

   !------ end of declarations -- execution starts hereafter  ------

      do j = 1, size(A,2)
         do i = 1, size(A,1)
            res(i,j) = mf_min_includeNaN_scal_scal( A(i,j), b )
         end do
      end do

#endif
   end function mf_min_includeNaN_mat_scal
!_______________________________________________________________________
!
   function mf_min_includeNaN_mat_mat( A, B ) result( res )
      real(kind=MF_DOUBLE) :: A(:,:), B(:,:)
      real(kind=MF_DOUBLE) :: res(size(A,1),size(A,2))
      !------ API end ------

#ifdef _DEVLP
      ! the routine returns as soon as a NaN is found

      integer :: i, j

   !------ end of declarations -- execution starts hereafter  ------

      do j = 1, size(A,2)
         do i = 1, size(A,1)
            res(i,j) = mf_min_includeNaN_scal_scal( A(i,j), B(i,j) )
         end do
      end do

#endif
   end function mf_min_includeNaN_mat_mat
!_______________________________________________________________________
!
   function mf_maxval_omitNaN( v ) result( res )
      real(kind=MF_DOUBLE) :: v(:)
      real(kind=MF_DOUBLE) :: res
      !------ API end ------

#ifdef _DEVLP
      ! the routine discards NaN value(s) found in the vector

      integer :: i, n, k

   !------ end of declarations -- execution starts hereafter  ------

      n = size(v)
if( n == 0 ) then
   pause "mf_maxval_omitNaN: case n==0 not handled!"
end if

      ! find a value which is not a NaN
      do i = 1, n
         if( v(i) /= v(i) ) then
            ! v(i) is a NaN
            cycle
         else
            ! v(i) is not a NaN
            res = v(i)
            go to 10
         end if
      end do

      res = v(1) ! res is a NaN
      return

 10   continue ! hereafter, res is not a NaN

      do k = i+1, n
         if( v(k) /= v(k) ) then
            ! v(k) is a NaN
            cycle
         else
            ! v(k) is not a NaN
            res = max( res, v(k) )
         end if
      end do

#endif
   end function mf_maxval_omitNaN
!_______________________________________________________________________
!
   function mf_maxval_includeNaN( v ) result( res )
      real(kind=MF_DOUBLE) :: v(:)
      real(kind=MF_DOUBLE) :: res
      !------ API end ------

#ifdef _DEVLP
      ! the routine returns as soon as a NaN is found

      integer :: i, n

   !------ end of declarations -- execution starts hereafter  ------

      n = size(v)
if( n == 0 ) then
   pause "mf_maxval_includeNaN: case n==0 not handled!"
end if

      res = v(1)
      if( res /= res ) then
         ! res is a NaN
         return
      end if

      do i = 2, n
         if( v(i) /= v(i) ) then
            ! v(i) is a NaN
            res = v(i)
            return
         else
            ! v(i) is not a NaN
            res = max( res, v(i) )
         end if
      end do

#endif
   end function mf_maxval_includeNaN
!_______________________________________________________________________
!
   function mf_minval_omitNaN( v ) result( res )
      real(kind=MF_DOUBLE) :: v(:)
      real(kind=MF_DOUBLE) :: res
      !------ API end ------

#ifdef _DEVLP
      ! the routine discards NaN value(s) found in the vector

      integer :: i, n, k

   !------ end of declarations -- execution starts hereafter  ------

      n = size(v)
if( n == 0 ) then
   pause "mf_minval_omitNaN: case n==0 not handled!"
end if

      ! find a value which is not a NaN
      do i = 1, n
         if( v(i) /= v(i) ) then
            ! v(i) is a NaN
            cycle
         else
            ! v(i) is not a NaN
            res = v(i)
            go to 10
         end if
      end do

      res = v(1) ! res is a NaN
      return

 10   continue ! hereafter, res is not a NaN

      do k = i+1, n
         if( v(k) /= v(k) ) then
            ! v(k) is a NaN
            cycle
         else
            ! v(k) is not a NaN
            res = min( res, v(k) )
         end if
      end do

#endif
   end function mf_minval_omitNaN
!_______________________________________________________________________
!
   function mf_minval_includeNaN( v ) result( res )
      real(kind=MF_DOUBLE) :: v(:)
      real(kind=MF_DOUBLE) :: res
      !------ API end ------

#ifdef _DEVLP
      ! the routine returns as soon as a NaN is found

      integer :: i, n

   !------ end of declarations -- execution starts hereafter  ------

      n = size(v)
if( n == 0 ) then
   pause "mf_minval_includeNaN: case n==0 not handled!"
end if

      res = v(1)
      if( res /= res ) then
         ! res is a NaN
         return
      end if

      do i = 2, n
         if( v(i) /= v(i) ) then
            ! v(i) is a NaN
            res = v(i)
            return
         else
            ! v(i) is not a NaN
            res = min( res, v(i) )
         end if
      end do

#endif
   end function mf_minval_includeNaN
!_______________________________________________________________________
!
   subroutine ms_maxval_loc_int_omitNaN( vec, val, loc )
      real(kind=MF_DOUBLE), intent(in)  :: vec(:)
      real(kind=MF_DOUBLE), intent(out) :: val
      integer,              intent(out) :: loc
      !------ API end ------

#ifdef _DEVLP
      ! the routine discards NaN value(s) found in the vector

      integer :: i, n, k

   !------ end of declarations -- execution starts hereafter  ------

      n = size(vec)
if( n == 0 ) then
   pause "ms_maxval_loc_int_omitNaN: case n==0 not handled!"
end if

      ! find a value which is not a NaN
      do i = 1, n
         if( vec(i) /= vec(i) ) then
            ! vec(i) is a NaN
            cycle
         else
            ! vec(i) is not a NaN
            val = vec(i)
            loc = i
            go to 10
         end if
      end do

      val = vec(1) ! val is a NaN
      loc = 1
      return

 10   continue ! hereafter, val is not a NaN

      do k = i+1, n
         if( vec(k) /= vec(k) ) then
            ! vec(k) is a NaN
            cycle
         else
            ! vec(k) is not a NaN
            if( vec(k) > val ) then
               val = vec(k)
               loc = k
            end if
         end if
      end do

#endif
   end subroutine ms_maxval_loc_int_omitNaN
!_______________________________________________________________________
!
   subroutine ms_maxval_loc_r8_omitNaN( vec, val, loc )
      real(kind=MF_DOUBLE), intent(in)  :: vec(:)
      real(kind=MF_DOUBLE), intent(out) :: val, loc
      !------ API end ------

#ifdef _DEVLP
      ! the routine discards NaN value(s) found in the vector

      integer :: i, n, k

   !------ end of declarations -- execution starts hereafter  ------

      n = size(vec)
if( n == 0 ) then
   pause "ms_maxval_loc_r8_omitNaN: case n==0 not handled!"
end if

      ! find a value which is not a NaN
      do i = 1, n
         if( vec(i) /= vec(i) ) then
            ! vec(i) is a NaN
            cycle
         else
            ! vec(i) is not a NaN
            val = vec(i)
            loc = i
            go to 10
         end if
      end do

      val = vec(1) ! val is a NaN
      loc = 1
      return

 10   continue ! hereafter, val is not a NaN

      do k = i+1, n
         if( vec(k) /= vec(k) ) then
            ! vec(k) is a NaN
            cycle
         else
            ! vec(k) is not a NaN
            if( vec(k) > val ) then
               val = vec(k)
               loc = k
            end if
         end if
      end do

#endif
   end subroutine ms_maxval_loc_r8_omitNaN
!_______________________________________________________________________
!
   subroutine ms_maxval_loc_int_includeNaN( vec, val, loc )
      real(kind=MF_DOUBLE), intent(in)  :: vec(:)
      real(kind=MF_DOUBLE), intent(out) :: val
      integer,              intent(out) :: loc
      !------ API end ------

#ifdef _DEVLP
      ! the routine returns as soon as a NaN is found

      integer :: i, n

   !------ end of declarations -- execution starts hereafter  ------

      n = size(vec)
if( n == 0 ) then
   pause "ms_maxval_loc_int_includeNaN: case n==0 not handled!"
end if

      val = vec(1)
      loc = 1
      if( val /= val ) then
         ! val is a NaN
         return
      end if

      do i = 2, n
         if( vec(i) /= vec(i) ) then
            ! vec(i) is a NaN
            val = vec(i)
            loc = i
            return
         else
            ! vec(i) is not a NaN
            if( vec(i) > val ) then
               val = vec(i)
               loc = i
            end if
         end if
      end do

#endif
   end subroutine ms_maxval_loc_int_includeNaN
!_______________________________________________________________________
!
   subroutine ms_maxval_loc_r8_includeNaN( vec, val, loc )
      real(kind=MF_DOUBLE), intent(in)  :: vec(:)
      real(kind=MF_DOUBLE), intent(out) :: val, loc
      !------ API end ------

#ifdef _DEVLP
      ! the routine returns as soon as a NaN is found

      integer :: i, n

   !------ end of declarations -- execution starts hereafter  ------

      n = size(vec)
if( n == 0 ) then
   pause "ms_maxval_loc_r8_includeNaN: case n==0 not handled!"
end if

      val = vec(1)
      loc = 1
      if( val /= val ) then
         ! val is a NaN
         return
      end if

      do i = 2, n
         if( vec(i) /= vec(i) ) then
            ! vec(i) is a NaN
            val = vec(i)
            loc = i
            return
         else
            ! vec(i) is not a NaN
            if( vec(i) > val ) then
               val = vec(i)
               loc = i
            end if
         end if
      end do

#endif
   end subroutine ms_maxval_loc_r8_includeNaN
!_______________________________________________________________________
!
   subroutine ms_minval_loc_int_omitNaN( vec, val, loc )
      real(kind=MF_DOUBLE), intent(in)  :: vec(:)
      real(kind=MF_DOUBLE), intent(out) :: val
      integer,              intent(out) :: loc
      !------ API end ------

#ifdef _DEVLP
      ! the routine discards NaN value(s) found in the vector

      integer :: i, n, k

   !------ end of declarations -- execution starts hereafter  ------

      n = size(vec)
if( n == 0 ) then
   pause "ms_minval_loc_int_omitNaN: case n==0 not handled!"
end if

      ! find a value which is not a NaN
      do i = 1, n
         if( vec(i) /= vec(i) ) then
            ! vec(i) is a NaN
            cycle
         else
            ! vec(i) is not a NaN
            val = vec(i)
            loc = i
            go to 10
         end if
      end do

      val = vec(1) ! val is a NaN
      loc = 1
      return

 10   continue ! hereafter, val is not a NaN

      do k = i+1, n
         if( vec(k) /= vec(k) ) then
            ! vec(k) is a NaN
            cycle
         else
            ! vec(k) is not a NaN
            if( vec(k) < val ) then
               val = vec(k)
               loc = k
            end if
         end if
      end do

#endif
   end subroutine ms_minval_loc_int_omitNaN
!_______________________________________________________________________
!
   subroutine ms_minval_loc_r8_omitNaN( vec, val, loc )
      real(kind=MF_DOUBLE), intent(in)  :: vec(:)
      real(kind=MF_DOUBLE), intent(out) :: val, loc
      !------ API end ------

#ifdef _DEVLP
      ! the routine discards NaN value(s) found in the vector

      integer :: i, n, k

   !------ end of declarations -- execution starts hereafter  ------

      n = size(vec)
if( n == 0 ) then
   pause "ms_minval_loc_r8_omitNaN: case n==0 not handled!"
end if

      ! find a value which is not a NaN
      do i = 1, n
         if( vec(i) /= vec(i) ) then
            ! vec(i) is a NaN
            cycle
         else
            ! vec(i) is not a NaN
            val = vec(i)
            loc = i
            go to 10
         end if
      end do

      val = vec(1) ! val is a NaN
      loc = 1
      return

 10   continue ! hereafter, val is not a NaN

      do k = i+1, n
         if( vec(k) /= vec(k) ) then
            ! vec(k) is a NaN
            cycle
         else
            ! vec(k) is not a NaN
            if( vec(k) < val ) then
               val = vec(k)
               loc = k
            end if
         end if
      end do

#endif
   end subroutine ms_minval_loc_r8_omitNaN
!_______________________________________________________________________
!
   subroutine ms_minval_loc_int_includeNaN( vec, val, loc )
      real(kind=MF_DOUBLE), intent(in)  :: vec(:)
      real(kind=MF_DOUBLE), intent(out) :: val
      integer,              intent(out) :: loc
      !------ API end ------

#ifdef _DEVLP
      ! the routine returns as soon as a NaN is found

      integer :: i, n

   !------ end of declarations -- execution starts hereafter  ------

      n = size(vec)
if( n == 0 ) then
   pause "ms_minval_loc_int_includeNaN: case n==0 not handled!"
end if

      val = vec(1)
      loc = 1
      if( val /= val ) then
         ! val is a NaN
         return
      end if

      do i = 2, n
         if( vec(i) /= vec(i) ) then
            ! vec(i) is a NaN
            val = vec(i)
            loc = i
            return
         else
            ! vec(i) is not a NaN
            if( vec(i) < val ) then
               val = vec(i)
               loc = i
            end if
         end if
      end do

#endif
   end subroutine ms_minval_loc_int_includeNaN
!_______________________________________________________________________
!
   subroutine ms_minval_loc_r8_includeNaN( vec, val, loc )
      real(kind=MF_DOUBLE), intent(in)  :: vec(:)
      real(kind=MF_DOUBLE), intent(out) :: val, loc
      !------ API end ------

#ifdef _DEVLP
      ! the routine returns as soon as a NaN is found

      integer :: i, n

   !------ end of declarations -- execution starts hereafter  ------

      n = size(vec)
if( n == 0 ) then
   pause "ms_minval_loc_r8_includeNaN: case n==0 not handled!"
end if

      val = vec(1)
      loc = 1
      if( val /= val ) then
         ! val is a NaN
         return
      end if

      do i = 2, n
         if( vec(i) /= vec(i) ) then
            ! vec(i) is a NaN
            val = vec(i)
            loc = i
            return
         else
            ! vec(i) is not a NaN
            if( vec(i) < val ) then
               val = vec(i)
               loc = i
            end if
         end if
      end do

#endif
   end subroutine ms_minval_loc_r8_includeNaN
!_______________________________________________________________________
!
   function first_index_not_in( vec ) result( i )
      integer :: vec(:), i
      !------ API end ------

#ifdef _DEVLP
      ! the vector 'vec(:)' is not necessarily sorted!

      integer, allocatable :: vs(:)
      integer :: n

   !------ end of declarations -- execution starts hereafter  ------

      n = size(vec)
if( n == 0 ) then
   pause "first_index_not_in: case n==0 not handled!"
end if

      allocate( vs(n) )
      vs(:) = vec(:)
      call quick_sort_1_int( "asc", vs )

      ! walking through the sorted integer vector, and leave the loop as soon
      ! as a shift is found between the value and the corresponding index
      do i = 1, n
         if( vs(i) > i ) then
            return
         end if
      end do

      ! index not found, the last possibility is as follows
      i = n + 1

#endif
   end function first_index_not_in
