! f90 include file

!_______________________________________________________________________
!
   subroutine msDisplay_with_legend( x, string,                         &
                                     legend1, legend2, legend3,         &
                                     legend4, legend5, legend6,         &
                                     legend7, legend8, legend9 )

      type(mfArray)                          :: x
      character(len=*), intent(in)           :: string, legend1
      character(len=*), intent(in), optional :: legend2, legend3,       &
                                                legend4, legend5,       &
                                                legend6, legend7,       &
                                                legend8, legend9
      !------ API end ------

#ifdef _DEVLP
      ! Here, only 'string' and legends are printed.

      integer :: m, n, nb_legend, x_count
      real(kind=MF_DOUBLE), allocatable :: x_abs(:,:)
      real(kind=MF_DOUBLE) :: max_val_abs, log10_x_max, power_threshold
      logical, allocatable :: x_mask(:,:)
      logical :: x_contains_special_IEEE_values
      logical :: integer_fmt, integer_small, float_small
      logical :: mf_short_mantissa_save
      integer :: power_scale, len_fmt, col_length, eff_len

      character(len=22), parameter :: blanks = ""
      character(len=22) :: str

      ! The following constants must be exactly correspond to those used
      ! in the 'print_mfArray_double_alone' routine.
      integer, parameter :: len_fmt_int_small = 4
      integer, parameter :: len_fmt_int_large = 10
      integer, parameter :: len_fmt_sci_short = 12
      integer, parameter :: len_fmt_short     = 9
      integer, parameter :: len_fmt_long      = 18
      integer, parameter :: len_fmt_sci_long  = 22

   !------ end of declarations -- execution starts hereafter  ------

      call msInitArgs( x )

      nb_legend = 1
      if( present(legend2) ) then
         nb_legend = nb_legend + 1
         if( present(legend3) ) then
            nb_legend = nb_legend + 1
            if( present(legend4) ) then
               nb_legend = nb_legend + 1
               if( present(legend5) ) then
                  nb_legend = nb_legend + 1
                  if( present(legend6) ) then
                     nb_legend = nb_legend + 1
                     if( present(legend7) ) then
                        nb_legend = nb_legend + 1
                        if( present(legend8) ) then
                           nb_legend = nb_legend + 1
                           if( present(legend9) ) then
                              nb_legend = nb_legend + 1
                           end if
                        end if
                     end if
                  end if
               end if
            end if
         end if
      end if

      m = x%shape(1)
      n = x%shape(2)

      if( nb_legend > n ) then
         call PrintMessage( "msDisplay", "W",                           &
                            "Nb of legends is too large for the actual mfArray!", &
                            "(the last ones will be discarded)" )
      end if

      if( mf_display_hexa ) then
         call PrintMessage( "msDisplay", "E",                           &
                            "Hexa format not possible when using legends!", &
                            "(the last ones will be discarded)" )
         go to 99
      end if

      write(STDOUT,"()")
      write(STDOUT,*) trim(string), " ="
      write(STDOUT,"()")

      ! ┌───────────────────────────────────────────────────────┐
      ! │ determine if the mfArray contains special IEEE values │
      ! └───────────────────────────────────────────────────────┘

!### There is a redondancy with the same computation in
!    'print_mfArray_double_alone', but we expect that the current
!    routine is used with small arrays...

      allocate( x_abs(m,n) )
      allocate( x_mask(m,n) )
      x_contains_special_IEEE_values = .false.
      x_abs(:,:) = abs(x%double)
      x_mask(:,:) = mf_isfinite(x_abs)
      x_count = count( x_mask )
      if( x_count == 0 ) then
         ! All values are Inf and/or NaN
         max_val_abs = 0.0d0
         x_contains_special_IEEE_values = .true.
      else
         ! avoid special IEEE values (Inf, NaN)
         max_val_abs = maxval(x_abs,MASK=x_mask)
         if( x_count /= m*n ) then
            x_contains_special_IEEE_values = .true.
         end if
      end if
      deallocate( x_abs, x_mask )

      ! default values
      float_small = .true.
      integer_fmt = .false.

      if( mf_display_exponent /= "sci" ) then ! "auto" or "eng"
         if( max_val_abs == 0.0d0 ) then
            log10_x_max = 0.0d0
         else
            log10_x_max = log10(max_val_abs)
         end if
         if( mf_short_mantissa ) then
            power_threshold = 3.0d0
         else
            power_threshold = 2.0d0
         end if
         if( abs(log10_x_max) >= power_threshold ) then
            float_small = .false.
         end if
         power_scale = int(log10_x_max)
         if( mf_display_exponent == "eng" ) then
            if( int(log10_x_max) < 0 ) then
               power_scale = ((power_scale)/3)*3
            else
               power_scale = ((power_scale+1)/3)*3
            end if
            if( power_scale /= 0 ) then
               float_small = .false.
            else
               float_small = .true.
            end if
         end if
      end if

      if( mf_display_exponent == "auto" .and.                           &
         .not. x_contains_special_IEEE_values ) then
         if( all( int(x%double) == x%double) ) then
            integer_fmt = .true.
            if( log10_x_max < 3.0d0 ) then
               integer_small = .true.
            else
               integer_small = .false.
            end if
            if( log10_x_max < 3.0d0 ) then
               len_fmt = len_fmt_int_small
            else if( log10_x_max < 8.0d0 ) then
               len_fmt = len_fmt_int_large
            else
               integer_fmt = .false.
            end if
         end if
      end if

      if( integer_fmt ) then
         ! integer format
!!ncol_max = ncol_shell / ( len_fmt + 2 )
col_length = len_fmt + 2
      else ! float format
         if( mf_display_exponent /= "sci" ) then ! "auto" or "eng"
            if( mf_short_mantissa ) then
               ! short mantissa
               len_fmt = len_fmt_short
            else
               ! long mantissa
               len_fmt = len_fmt_long
            end if
         else ! "sci"
            if( mf_short_mantissa ) then
               ! short mantissa
               len_fmt = len_fmt_sci_short
            else
               ! long mantissa
               len_fmt = len_fmt_sci_long
            end if
         end if
!!ncol_max = ncol_shell / ( len_fmt + 1 )
col_length = len_fmt + 1
      end if

!!print *, "col. length = ", col_length

      str = legend1
      eff_len = len_trim(str(1:col_length-2))
      write(STDOUT,"(A,A)",advance="no") blanks(1:col_length-eff_len),  &
                                         trim(str(1:col_length-2))
      if( present(legend2) ) then
         str = legend2
         eff_len = len_trim(str(1:col_length-2))
         write(STDOUT,"(A,A)",advance="no") blanks(1:col_length-eff_len), &
                                            trim(str(1:col_length-2))
         if( present(legend3) ) then
            str = legend3
            eff_len = len_trim(str(1:col_length-2))
            write(STDOUT,"(A,A)",advance="no") blanks(1:col_length-eff_len), &
                                               trim(str(1:col_length-2))
            if( present(legend4) ) then
               str = legend4
               eff_len = len_trim(str(1:col_length-2))
               write(STDOUT,"(A,A)",advance="no") blanks(1:col_length-eff_len), &
                                                  trim(str(1:col_length-2))
               if( present(legend5) ) then
                  str = legend5
                  eff_len = len_trim(str(1:col_length-2))
                  write(STDOUT,"(A,A)",advance="no") blanks(1:col_length-eff_len), &
                                                     trim(str(1:col_length-2))
                  if( present(legend6) ) then
                     str = legend6
                     eff_len = len_trim(str(1:col_length-2))
                     write(STDOUT,"(A,A)",advance="no") blanks(1:col_length-eff_len), &
                                                        trim(str(1:col_length-2))
                     if( present(legend7) ) then
                        str = legend7
                        eff_len = len_trim(str(1:col_length-2))
                        write(STDOUT,"(A,A)",advance="no") blanks(1:col_length-eff_len), &
                                                           trim(str(1:col_length-2))
                        if( present(legend8) ) then
                           str = legend8
                           eff_len = len_trim(str(1:col_length-2))
                           write(STDOUT,"(A,A)",advance="no") blanks(1:col_length-eff_len), &
                                                              trim(str(1:col_length-2))
                           if( present(legend9) ) then
                              str = legend9
                              eff_len = len_trim(str(1:col_length-2))
                              write(STDOUT,"(A,A)",advance="no") blanks(1:col_length-eff_len), &
                                                                 trim(str(1:col_length-2))
                           end if
                        end if
                     end if
                  end if
               end if
            end if
         end if
      end if
      write(STDOUT,"()")

      write(STDOUT,"()")

      call print_mfArray_double_alone( x )

 99   continue

      call msFreeArgs( x )
      call msAutoRelease( x )

#endif
   end subroutine msDisplay_with_legend
