! f90 include file

!_______________________________________________________________________
!
   subroutine msDisplay_mfUnit( x, string, unit )

      type(mfUnit) :: x
      character(len=*), intent(in) :: string
      type(mfUnit), intent(in), optional :: unit
      !------ API end ------

#ifdef _DEVLP
      character(len=75) :: phys_dim_str, phys_unit_str, phys_dim_req_str
      integer :: status

      character(len=10) :: fmt_int_small = "i4"

      character(len=10) :: fmt_int_large = "i10"

      character(len=10) :: fmt_short     = "f9.4"

      character(len=10) :: fmt_sci_short = "es11.4"

      character(len=10) :: fmt_long      = "f18.14"

      character(len=10) :: fmt_sci_long  = "es21.14"

      character(len=10) :: fmt_int, fmt_used
      character(len=80) :: fmt
      real(kind=MF_DOUBLE) :: re, log10_x_max, power_threshold
      integer :: power_scale
      logical :: integer_fmt, integer_small, float_small

   !------ end of declarations -- execution starts hereafter  ------

      call mf_save_and_disable_fpe( )

      write(STDOUT,"()")
      write(STDOUT,*) trim(string), " ="
      if( mf_phys_units ) then
         if( present(unit) ) then
            if( unit%abbrev == "S.I." ) then
               call process_units( x%units, phys_dim_str )
               ! special case where MUESLI must try to find
               ! the unit name
               call find_unit_name_from_units( x%units, phys_unit_str )
            else
               call process_units( x%units, phys_dim_str, unit, phys_unit_str )
               call verif_adim( x%units, unit%units, status )
               if( status /= 0 ) then
                  call process_units( unit%units, phys_dim_req_str )
                  call PrintMessage( "msDisplay", "E",                  &
                                     "required unit for printing not consistent with the physical dimension", &
                                     "of the mfArray!",                 &
                                     "  Current physical dimension is : " // trim(phys_dim_str), &
                                     "  Required unit for printing is : " // trim(phys_dim_req_str) )
                  go to 99
               end if
            end if
            write(STDOUT,*) trim(phys_dim_str), " ", trim(phys_unit_str)
            write(STDOUT,"()")
            re = x%value / unit%value
         else
            call process_units( x%units, phys_dim_str )
            write(STDOUT,*) trim(phys_dim_str)
            write(STDOUT,"()")
            re = x%value
         end if

         ! we suppose that 're' is finite, positive real number.
         if( re < 0.0d0 ) then
            call PrintMessage( "msDisplay", "E",                        &
                               "when printing a physical unit, the factor is expected to be positive!" )
            go to 99
         end if

         ! general cases
         float_small = .true.
         if( mf_display_exponent /= "sci" ) then ! "auto" or "eng"
            if( re == 0.0d0 ) then
               log10_x_max = 0.0d0
            else
               log10_x_max = log10(re)
            end if
            if( mf_short_mantissa ) then
               power_threshold = 3.0d0
            else
               power_threshold = 2.0d0
            end if
            if( abs(log10_x_max) >= power_threshold ) then
               float_small = .false.
            end if
            power_scale = int(log10_x_max)
            if( mf_display_exponent == "eng" ) then
               if( int(log10_x_max) < 0 ) then
                  power_scale = ((power_scale)/3)*3
               else
                  power_scale = ((power_scale+1)/3)*3
               end if
               if( power_scale /= 0 ) then
                  float_small = .false.
               else
                  float_small = .true.
               end if
            end if
         end if

         integer_fmt = .false.
         if( mf_display_exponent == "auto" ) then
            if( int(re) == re ) then
               integer_fmt = .true.
               if( log10_x_max < 3.0d0 ) then
                  integer_small = .true.
               else
                  integer_small = .false.
               end if
               if( log10_x_max < 3.0d0 ) then
                  fmt_int = fmt_int_small
               else if( log10_x_max < 8.0d0 ) then
                  fmt_int = fmt_int_large
               else
                  integer_fmt = .false.
               end if
            end if
         end if

         if( integer_fmt ) then
            ! integer format
            fmt = "(2x," // trim(fmt_int) // ")"
            write(STDOUT,fmt) nint(re)
         else ! float format
            if( mf_display_exponent /= "sci" ) then ! "auto" or "eng"
               if( mf_short_mantissa ) then
                  ! short mantissa
                  fmt_used = fmt_short
               else
                  ! long mantissa
                  fmt_used = fmt_long
               end if
            else ! "sci"
               if( mf_short_mantissa ) then
                  ! short mantissa
                  fmt_used = fmt_sci_short
               else
                  ! long mantissa
                  fmt_used = fmt_sci_long
               end if
            end if
            if( float_small ) then ! small float
               fmt = "(1x," // trim(fmt_used) // ")"
            else ! large float ("auto" or "eng" format)
               if( mf_short_mantissa ) then
                  if( mf_display_exponent == "eng" ) then
                     fmt = "(2x,en13.4)"
                  else
                     fmt = "(2x,es11.4)"
                  end if
               else
                  if( mf_display_exponent == "eng" ) then
                     fmt = "(2x,en23.14)"
                  else
                     fmt = "(2x,es21.14)"
                  end if
               end if
            end if
            write(STDOUT,fmt) re
         end if

      else
         ! trying to display a physical unit whereas 'mf_phys_units'
         ! is off
         call PrintMessage( "msDisplay", "W",                           &
                            "in order to display a physical unit, you should activate physical units", &
                            "via the 'msUsePhysUnits' routine!" )
      end if
      write(STDOUT,"()")

 99   continue

      write(STDOUT,"()")

      call mf_restore_fpe( )

#endif
   end subroutine msDisplay_mfUnit
