! f90 include file

!_______________________________________________________________________
!
   subroutine Implem_msDisp_mf_sparse_cmplx( x_arg, string, unit )

      type(mfArray) :: x_arg
      character(len=*), intent(in) :: string
      type(mfUnit), intent(in), optional :: unit
      !------ API end ------

#ifdef _DEVLP
      type(mfArray) :: x
      logical :: x_allocated

      integer :: m, n, i, j, nz, nzmax

      character(len=75) :: phys_dim_str, phys_unit_str, phys_dim_req_str
      integer :: status
      character(len=80) :: fmt, fmt2
      real(kind=MF_DOUBLE) :: re, im

   !------ end of declarations -- execution starts hereafter  ------

      call msInitArgs( x_arg )

      ! warning, 'x_arg' is the argument name, but in the following
      ! we are working with 'x'
      x%data_type = x_arg%data_type
      x%shape = x_arg%shape
      x%units = x_arg%units
      x_allocated = .false.

      write(STDOUT,"()")
      write(STDOUT,*) trim(string), " ="
      if( mf_phys_units ) then
         if( present(unit) ) then
            if( unit%abbrev == "S.I." ) then
               call process_units( x%units, phys_dim_str )
               ! special case where MUESLI must try to find
               ! the unit name
               call find_unit_name_from_units( x%units, phys_unit_str )
            else
               call process_units( x%units, phys_dim_str, unit, phys_unit_str )
               call verif_adim( x%units, unit%units, status )
               if( status /= 0 ) then
                  call process_units( unit%units, phys_dim_req_str )
                  call PrintMessage( "msDisplay", "E",                  &
                                     "required unit for printing not consistent", &
                                     "with the physical dimension of the mfArray!", &
                                     "Current physical dimension is : " // trim(phys_dim_str), &
                                     "Required unit for printing is : " // trim(phys_dim_req_str) )
                  go to 99
               end if
            end if
            write(STDOUT,*) trim(phys_dim_str), " ", trim(phys_unit_str)
            ! 'x' is modified only if the required physical unit
            ! is different from an SI unit.
            if( unit%value /= 1.0d0 ) then
               n = x%shape(2)
               nz = x_arg%j(n+1)-1
               allocate( x%z(n) )

               x%z(:) = x_arg%z(:) / unit%value
               x_allocated = .true.
            end if
         else
            call process_units( x%units, phys_dim_str )
            write(STDOUT,*) trim(phys_dim_str)
         end if
      end if
      write(STDOUT,"()")

      if( .not. x_allocated ) then
         x%z => x_arg%z
      end if

      ! eventually, one of the two dimension can be zero (used, e. g.,
      ! when we concat a matrix iteratively by a column vector),
      ! but not both.
      if( all( x%shape == [ 0, 0 ] ) ) then
         call PrintMessage( "msDisplay", "W",                           &
                            "all dims of the mfArray 'x' are zero!" )
         go to 99
      end if

      m = x%shape(1)
      n = x%shape(2)

      write(STDOUT,"(5X,A,I0,A,I0)") "complex sparse matrix of shape : ", m, ", ", n
      if( size(x_arg%j) > n+1 ) then
         write(STDOUT,"(5X,A,I0,A)") "(ncolmax : ", size(x_arg%j)-1, ")"
      end if
      ! check validity of the CSC structure
      nz = x_arg%j(n+1)-1
      nzmax = size(x_arg%z)
      write(STDOUT,"(5X,A,I0,A,I0)") "nz : ", nz, ", nzmax : ", nzmax
      if( nz > nzmax ) then
         write(STDERR,*) "(MUESLI msDisplay:) internal error:"
         write(STDERR,*) "                    in the current CSC structure:"
         write(STDERR,*) "                    nz > nzmax!"
         mf_message_displayed = .true.
         call muesli_trace( pause ="yes" )
         stop
      end if

      fmt2 = "(5X,'(',I0,',',I0,')')"
      if( mf_short_mantissa ) then
         fmt = "(5X,'(',I0,',',I0,')',2X,ES12.4E3,2X,ES12.4E3)"
         do j = 1, n
            do i = x_arg%j(j), x_arg%j(j+1)-1
               if( mf_isfinite(x%z(i)) ) then
                  write(STDOUT,fmt) x_arg%i(i), j, x%z(i)
               else
                  write(STDOUT,fmt2,advance="no") x_arg%i(i), j
                  re = real(x%z(i))
                  if( mf_isnan(re) ) then
                     write(STDOUT,"(A)",advance="no") "   NaN        "
                  else if( re == MF_INF ) then
                     write(STDOUT,"(A)",advance="no") "   Inf        "
                  else if( re == -MF_INF ) then
                     write(STDOUT,"(A)",advance="no") "  -Inf        "
                  else
                     write(STDOUT,"(2X,ES12.4E3)",advance="no") re
                  end if
                  im = aimag(x%z(i))
                  if( mf_isnan(im) ) then
                     write(STDOUT,"(A)",advance="no") "   NaN"
                  else if( im == MF_INF ) then
                     write(STDOUT,"(A)",advance="no") "   Inf"
                  else if( im == -MF_INF ) then
                     write(STDOUT,"(A)",advance="no") "  -Inf"
                  else
                     write(STDOUT,"(2X,ES12.4E3)",advance="no") im
                  end if
                  write(STDOUT,*)
               end if
            end do
         end do
      else ! long format
         fmt = "(5X,'(',I0,',',I0,')',2X,ES22.14E3,2X,ES22.14E3)"
         do j = 1, n
            do i = x_arg%j(j), x_arg%j(j+1)-1
               if( mf_isfinite(x%z(i)) ) then
                  write(STDOUT,fmt) x_arg%i(i), j, x%z(i)
               else
                  write(STDOUT,fmt2,advance="no") x_arg%i(i), j
                  re = real(x%z(i))
                  if( mf_isnan(re) ) then
                     write(STDOUT,"(A)",advance="no") "   NaN                  "
                  else if( re == MF_INF ) then
                     write(STDOUT,"(A)",advance="no") "   Inf                  "
                  else if( re == -MF_INF ) then
                     write(STDOUT,"(A)",advance="no") "  -Inf                  "
                  else
                     write(STDOUT,"(2X,ES22.14E3)",advance="no") re
                  end if
                  im = aimag(x%z(i))
                  if( mf_isnan(im) ) then
                     write(STDOUT,"(A)",advance="no") "   NaN"
                  else if( im == MF_INF ) then
                     write(STDOUT,"(A)",advance="no") "   Inf"
                  else if( im == -MF_INF ) then
                     write(STDOUT,"(A)",advance="no") "  -Inf"
                  else
                     write(STDOUT,"(2X,ES22.14E3)",advance="no") im
                  end if
                  write(STDOUT,*)
               end if
            end do
         end do
      end if


 99   continue

      write(STDOUT,"()")

      if( x_allocated ) then
         deallocate( x%z )

      end if

      call msFreeArgs( x_arg )
      call msAutoRelease( x_arg )

#endif
   end subroutine Implem_msDisp_mf_sparse_cmplx
