! f90 include file

!_______________________________________________________________________
!
   subroutine msDisplay_mf_Int_List_vec( x, string, compact )

      type(mf_Int_List), intent(in)           :: x(:)
      character(len=*),  intent(in), optional :: string
      logical,           intent(in), optional :: compact
      !------ API end ------

#ifdef _DEVLP
      integer :: m, n, len_fmt, ncol_shell, xmax
      character(len=10) :: fmt_int
      character(len=1024) :: line
      character(len=20) :: str_tmp
      integer :: i, j, l, len_number
      logical :: fmt_compact

   !------ end of declarations -- execution starts hereafter  ------

      if( present(string) ) then
         write(STDOUT,"()")
         write(STDOUT,*) trim(string), " ="
      end if
      write(STDOUT,"()")

      if( present(compact) ) then
         fmt_compact = compact
      else
         fmt_compact = .false.
      end if

      ncol_shell = mfGetTermWidth()

      m = size(x)

      do i = 1, m

         write(str_tmp,"(2X,I0,':')") i
         len_number = len_trim(str_tmp)
         line = trim(str_tmp)
         l = len_number

         if( allocated(x(i)%list) ) then
            n = size(x(i)%list)
         else
            n = 0
         end if

         if( n == 0 ) then
            write(str_tmp,"(A)") "  <EMPTY>"
            line = trim(line) // trim(str_tmp)
            write(STDOUT,"(A)") trim(line)
            write(STDOUT,"()")
            cycle
         end if

         if( fmt_compact ) then
            fmt_int = "(I0)"
         else
            xmax = maxval(abs(x(i)%list))
            if( xmax == 0 ) then
               ! avoid negative infinite
               len_fmt = 1
            else
               len_fmt = log10(real(xmax)) + 1
            end if
            write(fmt_int,"('(I',I0,')')") len_fmt
         end if

         j = 1
         do
            ! filling 'line' up to its end
            write(str_tmp,fmt_int) x(i)%list(j)
            len_number = len_trim(str_tmp)
            if( l+len_number+2+4 > ncol_shell ) then
               line(ncol_shell-3:ncol_shell) = " ..."
               write(STDOUT,"(A)") trim(line)
               line = ""
               l = 4
            end if
            line = line(1:l) // "  " // trim(str_tmp)
            l = l + len_number + 2
            j = j + 1
            if( j > n ) exit
         end do
         ! flush the remain of the numbers
         write(STDOUT,"(A)") trim(line)
         write(STDOUT,"()")

      end do

#endif
   end subroutine msDisplay_mf_Int_List_vec
