! f90 include file

!_______________________________________________________________________
!
   subroutine Implem_msDisplay_mfArray_cmplx( x_arg, string, unit )

      type(mfArray) :: x_arg
      character(len=*), intent(in) :: string
      type(mfUnit), intent(in), optional :: unit
      !------ API end ------

#ifdef _DEVLP
      type(mfArray) :: x
      logical :: x_allocated

      character(len=10) :: fmt_short_re  = "F8.4"
      integer       :: len_fmt_short_re  = 8

      character(len=10) :: fmt_short_im  = "F7.4"
      integer       :: len_fmt_short_im  = 7

      character(len=10) :: fmt_long_re   = "F18.14"
      integer       :: len_fmt_long_re   = 18

      character(len=10) :: fmt_long_im   = "F17.14"
      integer       :: len_fmt_long_im   = 17

      character(len=10) :: fmt_sci_short_re = "ES12.4E3"
      integer       :: len_fmt_sci_short_re = 12

      character(len=10) :: fmt_sci_short_im = "ES11.4E3"
      integer       :: len_fmt_sci_short_im = 11

      character(len=10) :: fmt_sci_long_re  = "ES22.14E3"
      integer       :: len_fmt_sci_long_re  = 22

      character(len=10) :: fmt_sci_long_im  = "ES21.14E3"
      integer       :: len_fmt_sci_long_im  = 21

      character(len=10) :: fmt_used_re
      character(len=10) :: fmt_used_im
      character(len=80) :: fmt, fmt2

      character(len=12) :: re_char_12, im_char_12
      character(len=22) :: re_char_22, im_char_22

      character(len=1) :: sign_imag
      integer :: i, j, jdeb, jfin, ncol_max, ncol_shell,                &
                 len_fmt, len_fmt_re, len_fmt_im
      real(kind=MF_DOUBLE) :: log10_x_max, scale, power_threshold, re, im
      integer :: power_scale
      real(kind=MF_DOUBLE) :: max_val_abs_re, max_val_abs_im, max_val_abs
      logical :: float_small

      real(kind=MF_DOUBLE), allocatable :: x_abs(:,:)
      logical, allocatable :: x_mask(:,:)
      integer :: m, n, x_count
      logical :: x_contains_special_IEEE_values, ellipsis_printed
      logical :: columns_vector, line_vector

      character(len=75) :: phys_dim_str, phys_unit_str, phys_dim_req_str
      integer :: status

   !------ end of declarations -- execution starts hereafter  ------

      call mf_save_and_disable_fpe( )

      ncol_shell = mfGetTermWidth()

      call msInitArgs( x_arg )

      ! warning, 'x_arg' is the argument name, but in the following
      ! we are working with 'x'
      x%data_type = x_arg%data_type
      x%shape = x_arg%shape
      x%units = x_arg%units
      x_allocated = .false.

      write(STDOUT,"()")
      write(STDOUT,*) trim(string), " ="
      if( mf_phys_units ) then
         if( present(unit) ) then
            if( unit%abbrev == "S.I." ) then
               call process_units( x%units, phys_dim_str )
               ! special case where MUESLI must try to find
               ! the unit name
               call find_unit_name_from_units( x%units, phys_unit_str )
            else
               call process_units( x%units, phys_dim_str, unit, phys_unit_str )
               call verif_adim( x%units, unit%units, status )
               if( status /= 0 ) then
                  call process_units( unit%units, phys_dim_req_str )
                  call PrintMessage( "msDisplay", "E",                  &
                                     "required unit for printing not consistent", &
                                     "with the physical dimension of the mfArray!", &
                                     "Current physical dimension is : " // trim(phys_dim_str), &
                                     "Required unit for printing is : " // trim(phys_dim_req_str) )
                  go to 99
               end if
            end if
            write(STDOUT,*) trim(phys_dim_str), " ", trim(phys_unit_str)
            ! 'x' is modified only if the required physical unit
            ! is different from an SI unit.
            if( unit%value /= 1.0d0 ) then
               m = x%shape(1)
               n = x%shape(2)
               allocate( x%cmplx(m,n) )

               x%cmplx(:,:) = x_arg%cmplx(:,:) / unit%value
               x_allocated = .true.
            end if
         else
            call process_units( x%units, phys_dim_str )
            write(STDOUT,*) trim(phys_dim_str)
         end if
      end if
      write(STDOUT,"()")

      if( .not. x_allocated ) then
         x%cmplx => x_arg%cmplx
      end if

      ! eventually, one of the two dimension can be zero (used, e. g.,
      ! when we concat a matrix iteratively by a column vector, or
      ! result of a mfFind inquiry), but not both.
      if( all( x%shape == [ 0, 0 ] ) ) then
         call PrintMessage( "msDisplay", "W",                           &
                            "all dims of the mfArray 'x' are zero!" )
         go to 99
      end if

      if( any( x%shape == [ 0, 0 ] ) ) then
         write(STDOUT,*) " <EMPTY>"
         write(STDOUT,"()")
         go to 99
      end if

      m = x%shape(1)
      n = x%shape(2)

      if( m == 1 ) then
         line_vector = .true.
      else
         line_vector = .false.
      end if
      columns_vector = .not. line_vector

      allocate( x_abs(m,n) )
      allocate( x_mask(m,n) )
      x_contains_special_IEEE_values = .false.
      ! real part...
      x_abs(:,:) = abs(real(x%cmplx))
      x_mask(:,:) = mf_isfinite(x_abs)
      x_count = count( x_mask )
      if( x_count == 0 ) then
         ! All values are Inf and/or NaN
         max_val_abs_re = 0.0d0
         x_contains_special_IEEE_values = .true.
      else
         ! avoid special IEEE values (Inf, NaN)
         max_val_abs_re = maxval(x_abs,MASK=x_mask)
         if( x_count /= m*n ) then
            x_contains_special_IEEE_values = .true.
         end if
      end if
      ! imag part...
      x_abs(:,:) = abs(aimag(x%cmplx))
      x_mask(:,:) = mf_isfinite(x_abs)
      x_count = count( x_mask )
      if( x_count == 0 ) then
         ! All values are Inf and/or NaN
         max_val_abs_im = 0.0d0
         x_contains_special_IEEE_values = .true.
      else
         ! avoid special IEEE values (Inf, NaN)
         max_val_abs_im = maxval(x_abs,MASK=x_mask)
         if( x_count /= m*n ) then
            x_contains_special_IEEE_values = .true.
         end if
      end if
      max_val_abs = max( max_val_abs_re, max_val_abs_im )

      ! general cases
      float_small = .true.
      if( mf_display_exponent /= "sci" ) then ! "auto" or "eng"

         if( max_val_abs == 0.0d0 ) then
            log10_x_max = 0.0d0
         else
            log10_x_max = log10(max_val_abs)
         end if
         if( mf_short_mantissa ) then
            power_threshold = 2.0d0
         else
            power_threshold = 2.0d0
         end if
         if( abs(log10_x_max) >= power_threshold ) then
            float_small = .false.
         end if
         power_scale = int(log10_x_max)
         if( mf_display_exponent == "eng" ) then
            if( int(log10_x_max) < 0 ) then
               power_scale = ((power_scale)/3)*3
            else
               power_scale = ((power_scale+1)/3)*3
            end if
            if( power_scale /= 0 ) then
               float_small = .false.
            else
               float_small = .true.
            end if
         end if

         if( mf_short_mantissa ) then
            ! short mantissa
            fmt_used_re = fmt_short_re
            fmt_used_im = fmt_short_im
            len_fmt_re = len_fmt_short_re
            len_fmt_im = len_fmt_short_im
         else
            ! long mantissa
            fmt_used_re = fmt_long_re
            fmt_used_im = fmt_long_im
            len_fmt_re = len_fmt_long_re
            len_fmt_im = len_fmt_long_im
         end if

      else if( mf_display_exponent == "sci" ) then

         if( mf_short_mantissa ) then
            ! short mantissa
            fmt_used_re = fmt_sci_short_re
            fmt_used_im = fmt_sci_short_im
            len_fmt_re = len_fmt_sci_short_re
            len_fmt_im = len_fmt_sci_short_im
         else
            ! long mantissa
            fmt_used_re = fmt_sci_long_re
            fmt_used_im = fmt_sci_long_im
            len_fmt_re = len_fmt_sci_long_re
            len_fmt_im = len_fmt_sci_long_im
         end if

      end if
      len_fmt = len_fmt_re + len_fmt_im + 3
      ncol_max = ncol_shell / ( len_fmt + 1 )

      fmt = "(1X," // trim(fmt_used_re) // ",',',A1," //                &
                      trim(fmt_used_im) // ",A1)"
      if( float_small ) then ! small float
         if( n <= ncol_max ) then
            if( x_contains_special_IEEE_values ) then
               if( mf_short_mantissa ) then
                  ellipsis_printed = .false.
                  if( columns_vector ) then
                     do i = 1, m
                        if( mf_display_line_head_or_tail ) then
                           if( i > mf_display_head_length .and.         &
                               m-i+1 > mf_display_tail_length ) then
                              if( .not. ellipsis_printed ) then
                                 write(STDOUT,"(A,I0,A)") "  ... (",    &
                                       m - mf_display_head_length - mf_display_tail_length, &
                                       " lines skipped)"
                                 ellipsis_printed = .true.
                              end if
                              cycle
                           end if
                        end if
                        do j = 1, n
                           sign_imag = "+"
                           im = aimag(x%cmplx(i,j))
                           if( im < 0.0d0 ) then
                              sign_imag = "-"
                           end if

                           re = real(x%cmplx(i,j))
                           re_char_12 = ""
                           if( mf_isnan(re) ) then ! NaN
                              re_char_12(len_fmt_re-4:len_fmt_re-1) = " NaN"
                           else if( re == MF_INF ) then
                              re_char_12(len_fmt_re-4:len_fmt_re-1) = " Inf"
                           else if( re == -MF_INF ) then
                              re_char_12(len_fmt_re-4:len_fmt_re-1) = "-Inf"
                           else
                              fmt2 = "("//fmt_used_re//")"
                              write(re_char_12,fmt2) re
                           end if
                           im = abs(im)
                           im_char_12 = ""
                           if( mf_isnan(im) ) then ! NaN
                              im_char_12(len_fmt_im-4:len_fmt_im-1) = " NaN"
                           else if( im == MF_INF ) then
                              im_char_12(len_fmt_im-4:len_fmt_im-1) = " Inf"
                           else
                              fmt2 = "("//fmt_used_im//")"
                              write(im_char_12,fmt2) im
                           end if

                           write(*,"(A)",advance="no") " " // re_char_12(1:len_fmt_re) // &
                                                       "," // sign_imag &
                                                           // im_char_12(1:len_fmt_im) // "i"
                        end do
                        write(STDOUT,"()")
                     end do
                  else ! line_vector with m = 1
                     if( mf_display_line_head_or_tail ) then
                        write(STDOUT,"(A,I0,A,/)") "  (",               &
                              n - mf_display_head_length - mf_display_tail_length, &
                              " values skipped)"
                     end if
                     do j = 1, n
                        if( mf_display_line_head_or_tail ) then
                           if( j > mf_display_head_length .and.         &
                               n-j+1 > mf_display_tail_length ) then
                              if( .not. ellipsis_printed ) then
                                 write(STDOUT,"(A)",advance='no') "         ...       "
                                 ellipsis_printed = .true.
                              end if
                              cycle
                           end if
                        end if
                        sign_imag = "+"
                        im = aimag(x%cmplx(1,j))
                        if( im < 0.0d0 ) then
                           sign_imag = "-"
                        end if

                        re = real(x%cmplx(1,j))
                        re_char_12 = ""
                        if( mf_isnan(re) ) then ! NaN
                           re_char_12(len_fmt_re-4:len_fmt_re-1) = " NaN"
                        else if( re == MF_INF ) then
                           re_char_12(len_fmt_re-4:len_fmt_re-1) = " Inf"
                        else if( re == -MF_INF ) then
                           re_char_12(len_fmt_re-4:len_fmt_re-1) = "-Inf"
                        else
                           fmt2 = "("//fmt_used_re//")"
                           write(re_char_12,fmt2) re
                        end if
                        im = abs(im)
                        im_char_12 = ""
                        if( mf_isnan(im) ) then ! NaN
                           im_char_12(len_fmt_im-4:len_fmt_im-1) = " NaN"
                        else if( im == MF_INF ) then
                           im_char_12(len_fmt_im-4:len_fmt_im-1) = " Inf"
                        else
                           fmt2 = "("//fmt_used_im//")"
                           write(im_char_12,fmt2) im
                        end if

                        write(*,"(A)",advance="no") " " // re_char_12(1:len_fmt_re) // &
                                                    "," // sign_imag    &
                                                        // im_char_12(1:len_fmt_im) // "i"
                     end do
                     write(STDOUT,"()")
                  end if
               else ! long mantissa
                  ellipsis_printed = .false.
                  if( columns_vector ) then
                     do i = 1, m
                        if( mf_display_line_head_or_tail ) then
                           if( i > mf_display_head_length .and.         &
                               m-i+1 > mf_display_tail_length ) then
                              if( .not. ellipsis_printed ) then
                                 write(STDOUT,"(A,I0,A)") "  ... (",    &
                                       m - mf_display_head_length - mf_display_tail_length, &
                                       " lines skipped)"
                                 ellipsis_printed = .true.
                              end if
                              cycle
                           end if
                        end if
                        do j = 1, n
                           sign_imag = "+"
                           im = aimag(x%cmplx(i,j))
                           if( im < 0.0d0 ) then
                              sign_imag = "-"
                           end if

                           re = real(x%cmplx(i,j))
                           re_char_22 = ""
                           if( mf_isnan(re) ) then ! NaN
                              re_char_22(len_fmt_re-4:len_fmt_re-1) = " NaN"
                           else if( re == MF_INF ) then
                              re_char_22(len_fmt_re-4:len_fmt_re-1) = " Inf"
                           else if( re == -MF_INF ) then
                              re_char_22(len_fmt_re-4:len_fmt_re-1) = "-Inf"
                           else
                              fmt2 = "("//fmt_used_re//")"
                              write(re_char_22,fmt2) re
                           end if
                           im = abs(im)
                           im_char_22 = ""
                           if( mf_isnan(im) ) then ! NaN
                              im_char_22(len_fmt_im-4:len_fmt_im-1) = " NaN"
                           else if( im == MF_INF ) then
                              im_char_22(len_fmt_im-4:len_fmt_im-1) = " Inf"
                           else
                              fmt2 = "("//fmt_used_im//")"
                              write(im_char_22,fmt2) im
                           end if

                           write(*,"(A)",advance="no") " " // re_char_22(1:len_fmt_re) // &
                                                       "," // sign_imag &
                                                           // im_char_22(1:len_fmt_im) // "i"
                        end do
                        write(STDOUT,"()")
                     end do
                  else ! line_vector with m = 1
                     if( mf_display_line_head_or_tail ) then
                        write(STDOUT,"(A,I0,A,/)") "  (",               &
                              n - mf_display_head_length - mf_display_tail_length, &
                              " values skipped)"
                     end if
                     do j = 1, n
                        if( mf_display_line_head_or_tail ) then
                           if( j > mf_display_head_length .and.         &
                               n-j+1 > mf_display_tail_length ) then
                              if( .not. ellipsis_printed ) then
                                 write(STDOUT,"(A)",advance='no') "                   ...                 "
                                 ellipsis_printed = .true.
                              end if
                              cycle
                           end if
                        end if
                        sign_imag = "+"
                        im = aimag(x%cmplx(1,j))
                        if( im < 0.0d0 ) then
                           sign_imag = "-"
                        end if

                        re = real(x%cmplx(1,j))
                        re_char_22 = ""
                        if( mf_isnan(re) ) then ! NaN
                           re_char_22(len_fmt_re-4:len_fmt_re-1) = " NaN"
                        else if( re == MF_INF ) then
                           re_char_22(len_fmt_re-4:len_fmt_re-1) = " Inf"
                        else if( re == -MF_INF ) then
                           re_char_22(len_fmt_re-4:len_fmt_re-1) = "-Inf"
                        else
                           fmt2 = "("//fmt_used_re//")"
                           write(re_char_22,fmt2) re
                        end if
                        im = abs(im)
                        im_char_22 = ""
                        if( mf_isnan(im) ) then ! NaN
                           im_char_22(len_fmt_im-4:len_fmt_im-1) = " NaN"
                        else if( im == MF_INF ) then
                           im_char_22(len_fmt_im-4:len_fmt_im-1) = " Inf"
                        else
                           fmt2 = "("//fmt_used_im//")"
                           write(im_char_22,fmt2) im
                        end if

                        write(*,"(A)",advance="no") " " // re_char_22(1:len_fmt_re) // &
                                                    "," // sign_imag    &
                                                        // im_char_22(1:len_fmt_im) // "i"
                     end do
                     write(STDOUT,"()")
                  end if
               end if
            else ! .not. x_contains_special_IEEE_values
               if( mf_display_line_head_or_tail ) then
                  ellipsis_printed = .false.
                  if( columns_vector ) then
                     do i = 1, m
                        if( i > mf_display_head_length .and.            &
                            m-i+1 > mf_display_tail_length ) then
                           if( .not. ellipsis_printed ) then
                              write(STDOUT,"(A,I0,A)") "  ... (",       &
                                                m - mf_display_head_length - mf_display_tail_length, &
                                                " lines skipped)"
                              ellipsis_printed = .true.
                           end if
                           cycle
                        end if
                        do j = 1, n
                           sign_imag = "+"
                           im = aimag(x%cmplx(i,j))
                           if( im < 0.0d0 ) then
                              sign_imag = "-"
                           end if
                           write(*,fmt,advance="no") real(x%cmplx(i,j)), &
                                                     sign_imag,         &
                                                     abs(aimag(x%cmplx(i,j))), &
                                                     "i"
                        end do
                        write(STDOUT,"()")
                     end do
                  else ! line_vector with m = 1
                     write(STDOUT,"(A,I0,A,/)") "  (",                  &
                           n - mf_display_head_length - mf_display_tail_length, &
                           " values skipped)"
                     do j = 1, n
                        if( j > mf_display_head_length .and.            &
                            n-j+1 > mf_display_tail_length ) then
                           if( .not. ellipsis_printed ) then
                              if( mf_short_mantissa ) then
                                 write(STDOUT,"(A)",advance='no') "         ...       "
                              else
                                 write(STDOUT,"(A)",advance='no') "                   ...                 "
                              end if
                              ellipsis_printed = .true.
                           end if
                           cycle
                        end if
                        sign_imag = "+"
                        im = aimag(x%cmplx(1,j))
                        if( im < 0.0d0 ) then
                           sign_imag = "-"
                        end if
                        write(*,fmt,advance="no") real(x%cmplx(1,j)),   &
                                                  sign_imag,            &
                                                  abs(aimag(x%cmplx(1,j))), &
                                                  "i"
                     end do
                     write(STDOUT,"()")
                  end if
               else
                  if( columns_vector ) then
                     do i = 1, m
                        do j = 1, n
                           sign_imag = "+"
                           im = aimag(x%cmplx(i,j))
                           if( im < 0.0d0 ) then
                              sign_imag = "-"
                           end if
                           write(*,fmt,advance="no") real(x%cmplx(i,j)), &
                                                     sign_imag,         &
                                                     abs(aimag(x%cmplx(i,j))), &
                                                     "i"
                        end do
                        write(STDOUT,"()")
                     end do
                  else ! line_vector with m = 1
                     do j = 1, n
                        sign_imag = "+"
                        im = aimag(x%cmplx(1,j))
                        if( im < 0.0d0 ) then
                           sign_imag = "-"
                        end if
                        write(*,fmt,advance="no") real(x%cmplx(1,j)),   &
                                                  sign_imag,            &
                                                  abs(aimag(x%cmplx(1,j))), &
                                                  "i"
                     end do
                     write(STDOUT,"()")
                  end if
               end if
            end if
         else ! n > ncol_max
            if( mf_display_line_head_or_tail .and. line_vector ) then
               write(STDOUT,"(A,I0,A,/)") "  (",                        &
                     n - mf_display_head_length - mf_display_tail_length, &
                     " values skipped)"
               ellipsis_printed = .false.
               if( mf_display_head_length+mf_display_tail_length+1 <= ncol_max ) then
                  if( x_contains_special_IEEE_values ) then
                     if( mf_short_mantissa ) then
                        do j = 1, n
                           if( j > mf_display_head_length .and.         &
                               n-j+1 > mf_display_tail_length ) then
                              if( .not. ellipsis_printed ) then
                                 write(STDOUT,"(A)",advance='no') "         ...       "
                                 ellipsis_printed = .true.
                              end if
                              cycle
                           end if
                           sign_imag = "+"
                           im = aimag(x%cmplx(1,j))
                           if( im < 0.0d0 ) then
                              sign_imag = "-"
                           end if

                           re = real(x%cmplx(1,j))
                           re_char_12 = ""
                           if( mf_isnan(re) ) then ! NaN
                              re_char_12(len_fmt_re-4:len_fmt_re-1) = " NaN"
                           else if( re == MF_INF ) then
                              re_char_12(len_fmt_re-4:len_fmt_re-1) = " Inf"
                           else if( re == -MF_INF ) then
                              re_char_12(len_fmt_re-4:len_fmt_re-1) = "-Inf"
                           else
                              fmt2 = "("//fmt_used_re//")"
                              write(re_char_12,fmt2) re
                           end if
                           im = abs(im)
                           im_char_12 = ""
                           if( mf_isnan(im) ) then ! NaN
                              im_char_12(len_fmt_im-4:len_fmt_im-1) = " NaN"
                           else if( im == MF_INF ) then
                              im_char_12(len_fmt_im-4:len_fmt_im-1) = " Inf"
                           else
                              fmt2 = "("//fmt_used_im//")"
                              write(im_char_12,fmt2) im
                           end if

                           write(*,"(A)",advance="no") " " // re_char_12(1:len_fmt_re) // &
                                                       "," // sign_imag &
                                                           // im_char_12(1:len_fmt_im) // "i"
                        end do
                        write(STDOUT,"()")
                     else ! long mantissa
                        do j = 1, n
                           if( j > mf_display_head_length .and.         &
                               n-j+1 > mf_display_tail_length ) then
                              if( .not. ellipsis_printed ) then
                                 write(STDOUT,"(A)",advance='no') "                   ...                 "
                                 ellipsis_printed = .true.
                              end if
                              cycle
                           end if
                           sign_imag = "+"
                           im = aimag(x%cmplx(1,j))
                           if( im < 0.0d0 ) then
                              sign_imag = "-"
                           end if

                           re = real(x%cmplx(1,j))
                           re_char_22 = ""
                           if( mf_isnan(re) ) then ! NaN
                              re_char_22(len_fmt_re-4:len_fmt_re-1) = " NaN"
                           else if( re == MF_INF ) then
                              re_char_22(len_fmt_re-4:len_fmt_re-1) = " Inf"
                           else if( re == -MF_INF ) then
                              re_char_22(len_fmt_re-4:len_fmt_re-1) = "-Inf"
                           else
                              fmt2 = "("//fmt_used_re//")"
                              write(re_char_22,fmt2) re
                           end if
                           im = abs(im)
                           im_char_22 = ""
                           if( mf_isnan(im) ) then ! NaN
                              im_char_22(len_fmt_im-4:len_fmt_im-1) = " NaN"
                           else if( im == MF_INF ) then
                              im_char_22(len_fmt_im-4:len_fmt_im-1) = " Inf"
                           else
                              fmt2 = "("//fmt_used_im//")"
                              write(im_char_22,fmt2) im
                           end if

                           write(*,"(A)",advance="no") " " // re_char_22(1:len_fmt_re) // &
                                                       "," // sign_imag &
                                                           // im_char_22(1:len_fmt_im) // "i"
                        end do
                        write(STDOUT,"()")
                     end if
                  else ! .not. x_contains_special_IEEE_values
                     do j = 1, n
                        if( j > mf_display_head_length .and.            &
                            n-j+1 > mf_display_tail_length ) then
                           if( .not. ellipsis_printed ) then
                              if( mf_short_mantissa ) then
                                 write(STDOUT,"(A)",advance='no') "         ...       "
                              else
                                 write(STDOUT,"(A)",advance='no') "                   ...                 "
                              end if
                              ellipsis_printed = .true.
                           end if
                           cycle
                        end if
                        sign_imag = "+"
                        im = aimag(x%cmplx(1,j))
                        if( im < 0.0d0 ) then
                           sign_imag = "-"
                        end if
                        write(*,fmt,advance="no") real(x%cmplx(1,j)),   &
                                                  sign_imag,            &
                                                  abs(aimag(x%cmplx(1,j))), &
                                                  "i"
                     end do
                     write(STDOUT,"()")
                  end if
               else
                  write(STDOUT,"(A)") "  <extracted vector too long to be printed on one single line>"
               end if
            else
               jdeb = 1
               do
                  jfin = min( jdeb+ncol_max-1, n )
                  if( jfin > jdeb ) then
                     write(STDOUT,"(a,i0,a,i0,/)") " Columns ", jdeb, " through ", jfin
                  else
                     write(STDOUT,"(a,i0,/)") " Column ", jdeb
                  end if
                  if( x_contains_special_IEEE_values ) then
                     if( mf_short_mantissa ) then
                        do i = 1, m
                           do j = jdeb, jfin
                              sign_imag = "+"
                              im = aimag(x%cmplx(i,j))
                              if( im < 0.0d0 ) then
                                 sign_imag = "-"
                              end if

                              re = real(x%cmplx(i,j))
                              re_char_12 = ""
                              if( mf_isnan(re) ) then ! NaN
                                 re_char_12(len_fmt_re-4:len_fmt_re-1) = " NaN"
                              else if( re == MF_INF ) then
                                 re_char_12(len_fmt_re-4:len_fmt_re-1) = " Inf"
                              else if( re == -MF_INF ) then
                                 re_char_12(len_fmt_re-4:len_fmt_re-1) = "-Inf"
                              else
                                 fmt2 = "("//fmt_used_re//")"
                                 write(re_char_12,fmt2) re
                              end if
                              im = abs(im)
                              im_char_12 = ""
                              if( mf_isnan(im) ) then ! NaN
                                 im_char_12(len_fmt_im-4:len_fmt_im-1) = " NaN"
                              else if( im == MF_INF ) then
                                 im_char_12(len_fmt_im-4:len_fmt_im-1) = " Inf"
                              else
                                 fmt2 = "("//fmt_used_im//")"
                                 write(im_char_12,fmt2) im
                              end if

                              write(*,"(A)",advance="no") " " // re_char_12(1:len_fmt_re) // &
                                                          "," // sign_imag &
                                                              // im_char_12(1:len_fmt_im) // "i"
                           end do
                           write(STDOUT,"()")
                        end do
                     else ! long mantissa
                        do i = 1, m
                           do j = jdeb, jfin
                              sign_imag = "+"
                              im = aimag(x%cmplx(i,j))
                              if( im < 0.0d0 ) then
                                 sign_imag = "-"
                              end if

                              re = real(x%cmplx(i,j))
                              re_char_22 = ""
                              if( mf_isnan(re) ) then ! NaN
                                 re_char_22(len_fmt_re-4:len_fmt_re-1) = " NaN"
                              else if( re == MF_INF ) then
                                 re_char_22(len_fmt_re-4:len_fmt_re-1) = " Inf"
                              else if( re == -MF_INF ) then
                                 re_char_22(len_fmt_re-4:len_fmt_re-1) = "-Inf"
                              else
                                 fmt2 = "("//fmt_used_re//")"
                                 write(re_char_22,fmt2) re
                              end if
                              im = abs(im)
                              im_char_22 = ""
                              if( mf_isnan(im) ) then ! NaN
                                 im_char_22(len_fmt_im-4:len_fmt_im-1) = " NaN"
                              else if( im == MF_INF ) then
                                 im_char_22(len_fmt_im-4:len_fmt_im-1) = " Inf"
                              else
                                 fmt2 = "("//fmt_used_im//")"
                                 write(im_char_22,fmt2) im
                              end if

                              write(*,"(A)",advance="no") " " // re_char_22(1:len_fmt_re) // &
                                                          "," // sign_imag &
                                                              // im_char_22(1:len_fmt_im) // "i"
                           end do
                           write(STDOUT,"()")
                        end do
                     end if
                  else ! .not. x_contains_special_IEEE_values
                     do i = 1, m
                        do j = jdeb, jfin
                           sign_imag = "+"
                           im = aimag(x%cmplx(i,j))
                           if( im < 0.0d0 ) then
                              sign_imag = "-"
                           end if
                           write(*,fmt,advance="no") real(x%cmplx(i,j)), &
                                                     sign_imag,         &
                                                     abs(aimag(x%cmplx(i,j))), &
                                                     "i"
                        end do
                        write(STDOUT,"()")
                     end do
                  end if
                  jdeb = jdeb + ncol_max
                  if( jdeb > n ) then
                     exit
                  end if
                  write(STDOUT,"()")
               end do
            end if
         end if
      else ! large float ("auto" or "eng" format)
         scale = 10.0d0**power_scale
         if( m==1 .and. n==1 ) then
            if( mf_short_mantissa ) then
               if( mf_display_exponent == "eng" ) then
                  fmt2 = "(1X,EN14.4E3,',',A1,EN13.4E3,A1)"
               else
                  fmt2 = "(1X,ES12.4E3,',',A1,ES11.4E3,A1)"
               end if
            else
               if( mf_display_exponent == "eng" ) then
                  fmt2 = "(1X,EN24.14E3,',',A1,EN23.14E3,A1)"
               else
                  fmt2 = "(1X,ES22.14E3,',',A1,ES21.14E3,A1)"
               end if
            end if
            if( aimag(x%cmplx(1,1)) >= 0.0d0 ) then
               sign_imag = "+"
            else
               sign_imag = "-"
            end if
            write(STDOUT,fmt2) real(x%cmplx(1,1)), sign_imag,           &
                               abs(aimag(x%cmplx(1,1))), "i"
            go to 99
         else
            write(STDOUT,"(2X,ES9.1E3,A,/)") scale, " *"
         end if
         if( n <= ncol_max ) then
            if( x_contains_special_IEEE_values ) then
               if( mf_short_mantissa ) then
                  ellipsis_printed = .false.
                  if( columns_vector ) then
                     do i = 1, m
                        if( mf_display_line_head_or_tail ) then
                           if( i > mf_display_head_length .and.         &
                               m-i+1 > mf_display_tail_length ) then
                              if( .not. ellipsis_printed ) then
                                 write(STDOUT,"(A,I0,A)") "  ... (",    &
                                                   m - mf_display_head_length - mf_display_tail_length, &
                                                   " lines skipped)"
                                 ellipsis_printed = .true.
                              end if
                              cycle
                           end if
                        end if
                        do j = 1, n
                           sign_imag = "+"
                           im = aimag(x%cmplx(i,j))
                           if( im < 0.0d0 ) then
                              sign_imag = "-"
                           end if

                           re = real(x%cmplx(i,j))
                           re_char_12 = ""
                           if( mf_isnan(re) ) then ! NaN
                              re_char_12(len_fmt_re-4:len_fmt_re-1) = " NaN"
                           else if( re == MF_INF ) then
                              re_char_12(len_fmt_re-4:len_fmt_re-1) = " Inf"
                           else if( re == -MF_INF ) then
                              re_char_12(len_fmt_re-4:len_fmt_re-1) = "-Inf"
                           else
                              fmt2 = "("//fmt_used_re//")"
                              write(re_char_12,fmt2) re/scale
                           end if
                           im = abs(im)
                           im_char_12 = ""
                           if( mf_isnan(im) ) then ! NaN
                              im_char_12(len_fmt_im-4:len_fmt_im-1) = " NaN"
                           else if( im == MF_INF ) then
                              im_char_12(len_fmt_im-4:len_fmt_im-1) = " Inf"
                           else
                              fmt2 = "("//fmt_used_im//")"
                              write(im_char_12,fmt2) im/scale
                           end if

                           write(*,"(A)",advance="no") " " // re_char_12(1:len_fmt_re) // &
                                                       "," // sign_imag &
                                                           // im_char_12(1:len_fmt_im) // "i"
                        end do
                        write(STDOUT,"()")
                     end do
                  else ! line_vector with m = 1
                     if( mf_display_line_head_or_tail ) then
                        write(STDOUT,"(A,I0,A,/)") "  (",               &
                              n - mf_display_head_length - mf_display_tail_length, &
                              " values skipped)"
                     end if
                     do j = 1, n
                        if( mf_display_line_head_or_tail ) then
                           if( j > mf_display_head_length .and.         &
                               n-j+1 > mf_display_tail_length ) then
                              if( .not. ellipsis_printed ) then
                                 write(STDOUT,"(A)",advance='no') "         ...       "
                                 ellipsis_printed = .true.
                              end if
                              cycle
                           end if
                        end if
                        sign_imag = "+"
                        im = aimag(x%cmplx(1,j))
                        if( im < 0.0d0 ) then
                           sign_imag = "-"
                        end if

                        re = real(x%cmplx(1,j))
                        re_char_12 = ""
                        if( mf_isnan(re) ) then ! NaN
                           re_char_12(len_fmt_re-4:len_fmt_re-1) = " NaN"
                        else if( re == MF_INF ) then
                           re_char_12(len_fmt_re-4:len_fmt_re-1) = " Inf"
                        else if( re == -MF_INF ) then
                           re_char_12(len_fmt_re-4:len_fmt_re-1) = "-Inf"
                        else
                           fmt2 = "("//fmt_used_re//")"
                           write(re_char_12,fmt2) re/scale
                        end if
                        im = abs(im)
                        im_char_12 = ""
                        if( mf_isnan(im) ) then ! NaN
                           im_char_12(len_fmt_im-4:len_fmt_im-1) = " NaN"
                        else if( im == MF_INF ) then
                           im_char_12(len_fmt_im-4:len_fmt_im-1) = " Inf"
                        else
                           fmt2 = "("//fmt_used_im//")"
                           write(im_char_12,fmt2) im/scale
                        end if

                        write(*,"(A)",advance="no") " " // re_char_12(1:len_fmt_re) // &
                                                    "," // sign_imag    &
                                                        // im_char_12(1:len_fmt_im) // "i"
                     end do
                     write(STDOUT,"()")
                  end if
               else ! long mantissa
                  ellipsis_printed = .false.
                  if( columns_vector ) then
                     do i = 1, m
                        if( mf_display_line_head_or_tail ) then
                           if( i > mf_display_head_length .and.         &
                               m-i+1 > mf_display_tail_length ) then
                              if( .not. ellipsis_printed ) then
                                 write(STDOUT,"(A,I0,A)") "  ... (",    &
                                                   m - mf_display_head_length - mf_display_tail_length, &
                                                   " lines skipped)"
                                 ellipsis_printed = .true.
                              end if
                              cycle
                           end if
                        end if
                        do j = 1, n
                           sign_imag = "+"
                           im = aimag(x%cmplx(i,j))
                           if( im < 0.0d0 ) then
                              sign_imag = "-"
                           end if

                           re = real(x%cmplx(i,j))
                           re_char_22 = ""
                           if( mf_isnan(re) ) then ! NaN
                              re_char_22(len_fmt_re-4:len_fmt_re-1) = " NaN"
                           else if( re == MF_INF ) then
                              re_char_22(len_fmt_re-4:len_fmt_re-1) = " Inf"
                           else if( re == -MF_INF ) then
                              re_char_22(len_fmt_re-4:len_fmt_re-1) = "-Inf"
                           else
                              fmt2 = "("//fmt_used_re//")"
                              write(re_char_22,fmt2) re/scale
                           end if
                           im = abs(im)
                           im_char_22 = ""
                           if( mf_isnan(im) ) then ! NaN
                              im_char_22(len_fmt_im-4:len_fmt_im-1) = " NaN"
                           else if( im == MF_INF ) then
                              im_char_22(len_fmt_im-4:len_fmt_im-1) = " Inf"
                           else
                              fmt2 = "("//fmt_used_im//")"
                              write(im_char_22,fmt2) im/scale
                           end if

                           write(*,"(A)",advance="no") " " // re_char_22(1:len_fmt_re) // &
                                                       "," // sign_imag &
                                                           // im_char_22(1:len_fmt_im) // "i"
                        end do
                        write(STDOUT,"()")
                     end do
                  else ! line_vector with m = 1
                     if( mf_display_line_head_or_tail ) then
                        write(STDOUT,"(A,I0,A,/)") "  (",               &
                              n - mf_display_head_length - mf_display_tail_length, &
                              " values skipped)"
                     end if
                     do j = 1, n
                        if( mf_display_line_head_or_tail ) then
                           if( j > mf_display_head_length .and.         &
                               n-j+1 > mf_display_tail_length ) then
                              if( .not. ellipsis_printed ) then
                                 write(STDOUT,"(A)",advance='no') "                   ...                 "
                                 ellipsis_printed = .true.
                              end if
                              cycle
                           end if
                        end if
                        sign_imag = "+"
                        im = aimag(x%cmplx(1,j))
                        if( im < 0.0d0 ) then
                           sign_imag = "-"
                        end if

                        re = real(x%cmplx(1,j))
                        re_char_22 = ""
                        if( mf_isnan(re) ) then ! NaN
                           re_char_22(len_fmt_re-4:len_fmt_re-1) = " NaN"
                        else if( re == MF_INF ) then
                           re_char_22(len_fmt_re-4:len_fmt_re-1) = " Inf"
                        else if( re == -MF_INF ) then
                           re_char_22(len_fmt_re-4:len_fmt_re-1) = "-Inf"
                        else
                           fmt2 = "("//fmt_used_re//")"
                           write(re_char_22,fmt2) re/scale
                        end if
                        im = abs(im)
                        im_char_22 = ""
                        if( mf_isnan(im) ) then ! NaN
                           im_char_22(len_fmt_im-4:len_fmt_im-1) = " NaN"
                        else if( im == MF_INF ) then
                           im_char_22(len_fmt_im-4:len_fmt_im-1) = " Inf"
                        else
                           fmt2 = "("//fmt_used_im//")"
                           write(im_char_22,fmt2) im/scale
                        end if

                        write(*,"(A)",advance="no") " " // re_char_22(1:len_fmt_re) // &
                                                    "," // sign_imag    &
                                                        // im_char_22(1:len_fmt_im) // "i"
                     end do
                     write(STDOUT,"()")
                  end if
               end if
            else ! .not. x_contains_special_IEEE_values
               if( mf_display_line_head_or_tail ) then
                  ellipsis_printed = .false.
                  if( columns_vector ) then
                     do i = 1, m
                        if( i > mf_display_head_length .and.            &
                            m-i+1 > mf_display_tail_length ) then
                           if( .not. ellipsis_printed ) then
                              write(STDOUT,"(A,I0,A)") "  ... (",       &
                                                m - mf_display_head_length - mf_display_tail_length, &
                                                " lines skipped)"
                              ellipsis_printed = .true.
                           end if
                           cycle
                        end if
                        do j = 1, n
                           sign_imag = "+"
                           im = aimag(x%cmplx(i,j))
                           if( im < 0.0d0 ) then
                              sign_imag = "-"
                           end if
                           write(*,fmt,advance="no") real(x%cmplx(i,j))/scale, &
                                                     sign_imag,         &
                                                     abs(aimag(x%cmplx(i,j)))/scale, &
                                                     "i"
                        end do
                        write(STDOUT,"()")
                     end do
                  else ! line_vector with m = 1
                     write(STDOUT,"(A,I0,A,/)") "  (",                  &
                           n - mf_display_head_length - mf_display_tail_length, &
                           " values skipped)"
                     do j = 1, n
                        if( j > mf_display_head_length .and.            &
                            n-j+1 > mf_display_tail_length ) then
                           if( .not. ellipsis_printed ) then
                              if( mf_short_mantissa ) then
                                 write(STDOUT,"(A)",advance='no') "         ...       "
                              else
                                 write(STDOUT,"(A)",advance='no') "                   ...                 "
                              end if
                              ellipsis_printed = .true.
                           end if
                           cycle
                        end if
                        sign_imag = "+"
                        im = aimag(x%cmplx(1,j))
                        if( im < 0.0d0 ) then
                           sign_imag = "-"
                        end if
                        write(*,fmt,advance="no") real(x%cmplx(1,j))/scale, &
                                                  sign_imag,            &
                                                  abs(aimag(x%cmplx(1,j)))/scale, &
                                                  "i"
                     end do
                     write(STDOUT,"()")
                  end if
               else
                  if( columns_vector ) then
                     do i = 1, m
                        do j = 1, n
                           sign_imag = "+"
                           im = aimag(x%cmplx(i,j))
                           if( im < 0.0d0 ) then
                              sign_imag = "-"
                           end if
                           write(*,fmt,advance="no") real(x%cmplx(i,j))/scale, &
                                                     sign_imag,         &
                                                     abs(aimag(x%cmplx(i,j)))/scale, &
                                                     "i"
                        end do
                        write(STDOUT,"()")
                     end do
                  else ! line_vector with m = 1
                     do j = 1, n
                        sign_imag = "+"
                        im = aimag(x%cmplx(1,j))
                        if( im < 0.0d0 ) then
                           sign_imag = "-"
                        end if
                        write(*,fmt,advance="no") real(x%cmplx(1,j))/scale, &
                                                  sign_imag,            &
                                                  abs(aimag(x%cmplx(1,j)))/scale, &
                                                  "i"
                     end do
                     write(STDOUT,"()")
                  end if
               end if
            end if
         else ! n > ncol_max
            if( mf_display_line_head_or_tail .and. line_vector ) then
               write(STDOUT,"(A,I0,A,/)") "  (",                        &
                     n - mf_display_head_length - mf_display_tail_length, &
                     " values skipped)"
               ellipsis_printed = .false.
               if( mf_display_head_length+mf_display_tail_length+1 <= ncol_max ) then
                  if( x_contains_special_IEEE_values ) then
                     if( mf_short_mantissa ) then
                        do j = 1, n
                           if( j > mf_display_head_length .and.         &
                               n-j+1 > mf_display_tail_length ) then
                              if( .not. ellipsis_printed ) then
                                 write(STDOUT,"(A)",advance='no') "         ...       "
                                 ellipsis_printed = .true.
                              end if
                              cycle
                           end if
                           sign_imag = "+"
                           im = aimag(x%cmplx(1,j))
                           if( im < 0.0d0 ) then
                              sign_imag = "-"
                           end if

                           re = real(x%cmplx(1,j))
                           re_char_12 = ""
                           if( mf_isnan(re) ) then ! NaN
                              re_char_12(len_fmt_re-4:len_fmt_re-1) = " NaN"
                           else if( re == MF_INF ) then
                              re_char_12(len_fmt_re-4:len_fmt_re-1) = " Inf"
                           else if( re == -MF_INF ) then
                              re_char_12(len_fmt_re-4:len_fmt_re-1) = "-Inf"
                           else
                              fmt2 = "("//fmt_used_re//")"
                              write(re_char_12,fmt2) re/scale
                           end if
                           im = abs(im)
                           im_char_12 = ""
                           if( mf_isnan(im) ) then ! NaN
                              im_char_12(len_fmt_im-4:len_fmt_im-1) = " NaN"
                           else if( im == MF_INF ) then
                              im_char_12(len_fmt_im-4:len_fmt_im-1) = " Inf"
                           else
                              fmt2 = "("//fmt_used_im//")"
                              write(im_char_12,fmt2) im/scale
                           end if

                           write(*,"(A)",advance="no") " " // re_char_12(1:len_fmt_re) // &
                                                       "," // sign_imag &
                                                           // im_char_12(1:len_fmt_im) // "i"
                        end do
                        write(STDOUT,"()")
                     else ! long mantissa
                        do j = 1, n
                           if( j > mf_display_head_length .and.         &
                               n-j+1 > mf_display_tail_length ) then
                              if( .not. ellipsis_printed ) then
                                 write(STDOUT,"(A)",advance='no') "                   ...                 "
                                 ellipsis_printed = .true.
                              end if
                              cycle
                           end if
                           sign_imag = "+"
                           im = aimag(x%cmplx(1,j))
                           if( im < 0.0d0 ) then
                              sign_imag = "-"
                           end if

                           re = real(x%cmplx(1,j))
                           re_char_22 = ""
                           if( mf_isnan(re) ) then ! NaN
                              re_char_22(len_fmt_re-4:len_fmt_re-1) = " NaN"
                           else if( re == MF_INF ) then
                              re_char_22(len_fmt_re-4:len_fmt_re-1) = " Inf"
                           else if( re == -MF_INF ) then
                              re_char_22(len_fmt_re-4:len_fmt_re-1) = "-Inf"
                           else
                              fmt2 = "("//fmt_used_re//")"
                              write(re_char_22,fmt2) re/scale
                           end if
                           im = abs(im)
                           im_char_22 = ""
                           if( mf_isnan(im) ) then ! NaN
                              im_char_22(len_fmt_im-4:len_fmt_im-1) = " NaN"
                           else if( im == MF_INF ) then
                              im_char_22(len_fmt_im-4:len_fmt_im-1) = " Inf"
                           else
                              fmt2 = "("//fmt_used_im//")"
                              write(im_char_22,fmt2) im/scale
                           end if

                           write(*,"(A)",advance="no") " " // re_char_22(1:len_fmt_re) // &
                                                       "," // sign_imag &
                                                           // im_char_22(1:len_fmt_im) // "i"
                        end do
                        write(STDOUT,"()")
                     end if
                  else ! .not. x_contains_special_IEEE_values
                     do j = 1, n
                        if( j > mf_display_head_length .and.            &
                            n-j+1 > mf_display_tail_length ) then
                           if( .not. ellipsis_printed ) then
                              if( mf_short_mantissa ) then
                                 write(STDOUT,"(A)",advance='no') "         ...       "
                              else
                                 write(STDOUT,"(A)",advance='no') "                   ...                 "
                              end if
                              ellipsis_printed = .true.
                           end if
                           cycle
                        end if
                        sign_imag = "+"
                        im = aimag(x%cmplx(1,j))
                        if( im < 0.0d0 ) then
                           sign_imag = "-"
                        end if
                        write(*,fmt,advance="no") real(x%cmplx(1,j))/scale, &
                                                  sign_imag,            &
                                                  abs(aimag(x%cmplx(1,j)))/scale, &
                                                  "i"
                     end do
                     write(STDOUT,"()")
                  end if
               else
                  write(STDOUT,"(A)") "  <extracted vector too long to be printed on one single line>"
               end if
            else
               jdeb = 1
               do
                  jfin = min( jdeb+ncol_max-1, n )
                  if( jfin > jdeb ) then
                     write(STDOUT,"(a,i0,a,i0,/)") " Columns ", jdeb, " through ", jfin
                  else
                     write(STDOUT,"(a,i0,/)") " Column ", jdeb
                  end if
                  if( x_contains_special_IEEE_values ) then
                     if( mf_short_mantissa ) then
                        do i = 1, m
                           do j = jdeb, jfin
                              sign_imag = "+"
                              im = aimag(x%cmplx(i,j))
                              if( im < 0.0d0 ) then
                                 sign_imag = "-"
                              end if

                              re = real(x%cmplx(i,j))
                              re_char_12 = ""
                              if( mf_isnan(re) ) then ! NaN
                                 re_char_12(len_fmt_re-4:len_fmt_re-1) = " NaN"
                              else if( re == MF_INF ) then
                                 re_char_12(len_fmt_re-4:len_fmt_re-1) = " Inf"
                              else if( re == -MF_INF ) then
                                 re_char_12(len_fmt_re-4:len_fmt_re-1) = "-Inf"
                              else
                                 fmt2 = "("//fmt_used_re//")"
                                 write(re_char_12,fmt2) re/scale
                              end if
                              im = abs(im)
                              im_char_12 = ""
                              if( mf_isnan(im) ) then ! NaN
                                 im_char_12(len_fmt_im-4:len_fmt_im-1) = " NaN"
                              else if( im == MF_INF ) then
                                 im_char_12(len_fmt_im-4:len_fmt_im-1) = " Inf"
                              else
                                 fmt2 = "("//fmt_used_im//")"
                                 write(im_char_12,fmt2) im/scale
                              end if

                              write(*,"(A)",advance="no") " " // re_char_12(1:len_fmt_re) // &
                                                          "," // sign_imag &
                                                              // im_char_12(1:len_fmt_im) // "i"
                           end do
                           write(STDOUT,"()")
                        end do
                     else ! long mantissa
                        do i = 1, m
                           do j = jdeb, jfin
                              sign_imag = "+"
                              im = aimag(x%cmplx(i,j))
                              if( im < 0.0d0 ) then
                                 sign_imag = "-"
                              end if

                              re = real(x%cmplx(i,j))
                              re_char_22 = ""
                              if( mf_isnan(re) ) then ! NaN
                                 re_char_22(len_fmt_re-4:len_fmt_re-1) = " NaN"
                              else if( re == MF_INF ) then
                                 re_char_22(len_fmt_re-4:len_fmt_re-1) = " Inf"
                              else if( re == -MF_INF ) then
                                 re_char_22(len_fmt_re-4:len_fmt_re-1) = "-Inf"
                              else
                                 fmt2 = "("//fmt_used_re//")"
                                 write(re_char_22,fmt2) re/scale
                              end if
                              im = abs(im)
                              im_char_22 = ""
                              if( mf_isnan(im) ) then ! NaN
                                 im_char_22(len_fmt_im-4:len_fmt_im-1) = " NaN"
                              else if( im == MF_INF ) then
                                 im_char_22(len_fmt_im-4:len_fmt_im-1) = " Inf"
                              else
                                 fmt2 = "("//fmt_used_im//")"
                                 write(im_char_22,fmt2) im/scale
                              end if

                              write(*,"(A)",advance="no") " " // re_char_22(1:len_fmt_re) // &
                                                          "," // sign_imag &
                                                              // im_char_22(1:len_fmt_im) // "i"
                           end do
                           write(STDOUT,"()")
                        end do
                     end if
                  else ! .not. x_contains_special_IEEE_values
                     do i = 1, m
                        do j = jdeb, jfin
                           sign_imag = "+"
                           im = aimag(x%cmplx(i,j))
                           if( im < 0.0d0 ) then
                              sign_imag = "-"
                           end if
                           write(*,fmt,advance="no") real(x%cmplx(i,j))/scale, &
                                                     sign_imag,         &
                                                     abs(aimag(x%cmplx(i,j)))/scale, &
                                                     "i"
                        end do
                        write(STDOUT,"()")
                     end do
                  end if
                  jdeb = jdeb + ncol_max
                  if( jdeb > n ) then
                     exit
                  end if
                  write(STDOUT,"()")
               end do
            end if
         end if
      end if

 99   continue

      write(STDOUT,"()")

      if( x_allocated ) then
         deallocate( x%cmplx )

      end if

      call msFreeArgs( x_arg )
      call msAutoRelease( x_arg )

      call mf_restore_fpe( )

#endif
   end subroutine Implem_msDisplay_mfArray_cmplx
