! f90 include file

!_______________________________________________________________________
!
   subroutine msDisplay_int( x1,                                        &
                             string1,                                   &
                             x2, string2, x3, string3, x4, string4 )

      integer,          intent(in)           :: x1
      character(len=*), intent(in), optional :: string1
      integer,          intent(in), optional :: x2, x3, x4
      character(len=*), intent(in), optional :: string2, string3, string4
      !------ API end ------

#ifdef _DEVLP
   !------ end of declarations -- execution starts hereafter  ------

      mf_display_line_head_or_tail = .false.

      if( present(string1) ) then
         call Implem_msDisplay_mfArray_double( mf(x1), string1 )
      else
         call Implem_msDisplay_mfArray_double( mf(x1), "ans" )
      end if

      if( present(x2) .and. present(string2) ) then
         call Implem_msDisplay_mfArray_double( mf(x2), string2 )
      end if

      if( present(x3) .and. present(string3) ) then
         call Implem_msDisplay_mfArray_double( mf(x3), string3 )
      end if

      if( present(x4) .and. present(string4) ) then
         call Implem_msDisplay_mfArray_double( mf(x4), string4 )
      end if

#endif
   end subroutine msDisplay_int
!_______________________________________________________________________
!
   subroutine msDisplay_vec_int( x1,                                    &
                                 string1,                               &
                                 x2, string2, x3, string3, x4, string4 )

      integer,          intent(in)           :: x1(:)
      character(len=*), intent(in), optional :: string1
      integer,          intent(in), optional :: x2(:), x3(:), x4(:)
      character(len=*), intent(in), optional :: string2, string3, string4
      !------ API end ------

#ifdef _DEVLP
   !------ end of declarations -- execution starts hereafter  ------

      mf_display_line_head_or_tail = .false.

      if( present(string1) ) then
         call Implem_msDisplay_mfArray_double( mf(x1), string1 )
      else
         call Implem_msDisplay_mfArray_double( mf(x1), "ans" )
      end if

      if( present(x2) .and. present(string2) ) then
         call Implem_msDisplay_mfArray_double( mf(x2), string2 )
      end if

      if( present(x3) .and. present(string3) ) then
         call Implem_msDisplay_mfArray_double( mf(x3), string3 )
      end if

      if( present(x4) .and. present(string4) ) then
         call Implem_msDisplay_mfArray_double( mf(x4), string4 )
      end if

#endif
   end subroutine msDisplay_vec_int
!_______________________________________________________________________
!
   subroutine msDisplay_array_int( x1,                                  &
                                   string1,                             &
                                   x2, string2, x3, string3, x4, string4 )

      integer,          intent(in)           :: x1(:,:)
      character(len=*), intent(in), optional :: string1
      integer,          intent(in), optional :: x2(:,:), x3(:,:), x4(:,:)
      character(len=*), intent(in), optional :: string2, string3, string4
      !------ API end ------

#ifdef _DEVLP
   !------ end of declarations -- execution starts hereafter  ------

      mf_display_line_head_or_tail = .false.

      if( present(string1) ) then
         call Implem_msDisplay_mfArray_double( mf(x1), string1 )
      else
         call Implem_msDisplay_mfArray_double( mf(x1), "ans" )
      end if

      if( present(x2) .and. present(string2) ) then
         call Implem_msDisplay_mfArray_double( mf(x2), string2 )
      end if

      if( present(x3) .and. present(string3) ) then
         call Implem_msDisplay_mfArray_double( mf(x3), string3 )
      end if

      if( present(x4) .and. present(string4) ) then
         call Implem_msDisplay_mfArray_double( mf(x4), string4 )
      end if

#endif
   end subroutine msDisplay_array_int
!_______________________________________________________________________
!
   subroutine msDisplay_single( x1,                                     &
                                string1,                                &
                                x2, string2, x3, string3, x4, string4 )

      real,             intent(in)           :: x1
      character(len=*), intent(in), optional :: string1
      real,             intent(in), optional :: x2, x3, x4
      character(len=*), intent(in), optional :: string2, string3, string4
      !------ API end ------

#ifdef _DEVLP
   !------ end of declarations -- execution starts hereafter  ------

      mf_display_line_head_or_tail = .false.

      if( present(string1) ) then
         call Implem_msDisplay_mfArray_double( mf(x1), string1 )
      else
         call Implem_msDisplay_mfArray_double( mf(x1), "ans" )
      end if

      if( present(x2) .and. present(string2) ) then
         call Implem_msDisplay_mfArray_double( mf(x2), string2 )
      end if

      if( present(x3) .and. present(string3) ) then
         call Implem_msDisplay_mfArray_double( mf(x3), string3 )
      end if

      if( present(x4) .and. present(string4) ) then
         call Implem_msDisplay_mfArray_double( mf(x4), string4 )
      end if

#endif
   end subroutine msDisplay_single
!_______________________________________________________________________
!
   subroutine msDisplay_vec_single( x1,                                 &
                                    string1,                            &
                                    x2, string2, x3, string3, x4, string4 )

      real,             intent(in)           :: x1(:)
      character(len=*), intent(in), optional :: string1
      real,             intent(in), optional :: x2(:), x3(:), x4(:)
      character(len=*), intent(in), optional :: string2, string3, string4
      !------ API end ------

#ifdef _DEVLP
   !------ end of declarations -- execution starts hereafter  ------

      mf_display_line_head_or_tail = .false.

      if( present(string1) ) then
         call Implem_msDisplay_mfArray_double( mf(x1), string1 )
      else
         call Implem_msDisplay_mfArray_double( mf(x1), "ans" )
      end if

      if( present(x2) .and. present(string2) ) then
         call Implem_msDisplay_mfArray_double( mf(x2), string2 )
      end if

      if( present(x3) .and. present(string3) ) then
         call Implem_msDisplay_mfArray_double( mf(x3), string3 )
      end if

      if( present(x4) .and. present(string4) ) then
         call Implem_msDisplay_mfArray_double( mf(x4), string4 )
      end if

#endif
   end subroutine msDisplay_vec_single
!_______________________________________________________________________
!
   subroutine msDisplay_array_single( x1,                               &
                                      string1,                          &
                                      x2, string2, x3, string3, x4, string4 )

      real,             intent(in)           :: x1(:,:)
      character(len=*), intent(in), optional :: string1
      real,             intent(in), optional :: x2(:,:), x3(:,:), x4(:,:)
      character(len=*), intent(in), optional :: string2, string3, string4
      !------ API end ------

#ifdef _DEVLP
   !------ end of declarations -- execution starts hereafter  ------

      mf_display_line_head_or_tail = .false.

      if( present(string1) ) then
         call Implem_msDisplay_mfArray_double( mf(x1), string1 )
      else
         call Implem_msDisplay_mfArray_double( mf(x1), "ans" )
      end if

      if( present(x2) .and. present(string2) ) then
         call Implem_msDisplay_mfArray_double( mf(x2), string2 )
      end if

      if( present(x3) .and. present(string3) ) then
         call Implem_msDisplay_mfArray_double( mf(x3), string3 )
      end if

      if( present(x4) .and. present(string4) ) then
         call Implem_msDisplay_mfArray_double( mf(x4), string4 )
      end if

#endif
   end subroutine msDisplay_array_single
!_______________________________________________________________________
!
   subroutine msDisplay_double( x1,                                     &
                                string1,                                &
                                x2, string2, x3, string3, x4, string4 )

      real(kind=MF_DOUBLE), intent(in)           :: x1
      character(len=*),     intent(in), optional :: string1
      real(kind=MF_DOUBLE), intent(in), optional :: x2, x3, x4
      character(len=*),     intent(in), optional :: string2, string3, string4
      !------ API end ------

#ifdef _DEVLP
   !------ end of declarations -- execution starts hereafter  ------

      mf_display_line_head_or_tail = .false.

      if( present(string1) ) then
         call Implem_msDisplay_mfArray_double( mf(x1), string1 )
      else
         call Implem_msDisplay_mfArray_double( mf(x1), "ans" )
      end if

      if( present(x2) .and. present(string2) ) then
         call Implem_msDisplay_mfArray_double( mf(x2), string2 )
      end if

      if( present(x3) .and. present(string3) ) then
         call Implem_msDisplay_mfArray_double( mf(x3), string3 )
      end if

      if( present(x4) .and. present(string4) ) then
         call Implem_msDisplay_mfArray_double( mf(x4), string4 )
      end if

#endif
   end subroutine msDisplay_double
!_______________________________________________________________________
!
   subroutine msDisplay_vec_double( x1,                                 &
                                    string1,                            &
                                    x2, string2, x3, string3, x4, string4 )

      real(kind=MF_DOUBLE), intent(in)           :: x1(:)
      character(len=*),     intent(in), optional :: string1
      real(kind=MF_DOUBLE), intent(in), optional :: x2(:), x3(:), x4(:)
      character(len=*),     intent(in), optional :: string2, string3, string4
      !------ API end ------

#ifdef _DEVLP
   !------ end of declarations -- execution starts hereafter  ------

      mf_display_line_head_or_tail = .false.

      if( present(string1) ) then
         call Implem_msDisplay_mfArray_double( mf(x1), string1 )
      else
         call Implem_msDisplay_mfArray_double( mf(x1), "ans" )
      end if

      if( present(x2) .and. present(string2) ) then
         call Implem_msDisplay_mfArray_double( mf(x2), string2 )
      end if

      if( present(x3) .and. present(string3) ) then
         call Implem_msDisplay_mfArray_double( mf(x3), string3 )
      end if

      if( present(x4) .and. present(string4) ) then
         call Implem_msDisplay_mfArray_double( mf(x4), string4 )
      end if

#endif
   end subroutine msDisplay_vec_double
!_______________________________________________________________________
!
   subroutine msDisplay_array_double( x1,                               &
                                      string1,                          &
                                      x2, string2, x3, string3, x4, string4 )

      real(kind=MF_DOUBLE), intent(in)           :: x1(:,:)
      character(len=*),     intent(in), optional :: string1
      real(kind=MF_DOUBLE), intent(in), optional :: x2(:,:), x3(:,:), x4(:,:)
      character(len=*),     intent(in), optional :: string2, string3, string4
      !------ API end ------

#ifdef _DEVLP
   !------ end of declarations -- execution starts hereafter  ------

      mf_display_line_head_or_tail = .false.

      if( present(string1) ) then
         call Implem_msDisplay_mfArray_double( mf(x1), string1 )
      else
         call Implem_msDisplay_mfArray_double( mf(x1), "ans" )
      end if

      if( present(x2) .and. present(string2) ) then
         call Implem_msDisplay_mfArray_double( mf(x2), string2 )
      end if

      if( present(x3) .and. present(string3) ) then
         call Implem_msDisplay_mfArray_double( mf(x3), string3 )
      end if

      if( present(x4) .and. present(string4) ) then
         call Implem_msDisplay_mfArray_double( mf(x4), string4 )
      end if

#endif
   end subroutine msDisplay_array_double
!_______________________________________________________________________
!
   subroutine msDisplay_cmplx( x1,                                      &
                               string1,                                 &
                               x2, string2, x3, string3, x4, string4 )

      complex,          intent(in)           :: x1
      character(len=*), intent(in), optional :: string1
      complex,          intent(in), optional :: x2, x3, x4
      character(len=*), intent(in), optional :: string2, string3, string4
      !------ API end ------

#ifdef _DEVLP
   !------ end of declarations -- execution starts hereafter  ------

      mf_display_line_head_or_tail = .false.

      if( present(string1) ) then
         call Implem_msDisplay_mfArray_cmplx( mf(x1), string1 )
      else
         call Implem_msDisplay_mfArray_cmplx( mf(x1), "ans" )
      end if

      if( present(x2) .and. present(string2) ) then
         call Implem_msDisplay_mfArray_cmplx( mf(x2), string2 )
      end if

      if( present(x3) .and. present(string3) ) then
         call Implem_msDisplay_mfArray_cmplx( mf(x3), string3 )
      end if

      if( present(x4) .and. present(string4) ) then
         call Implem_msDisplay_mfArray_cmplx( mf(x4), string4 )
      end if

#endif
   end subroutine msDisplay_cmplx
!_______________________________________________________________________
!
   subroutine msDisplay_vec_cmplx( x1,                                  &
                                   string1,                             &
                                   x2, string2, x3, string3, x4, string4 )

      complex,          intent(in)           :: x1(:)
      character(len=*), intent(in), optional :: string1
      complex,          intent(in), optional :: x2(:), x3(:), x4(:)
      character(len=*), intent(in), optional :: string2, string3, string4
      !------ API end ------

#ifdef _DEVLP
   !------ end of declarations -- execution starts hereafter  ------

      mf_display_line_head_or_tail = .false.

      if( present(string1) ) then
         call Implem_msDisplay_mfArray_cmplx( mf(x1), string1 )
      else
         call Implem_msDisplay_mfArray_cmplx( mf(x1), "ans" )
      end if

      if( present(x2) .and. present(string2) ) then
         call Implem_msDisplay_mfArray_cmplx( mf(x2), string2 )
      end if

      if( present(x3) .and. present(string3) ) then
         call Implem_msDisplay_mfArray_cmplx( mf(x3), string3 )
      end if

      if( present(x4) .and. present(string4) ) then
         call Implem_msDisplay_mfArray_cmplx( mf(x4), string4 )
      end if

#endif
   end subroutine msDisplay_vec_cmplx
!_______________________________________________________________________
!
   subroutine msDisplay_array_cmplx( x1,                                &
                                     string1,                           &
                                     x2, string2, x3, string3, x4, string4 )

      complex,          intent(in)           :: x1(:,:)
      character(len=*), intent(in), optional :: string1
      complex,          intent(in), optional :: x2(:,:), x3(:,:), x4(:,:)
      character(len=*), intent(in), optional :: string2, string3, string4
      !------ API end ------

#ifdef _DEVLP
   !------ end of declarations -- execution starts hereafter  ------

      mf_display_line_head_or_tail = .false.

      if( present(string1) ) then
         call Implem_msDisplay_mfArray_cmplx( mf(x1), string1 )
      else
         call Implem_msDisplay_mfArray_cmplx( mf(x1), "ans" )
      end if

      if( present(x2) .and. present(string2) ) then
         call Implem_msDisplay_mfArray_cmplx( mf(x2), string2 )
      end if

      if( present(x3) .and. present(string3) ) then
         call Implem_msDisplay_mfArray_cmplx( mf(x3), string3 )
      end if

      if( present(x4) .and. present(string4) ) then
         call Implem_msDisplay_mfArray_cmplx( mf(x4), string4 )
      end if

#endif
   end subroutine msDisplay_array_cmplx
!_______________________________________________________________________
!
   subroutine msDisplay_double_cmplx( x1,                               &
                                      string1,                          &
                                      x2, string2, x3, string3, x4, string4 )

      complex(kind=MF_DOUBLE), intent(in)           :: x1
      character(len=*),        intent(in), optional :: string1
      complex(kind=MF_DOUBLE), intent(in), optional :: x2, x3, x4
      character(len=*),        intent(in), optional :: string2, string3, string4
      !------ API end ------

#ifdef _DEVLP
   !------ end of declarations -- execution starts hereafter  ------

      mf_display_line_head_or_tail = .false.

      if( present(string1) ) then
         call Implem_msDisplay_mfArray_cmplx( mf(x1), string1 )
      else
         call Implem_msDisplay_mfArray_cmplx( mf(x1), "ans" )
      end if

      if( present(x2) .and. present(string2) ) then
         call Implem_msDisplay_mfArray_cmplx( mf(x2), string2 )
      end if

      if( present(x3) .and. present(string3) ) then
         call Implem_msDisplay_mfArray_cmplx( mf(x3), string3 )
      end if

      if( present(x4) .and. present(string4) ) then
         call Implem_msDisplay_mfArray_cmplx( mf(x4), string4 )
      end if

#endif
   end subroutine msDisplay_double_cmplx
!_______________________________________________________________________
!
   subroutine msDisplay_vec_double_cmplx( x1,                           &
                                          string1,                      &
                                          x2, string2, x3, string3, x4, string4 )

      complex(kind=MF_DOUBLE), intent(in)           :: x1(:)
      character(len=*),        intent(in), optional :: string1
      complex(kind=MF_DOUBLE), intent(in), optional :: x2(:), x3(:), x4(:)
      character(len=*),        intent(in), optional :: string2, string3, string4
      !------ API end ------

#ifdef _DEVLP
   !------ end of declarations -- execution starts hereafter  ------

      mf_display_line_head_or_tail = .false.

      if( present(string1) ) then
         call Implem_msDisplay_mfArray_cmplx( mf(x1), string1 )
      else
         call Implem_msDisplay_mfArray_cmplx( mf(x1), "ans" )
      end if

      if( present(x2) .and. present(string2) ) then
         call Implem_msDisplay_mfArray_cmplx( mf(x2), string2 )
      end if

      if( present(x3) .and. present(string3) ) then
         call Implem_msDisplay_mfArray_cmplx( mf(x3), string3 )
      end if

      if( present(x4) .and. present(string4) ) then
         call Implem_msDisplay_mfArray_cmplx( mf(x4), string4 )
      end if

#endif
   end subroutine msDisplay_vec_double_cmplx
!_______________________________________________________________________
!
   subroutine msDisplay_array_double_cmplx( x1,                         &
                                            string1,                    &
                                            x2, string2, x3, string3, x4, string4 )

      complex(kind=MF_DOUBLE), intent(in)           :: x1(:,:)
      character(len=*),        intent(in), optional :: string1
      complex(kind=MF_DOUBLE), intent(in), optional :: x2(:,:), x3(:,:), x4(:,:)
      character(len=*),        intent(in), optional :: string2, string3, string4
      !------ API end ------

#ifdef _DEVLP
   !------ end of declarations -- execution starts hereafter  ------

      mf_display_line_head_or_tail = .false.

      if( present(string1) ) then
         call Implem_msDisplay_mfArray_cmplx( mf(x1), string1 )
      else
         call Implem_msDisplay_mfArray_cmplx( mf(x1), "ans" )
      end if

      if( present(x2) .and. present(string2) ) then
         call Implem_msDisplay_mfArray_cmplx( mf(x2), string2 )
      end if

      if( present(x3) .and. present(string3) ) then
         call Implem_msDisplay_mfArray_cmplx( mf(x3), string3 )
      end if

      if( present(x4) .and. present(string4) ) then
         call Implem_msDisplay_mfArray_cmplx( mf(x4), string4 )
      end if

#endif
   end subroutine msDisplay_array_double_cmplx
!_______________________________________________________________________
!
   subroutine msDisplay_mfArray( x1,                                    &
                                 string1,                               &
                                 x2, string2, x3, string3, x4, string4, &
                                 unit, head, tail )

      type(mfArray)                          :: x1
      character(len=*), intent(in), optional :: string1
      type(mfArray),                optional :: x2, x3, x4
      character(len=*), intent(in), optional :: string2, string3, string4
      type(mfUnit),     intent(in), optional :: unit
      integer,          intent(in), optional :: head, tail
      !------ API end ------

#ifdef _DEVLP
      type(mfArray) :: tmp
      integer :: m, n
      character(len=120) :: string

      ! We are using global variables; else, we should have been used
      ! hundred of lines for handling all cases with three optional
      ! arguments.
      !
      ! The two module variables:
      !         mf_display_line_head, mf_display_line_head
      ! are used in the 'i' loop for printing mfArrays.
      !
      ! A restricted print is used only if the width of the array
      ! is smaller than the terminal width
      ! (i.e. for arrays with small nbr of columns)

   !------ end of declarations -- execution starts hereafter  ------

      mf_display_line_head_or_tail = .false.

      if( present(head) .and. present(tail) ) then
         mf_display_line_head_or_tail = .true.
         mf_display_head_length = head
         mf_display_tail_length = tail
      else if( present(head) ) then
         mf_display_line_head_or_tail = .true.
         mf_display_head_length = head
         mf_display_tail_length = 0
      else if( present(tail) ) then
         mf_display_line_head_or_tail = .true.
         mf_display_head_length = 0
         mf_display_tail_length = tail
      end if

      m = x1%shape(1)
      n = x1%shape(2)
      if( present(head) .and. present(tail) ) then
         call check_head_tail( "1" )
      else if( present(head) ) then
         call check_head( "1" )
      else if( present(tail) ) then
         call check_tail( "1" )
      end if

      if( present(string1) ) then
         string = string1
      else
         string = "ans"
      end if

      select case( x1%data_type )
         case( MF_DT_EMPTY ) ! empty
            call Implem_msDisplay_mfArray_null( x1, string )
         case( MF_DT_BOOL ) ! bool
            if( present(unit) ) then
               call PrintMessage( "msDisplay", "I",                     &
                                  "for boolean array, arg. 'unit' is ignored." )
            end if
            call Implem_msDisplay_mfArray_bool( x1, string )
         case( MF_DT_DBLE ) ! double
            if( present(unit) ) then
               call Implem_msDisplay_mfArray_double( x1, string, unit )
            else
               call Implem_msDisplay_mfArray_double( x1, string )
            end if
         case( MF_DT_CMPLX ) ! cmplx
            if( present(unit) ) then
               call Implem_msDisplay_mfArray_cmplx( x1, string, unit )
            else
               call Implem_msDisplay_mfArray_cmplx( x1, string )
            end if
         case( MF_DT_SP_BOOL ) ! sparse bool
            if( present(unit) ) then
               call PrintMessage( "msDisplay", "I",                     &
                                  "for boolean array, arg. 'unit' is ignored." )
            end if
            call Implem_msDisp_mf_sparse_bool( x1, string )
         case( MF_DT_SP_DBLE ) ! sparse double
            if( present(unit) ) then
               call Implem_msDisp_mf_sparse_double( x1, string, unit )
            else
               call Implem_msDisp_mf_sparse_double( x1, string )
            end if
         case( MF_DT_SP_CMPLX ) ! sparse complex
            if( present(unit) ) then
               call Implem_msDisp_mf_sparse_cmplx( x1, string, unit )
            else
               call Implem_msDisp_mf_sparse_cmplx( x1, string )
            end if
         case( MF_DT_PERM_VEC ) ! permutation vector
            tmp%data_type = MF_DT_DBLE
            tmp%shape = x1%shape
            allocate( tmp%double(tmp%shape(1),tmp%shape(2)) )

            tmp%double(:,1) = x1%i(:)
            tmp%status_temporary = .true.
            call Implem_msDisplay_mfArray_double( tmp, string )
         case default ! bad data type
            write(STDERR,*) "(MUESLI msDisplay:) internal error:"
            write(STDERR,*) "                    bad data type"
            mf_message_displayed = .true.
            call muesli_trace( pause ="yes" )
            stop
      end select

      if( present(x2) .and. present(string2) ) then
         m = x2%shape(1)
         n = x2%shape(1)
         if( present(head) .and. present(tail) ) then
            call check_head_tail( "2" )
         else if( present(head) ) then
            call check_head( "2" )
         else if( present(tail) ) then
            call check_tail( "2" )
         end if
         select case( x2%data_type )
            case( MF_DT_EMPTY ) ! empty
               call Implem_msDisplay_mfArray_null( x2, string2 )
            case( MF_DT_BOOL ) ! bool
               if( present(unit) ) then
                  call PrintMessage( "msDisplay", "I",                     &
                                    "for boolean array, arg. 'unit' is ignored." )
               end if
               call Implem_msDisplay_mfArray_bool( x2, string2 )
            case( MF_DT_DBLE ) ! double
               if( present(unit) ) then
                  call Implem_msDisplay_mfArray_double( x2, string2, unit )
               else
                  call Implem_msDisplay_mfArray_double( x2, string2 )
               end if
            case( MF_DT_CMPLX ) ! cmplx
               if( present(unit) ) then
                  call Implem_msDisplay_mfArray_cmplx( x2, string2, unit )
               else
                  call Implem_msDisplay_mfArray_cmplx( x2, string2 )
               end if
            case( MF_DT_SP_BOOL ) ! sparse bool
               if( present(unit) ) then
                  call PrintMessage( "msDisplay", "I",                     &
                                     "for boolean array, arg. 'unit' is ignored." )
               end if
               call Implem_msDisp_mf_sparse_bool( x2, string2 )
            case( MF_DT_SP_DBLE ) ! sparse double
               if( present(unit) ) then
                  call Implem_msDisp_mf_sparse_double( x2, string2, unit )
               else
                  call Implem_msDisp_mf_sparse_double( x2, string2 )
               end if
            case( MF_DT_SP_CMPLX ) ! sparse complex
               if( present(unit) ) then
                  call Implem_msDisp_mf_sparse_cmplx( x2, string2, unit )
               else
                  call Implem_msDisp_mf_sparse_cmplx( x2, string2 )
               end if
            case( MF_DT_PERM_VEC ) ! permutation vector
               tmp%data_type = MF_DT_DBLE
               tmp%shape = x2%shape
               allocate( tmp%double(tmp%shape(1),tmp%shape(2)) )

               tmp%double(:,1) = x2%i(:)
               tmp%status_temporary = .true.
               call Implem_msDisplay_mfArray_double( tmp, string2 )
            case default ! bad data type
               write(STDERR,*) "(MUESLI msDisplay:) internal error:"
               write(STDERR,*) "                    bad data type"
               mf_message_displayed = .true.
               call muesli_trace( pause ="yes" )
               stop
         end select
      end if

      if( present(x3) .and. present(string3) ) then
         m = x2%shape(1)
         n = x2%shape(1)
         if( present(head) .and. present(tail) ) then
            call check_head_tail( "3" )
         else if( present(head) ) then
            call check_head( "3" )
         else if( present(tail) ) then
            call check_tail( "3" )
         end if
         select case( x3%data_type )
            case( MF_DT_EMPTY ) ! empty
               call Implem_msDisplay_mfArray_null( x3, string3 )
            case( MF_DT_BOOL ) ! bool
               if( present(unit) ) then
                  call PrintMessage( "msDisplay", "I",                     &
                                    "for boolean array, arg. 'unit' is ignored." )
               end if
               call Implem_msDisplay_mfArray_bool( x3, string3 )
            case( MF_DT_DBLE ) ! double
               if( present(unit) ) then
                  call Implem_msDisplay_mfArray_double( x3, string3, unit )
               else
                  call Implem_msDisplay_mfArray_double( x3, string3 )
               end if
            case( MF_DT_CMPLX ) ! cmplx
               if( present(unit) ) then
                  call Implem_msDisplay_mfArray_cmplx( x3, string3, unit )
               else
                  call Implem_msDisplay_mfArray_cmplx( x3, string3 )
               end if
            case( MF_DT_SP_BOOL ) ! sparse bool
               if( present(unit) ) then
                  call PrintMessage( "msDisplay", "I",                     &
                                     "for boolean array, arg. 'unit' is ignored." )
               end if
               call Implem_msDisp_mf_sparse_bool( x3, string3 )
            case( MF_DT_SP_DBLE ) ! sparse double
               if( present(unit) ) then
                  call Implem_msDisp_mf_sparse_double( x3, string3, unit )
               else
                  call Implem_msDisp_mf_sparse_double( x3, string3 )
               end if
            case( MF_DT_SP_CMPLX ) ! sparse complex
               if( present(unit) ) then
                  call Implem_msDisp_mf_sparse_cmplx( x3, string3, unit )
               else
                  call Implem_msDisp_mf_sparse_cmplx( x3, string3 )
               end if
            case( MF_DT_PERM_VEC ) ! permutation vector
               tmp%data_type = MF_DT_DBLE
               tmp%shape = x3%shape
               allocate( tmp%double(tmp%shape(1),tmp%shape(2)) )

               tmp%double(:,1) = x3%i(:)
               tmp%status_temporary = .true.
               call Implem_msDisplay_mfArray_double( tmp, string3 )
            case default ! bad data type
               write(STDERR,*) "(MUESLI msDisplay:) internal error:"
               write(STDERR,*) "                    bad data type"
               mf_message_displayed = .true.
               call muesli_trace( pause ="yes" )
               stop
         end select
      end if

      if( present(x4) .and. present(string4) ) then
         m = x2%shape(1)
         n = x2%shape(1)
         if( present(head) .and. present(tail) ) then
            call check_head_tail( "4" )
         else if( present(head) ) then
            call check_head( "4" )
         else if( present(tail) ) then
            call check_tail( "4" )
         end if
         select case( x4%data_type )
            case( MF_DT_EMPTY ) ! empty
               call Implem_msDisplay_mfArray_null( x4, string4 )
            case( MF_DT_BOOL ) ! bool
               if( present(unit) ) then
                  call PrintMessage( "msDisplay", "I",                     &
                                    "for boolean array, arg. 'unit' is ignored." )
               end if
               call Implem_msDisplay_mfArray_bool( x4, string4 )
            case( MF_DT_DBLE ) ! double
               if( present(unit) ) then
                  call Implem_msDisplay_mfArray_double( x4, string4, unit )
               else
                  call Implem_msDisplay_mfArray_double( x4, string4 )
               end if
            case( MF_DT_CMPLX ) ! cmplx
               if( present(unit) ) then
                  call Implem_msDisplay_mfArray_cmplx( x4, string4, unit )
               else
                  call Implem_msDisplay_mfArray_cmplx( x4, string4 )
               end if
            case( MF_DT_SP_BOOL ) ! sparse bool
               if( present(unit) ) then
                  call PrintMessage( "msDisplay", "I",                     &
                                     "for boolean array, arg. 'unit' is ignored." )
               end if
               call Implem_msDisp_mf_sparse_bool( x4, string4 )
            case( MF_DT_SP_DBLE ) ! sparse double
               if( present(unit) ) then
                  call Implem_msDisp_mf_sparse_double( x4, string4, unit )
               else
                  call Implem_msDisp_mf_sparse_double( x4, string4 )
               end if
            case( MF_DT_SP_CMPLX ) ! sparse complex
               if( present(unit) ) then
                  call Implem_msDisp_mf_sparse_cmplx( x4, string4, unit )
               else
                  call Implem_msDisp_mf_sparse_cmplx( x4, string4 )
               end if
            case( MF_DT_PERM_VEC ) ! permutation vector
               tmp%data_type = MF_DT_DBLE
               tmp%shape = x4%shape
               allocate( tmp%double(tmp%shape(1),tmp%shape(2)) )

               tmp%double(:,1) = x4%i(:)
               tmp%status_temporary = .true.
               call Implem_msDisplay_mfArray_double( tmp, string4 )
            case default ! bad data type
               write(STDERR,*) "(MUESLI msDisplay:) internal error:"
               write(STDERR,*) "                    bad data type"
               mf_message_displayed = .true.
               call muesli_trace( pause ="yes" )
               stop
         end select
      end if

   contains

      subroutine check_head_tail( item )
         character, intent(in) :: item
         if( m == 1 ) then ! row vector
            if( head + 1 + tail > n ) then
               call PrintMessage( "msDisplay", "W",                     &
                                  "'head' and 'tail' are too large for arg #" // item // "!" )
               mf_display_line_head_or_tail = .false.
            end if
         else
            if( head + 1 + tail > m ) then
               call PrintMessage( "msDisplay", "W",                     &
                                  "'head' and 'tail' are too large for arg #" // item // "!" )
               mf_display_line_head_or_tail = .false.
            end if
         end if
      end subroutine check_head_tail

      subroutine check_head( item )
         character, intent(in) :: item
         if( m == 1 ) then ! row vector
            if( head + 1 > n ) then
               call PrintMessage( "msDisplay", "W",                     &
                                  "'head' is too large for arg #" // item // "!" )
               mf_display_line_head_or_tail = .false.
            end if
         else
            if( head + 1 > m ) then
               call PrintMessage( "msDisplay", "W",                     &
                                  "'head' is too large for arg #" // item // "!" )
               mf_display_line_head_or_tail = .false.
            end if
         end if
      end subroutine check_head

      subroutine check_tail( item )
         character, intent(in) :: item
         if( m == 1 ) then ! row vector
            if( 1 + tail > n ) then
               call PrintMessage( "msDisplay", "W",                     &
                                  "'tail' is too large for arg #" // item // "!" )
               mf_display_line_head_or_tail = .false.
            end if
         else
            if( 1 + tail > m ) then
               call PrintMessage( "msDisplay", "W",                     &
                                  "'tail' is too large for arg #" // item // "!" )
               mf_display_line_head_or_tail = .false.
            end if
         end if
      end subroutine check_tail

#endif
   end subroutine msDisplay_mfArray
!_______________________________________________________________________
!
   subroutine Implem_msDisplay_mfArray_null( x, string )

      type(mfArray)                :: x
      character(len=*), intent(in) :: string
      !------ API end ------

#ifdef _DEVLP
      ! implements the display of special mfArray (not numeric).

   !------ end of declarations -- execution starts hereafter  ------

      write(STDOUT,"()")
      write(STDOUT,*) trim(string), " ="
      write(STDOUT,"()")

      if( all( x%shape == 0 ) ) then
         write(STDOUT,*) " <EMPTY>"
         write(STDOUT,"()")
         return
      end if

      if( all( x%shape == -1 ) ) then ! MF_COLON or MF_ALL
         write(STDOUT,*) " <:> (colon selection)"
         write(STDOUT,"()")
         call PrintMessage( "msDisplay", "W",                           &
                            "Above, MF_COLON (or its alias MF_ALL) is the", &
                            "'colon selection': it makes no sense to display it!" )
         return
      end if

      ! case of an EndIndex (MF_END or integer expression of MF_END)
      if( all( x%shape == -2 ) ) then
         write(STDOUT,*) " (end-index)"
         write(STDOUT,"()")
         call PrintMessage( "msDisplay", "W",                           &
                            "Above, the mfArray is an end-index:" ,     &
                            "it makes no sense to display it!" )
         return
      end if

      if( all( x%shape == -3 ) ) then ! MF_NO_ARG
         write(STDOUT,*) " (no-arg)"
         write(STDOUT,"()")
         call PrintMessage( "msDisplay", "W",                           &
                            "Above, the mfArray is the no-arg keyword:" , &
                            "it makes no sense to display it!" )
         return
      end if

#endif
   end subroutine Implem_msDisplay_mfArray_null

